/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.cap4.template.bo;

import com.seeyon.cap4.template.bo.AbstractBaseBO;
import com.seeyon.cap4.template.po.CAPBusinessConfig;
import com.seeyon.ctp.common.AppContext;
import com.seeyon.ctp.common.exceptions.BusinessException;
import com.seeyon.ctp.organization.manager.OrgManager;
import com.seeyon.ctp.util.DateUtil;
import com.seeyon.ctp.util.Strings;
import com.seeyon.ctp.util.json.JSONUtil;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CAPBusinessConfigBO
extends AbstractBaseBO<CAPBusinessConfig> {
    private String id;
    private String pathId;
    private String createDate;
    private String modifyDate;
    private String createMemberId;
    private String createMemberName;
    private String modifyMemberId;
    private String modifyMemberName;
    private Map<String, Object> dataInfo;
    public static final String ID = "id";
    public static final String PATH_ID = "pathId";
    public static final String CREATE_DATE = "createDate";
    public static final String MODIFY_DATE = "modifyDate";
    public static final String CREATE_MEMBER_ID = "createMemberId";
    public static final String CREATE_MEMBER_NAME = "createMemberName";
    public static final String MODIFY_MEMBER_ID = "modifyMemberId";
    public static final String MODIFY_MEMBER_NAME = "modifyMemberName";
    public static final String DATA_INFO = "dataInfo";
    public static final String CONFIGED_FIELDS = "configedFields";

    @Override
    public void importFromJSon(Map<String, Object> jsonObject) {
        this.id = (String)jsonObject.get(ID);
        this.pathId = (String)jsonObject.get(PATH_ID);
        this.createDate = (String)jsonObject.get(CREATE_DATE);
        this.modifyDate = (String)jsonObject.get(MODIFY_DATE);
        this.createMemberId = (String)jsonObject.get(CREATE_MEMBER_ID);
        this.createMemberName = (String)jsonObject.get(CREATE_MEMBER_NAME);
        this.modifyMemberId = (String)jsonObject.get(MODIFY_MEMBER_ID);
        this.modifyMemberName = (String)jsonObject.get(MODIFY_MEMBER_NAME);
        this.dataInfo = (Map)jsonObject.get(DATA_INFO);
    }

    @Override
    public void importFromPO(CAPBusinessConfig capBusinessConfig) throws BusinessException {
        this.id = String.valueOf(capBusinessConfig.getId());
        this.pathId = String.valueOf(capBusinessConfig.getPathId());
        this.createDate = String.valueOf(capBusinessConfig.getCreateDate());
        this.modifyDate = String.valueOf(capBusinessConfig.getModifyDate());
        this.createMemberId = String.valueOf(capBusinessConfig.getCreateMember());
        OrgManager orgManager = (OrgManager)AppContext.getBean((String)"orgManager");
        this.createMemberName = orgManager.getMemberById(capBusinessConfig.getCreateMember()).getName();
        this.modifyMemberId = String.valueOf(capBusinessConfig.getModifyMember());
        this.modifyMemberName = orgManager.getMemberById(capBusinessConfig.getModifyMember()).getName();
        this.dataInfo = (Map)JSONUtil.parseJSONString((String)capBusinessConfig.getDataInfo(), Map.class);
    }

    public CAPBusinessConfig exportToPO() throws ParseException {
        CAPBusinessConfig capBusinessConfig = new CAPBusinessConfig();
        capBusinessConfig.setId(Long.valueOf(this.id));
        capBusinessConfig.setPathId(Long.valueOf(this.pathId));
        capBusinessConfig.setCreateDate(DateUtil.parseTimestamp((String)this.createDate));
        capBusinessConfig.setCreateMember(Strings.isBlank((String)this.createMemberId) ? null : Long.valueOf(this.createMemberId));
        capBusinessConfig.setModifyDate(DateUtil.parseTimestamp((String)this.modifyDate));
        capBusinessConfig.setModifyMember(Strings.isBlank((String)this.modifyMemberId) ? null : Long.valueOf(this.modifyMemberId));
        capBusinessConfig.setDataInfo(this.dataInfo == null ? "" : JSONUtil.toJSONString(this.dataInfo));
        return capBusinessConfig;
    }

    @Override
    public Map<String, Object> exportToJSon() {
        HashMap<String, Object> obj = new HashMap<String, Object>();
        obj.put(ID, this.id);
        obj.put(PATH_ID, this.pathId);
        obj.put(CREATE_DATE, this.createDate);
        obj.put(MODIFY_DATE, this.modifyDate);
        obj.put(CREATE_MEMBER_ID, this.createMemberId);
        obj.put(CREATE_MEMBER_NAME, this.createMemberName);
        obj.put(MODIFY_MEMBER_ID, this.modifyMemberId);
        obj.put(MODIFY_MEMBER_NAME, this.createMemberName);
        obj.put(DATA_INFO, this.dataInfo);
        return obj;
    }

    public List getConfigedFields() {
        List list = null;
        if (this.dataInfo != null) {
            list = (List)this.dataInfo.get(CONFIGED_FIELDS);
        }
        return list == null ? new ArrayList() : list;
    }

    @Override
    public void clear() {
        this.id = null;
        this.pathId = null;
        this.createDate = null;
        this.modifyDate = null;
        this.createMemberId = null;
        this.createMemberName = null;
        this.modifyMemberId = null;
        this.modifyMemberName = null;
        this.dataInfo = null;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getPathId() {
        return this.pathId;
    }

    public void setPathId(String pathId) {
        this.pathId = pathId;
    }

    public String getCreateDate() {
        return this.createDate;
    }

    public void setCreateDate(String createDate) {
        this.createDate = createDate;
    }

    public String getModifyDate() {
        return this.modifyDate;
    }

    public void setModifyDate(String modifyDate) {
        this.modifyDate = modifyDate;
    }

    public String getCreateMemberId() {
        return this.createMemberId;
    }

    public void setCreateMemberId(String createMemberId) {
        this.createMemberId = createMemberId;
    }

    public String getCreateMemberName() {
        return this.createMemberName;
    }

    public void setCreateMemberName(String createMemberName) {
        this.createMemberName = createMemberName;
    }

    public String getModifyMemberId() {
        return this.modifyMemberId;
    }

    public void setModifyMemberId(String modifyMemberId) {
        this.modifyMemberId = modifyMemberId;
    }

    public String getModifyMemberName() {
        return this.modifyMemberName;
    }

    public void setModifyMemberName(String modifyMemberName) {
        this.modifyMemberName = modifyMemberName;
    }

    public Map<String, Object> getDataInfo() {
        return this.dataInfo;
    }

    public void setDataInfo(Map<String, Object> dataInfo) {
        this.dataInfo = dataInfo;
    }

    public String toString() {
        return JSONUtil.toJSONString(this.exportToJSon());
    }
}

