/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.cap4.template.bo;

import com.seeyon.cap4.template.bo.AbstractBaseBO;
import com.seeyon.cap4.template.constant.CAPBusinessEnum;
import com.seeyon.cap4.template.po.CAPBusinessElement;
import com.seeyon.ctp.common.AppContext;
import com.seeyon.ctp.common.exceptions.BusinessException;
import com.seeyon.ctp.organization.manager.OrgManager;
import com.seeyon.ctp.util.DateUtil;
import com.seeyon.ctp.util.json.JSONUtil;
import java.text.ParseException;
import java.util.HashMap;
import java.util.Map;

public class CAPBusinessElementBO
extends AbstractBaseBO<CAPBusinessElement>
implements Cloneable {
    private String id;
    private String name;
    private String createDate;
    private String modifyDate;
    private String createMemberId;
    private String createMemberName;
    private String modifyMemberId;
    private String modifyMemberName;
    private String columnId;
    private String elementType;
    private Map<String, Object> extendInfo;
    private Map<String, Object> dataInfo;
    private String sort;
    public static final String ID = "id";
    public static final String NAME = "name";
    public static final String CREATE_DATE = "createDate";
    public static final String MODIFY_DATE = "modifyDate";
    public static final String CREATE_MEMBER_ID = "createMemberId";
    public static final String CREATE_MEMBER_NAME = "createMemberName";
    public static final String MODIFY_MEMBER_ID = "modifyMemberId";
    public static final String MODIFY_MEMBER_NAME = "modifyMemberName";
    public static final String COLUMN_ID = "columnId";
    public static final String ELEMENT_TYPE = "elementType";
    public static final String EXTEND_INFO = "extendInfo";
    public static final String DATA_INFO = "dataInfo";
    public static final String ELEMENT_TYPE_NAME = "elementTypeName";
    public static final String ELEMENT_TYPE_ALIAS = "elementTypeAlias";
    public static final String IS_CONFIG = "isConfig";
    public static final String SORT = "sort";
    public static final String DATA_INFO_TIME = "dataInfoTime";
    public static final String DATA_INFO_TYPE = "dataInfoType";

    @Override
    public void importFromJSon(Map<String, Object> jsonObject) {
        this.id = (String)jsonObject.get(ID);
        this.name = (String)jsonObject.get(NAME);
        this.createDate = (String)jsonObject.get(CREATE_DATE);
        this.modifyDate = (String)jsonObject.get(MODIFY_DATE);
        this.createMemberId = (String)jsonObject.get(CREATE_MEMBER_ID);
        this.createMemberName = (String)jsonObject.get(CREATE_MEMBER_NAME);
        this.modifyMemberId = (String)jsonObject.get(MODIFY_MEMBER_ID);
        this.modifyMemberName = (String)jsonObject.get(MODIFY_MEMBER_NAME);
        this.columnId = (String)jsonObject.get(COLUMN_ID);
        this.elementType = (String)jsonObject.get(ELEMENT_TYPE);
        this.extendInfo = (Map)jsonObject.get(EXTEND_INFO);
        this.dataInfo = (Map)jsonObject.get(DATA_INFO);
        if (this.extendInfo != null) {
            this.sort = this.extendInfo.get(SORT) == null ? "0" : String.valueOf(this.extendInfo.get(SORT));
        }
    }

    @Override
    public void importFromPO(CAPBusinessElement capBusinessElement) throws BusinessException {
        this.id = String.valueOf(capBusinessElement.getId());
        this.name = capBusinessElement.getName();
        this.createDate = String.valueOf(capBusinessElement.getCreateDate());
        this.modifyDate = String.valueOf(capBusinessElement.getModifyDate());
        this.createMemberId = String.valueOf(capBusinessElement.getCreateMember());
        OrgManager orgManager = (OrgManager)AppContext.getBean((String)"orgManager");
        this.createMemberName = orgManager.getMemberById(capBusinessElement.getCreateMember()).getName();
        this.modifyMemberId = String.valueOf(capBusinessElement.getModifyMember());
        this.modifyMemberName = orgManager.getMemberById(capBusinessElement.getModifyMember()).getName();
        this.columnId = capBusinessElement.getColumnId() == null ? "" : String.valueOf(capBusinessElement.getColumnId());
        this.elementType = capBusinessElement.getElementType() == null ? "" : String.valueOf(capBusinessElement.getElementType());
        this.extendInfo = capBusinessElement.getExtendInfo() == null ? null : (Map)JSONUtil.parseJSONString((String)capBusinessElement.getExtendInfo(), Map.class);
        Map<String, Object> map = this.dataInfo = capBusinessElement.getDataInfo() == null ? null : (Map<String, Object>)JSONUtil.parseJSONString((String)capBusinessElement.getDataInfo(), Map.class);
        if (this.extendInfo != null) {
            this.sort = this.extendInfo.get(SORT) == null ? "0" : String.valueOf(this.extendInfo.get(SORT));
        }
    }

    public CAPBusinessElement exportToPO() throws ParseException {
        CAPBusinessElement capBusinessElement = new CAPBusinessElement();
        capBusinessElement.setModifyDate(DateUtil.parseTimestamp((String)this.modifyDate));
        capBusinessElement.setId(Long.valueOf(this.id));
        capBusinessElement.setName(this.name);
        capBusinessElement.setCreateDate(DateUtil.parseTimestamp((String)this.createDate));
        capBusinessElement.setCreateMember(Long.valueOf(this.createMemberId));
        capBusinessElement.setModifyMember(Long.valueOf(this.modifyMemberId));
        capBusinessElement.setColumnId(Long.valueOf(this.columnId));
        capBusinessElement.setElementType(Integer.valueOf(this.elementType));
        capBusinessElement.setExtendInfo(this.extendInfo == null ? null : JSONUtil.toJSONString(this.extendInfo));
        capBusinessElement.setDataInfo(this.dataInfo == null ? null : JSONUtil.toJSONString(this.dataInfo));
        return capBusinessElement;
    }

    public Map<String, Object> exportToMapForDesign() {
        HashMap<String, Object> jsonObject = new HashMap<String, Object>();
        jsonObject.put(ID, this.id);
        jsonObject.put(NAME, this.name);
        jsonObject.put(ELEMENT_TYPE, this.elementType);
        CAPBusinessEnum.ColumnType elementType = CAPBusinessEnum.ColumnType.getEnumByType(Integer.valueOf(this.elementType));
        if (elementType != null) {
            jsonObject.put(ELEMENT_TYPE_NAME, elementType.getName());
            jsonObject.put(ELEMENT_TYPE_ALIAS, elementType.getAlias());
        } else {
            jsonObject.put(ELEMENT_TYPE_NAME, "");
            jsonObject.put(ELEMENT_TYPE_ALIAS, "");
        }
        if (this.getDataInfo() == null) {
            jsonObject.put(IS_CONFIG, "0");
        } else {
            jsonObject.put(IS_CONFIG, "1");
        }
        jsonObject.put(DATA_INFO, this.getDataInfo());
        return jsonObject;
    }

    @Override
    public Map<String, Object> exportToJSon() {
        HashMap<String, Object> obj = new HashMap<String, Object>();
        obj.put(ID, this.id);
        obj.put(NAME, this.name);
        obj.put(CREATE_DATE, this.createDate);
        obj.put(MODIFY_DATE, this.modifyDate);
        obj.put(CREATE_MEMBER_ID, this.createMemberId);
        obj.put(CREATE_MEMBER_NAME, this.createMemberName);
        obj.put(MODIFY_MEMBER_ID, this.modifyMemberId);
        obj.put(MODIFY_MEMBER_NAME, this.createMemberName);
        obj.put(ELEMENT_TYPE, this.elementType);
        obj.put(EXTEND_INFO, this.extendInfo);
        obj.put(DATA_INFO, this.dataInfo);
        obj.put(COLUMN_ID, this.columnId);
        return obj;
    }

    @Override
    public void clear() {
        this.id = null;
        this.name = null;
        this.createDate = null;
        this.modifyDate = null;
        this.createMemberId = null;
        this.createMemberName = null;
        this.modifyMemberId = null;
        this.modifyMemberName = null;
        this.columnId = null;
        this.elementType = null;
        this.extendInfo = null;
        this.dataInfo = null;
    }

    public String toString() {
        return JSONUtil.toJSONString(this.exportToJSon());
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getCreateDate() {
        return this.createDate;
    }

    public void setCreateDate(String createDate) {
        this.createDate = createDate;
    }

    public String getModifyDate() {
        return this.modifyDate;
    }

    public void setModifyDate(String modifyDate) {
        this.modifyDate = modifyDate;
    }

    public String getCreateMemberId() {
        return this.createMemberId;
    }

    public void setCreateMemberId(String createMemberId) {
        this.createMemberId = createMemberId;
    }

    public String getCreateMemberName() {
        return this.createMemberName;
    }

    public void setCreateMemberName(String createMemberName) {
        this.createMemberName = createMemberName;
    }

    public String getModifyMemberId() {
        return this.modifyMemberId;
    }

    public void setModifyMemberId(String modifyMemberId) {
        this.modifyMemberId = modifyMemberId;
    }

    public String getModifyMemberName() {
        return this.modifyMemberName;
    }

    public void setModifyMemberName(String modifyMemberName) {
        this.modifyMemberName = modifyMemberName;
    }

    public String getColumnId() {
        return this.columnId;
    }

    public void setColumnId(String columnId) {
        this.columnId = columnId;
    }

    public String getElementType() {
        return this.elementType;
    }

    public void setElementType(String elementType) {
        this.elementType = elementType;
    }

    public Map<String, Object> getExtendInfo() {
        return this.extendInfo;
    }

    public void setExtendInfo(Map<String, Object> extendInfo) {
        this.extendInfo = extendInfo;
    }

    public Map<String, Object> getDataInfo() {
        return this.dataInfo;
    }

    public void setDataInfo(Map<String, Object> dataInfo) {
        this.dataInfo = dataInfo;
    }

    public String getSort() {
        return this.sort;
    }

    public void setSort(String sort) {
        this.sort = sort;
    }
}

