/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.cap4.template.bo;

import com.seeyon.cap4.template.bo.AbstractMallBO;
import com.seeyon.cap4.template.bo.CAPBusinessColumnBO;
import com.seeyon.cap4.template.bo.CAPBusinessOrgBO;
import com.seeyon.cap4.template.constant.CAPBusinessEnum;
import com.seeyon.cap4.template.po.CAPBusinessTemplate;
import com.seeyon.cap4.template.util.CAPParamUtil;
import com.seeyon.ctp.common.AppContext;
import com.seeyon.ctp.common.exceptions.BusinessException;
import com.seeyon.ctp.organization.manager.OrgManager;
import com.seeyon.ctp.util.DateUtil;
import com.seeyon.ctp.util.Strings;
import com.seeyon.ctp.util.json.JSONUtil;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CAPBusinessTemplateBO
extends AbstractMallBO<CAPBusinessTemplate>
implements Cloneable {
    private String name;
    private String createDate;
    private String modifyDate;
    private String createMemberId;
    private String createMemberName;
    private String modifyMemberId;
    private String modifyMemberName;
    private String templateType;
    private String sort;
    private String state;
    private String eggId;
    private String pathId;
    private String frameType;
    private List<CAPBusinessColumnBO> capBusinessColumnBOs;
    private List<CAPBusinessOrgBO> capBusinessOrgBOs;
    public static final String NAME = "name";
    public static final String CREATE_DATE = "createDate";
    public static final String MODIFY_DATE = "modifyDate";
    public static final String CREATE_MEMBER_ID = "createMemberId";
    public static final String CREATE_MEMBER_NAME = "createMemberName";
    public static final String MODIFY_MEMBER_ID = "modifyMemberId";
    public static final String MODIFY_MEMBER_NAME = "modifyMemberName";
    public static final String TEMPLATE_TYPE = "templateType";
    public static final String SORT = "sort";
    public static final String CLIENT = "client";
    public static final String STATE = "state";
    public static final String EGG_ID = "eggId";
    public static final String PATH_ID = "pathId";
    public static final String FRAME_TYPE = "frameType";
    public static final String CAP_BUSINESS_COLUMNBOS = "capBusinessColumnBOs";
    public static final String CAP_BUSINESS_ORGBOS = "capBusinessOrgBOs";
    public static final String TEMPLATE_TYPE_NAME = "templateTypeName";
    public static final String TEMPLATE_TYPE_ALIAS = "templateTypeAlias";

    public boolean isBizIndex() {
        return CAPBusinessEnum.TemplateType.TP_BIZ_INDEX.getType() == Integer.valueOf(this.templateType).intValue();
    }

    @Override
    public void importFromJSon(Map<String, Object> jsonObject) {
        List list;
        this.id = (String)jsonObject.get("id");
        this.name = (String)jsonObject.get(NAME);
        this.createDate = (String)jsonObject.get(CREATE_DATE);
        this.modifyDate = (String)jsonObject.get(MODIFY_DATE);
        this.createMemberId = (String)jsonObject.get(CREATE_MEMBER_ID);
        this.createMemberName = (String)jsonObject.get(CREATE_MEMBER_NAME);
        this.modifyMemberId = (String)jsonObject.get(MODIFY_MEMBER_ID);
        this.modifyMemberName = (String)jsonObject.get(MODIFY_MEMBER_NAME);
        this.templateType = (String)jsonObject.get(TEMPLATE_TYPE);
        this.client = (String)jsonObject.get(CLIENT);
        this.sort = (String)jsonObject.get(SORT);
        this.state = (String)jsonObject.get(STATE);
        this.goodId = (String)jsonObject.get("goodId");
        this.goodName = (String)jsonObject.get("goodName");
        this.eggId = (String)jsonObject.get(EGG_ID);
        this.pathId = (String)jsonObject.get(PATH_ID);
        this.frameType = String.valueOf(jsonObject.get(FRAME_TYPE) == null ? Integer.valueOf(CAPBusinessEnum.TemplateFrameType.NEED_FRAME.getType()) : jsonObject.get(FRAME_TYPE));
        if (jsonObject.get(CAP_BUSINESS_COLUMNBOS) != null) {
            list = CAPParamUtil.getParamsListByKey(jsonObject, (String)CAP_BUSINESS_COLUMNBOS);
            this.capBusinessColumnBOs = new ArrayList<CAPBusinessColumnBO>();
            for (Map map : list) {
                CAPBusinessColumnBO capBusinessColumnBO = new CAPBusinessColumnBO();
                capBusinessColumnBO.importFromJSon(map);
                this.capBusinessColumnBOs.add(capBusinessColumnBO);
            }
        }
        if (jsonObject.get(CAP_BUSINESS_ORGBOS) != null) {
            list = CAPParamUtil.getParamsListByKey(jsonObject, (String)CAP_BUSINESS_ORGBOS);
            this.capBusinessOrgBOs = new ArrayList<CAPBusinessOrgBO>();
            for (Map map : list) {
                CAPBusinessOrgBO capBusinessOrgBO = new CAPBusinessOrgBO();
                capBusinessOrgBO.importFromJSon(map);
                this.capBusinessOrgBOs.add(capBusinessOrgBO);
            }
        }
    }

    @Override
    public void importFromPO(CAPBusinessTemplate capBusinessTemplate) throws BusinessException {
        this.id = String.valueOf(capBusinessTemplate.getId());
        this.name = capBusinessTemplate.getName();
        this.createDate = String.valueOf(capBusinessTemplate.getCreateDate());
        this.modifyDate = String.valueOf(capBusinessTemplate.getModifyDate());
        this.createMemberId = String.valueOf(capBusinessTemplate.getCreateMember());
        OrgManager orgManager = (OrgManager)AppContext.getBean((String)"orgManager");
        this.createMemberName = orgManager.getMemberById(capBusinessTemplate.getCreateMember()).getName();
        this.modifyMemberId = String.valueOf(capBusinessTemplate.getModifyMember());
        this.modifyMemberName = orgManager.getMemberById(capBusinessTemplate.getModifyMember()).getName();
        this.templateType = capBusinessTemplate.getTemplateType() == null ? "" : String.valueOf(capBusinessTemplate.getTemplateType());
        this.client = capBusinessTemplate.getClient() == null ? "" : String.valueOf(capBusinessTemplate.getClient());
        this.sort = capBusinessTemplate.getSort() == null ? "" : String.valueOf(capBusinessTemplate.getSort());
        this.state = capBusinessTemplate.getState() == null ? "" : String.valueOf(capBusinessTemplate.getState());
        this.goodId = capBusinessTemplate.getGoodId() == null ? "" : String.valueOf(capBusinessTemplate.getGoodId());
        this.goodName = capBusinessTemplate.getGoodName() == null ? "" : String.valueOf(capBusinessTemplate.getGoodName());
        this.eggId = capBusinessTemplate.getEggId() == null ? "" : String.valueOf(capBusinessTemplate.getEggId());
        this.pathId = capBusinessTemplate.getPathId() == null ? "" : String.valueOf(capBusinessTemplate.getPathId());
        this.frameType = String.valueOf(capBusinessTemplate.getFrameType() == null ? CAPBusinessEnum.TemplateFrameType.NEED_FRAME.getType() : capBusinessTemplate.getFrameType().intValue());
    }

    public CAPBusinessTemplate exportToPO() throws ParseException {
        CAPBusinessTemplate capBusinessTemplate = new CAPBusinessTemplate();
        capBusinessTemplate.setModifyDate(DateUtil.parseTimestamp((String)this.modifyDate));
        capBusinessTemplate.setId(Long.valueOf(this.id));
        capBusinessTemplate.setName(this.name);
        capBusinessTemplate.setCreateDate(DateUtil.parseTimestamp((String)this.createDate));
        capBusinessTemplate.setCreateMember(Long.valueOf(this.createMemberId));
        capBusinessTemplate.setModifyMember(Long.valueOf(this.modifyMemberId));
        capBusinessTemplate.setTemplateType(Integer.valueOf(this.templateType));
        capBusinessTemplate.setSort(Strings.isBlank((String)this.sort) ? 0 : Integer.valueOf(this.sort));
        capBusinessTemplate.setClient(Integer.valueOf(this.client));
        capBusinessTemplate.setState(Integer.valueOf(this.state));
        capBusinessTemplate.setGoodId(Strings.isBlank((String)this.goodId) ? null : Long.valueOf(this.goodId));
        capBusinessTemplate.setGoodName(this.goodName);
        capBusinessTemplate.setEggId(Strings.isBlank((String)this.eggId) ? null : Long.valueOf(this.eggId));
        capBusinessTemplate.setPathId(Strings.isBlank((String)this.pathId) ? null : Long.valueOf(this.pathId));
        capBusinessTemplate.setFrameType(Strings.isBlank((String)this.frameType) ? null : Integer.valueOf(this.frameType));
        return capBusinessTemplate;
    }

    public Map<String, Object> exportToMapForDesign() {
        HashMap<String, Object> boObject = new HashMap<String, Object>();
        boObject.put("id", this.id);
        boObject.put(NAME, this.name);
        boObject.put("goodName", this.goodName);
        boObject.put("goodId", this.goodId);
        boObject.put(SORT, this.sort);
        boObject.put(CLIENT, this.client);
        boObject.put(TEMPLATE_TYPE, this.templateType);
        CAPBusinessEnum.TemplateType templateTypeEnum = CAPBusinessEnum.TemplateType.getEnumByType(Integer.valueOf(this.templateType));
        boObject.put(TEMPLATE_TYPE_NAME, templateTypeEnum == null ? "" : templateTypeEnum.getName());
        boObject.put(TEMPLATE_TYPE_ALIAS, templateTypeEnum == null ? "" : templateTypeEnum.getAlias());
        boObject.put(STATE, this.state);
        boObject.put(EGG_ID, this.eggId);
        boObject.put(FRAME_TYPE, this.frameType);
        boObject.put(CREATE_DATE, this.createDate);
        return boObject;
    }

    @Override
    public Map<String, Object> exportToJSon() {
        HashMap<String, Object> obj = new HashMap<String, Object>();
        obj.put("id", this.id);
        obj.put(NAME, this.name);
        obj.put(CREATE_DATE, this.createDate);
        obj.put(MODIFY_DATE, this.modifyDate);
        obj.put(CREATE_MEMBER_ID, this.createMemberId);
        obj.put(CREATE_MEMBER_NAME, this.createMemberName);
        obj.put(MODIFY_MEMBER_ID, this.modifyMemberId);
        obj.put(MODIFY_MEMBER_NAME, this.createMemberName);
        obj.put(TEMPLATE_TYPE, this.templateType);
        obj.put(CLIENT, this.client);
        obj.put(SORT, this.sort);
        obj.put(STATE, this.state);
        obj.put("goodId", this.goodId);
        obj.put("goodName", this.goodName);
        obj.put(EGG_ID, this.eggId);
        obj.put(PATH_ID, this.pathId);
        obj.put(FRAME_TYPE, this.frameType);
        ArrayList<Map<String, Object>> array1 = new ArrayList<Map<String, Object>>();
        obj.put(CAP_BUSINESS_COLUMNBOS, array1);
        if (this.capBusinessColumnBOs != null) {
            for (CAPBusinessColumnBO capBusinessColumnBO : this.capBusinessColumnBOs) {
                array1.add(capBusinessColumnBO.exportToJSon());
            }
        }
        ArrayList<Map<String, Object>> array2 = new ArrayList<Map<String, Object>>();
        obj.put(CAP_BUSINESS_ORGBOS, array2);
        if (this.capBusinessOrgBOs != null) {
            for (CAPBusinessOrgBO capBusinessOrgBO : this.capBusinessOrgBOs) {
                array2.add(capBusinessOrgBO.exportToJSon());
            }
        }
        return obj;
    }

    public String toString() {
        return JSONUtil.toJSONString(this.exportToJSon());
    }

    @Override
    public void clear() {
        this.id = null;
        this.name = null;
        this.createDate = null;
        this.modifyDate = null;
        this.createMemberId = null;
        this.createMemberName = null;
        this.modifyMemberId = null;
        this.modifyMemberName = null;
        this.templateType = null;
        this.client = null;
        this.sort = null;
        this.state = null;
        this.eggId = null;
        this.pathId = null;
        this.frameType = null;
        this.capBusinessColumnBOs = null;
        this.capBusinessOrgBOs = null;
        this.clearMallAttr();
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getCreateDate() {
        return this.createDate;
    }

    public void setCreateDate(String createDate) {
        this.createDate = createDate;
    }

    public String getModifyDate() {
        return this.modifyDate;
    }

    public void setModifyDate(String modifyDate) {
        this.modifyDate = modifyDate;
    }

    public String getCreateMemberId() {
        return this.createMemberId;
    }

    public void setCreateMemberId(String createMemberId) {
        this.createMemberId = createMemberId;
    }

    public String getCreateMemberName() {
        return this.createMemberName;
    }

    public void setCreateMemberName(String createMemberName) {
        this.createMemberName = createMemberName;
    }

    public String getModifyMemberId() {
        return this.modifyMemberId;
    }

    public void setModifyMemberId(String modifyMemberId) {
        this.modifyMemberId = modifyMemberId;
    }

    public String getModifyMemberName() {
        return this.modifyMemberName;
    }

    public void setModifyMemberName(String modifyMemberName) {
        this.modifyMemberName = modifyMemberName;
    }

    public String getTemplateType() {
        return this.templateType;
    }

    public void setTemplateType(String templateType) {
        this.templateType = templateType;
    }

    public String getSort() {
        return this.sort;
    }

    public void setSort(String sort) {
        this.sort = sort;
    }

    public String getState() {
        return this.state;
    }

    public void setState(String state) {
        this.state = state;
    }

    public String getEggId() {
        return this.eggId;
    }

    public void setEggId(String eggId) {
        this.eggId = eggId;
    }

    public String getPathId() {
        return this.pathId;
    }

    public void setPathId(String pathId) {
        this.pathId = pathId;
    }

    public String getFrameType() {
        return this.frameType;
    }

    public void setFrameType(String frameType) {
        this.frameType = frameType;
    }

    public List<CAPBusinessColumnBO> getCapBusinessColumnBOs() {
        return this.capBusinessColumnBOs;
    }

    public void setCapBusinessColumnBOs(List<CAPBusinessColumnBO> capBusinessColumnBOs) {
        this.capBusinessColumnBOs = capBusinessColumnBOs;
    }

    public List<CAPBusinessOrgBO> getCapBusinessOrgBOs() {
        return this.capBusinessOrgBOs;
    }

    public void setCapBusinessOrgBOs(List<CAPBusinessOrgBO> capBusinessOrgBOs) {
        this.capBusinessOrgBOs = capBusinessOrgBOs;
    }

    public static class SortComparator
    implements Comparator<CAPBusinessTemplateBO> {
        @Override
        public int compare(CAPBusinessTemplateBO o1, CAPBusinessTemplateBO o2) {
            Integer sort1 = Integer.valueOf(o1.getSort());
            Integer sort2 = Integer.valueOf(o2.getSort());
            if (sort1 == null || sort2 == null) {
                return 0;
            }
            return sort1 - sort2;
        }
    }
}

