/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.cap4.template.cache;

import com.seeyon.cap4.template.bo.CAPBusinessColumnBO;
import com.seeyon.cap4.template.cache.LRUCacheManager;
import com.seeyon.cap4.template.manager.CAPBusinessColumnManager;
import com.seeyon.cap4.template.util.CAPBusinessClusterUtil;
import com.seeyon.ctp.common.AppContext;
import com.seeyon.ctp.common.exceptions.BusinessException;
import com.seeyon.ctp.common.log.CtpLogFactory;
import java.util.List;
import org.apache.commons.logging.Log;

public class CAPBusinessColumnCache
extends LRUCacheManager<Long, List<CAPBusinessColumnBO>> {
    private static final Log LOGGER = CtpLogFactory.getLog(CAPBusinessColumnCache.class);
    public static final CAPBusinessColumnCache instance = new CAPBusinessColumnCache(20);
    CAPBusinessColumnManager capBusinessColumnManager = (CAPBusinessColumnManager)AppContext.getBean((String)"capBusinessColumnManager");

    public CAPBusinessColumnCache(Integer capacity) {
        super(capacity);
    }

    public CAPBusinessColumnCache() {
    }

    @Override
    public List<CAPBusinessColumnBO> load(Long templateId) {
        List<CAPBusinessColumnBO> bos = null;
        try {
            bos = this.capBusinessColumnManager.getCAPBusinessColumnBOsByTemplateId(templateId);
        }
        catch (BusinessException e) {
            LOGGER.error((Object)"load bos is exception", (Throwable)e);
        }
        return bos;
    }

    @Override
    public List<CAPBusinessColumnBO> load(List<Long> templateIds) {
        List<CAPBusinessColumnBO> bos = null;
        try {
            bos = this.capBusinessColumnManager.getCAPBusinessColumnBOsByTemplateIds(templateIds);
        }
        catch (BusinessException e) {
            LOGGER.error((Object)"load bos is exception , by templateIds", (Throwable)e);
        }
        return bos;
    }

    @Override
    public void remove(Long k) {
        super.remove(k);
        CAPBusinessClusterUtil.removeCacheNotifyCluster(k, this.getClass().getName());
    }

    @Override
    public void removes(List<Long> ks) {
        super.removes(ks);
        CAPBusinessClusterUtil.removeCacheNotifyCluster(ks, this.getClass().getName());
    }
}

