/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.cap4.template.cache;

import com.seeyon.cap4.template.bo.CAPBusinessElementBO;
import com.seeyon.cap4.template.cache.LRUCacheManager;
import com.seeyon.cap4.template.manager.CAPBusinessElementManager;
import com.seeyon.cap4.template.util.CAPBusinessClusterUtil;
import com.seeyon.ctp.common.AppContext;
import com.seeyon.ctp.common.exceptions.BusinessException;
import com.seeyon.ctp.common.log.CtpLogFactory;
import java.util.List;
import org.apache.commons.logging.Log;

public class CAPBusinessElementCache
extends LRUCacheManager<Long, List<CAPBusinessElementBO>> {
    private static final Log LOGGER = CtpLogFactory.getLog(CAPBusinessElementCache.class);
    public static final CAPBusinessElementCache instance = new CAPBusinessElementCache(20);
    CAPBusinessElementManager capBusinessElementManager = (CAPBusinessElementManager)AppContext.getBean((String)"capBusinessElementManager");

    public CAPBusinessElementCache(Integer capacity) {
        super(capacity);
    }

    public CAPBusinessElementCache() {
    }

    @Override
    public List<CAPBusinessElementBO> load(Long columnId) {
        List<CAPBusinessElementBO> bos = null;
        try {
            bos = this.capBusinessElementManager.getCAPBusinessElementBOsByColumnId(columnId);
        }
        catch (BusinessException e) {
            LOGGER.error((Object)"load bos is exception", (Throwable)e);
        }
        return bos;
    }

    @Override
    public void remove(Long k) {
        super.remove(k);
        CAPBusinessClusterUtil.removeCacheNotifyCluster(k, this.getClass().getName());
    }

    @Override
    public void removes(List<Long> ks) {
        super.removes(ks);
        CAPBusinessClusterUtil.removeCacheNotifyCluster(ks, this.getClass().getName());
    }
}

