/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.cap4.template.cache;

import com.google.common.cache.Cache;
import com.google.common.cache.RemovalListener;
import com.google.common.cache.RemovalNotification;
import com.seeyon.cap4.form.util.sqlite.CAPSQLiteUtil;
import com.seeyon.cap4.template.cache.ICacheManager;
import com.seeyon.ctp.common.log.CtpLogFactory;
import com.seeyon.ctp.util.DateUtil;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;

public abstract class GuavaCacheManager<K, V>
implements ICacheManager<K, V> {
    private static final String CACHE_POOL = "cache_pool.db";
    private static final String KEY = "KEY";
    private static final String VALUE = "VALUE";
    private static final String LAST_TIME = "LAST_TIME";
    protected Cache cache = null;
    protected String BUSINESS_CACHE = null;
    private static final Log LOGGER = CtpLogFactory.getLog(GuavaCacheManager.class);

    public V getCache(K k) {
        if (this.cache != null) {
            return (V)this.cache.getIfPresent(k);
        }
        return null;
    }

    @Override
    public V get(K k) {
        if (this.cache != null && this.cache.getIfPresent(k) != null) {
            Object object = this.getPersistentContainer(k);
            if (object == null) {
                this.cache.invalidate(k);
            }
            return (V)object;
        }
        return null;
    }

    @Override
    public void set(K k, V v) {
        if (this.createPersistentContainer()) {
            if (this.cache == null) {
                this.buildCache();
            }
            if (this.cache != null && this.cache.getIfPresent(k) != null) {
                if (this.getPersistentContainer(k) == null) {
                    if (!this.putPersistentContainer(k, v)) {
                        LOGGER.error((Object)("GuavaCacheManager set fail," + k + ":" + v));
                    } else if (this.cache != null) {
                        this.cache.put(k, (Object)DateUtil.formatDateTime((Date)new Date()));
                    }
                } else if (!this.updatePersistentContainer(k, v)) {
                    LOGGER.error((Object)("GuavaCacheManager update fail," + k + ":" + v));
                } else if (this.cache != null) {
                    this.cache.put(k, (Object)DateUtil.formatDateTime((Date)new Date()));
                }
            } else if (!this.putPersistentContainer(k, v)) {
                LOGGER.error((Object)("GuavaCacheManager set fail," + k + ":" + v));
            } else if (this.cache != null) {
                this.cache.put(k, (Object)DateUtil.formatDateTime((Date)new Date()));
            }
        }
    }

    @Override
    public void remove(K k) {
        if (this.cache != null) {
            this.cache.invalidate(k);
        }
        this.removePersistentContainer(k);
    }

    @Override
    public boolean containsKey(K k) {
        return this.cache != null && this.cache.getIfPresent(k) != null;
    }

    @Override
    public void clear() {
        if (this.cache != null) {
            this.cache.invalidateAll();
        }
        this.deletePersistentContainer();
    }

    public abstract void init();

    public abstract void buildCache();

    public abstract void setCacheName();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean createPersistentContainer() {
        Connection connection = null;
        try {
            connection = CAPSQLiteUtil.getConnection((String)CACHE_POOL);
            if (!CAPSQLiteUtil.isExistTable((Connection)connection, (String)this.BUSINESS_CACHE)) {
                ArrayList<String> fields = new ArrayList<String>();
                fields.add("KEY CHAR(64)");
                fields.add("VALUE TEXT");
                fields.add("LAST_TIME CHAR(20)");
                String tableSql = CAPSQLiteUtil.getCreateTableSql((String)this.BUSINESS_CACHE, fields);
                CAPSQLiteUtil.createTable((Connection)connection, (String)tableSql);
            }
        }
        catch (SQLException e) {
            LOGGER.error((Object)"GuavaCacheManager createPersistentContainer error:", (Throwable)e);
            boolean bl = false;
            return bl;
        }
        finally {
            CAPSQLiteUtil.closeConnection((Connection)connection);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean deletePersistentContainer() {
        Connection connection = null;
        try {
            connection = CAPSQLiteUtil.getConnection((String)CACHE_POOL);
            if (CAPSQLiteUtil.isExistTable((Connection)connection, (String)this.BUSINESS_CACHE)) {
                CAPSQLiteUtil.deleteTable((Connection)connection, (String)this.BUSINESS_CACHE);
            }
        }
        catch (SQLException e) {
            LOGGER.error((Object)"GuavaCacheManager deletePersistentContainer error:", (Throwable)e);
            boolean bl = false;
            return bl;
        }
        finally {
            CAPSQLiteUtil.closeConnection((Connection)connection);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean putPersistentContainer(K k, V v) {
        Connection connection = null;
        try {
            connection = CAPSQLiteUtil.getConnection((String)CACHE_POOL);
            ArrayList<String> fields = new ArrayList<String>();
            fields.add(KEY);
            fields.add(VALUE);
            fields.add(LAST_TIME);
            String insertDataSql = CAPSQLiteUtil.getInsertDataSql((String)this.BUSINESS_CACHE, fields);
            ArrayList<Object> data = new ArrayList<Object>();
            ArrayList<ArrayList<Object>> datas = new ArrayList<ArrayList<Object>>(1);
            datas.add(data);
            data.add(k);
            data.add(v);
            data.add(DateUtil.formatDateTime((Date)new Date()));
            CAPSQLiteUtil.updateBatch((Connection)connection, (String)insertDataSql, datas);
        }
        catch (SQLException e) {
            LOGGER.error((Object)"GuavaCacheManager putPersistentContainer error:", (Throwable)e);
            boolean bl = false;
            return bl;
        }
        finally {
            CAPSQLiteUtil.closeConnection((Connection)connection);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean updatePersistentContainer(K k, V v) {
        Connection connection = null;
        try {
            connection = CAPSQLiteUtil.getConnection((String)CACHE_POOL);
            StringBuilder selectSql = new StringBuilder("UPDATE ").append(this.BUSINESS_CACHE).append(" SET ").append(VALUE).append(" = ?,").append(LAST_TIME).append(" = ? ").append(" WHERE ").append(KEY).append(" = ?");
            ArrayList<Object> updateParam = new ArrayList<Object>();
            ArrayList<ArrayList<Object>> updateParams = new ArrayList<ArrayList<Object>>(1);
            updateParams.add(updateParam);
            updateParam.add(v);
            updateParam.add(DateUtil.formatDateTime((Date)new Date()));
            updateParam.add(k);
            CAPSQLiteUtil.updateBatch((Connection)connection, (String)selectSql.toString(), updateParams);
        }
        catch (SQLException e) {
            LOGGER.error((Object)"GuavaCacheManager updatePersistentContainer error:", (Throwable)e);
            boolean bl = false;
            return bl;
        }
        finally {
            CAPSQLiteUtil.closeConnection((Connection)connection);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean removePersistentContainer(K k) {
        Connection connection = null;
        try {
            connection = CAPSQLiteUtil.getConnection((String)CACHE_POOL);
            if (CAPSQLiteUtil.isExistTable((Connection)connection, (String)this.BUSINESS_CACHE)) {
                StringBuilder deleteSql = new StringBuilder("DELETE FROM ").append(this.BUSINESS_CACHE).append(" WHERE ").append(KEY).append(" = ?");
                ArrayList<K> deleteParam = new ArrayList<K>();
                ArrayList<ArrayList<K>> deleteParams = new ArrayList<ArrayList<K>>(1);
                deleteParams.add(deleteParam);
                deleteParam.add(k);
                CAPSQLiteUtil.updateBatch((Connection)connection, (String)deleteSql.toString(), deleteParams);
            }
        }
        catch (SQLException e) {
            LOGGER.error((Object)"GuavaCacheManager removePersistentContainer error:", (Throwable)e);
            boolean bl = false;
            return bl;
        }
        finally {
            CAPSQLiteUtil.closeConnection((Connection)connection);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object getPersistentContainer(K k) {
        Connection connection = null;
        try {
            connection = CAPSQLiteUtil.getConnection((String)CACHE_POOL);
            StringBuilder selectSql = new StringBuilder("SELECT ").append(VALUE).append(" FROM ").append(this.BUSINESS_CACHE).append(" WHERE ").append(KEY).append(" = ?");
            ArrayList<K> selectParam = new ArrayList<K>();
            selectParam.add(k);
            List results = CAPSQLiteUtil.select((Connection)connection, (String)selectSql.toString(), selectParam);
            if (!results.isEmpty() && results.size() >= 1) {
                Map result = (Map)results.get(0);
                Object v = result.get(VALUE.toLowerCase());
                return v;
            }
        }
        catch (SQLException e) {
            LOGGER.error((Object)"GuavaCacheManager getPersistentContainer error:", (Throwable)e);
            Object var4_6 = null;
            return var4_6;
        }
        finally {
            CAPSQLiteUtil.closeConnection((Connection)connection);
        }
        return null;
    }

    protected class GuavaCacheRemovalListener
    implements RemovalListener {
        protected GuavaCacheRemovalListener() {
        }

        public void onRemoval(RemovalNotification notification) {
            GuavaCacheManager.this.removePersistentContainer(notification.getKey());
        }
    }
}

