/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.cap4.template.cache;

import com.seeyon.cap4.template.cache.ICacheManager;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public abstract class LRUCacheManager<K, V>
implements ICacheManager<K, V> {
    private Integer cacheSize;
    private Integer currentSize = 0;
    private Integer defaultCapacity = 100;
    private static final Lock lock = new ReentrantLock();
    private Map<K, CacheNode> nodes;
    private CacheNode head;
    private CacheNode last;

    public LRUCacheManager() {
        this.cacheSize = this.defaultCapacity;
        this.nodes = new HashMap<K, CacheNode>(this.defaultCapacity);
    }

    public LRUCacheManager(Integer capacity) {
        this.cacheSize = capacity;
        this.nodes = new HashMap<K, CacheNode>(capacity);
    }

    @Override
    public V get(K k) {
        try {
            lock.lock();
            V v = this.getNoLock(k);
            return v;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<V> gets(List<K> ks) {
        try {
            lock.lock();
            ArrayList<V> vs = new ArrayList<V>();
            for (K k : ks) {
                V v = this.getNoLock(k);
                if (v == null) continue;
                vs.add(v);
            }
            ArrayList<V> arrayList = vs;
            return arrayList;
        }
        finally {
            lock.unlock();
        }
    }

    private V getNoLock(K k) {
        CacheNode node = this.nodes.get(k);
        if (node == null) {
            V v = this.load(k);
            if (v != null) {
                this.set(k, v);
            }
            return v;
        }
        this.move(node);
        return node.value;
    }

    @Override
    public void set(K k, V v) {
        try {
            lock.lock();
            this.setNoLock(k, v);
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sets(List<K> ks, List<V> vs) {
        try {
            lock.lock();
            for (int i = 0; i < ks.size(); ++i) {
                this.setNoLock(ks.get(i), vs.get(i));
            }
        }
        finally {
            lock.unlock();
        }
    }

    public void setNoLock(K k, V v) {
        CacheNode node = this.nodes.get(k);
        if (node != null) {
            node.value = v;
            this.move(node);
            this.nodes.put(k, node);
        } else {
            node = new CacheNode();
            if (this.currentSize >= this.cacheSize) {
                if (this.last != null) {
                    this.nodes.remove(this.last.key);
                }
                this.removeLast();
            } else {
                Integer n = this.currentSize;
                Integer n2 = this.currentSize = Integer.valueOf(this.currentSize + 1);
            }
            node.key = k;
            node.value = v;
            this.move(node);
            this.nodes.put(k, node);
        }
    }

    @Override
    public void remove(K k) {
        try {
            lock.lock();
            this.removeNoLock(k);
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removes(List<K> ks) {
        try {
            lock.lock();
            for (K k : ks) {
                this.removeNoLock(k);
            }
        }
        finally {
            lock.unlock();
        }
    }

    private void removeNoLock(K k) {
        CacheNode cacheNode = this.nodes.get(k);
        if (cacheNode != null) {
            if (cacheNode.prev != null) {
                cacheNode.prev.next = cacheNode.next;
            }
            if (cacheNode.next != null) {
                cacheNode.next.prev = cacheNode.prev;
            }
            if (this.last == cacheNode) {
                this.last = cacheNode.prev;
            }
            if (this.head == cacheNode) {
                this.head = cacheNode.next;
            }
            this.nodes.remove(k);
        }
    }

    @Override
    public void clear() {
        try {
            lock.lock();
            this.head = null;
            this.last = null;
            this.nodes.clear();
        }
        finally {
            lock.unlock();
        }
    }

    @Override
    public boolean containsKey(K k) {
        try {
            lock.lock();
            boolean bl = this.nodes.containsKey(k);
            return bl;
        }
        finally {
            lock.unlock();
        }
    }

    private void removeLast() {
        if (this.last != null) {
            if (this.last.prev != null) {
                this.last.prev.next = null;
            } else {
                this.head = null;
            }
            this.last = this.last.prev;
        }
    }

    private void move(CacheNode cacheNode) {
        if (cacheNode == this.head) {
            return;
        }
        if (cacheNode.prev != null) {
            cacheNode.prev.next = cacheNode.next;
        }
        if (cacheNode.next != null) {
            cacheNode.next.prev = cacheNode.prev;
        }
        if (this.last == cacheNode) {
            this.last = cacheNode.prev;
        }
        if (this.head != null) {
            cacheNode.next = this.head;
            this.head.prev = cacheNode;
        }
        this.head = cacheNode;
        cacheNode.prev = null;
        if (this.last == null) {
            this.last = this.head;
        }
    }

    public abstract V load(K var1);

    class CacheNode {
        CacheNode prev;
        CacheNode next;
        V value;
        K key;

        CacheNode() {
        }
    }
}

