/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.cap4.template.condition.clause;

import com.seeyon.cap4.form.bean.FormFieldComEnum;
import com.seeyon.cap4.form.bean.FormQueryWhereClause;
import com.seeyon.cap4.form.modules.engin.formula.FormulaEnums;
import com.seeyon.cap4.form.util.FormUtil;
import com.seeyon.cap4.template.bean.ConditionBean;
import com.seeyon.cap4.template.condition.clause.AbstractConditionClause;
import com.seeyon.ctp.common.exceptions.BusinessException;
import com.seeyon.ctp.util.DateUtil;
import java.sql.Timestamp;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.List;

public class DateTimeConditionClause
extends AbstractConditionClause {
    private static final List<String> supportInputTypes = new ArrayList<String>();

    @Override
    public List<String> supportInputType() {
        return supportInputTypes;
    }

    @Override
    public FormQueryWhereClause get(ConditionBean conditionBean) throws BusinessException {
        ArrayList<Timestamp> queryParams = new ArrayList<Timestamp>();
        StringBuilder sb = new StringBuilder();
        String fieldName = conditionBean.getTableNameAndFieldName();
        String o = FormUtil.isNull2Str((Object)conditionBean.getFieldValue());
        Timestamp maxDate = null;
        Timestamp minDate = null;
        try {
            if (o.length() == 10) {
                maxDate = DateUtil.parseTimestamp((String)(o + " 23:59:59"), (String)"yyyy-MM-dd HH:mm:ss");
                minDate = DateUtil.parseTimestamp((String)(o + " 00:00:00"), (String)"yyyy-MM-dd HH:mm:ss");
            } else if (o.length() == 16) {
                maxDate = DateUtil.parseTimestamp((String)(o + ":59"), (String)"yyyy-MM-dd HH:mm:ss");
                minDate = DateUtil.parseTimestamp((String)(o + ":00"), (String)"yyyy-MM-dd HH:mm:ss");
            } else if (o.length() == 19) {
                maxDate = DateUtil.parseTimestamp((String)o, (String)"yyyy-MM-dd HH:mm:ss");
                minDate = DateUtil.parseTimestamp((String)o, (String)"yyyy-MM-dd HH:mm:ss");
            }
        }
        catch (ParseException e) {
            throw new BusinessException((Throwable)e, "\u8bbe\u7f6e\u5f00\u59cb\u65e5\u671f\uff0c\u7ed3\u675f\u65e5\u671f\u65f6\u6761\u4ef6\u65f6\uff0c\u5f02\u5e38", new Object[0]);
        }
        FormulaEnums.ConditionSymbol opChar = FormulaEnums.ConditionSymbol.getEnumByKey((String)conditionBean.getOperation());
        switch (opChar) {
            case equal: {
                sb.append("(").append(fieldName).append(" >= ? ").append(" and ").append(fieldName).append(" <= ? ").append(")");
                queryParams.add(minDate);
                queryParams.add(maxDate);
                break;
            }
            case greatAndEqual: {
                sb.append(fieldName).append(" >= ? ");
                queryParams.add(minDate);
                break;
            }
            case greatThan: {
                sb.append(fieldName).append(" > ? ");
                queryParams.add(maxDate);
                break;
            }
            case lessAndEqual: {
                sb.append(fieldName).append(" <= ? ");
                queryParams.add(maxDate);
                break;
            }
            case lessThan: {
                sb.append(fieldName).append(" < ? ");
                queryParams.add(minDate);
                break;
            }
            case notEqual: {
                sb.append("(").append(fieldName).append(" > ? ").append(" or ").append(fieldName).append(" < ? ").append(")");
                queryParams.add(maxDate);
                queryParams.add(minDate);
                break;
            }
            default: {
                sb.append(fieldName).append(" ").append(opChar).append(" ? ");
                queryParams.add(minDate);
            }
        }
        FormQueryWhereClause whereClause = new FormQueryWhereClause();
        whereClause.setQueryParams(queryParams);
        whereClause.setAllSqlClause(sb.toString());
        return whereClause;
    }

    static {
        supportInputTypes.add(FormFieldComEnum.EXTEND_DATETIME.getKey());
    }
}

