/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.cap4.template.constant;

import com.seeyon.ctp.common.i18n.ResourceUtil;
import java.util.HashMap;
import java.util.Map;

public class CAPBusinessEnum {

    public static enum CalcValueLengthLanguageEnum {
        ZH("zh", "GBK"),
        OTHER("other", "UTF-8");

        private String language;
        private String encoding;

        private CalcValueLengthLanguageEnum(String language, String encoding) {
            this.language = language;
            this.encoding = encoding;
        }

        public static String getEncodingByLanguage(String language) {
            if (ZH.getLanguage().equalsIgnoreCase(language)) {
                return ZH.getEncoding();
            }
            return OTHER.getEncoding();
        }

        public String getLanguage() {
            return this.language;
        }

        public String getEncoding() {
            return this.encoding;
        }
    }

    public static enum DistanceUnitEnum {
        M("m", "\u7c73"),
        KM("km", "\u5343\u7c73");

        private String key;
        private String name;

        private DistanceUnitEnum(String key, String name) {
            this.key = key;
            this.name = name;
        }

        public String getKey() {
            return this.key;
        }

        public void setKey(String key) {
            this.key = key;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }
    }

    public static enum ReportCacheKeyEnum {
        data("data");

        private String name;

        private ReportCacheKeyEnum(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }
    }

    public static enum BatchOperationEnum {
        BATCH_IMPORT("batchImport", "cap.template.batchOperation.batchOperationEnum.batchImport"),
        BATCH_SUB_IMPORT("batchSubImport", "cap.template.batchOperation.batchOperationEnum.batchSubImport"),
        BATCH_UPDATE("batchUpdate", "cap.template.batchOperation.batchOperationEnum.batchUpdate"),
        BATCH_REFRESH("batchRefresh", "cap.template.batchOperation.batchOperationEnum.batchRefresh"),
        EXPORT_DATA("exportData", "cap.template.batchOperation.batchOperationEnum.exportData"),
        EXPORT_MODULE("exportModule", "cap.template.batchOperation.batchOperationEnum.exportModule"),
        EXPORT_SUB_MODULE("exportSubModule", "cap.template.batchOperation.batchOperationEnum.exportSubModule"),
        EXPORT_SUB_DATA("exportSubData", "cap.template.batchOperation.batchOperationEnum.exportSubData"),
        DEFAULT("default", "this is default, don't use and delete!");

        private String key;
        private String explain;

        private BatchOperationEnum(String key, String explain) {
            this.key = key;
            this.explain = explain;
        }

        public String getKey() {
            return this.key;
        }

        public String getExplain() {
            return ResourceUtil.getString((String)this.explain);
        }

        public String getRealExplain() {
            return this.explain;
        }

        public String getDisplay() {
            return ResourceUtil.getString((String)this.explain);
        }
    }

    public static enum CheckBoxEnum {
        CHECK("1", "cap.template.form.checkBoxEnum.check"),
        UN_CHECK("0", "cap.template.form.checkBoxEnum.unCheck");

        private String key;
        private String display;

        private CheckBoxEnum(String key, String display) {
            this.key = key;
            this.display = display;
        }

        public String getKey() {
            return this.key;
        }

        public String getDisplay() {
            return ResourceUtil.getString((String)this.display);
        }
    }

    public static enum BatchValidateRulesEnum {
        VALIDATE_SUCCESS("0", "cap.template.batchOperation.batchValidateRulesEnum.validateSuccess"),
        FORMAT_ERROR("1", "cap.template.batchOperation.batchValidateRulesEnum.formatError"),
        FIELD_LENGTH_ERROR("2", "cap.template.batchOperation.batchValidateRulesEnum.fieldLengthError"),
        DECIMAL_DIGITS_ERROR("3", "cap.template.batchOperation.batchValidateRulesEnum.decimalDigitsError"),
        VALUE_MISMATCH_ERROR("4", "cap.template.batchOperation.batchValidateRulesEnum.valueMismatchError"),
        CONTROL_ERROR("5", "cap.template.batchOperation.batchValidateRulesEnum.controlError"),
        VALIDATE_RULES_ERROR("6", "cap.template.batchOperation.batchValidateRulesEnum.validateRulesError"),
        UNIQUE_IDENTIFIER_ERROR("7", "cap.template.batchOperation.batchValidateRulesEnum.uniqueIdentifierError"),
        TRIGGER_CAPACITY_FULL_ERROR("8", "cap.template.batchOperation.batchValidateRulesEnum.triggerCapacityFullError"),
        VALIDATE_ERROR("9", "cap.template.batchOperation.batchValidateRulesEnum.validateError"),
        DATA_LOCK_ERROR("10", "cap.template.batchOperation.batchValidateRulesEnum.dataLockError"),
        SYSTEM_RELATION_ERROR("11", "cap.template.data.relation.auto.noData");

        private String type;
        private String explain;

        private BatchValidateRulesEnum(String type, String explain) {
            this.type = type;
            this.explain = explain;
        }

        public String getType() {
            return this.type;
        }

        public String getExplain() {
            return ResourceUtil.getString((String)this.explain);
        }

        public static String getExplainByType(String type) {
            String result = VALIDATE_ERROR.getExplain();
            if (VALIDATE_SUCCESS.getType().equals(type)) {
                result = VALIDATE_SUCCESS.getExplain();
            } else if (FORMAT_ERROR.getType().equals(type)) {
                result = FORMAT_ERROR.getExplain();
            } else if (FIELD_LENGTH_ERROR.getType().equals(type)) {
                result = FIELD_LENGTH_ERROR.getExplain();
            } else if (DECIMAL_DIGITS_ERROR.getType().equals(type)) {
                result = DECIMAL_DIGITS_ERROR.getExplain();
            } else if (VALUE_MISMATCH_ERROR.getType().equals(type)) {
                result = VALUE_MISMATCH_ERROR.getExplain();
            } else if (CONTROL_ERROR.getType().equals(type)) {
                result = CONTROL_ERROR.getExplain();
            } else if (VALIDATE_RULES_ERROR.getType().equals(type)) {
                result = VALIDATE_RULES_ERROR.getExplain();
            } else if (UNIQUE_IDENTIFIER_ERROR.getType().equals(type)) {
                result = UNIQUE_IDENTIFIER_ERROR.getExplain();
            } else if (TRIGGER_CAPACITY_FULL_ERROR.getType().equals(type)) {
                result = TRIGGER_CAPACITY_FULL_ERROR.getExplain();
            } else if (DATA_LOCK_ERROR.getType().equals(type)) {
                result = DATA_LOCK_ERROR.getExplain();
            } else if (SYSTEM_RELATION_ERROR.getType().equals(type)) {
                result = SYSTEM_RELATION_ERROR.getExplain();
            }
            return result;
        }
    }

    public static enum DataSource {
        LIST_CREATE("listCreate", "cap.template.business.dataSource.listCreate"),
        LIST_SENT("listSent", "cap.template.business.dataSource.listSent"),
        LIST_WAIT_SEND("listWaitSend", "cap.template.business.dataSource.listWaitSend"),
        LIST_DONE("listDone", "cap.template.business.dataSource.listDone"),
        LIST_PENDING("listPending", "cap.template.business.dataSource.listPending"),
        FLOW_LIST("flowList", "cap.template.business.dataSource.flowList"),
        FLOW_BUSINESS("flowBusiness", "cap.template.business.dataSource.flowBusiness"),
        URL_TYPE("urlType", "cap.template.business.dataSource.urlType"),
        UNFLOW_CREATE("unflowCreate", "cap.template.business.dataSource.unflowCreate"),
        UNFLOW_LIST("unflowList", "cap.template.business.dataSource.unflowList"),
        QUERY_LIST("queryList", "cap.template.business.dataSource.queryList"),
        CACL_LIST("caclList", "cap.template.business.dataSource.caclList"),
        CATEGORY("category", "cap.template.business.dataSource.category"),
        BIZ_MAP("bizMap", "cap.template.business.dataSource.bizMap"),
        LISTPENDING_NUN("listPendingNun", "cap.template.business.dataSource.listPendingNun"),
        LISTDONE_NUN("listDoneNun", "cap.template.business.dataSource.listDoneNun"),
        LISTWAITSEND_NUN("listWaitSendNun", "cap.template.business.dataSource.listWaitSendNun"),
        LISTSENT_NUN("listSentNun", "cap.template.business.dataSource.listSentNun"),
        CACL_NUM("caclNum", "cap.template.business.dataSource.caclNum"),
        FLOW_CREATE_MENU_COLLECTION("flowCreateMenuCollection", "cap.template.business.dataSource.flowCreateMenuCollection"),
        UNFLOW_CREATE_MENU_COLLECTION("unFlowCreateMenuCollection", "cap.template.business.dataSource.unFlowCreateMenuCollection"),
        UNFLOW_MENU_COLLECTION("unflowMenuCollection", "cap.template.business.dataSource.unflowMenuCollection"),
        QUERY_MENU_COLLECTION("queryMenuCollection", "cap.template.business.dataSource.queryMenuCollection"),
        CACL_MENU_COLLECTION("caclMenuCollection", "cap.template.business.dataSource.caclMenuCollection"),
        ALL_MENU_COLLECTION("allMenuCollection", "cap.template.business.dataSource.allMenuCollection"),
        APP_IN_MENU_NOT_CONFIG("appInMenuNotConfig", "cap.template.business.dataSource.appInMenuNotConfig"),
        APP_IN_MENU_HAS_CONFIG("appInMenuHasConfig", "cap.template.business.dataSource.appInMenuHasConfig"),
        MUTI_BUSINESS_MENU("mutiBusinessMenu", "cap.template.business.dataSource.mutiBusinessMenu");

        private String key;
        private String name;

        private DataSource(String key, String name) {
            this.key = key;
            this.name = name;
        }

        public static DataSource getDataSourceByKey(String key) {
            for (DataSource ds : DataSource.values()) {
                if (!ds.key.equals(key)) continue;
                return ds;
            }
            return null;
        }

        public String getKey() {
            return this.key;
        }

        public String getName() {
            return ResourceUtil.getString((String)this.name);
        }
    }

    public static enum TrueOrFalseEnum {
        TRUE("1", "true", "cap.template.common.yes"),
        FALSE("0", "false", "cap.template.common.no");

        private String key;
        private String name;
        private String i18n;

        private TrueOrFalseEnum(String key, String name, String i18n) {
            this.key = key;
            this.name = name;
            this.i18n = i18n;
        }

        public String getKey() {
            return this.key;
        }

        public String getName() {
            return this.name;
        }

        public String getI18n() {
            return ResourceUtil.getString((String)this.i18n);
        }

        public static String getKey(boolean value) {
            return value ? TRUE.getKey() : FALSE.getKey();
        }

        public static TrueOrFalseEnum getEnum(boolean value) {
            return value ? TRUE : FALSE;
        }

        public static TrueOrFalseEnum getEnum(Integer value) {
            return TRUE.getKey().equals(String.valueOf(value)) ? TRUE : FALSE;
        }
    }

    public static enum UnFlowOperationTypeEnum {
        CREATE("create", "\u65b0\u5efa"),
        UPDATE("update", "\u4fee\u6539"),
        IMPORT("import", "\u6279\u91cf\u5bfc\u5165"),
        TEMPLATE_DOWNLOAD("templateDownload", "\u6a21\u7248\u4e0b\u8f7d"),
        EXPORT("export", "\u6279\u91cf\u5bfc\u51fa"),
        VIEWLOG("viewLog", "\u67e5\u770b\u65e5\u5fd7"),
        DELETE("delete", "\u5220\u9664"),
        LOCK("lock", "\u9501\u5b9a"),
        UNLOCK("unlock", "\u89e3\u9501"),
        PRINT("print", "\u6253\u5370"),
        BATCH_FRESH("batchFresh", "\u6279\u91cf\u5237\u65b0"),
        BATCH_UPDATE("batchUpdate", "\u6279\u91cf\u4fee\u6539"),
        BAR_CODE("barCode", "\u626b\u4e00\u626b");

        private String key;
        private String txt;

        private UnFlowOperationTypeEnum(String key, String txt) {
            this.key = key;
            this.txt = txt;
        }

        public String getKey() {
            return this.key;
        }

        public String getTxt() {
            return this.txt;
        }
    }

    public static enum DownloadZipType {
        TEMPLATE(1, "template", "\u6a21\u677f"),
        COLUMN(2, "column", "\u680f\u76ee"),
        CUSTOM_CTRL(3, "customCtrlDefault", "\u81ea\u5b9a\u4e49\u63a7\u4ef6(\u8868\u5355\u5185\u63a7\u4ef6)"),
        CUSTOM_BIND_BUTTON(5, "customCtrlBindButton", "\u5e94\u7528\u7ed1\u5b9a\u6309\u94ae");

        private int type;
        private String alias;
        private String name;

        private DownloadZipType(int type, String alias, String name) {
            this.type = type;
            this.alias = alias;
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public String getAlias() {
            return this.alias;
        }

        public int getType() {
            return this.type;
        }

        public static DownloadZipType getEnumByType(int type) {
            for (DownloadZipType e : DownloadZipType.values()) {
                if (e.getType() != type) continue;
                return e;
            }
            throw new IllegalArgumentException("\u672a\u5b9a\u4e49\u7684\u679a\u4e3e\u7c7b\u578b!type=" + type);
        }
    }

    public static enum TemplateFrameType {
        NEED_FRAME(0),
        NO_NEED_FRAME(1);

        private int type;

        private TemplateFrameType(int type) {
            this.type = type;
        }

        public int getType() {
            return this.type;
        }
    }

    public static enum State {
        DISABLE(0),
        ENABLE(1),
        EDIT(2);

        private int state;

        private State(int state) {
            this.state = state;
        }

        public int getState() {
            return this.state;
        }
    }

    public static enum TemplateType {
        TP_BIZ_INDEX(1, "tpBizIndex", "\u4e1a\u52a1\u9996\u9875"),
        TP_FLOW(2, "tpFlow", "\u6709\u6d41\u7a0b"),
        TP_CACL(3, "tpCacl", "\u7edf\u8ba1"),
        TP_QUERY(4, "tpQuery", "\u67e5\u8be2"),
        TP_UNFLOW(5, "tpUnflow", "\u65e0\u6d41\u7a0b"),
        TP_FORM(6, "tpForm", "\u8868\u5355"),
        TP_BIZ_MAP(7, "tpBizMap", "\u4e1a\u52a1\u5bfc\u56fe"),
        TP_FLOW_BUSINESS(8, "tpFlowBusiness", "\u6d41\u7a0b\u4e1a\u52a1\u5217\u8868");

        private String name;
        private String alias;
        private int type;

        private TemplateType(int type, String alias, String name) {
            this.name = name;
            this.alias = alias;
            this.type = type;
        }

        public String getName() {
            return ResourceUtil.getString((String)("cap.template.type." + this.alias));
        }

        public String getAlias() {
            return this.alias;
        }

        public int getType() {
            return this.type;
        }

        public static TemplateType getEnumByType(int type) {
            for (TemplateType e : TemplateType.values()) {
                if (e.getType() != type) continue;
                return e;
            }
            throw new IllegalArgumentException("\u672a\u5b9a\u4e49\u7684\u679a\u4e3e\u7c7b\u578b!type=" + type);
        }
    }

    public static enum ColumnType {
        QUERY_RESULT(1, "queryResult", "\u67e5\u8be2\u7ed3\u679c"),
        CACL_RESULT(2, "caclResult", "\u7edf\u8ba1\u7ed3\u679c"),
        FLOW_LIST(3, "flowList", "\u6d41\u7a0b\u5217\u8868"),
        BUSINESS_TARGET(4, "businessTarget", "\u4e1a\u52a1\u6307\u6807"),
        SHORT_CUT(5, "shortCut", "\u5feb\u6377\u5165\u53e3"),
        UNFLOW_LIST(6, "unflowList", "\u65e0\u6d41\u7a0b\u5217\u8868"),
        NO_DATA(7, "noData", "\u65e0\u987b\u914d\u7f6e\u6570\u636e\u6e90"),
        MENU_COLLECTION(8, "menuCollection", "\u83dc\u5355\u5408\u96c6"),
        MENU_COLUMN(9, "menuColumn", "\u83dc\u5355\u680f\u76ee");

        private String name;
        private String alias;
        private int type;

        private ColumnType(int type, String alias, String name) {
            this.name = name;
            this.alias = alias;
            this.type = type;
        }

        public String getName() {
            return this.name;
        }

        public String getAlias() {
            return this.alias;
        }

        public int getType() {
            return this.type;
        }

        public static ColumnType getEnumByType(int type) {
            for (ColumnType e : ColumnType.values()) {
                if (e.getType() != type) continue;
                return e;
            }
            throw new IllegalArgumentException("\u672a\u5b9a\u4e49\u7684\u679a\u4e3e\u7c7b\u578b!type=" + type);
        }
    }

    public static enum Platform {
        PC(1, "PC"),
        MOBILE(2, "\u79fb\u52a8");

        private String name;
        private int type;

        private Platform(int type, String name) {
            this.name = name;
            this.type = type;
        }

        public String getName() {
            return this.name;
        }

        public int getType() {
            return this.type;
        }
    }

    public static enum FormSaveType {
        SAVE_AND_CLOSED(1, "\u4fdd\u5b58\u5e76\u5173\u95ed"),
        SAVE_AND_NEW(2, "\u4fdd\u5b58\u5e76\u65b0\u5efa"),
        SAVE_AND_COPY(3, "\u4fdd\u5b58\u5e76\u590d\u5236"),
        SAVE_AS_TEMPLATE(4, "\u5b58\u4e3a\u6a21\u677f"),
        SAVE_AS(5, "\u4fdd\u5b58\u5f85\u53d1"),
        SAVE_CURRENT(6, "\u4fdd\u5b58");

        private Integer type;
        private String name;

        private FormSaveType(Integer type, String name) {
            this.name = name;
            this.type = type;
        }

        public String getName() {
            return this.name;
        }

        public Integer getType() {
            return this.type;
        }
    }

    public static enum FormOperateType {
        NEW("0", "\u65b0\u5efa"),
        UPDATE("1", "\u4fee\u6539"),
        BROWSE("2", "\u6d4f\u89c8");

        private String key;
        private String name;

        private FormOperateType(String key, String name) {
            this.name = name;
            this.key = key;
        }

        public String getName() {
            return this.name;
        }

        public String getKey() {
            return this.key;
        }
    }

    public static enum FormOpenFrom {
        TRIGGER_MESSAGE("triggerMessage", "\u89e6\u53d1"),
        ORIGINAL_FORM("originalForm", "\u539f\u8868\u5355"),
        LIGHT_FORM("lightForm", "\u8f7b\u8868\u5355"),
        API_FORWARD("apiForward", "API\u63a5\u53e3\u8f6c\u53d1");

        private String key;
        private String name;

        private FormOpenFrom(String key, String name) {
            this.name = name;
            this.key = key;
        }

        public String getName() {
            return this.name;
        }

        public String getKey() {
            return this.key;
        }
    }

    public static enum SubBeanNewFrom {
        MANUAL_RELATION("manualRelation", "\u624b\u52a8\u5173\u8054"),
        FRONT_SUBMIT("frontSubmit", "\u524d\u7aef\u63d0\u4ea4"),
        IMPORT("import", "\u5bfc\u5165"),
        FRONT_COLLECT_OR_INCREASE("frontCollectOrIncrease", "\u524d\u7aef\u81ea\u52a8\u6c47\u603b/\u65b0\u589e"),
        SAVE_AUTO_COLLECT("saveAutoCollect", "\u4fdd\u5b58\u65f6\u81ea\u52a8\u6c47\u603b"),
        COPY_FORM_DATA("copyFormData", "\u4e00\u952e\u590d\u5236");

        private String key;
        private String name;

        private SubBeanNewFrom(String key, String name) {
            this.name = name;
            this.key = key;
        }

        public String getName() {
            return this.name;
        }

        public String getKey() {
            return this.key;
        }
    }

    public static enum FormsonButtonType {
        MANUAL_RELATION(1, "manual_relation", "\u624b\u52a8\u5173\u8054", "cap-icon-charuwupin", "#00ACCB"),
        AUTO_COLLECT(3, "auto_collect", "\u81ea\u52a8\u6c47\u603b", "cap-icon-auto-collect", "#FF7D4A"),
        AUTO_INCREASE_ROW(4, "auto_increase_row", "\u81ea\u52a8\u65b0\u589e\u660e\u7ec6\u884c", "cap-icon-auto-collect", "#FF7D4A"),
        ADD(11, "add", "\u63d2\u5165\u884c", "cap-icon-jiahao", "#1F85EC"),
        COPY(12, "copy", "\u590d\u5236\u884c", "cap-icon-fuzhi", "#1F85EC"),
        DELETE(13, "delete", "\u5220\u9664\u884c", "cap-icon-shanchu", "#FF5E5E"),
        DELETE_ALL(14, "delete_all", "\u5220\u9664\u5168\u90e8", "cap-icon-shanchuquanbu", "#FF5E5E"),
        IMPORT_EXCEL(15, "import_excel", "\u5bfc\u5165\u6570\u636e", "cap-icon-import", "#45BE85"),
        EXPORT_EXCEL(16, "export_excel", "\u5bfc\u51fa\u6570\u636e", "cap-icon-daochu", "#3AADFB");

        private int type;
        private String alias;
        private String name;
        private String icon;
        private String color;

        private FormsonButtonType(int type, String alias, String name, String icon, String color) {
            this.type = type;
            this.alias = alias;
            this.name = name;
            this.icon = icon;
            this.color = color;
        }

        public int getType() {
            return this.type;
        }

        public String getAlias() {
            return this.alias;
        }

        public String getName() {
            return this.name;
        }

        public String getIcon() {
            return this.icon;
        }

        public String getColor() {
            return this.color;
        }

        public Map<String, Object> exportMap() {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("type", String.valueOf(this.type));
            map.put("alias", this.alias);
            map.put("name", ResourceUtil.getString((String)("cap.template.form.table.button." + this.alias)));
            map.put("icon", this.icon);
            map.put("color", this.color);
            return map;
        }

        public static FormsonButtonType getEnumByType(int type) {
            for (FormsonButtonType typeEnum : FormsonButtonType.values()) {
                if (typeEnum.getType() != type) continue;
                return typeEnum;
            }
            return null;
        }

        public static FormsonButtonType getEnumByAlias(String alias) {
            if ("deleteAll".equals(alias)) {
                return DELETE_ALL;
            }
            for (FormsonButtonType typeEnum : FormsonButtonType.values()) {
                if (!typeEnum.getAlias().equals(alias)) continue;
                return typeEnum;
            }
            return null;
        }
    }

    public static enum DataListTypeEnum {
        FLOW_TO_DO("flowToDo", 7, "pending", "todolist"),
        UN_FLOW("unFlow", 1, "unFlow", "unFlow"),
        FLOW_MANAGE("flowManage", 8, "integrated", "integrated");

        private String key;
        private int value;
        private String alias;
        private String m3path;

        private DataListTypeEnum(String key, int value, String alias, String m3path) {
            this.key = key;
            this.value = value;
            this.alias = alias;
            this.m3path = m3path;
        }

        public int getValue() {
            return this.value;
        }

        public String getKey() {
            return this.key;
        }

        public String getAlias() {
            return this.alias;
        }

        public String getM3path() {
            return this.m3path;
        }

        public static DataListTypeEnum getEnumByKey(String key, String type) {
            for (DataListTypeEnum typeEnum : DataListTypeEnum.values()) {
                if (!("key".equals(type) ? typeEnum.getKey().equals(key) : "alias".equals(type) && typeEnum.getAlias().equals(key))) continue;
                return typeEnum;
            }
            return null;
        }

        public static DataListTypeEnum getEnumByValue(int value) {
            for (DataListTypeEnum typeEnum : DataListTypeEnum.values()) {
                if (typeEnum.getValue() != value) continue;
                return typeEnum;
            }
            return null;
        }
    }
}

