/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.cap4.template.controller;

import com.seeyon.cap4.bizportal.BizPortalConstants;
import com.seeyon.cap4.bizportal.api.BizPortalApi;
import com.seeyon.cap4.bizportal.param.ContextParam;
import com.seeyon.cap4.bizportal.po.CAPPortalSpace;
import com.seeyon.cap4.form.bean.FormBean;
import com.seeyon.cap4.form.bean.FormBindAuthBean;
import com.seeyon.cap4.form.bean.FormFlowBusinessBean;
import com.seeyon.cap4.form.bean.SimpleObjectBean;
import com.seeyon.cap4.form.modules.business.BizConfigBean;
import com.seeyon.cap4.form.modules.business.BusinessManager;
import com.seeyon.cap4.form.modules.engin.base.formData.CAP4FormDataManager;
import com.seeyon.cap4.form.service.CAP4FormCacheManager;
import com.seeyon.cap4.form.service.CAP4FormManager;
import com.seeyon.cap4.form.util.DynamicFieldUtil;
import com.seeyon.cap4.form.util.Enums;
import com.seeyon.cap4.template.bo.CAPBusinessTemplateBO;
import com.seeyon.cap4.template.constant.CAPBusinessEnum;
import com.seeyon.cap4.template.manager.CAPBusinessManager;
import com.seeyon.cap4.template.manager.CAPBusinessTemplate4EditManager;
import com.seeyon.cap4.template.manager.CAPBusinessTemplateManager;
import com.seeyon.cap4.template.service.CAPBatchOperationService;
import com.seeyon.cap4.template.service.CAPExportService;
import com.seeyon.cap4.template.service.CAPMallOAuthService;
import com.seeyon.cap4.template.service.CAPTemplateDataService;
import com.seeyon.ctp.cap.api.manager.CAPFormManager;
import com.seeyon.ctp.common.AppContext;
import com.seeyon.ctp.common.ModuleType;
import com.seeyon.ctp.common.controller.BaseController;
import com.seeyon.ctp.common.exceptions.BusinessException;
import com.seeyon.ctp.common.i18n.ResourceUtil;
import com.seeyon.ctp.util.FlipInfo;
import com.seeyon.ctp.util.Strings;
import com.seeyon.ctp.util.json.JSONUtil;
import com.seeyon.v3x.system.manager.WaterMarkSettingManager;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.springframework.web.servlet.ModelAndView;
import sun.misc.BASE64Decoder;

public class CAPBusinessTemplateController
extends BaseController {
    private static final Logger LOGGER = Logger.getLogger(CAPBusinessTemplateController.class);
    private CAPBusinessManager capBusinessManager;
    private CAPBusinessTemplateManager capBusinessTemplateManager;
    private CAPBusinessTemplate4EditManager capBusinessTemplate4EditManager;
    private CAPMallOAuthService capMallOAuthService;
    private CAP4FormCacheManager cap4FormCacheManager;
    private CAP4FormManager cap4FormManager;
    private CAPTemplateDataService capTemplateDataService;
    private CAP4FormDataManager cap4FormDataManager;
    private CAPBatchOperationService capBatchOperationService;
    private WaterMarkSettingManager waterMarkSettingManager;
    private CAPFormManager capFormManager;
    private CAPExportService capExportService;
    private BizPortalApi bizPortalApi;

    public void setCapFormManager(CAPFormManager capFormManager) {
        this.capFormManager = capFormManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waterMark(HttpServletRequest request, HttpServletResponse response) {
        String platform = request.getParameter("platform");
        String printFlag = request.getParameter("printFlag");
        String type = request.getParameter("type");
        type = type == null ? "form" : type;
        boolean isMobile = "2".equals(platform);
        Map resultMap = this.waterMarkSettingManager.waterMarkInfo(type, isMobile, true, false);
        ServletOutputStream os = null;
        try {
            response.setContentType("image/jpeg");
            response.setHeader("Cache-Control", "no-cache");
            response.setHeader("Pragma", "no-cache");
            os = response.getOutputStream();
            String imgStr = String.valueOf(resultMap.get("img"));
            String blankImgStr = "iVBORw0KGgoAAAANSUhEUgAAAAEAAAABCAYAAAAfFcSJAAAADUlEQVQImWNgYGBgAAAABQABh6FO1AAAAABJRU5ErkJggg==";
            if (Strings.isBlank((String)imgStr)) {
                imgStr = blankImgStr;
            } else {
                if ("1".equals(printFlag)) {
                    imgStr = Boolean.FALSE.equals(resultMap.get("print")) ? blankImgStr : imgStr;
                }
                imgStr = imgStr.replace("data:image/png;base64,", "");
            }
            BASE64Decoder decoder = new BASE64Decoder();
            byte[] b = decoder.decodeBuffer(imgStr);
            for (int i = 0; i < b.length; ++i) {
                if (b[i] >= 0) continue;
                int n = i;
                b[n] = (byte)(b[n] + 256);
            }
            os.write(b);
            os.flush();
            os.close();
            IOUtils.closeQuietly((OutputStream)os);
        }
        catch (IOException e) {
            LOGGER.error((Object)"waterMark exception", (Throwable)e);
        }
        finally {
            IOUtils.closeQuietly(os);
        }
    }

    @Deprecated
    public ModelAndView capFlowList(HttpServletRequest request, HttpServletResponse response) throws Exception {
        Long bussId = Long.parseLong(request.getParameter("businessId"));
        Long moduleId = Long.parseLong(request.getParameter("moduleId"));
        boolean hasCustomTemplate = this.capBusinessTemplateManager.isUseCustomTemplate(bussId, moduleId, CAPBusinessEnum.TemplateType.TP_FLOW.getType());
        Long pathId = moduleId;
        if (!hasCustomTemplate) {
            pathId = 0L;
        }
        ModelAndView mav = new ModelAndView("cap4/form/template/flowlist");
        mav.addObject("pathId", (Object)pathId);
        mav.addObject("bussId", (Object)bussId);
        mav.addObject("appId", (Object)moduleId);
        mav.addObject("approval", (Object)(request.getParameter("approval") == null ? "false" : String.valueOf(request.getParameter("approval"))));
        return mav;
    }

    public ModelAndView capFlowListNew(HttpServletRequest request, HttpServletResponse response) throws Exception {
        FormBean formBean;
        Long bussId = Long.parseLong(request.getParameter("businessId"));
        Long moduleId = Long.parseLong(request.getParameter("moduleId"));
        Long formId = Long.parseLong(request.getParameter("formId"));
        boolean hasCustomTemplate = this.capBusinessTemplateManager.isUseCustomTemplate(bussId, moduleId, CAPBusinessEnum.TemplateType.TP_FLOW.getType());
        Long pathId = moduleId;
        if (!hasCustomTemplate) {
            pathId = 0L;
        }
        if ((formBean = this.cap4FormCacheManager.getForm(formId)) == null || !this.cap4FormManager.isEnabled(formBean)) {
            throw new BusinessException(ResourceUtil.getString((String)"bizconfig.use.authorize.forbidden"));
        }
        if (formBean.getBind() == null) {
            throw new BusinessException(ResourceUtil.getString((String)"form.showAppFormData.noright"));
        }
        FormFlowBusinessBean flowBusinessBean = formBean.getBind().getFlowBusinessBean(String.valueOf(moduleId));
        if (flowBusinessBean == null || !flowBusinessBean.checkRight(AppContext.currentUserId())) {
            throw new BusinessException(ResourceUtil.getString((String)"form.showAppFormData.noright"));
        }
        ModelAndView mav = new ModelAndView("cap4/form/template/datalist");
        mav.addObject("pathId", (Object)pathId);
        mav.addObject("bussId", (Object)bussId);
        mav.addObject("appId", (Object)moduleId);
        mav.addObject("formId", (Object)formId);
        mav.addObject("listType", (Object)("flow" + flowBusinessBean.getType()));
        return mav;
    }

    public ModelAndView capUnflowList(HttpServletRequest request, HttpServletResponse response) throws Exception {
        FormBindAuthBean formBindAuthBean;
        FormBean formBean;
        Long bussId = Long.parseLong(request.getParameter("businessId"));
        Long moduleId = Long.parseLong(request.getParameter("moduleId"));
        Long formId = Long.parseLong(request.getParameter("formId"));
        boolean hasCustomTemplate = this.capBusinessTemplateManager.isUseCustomTemplate(bussId, moduleId, CAPBusinessEnum.TemplateType.TP_UNFLOW.getType());
        Long pathId = moduleId;
        if (!hasCustomTemplate) {
            pathId = 0L;
        }
        if ((formBean = this.cap4FormCacheManager.getForm(formId)) == null || !this.cap4FormManager.isEnabled(formBean)) {
            throw new BusinessException(ResourceUtil.getString((String)"bizconfig.use.authorize.forbidden"));
        }
        if (moduleId != null && formBean.getBind() != null && (formBindAuthBean = formBean.getBind().getUnFlowTemplateById(moduleId)) != null && !formBindAuthBean.checkRight(AppContext.currentUserId())) {
            throw new BusinessException(ResourceUtil.getString((String)"form.showAppFormData.noright"));
        }
        ModelAndView mav = new ModelAndView("cap4/form/template/unflowlist");
        mav.addObject("pathId", (Object)pathId);
        mav.addObject("bussId", (Object)bussId);
        mav.addObject("appId", (Object)moduleId);
        mav.addObject("formId", (Object)formId);
        return mav;
    }

    public ModelAndView formContent(HttpServletRequest request, HttpServletResponse response) throws Exception {
        return new ModelAndView("cap4/form/template/formcontent");
    }

    public ModelAndView businessIndex(HttpServletRequest request, HttpServletResponse response) throws Exception {
        ModelAndView mav = new ModelAndView("cap4/form/template/businessindex");
        Long bussId = Long.parseLong(request.getParameter("bussId"));
        String openPage = request.getParameter("openPage");
        if (StringUtils.isEmpty((String)openPage)) {
            List<CAPPortalSpace> list = this.bizPortalApi.findAvailableCAPPortalSpace(ContextParam.of(AppContext.getCurrentUser(), bussId, BizPortalConstants.Platform.PC));
            boolean isNew = CollectionUtils.isNotEmpty(list);
            if (isNew) {
                CAPPortalSpace space = list.get(0);
                mav.addObject("spaceId", (Object)space.getId());
                mav.addObject("hasCustomTemplate", (Object)false);
                mav.addObject("useFrame", (Object)false);
            } else {
                String templateId = request.getParameter("templateId");
                Map<String, Object> map = this.capTemplateDataService.getAuthorizeTemplatesInfo(bussId, CAPBusinessEnum.TemplateType.TP_BIZ_INDEX.getType(), templateId);
                mav.addObject("bussId", (Object)bussId);
                mav.addAllObjects(map);
            }
            mav.addObject("useNewSpace", (Object)isNew);
        } else {
            String templateId = request.getParameter("templateId");
            Map<String, Object> map = this.capTemplateDataService.getAuthorizeTemplatesInfo(bussId, CAPBusinessEnum.TemplateType.TP_BIZ_INDEX.getType(), templateId);
            mav.addObject("bussId", (Object)bussId);
            mav.addObject("useNewSpace", (Object)false);
            mav.addAllObjects(map);
        }
        return mav;
    }

    public ModelAndView businessIndexEdit(HttpServletRequest request, HttpServletResponse response) throws Exception {
        Long templateId = Long.parseLong(request.getParameter("templateId"));
        CAPBusinessTemplateBO bo = this.capBusinessTemplateManager.getCAPBusinessTemplateBOById(templateId);
        if (bo == null) {
            throw new BusinessException("\u627e\u4e0d\u5230\u6a21\u677f\uff01");
        }
        if (!this.capBusinessManager.checkBizOwnerAuth4Template(Long.valueOf(bo.getEggId()))) {
            throw new BusinessException("\u65e0\u6743\u9650\u64cd\u4f5c\uff01");
        }
        boolean isCacheEditable = this.capBusinessTemplate4EditManager.initForEdit(bo);
        BusinessManager businessManager = (BusinessManager)AppContext.getBean((String)"businessManager4");
        BizConfigBean bizConfigBean = businessManager.findBizConfigById(Long.valueOf(bo.getEggId()));
        ModelAndView mav = new ModelAndView("cap4/form/template/businessindexedit");
        mav.addObject("bussId", (Object)bo.getEggId());
        mav.addObject("templateId", (Object)bo.getId());
        mav.addObject("templateClient", (Object)bo.getClient());
        mav.addObject("isCacheEditable", (Object)isCacheEditable);
        mav.addObject("bizName", (Object)bizConfigBean.getName());
        return mav;
    }

    public ModelAndView exportReportExcel(HttpServletRequest request, HttpServletResponse response) throws Exception {
        HashMap<String, Object> params = new HashMap<String, Object>();
        for (String key : request.getParameterMap().keySet()) {
            if ("method".equals(key)) continue;
            if ("userConditions".equals(key)) {
                params.put(key, JSONUtil.parseJSONString((String)((String[])request.getParameterMap().get(key))[0], List.class));
                continue;
            }
            if ("statisticsId".equals(key)) {
                params.put("designId", ((String[])request.getParameterMap().get(key))[0]);
                continue;
            }
            params.put(key, ((String[])request.getParameterMap().get(key))[0]);
        }
        this.capTemplateDataService.exportReportExcel(params, response);
        return null;
    }

    public ModelAndView exportUnflowExcel(HttpServletRequest request, HttpServletResponse response) throws Exception {
        HashMap<String, Object> params = new HashMap<String, Object>();
        for (String key : request.getParameterMap().keySet()) {
            if ("method".equals(key)) continue;
            params.put(key, ((String[])request.getParameterMap().get(key))[0]);
        }
        this.capExportService.export(params, response);
        return null;
    }

    public ModelAndView unflowQuerySingleDataSection(HttpServletRequest request, HttpServletResponse response) throws BusinessException {
        ModelAndView mav = new ModelAndView("ctp/form/queryResult/unflowSingleDataSection");
        Long queryId = Long.valueOf(request.getParameter("queryId"));
        Long formId = Long.valueOf(request.getParameter("formId"));
        String singleType = request.getParameter("singleType");
        FormBean formBean = this.cap4FormCacheManager.getForm(formId);
        FormBindAuthBean bindAuthBean = formBean.getBind().getFormBindAuthBean(String.valueOf(queryId));
        if (bindAuthBean != null) {
            if (!bindAuthBean.checkRight(AppContext.currentUserId())) {
                LOGGER.error((Object)ResourceUtil.getString((String)"form.showAppFormData.noright"));
                throw new BusinessException(ResourceUtil.getString((String)"form.showAppFormData.noright"));
            }
            FlipInfo flipInfo = new FlipInfo();
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("formId", formBean.getId());
            params.put("formTemplateId", queryId);
            String sortStr = DynamicFieldUtil.getSortStr(bindAuthBean.getOrderByList());
            params.put("sortStr", sortStr);
            boolean reverse = false;
            if ("1".equals(singleType)) {
                reverse = true;
            }
            this.cap4FormDataManager.getFormDataList(flipInfo, params, formBean, reverse);
            List dataList = flipInfo.getData();
            if (dataList.isEmpty()) {
                return mav;
            }
            Map dataObj = (Map)dataList.get(0);
            mav.addObject("_moduleId", dataObj.get("id"));
            this.unflowSectionComm(formBean, bindAuthBean, mav, request);
        }
        return mav;
    }

    private void unflowSectionComm(FormBean formBean, FormBindAuthBean bindAuthBean, ModelAndView mav, HttpServletRequest request) {
        mav.addObject("_moduleType", (Object)ModuleType.cap4UnflowForm.getKey());
        mav.addObject("_templateName", (Object)bindAuthBean.getName());
        String rightId = "";
        if (formBean.getFormType() == Enums.FormType.unFlowForm.getKey()) {
            String showAuth = bindAuthBean.getShowFormAuth();
            if (Strings.isNotBlank((String)showAuth) && "|".equals(showAuth.substring(showAuth.length() - 1, showAuth.length()))) {
                showAuth = showAuth.substring(0, showAuth.length() - 1);
            }
            this.capFormManager.addRight(showAuth);
            rightId = showAuth.split("[|]")[0];
            if (rightId.indexOf(".") != -1) {
                rightId = rightId.split("[.]")[1];
            }
            ArrayList<SimpleObjectBean> editAuth = bindAuthBean.getUpdateAuthList();
            ArrayList<SimpleObjectBean> cloneEditAuth = new ArrayList<SimpleObjectBean>();
            for (SimpleObjectBean s : editAuth) {
                SimpleObjectBean c = null;
                try {
                    c = (SimpleObjectBean)s.clone();
                }
                catch (CloneNotSupportedException e) {
                    LOGGER.error((Object)e.getMessage(), (Throwable)e);
                }
                if (null != c) {
                    if (Strings.isEmpty((String)c.getDisplay())) {
                        c.setDisplay(ResourceUtil.getString((String)"application.92.label"));
                    }
                    this.capFormManager.addRight(c.getPhoneValue());
                    this.capFormManager.addRight(c.getValue());
                }
                cloneEditAuth.add(c);
            }
            editAuth = cloneEditAuth;
            mav.addObject("editAuth", (Object)JSONUtil.toJSONString(editAuth));
        }
        this.capFormManager.addRight(rightId);
        mav.addObject("_rightId", (Object)rightId);
        mav.addObject("_formId", (Object)request.getParameter("formId"));
        mav.addObject("_formTemplateId", (Object)request.getParameter("queryId"));
    }

    public ModelAndView mallOAuthCertificated(HttpServletRequest request, HttpServletResponse response) throws Exception {
        ModelAndView mav = new ModelAndView("cap4/form/template/certificated");
        mav.addObject("data", this.capMallOAuthService.certificated(request));
        return mav;
    }

    public void setCapBusinessTemplateManager(CAPBusinessTemplateManager capBusinessTemplateManager) {
        this.capBusinessTemplateManager = capBusinessTemplateManager;
    }

    public void setCapMallOAuthService(CAPMallOAuthService capMallOAuthService) {
        this.capMallOAuthService = capMallOAuthService;
    }

    public void setCap4FormCacheManager(CAP4FormCacheManager cap4FormCacheManager) {
        this.cap4FormCacheManager = cap4FormCacheManager;
    }

    public void setCap4FormManager(CAP4FormManager cap4FormManager) {
        this.cap4FormManager = cap4FormManager;
    }

    public void setCapTemplateDataService(CAPTemplateDataService capTemplateDataService) {
        this.capTemplateDataService = capTemplateDataService;
    }

    public void setCap4FormDataManager(CAP4FormDataManager cap4FormDataManager) {
        this.cap4FormDataManager = cap4FormDataManager;
    }

    public void setCapBatchOperationService(CAPBatchOperationService capBatchOperationService) {
        this.capBatchOperationService = capBatchOperationService;
    }

    public void setCapBusinessTemplate4EditManager(CAPBusinessTemplate4EditManager capBusinessTemplate4EditManager) {
        this.capBusinessTemplate4EditManager = capBusinessTemplate4EditManager;
    }

    public void setCapBusinessManager(CAPBusinessManager capBusinessManager) {
        this.capBusinessManager = capBusinessManager;
    }

    public void setWaterMarkSettingManager(WaterMarkSettingManager waterMarkSettingManager) {
        this.waterMarkSettingManager = waterMarkSettingManager;
    }

    public void setCapExportService(CAPExportService capExportService) {
        this.capExportService = capExportService;
    }

    public void setBizPortalApi(BizPortalApi bizPortalApi) {
        this.bizPortalApi = bizPortalApi;
    }
}

