/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.cap4.template.dao.impl;

import com.seeyon.cap4.template.dao.CAPBusinessElementDAO;
import com.seeyon.cap4.template.po.CAPBusinessElement;
import com.seeyon.ctp.common.exceptions.BusinessException;
import com.seeyon.ctp.util.DBAgent;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CAPBusinessElementDAOImpl
implements CAPBusinessElementDAO {
    @Override
    public void insertCAPBusinessElements(List<CAPBusinessElement> capBusinessElements) throws BusinessException {
        DBAgent.saveAll(capBusinessElements);
    }

    @Override
    public List<CAPBusinessElement> getCAPBusinessElementsByColumnId(Long columnId) throws BusinessException {
        StringBuilder hql = new StringBuilder("from CAPBusinessElement cbe where cbe.columnId = :columnId");
        HashMap<String, Long> params = new HashMap<String, Long>();
        params.put("columnId", columnId);
        return DBAgent.find((String)hql.toString(), params);
    }

    @Override
    public void deleteCAPBusinessElements(List<CAPBusinessElement> capBusinessElements) throws BusinessException {
        DBAgent.deleteAll(capBusinessElements);
    }

    @Override
    public List<CAPBusinessElement> getCAPBusinessElementsByColumnIds(List<Long> columnIds) throws BusinessException {
        if (columnIds == null || columnIds.size() == 0) {
            return null;
        }
        StringBuilder hql = new StringBuilder("from CAPBusinessElement cbe where cbe.columnId IN (:columnIds) ");
        HashMap<String, List<Long>> params = new HashMap<String, List<Long>>();
        params.put("columnIds", columnIds);
        return DBAgent.find((String)hql.toString(), params);
    }

    @Override
    public List<CAPBusinessElement> getCAPBusinessElementsByElementIds(List<Long> elementIds) throws BusinessException {
        if (elementIds == null || elementIds.size() == 0) {
            return null;
        }
        StringBuilder hql = new StringBuilder("from CAPBusinessElement cbe where cbe.id IN (:elementIds) ");
        HashMap<String, List<Long>> params = new HashMap<String, List<Long>>();
        params.put("elementIds", elementIds);
        return DBAgent.find((String)hql.toString(), params);
    }

    @Override
    public void updateCAPBusinessElements(List<CAPBusinessElement> capBusinessElements) throws BusinessException {
        DBAgent.updateAll(capBusinessElements);
    }

    @Override
    public List<CAPBusinessElement> getConfigedCAPBusinessElementsByParams(Map<String, Object> params) throws BusinessException {
        if (params == null || params.size() == 0) {
            return null;
        }
        StringBuilder hql = new StringBuilder("SELECT cbe FROM CAPBusinessElement cbe , CAPBusinessColumn cbc ");
        hql.append(" WHERE cbc.id = cbe.columnId AND cbe.elementType =:elementType ");
        hql.append(" AND cbe.name = :name");
        hql.append(" AND cbc.id IN (:columnId)");
        hql.append(" AND cbe.dataInfo IS NOT NULL");
        if (params.containsKey("columnName")) {
            hql.append(" AND cbc.name = :columnName ");
        }
        return DBAgent.find((String)hql.toString(), params);
    }
}

