/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.cap4.template.dao.impl;

import com.seeyon.cap4.template.dao.CAPBusinessTemplateDAO;
import com.seeyon.cap4.template.po.CAPBusinessTemplate;
import com.seeyon.ctp.common.exceptions.BusinessException;
import com.seeyon.ctp.util.DBAgent;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;

public class CAPBusinessTemplateDAOImpl
implements CAPBusinessTemplateDAO {
    @Override
    public void insertCAPBusinessTemplate(CAPBusinessTemplate capBusinessTemplate) throws BusinessException {
        DBAgent.save((Object)((Object)capBusinessTemplate));
    }

    @Override
    public void insertCAPBusinessTemplates(List<CAPBusinessTemplate> capBusinessTemplates) throws BusinessException {
        DBAgent.saveAll(capBusinessTemplates);
    }

    @Override
    public void updateCAPBusinessTemplates(List<CAPBusinessTemplate> capBusinessTemplates) throws BusinessException {
        DBAgent.updateAll(capBusinessTemplates);
    }

    @Override
    public void updateCAPBusinessTemplate(CAPBusinessTemplate capBusinessTemplate) throws BusinessException {
        DBAgent.update((Object)((Object)capBusinessTemplate));
    }

    @Override
    public CAPBusinessTemplate getCAPBusinessTemplateById(Long templateId) throws BusinessException {
        return (CAPBusinessTemplate)((Object)DBAgent.get(CAPBusinessTemplate.class, (Serializable)templateId));
    }

    @Override
    public List<CAPBusinessTemplate> getCAPBusinessTemplatesByBizId(Long bizId) throws BusinessException {
        StringBuilder hql = new StringBuilder("from CAPBusinessTemplate cbt where cbt.eggId = :bizId");
        HashMap<String, Long> params = new HashMap<String, Long>();
        params.put("bizId", bizId);
        hql.append(" order by cbt.sort ASC , cbt.name ASC");
        return DBAgent.find((String)hql.toString(), params);
    }

    @Override
    public List<CAPBusinessTemplate> getCAPBusinessTemplatesByIds(List<Long> templateIds) throws BusinessException {
        if (templateIds == null || templateIds.size() == 0) {
            return null;
        }
        StringBuilder hql = new StringBuilder("from CAPBusinessTemplate cbt where cbt.id IN ( :templateIds )");
        HashMap<String, List<Long>> params = new HashMap<String, List<Long>>();
        params.put("templateIds", templateIds);
        return DBAgent.find((String)hql.toString(), params);
    }

    @Override
    public void deleteCAPBusinessTemplate(CAPBusinessTemplate capBusinessTemplate) throws BusinessException {
        DBAgent.delete((Object)((Object)capBusinessTemplate));
    }

    @Override
    public void deleteCAPBusinessTemplatesByTemplateIds(List<Long> templateIds) throws BusinessException {
        StringBuilder hql = new StringBuilder("delete from CAPBusinessTemplate cbt where cbt.id IN ( :templateIds )");
        HashMap<String, List<Long>> params = new HashMap<String, List<Long>>();
        params.put("templateIds", templateIds);
        DBAgent.bulkUpdate((String)hql.toString(), params);
    }

    @Override
    public int getMaxSortByBizIdAndTemplateType(Long eggId, Integer templateType) throws BusinessException {
        StringBuilder hql = new StringBuilder("select max(sort) from CAPBusinessTemplate cbt where cbt.templateType = :templateType and cbt.eggId = :eggId");
        HashMap<String, Number> params = new HashMap<String, Number>();
        params.put("templateType", templateType);
        params.put("eggId", eggId);
        List list = DBAgent.find((String)hql.toString(), params);
        return list == null || list.get(0) == null ? 0 : (Integer)list.get(0);
    }

    @Override
    public CAPBusinessTemplate getCAPBusinessTemplateByPathIdAndTypeAndClient(Long pathId, Integer templateType, Integer client) throws BusinessException {
        StringBuilder hql = new StringBuilder("from CAPBusinessTemplate cbt where cbt.pathId = :pathId and cbt.templateType = :templateType and cbt.client = :client");
        HashMap<String, Number> params = new HashMap<String, Number>();
        params.put("templateType", templateType);
        params.put("client", client);
        params.put("pathId", pathId);
        List list = DBAgent.find((String)hql.toString(), params);
        return list == null || list.size() == 0 || list.get(0) == null ? null : (CAPBusinessTemplate)((Object)list.get(0));
    }

    @Override
    public List<CAPBusinessTemplate> getCAPBusinessTemplateByPathIdAndType(Long pathId, Integer templateType) throws BusinessException {
        StringBuilder hql = new StringBuilder("from CAPBusinessTemplate cbt where cbt.pathId = :pathId and cbt.templateType = :templateType");
        HashMap<String, Number> params = new HashMap<String, Number>();
        params.put("templateType", templateType);
        params.put("pathId", pathId);
        return DBAgent.find((String)hql.toString(), params);
    }

    @Override
    public List<CAPBusinessTemplate> getCAPBusinessTemplateByPathIdsAndType(List<Long> pathIds, Integer templateType) throws BusinessException {
        StringBuilder hql = new StringBuilder("from CAPBusinessTemplate cbt where cbt.templateType = :templateType and cbt.pathId in (:pathIds)");
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("templateType", templateType);
        params.put("pathIds", pathIds);
        return DBAgent.find((String)hql.toString(), params);
    }

    @Override
    public List<CAPBusinessTemplate> getCAPBusinessTemplatesByGoodId(List<Long> goodIds) throws BusinessException {
        StringBuilder hql = new StringBuilder("from CAPBusinessTemplate cbt where cbt.goodId IN (:goodIds)");
        HashMap<String, List<Long>> params = new HashMap<String, List<Long>>();
        params.put("goodIds", goodIds);
        return DBAgent.find((String)hql.toString(), params);
    }
}

