/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.cap4.template.manager.impl;

import com.seeyon.cap4.form.bean.FormBean;
import com.seeyon.cap4.form.bean.FormFieldBean;
import com.seeyon.cap4.form.bean.FormFieldComEnum;
import com.seeyon.cap4.form.util.Enums;
import com.seeyon.cap4.template.bean.FormDataListFormatBean;
import com.seeyon.cap4.template.util.CAPAttachmentUtil;
import com.seeyon.cap4.template.vo.ListFieldVO;
import com.seeyon.ctp.common.SystemEnvironment;
import com.seeyon.ctp.common.ctpenumnew.manager.EnumManager;
import com.seeyon.ctp.common.exceptions.BusinessException;
import com.seeyon.ctp.common.filemanager.manager.AttachmentManager;
import com.seeyon.ctp.common.i18n.ResourceUtil;
import com.seeyon.ctp.common.po.ctpenumnew.CtpEnumItem;
import com.seeyon.ctp.common.taglibs.functions.Functions;
import com.seeyon.ctp.organization.manager.OrgManager;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;

public abstract class AbstractCAPDataListFormatManager {
    protected OrgManager orgManager;
    protected EnumManager enumManagerNew;
    protected AttachmentManager attachmentManager;

    public abstract Object getConstantFieldValue(int var1, String var2, Map<String, Object> var3) throws Exception;

    protected Object getEnumImageValue(Object value, FormFieldBean fieldBean, Set<String> displayImageFields) throws BusinessException {
        CtpEnumItem ctpEnumItem;
        if (value != null && displayImageFields.contains(fieldBean.getName()) && (ctpEnumItem = this.enumManagerNew.getCacheEnumItem(Long.valueOf(Long.parseLong(value.toString())))) != null) {
            HashMap<String, String> enumInfo = new HashMap<String, String>();
            enumInfo.put("id", String.valueOf(ctpEnumItem.getId()));
            enumInfo.put("showValue", ResourceUtil.getString((String)ctpEnumItem.getShowvalue()));
            enumInfo.put("enumValue", ctpEnumItem.getValue());
            enumInfo.put("level", String.valueOf(ctpEnumItem.getLevelNum()));
            enumInfo.put("imageUrl", SystemEnvironment.getContextPath() + "/fileUpload.do?method=showRTE&fileId=" + ctpEnumItem.getImageId() + "&type=image" + Functions.csrfSuffix());
            return enumInfo;
        }
        return value;
    }

    protected Object resetEnumImageValue(Object v, Map<String, Object> fieldData) {
        Object value = null;
        if (v != null) {
            if (v instanceof Map) {
                fieldData.putAll((Map)v);
                value = ((Map)v).get("imageUrl");
            } else {
                value = v;
            }
        }
        return value;
    }

    protected Object getFormFieldDisplayValue(FormBean formBean, FormFieldBean fieldBean, Map<String, Object> dataMap, String fieldAuth, Set<String> displayImageFields, FormDataListFormatBean paramFormatBean, Map<String, List<Map<String, String>>> capFormAttachmentsMap) throws Exception {
        boolean isBatchUpdate = paramFormatBean.isBatchUpdate();
        boolean forExport = paramFormatBean.isForExport();
        boolean forCalc = paramFormatBean.isForCalc();
        Object value = dataMap.get(fieldBean.getName());
        if (fieldBean.isMasterField() && fieldBean.isConstantField()) {
            value = this.getConstantFieldValue(formBean.getFormType(), fieldBean.getName(), dataMap);
        } else if (Enums.FieldAccessType.hide.getKey().equals(fieldAuth) && !isBatchUpdate) {
            value = "*";
        } else if (!forExport && fieldBean.isImageEnumField()) {
            value = this.getEnumImageValue(value, fieldBean, displayImageFields);
        } else if (!forExport && FormFieldComEnum.EXTEND_IMAGE.getKey().equals(fieldBean.getInputType())) {
            value = capFormAttachmentsMap.get(String.valueOf(value));
        } else {
            Object[] values = fieldBean.getDisplayValue(value, false, forExport, forCalc);
            value = values[1];
        }
        return value;
    }

    protected boolean hasImageField(List<ListFieldVO> fieldVOList) {
        boolean result = false;
        if (CollectionUtils.isNotEmpty(fieldVOList)) {
            for (ListFieldVO vo : fieldVOList) {
                if (!FormFieldComEnum.EXTEND_IMAGE.getKey().equals(vo.getInputType())) continue;
                result = true;
                break;
            }
        }
        return result;
    }

    protected Map<String, List<Map<String, String>>> getDataAttachmentMap(List<Map<String, Object>> formDataList, boolean hasImageField, String idKey) {
        if (CollectionUtils.isEmpty(formDataList) || !hasImageField) {
            return new HashMap<String, List<Map<String, String>>>();
        }
        ArrayList<Long> references = new ArrayList<Long>();
        for (Map<String, Object> dataMap : formDataList) {
            references.add(Long.parseLong(MapUtils.getString(dataMap, (Object)idKey)));
        }
        List attachmentList = this.attachmentManager.getByReference(references);
        return CAPAttachmentUtil.buildAttachmentSubReferenceToListMap(attachmentList, false);
    }

    protected Set<String> getDisplayImageFields(FormBean formBean, List<ListFieldVO> fieldVOList) {
        HashSet<String> displayImageFields = new HashSet<String>();
        if (CollectionUtils.isNotEmpty(fieldVOList)) {
            for (ListFieldVO vo : fieldVOList) {
                FormFieldBean fieldBean;
                if (!vo.getFieldName().contains("field") || (fieldBean = formBean.getFieldBeanByName(vo.getFieldName())) == null || !fieldBean.isImageEnumField()) continue;
                displayImageFields.add(fieldBean.getName());
            }
        }
        return displayImageFields;
    }

    public void setOrgManager(OrgManager orgManager) {
        this.orgManager = orgManager;
    }

    public void setEnumManagerNew(EnumManager enumManagerNew) {
        this.enumManagerNew = enumManagerNew;
    }

    public void setAttachmentManager(AttachmentManager attachmentManager) {
        this.attachmentManager = attachmentManager;
    }
}

