/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.cap4.template.manager.impl;

import com.seeyon.cap4.form.bean.FormFieldBean;
import com.seeyon.cap4.form.bean.FormFieldComEnum;
import com.seeyon.cap4.form.modules.engin.base.formData.CAP4FormDataManager;
import com.seeyon.cap4.form.service.CAP4FormCacheManager;
import com.seeyon.cap4.form.service.CAP4FormManager;
import com.seeyon.cap4.template.constant.CAPBusinessEnum;
import com.seeyon.cap4.template.manager.CAPExportManager;
import com.seeyon.cap4.template.manager.impl.AbstractCAPImportExportManager;
import com.seeyon.ctp.common.ctpenumnew.manager.EnumManager;
import com.seeyon.ctp.common.exceptions.BusinessException;
import com.seeyon.ctp.common.log.CtpLogFactory;
import com.seeyon.ctp.common.po.ctpenumnew.CtpEnumItem;
import com.seeyon.ctp.util.UUIDLong;
import java.util.LinkedHashSet;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.poi.ss.usermodel.DataValidation;
import org.apache.poi.ss.usermodel.DataValidationConstraint;
import org.apache.poi.ss.util.CellRangeAddressList;
import org.apache.poi.xssf.usermodel.XSSFDataValidation;
import org.apache.poi.xssf.usermodel.XSSFDataValidationConstraint;
import org.apache.poi.xssf.usermodel.XSSFDataValidationHelper;
import org.apache.poi.xssf.usermodel.XSSFName;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public abstract class AbstractCAPExportManager<T, V>
extends AbstractCAPImportExportManager
implements CAPExportManager<T, V> {
    private static final Log LOGGER = CtpLogFactory.getLog(AbstractCAPExportManager.class);
    protected static final int TOTAL_LINE = 10000;
    protected static final String REMARKS_TEMPLATE = "cap.form.batchOperation.remarksTemplate";
    protected static final String ERROR_EXPLAIN = "cap.form.batchOperation.errorExplain";
    protected CAP4FormCacheManager cap4FormCacheManager;
    protected EnumManager enumManagerNew;
    protected CAP4FormDataManager cap4FormDataManager;
    protected CAP4FormManager cap4FormManager;

    protected String[] getFieldEnum(FormFieldBean formFieldBean) throws BusinessException {
        Long enumId = formFieldBean.getEnumId();
        List ctpEnumItems = formFieldBean.getIsFinalChild() ? this.enumManagerNew.getLastCtpEnumItem(enumId) : this.enumManagerNew.getCtpEnumItem(enumId, formFieldBean.getEnumLevel());
        LinkedHashSet<String> showValues = new LinkedHashSet<String>();
        for (CtpEnumItem ctpEnumItem : ctpEnumItems) {
            if (ctpEnumItem.getState() != 1) continue;
            showValues.add(ctpEnumItem.getShowvalue());
        }
        return showValues.toArray(new String[showValues.size()]);
    }

    protected void setEnumValidation(XSSFWorkbook xssfWorkbook, XSSFSheet firstSheet, FormFieldBean formFieldBean, int firstRow, int col) throws BusinessException {
        if (formFieldBean.isEnumField()) {
            String[] enums = this.getFieldEnum(formFieldBean);
            this.setXSSFValidation(xssfWorkbook, firstSheet, enums, firstRow, 10000, col, col);
        } else if (FormFieldComEnum.CHECKBOX.getKey().equals(formFieldBean.getInputType())) {
            String[] enums = new String[]{CAPBusinessEnum.CheckBoxEnum.CHECK.getDisplay(), CAPBusinessEnum.CheckBoxEnum.UN_CHECK.getDisplay()};
            this.setXSSFValidation(xssfWorkbook, firstSheet, enums, firstRow, 10000, col, col);
        }
    }

    protected XSSFSheet setXSSFValidation(XSSFWorkbook xssfWorkbook, XSSFSheet xssfSheet, String[] textList, int firstRow, int endRow, int firstCol, int endCol) {
        String nameId = String.valueOf(UUIDLong.longUUID());
        if (nameId.startsWith("-")) {
            nameId = nameId.substring(1);
        }
        String hiddenSheetName = "_" + nameId;
        XSSFSheet hiddenSheet = xssfWorkbook.createSheet(hiddenSheetName);
        int length = textList.length;
        for (int i = 0; i < length; ++i) {
            hiddenSheet.createRow(endRow + i).createCell(endCol).setCellValue(textList[i]);
        }
        XSSFName hiddenName = xssfWorkbook.createName();
        hiddenName.setNameName(hiddenSheetName);
        hiddenName.setRefersToFormula(hiddenSheetName + "!A1:A" + (textList.length + endRow));
        XSSFDataValidationHelper dvHelper = new XSSFDataValidationHelper(xssfSheet);
        XSSFDataValidationConstraint dvConstraint = (XSSFDataValidationConstraint)dvHelper.createFormulaListConstraint(hiddenSheetName);
        CellRangeAddressList addressList = new CellRangeAddressList(firstRow, endRow, firstCol, endCol);
        XSSFDataValidation validation = (XSSFDataValidation)dvHelper.createValidation((DataValidationConstraint)dvConstraint, addressList);
        validation.setSuppressDropDownArrow(true);
        validation.setShowErrorBox(true);
        int currentSheetIndex = xssfWorkbook.getSheetIndex(hiddenSheetName);
        xssfWorkbook.setSheetHidden(currentSheetIndex, true);
        xssfSheet.addValidationData((DataValidation)validation);
        return xssfSheet;
    }

    public void setCap4FormCacheManager(CAP4FormCacheManager cap4FormCacheManager) {
        this.cap4FormCacheManager = cap4FormCacheManager;
    }

    public void setEnumManagerNew(EnumManager enumManagerNew) {
        this.enumManagerNew = enumManagerNew;
    }

    public void setCap4FormDataManager(CAP4FormDataManager cap4FormDataManager) {
        this.cap4FormDataManager = cap4FormDataManager;
    }

    public void setCap4FormManager(CAP4FormManager cap4FormManager) {
        this.cap4FormManager = cap4FormManager;
    }
}

