/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.cap4.template.manager.impl;

import com.seeyon.cap4.form.bean.FormBean;
import com.seeyon.cap4.form.bean.FormFieldBean;
import com.seeyon.cap4.form.bean.FormFieldComEnum;
import com.seeyon.cap4.form.bean.FormTableBean;
import com.seeyon.cap4.form.util.sqlite.CAPSQLiteUtil;
import com.seeyon.cap4.template.manager.CAPExcelManager;
import com.seeyon.cap4.template.manager.CAPImportUniqueManager;
import com.seeyon.ctp.common.AppContext;
import com.seeyon.ctp.common.log.CtpLogFactory;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.logging.Log;

public abstract class AbstractCAPImportExportManager {
    private static final Log LOGGER = CtpLogFactory.getLog(AbstractCAPImportExportManager.class);
    public static final String CODE = "3000";
    public static final String MESSAGE = "this option is success!";
    public static final String CODE1 = "3001";
    public static final String MESSAGE1 = "this param %s is null!";
    public static final String CODE2 = "3002";
    public static final String MESSAGE2 = "%s option exception!";
    public static final String CODE3 = "3003";
    public static final String MESSAGE3 = "excel data is empty";
    public static final String CODE4 = "3004";
    public static final String MESSAGE4 = "more than %s lines!";
    public static final String CODE5 = "3005";
    public static final String MESSAGE5 = "non excel standard template!";
    public static final String CODE6 = "3006";
    public static final String MESSAGE6 = "%s table not exist!";
    protected static final int TOTAL_LINE = 10000;
    protected static Set<FormFieldComEnum> importNotSupportedField = new HashSet<FormFieldComEnum>();
    protected CAPExcelManager capExcelManager;
    protected CAPImportUniqueManager capImportUniqueManager;

    protected String getDbName(String tableName, String typeName) {
        return tableName + "_" + AppContext.currentUserId() + ".db";
    }

    protected void deleteTable(FormBean formBean, Connection connection) {
        try {
            if (formBean != null && connection != null) {
                if (CAPSQLiteUtil.isExistTable((Connection)connection, (String)formBean.getMasterTableBean().getTableName())) {
                    CAPSQLiteUtil.deleteTable((Connection)connection, (String)formBean.getMasterTableBean().getTableName());
                }
                List subTableBeans = formBean.getSubTableBean();
                for (FormTableBean formTableBean : subTableBeans) {
                    if (!CAPSQLiteUtil.isExistTable((Connection)connection, (String)formTableBean.getTableName())) continue;
                    CAPSQLiteUtil.deleteTable((Connection)connection, (String)formTableBean.getTableName());
                }
                this.capImportUniqueManager.deleteTable(connection);
            }
        }
        catch (SQLException e) {
            LOGGER.error((Object)"deleteTable.SQLException", (Throwable)e);
        }
    }

    protected String trim(String value) {
        int st;
        if (value == null) {
            return "";
        }
        int len = value.length();
        char[] val = value.toCharArray();
        for (st = 0; st < len && val[st] == ' ' || st < len && val[st] == '\u3000'; ++st) {
        }
        while (st < len && val[len - 1] == ' ' || st < len && val[len - 1] == '\u3000') {
            --len;
        }
        return st > 0 || len < value.length() ? value.substring(st, len) : value;
    }

    public boolean checkImportSupportField(FormFieldBean formFieldBean) {
        return formFieldBean != null && !importNotSupportedField.contains(formFieldBean.getInputTypeEnum());
    }

    public boolean checkImportSupportSubField(FormFieldBean formFieldBean) {
        return this.checkImportSupportField(formFieldBean);
    }

    public boolean checkExportSubField(FormFieldBean formFieldBean) {
        boolean result = true;
        if (formFieldBean == null) {
            result = false;
        } else {
            FormFieldComEnum formFieldComEnum = formFieldBean.getInputTypeEnum();
            switch (formFieldComEnum) {
                case TEXTAREA: 
                case EXTEND_MULTI_DEPARTMENT: 
                case EXTEND_MULTI_LEVEL: 
                case EXTEND_MULTI_POST: 
                case EXTEND_MULTI_MEMBER: 
                case EXTEND_MULTI_ACCOUNT: {
                    if (!formFieldBean.isLongTextField()) break;
                    result = false;
                    break;
                }
                case TEXT: 
                case EXTEND_DATE: 
                case EXTEND_DATETIME: 
                case CHECKBOX: 
                case SELECT: 
                case RADIO: 
                case IMAGE_SELECT: 
                case IMAGE_RADIO: 
                case EXTEND_DEPARTMENT: 
                case EXTEND_LEVEL: 
                case EXTEND_POST: 
                case EXTEND_MEMBER: 
                case EXTEND_ACCOUNT: {
                    result = true;
                    break;
                }
                default: {
                    result = false;
                }
            }
        }
        return result;
    }

    public void setCapImportUniqueManager(CAPImportUniqueManager capImportUniqueManager) {
        this.capImportUniqueManager = capImportUniqueManager;
    }

    public void setCapExcelManager(CAPExcelManager capExcelManager) {
        this.capExcelManager = capExcelManager;
    }

    static {
        importNotSupportedField.add(FormFieldComEnum.CUSTOM_CONTROL);
        importNotSupportedField.add(FormFieldComEnum.MAP_MARKED);
        importNotSupportedField.add(FormFieldComEnum.MAP_LOCATE);
        importNotSupportedField.add(FormFieldComEnum.MAP_PHOTO);
        importNotSupportedField.add(FormFieldComEnum.EXTEND_DOCUMENT);
        importNotSupportedField.add(FormFieldComEnum.EXTEND_IMAGE);
        importNotSupportedField.add(FormFieldComEnum.EXTEND_ATTACHMENT);
        importNotSupportedField.add(FormFieldComEnum.FLOWDEALOPITION);
        importNotSupportedField.add(FormFieldComEnum.LINE_NUMBER);
    }
}

