/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.cap4.template.manager.impl;

import com.seeyon.cap4.form.bean.FormBean;
import com.seeyon.cap4.form.bean.FormFieldBean;
import com.seeyon.cap4.form.bean.FormFieldComEnum;
import com.seeyon.cap4.form.bean.FormTableBean;
import com.seeyon.cap4.form.bean.FormViewBean;
import com.seeyon.cap4.form.bean.ImpResultBean;
import com.seeyon.cap4.form.bean.fieldCtrl.FormFieldUtil;
import com.seeyon.cap4.form.service.CAP4FormCacheManager;
import com.seeyon.cap4.form.service.CAP4FormManager;
import com.seeyon.cap4.form.util.Enums;
import com.seeyon.cap4.form.util.sqlite.CAPSQLiteUtil;
import com.seeyon.cap4.template.bean.ImportPromptBean;
import com.seeyon.cap4.template.bean.ImportUniqueBean;
import com.seeyon.cap4.template.constant.CAPBusinessEnum;
import com.seeyon.cap4.template.manager.CAPDataListSqlHelpManager;
import com.seeyon.cap4.template.manager.impl.AbstractCAPImportExportManager;
import com.seeyon.cap4.template.vo.ExportTableLineDataVO;
import com.seeyon.cap4.template.vo.ImportFieldVO;
import com.seeyon.ctp.common.AppContext;
import com.seeyon.ctp.common.ModuleType;
import com.seeyon.ctp.common.ctpenumnew.manager.EnumManager;
import com.seeyon.ctp.common.excel.FileToExcelManager;
import com.seeyon.ctp.common.exceptions.BusinessException;
import com.seeyon.ctp.common.filemanager.manager.FileManager;
import com.seeyon.ctp.common.i18n.ResourceUtil;
import com.seeyon.ctp.common.log.CtpLogFactory;
import com.seeyon.ctp.common.po.content.CtpContentAll;
import com.seeyon.ctp.common.po.ctpenumnew.CtpEnumItem;
import com.seeyon.ctp.form.po.FormRelation;
import com.seeyon.ctp.util.DateUtil;
import com.seeyon.ctp.util.FlipInfo;
import com.seeyon.ctp.util.Strings;
import com.seeyon.ctp.util.json.JSONUtil;
import java.io.UnsupportedEncodingException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;

public abstract class AbstractCAPImportManager
extends AbstractCAPImportExportManager {
    private static final Log LOGGER = CtpLogFactory.getLog(AbstractCAPImportManager.class);
    protected CAP4FormCacheManager cap4FormCacheManager;
    protected FileManager fileManager;
    protected FileToExcelManager fileToExcelManager;
    protected CAP4FormManager cap4FormManager;
    protected EnumManager enumManagerNew;
    protected CAPDataListSqlHelpManager capDataListSqlHelpManager;
    private static final Date DATE = DateUtil.toDate((String)"1900-01-01", (String)"yyyy-MM-dd");
    private static final Date DATE_TIME = DateUtil.toDate((String)"1900-01-01 00:00:00", (String)"yyyy-MM-dd HH:mm:ss");
    protected static final String ERROR_FILE_NAME = "cap.form.batchOperation.errorFileName";

    protected Map<String, FormFieldBean> getTableFieldBeans(FormBean formBean, FormViewBean formViewBean, String tableName) {
        HashMap<String, FormFieldBean> fieldBeanMap = new HashMap<String, FormFieldBean>();
        if (Strings.isNotBlank((String)tableName)) {
            List fieldList = formViewBean.getFieldBeanList(formBean, tableName);
            for (FormFieldBean fieldBean : fieldList) {
                if (fieldBean == null) continue;
                fieldBeanMap.put(fieldBean.getName(), fieldBean);
            }
        }
        return fieldBeanMap;
    }

    protected ImportFieldVO getFieldValue(FormFieldBean formFieldBean, String showValue) throws BusinessException {
        ImpResultBean impResultBean;
        boolean isMultiOrg = formFieldBean.getFieldCtrl().getKey().contains("multi");
        if (isMultiOrg && showValue != null) {
            String[] values;
            HashMap<String, String> tempValueMap = new HashMap<String, String>();
            ArrayList<String> valueList = new ArrayList<String>();
            for (String value : values = showValue.split("(,)")) {
                if (tempValueMap.get(value) != null) continue;
                valueList.add(value);
                tempValueMap.put(value, value);
            }
            showValue = StringUtils.join(valueList, (String)",");
        }
        if ((impResultBean = formFieldBean.getValue4Import((Object)showValue, false)) == null) {
            return new ImportFieldVO("", "", CAPBusinessEnum.BatchValidateRulesEnum.VALIDATE_SUCCESS.getType());
        }
        Object object = impResultBean.getResult();
        return new ImportFieldVO(object == null ? "" : object, showValue, this.checkFormExcelDatas(formFieldBean, showValue, object));
    }

    private String checkFormExcelDatas(FormFieldBean formFieldBean, String value, Object dbValue) {
        String result = CAPBusinessEnum.BatchValidateRulesEnum.VALIDATE_SUCCESS.getType();
        FormFieldComEnum formFieldComEnum = formFieldBean.getInputTypeEnum();
        switch (formFieldComEnum) {
            case RADIO: 
            case SELECT: 
            case IMAGE_SELECT: 
            case IMAGE_RADIO: {
                if (dbValue != null && !Strings.isBlank((String)String.valueOf(dbValue))) break;
                result = CAPBusinessEnum.BatchValidateRulesEnum.VALUE_MISMATCH_ERROR.getType();
                break;
            }
            case EXTEND_MEMBER: 
            case EXTEND_MULTI_MEMBER: 
            case EXTEND_ACCOUNT: 
            case EXTEND_MULTI_ACCOUNT: 
            case EXTEND_DEPARTMENT: 
            case EXTEND_MULTI_DEPARTMENT: 
            case EXTEND_POST: 
            case EXTEND_MULTI_POST: 
            case EXTEND_LEVEL: 
            case EXTEND_MULTI_LEVEL: {
                if (dbValue != null && !Strings.isBlank((String)String.valueOf(dbValue))) break;
                result = CAPBusinessEnum.BatchValidateRulesEnum.CONTROL_ERROR.getType();
                break;
            }
            case TEXT: 
            case TEXTAREA: {
                try {
                    if (Enums.FieldType.DECIMAL.getKey().equals(formFieldBean.getFieldType())) {
                        String checkFormat = FormFieldUtil.checkFormat((String)formFieldBean.getInputType(), (String)formFieldBean.getFieldType(), (String)value, (boolean)true);
                        if (Strings.isNotBlank((String)checkFormat)) {
                            result = CAPBusinessEnum.BatchValidateRulesEnum.FORMAT_ERROR.getType();
                            break;
                        }
                        if (dbValue != null && !this.checkDataLength(formFieldBean, value)) {
                            result = CAPBusinessEnum.BatchValidateRulesEnum.FIELD_LENGTH_ERROR.getType();
                            break;
                        }
                        if (FormFieldUtil.checkNumberDigitLength((FormFieldBean)formFieldBean, (Object)dbValue)) break;
                        result = CAPBusinessEnum.BatchValidateRulesEnum.DECIMAL_DIGITS_ERROR.getType();
                        break;
                    }
                    if (dbValue == null || this.checkDataLength(formFieldBean, value)) break;
                    result = CAPBusinessEnum.BatchValidateRulesEnum.FIELD_LENGTH_ERROR.getType();
                }
                catch (Exception e) {
                    result = CAPBusinessEnum.BatchValidateRulesEnum.FORMAT_ERROR.getType();
                }
                break;
            }
            case EXTEND_DATE: {
                String checkDateFormat = FormFieldUtil.checkFormat((String)formFieldBean.getInputType(), (String)formFieldBean.getFieldType(), (String)value, (boolean)true);
                if (Strings.isNotBlank((String)checkDateFormat)) {
                    result = CAPBusinessEnum.BatchValidateRulesEnum.FORMAT_ERROR.getType();
                    break;
                }
                Date dateTimeVale = DateUtil.toDate((String)value, (String)"yyyy-MM-dd");
                if (dateTimeVale.getTime() >= DATE.getTime()) break;
                result = CAPBusinessEnum.BatchValidateRulesEnum.FORMAT_ERROR.getType();
                break;
            }
            case EXTEND_DATETIME: {
                String checkDateTimeFormat = FormFieldUtil.checkFormat((String)formFieldBean.getInputType(), (String)formFieldBean.getFieldType(), (String)value, (boolean)true);
                if (Strings.isNotBlank((String)checkDateTimeFormat)) {
                    result = CAPBusinessEnum.BatchValidateRulesEnum.FORMAT_ERROR.getType();
                    break;
                }
                Date dateTimeVale = DateUtil.toDate((String)value, (String)"yyyy-MM-dd HH:mm");
                if (dateTimeVale.getTime() >= DATE_TIME.getTime()) break;
                result = CAPBusinessEnum.BatchValidateRulesEnum.FORMAT_ERROR.getType();
                break;
            }
            case CHECKBOX: {
                if (CAPBusinessEnum.CheckBoxEnum.CHECK.getDisplay().equals(value) || CAPBusinessEnum.CheckBoxEnum.UN_CHECK.getDisplay().equals(value)) break;
                result = CAPBusinessEnum.BatchValidateRulesEnum.VALUE_MISMATCH_ERROR.getType();
                break;
            }
        }
        return result;
    }

    private boolean checkDataLength(FormFieldBean formFieldBean, String data) throws UnsupportedEncodingException {
        String fieldType = formFieldBean.getFieldType();
        if (Strings.isBlank((String)data) || Strings.isBlank((String)data)) {
            return true;
        }
        int dataLength = 0;
        if (Enums.FieldType.VARCHAR.getKey().equalsIgnoreCase(fieldType)) {
            dataLength = data.getBytes("UTF-8").length;
            if (formFieldBean.getMaxLength(false) < dataLength) {
                return false;
            }
        } else if (Enums.FieldType.DECIMAL.getKey().equalsIgnoreCase(fieldType)) {
            int maxLength = formFieldBean.getMaxLength();
            int digitNum = 0;
            if (Strings.isNotBlank((String)formFieldBean.getDigitNum())) {
                digitNum = Integer.parseInt(formFieldBean.getDigitNum());
                maxLength -= digitNum;
            }
            dataLength = data.length();
            if (data.contains(".")) {
                String integerData = data.split("[.]")[0];
                dataLength = integerData.getBytes("UTF-8").length;
            }
            if (maxLength < dataLength) {
                return false;
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void deleteSqliteDbFile(Long formId, String type) {
        FormBean formBean = this.cap4FormCacheManager.getForm(formId);
        String dbName = this.getDbName(formBean.getMasterTableBean().getTableName(), type);
        Connection connection = null;
        try {
            connection = CAPSQLiteUtil.getConnection((String)dbName);
            this.deleteTable(formBean, connection);
        }
        catch (SQLException e) {
            LOGGER.error((Object)("deleteSqliteDbFile.SQLException formId=" + formId), (Throwable)e);
        }
        finally {
            CAPSQLiteUtil.closeConnection((Connection)connection);
        }
        CAPSQLiteUtil.deleteDbFile((String)dbName);
    }

    protected void deleteErrorEnumField(ImportPromptBean promptBean, List<Set<String>> enumFieldTeams, Map<Integer, FormFieldBean> indexFieldMap, Map<String, Integer> fieldNameIndexMap, FormBean formBean) {
        for (Set<String> enumFieldTeam : enumFieldTeams) {
            ArrayList<String> fieldNames = new ArrayList<String>();
            boolean hasAllEnumField = true;
            for (String enumField : enumFieldTeam) {
                FormFieldBean fieldBean;
                if (formBean != null && ((fieldBean = formBean.getFieldBeanByName(enumField, true)) == null || fieldBean.isMasterField())) continue;
                if (fieldNameIndexMap.get(enumField) == null) {
                    hasAllEnumField = false;
                    continue;
                }
                fieldNames.add(enumField);
            }
            if (hasAllEnumField) continue;
            for (String fieldName : fieldNames) {
                Integer index = fieldNameIndexMap.get(fieldName);
                FormFieldBean formFieldBean = indexFieldMap.get(index);
                indexFieldMap.remove(index);
                fieldNameIndexMap.remove(fieldName);
                if (promptBean == null) continue;
                promptBean.getRelationEnumField().add(formFieldBean.getDisplay());
            }
        }
    }

    protected List<Set<String>> getEnumFieldTeams(FormBean formBean) {
        ArrayList<Set<String>> enumFieldTeams = new ArrayList<Set<String>>();
        HashMap<String, ArrayList<String>> enumRelationList = new HashMap<String, ArrayList<String>>();
        ArrayList allFieldBeans = new ArrayList();
        List formTableBeans = formBean.getTableList();
        int n = formTableBeans.size();
        for (int i = 0; i < n; ++i) {
            FormTableBean formTableBean = (FormTableBean)formTableBeans.get(i);
            allFieldBeans.addAll(formTableBean.getFields());
        }
        for (FormFieldBean formFieldBean : allFieldBeans) {
            FormRelation relation;
            if (!FormFieldComEnum.SELECT.getKey().equals(formFieldBean.getInputType()) || (relation = formFieldBean.getFormRelation()) == null) continue;
            FormFieldBean fromFieldBean = formBean.getFieldBeanByName(relation.getToRelationAttr());
            if (!FormFieldComEnum.SELECT.getKey().equals(fromFieldBean.getInputType())) continue;
            ArrayList<String> toFields = (ArrayList<String>)enumRelationList.get(fromFieldBean.getName());
            if (toFields == null) {
                toFields = new ArrayList<String>();
            }
            toFields.add(formFieldBean.getName());
            enumRelationList.put(fromFieldBean.getName(), toFields);
        }
        for (Map.Entry entry : enumRelationList.entrySet()) {
            String fromField = (String)entry.getKey();
            List toFields = (List)entry.getValue();
            toFields.add(fromField);
            if (enumFieldTeams.size() == 0) {
                HashSet teamFields = new HashSet();
                teamFields.addAll(toFields);
                enumFieldTeams.add(teamFields);
                continue;
            }
            boolean hasRetainFlag = false;
            int j2 = enumFieldTeams.size();
            for (int i = 0; i < j2; ++i) {
                Set teamFields = (Set)enumFieldTeams.get(i);
                HashSet<String> tempFields = new HashSet<String>(teamFields.size());
                for (String tempField : teamFields) {
                    tempFields.add(tempField);
                }
                tempFields.retainAll(toFields);
                if (tempFields.size() > 0) {
                    teamFields.addAll(toFields);
                    hasRetainFlag = false;
                    break;
                }
                hasRetainFlag = true;
            }
            if (!hasRetainFlag) continue;
            HashSet teamFieldss = new HashSet();
            teamFieldss.addAll(toFields);
            enumFieldTeams.add(teamFieldss);
        }
        return enumFieldTeams;
    }

    protected void checkMultiLevelEnum(FormBean formBean, Map<String, String> masterDataMap, Map<String, String> currentMap, FormFieldBean formFieldBean, ImportFieldVO fieldVO, Map<String, ImportFieldVO> cacheCurrentLineData) throws BusinessException {
        FormRelation formRelation = formFieldBean.getFormRelation();
        if (CAPBusinessEnum.BatchValidateRulesEnum.VALIDATE_SUCCESS.getType().equals(fieldVO.getState()) && FormFieldComEnum.SELECT.getKey().equals(formFieldBean.getInputType()) && formRelation != null) {
            FormFieldBean fromFieldBean = formBean.getFieldBeanByName(formRelation.getToRelationAttr());
            if (FormFieldComEnum.SELECT.getKey().equals(fromFieldBean.getInputType())) {
                String value = masterDataMap != null && fromFieldBean.isMasterField() ? masterDataMap.get(fromFieldBean.getName()) : currentMap.get(fromFieldBean.getName());
                ImportFieldVO fieldResult = cacheCurrentLineData.get(fromFieldBean.getName());
                if (fieldResult == null) {
                    fieldResult = this.getFieldValue(fromFieldBean, value);
                }
                if (CAPBusinessEnum.BatchValidateRulesEnum.VALIDATE_SUCCESS.getType().equals(fieldResult.getState())) {
                    boolean checkResult = this.enumItemHasDesignatedEnumItem(String.valueOf(fieldResult.getDbValue()), fieldVO, formFieldBean, cacheCurrentLineData, false);
                    fieldVO.setState(!checkResult ? CAPBusinessEnum.BatchValidateRulesEnum.VALUE_MISMATCH_ERROR.getType() : CAPBusinessEnum.BatchValidateRulesEnum.VALIDATE_SUCCESS.getType());
                } else if (Strings.isNotBlank((String)fieldVO.getShowValue())) {
                    fieldVO.setState(CAPBusinessEnum.BatchValidateRulesEnum.VALUE_MISMATCH_ERROR.getType());
                }
            }
        }
    }

    private boolean enumItemHasDesignatedEnumItem(String parentEnumId, ImportFieldVO fieldVO, FormFieldBean formFieldBean, Map<String, ImportFieldVO> cacheCurrentLineData, boolean checkUpEnum) throws BusinessException {
        String sonEnumId = String.valueOf(fieldVO.getDbValue());
        if (Strings.isBlank((String)sonEnumId)) {
            return true;
        }
        if (Strings.isBlank((String)parentEnumId) && Strings.isNotBlank((String)sonEnumId)) {
            return false;
        }
        if (Strings.isBlank((String)parentEnumId) && Strings.isBlank((String)sonEnumId)) {
            return true;
        }
        boolean result = false;
        if (this.enumManagerNew.getCtpEnumItem(Long.valueOf(parentEnumId)) != null) {
            List ctpEnumItems = this.enumManagerNew.getChildEnumItems(Long.valueOf(parentEnumId).longValue());
            for (CtpEnumItem enumItem : ctpEnumItems) {
                if (!enumItem.getParentId().toString().equals(parentEnumId) || !enumItem.getShowvalue().equals(fieldVO.getShowValue())) continue;
                result = true;
                if (null == cacheCurrentLineData) {
                    if (checkUpEnum) {
                        fieldVO.setDbValue(enumItem.getId().toString());
                        break;
                    }
                    if (enumItem.getId().toString().equals(sonEnumId)) break;
                    result = false;
                    break;
                }
                fieldVO.setDbValue(enumItem.getId().toString());
                cacheCurrentLineData.put(formFieldBean.getName(), fieldVO);
                break;
            }
        }
        return result;
    }

    protected String setData2Insert(FormBean formBean, Map<String, String> oneLineData, Map<String, ImportFieldVO> cacheCurrentLineData, List<Object> insertParam, String errorFlag, Map<String, String> masterDataMap) throws BusinessException {
        for (Map.Entry<String, String> entry : oneLineData.entrySet()) {
            FormFieldBean formFieldBean = formBean.getFieldBeanByName(entry.getKey());
            ImportFieldVO fieldVO = this.getFieldValue(formFieldBean, entry.getValue());
            this.checkMultiLevelEnum(formBean, masterDataMap, oneLineData, formFieldBean, fieldVO, cacheCurrentLineData);
            insertParam.add(fieldVO.toJSONString());
            if (!CAPBusinessEnum.TrueOrFalseEnum.FALSE.getKey().equals(errorFlag) || CAPBusinessEnum.BatchValidateRulesEnum.VALIDATE_SUCCESS.getType().equals(fieldVO.getState())) continue;
            errorFlag = CAPBusinessEnum.TrueOrFalseEnum.TRUE.getKey();
        }
        return errorFlag;
    }

    protected Map<String, List<String>> getTableUniqueFieldNames(FormBean formBean) {
        if (CollectionUtils.isEmpty((Collection)formBean.getUniqueFieldList())) {
            return null;
        }
        HashMap<String, List<String>> tableUniqueFieldNames = new HashMap<String, List<String>>();
        for (List uniqueFieldList : formBean.getUniqueFieldList()) {
            for (String fieldName : uniqueFieldList) {
                FormFieldBean formFieldBean = formBean.getFieldBeanByName(fieldName, true);
                String tableName = formFieldBean.getOwnerTableName();
                ArrayList<String> fieldNames = (ArrayList<String>)tableUniqueFieldNames.get(tableName);
                if (fieldNames == null) {
                    fieldNames = new ArrayList<String>();
                    tableUniqueFieldNames.put(tableName, fieldNames);
                }
                fieldNames.add(formFieldBean.getName());
            }
        }
        return tableUniqueFieldNames;
    }

    protected List<ImportUniqueBean> getUniqueBeans(FormBean formBean, String fieldInfos) {
        ArrayList<ImportUniqueBean> uniqueBeans = new ArrayList<ImportUniqueBean>();
        for (List uniqueFieldList : formBean.getUniqueFieldList()) {
            ArrayList<String> displays = new ArrayList<String>();
            boolean hasUniqueField = true;
            boolean hasMasterField = false;
            boolean hasSubField = false;
            String subTableName = "";
            ArrayList<FormFieldBean> fieldBeans = new ArrayList<FormFieldBean>();
            for (String fieldName : uniqueFieldList) {
                FormFieldBean formFieldBean = formBean.getFieldBeanByName(fieldName, true);
                fieldBeans.add(formFieldBean);
                if (formFieldBean.isMasterField()) {
                    hasMasterField = true;
                    displays.add("[" + ResourceUtil.getString((String)"cap.formDesign.setting.mainForm") + "]" + formFieldBean.getDisplay());
                } else {
                    if (Strings.isBlank((String)subTableName)) {
                        subTableName = formFieldBean.getOwnerTableName();
                    }
                    hasSubField = true;
                    displays.add("[" + formFieldBean.getOwnerTableDisplay() + "]" + formFieldBean.getDisplay());
                }
                if (fieldInfos.contains(formFieldBean.getName()) || !hasUniqueField) continue;
                hasUniqueField = false;
            }
            if (!Strings.isBlank((String)fieldInfos) && !hasUniqueField) continue;
            ImportUniqueBean uniqueBean = new ImportUniqueBean();
            uniqueBean.setHasMasterField(hasMasterField);
            uniqueBean.setHasSubField(hasSubField);
            uniqueBean.setUniqueFieldList(fieldBeans);
            uniqueBean.setDisplay(StringUtils.join(displays, (String)","));
            uniqueBean.setSubTableName(subTableName);
            uniqueBeans.add(uniqueBean);
        }
        return uniqueBeans;
    }

    protected List<String> getFieldNames(Collection<FormFieldBean> fieldBeans) {
        ArrayList<String> fieldNames = new ArrayList<String>();
        if (CollectionUtils.isNotEmpty(fieldBeans)) {
            for (FormFieldBean fieldBean : fieldBeans) {
                fieldNames.add(fieldBean.getName());
            }
        }
        return fieldNames;
    }

    protected ExportTableLineDataVO getTableLineDataVO(FormBean formBean, Map<String, Object> excelFormData, Map<String, Object> formData, List<String> fieldList) {
        boolean flag = true;
        StringBuilder errorSb = new StringBuilder();
        ArrayList<Object> dataList = new ArrayList<Object>();
        for (String fieldName : fieldList) {
            FormFieldBean formFieldBean = formBean.getFieldBeanByName(fieldName, true);
            if (!this.checkImportSupportField(formFieldBean) || excelFormData.get(fieldName) == null) continue;
            ImportFieldVO field = (ImportFieldVO)JSONUtil.parseJSONString((String)String.valueOf(excelFormData.get(fieldName)), ImportFieldVO.class);
            dataList.add(field.getShowValue());
            if (CAPBusinessEnum.BatchValidateRulesEnum.VALIDATE_SUCCESS.getType().equals(field.getState())) {
                if (formData == null) continue;
                FormFieldComEnum formFieldComEnum = formFieldBean.getInputTypeEnum();
                switch (formFieldComEnum) {
                    case EXTEND_DATE: {
                        String data = String.valueOf(field.getDbValue());
                        formData.put(fieldName, Strings.isNotBlank((String)data) ? DateUtil.toDate((String)data, (String)"yyyy-MM-dd") : data);
                        break;
                    }
                    case EXTEND_DATETIME: {
                        String dataTime = String.valueOf(field.getDbValue());
                        formData.put(fieldName, Strings.isNotBlank((String)dataTime) ? DateUtil.toDate((String)dataTime, (String)"yyyy-MM-dd HH:mm:ss") : dataTime);
                        break;
                    }
                    default: {
                        formData.put(fieldName, field.getDbValue());
                        break;
                    }
                }
                continue;
            }
            flag = false;
            errorSb.append("\u3010").append(formFieldBean.getDisplay()).append("\u3011").append(CAPBusinessEnum.BatchValidateRulesEnum.getExplainByType(field.getState()));
        }
        ExportTableLineDataVO dataVO = new ExportTableLineDataVO();
        dataVO.setError(errorSb.toString());
        dataVO.setLineValueData(dataList);
        dataVO.setFlag(flag);
        return dataVO;
    }

    protected int getTableDataCount(String table, String where, List<Object> params) throws BusinessException {
        StringBuilder sql = new StringBuilder();
        sql.append("SELECT COUNT(1) FROM ").append(table);
        if (Strings.isNotBlank((String)where)) {
            sql.append(" WHERE ").append(where);
        }
        try {
            return this.capDataListSqlHelpManager.selectDataCount(sql.toString(), params);
        }
        catch (SQLException e) {
            throw new BusinessException((Throwable)e);
        }
    }

    protected List getTableDataList(String table, List<String> fieldNames, List<Object> ids) throws BusinessException {
        return this.getTableDataList(table, fieldNames, ids, null);
    }

    protected List getTableDataList(String table, List<String> fieldNames, List<Object> ids, FlipInfo flipInfo) throws BusinessException {
        StringBuilder sql = new StringBuilder();
        if (CollectionUtils.isEmpty(fieldNames)) {
            sql.append("SELECT * FROM ").append(table);
        } else {
            sql.append("SELECT ").append(StringUtils.join(fieldNames, (String)",")).append(" FROM ").append(table);
        }
        if (CollectionUtils.isNotEmpty(ids)) {
            boolean isMaster = table.startsWith("formmain");
            if (isMaster) {
                sql.append(" WHERE ").append(Enums.MasterTableField.id.getKey()).append(" IN (");
            } else {
                sql.append(" WHERE ").append(Enums.SubTableField.formmain_id.getKey()).append(" IN (");
            }
            int j = ids.size();
            for (int i = 0; i < j; ++i) {
                sql.append(i == j - 1 ? "?" : "?,");
            }
            sql.append(")");
            if (!isMaster) {
                sql.append(" ORDER BY sort ASC ");
            }
        }
        try {
            List returnData;
            if (flipInfo != null) {
                if (flipInfo.getTotal() > 0) {
                    flipInfo.setNeedTotal(false);
                }
                this.capDataListSqlHelpManager.selectDataList(flipInfo, sql.toString(), ids);
                returnData = flipInfo.getData();
            } else {
                returnData = this.capDataListSqlHelpManager.selectDataList(sql.toString(), ids);
            }
            return returnData;
        }
        catch (SQLException e) {
            throw new BusinessException((Throwable)e);
        }
    }

    protected CtpContentAll buildCtpContentAll(Long formMasterId, Long contentTemplateId, Long id) {
        CtpContentAll ctpContentAll = new CtpContentAll();
        ctpContentAll.setIdIfNew();
        ctpContentAll.setModuleType(Integer.valueOf(ModuleType.cap4UnflowForm.getKey()));
        ctpContentAll.setModuleId(formMasterId);
        ctpContentAll.setModuleTemplateId(id);
        ctpContentAll.setContentType(Integer.valueOf(20));
        ctpContentAll.setContentTemplateId(contentTemplateId);
        ctpContentAll.setContentDataId(formMasterId);
        ctpContentAll.setModifyId(Long.valueOf(AppContext.currentUserId()));
        ctpContentAll.setModifyDate(new Date());
        ctpContentAll.setCreateId(Long.valueOf(AppContext.currentUserId()));
        ctpContentAll.setCreateDate(new Date());
        ctpContentAll.setSort(Integer.valueOf(0));
        return ctpContentAll;
    }

    protected List<Map<String, Object>> getSQLiteDataListByIn(Connection connection, List<?> masterIds, String tableName, String keyName) throws SQLException {
        ArrayList param = null;
        StringBuilder sql = new StringBuilder();
        sql.append("SELECT * FROM ").append(tableName);
        if (CollectionUtils.isNotEmpty(masterIds) && Strings.isNotBlank((String)keyName)) {
            param = new ArrayList();
            StringBuilder inSqlSb = new StringBuilder();
            int size = masterIds.size();
            for (int i = 0; i < size; ++i) {
                inSqlSb.append(i == size - 1 ? "?" : "?,");
                param.add(masterIds.get(i));
            }
            sql.append(" WHERE ").append(keyName).append(" IN ( ").append(inSqlSb.toString()).append(")");
        }
        return CAPSQLiteUtil.select((Connection)connection, (String)sql.toString(), param);
    }

    protected List<Map<String, Object>> getSQLiteDataList(Connection connection, String tableName, String key, Object param) throws SQLException {
        String sql = "SELECT * FROM " + tableName + " WHERE " + key + " = ?";
        ArrayList<Object> selectParam = new ArrayList<Object>();
        selectParam.add(param);
        return CAPSQLiteUtil.select((Connection)connection, (String)sql, selectParam);
    }

    public void setCap4FormCacheManager(CAP4FormCacheManager cap4FormCacheManager) {
        this.cap4FormCacheManager = cap4FormCacheManager;
    }

    public void setFileManager(FileManager fileManager) {
        this.fileManager = fileManager;
    }

    public void setFileToExcelManager(FileToExcelManager fileToExcelManager) {
        this.fileToExcelManager = fileToExcelManager;
    }

    public void setCap4FormManager(CAP4FormManager cap4FormManager) {
        this.cap4FormManager = cap4FormManager;
    }

    public void setEnumManagerNew(EnumManager enumManagerNew) {
        this.enumManagerNew = enumManagerNew;
    }

    public void setCapDataListSqlHelpManager(CAPDataListSqlHelpManager capDataListSqlHelpManager) {
        this.capDataListSqlHelpManager = capDataListSqlHelpManager;
    }
}

