/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.cap4.template.manager.impl;

import com.seeyon.cap4.template.bo.CAPBusinessColumnBO;
import com.seeyon.cap4.template.dao.CAPBusinessColumnDAO;
import com.seeyon.cap4.template.manager.CAPBusinessColumnManager;
import com.seeyon.cap4.template.po.CAPBusinessColumn;
import com.seeyon.cap4.template.vo.config.ConfigColumnVO;
import com.seeyon.ctp.common.exceptions.BusinessException;
import com.seeyon.ctp.common.log.CtpLogFactory;
import com.seeyon.ctp.util.DateUtil;
import com.seeyon.ctp.util.Strings;
import java.sql.Timestamp;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;

public class CAPBusinessColumnManagerImpl
implements CAPBusinessColumnManager {
    private static final Log LOGGER = CtpLogFactory.getLog(CAPBusinessColumnManagerImpl.class);
    private CAPBusinessColumnDAO capBusinessColumnDAO;

    @Override
    public CAPBusinessColumnBO analysisDownloadColumn(ConfigColumnVO columnVO, String goodId, String goodName, String templateId, String memberId) {
        CAPBusinessColumnBO capBusinessColumnBO = new CAPBusinessColumnBO();
        capBusinessColumnBO.setId(columnVO.getColumnId());
        capBusinessColumnBO.setName(columnVO.getName());
        capBusinessColumnBO.setColumnType(columnVO.getType());
        capBusinessColumnBO.setState(columnVO.getState());
        Timestamp timestamp = DateUtil.currentTimestamp();
        capBusinessColumnBO.setCreateMemberId(memberId);
        capBusinessColumnBO.setModifyMemberId(memberId);
        capBusinessColumnBO.setCreateDate(String.valueOf(timestamp));
        capBusinessColumnBO.setModifyDate(String.valueOf(timestamp));
        capBusinessColumnBO.setGoodId(goodId);
        capBusinessColumnBO.setGoodName(goodName);
        capBusinessColumnBO.setTemplateId(templateId);
        return capBusinessColumnBO;
    }

    @Override
    public boolean updateCAPBusinessColumns(List<CAPBusinessColumn> capBusinessColumns) throws BusinessException {
        Timestamp timestamp = DateUtil.currentTimestamp();
        for (CAPBusinessColumn capBusinessColumn : capBusinessColumns) {
            capBusinessColumn.setModifyDate(timestamp);
        }
        this.capBusinessColumnDAO.updateCAPBusinessColumns(capBusinessColumns);
        return true;
    }

    @Override
    public void saveCAPBusinessColumnBOs(List<CAPBusinessColumnBO> capBusinessColumnBOs) throws BusinessException {
        if (CollectionUtils.isEmpty(capBusinessColumnBOs)) {
            return;
        }
        ArrayList<CAPBusinessColumn> capBusinessColumns = new ArrayList<CAPBusinessColumn>();
        try {
            Timestamp timestamp = DateUtil.currentTimestamp();
            for (CAPBusinessColumnBO capBusinessColumnBO : capBusinessColumnBOs) {
                capBusinessColumnBO.setModifyDate(String.valueOf(timestamp));
                capBusinessColumnBO.setCreateDate(String.valueOf(timestamp));
                capBusinessColumns.add(capBusinessColumnBO.exportToPO());
            }
            this.capBusinessColumnDAO.insertCAPBusinessColumns(capBusinessColumns);
        }
        catch (ParseException e) {
            LOGGER.error((Object)"method saveCAPBusinessColumnBOs is error ", (Throwable)e);
            throw new BusinessException(e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public CAPBusinessColumnBO getCAPBusinessColumnBOFromCacheById(Long templateId, Long columnId) throws BusinessException {
        CAPBusinessColumnBO capBusinessColumnBO = null;
        List<CAPBusinessColumnBO> capBusinessColumnBOS = this.getCAPBusinessColumnBOsByTemplateId(templateId);
        for (CAPBusinessColumnBO capBusinessColumnBO1 : capBusinessColumnBOS) {
            if (!capBusinessColumnBO1.getId().equals(String.valueOf(columnId))) continue;
            capBusinessColumnBO = capBusinessColumnBO1;
            break;
        }
        return capBusinessColumnBO;
    }

    @Override
    public List<CAPBusinessColumn> getCAPBusinessColumnsByTemplateIds(List<Long> templateIds) throws BusinessException {
        return this.capBusinessColumnDAO.getCAPBusinessColumnsByTemplateIds(templateIds);
    }

    @Override
    public List<CAPBusinessColumnBO> getCAPBusinessColumnBOsByTemplateIds(List<Long> templateIds) throws BusinessException {
        List<CAPBusinessColumn> capBusinessColumns = null;
        if (Strings.isNotEmpty(templateIds)) {
            capBusinessColumns = this.getCAPBusinessColumnsByTemplateIds(templateIds);
        }
        return this.importColumnBOsFromPOs(capBusinessColumns);
    }

    @Override
    public List<CAPBusinessColumn> getCAPBusinessColumnsByTemplateId(Long templateId) throws BusinessException {
        return this.capBusinessColumnDAO.getCAPBusinessColumnsByTemplateId(templateId);
    }

    @Override
    public List<CAPBusinessColumnBO> getCAPBusinessColumnBOsByTemplateId(Long templateId) throws BusinessException {
        List<CAPBusinessColumn> capBusinessColumns = this.getCAPBusinessColumnsByTemplateId(templateId);
        return this.importColumnBOsFromPOs(capBusinessColumns);
    }

    @Override
    public List<CAPBusinessColumn> getCAPBusinessColumnsByColumnIds(List<Long> columnIds) throws BusinessException {
        return this.capBusinessColumnDAO.getCAPBusinessColumnsByColumnIds(columnIds);
    }

    private List<CAPBusinessColumnBO> importColumnBOsFromPOs(List<CAPBusinessColumn> capBusinessColumns) throws BusinessException {
        ArrayList<CAPBusinessColumnBO> capBusinessColumnBOs = new ArrayList<CAPBusinessColumnBO>();
        if (Strings.isNotEmpty(capBusinessColumns)) {
            for (CAPBusinessColumn capBusinessColumn : capBusinessColumns) {
                CAPBusinessColumnBO capBusinessColumnBO = new CAPBusinessColumnBO();
                capBusinessColumnBO.importFromPO(capBusinessColumn);
                capBusinessColumnBOs.add(capBusinessColumnBO);
            }
        }
        return capBusinessColumnBOs;
    }

    public void setCapBusinessColumnDAO(CAPBusinessColumnDAO capBusinessColumnDAO) {
        this.capBusinessColumnDAO = capBusinessColumnDAO;
    }
}

