/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.cap4.template.manager.impl;

import com.seeyon.cap4.template.bo.CAPBusinessConfigBO;
import com.seeyon.cap4.template.dao.CAPBusinessConfigDAO;
import com.seeyon.cap4.template.manager.CAPBusinessConfigManager;
import com.seeyon.cap4.template.po.CAPBusinessConfig;
import com.seeyon.ctp.common.exceptions.BusinessException;
import com.seeyon.ctp.common.log.CtpLogFactory;
import com.seeyon.ctp.util.DateUtil;
import java.sql.Timestamp;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;

public class CAPBusinessConfigManagerImpl
implements CAPBusinessConfigManager {
    private static final Log LOGGER = CtpLogFactory.getLog(CAPBusinessConfigManagerImpl.class);
    private CAPBusinessConfigDAO capBusinessConfigDAO;

    @Override
    public List<CAPBusinessConfigBO> getCAPBusinessConfigBOsByPathIds(Collection<Long> pathIds) {
        if (pathIds == null || pathIds.size() == 0) {
            return null;
        }
        try {
            List<CAPBusinessConfig> capBusinessConfigs = this.capBusinessConfigDAO.getCAPBusinessConfigsByPathIds(pathIds);
            if (capBusinessConfigs == null) {
                return null;
            }
            ArrayList<CAPBusinessConfigBO> capBusinessConfigBOS = new ArrayList<CAPBusinessConfigBO>();
            for (CAPBusinessConfig capBusinessConfig : capBusinessConfigs) {
                CAPBusinessConfigBO capBusinessConfigBO = new CAPBusinessConfigBO();
                capBusinessConfigBO.importFromPO(capBusinessConfig);
                capBusinessConfigBOS.add(capBusinessConfigBO);
            }
            return capBusinessConfigBOS;
        }
        catch (BusinessException e) {
            LOGGER.error((Object)("method getCAPBusinessConfigBOsByPathIds is error " + e.getMessage() + " AND param pathIds is" + pathIds));
            return null;
        }
    }

    @Override
    public CAPBusinessConfigBO getCAPBusinessConfigBOByPathId(Long pathId) {
        if (pathId == null) {
            return null;
        }
        try {
            CAPBusinessConfig capBusinessConfig = this.capBusinessConfigDAO.getCAPBusinessConfigByPathId(pathId);
            if (capBusinessConfig == null) {
                return null;
            }
            CAPBusinessConfigBO capBusinessConfigBO = new CAPBusinessConfigBO();
            capBusinessConfigBO.importFromPO(capBusinessConfig);
            return capBusinessConfigBO;
        }
        catch (BusinessException e) {
            LOGGER.error((Object)("method getCAPBusinessConfigBOById is error " + e.getMessage() + " AND param pathId is" + pathId));
            return null;
        }
    }

    @Override
    public boolean insertCAPBusinessConfigBO(CAPBusinessConfigBO capBusinessConfigBO) {
        boolean result = false;
        if (capBusinessConfigBO == null) {
            return result;
        }
        Timestamp timestamp = DateUtil.currentTimestamp();
        capBusinessConfigBO.setModifyDate(String.valueOf(timestamp));
        capBusinessConfigBO.setCreateDate(String.valueOf(timestamp));
        try {
            this.capBusinessConfigDAO.insertCAPBusinessConfig(capBusinessConfigBO.exportToPO());
            result = true;
        }
        catch (ParseException e) {
            LOGGER.error((Object)("method insertCAPBusinessConfig is error " + e.getMessage() + " AND param capBusinessConfigBO is" + capBusinessConfigBO));
        }
        catch (BusinessException e) {
            LOGGER.error((Object)("method insertCAPBusinessConfig is error " + e.getMessage() + " AND param capBusinessConfigBO is" + capBusinessConfigBO));
        }
        return result;
    }

    @Override
    public void insertCAPBusinessConfigBOs(List<CAPBusinessConfigBO> capBusinessConfigBOs) throws BusinessException {
        if (CollectionUtils.isEmpty(capBusinessConfigBOs)) {
            return;
        }
        try {
            ArrayList<CAPBusinessConfig> capBusinessConfigs = new ArrayList<CAPBusinessConfig>();
            Timestamp timestamp = DateUtil.currentTimestamp();
            for (CAPBusinessConfigBO capBusinessConfigBO : capBusinessConfigBOs) {
                capBusinessConfigBO.setModifyDate(String.valueOf(timestamp));
                capBusinessConfigBO.setCreateDate(String.valueOf(timestamp));
                capBusinessConfigs.add(capBusinessConfigBO.exportToPO());
            }
            this.capBusinessConfigDAO.insertCAPBusinessConfigs(capBusinessConfigs);
        }
        catch (ParseException e) {
            LOGGER.error((Object)"method insertCAPBusinessConfigBOs is error ", (Throwable)e);
            throw new BusinessException(e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public boolean updateCAPBusinessConfigBO(CAPBusinessConfigBO capBusinessConfigBO) {
        boolean result = false;
        if (capBusinessConfigBO == null) {
            return result;
        }
        Timestamp timestamp = DateUtil.currentTimestamp();
        capBusinessConfigBO.setModifyDate(String.valueOf(timestamp));
        try {
            this.capBusinessConfigDAO.updateCAPBusinessConfig(capBusinessConfigBO.exportToPO());
            result = true;
        }
        catch (ParseException e) {
            LOGGER.error((Object)("method updateCAPBusinessConfig is error " + e.getMessage() + " AND param capBusinessConfigBO is" + capBusinessConfigBO));
        }
        catch (BusinessException e) {
            LOGGER.error((Object)("method updateCAPBusinessConfig is error " + e.getMessage() + " AND param capBusinessConfigBO is" + capBusinessConfigBO));
        }
        return result;
    }

    @Override
    public void deleteCAPBusinessConfigBOs(List<CAPBusinessConfigBO> capBusinessConfigBOs) throws BusinessException {
        if (capBusinessConfigBOs == null || capBusinessConfigBOs.size() == 0) {
            return;
        }
        try {
            ArrayList<CAPBusinessConfig> capBusinessConfigs = new ArrayList<CAPBusinessConfig>();
            for (CAPBusinessConfigBO capBusinessConfigBO : capBusinessConfigBOs) {
                capBusinessConfigs.add(capBusinessConfigBO.exportToPO());
            }
            this.capBusinessConfigDAO.deleteCAPBusinessConfigs(capBusinessConfigs);
        }
        catch (ParseException e) {
            LOGGER.error((Object)"method insertCAPBusinessConfigBOs is error ", (Throwable)e);
            throw new BusinessException(e.getMessage(), (Throwable)e);
        }
    }

    public void setCapBusinessConfigDAO(CAPBusinessConfigDAO capBusinessConfigDAO) {
        this.capBusinessConfigDAO = capBusinessConfigDAO;
    }
}

