/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.cap4.template.manager.impl;

import com.seeyon.cap4.form.bean.FormBean;
import com.seeyon.cap4.form.bean.FormBindAuthBean;
import com.seeyon.cap4.form.bean.FormBindBean;
import com.seeyon.cap4.form.bean.SimpleObjectBean;
import com.seeyon.cap4.form.modules.business.BizConfigBean;
import com.seeyon.cap4.form.modules.business.BusinessManager;
import com.seeyon.cap4.form.modules.business.FormAppBO;
import com.seeyon.cap4.form.po.CAPFormDefinition;
import com.seeyon.cap4.form.service.CAP4FormCacheManager;
import com.seeyon.cap4.form.util.Enums;
import com.seeyon.cap4.template.bo.CAPBusinessColumnBO;
import com.seeyon.cap4.template.bo.CAPBusinessElementBO;
import com.seeyon.cap4.template.bo.CAPBusinessTemplateBO;
import com.seeyon.cap4.template.constant.CAPBusinessEnum;
import com.seeyon.cap4.template.dao.CAPBusinessElementDAO;
import com.seeyon.cap4.template.manager.CAPBusinessColumnManager;
import com.seeyon.cap4.template.manager.CAPBusinessElementManager;
import com.seeyon.cap4.template.manager.CAPBusinessTemplateManager;
import com.seeyon.cap4.template.po.CAPBusinessElement;
import com.seeyon.cap4.template.vo.config.ConfigElementVO;
import com.seeyon.ctp.common.constants.ApplicationCategoryEnum;
import com.seeyon.ctp.common.exceptions.BusinessException;
import com.seeyon.ctp.common.i18n.ResourceUtil;
import com.seeyon.ctp.common.log.CtpLogFactory;
import com.seeyon.ctp.common.po.template.CtpTemplate;
import com.seeyon.ctp.common.po.template.CtpTemplateCategory;
import com.seeyon.ctp.common.template.manager.TemplateManager;
import com.seeyon.ctp.form.util.StringUtils;
import com.seeyon.ctp.portal.api.PortalApi;
import com.seeyon.ctp.portal.po.PortalCustomizeMenu;
import com.seeyon.ctp.privilege.bo.PrivMenuBO;
import com.seeyon.ctp.report.engine.api.ReportConstants;
import com.seeyon.ctp.report.engine.api.manager.ReportApi;
import com.seeyon.ctp.report.engine.po.ReportIndex;
import com.seeyon.ctp.util.DateUtil;
import com.seeyon.ctp.util.FlipInfo;
import com.seeyon.ctp.util.Strings;
import java.sql.Timestamp;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;

public class CAPBusinessElementManagerImpl
implements CAPBusinessElementManager {
    private static final Log LOGGER = CtpLogFactory.getLog(CAPBusinessElementManagerImpl.class);
    private static final String ZERO = "0";
    private CAPBusinessElementDAO capBusinessElementDAO;
    private ReportApi reportApi;
    private BusinessManager businessManager4;
    private TemplateManager templateManager;
    private CAP4FormCacheManager cap4FormCacheManager;
    private PortalApi portalApi;
    private CAPBusinessTemplateManager capBusinessTemplateManager;
    private CAPBusinessColumnManager capBusinessColumnManager;

    @Override
    public List<CAPBusinessElementBO> analysisDownloadElement(List<ConfigElementVO> configElementVOS, CAPBusinessColumnBO capBusinessColumnBO, Map<String, Object> elementDataSource) {
        ArrayList<CAPBusinessElementBO> capBusinessElementBOS = null;
        if (Strings.isNotEmpty(configElementVOS)) {
            capBusinessElementBOS = new ArrayList<CAPBusinessElementBO>();
            HashSet<String> usedDynamicKey = new HashSet<String>();
            for (ConfigElementVO elementVO : configElementVOS) {
                CAPBusinessElementBO elementBO = new CAPBusinessElementBO();
                elementBO.setId(elementVO.getElementId());
                elementBO.setName(elementVO.getName());
                HashMap<String, Object> extendInfo = new HashMap<String, Object>();
                extendInfo.put("dynamicKey", elementVO.getDynamicKey());
                extendInfo.put("sort", elementVO.getSort());
                elementBO.setSort(elementVO.getSort());
                elementBO.setExtendInfo(extendInfo);
                elementBO.setElementType(elementVO.getType());
                elementBO.setColumnId(String.valueOf(capBusinessColumnBO.getId()));
                elementBO.setCreateMemberId(capBusinessColumnBO.getCreateMemberId());
                elementBO.setModifyMemberId(capBusinessColumnBO.getCreateMemberId());
                elementBO.setCreateDate(capBusinessColumnBO.getCreateDate());
                elementBO.setModifyDate(capBusinessColumnBO.getModifyDate());
                if (elementDataSource != null && elementDataSource.get(elementVO.getDynamicKey()) != null) {
                    elementBO.setDataInfo((Map)elementDataSource.get(elementVO.getDynamicKey()));
                    usedDynamicKey.add(elementVO.getDynamicKey());
                }
                capBusinessElementBOS.add(elementBO);
            }
            if (elementDataSource != null && usedDynamicKey.size() < capBusinessElementBOS.size()) {
                ArrayList<Map> list = new ArrayList<Map>();
                for (String key : elementDataSource.keySet()) {
                    if (usedDynamicKey.contains(key)) continue;
                    list.add((Map)elementDataSource.get(key));
                }
                Collections.sort(list, new Comparator<Map<String, Object>>(){

                    @Override
                    public int compare(Map<String, Object> o1, Map<String, Object> o2) {
                        if (o1.get("dataInfoTime") == null || o2.get("dataInfoTime") == null) {
                            return 0;
                        }
                        Long sort1 = DateUtil.toDate((String)String.valueOf(o1.get("dataInfoTime"))).getTime();
                        Long sort2 = DateUtil.toDate((String)String.valueOf(o2.get("dataInfoTime"))).getTime();
                        if (sort1 == null || sort2 == null) {
                            return 0;
                        }
                        return sort2.intValue() - sort1.intValue();
                    }
                });
                block2: for (CAPBusinessElementBO bo : capBusinessElementBOS) {
                    if (!list.isEmpty()) {
                        if (bo.getDataInfo() != null) continue;
                        Iterator it = list.iterator();
                        while (it.hasNext()) {
                            Map map = (Map)it.next();
                            if (!bo.getElementType().equals(map.get("dataInfoType")) || !bo.getSort().equals(map.get("sort"))) continue;
                            bo.setDataInfo(map);
                            it.remove();
                            continue block2;
                        }
                        continue;
                    }
                    break;
                }
            }
        } else {
            LOGGER.error((Object)"method analysisElement is error AND params mapList or capBusinessColumnBO is null .");
        }
        return capBusinessElementBOS;
    }

    @Override
    public void saveCAPBusinessElementBOs(List<CAPBusinessElementBO> capBusinessElementBOs) throws BusinessException {
        if (CollectionUtils.isEmpty(capBusinessElementBOs)) {
            return;
        }
        try {
            ArrayList<CAPBusinessElement> capBusinessElements = new ArrayList<CAPBusinessElement>();
            Timestamp timestamp = DateUtil.currentTimestamp();
            for (CAPBusinessElementBO capBusinessElementBO : capBusinessElementBOs) {
                capBusinessElementBO.setModifyDate(String.valueOf(timestamp));
                capBusinessElementBO.setCreateDate(String.valueOf(timestamp));
                capBusinessElements.add(capBusinessElementBO.exportToPO());
            }
            this.capBusinessElementDAO.insertCAPBusinessElements(capBusinessElements);
        }
        catch (ParseException e) {
            LOGGER.error((Object)"method saveCAPBusinessElementBOs is error", (Throwable)e);
            throw new BusinessException(e.getMessage(), (Throwable)e);
        }
    }

    @Override
    @Deprecated
    public boolean autoMatchElementData(Long bizId, List<Long> templateIds) throws BusinessException {
        List<CAPBusinessTemplateBO> capBusinessTemplateBOList = this.capBusinessTemplateManager.getCAPBusinessTemplatesByBizId(bizId);
        ArrayList<CAPBusinessElementBO> capBusinessElementBOList = new ArrayList<CAPBusinessElementBO>();
        ArrayList<Long> waitClearElementCacheColumnIds = new ArrayList<Long>();
        ArrayList<Long> rangeColumnIds = new ArrayList<Long>();
        for (CAPBusinessTemplateBO capBusinessTemplateBO : capBusinessTemplateBOList) {
            List<CAPBusinessColumnBO> capBusinessColumnBOs = this.capBusinessColumnManager.getCAPBusinessColumnBOsByTemplateId(Long.valueOf(capBusinessTemplateBO.getId()));
            for (CAPBusinessColumnBO capBusinessColumnBO : capBusinessColumnBOs) {
                rangeColumnIds.add(Long.valueOf(capBusinessColumnBO.getId()));
                if (!templateIds.contains(Long.valueOf(capBusinessTemplateBO.getId()))) continue;
                List<CAPBusinessElementBO> capBusinessElementBOs = this.getCAPBusinessElementBOsByColumnId(Long.valueOf(capBusinessColumnBO.getId()));
                for (CAPBusinessElementBO capBusinessElementBO : capBusinessElementBOs) {
                    if (capBusinessElementBO.getDataInfo() != null) continue;
                    capBusinessElementBOList.add(capBusinessElementBO);
                    Long columnId = Long.parseLong(capBusinessElementBO.getColumnId());
                    if (waitClearElementCacheColumnIds.contains(columnId)) continue;
                    waitClearElementCacheColumnIds.add(columnId);
                }
            }
        }
        boolean result = false;
        try {
            ArrayList<CAPBusinessElement> toUpdateElements = new ArrayList<CAPBusinessElement>();
            HashMap<String, Object> queryParams = new HashMap<String, Object>();
            HashMap<String, CAPBusinessElement> queryedElement = new HashMap<String, CAPBusinessElement>();
            for (CAPBusinessElementBO capBusinessElementBO : capBusinessElementBOList) {
                CAPBusinessElement useElement;
                queryParams.clear();
                queryParams.put("elementType", Integer.valueOf(capBusinessElementBO.getElementType()));
                queryParams.put("name", capBusinessElementBO.getName());
                queryParams.put("columnId", rangeColumnIds);
                String queryedKey = capBusinessElementBO.getElementType() + capBusinessElementBO.getName();
                if (!queryedElement.containsKey(queryedKey)) {
                    List<CAPBusinessElement> queryedElements = this.capBusinessElementDAO.getConfigedCAPBusinessElementsByParams(queryParams);
                    if (queryedElements == null || queryedElements.size() == 0 || queryedElements.get(0) == null) {
                        queryedElement.put(queryedKey, null);
                    } else {
                        queryedElement.put(queryedKey, queryedElements.get(0));
                    }
                }
                if ((useElement = (CAPBusinessElement)((Object)queryedElement.get(queryedKey))) == null) continue;
                CAPBusinessElement exportElement = capBusinessElementBO.exportToPO();
                exportElement.setDataInfo(useElement.getDataInfo());
                toUpdateElements.add(exportElement);
            }
            if (toUpdateElements.size() > 0) {
                this.capBusinessElementDAO.updateCAPBusinessElements(toUpdateElements);
            }
            result = true;
        }
        catch (ParseException e) {
            LOGGER.error((Object)"method autoMatchElementData is error", (Throwable)e);
            throw new BusinessException((Throwable)e);
        }
        return result;
    }

    @Override
    public List<CAPBusinessElement> getCAPBusinessElementsByElementIds(List<Long> elementIds) throws BusinessException {
        return this.capBusinessElementDAO.getCAPBusinessElementsByElementIds(elementIds);
    }

    @Override
    public boolean updateCAPBusinessElements(List<CAPBusinessElement> capBusinessElements) throws BusinessException {
        Timestamp timestamp = DateUtil.currentTimestamp();
        for (CAPBusinessElement element : capBusinessElements) {
            element.setModifyDate(timestamp);
        }
        this.capBusinessElementDAO.updateCAPBusinessElements(capBusinessElements);
        return true;
    }

    @Override
    public List<CAPBusinessElementBO> getCAPBusinessElementBOsByColumnId(Long columnId) throws BusinessException {
        List<CAPBusinessElement> capBusinessElements = this.getCAPBusinessElementsByColumnId(columnId);
        return this.importElementBOsFromPOs(capBusinessElements);
    }

    @Override
    public List<CAPBusinessElement> getCAPBusinessElementsByColumnId(Long columnId) throws BusinessException {
        return this.capBusinessElementDAO.getCAPBusinessElementsByColumnId(columnId);
    }

    @Override
    public List<CAPBusinessElementBO> getCAPBusinessElementBOsByColumnIds(List<Long> columnIds) throws BusinessException {
        List<CAPBusinessElement> capBusinessElements = this.getCAPBusinessElementsByColumnIds(columnIds);
        return this.importElementBOsFromPOs(capBusinessElements);
    }

    @Override
    public Map<String, List<CAPBusinessElementBO>> getCAPBusinessElementBOsMapByColumnIds(List<Long> columnIds) throws BusinessException {
        List<CAPBusinessElementBO> elementBOS = this.getCAPBusinessElementBOsByColumnIds(columnIds);
        HashMap<String, List<CAPBusinessElementBO>> columnId2ElementBos = new HashMap<String, List<CAPBusinessElementBO>>();
        if (Strings.isNotEmpty(elementBOS)) {
            for (CAPBusinessElementBO elementBO : elementBOS) {
                ArrayList<CAPBusinessElementBO> columnElementBos = (ArrayList<CAPBusinessElementBO>)columnId2ElementBos.get(elementBO.getColumnId());
                if (columnElementBos == null) {
                    columnElementBos = new ArrayList<CAPBusinessElementBO>();
                }
                columnElementBos.add(elementBO);
                columnId2ElementBos.put(elementBO.getColumnId(), columnElementBos);
            }
        }
        return columnId2ElementBos;
    }

    private List<CAPBusinessElementBO> importElementBOsFromPOs(List<CAPBusinessElement> capBusinessElements) throws BusinessException {
        ArrayList<CAPBusinessElementBO> capBusinessElementBOS = new ArrayList<CAPBusinessElementBO>();
        if (Strings.isNotEmpty(capBusinessElements)) {
            for (CAPBusinessElement capBusinessElement : capBusinessElements) {
                CAPBusinessElementBO capBusinessElementBO = new CAPBusinessElementBO();
                capBusinessElementBO.importFromPO(capBusinessElement);
                capBusinessElementBOS.add(capBusinessElementBO);
            }
        }
        return capBusinessElementBOS;
    }

    @Override
    public List<CAPBusinessElement> getCAPBusinessElementsByColumnIds(List<Long> columnIds) throws BusinessException {
        return this.capBusinessElementDAO.getCAPBusinessElementsByColumnIds(columnIds);
    }

    @Override
    public List getCAPBusinessDataIds(Long bizId, Integer columnType, Integer client) throws BusinessException {
        ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>();
        if (CAPBusinessEnum.ColumnType.FLOW_LIST.getType() == columnType.intValue()) {
            ArrayList<Map<String, Object>> bussFlowArray = new ArrayList<Map<String, Object>>();
            Map<String, Object> bussFlowObject = this.getData(ZERO, ResourceUtil.getString((String)"cap.template.business.element.flow"), bussFlowArray);
            ArrayList<Map<String, Object>> processMergingArray = new ArrayList<Map<String, Object>>();
            Map<String, Object> processMergingObject = this.getData(ZERO, ResourceUtil.getString((String)"cap.template.business.element.merging"), processMergingArray);
            bussFlowArray.add(processMergingObject);
            String parentName = this.getParentName(ResourceUtil.getString((String)"cap.template.business.element.flow"), ResourceUtil.getString((String)"cap.template.business.element.merging"), CAPBusinessEnum.DataSource.LIST_PENDING.getName());
            processMergingArray.add(this.getFlowData(parentName, String.valueOf(bizId), null, CAPBusinessEnum.DataSource.LIST_PENDING.getName(), CAPBusinessEnum.DataSource.LIST_PENDING.getKey()));
            List<CAPFormDefinition> formList = this.businessManager4.getCAP4FormByBizId(bizId);
            for (CAPFormDefinition formDefine : formList) {
                FormBean fb = this.cap4FormCacheManager.getForm(formDefine.getId());
                if (Enums.FormType.processesForm.getKey() != fb.getFormType()) continue;
                List templateList = this.templateManager.getCtpTemplates(fb.getId().longValue(), false);
                for (CtpTemplate ctpTemplate : templateList) {
                    String templateId = ctpTemplate.getId().toString();
                    String templateName = ctpTemplate.getSubject();
                    parentName = this.getParentName(ResourceUtil.getString((String)"cap.template.business.element.flow"), templateName, CAPBusinessEnum.DataSource.LIST_PENDING.getName());
                    ArrayList<Map<String, Object>> currentArray = new ArrayList<Map<String, Object>>();
                    Map<String, Object> currentObject = this.getData(templateId, templateName, currentArray);
                    currentArray.add(this.getFlowData(parentName, null, templateId, CAPBusinessEnum.DataSource.LIST_PENDING.getName(), CAPBusinessEnum.DataSource.LIST_PENDING.getKey()));
                    bussFlowArray.add(currentObject);
                }
            }
            result.add(bussFlowObject);
        } else if (CAPBusinessEnum.ColumnType.UNFLOW_LIST.getType() == columnType.intValue()) {
            ArrayList<Map<String, Object>> unFlowArray = new ArrayList<Map<String, Object>>();
            Map<String, Object> unFlowObject = this.getData(ZERO, ResourceUtil.getString((String)"cap.template.business.element.unflow"), unFlowArray);
            List<CAPFormDefinition> formList = this.businessManager4.getCAP4FormByBizId(bizId);
            for (CAPFormDefinition formDefine : formList) {
                FormBean formBean = this.cap4FormCacheManager.getForm(formDefine.getId());
                if (Enums.FormType.unFlowForm.getKey() != formBean.getFormType()) continue;
                FormBindBean bindBean = formBean.getBind();
                Map unTemplates = bindBean.getUnFlowTemplateMap();
                for (Map.Entry entry : unTemplates.entrySet()) {
                    CtpTemplateCategory category = this.templateManager.getCtpTemplateCategory(Long.valueOf(formBean.getCategoryId()));
                    if (category == null) continue;
                    FormBindAuthBean formBindAuthBean = (FormBindAuthBean)entry.getValue();
                    String parentName = this.getParentName(ResourceUtil.getString((String)"cap.template.business.element.unflow"), formBindAuthBean.getName());
                    unFlowArray.add(this.getUnflowData(parentName, String.valueOf(formBean.getId()), formBindAuthBean.getId().toString(), formBindAuthBean.getName()));
                }
            }
            result.add(unFlowObject);
        } else if (CAPBusinessEnum.ColumnType.QUERY_RESULT.getType() == columnType.intValue()) {
            ArrayList<Map<String, Object>> queryArray = new ArrayList<Map<String, Object>>();
            Map<String, Object> queryObject = this.getData(ZERO, ResourceUtil.getString((String)"cap.template.business.element.query"), queryArray);
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("categoryId", String.valueOf(bizId));
            params.put("category", ApplicationCategoryEnum.cap4biz.name());
            params.put("designType", ReportConstants.DesignType.QUERY.name());
            List results = this.reportApi.findDesignWithoutAuth(params);
            for (Map map : results) {
                String designId = String.valueOf(map.get("designId"));
                String title = String.valueOf(map.get("title"));
                String parentName = this.getParentName(ResourceUtil.getString((String)"cap.template.business.element.query"), title);
                queryArray.add(this.getQueryData(parentName, designId, title));
            }
            result.add(queryObject);
        } else if (CAPBusinessEnum.ColumnType.CACL_RESULT.getType() == columnType.intValue()) {
            ArrayList<Map<String, Object>> caclArray = new ArrayList<Map<String, Object>>();
            Map<String, Object> caclObject = this.getData(ZERO, ResourceUtil.getString((String)"cap.template.business.element.statistics"), caclArray);
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("categoryId", String.valueOf(bizId));
            params.put("category", ApplicationCategoryEnum.cap4biz.name());
            ArrayList<String> designTypeList = new ArrayList<String>();
            designTypeList.add(ReportConstants.DesignType.STATISTICS.name());
            designTypeList.add(ReportConstants.DesignType.MULTSTATS.name());
            designTypeList.add(ReportConstants.DesignType.SCHEDULEDSTATS.name());
            params.put("designTypeList", designTypeList);
            List results = this.reportApi.findDesignWithoutAuth(params);
            for (Map map : results) {
                String designId = String.valueOf(map.get("designId"));
                String title = String.valueOf(map.get("title"));
                String parentName = this.getParentName(ResourceUtil.getString((String)"cap.template.business.element.statistics"), title);
                caclArray.add(this.getCaclData(parentName, designId, title));
            }
            result.add(caclObject);
        } else if (CAPBusinessEnum.ColumnType.BUSINESS_TARGET.getType() == columnType.intValue()) {
            ArrayList<Map<String, Object>> bussFlowArray = new ArrayList<Map<String, Object>>();
            Map<String, Object> bussFlowObject = this.getData(ZERO, ResourceUtil.getString((String)"cap.template.business.element.flow"), bussFlowArray);
            result.add(bussFlowObject);
            ArrayList<Map<String, Object>> processMergingArray = new ArrayList<Map<String, Object>>();
            Map<String, Object> processMergingObject = this.getData(ZERO, ResourceUtil.getString((String)"cap.template.business.element.merging"), processMergingArray);
            bussFlowArray.add(processMergingObject);
            String parentName = this.getParentName(ResourceUtil.getString((String)"cap.template.business.element.flow"), ResourceUtil.getString((String)"cap.template.business.element.merging"), CAPBusinessEnum.DataSource.LISTPENDING_NUN.getName());
            processMergingArray.add(this.getTargetData(parentName, String.valueOf(bizId), null, null, CAPBusinessEnum.DataSource.LISTPENDING_NUN.getName(), CAPBusinessEnum.DataSource.LISTPENDING_NUN.getKey()));
            parentName = this.getParentName(ResourceUtil.getString((String)"cap.template.business.element.flow"), ResourceUtil.getString((String)"cap.template.business.element.merging"), CAPBusinessEnum.DataSource.LISTDONE_NUN.getName());
            processMergingArray.add(this.getTargetData(parentName, String.valueOf(bizId), null, null, CAPBusinessEnum.DataSource.LISTDONE_NUN.getName(), CAPBusinessEnum.DataSource.LISTDONE_NUN.getKey()));
            parentName = this.getParentName(ResourceUtil.getString((String)"cap.template.business.element.flow"), ResourceUtil.getString((String)"cap.template.business.element.merging"), CAPBusinessEnum.DataSource.LISTWAITSEND_NUN.getName());
            processMergingArray.add(this.getTargetData(parentName, String.valueOf(bizId), null, null, CAPBusinessEnum.DataSource.LISTWAITSEND_NUN.getName(), CAPBusinessEnum.DataSource.LISTWAITSEND_NUN.getKey()));
            parentName = this.getParentName(ResourceUtil.getString((String)"cap.template.business.element.flow"), ResourceUtil.getString((String)"cap.template.business.element.merging"), CAPBusinessEnum.DataSource.LISTSENT_NUN.getName());
            processMergingArray.add(this.getTargetData(parentName, String.valueOf(bizId), null, null, CAPBusinessEnum.DataSource.LISTSENT_NUN.getName(), CAPBusinessEnum.DataSource.LISTSENT_NUN.getKey()));
            List<CAPFormDefinition> formList = this.businessManager4.getCAP4FormByBizId(bizId);
            for (CAPFormDefinition formDefine : formList) {
                FormBean fb = this.cap4FormCacheManager.getForm(formDefine.getId());
                if (Enums.FormType.processesForm.getKey() != fb.getFormType()) continue;
                List templateList = this.templateManager.getCtpTemplates(fb.getId().longValue(), false);
                for (CtpTemplate ctpTemplate : templateList) {
                    String templateId = ctpTemplate.getId().toString();
                    String templateName = ctpTemplate.getSubject();
                    ArrayList<Map<String, Object>> currentArray = new ArrayList<Map<String, Object>>();
                    Map<String, Object> currentObject = this.getData(templateId, templateName, currentArray);
                    parentName = this.getParentName(ResourceUtil.getString((String)"cap.template.business.element.flow"), templateName, CAPBusinessEnum.DataSource.LISTPENDING_NUN.getName());
                    currentArray.add(this.getTargetData(parentName, String.valueOf(bizId), templateId, null, CAPBusinessEnum.DataSource.LISTPENDING_NUN.getName(), CAPBusinessEnum.DataSource.LISTPENDING_NUN.getKey()));
                    parentName = this.getParentName(ResourceUtil.getString((String)"cap.template.business.element.flow"), templateName, CAPBusinessEnum.DataSource.LISTDONE_NUN.getName());
                    currentArray.add(this.getTargetData(parentName, String.valueOf(bizId), templateId, null, CAPBusinessEnum.DataSource.LISTDONE_NUN.getName(), CAPBusinessEnum.DataSource.LISTDONE_NUN.getKey()));
                    parentName = this.getParentName(ResourceUtil.getString((String)"cap.template.business.element.flow"), templateName, CAPBusinessEnum.DataSource.LISTWAITSEND_NUN.getName());
                    currentArray.add(this.getTargetData(parentName, String.valueOf(bizId), templateId, null, CAPBusinessEnum.DataSource.LISTWAITSEND_NUN.getName(), CAPBusinessEnum.DataSource.LISTWAITSEND_NUN.getKey()));
                    parentName = this.getParentName(ResourceUtil.getString((String)"cap.template.business.element.flow"), templateName, CAPBusinessEnum.DataSource.LISTSENT_NUN.getName());
                    currentArray.add(this.getTargetData(parentName, String.valueOf(bizId), templateId, null, CAPBusinessEnum.DataSource.LISTSENT_NUN.getName(), CAPBusinessEnum.DataSource.LISTSENT_NUN.getKey()));
                    bussFlowArray.add(currentObject);
                }
            }
            List reportIndices = this.reportApi.findReportIndex(ApplicationCategoryEnum.cap4biz.name(), String.valueOf(bizId));
            LinkedHashMap<Long, Map<String, Object>> indexMaps = new LinkedHashMap<Long, Map<String, Object>>(reportIndices.size());
            for (int i = 0; i < reportIndices.size(); ++i) {
                ArrayList<Map<String, Object>> currentArray;
                ReportIndex reportIndex = (ReportIndex)reportIndices.get(i);
                Long reportDesignId = reportIndex.getReportDesignId();
                String reportTitle = reportIndex.getDesignTitle();
                Map<String, Object> indexMap = (Map<String, Object>)indexMaps.get(reportDesignId);
                if (indexMap == null) {
                    currentArray = new ArrayList();
                    indexMap = this.getData(ZERO, reportTitle, currentArray);
                } else {
                    currentArray = (List)indexMap.get("dataList");
                }
                parentName = this.getParentName(reportTitle, reportIndex.getTitle());
                currentArray.add(this.getTargetData(parentName, String.valueOf(bizId), String.valueOf(reportDesignId), String.valueOf(reportIndex.getId()), reportIndex.getTitle(), CAPBusinessEnum.DataSource.CACL_NUM.getKey()));
                indexMaps.put(reportDesignId, indexMap);
            }
            result.addAll(indexMaps.values());
        } else if (CAPBusinessEnum.ColumnType.SHORT_CUT.getType() == columnType.intValue()) {
            ArrayList<Map<String, Object>> operationFlowArray = new ArrayList<Map<String, Object>>();
            Map<String, Object> operationFlowObject = this.getData(ZERO, ResourceUtil.getString((String)"cap.template.business.element.flow"), operationFlowArray);
            ArrayList<Map<String, Object>> unFlowArray = new ArrayList<Map<String, Object>>();
            Map<String, Object> unFlowObject = this.getData(ZERO, ResourceUtil.getString((String)"cap.template.business.element.unflow"), unFlowArray);
            ArrayList<Map<String, Object>> queryArray = new ArrayList<Map<String, Object>>();
            Map<String, Object> queryObject = this.getData(ZERO, ResourceUtil.getString((String)"cap.template.business.element.query"), queryArray);
            ArrayList<Map<String, Object>> caclArray = new ArrayList<Map<String, Object>>();
            Map<String, Object> caclObject = this.getData(ZERO, ResourceUtil.getString((String)"cap.template.business.element.statistics"), caclArray);
            List<FormAppBO> formList = this.businessManager4.getFormListByBizId(bizId);
            for (FormAppBO formAppBO : formList) {
                Map<String, Object> currentApp;
                Map<String, Object> currentApp2;
                String parentName;
                String appName = formAppBO.getName();
                if (Enums.FormType.processesForm.getKey() == formAppBO.getSourceType()) {
                    parentName = this.getParentName(ResourceUtil.getString((String)"cap.template.business.element.flow"), appName, CAPBusinessEnum.DataSource.LIST_CREATE.getName());
                    ArrayList<Map<String, Object>> flowMenuarray = new ArrayList<Map<String, Object>>();
                    currentApp2 = this.getData(ZERO, appName, flowMenuarray);
                    operationFlowArray.add(currentApp2);
                    flowMenuarray.add(this.getData(parentName, String.valueOf(bizId), formAppBO.getId(), String.valueOf(formAppBO.getFormAppmainId()), CAPBusinessEnum.DataSource.LIST_CREATE.getName(), CAPBusinessEnum.DataSource.LIST_CREATE.getKey(), String.valueOf(client)));
                }
                if (Enums.FormType.unFlowForm.getKey() == formAppBO.getSourceType()) {
                    ArrayList<Map<String, Object>> unflowMenuarray = new ArrayList<Map<String, Object>>();
                    currentApp2 = this.getData(ZERO, appName, unflowMenuarray);
                    unFlowArray.add(currentApp2);
                    FormBindAuthBean formBindAuthBean = this.cap4FormCacheManager.getForm(formAppBO.getFormAppmainId()).getBind().getFormBindAuthBean(formAppBO.getId());
                    SimpleObjectBean add = formBindAuthBean.getAuthObjByName(FormBindAuthBean.AuthName.ADD.getKey());
                    if (add != null) {
                        parentName = this.getParentName(ResourceUtil.getString((String)"cap.template.business.element.unflow"), appName, CAPBusinessEnum.DataSource.UNFLOW_CREATE.getName());
                        if (CAPBusinessEnum.Platform.PC.getType() == client.intValue() && !Strings.isBlank((String)add.getValue())) {
                            unflowMenuarray.add(this.getData(parentName, String.valueOf(bizId), formAppBO.getId(), String.valueOf(formAppBO.getFormAppmainId()), CAPBusinessEnum.DataSource.UNFLOW_CREATE.getName(), CAPBusinessEnum.DataSource.UNFLOW_CREATE.getKey(), String.valueOf(client)));
                        }
                        if (CAPBusinessEnum.Platform.MOBILE.getType() == client.intValue() && !Strings.isBlank((String)add.getPhoneValue())) {
                            unflowMenuarray.add(this.getData(parentName, String.valueOf(bizId), formAppBO.getId(), String.valueOf(formAppBO.getFormAppmainId()), CAPBusinessEnum.DataSource.UNFLOW_CREATE.getName(), CAPBusinessEnum.DataSource.UNFLOW_CREATE.getKey(), String.valueOf(client)));
                        }
                    }
                    parentName = this.getParentName(ResourceUtil.getString((String)"cap.template.business.element.unflow"), appName, CAPBusinessEnum.DataSource.UNFLOW_LIST.getName());
                    unflowMenuarray.add(this.getData(parentName, String.valueOf(bizId), formAppBO.getId(), String.valueOf(formAppBO.getFormAppmainId()), CAPBusinessEnum.DataSource.UNFLOW_LIST.getName(), CAPBusinessEnum.DataSource.UNFLOW_LIST.getKey(), String.valueOf(client)));
                }
                if (Enums.SourceType.SOURCE_TYPE_QUERY.getKey() == formAppBO.getSourceType()) {
                    parentName = this.getParentName(ResourceUtil.getString((String)"cap.template.business.element.query"), formAppBO.getName());
                    currentApp = this.getData(parentName, String.valueOf(bizId), formAppBO.getId(), null, formAppBO.getName(), CAPBusinessEnum.DataSource.QUERY_LIST.getKey(), String.valueOf(client));
                    queryArray.add(currentApp);
                }
                if (Enums.SourceType.SOURCE_TYPE_REPORT.getKey() != formAppBO.getSourceType()) continue;
                parentName = this.getParentName(ResourceUtil.getString((String)"cap.template.business.element.statistics"), formAppBO.getName());
                currentApp = this.getData(parentName, String.valueOf(bizId), formAppBO.getId(), null, formAppBO.getName(), CAPBusinessEnum.DataSource.CACL_LIST.getKey(), String.valueOf(client));
                caclArray.add(currentApp);
            }
            result.add(operationFlowObject);
            result.add(unFlowObject);
            result.add(queryObject);
            result.add(caclObject);
        } else if (CAPBusinessEnum.ColumnType.MENU_COLLECTION.getType() == columnType.intValue()) {
            BizConfigBean bizConfigBean = this.businessManager4.findBizConfigById(bizId);
            ArrayList<Map<String, Object>> bussNameArray = new ArrayList<Map<String, Object>>();
            Map<String, Object> bussNamebject = this.getData(ZERO, bizConfigBean.getName(), bussNameArray);
            String parentName = this.getParentName(bizConfigBean.getName(), CAPBusinessEnum.DataSource.FLOW_CREATE_MENU_COLLECTION.getName());
            bussNameArray.add(this.getMenuCollectionData(String.valueOf(bizId), parentName, CAPBusinessEnum.DataSource.FLOW_CREATE_MENU_COLLECTION.getName(), CAPBusinessEnum.DataSource.FLOW_CREATE_MENU_COLLECTION.getKey(), String.valueOf(client)));
            parentName = this.getParentName(bizConfigBean.getName(), CAPBusinessEnum.DataSource.UNFLOW_CREATE_MENU_COLLECTION.getName());
            bussNameArray.add(this.getMenuCollectionData(String.valueOf(bizId), parentName, CAPBusinessEnum.DataSource.UNFLOW_CREATE_MENU_COLLECTION.getName(), CAPBusinessEnum.DataSource.UNFLOW_CREATE_MENU_COLLECTION.getKey(), String.valueOf(client)));
            parentName = this.getParentName(bizConfigBean.getName(), CAPBusinessEnum.DataSource.UNFLOW_MENU_COLLECTION.getName());
            bussNameArray.add(this.getMenuCollectionData(String.valueOf(bizId), parentName, CAPBusinessEnum.DataSource.UNFLOW_MENU_COLLECTION.getName(), CAPBusinessEnum.DataSource.UNFLOW_MENU_COLLECTION.getKey(), String.valueOf(client)));
            parentName = this.getParentName(bizConfigBean.getName(), CAPBusinessEnum.DataSource.QUERY_MENU_COLLECTION.getName());
            bussNameArray.add(this.getMenuCollectionData(String.valueOf(bizId), parentName, CAPBusinessEnum.DataSource.QUERY_MENU_COLLECTION.getName(), CAPBusinessEnum.DataSource.QUERY_MENU_COLLECTION.getKey(), String.valueOf(client)));
            parentName = this.getParentName(bizConfigBean.getName(), CAPBusinessEnum.DataSource.CACL_MENU_COLLECTION.getName());
            bussNameArray.add(this.getMenuCollectionData(String.valueOf(bizId), parentName, CAPBusinessEnum.DataSource.CACL_MENU_COLLECTION.getName(), CAPBusinessEnum.DataSource.CACL_MENU_COLLECTION.getKey(), String.valueOf(client)));
            parentName = this.getParentName(bizConfigBean.getName(), CAPBusinessEnum.DataSource.ALL_MENU_COLLECTION.getName());
            bussNameArray.add(this.getMenuCollectionData(String.valueOf(bizId), parentName, CAPBusinessEnum.DataSource.ALL_MENU_COLLECTION.getName(), CAPBusinessEnum.DataSource.ALL_MENU_COLLECTION.getKey(), String.valueOf(client)));
            result.add(bussNamebject);
        } else if (CAPBusinessEnum.ColumnType.MENU_COLUMN.getType() == columnType.intValue()) {
            BizConfigBean bizConfigBean = this.businessManager4.findBizConfigById(bizId);
            ArrayList<Map<String, Object>> appInMenuArray = new ArrayList<Map<String, Object>>();
            Map<String, Object> bussFlowObject = this.getData(ZERO, bizConfigBean.getName(), appInMenuArray);
            result.add(bussFlowObject);
            List privMenuBOS = bizConfigBean.getMenuList();
            String type = privMenuBOS != null && privMenuBOS.size() == 1 && ((PrivMenuBO)privMenuBOS.get(0)).getId().longValue() == bizConfigBean.getMenuId().longValue() ? CAPBusinessEnum.DataSource.APP_IN_MENU_NOT_CONFIG.getKey() : CAPBusinessEnum.DataSource.APP_IN_MENU_HAS_CONFIG.getKey();
            String parentName = this.getParentName(bizConfigBean.getName(), ResourceUtil.getString((String)"cap.template.business.element.inMenu"));
            appInMenuArray.add(this.getMenuColumnData(String.valueOf(bizId), String.valueOf(bizConfigBean.getMenuId()), parentName, ResourceUtil.getString((String)"cap.template.business.element.inMenu"), type, String.valueOf(client)));
            if (CAPBusinessEnum.Platform.PC.getType() == client.intValue()) {
                ArrayList<Map<String, Object>> mutiBusinessMenuArray = new ArrayList<Map<String, Object>>();
                Map<String, Object> mutiBusinessMenu = this.getData(ZERO, ResourceUtil.getString((String)"cap.template.business.element.bussinessMenu"), mutiBusinessMenuArray);
                result.add(mutiBusinessMenu);
                HashMap params = new HashMap(1);
                FlipInfo flipInfo = new FlipInfo(1, -1);
                this.portalApi.capCustomizeMenuList(flipInfo, params);
                int total = flipInfo.getTotal();
                flipInfo.setSize(total);
                this.portalApi.capCustomizeMenuList(flipInfo, params);
                List portalCustomizeMenus = flipInfo.getData();
                int j = portalCustomizeMenus.size();
                for (int i = 0; i < j; ++i) {
                    PortalCustomizeMenu portalCustomizeMenu = (PortalCustomizeMenu)portalCustomizeMenus.get(i);
                    parentName = this.getParentName(ResourceUtil.getString((String)"cap.template.business.element.bussinessMenu"), portalCustomizeMenu.getShowName());
                    mutiBusinessMenuArray.add(this.getMenuColumnData(String.valueOf(bizId), String.valueOf(portalCustomizeMenu.getId()), parentName, portalCustomizeMenu.getShowName(), CAPBusinessEnum.DataSource.MUTI_BUSINESS_MENU.getKey(), String.valueOf(client)));
                }
            }
        }
        return result;
    }

    private String getParentName(String ... names) {
        StringBuilder stringBuilder = new StringBuilder();
        for (String name : names) {
            stringBuilder.append(name).append("-");
        }
        return StringUtils.replaceLast((String)stringBuilder.toString(), (String)"-", (String)"");
    }

    private Map<String, Object> getMenuColumnData(String bussId, String menuId, String parentName, String name, String type, String client) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("bussId", bussId);
        result.put("menuId", menuId);
        result.put("name", name);
        result.put("type", type);
        result.put("parentName", parentName);
        result.put("client", client);
        return result;
    }

    private Map<String, Object> getMenuCollectionData(String bussId, String parentName, String name, String type, String client) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("bussId", bussId);
        result.put("name", name);
        result.put("type", type);
        result.put("parentName", parentName);
        result.put("client", client);
        return result;
    }

    private Map<String, Object> getData(String sign, String name, List<Map<String, Object>> dataList) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("sign", sign);
        result.put("name", name);
        result.put("dataList", dataList);
        return result;
    }

    private Map<String, Object> getData(String parentName, String bussId, String appId, String formId, String name, String type, String client) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("bussId", bussId);
        if (Strings.isNotBlank((String)appId)) {
            result.put("appId", appId);
        }
        if (Strings.isNotBlank((String)appId)) {
            result.put("formId", formId);
        }
        result.put("name", name);
        result.put("type", type);
        result.put("parentName", parentName);
        result.put("client", client);
        return result;
    }

    private Map<String, Object> getFlowData(String parentName, String bussId, String templateId, String name, String type) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        if (Strings.isNotBlank((String)bussId)) {
            result.put("bussId", bussId);
        }
        if (Strings.isNotBlank((String)templateId)) {
            result.put("templateId", templateId);
        }
        result.put("name", name);
        result.put("type", type);
        result.put("parentName", parentName);
        return result;
    }

    private Map<String, Object> getTargetData(String parentName, String bussId, String appId, String indexId, String name, String type) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        if (Strings.isNotBlank((String)bussId)) {
            result.put("bussId", bussId);
        }
        if (Strings.isNotBlank((String)appId)) {
            result.put("appId", appId);
        }
        if (Strings.isNotBlank((String)indexId)) {
            result.put("indexId", indexId);
        }
        result.put("name", name);
        result.put("type", type);
        result.put("parentName", parentName);
        return result;
    }

    private Map<String, Object> getUnflowData(String parentName, String formId, String bindAuthId, String name) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("formId", formId);
        result.put("bindAuthId", bindAuthId);
        result.put("name", name);
        result.put("parentName", parentName);
        return result;
    }

    private Map<String, Object> getQueryData(String parentName, String queryId, String name) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("queryId", queryId);
        result.put("name", name);
        result.put("parentName", parentName);
        return result;
    }

    private Map<String, Object> getCaclData(String parentName, String statisticsId, String name) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("statisticsId", statisticsId);
        result.put("name", name);
        result.put("parentName", parentName);
        return result;
    }

    public void setCapBusinessElementDAO(CAPBusinessElementDAO capBusinessElementDAO) {
        this.capBusinessElementDAO = capBusinessElementDAO;
    }

    public void setBusinessManager4(BusinessManager businessManager4) {
        this.businessManager4 = businessManager4;
    }

    public void setTemplateManager(TemplateManager templateManager) {
        this.templateManager = templateManager;
    }

    public void setReportApi(ReportApi reportApi) {
        this.reportApi = reportApi;
    }

    public void setCap4FormCacheManager(CAP4FormCacheManager cap4FormCacheManager) {
        this.cap4FormCacheManager = cap4FormCacheManager;
    }

    public void setPortalApi(PortalApi portalApi) {
        this.portalApi = portalApi;
    }

    public void setCapBusinessTemplateManager(CAPBusinessTemplateManager capBusinessTemplateManager) {
        this.capBusinessTemplateManager = capBusinessTemplateManager;
    }

    public void setCapBusinessColumnManager(CAPBusinessColumnManager capBusinessColumnManager) {
        this.capBusinessColumnManager = capBusinessColumnManager;
    }
}

