/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.cap4.template.manager.impl;

import com.seeyon.cap4.form.bean.FormBean;
import com.seeyon.cap4.form.modules.business.BizConfigBean;
import com.seeyon.cap4.form.modules.business.BusinessManager;
import com.seeyon.cap4.form.service.CAP4FormCacheManager;
import com.seeyon.cap4.template.api.CAPBusinessTemplateReportApi;
import com.seeyon.cap4.template.manager.CAPBusinessManager;
import com.seeyon.ctp.common.AppContext;
import com.seeyon.ctp.common.exceptions.BusinessException;
import com.seeyon.ctp.common.log.CtpLogFactory;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.apache.commons.logging.Log;

public class CAPBusinessManagerImpl
implements CAPBusinessManager {
    private static final Log LOGGER = CtpLogFactory.getLog(CAPBusinessManagerImpl.class);
    private BusinessManager businessManager4;
    private CAP4FormCacheManager cap4FormCacheManager;

    @Override
    public boolean checkBizOwnerAuth4Template(Long bizId) {
        boolean auth = false;
        if (bizId == null) {
            auth = true;
        } else {
            Long userId = AppContext.currentUserId();
            try {
                BizConfigBean bizConfigBean = this.businessManager4.findBizConfigById(bizId);
                if (bizConfigBean != null) {
                    auth = userId.equals(bizConfigBean.getOwnerId());
                } else {
                    FormBean formBean = this.cap4FormCacheManager.getForm(bizId);
                    if (formBean != null) {
                        auth = userId.equals(formBean.getOwnerId());
                    } else {
                        CAPBusinessTemplateReportApi capBusinessTemplateGlobalReportApi = (CAPBusinessTemplateReportApi)AppContext.getBean((String)"capBusinessTemplateGlobalReportApi");
                        if (capBusinessTemplateGlobalReportApi != null) {
                            auth = capBusinessTemplateGlobalReportApi.checkReportOwnerAuth(bizId);
                        }
                    }
                }
            }
            catch (BusinessException e) {
                LOGGER.error((Object)("checkBizOwnerAuth4Template is exception , bizId is " + bizId + " , userId is " + userId), (Throwable)e);
            }
        }
        return auth;
    }

    @Override
    public boolean checkBizOwnerAuth4Template(Collection<Long> bizIds) {
        HashSet<Long> bizIdSets;
        if (bizIds == null || bizIds.isEmpty()) {
            return true;
        }
        if (bizIds instanceof Set) {
            bizIdSets = (HashSet<Long>)bizIds;
        } else {
            bizIdSets = new HashSet<Long>();
            bizIdSets.addAll(bizIds);
        }
        boolean authResult = true;
        Iterator iterator = bizIdSets.iterator();
        while (iterator.hasNext()) {
            if (this.checkBizOwnerAuth4Template((Long)iterator.next())) continue;
            authResult = false;
            break;
        }
        return authResult;
    }

    public void setBusinessManager4(BusinessManager businessManager4) {
        this.businessManager4 = businessManager4;
    }

    public void setCap4FormCacheManager(CAP4FormCacheManager cap4FormCacheManager) {
        this.cap4FormCacheManager = cap4FormCacheManager;
    }
}

