/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.cap4.template.manager.impl;

import com.seeyon.apps.collaboration.api.CollaborationApi;
import com.seeyon.apps.collaboration.enums.ColQueryCondition;
import com.seeyon.cap4.form.bean.FormBean;
import com.seeyon.cap4.form.modules.business.BusinessManager;
import com.seeyon.cap4.form.po.CAPFormDefinition;
import com.seeyon.cap4.form.service.CAP4FormCacheManager;
import com.seeyon.cap4.form.util.Enums;
import com.seeyon.cap4.form.util.StringUtils;
import com.seeyon.cap4.template.constant.CAPBusinessEnum;
import com.seeyon.cap4.template.manager.AbstractColumnElementDataManager;
import com.seeyon.cap4.template.manager.CAPBusinessTargetManager;
import com.seeyon.ctp.common.AppContext;
import com.seeyon.ctp.common.content.affair.constants.StateEnum;
import com.seeyon.ctp.common.exceptions.BusinessException;
import com.seeyon.ctp.common.log.CtpLogFactory;
import com.seeyon.ctp.common.po.template.CtpTemplate;
import com.seeyon.ctp.common.template.manager.TemplateManager;
import com.seeyon.ctp.report.engine.api.manager.ReportApi;
import com.seeyon.ctp.report.engine.bean.ReportIndexResult;
import com.seeyon.ctp.util.Strings;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;

public class CAPBusinessTargetManagerImpl
extends AbstractColumnElementDataManager
implements CAPBusinessTargetManager {
    private static final Log LOGGER = CtpLogFactory.getLog(CAPBusinessTargetManagerImpl.class);
    private BusinessManager businessManager4;
    private CollaborationApi collaborationApi;
    private ReportApi reportApi;
    private CAP4FormCacheManager cap4FormCacheManager;
    private TemplateManager templateManager;

    @Override
    public Map<String, Object> getColumnElementData(Map<String, Object> params) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        String type = (String)params.get("type");
        if (Strings.isBlank((String)type)) {
            result.put("code", "1001");
            result.put("message", String.format("this param %s is null!", "type"));
            return result;
        }
        try {
            HashMap<String, Object> data = new HashMap<String, Object>();
            if (CAPBusinessEnum.DataSource.CACL_NUM.getKey().equals(type)) {
                String appId = (String)params.get("appId");
                if (Strings.isBlank((String)appId)) {
                    result.put("code", "1001");
                    result.put("message", String.format("this param %s is null!", "appId"));
                    return result;
                }
                if (this.reportApi.checkAuth(Long.valueOf(appId), Long.valueOf(AppContext.currentUserId()))) {
                    String indexId = (String)params.get("indexId");
                    if (Strings.isBlank((String)indexId)) {
                        result.put("code", "1001");
                        result.put("message", String.format("this param %s is null!", "indexId"));
                        return result;
                    }
                    ArrayList<Long> indesIds = new ArrayList<Long>();
                    indesIds.add(Long.valueOf(indexId));
                    List reportIndexResults = this.reportApi.findReportIndexResult(indesIds);
                    data.put("name", params.get("name"));
                    if (reportIndexResults.size() > 0) {
                        ReportIndexResult reportIndexResult = (ReportIndexResult)reportIndexResults.get(0);
                        data.put("realValue", reportIndexResult.getRealValue());
                        data.put("display", reportIndexResult.getDisplay());
                        data.put("originalField", reportIndexResult.getOriginalField());
                    } else {
                        data.put("realValue", null);
                        data.put("display", null);
                        data.put("originalField", null);
                    }
                }
            } else {
                String templeteIds;
                String bussId = (String)params.get("bussId");
                if (Strings.isBlank((String)bussId)) {
                    result.put("code", "1001");
                    result.put("message", "this param %s is null!");
                    return result;
                }
                StringBuilder templeteIdSb = new StringBuilder();
                String templateId = (String)params.get("appId");
                if (Strings.isBlank((String)templateId)) {
                    List<CAPFormDefinition> formList = this.businessManager4.getCAP4FormByBizId(Long.valueOf(bussId));
                    for (CAPFormDefinition formDefine : formList) {
                        FormBean fb = this.cap4FormCacheManager.getForm(formDefine.getId());
                        if (Enums.FormType.processesForm.getKey() != fb.getFormType()) continue;
                        List templateList = this.templateManager.getCtpTemplates(fb.getId().longValue(), false);
                        for (CtpTemplate ctpTemplate : templateList) {
                            templeteIdSb.append(ctpTemplate.getId()).append(",");
                        }
                    }
                    templeteIds = StringUtils.replaceLast((String)templeteIdSb.toString(), (String)",", (String)"");
                } else {
                    templeteIds = templateId;
                }
                if (Strings.isBlank((String)templeteIds)) {
                    data.put("data", "0");
                } else {
                    HashMap<String, String> requestMap = new HashMap<String, String>();
                    requestMap.put(ColQueryCondition.templeteIds.name(), templeteIds);
                    requestMap.put(ColQueryCondition.currentUser.name(), String.valueOf(AppContext.currentUserId()));
                    int total = 0;
                    if (CAPBusinessEnum.DataSource.LISTPENDING_NUN.getKey().equals(type)) {
                        data.put("name", CAPBusinessEnum.DataSource.LISTPENDING_NUN.getName());
                        requestMap.put(ColQueryCondition.state.name(), String.valueOf(StateEnum.col_pending.getKey()));
                        total = this.collaborationApi.getColAffairsCountByCondition(requestMap);
                    } else if (CAPBusinessEnum.DataSource.LISTSENT_NUN.getKey().equals(type)) {
                        data.put("name", CAPBusinessEnum.DataSource.LISTSENT_NUN.getName());
                        requestMap.put(ColQueryCondition.state.name(), String.valueOf(StateEnum.col_sent.getKey()));
                        total = this.collaborationApi.getColAffairsCountByCondition(requestMap);
                    } else if (CAPBusinessEnum.DataSource.LISTWAITSEND_NUN.getKey().equals(type)) {
                        data.put("name", CAPBusinessEnum.DataSource.LISTWAITSEND_NUN.getName());
                        requestMap.put(ColQueryCondition.state.name(), String.valueOf(StateEnum.col_waitSend.getKey()));
                        total = this.collaborationApi.getColAffairsCountByCondition(requestMap);
                    } else if (CAPBusinessEnum.DataSource.LISTDONE_NUN.getKey().equals(type)) {
                        data.put("name", CAPBusinessEnum.DataSource.LISTDONE_NUN.getName());
                        requestMap.put(ColQueryCondition.state.name(), String.valueOf(StateEnum.col_done.getKey()));
                        total = this.collaborationApi.getColAffairsCountByCondition(requestMap);
                    }
                    data.put("realValue", String.valueOf(total));
                    data.put("display", String.valueOf(total));
                    HashMap<String, String> originalField = new HashMap<String, String>();
                    originalField.put("dbType", "DECIMAL");
                    originalField.put("comType", "TEXT");
                    data.put("originalField", originalField);
                }
            }
            result.put("code", "1000");
            result.put("message", "the operation is success!!!");
            result.put("data", data);
        }
        catch (BusinessException e) {
            LOGGER.error((Object)("CAPBusinessTargetManagerImpl.BusinessException, params = " + params.toString()), (Throwable)e);
            result.put("code", "1002");
            result.put("message", String.format("%s option exception!", "CAPBusinessTargetManagerImpl.BusinessException"));
        }
        return result;
    }

    @Override
    public String getClassId() {
        return String.valueOf(CAPBusinessEnum.ColumnType.BUSINESS_TARGET.getType());
    }

    public void setBusinessManager4(BusinessManager businessManager4) {
        this.businessManager4 = businessManager4;
    }

    public void setCollaborationApi(CollaborationApi collaborationApi) {
        this.collaborationApi = collaborationApi;
    }

    public void setReportApi(ReportApi reportApi) {
        this.reportApi = reportApi;
    }

    public void setCap4FormCacheManager(CAP4FormCacheManager cap4FormCacheManager) {
        this.cap4FormCacheManager = cap4FormCacheManager;
    }

    public void setTemplateManager(TemplateManager templateManager) {
        this.templateManager = templateManager;
    }
}

