/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.cap4.template.manager.impl;

import com.seeyon.cap4.template.bo.CAPBusinessColumnBO;
import com.seeyon.cap4.template.bo.CAPBusinessElementBO;
import com.seeyon.cap4.template.bo.CAPBusinessTemplateBO;
import com.seeyon.cap4.template.cache.CAPTemplateEditableColumnCache;
import com.seeyon.cap4.template.cache.CAPTemplateEditableColumnReplacedIdsCache;
import com.seeyon.cap4.template.cache.CAPTemplateEditableConfigCache;
import com.seeyon.cap4.template.cache.CAPTemplateEditablePreDataSourceCache;
import com.seeyon.cap4.template.constant.CAPBusinessEnum;
import com.seeyon.cap4.template.dao.CAPBusinessColumnDAO;
import com.seeyon.cap4.template.dao.CAPBusinessElementDAO;
import com.seeyon.cap4.template.manager.CAPBusinessColumnManager;
import com.seeyon.cap4.template.manager.CAPBusinessElementManager;
import com.seeyon.cap4.template.manager.CAPBusinessTemplate4EditManager;
import com.seeyon.cap4.template.manager.CAPBusinessTemplateClusterManager;
import com.seeyon.cap4.template.manager.CAPBusinessTemplateManager;
import com.seeyon.cap4.template.po.CAPBusinessColumn;
import com.seeyon.cap4.template.po.CAPBusinessElement;
import com.seeyon.cap4.template.po.CAPBusinessTemplate;
import com.seeyon.cap4.template.thread.CAPBackupTemplateFileThread;
import com.seeyon.cap4.template.thread.CAPDeleteTemplateFileRunnable;
import com.seeyon.cap4.template.util.CAPBuildM3Util;
import com.seeyon.cap4.template.util.CAPBusinessTemplateUtil;
import com.seeyon.cap4.template.util.CAPBusinessUtil;
import com.seeyon.cap4.template.util.CAPParamUtil;
import com.seeyon.cap4.template.util.FileUtil;
import com.seeyon.cap4.template.vo.CAPBuildTemplateVO;
import com.seeyon.cap4.template.vo.config.ConfigTemplateVO;
import com.seeyon.ctp.common.AppContext;
import com.seeyon.ctp.common.authenticate.domain.User;
import com.seeyon.ctp.common.exceptions.BusinessException;
import com.seeyon.ctp.common.i18n.ResourceUtil;
import com.seeyon.ctp.common.log.CtpLogFactory;
import com.seeyon.ctp.util.DateUtil;
import com.seeyon.ctp.util.Strings;
import com.seeyon.ctp.util.ZipUtil;
import com.seeyon.ctp.util.json.JSONUtil;
import java.io.File;
import java.io.IOException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;

public class CAPBusinessTemplate4EditManagerImpl
implements CAPBusinessTemplate4EditManager {
    private static final Log LOGGER = CtpLogFactory.getLog(CAPBusinessTemplate4EditManagerImpl.class);
    private CAPBusinessTemplateManager capBusinessTemplateManager;
    private CAPBusinessElementManager capBusinessElementManager;
    private CAPBusinessColumnManager capBusinessColumnManager;
    private CAPBusinessTemplateClusterManager capBusinessTemplateClusterManager;
    private CAPBusinessColumnDAO capBusinessColumnDAO;
    private CAPBusinessElementDAO capBusinessElementDAO;

    @Override
    public void saveEditableTemplate(Long templateId, ConfigTemplateVO inputCTVO) throws BusinessException {
        long saveStartTime = System.currentTimeMillis();
        ConfigTemplateVO sessCTVO = this.getCacheEditableTemplateConfigJSON(templateId);
        if (sessCTVO == null) {
            throw new BusinessException(ResourceUtil.getString((String)"cap.template.design.edit.cacheDisabled"));
        }
        CAPBusinessTemplate template = this.capBusinessTemplateManager.getCAPBusinessTemplateById(templateId);
        if (template == null) {
            throw new BusinessException(ResourceUtil.getString((String)"cap.template.design.edit.templateDeleted"));
        }
        User currentUser = AppContext.getCurrentUser();
        this.loggerEditableTemplate(template, "\u5f00\u59cb\u4fdd\u5b58");
        this.doBeforeSaveOrRestoreTemplate(template);
        List<CAPBusinessColumnBO> editableColumnBOS = this.getCacheEditableCAPBusinessColumnBOs(templateId, null, false);
        inputCTVO.setName(template.getName());
        inputCTVO.setState(String.valueOf(template.getState()));
        String runtimeConfigPath = CAPBusinessTemplateUtil.getTemplateConfigPath("runtime", template, true);
        CAPBusinessUtil.writeConfigJSON(runtimeConfigPath, inputCTVO.exportToMap());
        String editableRuntimePath = CAPBusinessTemplateUtil.getTemplatePath("runtime", template, true);
        String dataFolderId = String.valueOf(template.getId());
        if (CAPBusinessEnum.TemplateType.TP_BIZ_INDEX.getType() != template.getTemplateType().intValue()) {
            dataFolderId = String.valueOf(template.getPathId());
        }
        long copyStartTime = System.currentTimeMillis();
        File oldBaseFile = null;
        File oldRuntimeFile = null;
        File oldBaseFileRenameTo = null;
        File oldRuntimeFileRenameTo = null;
        File editableRuntimeFile = null;
        try {
            editableRuntimeFile = new File(editableRuntimePath);
            String oldBasePath = CAPBusinessTemplateUtil.getTemplatePath("base", template, false);
            oldBaseFile = new File(oldBasePath);
            oldBaseFileRenameTo = new File(oldBaseFile.getParent() + File.separator + dataFolderId + "_" + "rename");
            oldBaseFile.renameTo(oldBaseFileRenameTo);
            FileUtil.copyDirectory((File)editableRuntimeFile, (File)oldBaseFile);
            oldRuntimeFile = new File(CAPBusinessTemplateUtil.getTemplatePath("runtime", template, false));
            oldRuntimeFileRenameTo = new File(oldRuntimeFile.getParent() + File.separator + dataFolderId + "_" + "rename");
            oldRuntimeFile.renameTo(oldRuntimeFileRenameTo);
            FileUtil.copyDirectory((File)editableRuntimeFile, (File)oldRuntimeFile);
        }
        catch (IOException e) {
            this.loggerEditableTemplate(template, "\u4fdd\u5b58\u6a21\u677f copyFolder is exception " + e.getMessage(), (Exception)e);
            throw new BusinessException(ResourceUtil.getString((String)"cap.template.design.edit.copyError"));
        }
        this.loggerEditableTemplate(template, "\u4fdd\u5b58\u6a21\u677f copy file use time " + (System.currentTimeMillis() - copyStartTime));
        List<CAPBusinessColumn> dbColumns = this.capBusinessColumnManager.getCAPBusinessColumnsByTemplateId(templateId);
        HashSet<Long> dbColumnIds = new HashSet<Long>();
        for (CAPBusinessColumn column : dbColumns) {
            dbColumnIds.add(column.getId());
        }
        ArrayList<CAPBusinessElementBO> insertElementBOS = new ArrayList<CAPBusinessElementBO>();
        ArrayList<CAPBusinessColumnBO> insertColumnBOS = new ArrayList<CAPBusinessColumnBO>();
        ArrayList<Long> deleteElementByColumnIds = new ArrayList<Long>();
        ArrayList<Long> deleteColumnIds = new ArrayList<Long>();
        for (CAPBusinessColumnBO cAPBusinessColumnBO : editableColumnBOS) {
            Long columnId = Long.valueOf(cAPBusinessColumnBO.getId());
            if (dbColumnIds.contains(columnId)) {
                deleteElementByColumnIds.add(columnId);
                deleteColumnIds.add(columnId);
            }
            cAPBusinessColumnBO.setModifyMemberId(String.valueOf(currentUser.getId()));
            insertColumnBOS.add(cAPBusinessColumnBO);
            insertElementBOS.addAll(cAPBusinessColumnBO.getCapBusinessElementBOs());
        }
        for (CAPBusinessElementBO cAPBusinessElementBO : insertElementBOS) {
            cAPBusinessElementBO.setModifyMemberId(String.valueOf(currentUser.getId()));
        }
        List<String> replacedColumnIds = this.getCacheEditableReplacedColumnIds(templateId);
        if (Strings.isNotEmpty(replacedColumnIds)) {
            for (String str : replacedColumnIds) {
                deleteElementByColumnIds.add(Long.valueOf(str));
                deleteColumnIds.add(Long.valueOf(str));
            }
        }
        long l = System.currentTimeMillis();
        try {
            template.setModifyMember(currentUser.getId());
            List<CAPBusinessColumn> columns = null;
            List<CAPBusinessElement> elements = null;
            if (Strings.isNotEmpty(deleteColumnIds)) {
                columns = this.capBusinessColumnManager.getCAPBusinessColumnsByColumnIds(deleteColumnIds);
            }
            if (Strings.isNotEmpty(deleteElementByColumnIds)) {
                elements = this.capBusinessElementManager.getCAPBusinessElementsByColumnIds(deleteElementByColumnIds);
            }
            this.capBusinessTemplateManager.updateCAPBusinessTemplate(template);
            if (columns != null) {
                this.capBusinessColumnDAO.deleteCAPBusinessColumns(columns);
            }
            if (elements != null) {
                this.capBusinessElementDAO.deleteCAPBusinessElements(elements);
            }
            this.capBusinessColumnManager.saveCAPBusinessColumnBOs(insertColumnBOS);
            this.capBusinessElementManager.saveCAPBusinessElementBOs(insertElementBOS);
        }
        catch (BusinessException e) {
            this.loggerEditableTemplate(template, "\u4fdd\u5b58\u6a21\u677f save db exception " + e.getMessage(), (Exception)((Object)e));
            this.rollbackSaveOrRestoreWhenDbException(oldBaseFile, oldRuntimeFile, oldBaseFileRenameTo, oldRuntimeFileRenameTo);
            throw new BusinessException(ResourceUtil.getString((String)"cap.template.design.edit.saveDbError"));
        }
        long saveDbEndTime = System.currentTimeMillis();
        this.loggerEditableTemplate(template, "\u4fdd\u5b58\u6a21\u677f save db use time " + (saveDbEndTime - l));
        LOGGER.info((Object)("saveEditableTemplate delete columnIds " + ((Object)deleteColumnIds).toString()));
        ArrayList<File> deleteFiles = new ArrayList<File>();
        deleteFiles.add(oldBaseFileRenameTo);
        deleteFiles.add(oldRuntimeFileRenameTo);
        this.capBusinessTemplateManager.addDelayTask(new CAPDeleteTemplateFileRunnable(deleteFiles), 10);
        this.loggerEditableTemplate(template, "\u4fdd\u5b58\u6210\u529f db end to use time " + (System.currentTimeMillis() - saveDbEndTime));
        this.doAfterSaveOrRestoreTemplate(template);
        this.clearEditableCache(template);
        this.putCacheEditableTemplateConfigJSON(templateId, inputCTVO);
        String savePath = CAPBusinessTemplateUtil.getTemplateTempFolder();
        String saveFileName = this.getEditableCacheKey(templateId);
        CAPBackupTemplateFileThread thread = new CAPBackupTemplateFileThread(templateId, savePath, saveFileName);
        thread.start();
        this.loggerEditableTemplate(template, "\u4fdd\u5b58\u5168\u90e8 use time " + (System.currentTimeMillis() - saveStartTime));
    }

    @Override
    public void restoreEditableTemplateToInitial(Long templateId) throws BusinessException {
        Object bo;
        long restoreStartTime = System.currentTimeMillis();
        CAPBusinessTemplate template = this.capBusinessTemplateManager.getCAPBusinessTemplateById(templateId);
        if (template == null) {
            throw new BusinessException(ResourceUtil.getString((String)"cap.template.design.edit.templateDeleted"));
        }
        User currentUser = AppContext.getCurrentUser();
        this.loggerEditableTemplate(template, "\u5f00\u59cb\u6062\u590d\u521d\u59cb");
        this.doBeforeSaveOrRestoreTemplate(template);
        long unzipStartTime = System.currentTimeMillis();
        String initPath = CAPBusinessTemplateUtil.getBaseTemplateInitialBackupFolder();
        File initZipFile = new File(initPath + templateId + ".zip");
        File initDataFile = new File(initPath + templateId + ".json");
        if (!initZipFile.exists() || !initDataFile.exists()) {
            this.loggerEditableTemplate(template, "\u6062\u590d\u521d\u59cb\u6587\u4ef6\u6216\u6570\u636e\u4e0d\u5b58\u5728 " + initZipFile.exists() + " " + initZipFile.getAbsolutePath() + " , " + initDataFile.exists() + " " + initZipFile.getAbsolutePath());
            throw new BusinessException(ResourceUtil.getString((String)"cap.template.design.edit.initFileMissing"));
        }
        File unzipFile = new File(initPath + templateId);
        Map initDataMap = (Map)JSONUtil.parseJSONString((String)FileUtil.readFile((File)initDataFile));
        try {
            ZipUtil.unzip((File)initZipFile, (File)unzipFile);
        }
        catch (IOException e) {
            this.loggerEditableTemplate(template, "\u6062\u590d\u521d\u59cb\u89e3\u538b\u5931\u8d25 " + unzipFile.getAbsolutePath() + e.getMessage(), (Exception)e);
            throw new BusinessException(ResourceUtil.getString((String)"cap.template.design.edit.unzipError"));
        }
        this.loggerEditableTemplate(template, "\u6062\u590d\u6a21\u677f unzip file use time " + (System.currentTimeMillis() - unzipStartTime));
        String memberId = String.valueOf(currentUser.getId());
        CAPBusinessTemplateBO fileTemplateBO = new CAPBusinessTemplateBO();
        fileTemplateBO.importFromJSon((Map)initDataMap.get("template"));
        fileTemplateBO.setCreateMemberId(memberId);
        fileTemplateBO.setModifyMemberId(memberId);
        CAPBusinessTemplate fileTemplate = null;
        try {
            fileTemplate = fileTemplateBO.exportToPO();
        }
        catch (ParseException e) {
            this.loggerEditableTemplate(template, "\u6062\u590d\u521d\u59cb\u6a21\u677f\u6570\u636e\u7ec4\u88c5\u9519\u8bef " + fileTemplateBO.exportToJSon(), (Exception)e);
            throw new BusinessException(ResourceUtil.getString((String)"cap.template.design.edit.dataError"));
        }
        ArrayList<CAPBusinessColumnBO> fileColumnBOS = new ArrayList<CAPBusinessColumnBO>();
        ArrayList<CAPBusinessElementBO> fileElementBOS = new ArrayList<CAPBusinessElementBO>();
        List columnMaps = CAPParamUtil.getParamsListByKey((Map)initDataMap, (String)"columns");
        List elementMaps = CAPParamUtil.getParamsListByKey((Map)initDataMap, (String)"elements");
        for (Map map : columnMaps) {
            bo = new CAPBusinessColumnBO();
            ((CAPBusinessColumnBO)bo).importFromJSon(map);
            ((CAPBusinessColumnBO)bo).setCreateMemberId(memberId);
            ((CAPBusinessColumnBO)bo).setModifyMemberId(memberId);
            fileColumnBOS.add((CAPBusinessColumnBO)bo);
        }
        for (Map map : elementMaps) {
            bo = new CAPBusinessElementBO();
            ((CAPBusinessElementBO)bo).importFromJSon(map);
            ((CAPBusinessElementBO)bo).setCreateMemberId(memberId);
            ((CAPBusinessElementBO)bo).setModifyMemberId(memberId);
            fileElementBOS.add((CAPBusinessElementBO)bo);
        }
        ArrayList<Long> dbColumnIds = new ArrayList<Long>();
        List<CAPBusinessColumn> dbColunms = this.capBusinessColumnManager.getCAPBusinessColumnsByTemplateId(templateId);
        for (CAPBusinessColumn column : dbColunms) {
            dbColumnIds.add(column.getId());
        }
        String basePath = CAPBusinessTemplateUtil.getTemplatePath("base", template, false);
        String runtimePath = CAPBusinessTemplateUtil.getTemplatePath("runtime", template, false);
        String dataFolderId = String.valueOf(template.getId());
        if (CAPBusinessEnum.TemplateType.TP_BIZ_INDEX.getType() != template.getTemplateType().intValue()) {
            dataFolderId = String.valueOf(template.getPathId());
        }
        long copyStartTime = System.currentTimeMillis();
        File oldBaseFile = null;
        File oldRuntimeFile = null;
        File oldBaseFileRenameTo = null;
        File oldRuntimeFileRenameTo = null;
        try {
            oldBaseFile = new File(basePath);
            oldBaseFileRenameTo = new File(oldBaseFile.getParent() + File.separator + dataFolderId + "_" + "rename");
            oldBaseFile.renameTo(oldBaseFileRenameTo);
            oldRuntimeFile = new File(runtimePath);
            oldRuntimeFileRenameTo = new File(oldRuntimeFile.getParent() + File.separator + dataFolderId + "_" + "rename");
            oldRuntimeFile.renameTo(oldRuntimeFileRenameTo);
            FileUtil.copyDirectory((File)unzipFile, (File)oldBaseFile);
            CAPBusinessUtil.copyTemplateFromBaseToRuntime(template, false);
        }
        catch (IOException e) {
            this.loggerEditableTemplate(template, "\u6062\u590d\u521d\u59cb\u62f7\u8d1d\u5931\u8d25 " + unzipFile.getAbsolutePath() + e.getMessage(), (Exception)e);
            throw new BusinessException(ResourceUtil.getString((String)"cap.template.design.edit.copyError"));
        }
        long saveDbStartTime = System.currentTimeMillis();
        this.loggerEditableTemplate(template, "\u6062\u590d\u521d\u59cb copy use time " + (saveDbStartTime - copyStartTime));
        try {
            List<CAPBusinessColumn> columns = null;
            List<CAPBusinessElement> elements = null;
            if (Strings.isNotEmpty(dbColumnIds)) {
                columns = this.capBusinessColumnManager.getCAPBusinessColumnsByColumnIds(dbColumnIds);
                elements = this.capBusinessElementManager.getCAPBusinessElementsByColumnIds(dbColumnIds);
            }
            if (columns != null) {
                this.capBusinessColumnDAO.deleteCAPBusinessColumns(columns);
            }
            if (elements != null) {
                this.capBusinessElementDAO.deleteCAPBusinessElements(elements);
            }
            this.capBusinessTemplateManager.updateCAPBusinessTemplate(fileTemplate);
            this.capBusinessColumnManager.saveCAPBusinessColumnBOs(fileColumnBOS);
            this.capBusinessElementManager.saveCAPBusinessElementBOs(fileElementBOS);
        }
        catch (BusinessException e) {
            this.loggerEditableTemplate(template, "\u6062\u590d\u521d\u59cb save db exception " + e.getMessage(), (Exception)((Object)e));
            this.rollbackSaveOrRestoreWhenDbException(oldBaseFile, oldRuntimeFile, oldBaseFileRenameTo, oldRuntimeFileRenameTo);
            throw new BusinessException(ResourceUtil.getString((String)"cap.template.design.edit.saveDbError"));
        }
        long saveDbEndTime = System.currentTimeMillis();
        this.loggerEditableTemplate(template, "\u6062\u590d\u521d\u59cb save db use time " + (saveDbEndTime - saveDbStartTime));
        ArrayList<File> deleteFiles = new ArrayList<File>();
        deleteFiles.add(oldBaseFileRenameTo);
        deleteFiles.add(oldRuntimeFileRenameTo);
        this.capBusinessTemplateManager.addDelayTask(new CAPDeleteTemplateFileRunnable(deleteFiles), 10);
        this.loggerEditableTemplate(template, "\u6062\u590d\u521d\u59cb\u6210\u529f db end to use time " + (System.currentTimeMillis() - saveDbEndTime));
        this.doAfterSaveOrRestoreTemplate(fileTemplate);
        this.clearEditableCache(fileTemplate);
        this.clearEditableFile(fileTemplate);
        this.loggerEditableTemplate(template, "\u6062\u590d\u521d\u59cb\u5168\u90e8 use time " + (System.currentTimeMillis() - restoreStartTime));
    }

    private void doBeforeSaveOrRestoreTemplate(CAPBusinessTemplate template) throws BusinessException {
        long startTime = System.currentTimeMillis();
        String backEditPath = CAPBusinessTemplateUtil.getTemplateTempFolder();
        String fileName = this.getEditableCacheKey(template.getId());
        File backFile = new File(backEditPath + File.separator + fileName + ".zip");
        if (!backFile.exists()) {
            this.capBusinessTemplateManager.zipTemplateFileWithData(template.getId(), backEditPath, fileName);
            this.loggerEditableTemplate(template, " \u5907\u4efd\u8def\u5f84:" + backEditPath + " , \u6587\u4ef6\u540d:" + fileName);
        }
        this.loggerEditableTemplate(template, "doBeforeSaveOrRestoreTemplate use time " + (System.currentTimeMillis() - startTime));
    }

    private void doAfterSaveOrRestoreTemplate(CAPBusinessTemplate template) {
        long startTime = System.currentTimeMillis();
        this.capBusinessTemplateClusterManager.sendSaveEditableTemplate(template.getId(), false);
        this.loggerEditableTemplate(template, "\u96c6\u7fa4\u901a\u77e5, use time " + (System.currentTimeMillis() - startTime));
        if (CAPBusinessEnum.Platform.MOBILE.getType() == template.getClient().intValue()) {
            long buildStartTime = System.currentTimeMillis();
            ArrayList<CAPBuildTemplateVO> waitBuildTemplates = new ArrayList<CAPBuildTemplateVO>();
            CAPBuildTemplateVO vo = new CAPBuildTemplateVO(template.getEggId(), template.getId(), template.getTemplateType(), template.getClient(), template.getPathId());
            waitBuildTemplates.add(vo);
            CAPBuildM3Util.buildMobileCAPTemplatePackage(waitBuildTemplates, true);
            this.loggerEditableTemplate(template, "M3\u6784\u5efa, use time " + (System.currentTimeMillis() - buildStartTime));
        }
        this.clearEditableBackupFile(template);
        this.loggerEditableTemplate(template, "doAfterSaveOrRestoreTemplate use time " + (System.currentTimeMillis() - startTime));
    }

    private void rollbackSaveOrRestoreWhenDbException(File oldBaseFile, File oldRuntimeFile, File oldBaseFileRenameTo, File oldRuntimeFileRenameTo) throws BusinessException {
        FileUtil.deleteDirectory((File)oldBaseFile);
        FileUtil.deleteDirectory((File)oldRuntimeFile);
        try {
            FileUtil.copyDirectory((File)oldBaseFileRenameTo, (File)oldBaseFile);
            FileUtil.copyDirectory((File)oldRuntimeFileRenameTo, (File)oldRuntimeFile);
        }
        catch (IOException e) {
            LOGGER.error((Object)("rollbackSaveOrRestoreWhenDbException is error " + e.getMessage()), (Throwable)e);
            throw new BusinessException(ResourceUtil.getString((String)"cap.template.design.edit.saveRollbackError"));
        }
    }

    private void loggerEditableTemplate(CAPBusinessTemplateBO templateBO, String message) {
        this.loggerEditableTemplate(templateBO, message, null);
    }

    private void loggerEditableTemplate(CAPBusinessTemplate template, String message) {
        this.loggerEditableTemplate(template, message, null);
    }

    private void loggerEditableTemplate(CAPBusinessTemplateBO templateBO, String message, Exception e) {
        User currentUser = AppContext.getCurrentUser();
        String str = currentUser.getId() + "," + currentUser.getName() + ",\u6a21\u677f:" + templateBO.getId() + "," + templateBO.getName() + ",message:" + message;
        if (e == null) {
            LOGGER.info((Object)str);
        } else {
            LOGGER.error((Object)str, (Throwable)e);
        }
    }

    private void loggerEditableTemplate(CAPBusinessTemplate template, String message, Exception e) {
        User currentUser = AppContext.getCurrentUser();
        String str = "";
        str = currentUser == null ? str + "user is null, delete by thread " : str + currentUser.getId() + "," + currentUser.getName();
        str = str + ",\u6a21\u677f:" + template.getId() + "," + template.getName() + ",message:" + message;
        if (e == null) {
            LOGGER.info((Object)str);
        } else {
            LOGGER.error((Object)str, (Throwable)e);
        }
    }

    @Override
    public boolean initForEdit(CAPBusinessTemplateBO templateBO) throws BusinessException {
        long startTime = System.currentTimeMillis();
        CAPBusinessTemplate template = null;
        try {
            template = templateBO.exportToPO();
        }
        catch (ParseException e) {
            this.loggerEditableTemplate(templateBO, e.getMessage(), (Exception)e);
        }
        if (template == null) {
            throw new BusinessException(ResourceUtil.getString((String)"cap.template.design.edit.templateDeleted"));
        }
        ConfigTemplateVO cacheCTVO = this.getCacheEditableTemplateConfigJSON(template.getId());
        if (cacheCTVO == null) {
            String savePath = CAPBusinessTemplateUtil.getTemplateTempFolder();
            String saveFileName = this.getEditableCacheKey(template.getId());
            CAPBackupTemplateFileThread thread = new CAPBackupTemplateFileThread(template.getId(), savePath, saveFileName);
            thread.start();
        }
        this.clearEditableCache(template);
        this.clearEditableFile(template);
        this.copyTemplateFilesForEdit(template.getId());
        ConfigTemplateVO configTemplateVO = this.capBusinessTemplateManager.getConfigTemplateVO(template.getId());
        if (configTemplateVO == null) {
            throw new BusinessException(ResourceUtil.getString((String)"cap.template.design.edit.readConfigError"));
        }
        this.putCacheEditableTemplateConfigJSON(template.getId(), configTemplateVO);
        this.loggerEditableTemplate(templateBO, "\u6253\u5f00\u7f16\u8f91 use time " + (System.currentTimeMillis() - startTime));
        return false;
    }

    @Override
    public void copyTemplateFilesForEdit(Long templateId) throws BusinessException {
        ArrayList<Long> list = new ArrayList<Long>(1);
        list.add(templateId);
        this.copyTemplatesFilesForEdit(list);
    }

    @Override
    public void copyTemplatesFilesForEdit(List<Long> templateIds) throws BusinessException {
        long startTime = System.currentTimeMillis();
        List<CAPBusinessTemplateBO> capBusinessTemplateBOS = this.capBusinessTemplateManager.getCAPBusinessTemplateBOsByIds(templateIds);
        try {
            for (CAPBusinessTemplateBO bo : capBusinessTemplateBOS) {
                String srcPath = CAPBusinessTemplateUtil.getTemplatePath("runtime", bo, false);
                String destPath = CAPBusinessTemplateUtil.getTemplatePath("runtime", bo, true);
                FileUtil.copyDirectory((String)srcPath, (String)destPath);
            }
        }
        catch (IOException e) {
            LOGGER.error((Object)("copyTemplatesFileForEdit is exception " + e.getMessage()), (Throwable)e);
            throw new BusinessException((Throwable)e);
        }
        LOGGER.info((Object)("copyTemplatesFilesForEdit use time " + (System.currentTimeMillis() - startTime)));
    }

    @Override
    public ConfigTemplateVO getCacheEditableTemplateConfigJSON(Long templateId) throws BusinessException {
        String dataKey;
        String data;
        ConfigTemplateVO configTemplateVO = null;
        if (templateId != null && (data = (String)CAPTemplateEditableConfigCache.instance.get(dataKey = this.getEditableCacheKey(templateId))) != null) {
            Map map = (Map)JSONUtil.parseJSONString((String)data);
            configTemplateVO = new ConfigTemplateVO();
            configTemplateVO.importFromMap(map);
        }
        return configTemplateVO;
    }

    @Override
    public void putCacheEditableTemplateConfigJSON(Long templateId, ConfigTemplateVO configTemplateVO) throws BusinessException {
        String dataKey = this.getEditableCacheKey(templateId);
        if (configTemplateVO == null) {
            LOGGER.info((Object)("putCacheEditableTemplateConfigJSON clear " + dataKey));
            CAPTemplateEditableConfigCache.instance.remove(dataKey);
        } else {
            CAPTemplateEditableConfigCache.instance.set(dataKey, JSONUtil.toJSONString(configTemplateVO.exportToMap()));
        }
    }

    @Override
    public void cancelEditTemplate(Long templateId) throws BusinessException {
        CAPBusinessTemplate template = this.capBusinessTemplateManager.getCAPBusinessTemplateById(templateId);
        if (template == null) {
            throw new BusinessException(ResourceUtil.getString((String)"cap.template.design.edit.templateDeleted"));
        }
        this.clearEditableCache(template);
        this.clearEditableFile(template);
        this.clearEditableBackupFile(template);
    }

    private void clearEditableFile(CAPBusinessTemplate template) {
        long startTime = System.currentTimeMillis();
        String editRuntimePath = CAPBusinessTemplateUtil.getTemplatePath("runtime", template, true);
        if (Strings.isNotBlank((String)editRuntimePath)) {
            FileUtil.deleteDirectory((String)editRuntimePath);
        }
        this.loggerEditableTemplate(template, "\u6e05\u9664\u6a21\u677f\u7f16\u8f91\u6587\u4ef6 use time " + (System.currentTimeMillis() - startTime));
    }

    @Override
    public void clearEditableBackupFile(CAPBusinessTemplate template) {
        long startTime = System.currentTimeMillis();
        String backEditPath = CAPBusinessTemplateUtil.getTemplateTempFolder();
        Long userId = AppContext.currentUserId();
        userId = userId == null ? template.getModifyMember() : userId;
        String fileName = this.getEditableCacheKey(template.getId(), userId);
        FileUtil.deleteFile((String)(backEditPath + File.separator + fileName + ".zip"));
        FileUtil.deleteFile((String)(backEditPath + File.separator + fileName + ".json"));
        this.loggerEditableTemplate(template, "clearEditableBackupFile use time " + (System.currentTimeMillis() - startTime) + " \u5220\u9664\u5907\u4efd\u8def\u5f84:" + backEditPath + " , \u6587\u4ef6\u540d:" + fileName);
    }

    private void clearEditableCache(CAPBusinessTemplate template) {
        long startTime = System.currentTimeMillis();
        this.clearEditableCache(template.getId());
        this.loggerEditableTemplate(template, "\u6e05\u9664\u6a21\u677f\u7f16\u8f91cache use time " + (System.currentTimeMillis() - startTime));
    }

    private void clearEditableCache(Long templateId) {
        String key = this.getEditableCacheKey(templateId);
        CAPTemplateEditableConfigCache.instance.remove(key);
        CAPTemplateEditableColumnCache.instance.remove(key);
        CAPTemplateEditablePreDataSourceCache.instance.remove(key);
        CAPTemplateEditableColumnReplacedIdsCache.instance.remove(key);
    }

    private String getEditableCacheKey(Long templateId) {
        return this.getEditableCacheKey(templateId, AppContext.currentUserId());
    }

    private String getEditableCacheKey(Long templateId, Long userId) {
        return userId + "_" + templateId;
    }

    @Override
    public CAPBusinessColumnBO getCacheEditableCAPBusinessColumnBO(Long templateId, Long columnId) throws BusinessException {
        String key = this.getEditableCacheKey(templateId);
        Map<String, Object> allMap = this.getCacheEditableColumnMap(key);
        CAPBusinessColumnBO bo = null;
        if (allMap.get(String.valueOf(columnId)) != null) {
            bo = new CAPBusinessColumnBO();
            bo.importFromJSon((Map)allMap.get(String.valueOf(columnId)));
        }
        return bo;
    }

    @Override
    public List<CAPBusinessColumnBO> getCacheEditableCAPBusinessColumnBOs(Long templateId, List<String> columnIds, boolean clearColumnIdsIfHas) throws BusinessException {
        String key = this.getEditableCacheKey(templateId);
        Map<String, Object> allMap = this.getCacheEditableColumnMap(key);
        ArrayList<CAPBusinessColumnBO> bos = null;
        if (columnIds == null) {
            bos = new ArrayList<CAPBusinessColumnBO>(allMap.size());
            for (String ik : allMap.keySet()) {
                CAPBusinessColumnBO bo = new CAPBusinessColumnBO();
                bo.importFromJSon((Map)allMap.get(ik));
                bos.add(bo);
            }
        } else {
            bos = new ArrayList(columnIds.size());
            Iterator<String> iterator = columnIds.iterator();
            while (iterator.hasNext()) {
                String columnId = iterator.next();
                if (allMap.get(columnId) == null) continue;
                CAPBusinessColumnBO bo = new CAPBusinessColumnBO();
                bo.importFromJSon((Map)allMap.get(columnId));
                bos.add(bo);
                if (!clearColumnIdsIfHas) continue;
                iterator.remove();
            }
        }
        return bos;
    }

    @Override
    public List<CAPBusinessColumnBO> getAllCAPBusinessColumnBOs(Long templateId) throws BusinessException {
        List<CAPBusinessColumnBO> editableBos = this.getCacheEditableCAPBusinessColumnBOs(templateId, null, false);
        HashSet<String> editableIds = new HashSet<String>();
        if (editableBos != null) {
            for (CAPBusinessColumnBO bo : editableBos) {
                editableIds.add(bo.getId());
            }
        }
        List<CAPBusinessColumnBO> dbColumnBos = this.capBusinessColumnManager.getCAPBusinessColumnBOsByTemplateId(templateId);
        List<String> replacedIds = this.getCacheEditableReplacedColumnIds(templateId);
        if (dbColumnBos != null) {
            if (editableBos == null) {
                editableBos = new ArrayList<CAPBusinessColumnBO>();
            }
            for (CAPBusinessColumnBO bo : dbColumnBos) {
                boolean isReplaced;
                if (editableIds.contains(bo.getId()) || (isReplaced = replacedIds == null ? false : replacedIds.contains(bo.getId()))) continue;
                editableBos.add(bo);
            }
        }
        return editableBos;
    }

    @Override
    public void putCacheEditableCAPBusinessColumnBO(CAPBusinessColumnBO capBusinessColumnBO, Long oldColumnId) throws BusinessException {
        String key = this.getEditableCacheKey(Long.valueOf(capBusinessColumnBO.getTemplateId()));
        Map<String, Object> allMap = this.getCacheEditableColumnMap(key);
        allMap.remove(capBusinessColumnBO.getId());
        if (oldColumnId != null) {
            allMap.remove(String.valueOf(oldColumnId));
        }
        allMap.put(capBusinessColumnBO.getId(), capBusinessColumnBO.exportToJSon());
        CAPTemplateEditableColumnCache.instance.set(key, JSONUtil.toJSONString(allMap));
    }

    private void putCacheEditableCAPBusinessColumnBOs(Long templateId, List<CAPBusinessColumnBO> capBusinessColumnBOS) throws BusinessException {
        if (Strings.isNotEmpty(capBusinessColumnBOS)) {
            String key = this.getEditableCacheKey(templateId);
            Map<String, Object> allMap = this.getCacheEditableColumnMap(key);
            for (CAPBusinessColumnBO bo : capBusinessColumnBOS) {
                allMap.put(bo.getId(), bo.exportToJSon());
            }
            CAPTemplateEditableColumnCache.instance.set(key, JSONUtil.toJSONString(allMap));
        }
    }

    @Override
    public void updateCacheEditableColumns(Long templateId, List<Long> columnIds, Map<String, Object> operation2Value) throws BusinessException {
        ArrayList<CAPBusinessColumnBO> capBusinessColumnBOS = new ArrayList<CAPBusinessColumnBO>();
        try {
            ArrayList<Long> dbColumnIds = new ArrayList<Long>();
            for (Long columnId : columnIds) {
                CAPBusinessColumnBO columnBO = this.getCacheEditableCAPBusinessColumnBO(templateId, columnId);
                if (columnBO == null) {
                    dbColumnIds.add(columnId);
                    continue;
                }
                capBusinessColumnBOS.add(columnBO);
            }
            if (!dbColumnIds.isEmpty()) {
                List<CAPBusinessColumnBO> dbColumnBOs = this.capBusinessColumnManager.getCAPBusinessColumnBOsByTemplateId(templateId);
                HashMap<String, CAPBusinessColumnBO> dbColumnId2BoMap = new HashMap<String, CAPBusinessColumnBO>();
                for (CAPBusinessColumnBO bo : dbColumnBOs) {
                    dbColumnId2BoMap.put(bo.getId(), bo);
                }
                for (Long columnId : dbColumnIds) {
                    CAPBusinessColumnBO columnBO = this.cloneCAPBusinessColumnBOWithElementBOs((CAPBusinessColumnBO)dbColumnId2BoMap.get(String.valueOf(columnId)));
                    capBusinessColumnBOS.add(columnBO);
                }
            }
        }
        catch (CloneNotSupportedException e) {
            LOGGER.error((Object)("updateCacheEditableCAPBusinessColumnBOs is clone exception " + e.getMessage()), (Throwable)e);
            throw new BusinessException((Throwable)e);
        }
        for (CAPBusinessColumnBO bo : capBusinessColumnBOS) {
            for (String key : operation2Value.keySet()) {
                if ("name".equals(key)) {
                    bo.setName(String.valueOf(operation2Value.get(key)));
                    continue;
                }
                if (!"state".equals(key)) continue;
                bo.setState(String.valueOf(operation2Value.get(key)));
            }
        }
        this.putCacheEditableCAPBusinessColumnBOs(templateId, capBusinessColumnBOS);
    }

    @Override
    public void removeCacheEditableCAPBusinessColumnBO(Long templateId, Long columnId) {
        String key = this.getEditableCacheKey(templateId);
        Map<String, Object> allMap = this.getCacheEditableColumnMap(key);
        allMap.remove(String.valueOf(columnId));
        CAPTemplateEditableColumnCache.instance.set(key, JSONUtil.toJSONString(allMap));
    }

    private Map<String, Object> getCacheEditableColumnMap(String key) {
        String allStr = (String)CAPTemplateEditableColumnCache.instance.get(key);
        HashMap<String, Object> allMap = allStr == null ? new HashMap() : (Map)JSONUtil.parseJSONString((String)allStr);
        return allMap;
    }

    @Override
    public List<CAPBusinessElementBO> getEditableCAPBusinessElementBOs(Long templateId, Long columnId, boolean nullWhenQuery) throws BusinessException {
        List<CAPBusinessElementBO> capBusinessElementBOS = null;
        CAPBusinessColumnBO capBusinessColumnBO = this.getCacheEditableCAPBusinessColumnBO(templateId, columnId);
        if (capBusinessColumnBO == null) {
            if (nullWhenQuery) {
                capBusinessElementBOS = this.capBusinessElementManager.getCAPBusinessElementBOsByColumnId(columnId);
            }
        } else {
            capBusinessElementBOS = capBusinessColumnBO.getCapBusinessElementBOs();
        }
        return capBusinessElementBOS;
    }

    @Override
    public List<CAPBusinessElementBO> updateCacheEditableElement(Long templateId, Long columnId, Map<String, Object> elementMap) throws BusinessException {
        CAPBusinessColumnBO cacheColumnBO = this.getCacheEditableCAPBusinessColumnBO(templateId, columnId);
        if (cacheColumnBO == null) {
            try {
                List<CAPBusinessColumnBO> capBusinessColumnBOS = this.capBusinessColumnManager.getCAPBusinessColumnBOsByTemplateId(templateId);
                for (CAPBusinessColumnBO columnBO : capBusinessColumnBOS) {
                    if (!columnBO.getId().equals(String.valueOf(columnId))) continue;
                    cacheColumnBO = this.cloneCAPBusinessColumnBOWithElementBOs(columnBO);
                    break;
                }
            }
            catch (CloneNotSupportedException e) {
                LOGGER.error((Object)("putCacheEditableElementDataSource is exception " + e.getMessage()), (Throwable)e);
                throw new BusinessException((Throwable)e);
            }
        }
        if (cacheColumnBO == null) {
            LOGGER.error((Object)("putCacheEditableElementDataSource column is null " + columnId));
            throw new BusinessException(ResourceUtil.getString((String)"cap.template.design.edit.columnMissing"));
        }
        List<CAPBusinessElementBO> elementBOS = cacheColumnBO.getCapBusinessElementBOs();
        if (elementBOS == null) {
            LOGGER.error((Object)"putCacheEditableElementDataSource \u6ca1\u6709\u5143\u7d20\u53ef\u7528\u4e8e\u914d\u7f6e\u6570\u636e\u6e90");
            throw new BusinessException(ResourceUtil.getString((String)"cap.template.design.edit.elementEmpty"));
        }
        String time = DateUtil.currentDateString((String)"yyyy-MM-dd HH:mm:ss");
        for (CAPBusinessElementBO elementBO : elementBOS) {
            Map dataInfo;
            if (!elementBO.getId().equals(elementMap.get("id"))) continue;
            Map map = dataInfo = elementMap.get("dataInfo") == null ? null : (Map)elementMap.get("dataInfo");
            if (dataInfo != null) {
                dataInfo.put("dataInfoTime", time);
                dataInfo.put("dataInfoType", elementBO.getElementType());
                dataInfo.put("sort", elementBO.getSort());
            }
            elementBO.setDataInfo(dataInfo);
            elementBO.setName((String)elementMap.get("name"));
        }
        this.putCacheEditableCAPBusinessColumnBO(cacheColumnBO, null);
        return elementBOS;
    }

    @Override
    public void autoMatchEditableElementDataSource(Long bizId, Long templateId) throws BusinessException {
        List<CAPBusinessTemplateBO> capBusinessTemplateBOList = this.capBusinessTemplateManager.getCAPBusinessTemplatesByBizId(bizId);
        HashSet<Long> rangeColumnIds = new HashSet<Long>();
        CAPBusinessTemplateBO nowTemplateBO = null;
        for (CAPBusinessTemplateBO capBusinessTemplateBO : capBusinessTemplateBOList) {
            if (templateId.equals(Long.valueOf(capBusinessTemplateBO.getId()))) {
                nowTemplateBO = capBusinessTemplateBO;
                continue;
            }
            List<CAPBusinessColumnBO> capBusinessColumnBOs = this.capBusinessColumnManager.getCAPBusinessColumnBOsByTemplateId(Long.valueOf(capBusinessTemplateBO.getId()));
            Iterator iterator = capBusinessColumnBOs.iterator();
            while (iterator.hasNext()) {
                CAPBusinessColumnBO capBusinessColumnBO = (CAPBusinessColumnBO)iterator.next();
                rangeColumnIds.add(Long.valueOf(capBusinessColumnBO.getId()));
            }
        }
        if (rangeColumnIds.isEmpty()) {
            this.loggerEditableTemplate(nowTemplateBO, "rangeColumnIds is empty , can't do auto match");
        } else {
            HashSet<String> editableColumnIds = new HashSet<String>();
            List<CAPBusinessColumnBO> editableColumnBOs = this.getCacheEditableCAPBusinessColumnBOs(templateId, null, false);
            for (CAPBusinessColumnBO bo : editableColumnBOs) {
                editableColumnIds.add(bo.getId());
            }
            ArrayList<CAPBusinessColumnBO> needPutToEditable = new ArrayList<CAPBusinessColumnBO>();
            List<CAPBusinessColumnBO> allDbColumnBOs = this.capBusinessColumnManager.getCAPBusinessColumnBOsByTemplateId(templateId);
            for (CAPBusinessColumnBO cAPBusinessColumnBO : allDbColumnBOs) {
                if (editableColumnIds.contains(cAPBusinessColumnBO.getId())) continue;
                boolean bl = false;
                List<CAPBusinessElementBO> capBusinessElementBOs = this.capBusinessElementManager.getCAPBusinessElementBOsByColumnId(Long.valueOf(cAPBusinessColumnBO.getId()));
                for (CAPBusinessElementBO elementBO : capBusinessElementBOs) {
                    if (elementBO.getDataInfo() != null || bl) continue;
                    bl = true;
                    break;
                }
                if (!bl) continue;
                needPutToEditable.add(cAPBusinessColumnBO);
            }
            List<String> replacedColumnIds = this.getCacheEditableReplacedColumnIds(templateId);
            try {
                for (CAPBusinessColumnBO cAPBusinessColumnBO : needPutToEditable) {
                    if (Strings.isNotEmpty(replacedColumnIds) && replacedColumnIds.contains(cAPBusinessColumnBO.getId())) continue;
                    editableColumnBOs.add(this.cloneCAPBusinessColumnBOWithElementBOs(cAPBusinessColumnBO));
                }
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                LOGGER.error((Object)("autoMatchEditableElementDataSource is clone exception " + templateId), (Throwable)cloneNotSupportedException);
                throw new BusinessException((Throwable)cloneNotSupportedException);
            }
            if (Strings.isEmpty(editableColumnBOs)) {
                this.loggerEditableTemplate(nowTemplateBO, ResourceUtil.getString((String)"cap.template.design.edit.columnAutoEmpty"));
            } else {
                HashMap<String, Map<String, Object>> hashMap = new HashMap<String, Map<String, Object>>();
                String string = DateUtil.currentDateString((String)"yyyy-MM-dd HH:mm:ss");
                HashSet<String> configedColumnIds = new HashSet<String>();
                for (CAPBusinessColumnBO columnBO : editableColumnBOs) {
                    if (columnBO.getCapBusinessElementBOs() == null) continue;
                    for (CAPBusinessElementBO elementBO : columnBO.getCapBusinessElementBOs()) {
                        Map<String, Object> info;
                        if (elementBO.getDataInfo() != null) continue;
                        String key = elementBO.getElementType() + "_" + elementBO.getName() + "_" + columnBO.getName();
                        if (hashMap.containsKey(key)) {
                            info = (Map<String, Object>)hashMap.get(key);
                        } else {
                            info = this.queryElementDataSource(elementBO.getElementType(), elementBO.getName(), columnBO.getName(), rangeColumnIds);
                            hashMap.put(key, info);
                        }
                        if (info == null) continue;
                        info.put("dataInfoTime", string);
                        info.put("dataInfoType", elementBO.getElementType());
                        info.put("sort", elementBO.getSort());
                        elementBO.setDataInfo(info);
                        configedColumnIds.add(columnBO.getId());
                    }
                }
                Iterator<CAPBusinessColumnBO> iterator = editableColumnBOs.iterator();
                while (iterator.hasNext()) {
                    CAPBusinessColumnBO bo = iterator.next();
                    if (configedColumnIds.contains(bo.getId())) continue;
                    iterator.remove();
                }
                this.putCacheEditableCAPBusinessColumnBOs(templateId, editableColumnBOs);
            }
        }
    }

    @Override
    public CAPBusinessColumnBO cloneCAPBusinessColumnBOWithElementBOs(CAPBusinessColumnBO bo) throws BusinessException, CloneNotSupportedException {
        CAPBusinessColumnBO cloneBo = (CAPBusinessColumnBO)bo.clone();
        ArrayList<CAPBusinessElementBO> cloneElementBOs = new ArrayList<CAPBusinessElementBO>();
        List<CAPBusinessElementBO> capBusinessElementBOs = this.capBusinessElementManager.getCAPBusinessElementBOsByColumnId(Long.valueOf(bo.getId()));
        for (CAPBusinessElementBO elementBO : capBusinessElementBOs) {
            CAPBusinessElementBO cloneElementBO = (CAPBusinessElementBO)elementBO.clone();
            cloneElementBOs.add(cloneElementBO);
        }
        cloneBo.setCapBusinessElementBOs(cloneElementBOs);
        return cloneBo;
    }

    @Override
    public void putCacheEditableColumnPreDataSource(Long templateId, Long columnId, Map<String, Object> lastDataSourceMap, Long removeColumnId) throws BusinessException {
        String key = this.getEditableCacheKey(templateId);
        Map<String, Object> allMap = this.getCacheEditableColumnPreDataSourceAllMap(key);
        if (allMap == null) {
            allMap = new HashMap<String, Object>();
        }
        if (removeColumnId == null) {
            allMap.remove(String.valueOf(removeColumnId));
        }
        allMap.put(String.valueOf(columnId), lastDataSourceMap);
        CAPTemplateEditablePreDataSourceCache.instance.set(key, JSONUtil.toJSONString(allMap));
    }

    @Override
    public Map<String, Object> getCacheEditableColumnPreDataSource(Long templateId, Long columnId) throws BusinessException {
        String key = this.getEditableCacheKey(templateId);
        Map<String, Object> allMap = this.getCacheEditableColumnPreDataSourceAllMap(key);
        Map map = null;
        if (allMap != null && allMap.get(String.valueOf(columnId)) != null) {
            map = (Map)allMap.get(String.valueOf(columnId));
        }
        return map;
    }

    private Map<String, Object> getCacheEditableColumnPreDataSourceAllMap(String key) {
        String str = (String)CAPTemplateEditablePreDataSourceCache.instance.get(key);
        Map allMap = null;
        if (str != null) {
            allMap = (Map)JSONUtil.parseJSONString((String)str, Map.class);
        }
        return allMap;
    }

    @Override
    public void putCacheEditableReplacedColumnIds(Long templateId, Long columnId) throws BusinessException {
        List<String> list = this.getCacheEditableReplacedColumnIds(templateId);
        if (list == null) {
            list = new LinkedList<String>();
        }
        list.add(String.valueOf(columnId));
        CAPTemplateEditableColumnReplacedIdsCache.instance.set(this.getEditableCacheKey(templateId), JSONUtil.toJSONString(list));
    }

    private List<String> getCacheEditableReplacedColumnIds(Long templateId) {
        String key = this.getEditableCacheKey(templateId);
        String str = (String)CAPTemplateEditableColumnReplacedIdsCache.instance.get(key);
        List sets = null;
        if (str != null) {
            sets = (List)JSONUtil.parseJSONString((String)str);
        }
        return sets;
    }

    @Override
    public void initializeStart() {
        long startTime = System.currentTimeMillis();
        CAPTemplateEditableConfigCache.instance.init();
        CAPTemplateEditableColumnCache.instance.init();
        CAPTemplateEditablePreDataSourceCache.instance.init();
        CAPTemplateEditableColumnReplacedIdsCache.instance.init();
        LOGGER.info((Object)("\u521d\u59cb\u5316CAP\u81ea\u5b9a\u4e49\u7f16\u8f91\u6001\u7f13\u5b58\uff0c\u8017\u65f6\uff1a" + (System.currentTimeMillis() - startTime) + " MS"));
    }

    private Map<String, Object> queryElementDataSource(String elementType, String elementName, String columnName, Set<Long> rangeColumnIds) throws BusinessException {
        HashMap<String, Object> queryParams = new HashMap<String, Object>(3);
        queryParams.put("elementType", Integer.valueOf(elementType));
        queryParams.put("name", elementName);
        queryParams.put("columnName", columnName);
        queryParams.put("columnId", rangeColumnIds);
        List<CAPBusinessElement> queryedElements = this.capBusinessElementDAO.getConfigedCAPBusinessElementsByParams(queryParams);
        String dataInfo = queryedElements == null || queryedElements.size() == 0 || queryedElements.get(0) == null ? null : queryedElements.get(0).getDataInfo();
        return dataInfo == null ? null : (Map)JSONUtil.parseJSONString(dataInfo);
    }

    public void setCapBusinessTemplateManager(CAPBusinessTemplateManager capBusinessTemplateManager) {
        this.capBusinessTemplateManager = capBusinessTemplateManager;
    }

    public void setCapBusinessElementManager(CAPBusinessElementManager capBusinessElementManager) {
        this.capBusinessElementManager = capBusinessElementManager;
    }

    public void setCapBusinessColumnManager(CAPBusinessColumnManager capBusinessColumnManager) {
        this.capBusinessColumnManager = capBusinessColumnManager;
    }

    public void setCapBusinessTemplateClusterManager(CAPBusinessTemplateClusterManager capBusinessTemplateClusterManager) {
        this.capBusinessTemplateClusterManager = capBusinessTemplateClusterManager;
    }

    public void setCapBusinessColumnDAO(CAPBusinessColumnDAO capBusinessColumnDAO) {
        this.capBusinessColumnDAO = capBusinessColumnDAO;
    }

    public void setCapBusinessElementDAO(CAPBusinessElementDAO capBusinessElementDAO) {
        this.capBusinessElementDAO = capBusinessElementDAO;
    }
}

