/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.cap4.template.manager.impl;

import com.seeyon.cap4.form.service.CAP4FormCache;
import com.seeyon.cap4.form.service.CAP4FormCacheManager;
import com.seeyon.cap4.template.bo.CAPBusinessTemplateBO;
import com.seeyon.cap4.template.constant.CAPBusinessEnum;
import com.seeyon.cap4.template.manager.CAPBusinessTemplateClusterManager;
import com.seeyon.cap4.template.manager.CAPBusinessTemplateManager;
import com.seeyon.cap4.template.po.CAPBusinessTemplate;
import com.seeyon.cap4.template.util.CAPBusinessTemplateUtil;
import com.seeyon.cap4.template.util.CAPBusinessUtil;
import com.seeyon.cap4.template.util.CAPParamUtil;
import com.seeyon.cap4.template.util.FileUtil;
import com.seeyon.ctp.common.AppContext;
import com.seeyon.ctp.common.exceptions.BusinessException;
import com.seeyon.ctp.common.log.CtpLogFactory;
import com.seeyon.ctp.util.Strings;
import java.io.IOException;
import java.lang.constant.Constable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;

public class CAPBusinessTemplateClusterManagerImpl
implements CAPBusinessTemplateClusterManager {
    private static final Log LOGGER = CtpLogFactory.getLog(CAPBusinessTemplateClusterManagerImpl.class);
    private static final String BIZ_ID = "bizId";
    private static final String TYPE = "type";
    private static final String TEMPLATE_ID = "templateId";
    private static final String TEMPLATE_IDS = "templateIds";
    private static final String IS_EDIT = "isEdit";
    private static final String UPDATE_COLUMN = "updateColumn";
    private static final String UPDATE_ELEMENT = "updateElement";
    private static final String DATA_IDS = "dataIds";
    private static final String TEMPLATES = "templates";
    private CAPBusinessTemplateManager capBusinessTemplateManager;
    private CAP4FormCacheManager cap4FormCacheManager;

    @Override
    public void sendSaveEditableTemplate(Long templateId, boolean isEdit) {
        HashMap<String, Constable> clusterArgs = new HashMap<String, Constable>(2);
        clusterArgs.put(TEMPLATE_ID, templateId);
        clusterArgs.put(IS_EDIT, Boolean.valueOf(isEdit));
        this.cap4FormCacheManager.sendNotification(clusterArgs, CAP4FormCache.FormCacheType.CustomTemplate_Save_Editable_Template, templateId);
    }

    @Override
    public void sendImportBusiness(Long newEggId) {
        HashMap<String, Long> clusterArgs = new HashMap<String, Long>(1);
        clusterArgs.put(BIZ_ID, newEggId);
        this.cap4FormCacheManager.sendNotification(clusterArgs, CAP4FormCache.FormCacheType.CustomTemplate_Import_Business, newEggId);
    }

    @Override
    public void sendCopyTemplate(Object object) {
    }

    @Override
    public void sendDeleteTemplate(Long bizId, List<CAPBusinessTemplate> capBusinessTemplates) {
        if (Strings.isNotEmpty(capBusinessTemplates)) {
            HashMap<String, Object> map = new HashMap<String, Object>(2);
            ArrayList<Map<String, Object>> mapList = new ArrayList<Map<String, Object>>();
            try {
                for (CAPBusinessTemplate template : capBusinessTemplates) {
                    CAPBusinessTemplateBO bo = new CAPBusinessTemplateBO();
                    bo.importFromPO(template);
                    mapList.add(bo.exportToJSon());
                }
                map.put(TEMPLATES, mapList);
                map.put(BIZ_ID, String.valueOf(bizId));
                this.cap4FormCacheManager.sendNotification(map, CAP4FormCache.FormCacheType.CustomTemplate_Delete_Template, bizId);
            }
            catch (BusinessException e) {
                LOGGER.error((Object)("sendDeleteTemplate error " + capBusinessTemplates.toString()));
                LOGGER.error((Object)"sendDeleteTemplate error ", (Throwable)e);
            }
        }
    }

    @Override
    public void sendDownloadTemplate(Long bizId, List<String> clusterTemplateIds) {
        HashMap<String, Object> clusterArgs = new HashMap<String, Object>(2);
        clusterArgs.put(BIZ_ID, bizId);
        clusterArgs.put(TEMPLATE_IDS, clusterTemplateIds);
        this.cap4FormCacheManager.sendNotification(clusterArgs, CAP4FormCache.FormCacheType.CustomTemplate_Download_Template, bizId);
    }

    @Override
    public void sendModifyConfig(List<Long> templateIds, boolean updateColumn, boolean updateElement) {
        HashMap<String, Object> clusterArgs = new HashMap<String, Object>();
        clusterArgs.put(TEMPLATE_IDS, templateIds);
        clusterArgs.put(UPDATE_COLUMN, updateColumn ? CAPBusinessEnum.TrueOrFalseEnum.TRUE.getKey() : CAPBusinessEnum.TrueOrFalseEnum.FALSE.getKey());
        clusterArgs.put(UPDATE_ELEMENT, updateElement ? CAPBusinessEnum.TrueOrFalseEnum.TRUE.getKey() : CAPBusinessEnum.TrueOrFalseEnum.FALSE.getKey());
        this.cap4FormCacheManager.sendNotification(clusterArgs, CAP4FormCache.FormCacheType.CustomTemplate_Modify_Config, templateIds);
    }

    @Override
    public void sendRemoveCache(List<Long> dataIds, String name) {
        HashMap<String, Object> map = new HashMap<String, Object>(2);
        map.put(DATA_IDS, dataIds);
        map.put(TYPE, name);
        this.cap4FormCacheManager.sendNotification(map, CAP4FormCache.FormCacheType.CustomTemplate_Remove_Cache, dataIds);
    }

    @Override
    public void receiveSaveEditableTemplate(Object object) {
        Map map = (Map)object;
        Long templateId = CAPParamUtil.getLong((Map)map, (String)TEMPLATE_ID);
        boolean isEdit = CAPParamUtil.getBoolean((Map)map, (String)IS_EDIT);
        CAPBusinessTemplateBO capBusinessTemplateBO = this.capBusinessTemplateManager.getCAPBusinessTemplateBOById(templateId);
        try {
            CAPBusinessUtil.copyTemplateFromBaseToRuntime(capBusinessTemplateBO, isEdit);
        }
        catch (IOException e) {
            LOGGER.error((Object)"saveEditableTemplate IOException.", (Throwable)e);
        }
    }

    @Override
    public void receiveImportBusiness(Object object) {
        Map map = (Map)object;
        Long bizId = CAPParamUtil.getLong((Map)map, (String)BIZ_ID);
        List<CAPBusinessTemplateBO> capBusinessTemplateBOS = this.capBusinessTemplateManager.getCAPBusinessTemplatesByBizId(bizId);
        try {
            CAPBusinessUtil.copyTemplatesFromBaseToRuntime(bizId, capBusinessTemplateBOS, true);
        }
        catch (IOException e) {
            LOGGER.error((Object)"importBusiness IOException.", (Throwable)e);
        }
    }

    @Override
    public void receiveCopyTemplate(Object object) {
        Map map = (Map)object;
        List templateIds = CAPParamUtil.convertParamListStringToLong((Map)map, (String)TEMPLATE_IDS);
        List<CAPBusinessTemplateBO> capBusinessTemplateBOS = this.capBusinessTemplateManager.getCAPBusinessTemplateBOsByIds(templateIds);
        try {
            CAPBusinessUtil.copyTemplatesFromBaseToRuntime(null, capBusinessTemplateBOS, false);
        }
        catch (IOException e) {
            LOGGER.error((Object)"copyTemplate IOException.", (Throwable)e);
        }
    }

    @Override
    public void receiveDeleteTemplate(Object object) {
        Map map = (Map)object;
        List mapList = (List)map.get(TEMPLATES);
        Long bizId = CAPParamUtil.getLong((Map)map, (String)BIZ_ID);
        int deleteDirCount = 0;
        HashSet<Integer> set = new HashSet<Integer>();
        for (Map tempMap : mapList) {
            CAPBusinessTemplateBO bo = new CAPBusinessTemplateBO();
            bo.importFromJSon(tempMap);
            if (bo.getId() == null) {
                LOGGER.error((Object)("receiveDeleteTemplate bo is null " + tempMap));
                continue;
            }
            String runtimePath = CAPBusinessTemplateUtil.getTemplatePath("runtime", bo, false);
            if (Strings.isNotEmpty((String)runtimePath)) {
                FileUtil.deleteDirectory((String)runtimePath);
            }
            ++deleteDirCount;
            set.add(Integer.valueOf(bo.getClient()));
        }
        Iterator clientIt = set.iterator();
        while (clientIt.hasNext()) {
            int clientType = (Integer)clientIt.next();
            CAPBusinessUtil.deleteTemplateFrame(bizId, clientType);
        }
        LOGGER.info((Object)("receiveDeleteTemplate delete " + deleteDirCount));
    }

    @Override
    public void receiveDownloadTemplate(Object object) {
        Map map = (Map)object;
        Long bizId = CAPParamUtil.getLong((Map)map, (String)BIZ_ID);
        List templateIds = CAPParamUtil.convertParamListStringToLong((Map)map, (String)TEMPLATE_IDS);
        List<CAPBusinessTemplateBO> capBusinessTemplateBOS = this.capBusinessTemplateManager.getCAPBusinessTemplateBOsByIds(templateIds);
        try {
            CAPBusinessUtil.copyTemplatesFromBaseToRuntime(bizId, capBusinessTemplateBOS, true);
        }
        catch (IOException e) {
            LOGGER.error((Object)"cluster method downloadTemplate is IOException . ", (Throwable)e);
        }
    }

    @Override
    public void receiveModifyConfig(Object object) {
        Map map = (Map)object;
        LOGGER.info((Object)("cluster method modifyConfig params " + map.toString()));
        List templateIds = (List)map.get(TEMPLATE_IDS);
        String updateColumn = (String)map.get(UPDATE_COLUMN);
        String updateElement = (String)map.get(UPDATE_ELEMENT);
        CAPBusinessTemplateManager capBusinessTemplateManager = (CAPBusinessTemplateManager)AppContext.getBean((String)"capBusinessTemplateManager");
        capBusinessTemplateManager.rewriteTemplateConfig(templateIds, CAPBusinessEnum.TrueOrFalseEnum.TRUE.getKey().equals(updateColumn), CAPBusinessEnum.TrueOrFalseEnum.TRUE.getKey().equals(updateElement), false);
    }

    public void setCapBusinessTemplateManager(CAPBusinessTemplateManager capBusinessTemplateManager) {
        this.capBusinessTemplateManager = capBusinessTemplateManager;
    }

    public void setCap4FormCacheManager(CAP4FormCacheManager cap4FormCacheManager) {
        this.cap4FormCacheManager = cap4FormCacheManager;
    }
}

