/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.cap4.template.manager.impl;

import com.seeyon.cap4.template.bo.CAPBusinessColumnBO;
import com.seeyon.cap4.template.bo.CAPBusinessElementBO;
import com.seeyon.cap4.template.bo.CAPBusinessOrgBO;
import com.seeyon.cap4.template.bo.CAPBusinessTemplateBO;
import com.seeyon.cap4.template.constant.CAPBusinessConstant;
import com.seeyon.cap4.template.constant.CAPBusinessEnum;
import com.seeyon.cap4.template.dao.CAPBusinessColumnDAO;
import com.seeyon.cap4.template.dao.CAPBusinessElementDAO;
import com.seeyon.cap4.template.dao.CAPBusinessTemplateDAO;
import com.seeyon.cap4.template.dao.CAPBusinessTemplateOrgDAO;
import com.seeyon.cap4.template.manager.CAPBusinessColumnManager;
import com.seeyon.cap4.template.manager.CAPBusinessElementManager;
import com.seeyon.cap4.template.manager.CAPBusinessTemplate4EditManager;
import com.seeyon.cap4.template.manager.CAPBusinessTemplateClusterManager;
import com.seeyon.cap4.template.manager.CAPBusinessTemplateManager;
import com.seeyon.cap4.template.manager.CAPBusinessTemplateOrgManager;
import com.seeyon.cap4.template.manager.CAPDownloadBaseManager;
import com.seeyon.cap4.template.manager.CAPHttpRequestManager;
import com.seeyon.cap4.template.po.CAPBusinessColumn;
import com.seeyon.cap4.template.po.CAPBusinessElement;
import com.seeyon.cap4.template.po.CAPBusinessTemplate;
import com.seeyon.cap4.template.thread.CAPAutoUpdateFrameRunnable;
import com.seeyon.cap4.template.thread.CAPAutoUpdateTemplateRunnable;
import com.seeyon.cap4.template.thread.CAPDeleteTemplateRunnable;
import com.seeyon.cap4.template.thread.CAPSystemInitTemplateRunnable;
import com.seeyon.cap4.template.util.CAPBusinessTemplateUtil;
import com.seeyon.cap4.template.util.CAPBusinessUtil;
import com.seeyon.cap4.template.util.FileUtil;
import com.seeyon.cap4.template.util.mall.MallUtil;
import com.seeyon.cap4.template.vo.config.ConfigColumnVO;
import com.seeyon.cap4.template.vo.config.ConfigElementVO;
import com.seeyon.cap4.template.vo.config.ConfigTemplateVO;
import com.seeyon.ctp.common.AppContext;
import com.seeyon.ctp.common.SystemEnvironment;
import com.seeyon.ctp.common.constants.Constants;
import com.seeyon.ctp.common.exceptions.BusinessException;
import com.seeyon.ctp.common.log.CtpLogFactory;
import com.seeyon.ctp.util.DateUtil;
import com.seeyon.ctp.util.Strings;
import com.seeyon.ctp.util.UUIDLong;
import com.seeyon.ctp.util.ZipUtil;
import com.seeyon.ctp.util.json.JSONUtil;
import java.io.File;
import java.io.IOException;
import java.sql.Timestamp;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;

public class CAPBusinessTemplateManagerImpl
implements CAPBusinessTemplateManager {
    private static final Log LOGGER = CtpLogFactory.getLog(CAPBusinessTemplateManagerImpl.class);
    private CAPBusinessTemplateDAO capBusinessTemplateDAO;
    private CAPBusinessColumnDAO capBusinessColumnDAO;
    private CAPBusinessElementDAO capBusinessElementDAO;
    private CAPBusinessTemplateOrgDAO capBusinessTemplateOrgDAO;
    private CAPBusinessColumnManager capBusinessColumnManager;
    private CAPBusinessElementManager capBusinessElementManager;
    private CAPBusinessTemplateOrgManager capBusinessTemplateOrgManager;
    private CAPBusinessTemplate4EditManager capBusinessTemplate4EditManager;
    private CAPBusinessTemplateClusterManager capBusinessTemplateClusterManager;
    private CAPHttpRequestManager capHttpRequestManager;
    private CAPDownloadBaseManager capDownloadBaseManager;
    private Vector<Long> deleteIdVector = new Vector();
    private static final int DELAY_SECONDS = 10;
    private final int coreThreadSize = Runtime.getRuntime().availableProcessors() * 2;
    private ScheduledExecutorService delayExecutor = new ScheduledThreadPoolExecutor(2, new CAPTemplateThreadFactory("Scheduled"));

    @Override
    public void addDelayTask(Runnable runnable, int delaySeconds) {
        if (delaySeconds > 0) {
            this.delayExecutor.schedule(runnable, (long)delaySeconds, TimeUnit.SECONDS);
        } else {
            runnable.run();
        }
    }

    @Override
    public List<CAPBusinessTemplate> getCAPBusinessTemplatesByGoodId(List<Long> goodIds) throws BusinessException {
        return Strings.isEmpty(goodIds) ? null : this.capBusinessTemplateDAO.getCAPBusinessTemplatesByGoodId(goodIds);
    }

    @Override
    public void systemStartInitialize() {
        try {
            this.capHttpRequestManager.init();
            File tempFile = new File(CAPBusinessTemplateUtil.getTemplateTempFolder());
            tempFile.mkdirs();
            Map<String, Set<String>> updateMap = this.updateTemplateFile(true);
            Set<String> pcFolderNames = updateMap == null ? null : updateMap.get("pc");
            Set<String> mobileFolderNames = updateMap == null ? null : updateMap.get("mobile");
            String oldBasePath = SystemEnvironment.getBaseFolder() + File.separator + "cap";
            File oldBaseFile = new File(oldBasePath);
            if (oldBaseFile.exists()) {
                try {
                    File clusterFolder = SystemEnvironment.getClusterPublicFolder((String)"cap");
                    FileUtil.copyFile((File)oldBaseFile, (File)clusterFolder);
                    FileUtil.deleteDirectory((File)oldBaseFile);
                }
                catch (BusinessException e) {
                    LOGGER.error((Object)"copy old base to cluster share error", (Throwable)e);
                }
            }
            ArrayList<Integer> needDealTypes = new ArrayList<Integer>();
            needDealTypes.add(CAPBusinessEnum.TemplateType.TP_BIZ_INDEX.getType());
            needDealTypes.add(CAPBusinessEnum.TemplateType.TP_CACL.getType());
            needDealTypes.add(CAPBusinessEnum.TemplateType.TP_FLOW.getType());
            needDealTypes.add(CAPBusinessEnum.TemplateType.TP_UNFLOW.getType());
            needDealTypes.add(CAPBusinessEnum.TemplateType.TP_QUERY.getType());
            ThreadPoolExecutor templateInitPool = new ThreadPoolExecutor(this.coreThreadSize, this.coreThreadSize, 0L, TimeUnit.SECONDS, new ArrayBlockingQueue<Runnable>(10), new CAPTemplateThreadFactory("init"));
            for (Integer templateType : needDealTypes) {
                templateInitPool.submit(new CAPSystemInitTemplateRunnable(CAPBusinessEnum.Platform.PC.getType(), templateType, pcFolderNames));
                templateInitPool.submit(new CAPSystemInitTemplateRunnable(CAPBusinessEnum.Platform.MOBILE.getType(), templateType, mobileFolderNames));
            }
            templateInitPool.shutdown();
        }
        catch (IOException e) {
            LOGGER.error((Object)"\u521d\u59cb\u5316CAP\u81ea\u5b9a\u4e49\u6a21\u677f\u5931\u8d25", (Throwable)e);
        }
        this.capBusinessTemplate4EditManager.initializeStart();
    }

    @Override
    public Map<String, Set<String>> updateTemplateFile(boolean copyToRuntime) {
        long startTime = System.currentTimeMillis();
        String autoPath = CAPBusinessTemplateUtil.getRuntimeAutoUpdatePath();
        File autoFolder = new File(autoPath);
        File configFile = new File(autoFolder, MallUtil.CLOUD_APP_URL.indexOf("test") > 0 ? "config_test.json" : "config.json");
        if (!configFile.exists()) {
            LOGGER.info((Object)"CAP4\u5347\u7ea7\u6a21\u677f\uff0c\u8df3\u8fc7\uff1a\u65e0\u914d\u7f6e\u6587\u4ef6");
            return null;
        }
        Map<String, Object> folderMap = CAPBusinessUtil.readConfigJSON(configFile.getAbsolutePath());
        if (folderMap == null || folderMap.size() == 0) {
            LOGGER.info((Object)"CAP4\u5347\u7ea7\u6a21\u677f\uff0c\u8df3\u8fc7\uff1a\u914d\u7f6e\u6587\u4ef6Map\u4e3a\u7a7a");
            return null;
        }
        ArrayList<Long> goodIds = new ArrayList<Long>();
        for (String id : folderMap.keySet()) {
            if ("frame".equals(id)) continue;
            goodIds.add(Long.valueOf(id));
        }
        List<CAPBusinessTemplate> capBusinessTemplates = null;
        try {
            capBusinessTemplates = this.getCAPBusinessTemplatesByGoodId(goodIds);
        }
        catch (BusinessException e) {
            LOGGER.error((Object)"CAP4\u5347\u7ea7\u6a21\u677f", (Throwable)e);
        }
        File autoUpdateBackFolder = new File(CAPBusinessTemplateUtil.getBaseTemplateUpdateBackupFolder(), DateUtil.currentDateString((String)"yyyy-MM-dd"));
        autoUpdateBackFolder.mkdirs();
        CAPBusinessTemplateManagerImpl.clearAutoUpdateConfig(autoFolder, folderMap);
        LOGGER.info((Object)"CAP4\u5347\u7ea7\u6a21\u677f updateTemplateFile \u5f00\u59cb\uff0c\u542f\u52a8\u7ebf\u7a0b...");
        HashSet<String> pcFolders = new HashSet<String>();
        HashSet<String> mobileFolders = new HashSet<String>();
        ScheduledThreadPoolExecutor templateUpdatePool = new ScheduledThreadPoolExecutor(this.coreThreadSize, new CAPTemplateThreadFactory("update"));
        if (folderMap.get("frame") != null) {
            templateUpdatePool.submit(new CAPAutoUpdateFrameRunnable(folderMap, copyToRuntime, autoFolder));
            pcFolders.add("frame");
            mobileFolders.add("frame");
        }
        if (!Strings.isEmpty(capBusinessTemplates)) {
            for (CAPBusinessTemplate template : capBusinessTemplates) {
                String folderName;
                templateUpdatePool.submit(new CAPAutoUpdateTemplateRunnable(template, folderMap, copyToRuntime, autoFolder));
                String string = folderName = template.getTemplateType().equals(CAPBusinessEnum.TemplateType.TP_BIZ_INDEX.getType()) ? String.valueOf(template.getId()) : String.valueOf(template.getPathId());
                if (template.getClient().equals(CAPBusinessEnum.Platform.PC.getType())) {
                    pcFolders.add(folderName);
                    continue;
                }
                mobileFolders.add(folderName);
            }
        }
        templateUpdatePool.shutdown();
        FileUtil.deleteFile((File)configFile);
        LOGGER.info((Object)("CAP4\u5347\u7ea7\u95e8\u6237\u6a21\u677f updateTemplateFile config " + JSONUtil.toJSONString(folderMap)));
        LOGGER.info((Object)("CAP4\u5347\u7ea7\u95e8\u6237\u6a21\u677f updateTemplateFile " + (System.currentTimeMillis() - startTime) + " MS"));
        HashMap<String, Set<String>> dataMap = new HashMap<String, Set<String>>();
        dataMap.put("pc", pcFolders);
        dataMap.put("mobile", mobileFolders);
        return dataMap;
    }

    private static void clearAutoUpdateConfig(File autoFolder, Map<String, Object> folderMap) {
        for (String key : folderMap.keySet()) {
            File egFile;
            Map map = (Map)folderMap.get(key);
            File folder = new File(autoFolder, String.valueOf(map.get("folder")));
            if (!folder.isDirectory() || !folder.exists()) continue;
            File configFile = new File(folder, CAPBusinessConstant.DIST_STATIC_CONFIG_JSON);
            if (configFile.exists()) {
                FileUtil.deleteFile((File)configFile);
            }
            if (!(egFile = new File(folder, "eg" + File.separator + "data.json")).exists()) continue;
            FileUtil.deleteFile((File)egFile);
        }
    }

    @Override
    public boolean saveCAPBusinessTemplate(CAPBusinessTemplate capBusinessTemplate) {
        boolean result = false;
        try {
            Timestamp timestamp = DateUtil.currentTimestamp();
            capBusinessTemplate.setCreateDate(timestamp);
            capBusinessTemplate.setModifyDate(timestamp);
            this.capBusinessTemplateDAO.insertCAPBusinessTemplate(capBusinessTemplate);
            result = true;
        }
        catch (BusinessException e) {
            LOGGER.error((Object)"method insertCAPBusinessTemplate is error", (Throwable)e);
        }
        return result;
    }

    @Override
    public boolean updateCAPBusinessTemplate(CAPBusinessTemplate capBusinessTemplate) throws BusinessException {
        Timestamp timestamp = DateUtil.currentTimestamp();
        capBusinessTemplate.setModifyDate(timestamp);
        this.capBusinessTemplateDAO.updateCAPBusinessTemplate(capBusinessTemplate);
        return true;
    }

    @Override
    public boolean updateCAPBusinessTemplates(List<CAPBusinessTemplate> capBusinessTemplates) throws BusinessException {
        Timestamp timestamp = DateUtil.currentTimestamp();
        for (CAPBusinessTemplate capBusinessTemplate : capBusinessTemplates) {
            capBusinessTemplate.setModifyDate(timestamp);
        }
        this.capBusinessTemplateDAO.updateCAPBusinessTemplates(capBusinessTemplates);
        return true;
    }

    @Override
    public CAPBusinessTemplateBO getCAPBusinessTemplateBOById(Long templateId) {
        CAPBusinessTemplateBO capBusinessTemplateBO = null;
        try {
            CAPBusinessTemplate template = this.getCAPBusinessTemplateById(templateId);
            if (template != null) {
                capBusinessTemplateBO = new CAPBusinessTemplateBO();
                capBusinessTemplateBO.importFromPO(template);
            }
        }
        catch (BusinessException e) {
            LOGGER.error((Object)"method getCAPBusinessTemplateBOById is error ", (Throwable)e);
        }
        return capBusinessTemplateBO;
    }

    @Override
    public CAPBusinessTemplate getCAPBusinessTemplateById(Long templateId) throws BusinessException {
        return this.capBusinessTemplateDAO.getCAPBusinessTemplateById(templateId);
    }

    @Override
    public List<CAPBusinessTemplateBO> getCAPBusinessTemplatesByBizId(Long bizId) {
        ArrayList<CAPBusinessTemplateBO> listBo = new ArrayList<CAPBusinessTemplateBO>();
        try {
            List<CAPBusinessTemplate> list = this.capBusinessTemplateDAO.getCAPBusinessTemplatesByBizId(bizId);
            for (CAPBusinessTemplate capBusinessTemplate : list) {
                CAPBusinessTemplateBO capBusinessTemplateBO = new CAPBusinessTemplateBO();
                capBusinessTemplateBO.importFromPO(capBusinessTemplate);
                listBo.add(capBusinessTemplateBO);
            }
        }
        catch (BusinessException e) {
            LOGGER.error((Object)"method getCAPBusinessTemplatesByBizId is error", (Throwable)e);
        }
        return listBo;
    }

    @Override
    public List<CAPBusinessTemplate> getCAPBusinessTemplateByPathIdAndType(Long pathId, Integer templateType) {
        try {
            return this.capBusinessTemplateDAO.getCAPBusinessTemplateByPathIdAndType(pathId, templateType);
        }
        catch (BusinessException e) {
            LOGGER.error((Object)"method getCAPBusinessTemplateByTemplateId is error", (Throwable)e);
            return null;
        }
    }

    @Override
    public List<CAPBusinessTemplate> getCAPBusinessTemplateByPathIdsAndType(List<Long> pathIds, Integer templateType) {
        try {
            return this.capBusinessTemplateDAO.getCAPBusinessTemplateByPathIdsAndType(pathIds, templateType);
        }
        catch (BusinessException e) {
            LOGGER.error((Object)"method getCAPBusinessTemplateByTemplateId is error", (Throwable)e);
            return null;
        }
    }

    @Override
    public CAPBusinessTemplate getCAPBusinessTemplateByPathIdAndTypeAndClient(Long pathId, Integer templateType, Integer client) {
        try {
            return this.capBusinessTemplateDAO.getCAPBusinessTemplateByPathIdAndTypeAndClient(pathId, templateType, client);
        }
        catch (BusinessException e) {
            LOGGER.error((Object)"method getCAPBusinessTemplateByTemplateId is error", (Throwable)e);
            return null;
        }
    }

    @Override
    public List<CAPBusinessTemplate> getCAPBusinessTemplatesByIds(List<Long> templateIds) {
        try {
            return this.capBusinessTemplateDAO.getCAPBusinessTemplatesByIds(templateIds);
        }
        catch (BusinessException e) {
            LOGGER.error((Object)"method getCAPBusinessTemplatesByIds is error", (Throwable)e);
            return null;
        }
    }

    @Override
    public List<CAPBusinessTemplateBO> getCAPBusinessTemplateBOsByIds(List<Long> templateIds) {
        try {
            ArrayList<CAPBusinessTemplateBO> capBusinessTemplateBOs = new ArrayList<CAPBusinessTemplateBO>();
            List<CAPBusinessTemplate> capBusinessTemplates = this.getCAPBusinessTemplatesByIds(templateIds);
            for (CAPBusinessTemplate capBusinessTemplate : capBusinessTemplates) {
                CAPBusinessTemplateBO capBusinessTemplateBO = new CAPBusinessTemplateBO();
                capBusinessTemplateBO.importFromPO(capBusinessTemplate);
                capBusinessTemplateBOs.add(capBusinessTemplateBO);
            }
            return capBusinessTemplateBOs;
        }
        catch (BusinessException e) {
            LOGGER.error((Object)"getCAPBusinessTemplateBOsByIds method is error", (Throwable)e);
            return null;
        }
    }

    private boolean deleteCAPBusinessTemplatesByTemplateIds(List<Long> templateIds) throws BusinessException {
        this.capBusinessTemplateDAO.deleteCAPBusinessTemplatesByTemplateIds(templateIds);
        List<CAPBusinessColumn> capBusinessColumns = this.capBusinessColumnDAO.getCAPBusinessColumnsByTemplateIds(templateIds);
        if (Strings.isNotEmpty(capBusinessColumns)) {
            ArrayList<Long> columnIds = new ArrayList<Long>();
            for (CAPBusinessColumn capBusinessColumn : capBusinessColumns) {
                columnIds.add(capBusinessColumn.getId());
            }
            this.capBusinessColumnDAO.deleteCAPBusinessColumns(capBusinessColumns);
            List<CAPBusinessElement> elements = this.capBusinessElementDAO.getCAPBusinessElementsByColumnIds(columnIds);
            if (Strings.isNotEmpty(elements)) {
                this.capBusinessElementDAO.deleteCAPBusinessElements(elements);
            }
        }
        this.capBusinessTemplateOrgDAO.deleteCAPBusinessTemplateOrgsByTemplateIds(templateIds);
        return true;
    }

    @Override
    public boolean deleteCAPBusinessTemplatesByBizId(Long bizId) throws BusinessException {
        List<CAPBusinessTemplate> capBusinessTemplates = this.capBusinessTemplateDAO.getCAPBusinessTemplatesByBizId(bizId);
        return this.deleteCAPBusinessTemplates(bizId, capBusinessTemplates);
    }

    @Override
    public boolean deleteCAPBusinessTemplates(Long bizId, List<CAPBusinessTemplate> capBusinessTemplates) {
        return this.deleteCAPBusinessTemplates(bizId, capBusinessTemplates, true);
    }

    @Override
    public void deleteCAPBusinessTemplatesByBO(Long bizId, List<CAPBusinessTemplateBO> capBusinessTemplateBOS, int delaySeconds) throws BusinessException {
        ArrayList<CAPBusinessTemplate> capBusinessTemplates = new ArrayList<CAPBusinessTemplate>();
        try {
            for (CAPBusinessTemplateBO capBusinessTemplateBO : capBusinessTemplateBOS) {
                capBusinessTemplates.add(capBusinessTemplateBO.exportToPO());
            }
        }
        catch (ParseException e) {
            LOGGER.error((Object)"deleteCAPBusinessTemplatesByBO is error", (Throwable)e);
            throw new BusinessException(e.getMessage(), (Throwable)e);
        }
        this.deleteCAPBusinessTemplates(bizId, capBusinessTemplates, true, delaySeconds);
    }

    @Override
    public void deleteCAPBusinessTemplatesByBO(Long bizId, List<CAPBusinessTemplateBO> capBusinessTemplateBOS) throws BusinessException {
        this.deleteCAPBusinessTemplatesByBO(bizId, capBusinessTemplateBOS, 10);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean deleteCAPBusinessTemplates(Long bizId, List<CAPBusinessTemplate> capBusinessTemplates, boolean deleteFile, int delaySeconds) {
        boolean deleteResult = false;
        if (CollectionUtils.isEmpty(capBusinessTemplates)) {
            return deleteResult;
        }
        ArrayList<Long> templateIds = new ArrayList<Long>();
        try {
            Long userId = AppContext.currentUserId();
            Iterator<CAPBusinessTemplate> iterator = capBusinessTemplates.iterator();
            while (iterator.hasNext()) {
                CAPBusinessTemplate template = iterator.next();
                if (this.deleteIdVector.contains(template.getId())) {
                    iterator.remove();
                    continue;
                }
                this.deleteIdVector.add(template.getId());
            }
            if (CollectionUtils.isEmpty(capBusinessTemplates)) {
                boolean bl = deleteResult;
                return bl;
            }
            for (CAPBusinessTemplate template : capBusinessTemplates) {
                LOGGER.info((Object)("user " + userId + " delete template " + template.toString()));
                templateIds.add(template.getId());
            }
            deleteResult = this.deleteCAPBusinessTemplatesByTemplateIds(templateIds);
            if (deleteResult && deleteFile) {
                this.addDelayTask(new CAPDeleteTemplateRunnable(capBusinessTemplates, bizId), delaySeconds);
                this.capBusinessTemplateClusterManager.sendDeleteTemplate(bizId, capBusinessTemplates);
            }
        }
        catch (BusinessException e) {
            LOGGER.error((Object)("deleteCAPBusinessTemplates is error" + e.getMessage() + " AND param bizId is" + bizId + " AND param capBusinessTemplates is " + capBusinessTemplates.toString()));
        }
        finally {
            if (templateIds.size() > 0) {
                this.deleteIdVector.removeAll(templateIds);
            }
        }
        return deleteResult;
    }

    @Override
    public boolean deleteCAPBusinessTemplates(Long bizId, List<CAPBusinessTemplate> capBusinessTemplates, boolean deleteFile) {
        return this.deleteCAPBusinessTemplates(bizId, capBusinessTemplates, deleteFile, 10);
    }

    @Override
    public boolean saveCAPBusinessTemplatesByImport(List<CAPBusinessTemplateBO> capBusinessTemplateBOS, List<Long> deleteTemplateIds, Long bizId) {
        try {
            if (deleteTemplateIds != null && deleteTemplateIds.size() > 0) {
                this.deleteCAPBusinessTemplatesByTemplateIds(deleteTemplateIds);
            }
            if (capBusinessTemplateBOS != null) {
                ArrayList<CAPBusinessTemplate> capBusinessTemplates = new ArrayList<CAPBusinessTemplate>();
                ArrayList<CAPBusinessColumn> capBusinessColumns = new ArrayList<CAPBusinessColumn>();
                ArrayList<CAPBusinessElement> capBusinessElements = new ArrayList<CAPBusinessElement>();
                Timestamp timestamp = DateUtil.currentTimestamp();
                for (CAPBusinessTemplateBO capBusinessTemplateBO : capBusinessTemplateBOS) {
                    capBusinessTemplateBO.setModifyDate(String.valueOf(timestamp));
                    capBusinessTemplateBO.setCreateDate(String.valueOf(timestamp));
                    capBusinessTemplates.add(capBusinessTemplateBO.exportToPO());
                    List<CAPBusinessColumnBO> capBusinessColumnBOS = capBusinessTemplateBO.getCapBusinessColumnBOs();
                    if (capBusinessColumnBOS == null) continue;
                    for (CAPBusinessColumnBO capBusinessColumnBO : capBusinessColumnBOS) {
                        capBusinessColumnBO.setModifyDate(String.valueOf(timestamp));
                        capBusinessColumnBO.setCreateDate(String.valueOf(timestamp));
                        capBusinessColumns.add(capBusinessColumnBO.exportToPO());
                        List<CAPBusinessElementBO> capBusinessElementBOS = capBusinessColumnBO.getCapBusinessElementBOs();
                        if (capBusinessElementBOS == null) continue;
                        for (CAPBusinessElementBO capBusinessElementBO : capBusinessElementBOS) {
                            capBusinessElementBO.setModifyDate(String.valueOf(timestamp));
                            capBusinessElementBO.setCreateDate(String.valueOf(timestamp));
                            capBusinessElements.add(capBusinessElementBO.exportToPO());
                        }
                    }
                }
                this.capBusinessTemplateDAO.insertCAPBusinessTemplates(capBusinessTemplates);
                this.capBusinessColumnDAO.insertCAPBusinessColumns(capBusinessColumns);
                this.capBusinessElementDAO.insertCAPBusinessElements(capBusinessElements);
            }
            return true;
        }
        catch (BusinessException e) {
            LOGGER.error((Object)"method saveCAPBusinessTemplatesByImport is error", (Throwable)e);
        }
        catch (ParseException e) {
            LOGGER.error((Object)"method saveCAPBusinessTemplatesByImport is error", (Throwable)e);
        }
        return false;
    }

    @Override
    public void resetTemplateConfigJSONIds(CAPBusinessTemplateBO templateBO, ConfigTemplateVO configTemplateVO, Map<Long, Long> oldId2NewIdMap) throws BusinessException {
        if (configTemplateVO == null) {
            return;
        }
        Long newTemplateId = oldId2NewIdMap == null ? UUIDLong.longUUID() : oldId2NewIdMap.get(Long.valueOf(configTemplateVO.getTemplateId()));
        LOGGER.info((Object)("reset config , " + templateBO.getId() + "," + templateBO.getName()));
        configTemplateVO.setTemplateId(String.valueOf(newTemplateId));
        configTemplateVO.setTemplateFolder(String.valueOf(newTemplateId));
        List<ConfigColumnVO> configColumnVOS = configTemplateVO.getColumns();
        if (configColumnVOS != null) {
            boolean isCalcOrQuery = Integer.valueOf(templateBO.getTemplateType()).equals(CAPBusinessEnum.TemplateType.TP_CACL.getType()) || Integer.valueOf(templateBO.getTemplateType()).equals(CAPBusinessEnum.TemplateType.TP_QUERY.getType());
            for (ConfigColumnVO configColumnVO : configColumnVOS) {
                Long newColumnId;
                Long oldColumnId = Long.valueOf(configColumnVO.getColumnId());
                CAPBusinessColumnBO columnBO = null;
                if (oldId2NewIdMap == null) {
                    newColumnId = UUIDLong.longUUID();
                } else {
                    newColumnId = oldId2NewIdMap.get(oldColumnId);
                    if (newColumnId == null && isCalcOrQuery && CollectionUtils.isNotEmpty(templateBO.getCapBusinessColumnBOs())) {
                        columnBO = templateBO.getCapBusinessColumnBOs().get(0);
                        newColumnId = Long.valueOf(columnBO.getId());
                        oldId2NewIdMap.put(oldColumnId, newColumnId);
                    }
                }
                if (newColumnId == null) {
                    LOGGER.error((Object)("reset newColumnId error , " + configColumnVO.toString()));
                    throw new BusinessException("columnId is error." + configColumnVO.toString());
                }
                configColumnVO.setColumnId(String.valueOf(newColumnId));
                List<ConfigElementVO> configElementVOS = configColumnVO.getElements();
                if (configElementVOS == null) continue;
                for (ConfigElementVO configElementVO : configElementVOS) {
                    Long newElementId;
                    Long oldElementId = Long.valueOf(configElementVO.getElementId());
                    if (oldId2NewIdMap == null) {
                        newElementId = UUIDLong.longUUID();
                    } else {
                        newElementId = oldId2NewIdMap.get(oldElementId);
                        if (newElementId == null && isCalcOrQuery && columnBO != null && CollectionUtils.isNotEmpty(columnBO.getCapBusinessElementBOs())) {
                            newElementId = Long.valueOf(columnBO.getCapBusinessElementBOs().get(0).getId());
                            oldId2NewIdMap.put(oldElementId, newElementId);
                        }
                    }
                    if (newElementId == null) {
                        LOGGER.error((Object)("reset newElementId error , " + configElementVO.toString()));
                        throw new BusinessException("elementId is error." + configElementVO.toString());
                    }
                    configElementVO.setElementId(String.valueOf(newElementId));
                }
            }
        }
    }

    @Override
    public void saveCAPBusinessTemplateBOs(List<CAPBusinessTemplateBO> capBusinessTemplateBOS) throws BusinessException {
        if (CollectionUtils.isEmpty(capBusinessTemplateBOS)) {
            return;
        }
        try {
            ArrayList<CAPBusinessTemplate> capBusinessTemplates = new ArrayList<CAPBusinessTemplate>();
            Timestamp timestamp = DateUtil.currentTimestamp();
            for (CAPBusinessTemplateBO capBusinessTemplateBO : capBusinessTemplateBOS) {
                capBusinessTemplateBO.setModifyDate(String.valueOf(timestamp));
                capBusinessTemplateBO.setCreateDate(String.valueOf(timestamp));
                capBusinessTemplates.add(capBusinessTemplateBO.exportToPO());
            }
            this.capBusinessTemplateDAO.insertCAPBusinessTemplates(capBusinessTemplates);
        }
        catch (ParseException e) {
            LOGGER.error((Object)("method saveCAPBusinessTemplateBOs is error AND param capBusinessTemplateBOS is" + capBusinessTemplateBOS.toString()), (Throwable)e);
            throw new BusinessException(e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public int getMaxSortByBizIdAndTemplateType(Long eggId, Integer templateType) {
        try {
            return this.capBusinessTemplateDAO.getMaxSortByBizIdAndTemplateType(eggId, templateType);
        }
        catch (BusinessException e) {
            LOGGER.error((Object)"method getMaxSortByTemplateType is error ", (Throwable)e);
            return 0;
        }
    }

    @Override
    public boolean isUseCustomTemplate(Long bizId, Long pathId, int templateType) {
        int clientType = CAPBusinessEnum.Platform.PC.getType();
        int userAgent = AppContext.getCurrentUser().getLoginSign();
        if (userAgent == Constants.login_sign.phone.value()) {
            clientType = CAPBusinessEnum.Platform.MOBILE.getType();
        }
        return this.isUseCustomTemplate(bizId, pathId, templateType, clientType);
    }

    @Override
    public boolean isUseCustomTemplate(Long bizId, Long pathId, int templateType, int clientType) {
        return this.getCustomTemplateBO(bizId, pathId, templateType, clientType) != null;
    }

    @Override
    public CAPBusinessTemplateBO getCustomTemplateBO(Long bizId, Long pathId, int templateType, int clientType) {
        CAPBusinessTemplateBO bo = null;
        if (pathId == null || bizId == null) {
            return bo;
        }
        List<CAPBusinessTemplateBO> capBusinessTemplateBOs = this.getCAPBusinessTemplatesByBizId(bizId);
        if (capBusinessTemplateBOs == null || capBusinessTemplateBOs.size() == 0) {
            return bo;
        }
        for (CAPBusinessTemplateBO capBusinessTemplateBO : capBusinessTemplateBOs) {
            if (!capBusinessTemplateBO.getPathId().equals(String.valueOf(pathId)) || !capBusinessTemplateBO.getTemplateType().equals(String.valueOf(templateType)) || !String.valueOf(clientType).equals(capBusinessTemplateBO.getClient()) || !"1".equals(capBusinessTemplateBO.getState())) continue;
            bo = capBusinessTemplateBO;
            break;
        }
        return bo;
    }

    @Override
    public List<CAPBusinessTemplateBO> getCAPBusinessTemplatesForMenu(Long bizId) {
        List<CAPBusinessTemplateBO> capBusinessTemplateBOs = this.getCAPBusinessTemplatesByBizId(bizId);
        ArrayList<CAPBusinessTemplateBO> bos = new ArrayList<CAPBusinessTemplateBO>();
        if (capBusinessTemplateBOs != null && capBusinessTemplateBOs.size() > 0) {
            for (CAPBusinessTemplateBO capBusinessTemplateBO : capBusinessTemplateBOs) {
                if (!String.valueOf(CAPBusinessEnum.TemplateType.TP_BIZ_INDEX.getType()).equals(capBusinessTemplateBO.getTemplateType())) continue;
                List<CAPBusinessOrgBO> capBusinessOrgBOS = this.capBusinessTemplateOrgManager.getCAPBusinessOrgBOsByTemplateId(Long.valueOf(capBusinessTemplateBO.getId()));
                capBusinessTemplateBO.setCapBusinessOrgBOs(capBusinessOrgBOS);
                bos.add(capBusinessTemplateBO);
            }
        }
        return bos;
    }

    @Override
    public ConfigTemplateVO getConfigTemplateVO(Long templateId) throws BusinessException {
        if (templateId != null) {
            CAPBusinessTemplateBO bo = this.getCAPBusinessTemplateBOById(templateId);
            String configPath = CAPBusinessTemplateUtil.getTemplateConfigPath("base", bo, false);
            return this.getConfigTemplateVO(configPath);
        }
        return null;
    }

    @Override
    public ConfigTemplateVO getConfigTemplateVO(String configPath) throws BusinessException {
        Map<String, Object> configMap;
        ConfigTemplateVO configTemplateVO = null;
        if (Strings.isNotBlank((String)configPath) && (configMap = CAPBusinessUtil.readConfigJSON(configPath)) != null) {
            configTemplateVO = new ConfigTemplateVO();
            configTemplateVO.importFromMap(configMap);
        }
        return configTemplateVO;
    }

    @Override
    public boolean rewriteTemplateConfig(List<Long> templateIds, boolean updateColumn, boolean updateElement) {
        return this.rewriteTemplateConfig(templateIds, updateColumn, updateElement, true);
    }

    @Override
    public boolean rewriteTemplateConfig(List<Long> templateIds, boolean updateColumn, boolean updateElement, boolean notifyCluster) {
        if (templateIds == null || templateIds.size() == 0) {
            return false;
        }
        try {
            List<CAPBusinessTemplateBO> capBusinessTemplateBOs = this.getCAPBusinessTemplateBOsByIds(templateIds);
            for (CAPBusinessTemplateBO capBusinessTemplateBO : capBusinessTemplateBOs) {
                String baseConfigPath = CAPBusinessTemplateUtil.getTemplateConfigPath("base", capBusinessTemplateBO, false);
                ConfigTemplateVO configTemplateVO = new ConfigTemplateVO();
                configTemplateVO.importFromMap(CAPBusinessUtil.readConfigJSON(baseConfigPath));
                configTemplateVO.setName(capBusinessTemplateBO.getName());
                configTemplateVO.setState(capBusinessTemplateBO.getState());
                if (updateColumn) {
                    List<ConfigColumnVO> configColumns = configTemplateVO.getColumns();
                    List<CAPBusinessColumnBO> capBusinessColumnBOs = this.capBusinessColumnManager.getCAPBusinessColumnBOsByTemplateId(Long.valueOf(capBusinessTemplateBO.getId()));
                    if (capBusinessColumnBOs == null || configColumns == null) continue;
                    HashMap<String, CAPBusinessColumnBO> columnIdToColumnBO = new HashMap<String, CAPBusinessColumnBO>();
                    for (CAPBusinessColumnBO capBusinessColumnBO : capBusinessColumnBOs) {
                        columnIdToColumnBO.put(capBusinessColumnBO.getId(), capBusinessColumnBO);
                    }
                    for (ConfigColumnVO configColumn : configColumns) {
                        CAPBusinessColumnBO capBusinessColumnBO = (CAPBusinessColumnBO)columnIdToColumnBO.get(configColumn.getColumnId());
                        if (capBusinessColumnBO == null) continue;
                        configColumn.setName(capBusinessColumnBO.getName());
                        configColumn.setState(capBusinessColumnBO.getState());
                        if (!updateElement) continue;
                        List<ConfigElementVO> configElements = configColumn.getElements();
                        List<CAPBusinessElementBO> capBusinessElementBOS = this.capBusinessElementManager.getCAPBusinessElementBOsByColumnId(Long.valueOf(capBusinessColumnBO.getId()));
                        if (capBusinessElementBOS == null || configElements == null) continue;
                        HashMap<String, CAPBusinessElementBO> elementIdToElementBO = new HashMap<String, CAPBusinessElementBO>();
                        for (CAPBusinessElementBO capBusinessElementBO : capBusinessElementBOS) {
                            elementIdToElementBO.put(capBusinessElementBO.getId(), capBusinessElementBO);
                        }
                        for (ConfigElementVO configElement : configElements) {
                            CAPBusinessElementBO capBusinessElementBO = (CAPBusinessElementBO)elementIdToElementBO.get(configElement.getElementId());
                            if (capBusinessColumnBO == null) continue;
                            configElement.setName(capBusinessElementBO.getName());
                        }
                    }
                }
                Map<String, Object> configMap = configTemplateVO.exportToMap();
                if (notifyCluster) {
                    LOGGER.info((Object)("rewriteTemplateConfig base : " + baseConfigPath));
                    CAPBusinessUtil.writeConfigJSON(baseConfigPath, configMap);
                }
                String runtimeConfigPath = CAPBusinessTemplateUtil.getTemplateConfigPath("runtime", capBusinessTemplateBO, false);
                LOGGER.info((Object)("rewriteTemplateConfig runtime : " + runtimeConfigPath));
                CAPBusinessUtil.writeConfigJSON(runtimeConfigPath, configMap);
            }
            if (notifyCluster) {
                this.capBusinessTemplateClusterManager.sendModifyConfig(templateIds, updateColumn, updateElement);
            }
            return true;
        }
        catch (BusinessException e) {
            LOGGER.error((Object)("rewriteTemplateConfig is exception " + e.getMessage() + " , templateIds " + templateIds.toString()), (Throwable)e);
            return false;
        }
    }

    @Override
    public void execTemplateInitialBackup(List<Long> templateIds) throws BusinessException {
        if (Strings.isEmpty(templateIds)) {
            return;
        }
        com.seeyon.ctp.util.FileUtil.makeDir((String)CAPBusinessTemplateUtil.getBaseTemplateInitialBackupFolder());
        List<CAPBusinessTemplateBO> templateBOs = this.getCAPBusinessTemplateBOsByIds(templateIds);
        for (CAPBusinessTemplateBO templateBO : templateBOs) {
            this.zipTemplateFileWithData(templateBO, CAPBusinessTemplateUtil.getBaseTemplateInitialBackupFolder(), templateBO.getId());
        }
    }

    @Override
    public void zipTemplateFileWithData(Long templateId, String savePath, String fileName) throws BusinessException {
        CAPBusinessTemplateBO capBusinessTemplateBO = this.getCAPBusinessTemplateBOById(templateId);
        this.zipTemplateFileWithData(capBusinessTemplateBO, savePath, fileName);
    }

    @Override
    public void restoreTemplateFile(CAPBusinessTemplateBO templateBO, String savePath, String fileName) throws BusinessException {
        savePath = savePath.endsWith(File.separator) ? savePath : savePath + File.separator;
        String zipFilePath = savePath + fileName + ".zip";
        File destFile = new File(CAPBusinessTemplateUtil.getTemplatePath("base", templateBO, false));
        File zipFile = new File(zipFilePath);
        if (!zipFile.exists()) {
            LOGGER.info((Object)("back file is not exits!" + zipFilePath + "," + templateBO.getId() + templateBO.getName()));
            throw new BusinessException("back file is not exits!");
        }
        String unzipToFolder = this.capDownloadBaseManager.unzipDownloadFile(zipFile);
        try {
            FileUtil.copyDirectory((File)new File(unzipToFolder), (File)destFile, (int)5);
            CAPBusinessUtil.copyTemplateFromBaseToRuntime(templateBO, false);
        }
        catch (IOException e) {
            throw new BusinessException((Throwable)e);
        }
    }

    @Override
    public void zipTemplateFileWithData(CAPBusinessTemplateBO templateBO, String savePath, String fileName) throws BusinessException {
        try {
            savePath = savePath.endsWith(File.separator) ? savePath : savePath + File.separator;
            File srcFile = new File(CAPBusinessTemplateUtil.getTemplatePath("base", templateBO, false));
            String zipFilePath = savePath + fileName + ".zip";
            String dataFilePath = savePath + fileName + ".json";
            String templateInfo = templateBO.getId() + "," + templateBO.getEggId() + "," + templateBO.getName();
            if (!srcFile.exists() || !srcFile.isDirectory()) {
                LOGGER.error((Object)("zipTemplateFileWithData template " + templateInfo + ", filePath " + srcFile.getAbsolutePath() + " is not exits or not a directory!exists:" + srcFile.exists() + ",isDirectory:" + srcFile.isDirectory()));
                return;
            }
            ZipUtil.zip((File)srcFile, (File)new File(zipFilePath), (boolean)false);
            LOGGER.info((Object)("zipTemplateFileWithData template " + templateInfo + ", filePath " + zipFilePath));
            HashMap<String, Object> map = new HashMap<String, Object>();
            ArrayList<Map<String, Object>> columnMaps = new ArrayList<Map<String, Object>>();
            ArrayList<Map<String, Object>> elementMaps = new ArrayList<Map<String, Object>>();
            ArrayList<Map<String, Object>> authMaps = new ArrayList<Map<String, Object>>();
            map.put("template", templateBO.exportToJSon());
            map.put("columns", columnMaps);
            map.put("elements", elementMaps);
            map.put("auths", authMaps);
            List<CAPBusinessColumnBO> columnBOS = this.capBusinessColumnManager.getCAPBusinessColumnBOsByTemplateId(Long.valueOf(templateBO.getId()));
            ArrayList<Long> columnIds = new ArrayList<Long>();
            for (CAPBusinessColumnBO columnBO : columnBOS) {
                columnMaps.add(columnBO.exportToJSon());
                columnIds.add(Long.valueOf(columnBO.getId()));
            }
            Map<String, List<CAPBusinessElementBO>> columnId2ElementBos = this.capBusinessElementManager.getCAPBusinessElementBOsMapByColumnIds(columnIds);
            for (String columnId : columnId2ElementBos.keySet()) {
                List<CAPBusinessElementBO> elementBOS = columnId2ElementBos.get(columnId);
                for (CAPBusinessElementBO elementBO : elementBOS) {
                    elementMaps.add(elementBO.exportToJSon());
                }
            }
            List<CAPBusinessOrgBO> capBusinessOrgBOS = this.capBusinessTemplateOrgManager.getCAPBusinessOrgBOsByTemplateId(Long.valueOf(templateBO.getId()));
            if (CollectionUtils.isNotEmpty(capBusinessOrgBOS)) {
                for (CAPBusinessOrgBO orgBO : capBusinessOrgBOS) {
                    authMaps.add(orgBO.exportToJSon());
                }
            }
            FileUtil.writeFile((File)new File(dataFilePath), (String)JSONUtil.toJSONString(map));
            LOGGER.info((Object)("zipTemplateFileWithData template " + templateInfo + ", dataPath " + dataFilePath));
        }
        catch (IOException e) {
            LOGGER.error((Object)("zipTemplateFileWithData is exception " + e.getMessage()), (Throwable)e);
            throw new BusinessException((Throwable)e);
        }
    }

    public void setCapBusinessTemplateDAO(CAPBusinessTemplateDAO capBusinessTemplateDAO) {
        this.capBusinessTemplateDAO = capBusinessTemplateDAO;
    }

    public void setCapBusinessColumnDAO(CAPBusinessColumnDAO capBusinessColumnDAO) {
        this.capBusinessColumnDAO = capBusinessColumnDAO;
    }

    public void setCapBusinessElementDAO(CAPBusinessElementDAO capBusinessElementDAO) {
        this.capBusinessElementDAO = capBusinessElementDAO;
    }

    public void setCapBusinessTemplateOrgDAO(CAPBusinessTemplateOrgDAO capBusinessTemplateOrgDAO) {
        this.capBusinessTemplateOrgDAO = capBusinessTemplateOrgDAO;
    }

    public void setCapBusinessColumnManager(CAPBusinessColumnManager capBusinessColumnManager) {
        this.capBusinessColumnManager = capBusinessColumnManager;
    }

    public void setCapBusinessElementManager(CAPBusinessElementManager capBusinessElementManager) {
        this.capBusinessElementManager = capBusinessElementManager;
    }

    public void setCapBusinessTemplateOrgManager(CAPBusinessTemplateOrgManager capBusinessTemplateOrgManager) {
        this.capBusinessTemplateOrgManager = capBusinessTemplateOrgManager;
    }

    public void setCapBusinessTemplate4EditManager(CAPBusinessTemplate4EditManager capBusinessTemplate4EditManager) {
        this.capBusinessTemplate4EditManager = capBusinessTemplate4EditManager;
    }

    public void setCapBusinessTemplateClusterManager(CAPBusinessTemplateClusterManager capBusinessTemplateClusterManager) {
        this.capBusinessTemplateClusterManager = capBusinessTemplateClusterManager;
    }

    public void setCapHttpRequestManager(CAPHttpRequestManager capHttpRequestManager) {
        this.capHttpRequestManager = capHttpRequestManager;
    }

    public void setCapDownloadBaseManager(CAPDownloadBaseManager capDownloadBaseManager) {
        this.capDownloadBaseManager = capDownloadBaseManager;
    }

    private class CAPTemplateThreadFactory
    implements ThreadFactory {
        private AtomicInteger tag = new AtomicInteger(0);
        private String threadName;

        public CAPTemplateThreadFactory(String threadName) {
            this.threadName = threadName;
        }

        @Override
        public Thread newThread(Runnable r) {
            Thread thread = new Thread(r);
            thread.setName("CAPTemplate-" + this.threadName + "-" + this.tag.getAndIncrement());
            return thread;
        }
    }
}

