/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.cap4.template.manager.impl;

import com.google.common.collect.Lists;
import com.seeyon.cap4.template.bo.CAPBusinessOrgBO;
import com.seeyon.cap4.template.dao.CAPBusinessTemplateOrgDAO;
import com.seeyon.cap4.template.manager.CAPBusinessTemplateOrgManager;
import com.seeyon.cap4.template.po.CAPBusinessTemplateOrg;
import com.seeyon.ctp.common.exceptions.BusinessException;
import com.seeyon.ctp.common.log.CtpLogFactory;
import com.seeyon.ctp.util.DateUtil;
import com.seeyon.ctp.util.Strings;
import java.sql.Timestamp;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;

public class CAPBusinessTemplateOrgManagerImpl
implements CAPBusinessTemplateOrgManager {
    private static final Log LOGGER = CtpLogFactory.getLog(CAPBusinessTemplateOrgManagerImpl.class);
    private CAPBusinessTemplateOrgDAO capBusinessTemplateOrgDAO;

    @Override
    public boolean saveCAPBusinessTemplateOrgs(List<Long> templateIds, List<CAPBusinessOrgBO> capBusinessOrgBOS) {
        if (Strings.isEmpty(templateIds)) {
            return false;
        }
        try {
            this.capBusinessTemplateOrgDAO.deleteCAPBusinessTemplateOrgsByTemplateIds(templateIds);
            this.saveCAPBusinessTemplateOrgs(capBusinessOrgBOS);
            return true;
        }
        catch (Exception e) {
            LOGGER.error((Object)("method saveCAPBusinessTemplateOrgs is error " + e.getMessage() + " AND param templateIds is " + templateIds + " AND param capBusinessOrgBOS is " + capBusinessOrgBOS.toString()), (Throwable)e);
            return false;
        }
    }

    @Override
    public boolean saveCAPBusinessTemplateOrgs(List<CAPBusinessOrgBO> capBusinessOrgBOS) throws BusinessException {
        boolean result = true;
        if (capBusinessOrgBOS == null || capBusinessOrgBOS.isEmpty()) {
            return result;
        }
        try {
            ArrayList<CAPBusinessTemplateOrg> capBusinessTemplateOrgs = new ArrayList<CAPBusinessTemplateOrg>();
            Timestamp timestamp = DateUtil.currentTimestamp();
            for (CAPBusinessOrgBO capBusinessOrgBO : capBusinessOrgBOS) {
                capBusinessOrgBO.setCreateDate(String.valueOf(timestamp));
                capBusinessTemplateOrgs.add(capBusinessOrgBO.exportToPO());
            }
            this.capBusinessTemplateOrgDAO.insertCAPBusinessTemplateOrgs(capBusinessTemplateOrgs);
        }
        catch (ParseException e) {
            LOGGER.error((Object)("method saveCAPBusinessTemplateOrgs is error " + e.getMessage() + " AND param capBusinessOrgBOS is " + capBusinessOrgBOS.toString()), (Throwable)e);
            result = false;
        }
        return result;
    }

    @Override
    public Map<Long, List<CAPBusinessOrgBO>> getCAPBusinessOrgBOsByTemplateIds(List<Long> templateIds) {
        HashMap<Long, List<CAPBusinessOrgBO>> map = new HashMap<Long, List<CAPBusinessOrgBO>>();
        if (CollectionUtils.isEmpty(templateIds)) {
            return map;
        }
        try {
            List<CAPBusinessTemplateOrg> capBusinessTemplateOrgs = this.capBusinessTemplateOrgDAO.getCAPBusinessTemplateOrgsByTemplateIds(templateIds);
            if (CollectionUtils.isNotEmpty(capBusinessTemplateOrgs)) {
                for (CAPBusinessTemplateOrg capBusinessTemplateOrg : capBusinessTemplateOrgs) {
                    ArrayList<CAPBusinessOrgBO> capBusinessOrgBOS = (ArrayList<CAPBusinessOrgBO>)map.get(capBusinessTemplateOrg.getTemplateId());
                    if (capBusinessOrgBOS == null) {
                        capBusinessOrgBOS = new ArrayList<CAPBusinessOrgBO>();
                        map.put(capBusinessTemplateOrg.getTemplateId(), capBusinessOrgBOS);
                    }
                    CAPBusinessOrgBO capBusinessOrgBO = new CAPBusinessOrgBO();
                    capBusinessOrgBO.importFromPO(capBusinessTemplateOrg);
                    capBusinessOrgBOS.add(capBusinessOrgBO);
                }
            }
        }
        catch (BusinessException e) {
            LOGGER.error((Object)("method getCAPBusinessOrgBOsByTemplateIds is error" + e.getMessage() + " AND param templateId is" + templateIds));
        }
        return map;
    }

    @Override
    public List<CAPBusinessOrgBO> getCAPBusinessOrgBOsByTemplateId(Long templateId) {
        List<CAPBusinessOrgBO> capBusinessOrgBOs = new ArrayList<CAPBusinessOrgBO>();
        if (templateId == null) {
            return capBusinessOrgBOs;
        }
        try {
            List<CAPBusinessTemplateOrg> capBusinessTemplateOrgs = this.capBusinessTemplateOrgDAO.getCAPBusinessTemplateOrgsByTemplateId(templateId);
            capBusinessOrgBOs = this.importFromPO(capBusinessTemplateOrgs);
        }
        catch (BusinessException e) {
            LOGGER.error((Object)("method getCAPBusinessOrgBOsByTemplateId is error" + e.getMessage() + " AND param templateId is" + templateId));
        }
        return capBusinessOrgBOs;
    }

    @Override
    public List<CAPBusinessOrgBO> getCAPBusinessOrgBOsByOrgIds(List<Long> orgIds) {
        List<CAPBusinessOrgBO> capBusinessOrgBOS = new ArrayList<CAPBusinessOrgBO>();
        if (orgIds == null) {
            return capBusinessOrgBOS;
        }
        try {
            List<CAPBusinessTemplateOrg> capBusinessTemplateOrgs = this.capBusinessTemplateOrgDAO.getCAPBusinessTemplateOrgsByOrgIds(orgIds);
            capBusinessOrgBOS = this.importFromPO(capBusinessTemplateOrgs);
        }
        catch (BusinessException e) {
            LOGGER.error((Object)("method getCAPBusinessOrgBOsByOrgIds is error" + e.getMessage() + " AND param orgIds is" + orgIds.toString()));
        }
        return capBusinessOrgBOS;
    }

    private List<CAPBusinessOrgBO> importFromPO(List<CAPBusinessTemplateOrg> capBusinessTemplateOrgs) throws BusinessException {
        ArrayList<CAPBusinessOrgBO> capBusinessOrgBOS = new ArrayList<CAPBusinessOrgBO>();
        if (CollectionUtils.isNotEmpty(capBusinessTemplateOrgs)) {
            for (CAPBusinessTemplateOrg capBusinessTemplateOrg : capBusinessTemplateOrgs) {
                CAPBusinessOrgBO capBusinessOrgBO = new CAPBusinessOrgBO();
                capBusinessOrgBO.importFromPO(capBusinessTemplateOrg);
                capBusinessOrgBOS.add(capBusinessOrgBO);
            }
        }
        return capBusinessOrgBOS;
    }

    @Override
    public List<CAPBusinessOrgBO> getBOsByIds(List<Long> ids) {
        ArrayList<CAPBusinessOrgBO> capBusinessOrgBOS = new ArrayList<CAPBusinessOrgBO>();
        if (CollectionUtils.isNotEmpty(ids)) {
            try {
                if (ids.size() > 999) {
                    List pIds = Lists.partition(ids, (int)999);
                    for (List p : pIds) {
                        List<CAPBusinessTemplateOrg> capBusinessTemplateOrgs = this.capBusinessTemplateOrgDAO.getCAPBusinessTemplateOrgsByIds(p);
                        capBusinessOrgBOS.addAll(this.importFromPO(capBusinessTemplateOrgs));
                    }
                } else {
                    List<CAPBusinessTemplateOrg> capBusinessTemplateOrgs = this.capBusinessTemplateOrgDAO.getCAPBusinessTemplateOrgsByIds(ids);
                    capBusinessOrgBOS.addAll(this.importFromPO(capBusinessTemplateOrgs));
                }
            }
            catch (BusinessException e) {
                LOGGER.error((Object)("method getBOsByIds is error" + e.getMessage() + " AND param ids is" + ids.toString()));
            }
        }
        return capBusinessOrgBOS;
    }

    @Override
    public boolean isEqual(CAPBusinessOrgBO bo1, CAPBusinessOrgBO bo2) {
        if (bo1 == null || bo2 == null) {
            return true;
        }
        return StringUtils.equals((CharSequence)bo1.getId(), (CharSequence)bo2.getId()) && StringUtils.equals((CharSequence)bo1.getTemplateId(), (CharSequence)bo2.getTemplateId()) && StringUtils.equals((CharSequence)bo1.getOrgId(), (CharSequence)bo2.getOrgId()) && StringUtils.equals((CharSequence)bo1.getOrgType(), (CharSequence)bo2.getOrgType());
    }

    public void setCapBusinessTemplateOrgDAO(CAPBusinessTemplateOrgDAO capBusinessTemplateOrgDAO) {
        this.capBusinessTemplateOrgDAO = capBusinessTemplateOrgDAO;
    }
}

