/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.cap4.template.manager.impl;

import com.seeyon.cap4.form.bean.FormBean;
import com.seeyon.cap4.form.bean.FormBindAuthBean;
import com.seeyon.cap4.form.bean.SimpleObjectBean;
import com.seeyon.cap4.form.modules.business.BizConfigBean;
import com.seeyon.cap4.form.modules.business.BusinessManager;
import com.seeyon.cap4.form.modules.business.CtpBizConfigItem;
import com.seeyon.cap4.form.service.CAP4FormCacheManager;
import com.seeyon.cap4.form.util.Enums;
import com.seeyon.cap4.template.constant.CAPBusinessEnum;
import com.seeyon.cap4.template.manager.AbstractColumnElementDataManager;
import com.seeyon.cap4.template.manager.CAPBusinessTemplateManager;
import com.seeyon.cap4.template.manager.CAPBussinessMenuCollectionManager;
import com.seeyon.ctp.common.AppContext;
import com.seeyon.ctp.common.exceptions.BusinessException;
import com.seeyon.ctp.common.log.CtpLogFactory;
import com.seeyon.ctp.privilege.bo.PrivMenuBO;
import com.seeyon.ctp.util.Strings;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;

public class CAPBussinessMenuCollectionManagerImpl
extends AbstractColumnElementDataManager
implements CAPBussinessMenuCollectionManager {
    private static final Log LOGGER = CtpLogFactory.getLog(CAPBussinessMenuCollectionManagerImpl.class);
    private BusinessManager businessManager4;
    private CAP4FormCacheManager cap4FormCacheManager;
    private CAPBusinessTemplateManager capBusinessTemplateManager;

    @Override
    public Map<String, Object> getColumnElementData(Map<String, Object> params) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        String bussId = (String)params.get("bussId");
        String type = (String)params.get("type");
        if (Strings.isBlank((String)bussId) || Strings.isBlank((String)type)) {
            result.put("code", "1001");
            result.put("message", String.format("this param %s is null!", "bussId or type"));
            return result;
        }
        String client = (String)params.get("client");
        if (Strings.isBlank((String)client)) {
            client = String.valueOf(AppContext.getCurrentUser().getLoginSign());
        }
        try {
            HashMap data = new HashMap();
            ArrayList shortCutArray = new ArrayList();
            Long bizId = Long.valueOf(bussId);
            BizConfigBean bizConfigBean = this.businessManager4.findBizConfigById(bizId);
            List<PrivMenuBO> hasAuthMenuList = this.businessManager4.checkMenuAuth(bizConfigBean.getMenuId());
            block10: for (PrivMenuBO privMenuBO : hasAuthMenuList) {
                CtpBizConfigItem ctpBizConfigItem = new CtpBizConfigItem();
                ctpBizConfigItem.setPrivMenuBO(privMenuBO);
                if (ctpBizConfigItem.getSourceType() == -1 || ctpBizConfigItem.getSourceType().intValue() == Enums.SourceType.SOURCE_TYPE_CATG.getKey()) continue;
                HashMap<String, String> privMenu = new HashMap<String, String>();
                privMenu.put("menuName", ctpBizConfigItem.getName());
                privMenu.put("appId", ctpBizConfigItem.getSourceId().toString());
                privMenu.put("menuIcon", ctpBizConfigItem.getMenuIcon());
                privMenu.put("type", type);
                CAPBusinessEnum.DataSource dataSource = CAPBusinessEnum.DataSource.getDataSourceByKey(type);
                if (dataSource == null) continue;
                switch (dataSource) {
                    case ALL_MENU_COLLECTION: {
                        if (ctpBizConfigItem.getSourceType().intValue() == Enums.SourceType.SOURCE_TYPE_FLOWTEMPLATE.getKey() && ctpBizConfigItem.getFlowMenuType() == 1 && ctpBizConfigItem.getSourceId() != 0L) {
                            privMenu.put("isUseCustomTemplate", this.capBusinessTemplateManager.isUseCustomTemplate(bizId, ctpBizConfigItem.getSourceId(), CAPBusinessEnum.TemplateType.TP_FLOW.getType(), Integer.parseInt(client)) ? CAPBusinessEnum.TrueOrFalseEnum.TRUE.getKey() : CAPBusinessEnum.TrueOrFalseEnum.FALSE.getKey());
                            privMenu.put("type", CAPBusinessEnum.DataSource.FLOW_CREATE_MENU_COLLECTION.getKey());
                            shortCutArray.add(privMenu);
                        }
                        if (ctpBizConfigItem.getSourceType().intValue() == Enums.SourceType.SOURCE_TYPE_INFOMANAGE.getKey() && ctpBizConfigItem.getFlowMenuType() == 0) {
                            privMenu.put("isUseCustomTemplate", this.capBusinessTemplateManager.isUseCustomTemplate(bizId, ctpBizConfigItem.getSourceId(), CAPBusinessEnum.TemplateType.TP_UNFLOW.getType(), Integer.parseInt(client)) ? CAPBusinessEnum.TrueOrFalseEnum.TRUE.getKey() : CAPBusinessEnum.TrueOrFalseEnum.FALSE.getKey());
                            privMenu.put("formId", String.valueOf(ctpBizConfigItem.getFormAppmainId()));
                            privMenu.put("type", CAPBusinessEnum.DataSource.UNFLOW_MENU_COLLECTION.getKey());
                            shortCutArray.add(privMenu);
                        }
                        if (Enums.SourceType.SOURCE_TYPE_QUERY.getKey() == privMenuBO.getExt12().intValue()) {
                            privMenu.put("isUseCustomTemplate", this.capBusinessTemplateManager.isUseCustomTemplate(bizId, privMenuBO.getExt17(), CAPBusinessEnum.TemplateType.TP_QUERY.getType(), Integer.parseInt(client)) ? CAPBusinessEnum.TrueOrFalseEnum.TRUE.getKey() : CAPBusinessEnum.TrueOrFalseEnum.FALSE.getKey());
                            privMenu.put("type", CAPBusinessEnum.DataSource.QUERY_MENU_COLLECTION.getKey());
                            shortCutArray.add(privMenu);
                        }
                        if (Enums.SourceType.SOURCE_TYPE_REPORT.getKey() != privMenuBO.getExt12().intValue()) break;
                        privMenu.put("isUseCustomTemplate", this.capBusinessTemplateManager.isUseCustomTemplate(bizId, privMenuBO.getExt17(), CAPBusinessEnum.TemplateType.TP_CACL.getType(), Integer.parseInt(client)) ? CAPBusinessEnum.TrueOrFalseEnum.TRUE.getKey() : CAPBusinessEnum.TrueOrFalseEnum.FALSE.getKey());
                        privMenu.put("type", CAPBusinessEnum.DataSource.CACL_MENU_COLLECTION.getKey());
                        shortCutArray.add(privMenu);
                        break;
                    }
                    case FLOW_CREATE_MENU_COLLECTION: {
                        if (ctpBizConfigItem.getSourceType().intValue() != Enums.SourceType.SOURCE_TYPE_FLOWTEMPLATE.getKey() || ctpBizConfigItem.getFlowMenuType() != 1 || ctpBizConfigItem.getSourceId() == 0L) break;
                        privMenu.put("isUseCustomTemplate", this.capBusinessTemplateManager.isUseCustomTemplate(bizId, ctpBizConfigItem.getSourceId(), CAPBusinessEnum.TemplateType.TP_FLOW.getType(), Integer.parseInt(client)) ? CAPBusinessEnum.TrueOrFalseEnum.TRUE.getKey() : CAPBusinessEnum.TrueOrFalseEnum.FALSE.getKey());
                        shortCutArray.add(privMenu);
                        break;
                    }
                    case UNFLOW_CREATE_MENU_COLLECTION: {
                        if (ctpBizConfigItem.getSourceType().intValue() != Enums.SourceType.SOURCE_TYPE_INFOMANAGE.getKey() || ctpBizConfigItem.getFlowMenuType() != 0) break;
                        privMenu.put("isUseCustomTemplate", this.capBusinessTemplateManager.isUseCustomTemplate(bizId, ctpBizConfigItem.getSourceId(), CAPBusinessEnum.TemplateType.TP_UNFLOW.getType(), Integer.parseInt(client)) ? CAPBusinessEnum.TrueOrFalseEnum.TRUE.getKey() : CAPBusinessEnum.TrueOrFalseEnum.FALSE.getKey());
                        privMenu.put("formId", String.valueOf(ctpBizConfigItem.getFormAppmainId()));
                        FormBean formBean = this.cap4FormCacheManager.getForm(ctpBizConfigItem.getFormAppmainId());
                        FormBindAuthBean formBindAuthBean = formBean.getBind().getFormBindAuthBean(String.valueOf(ctpBizConfigItem.getSourceId()));
                        SimpleObjectBean add = formBindAuthBean.getAuthObjByName(FormBindAuthBean.AuthName.ADD.getKey());
                        if (add == null) continue block10;
                        if (Strings.isNotBlank((String)add.getValue()) && CAPBusinessEnum.Platform.PC.getType() == Integer.parseInt(client)) {
                            privMenu.put("viewId", add.getValue().split("\\.")[0]);
                            privMenu.put("authId", add.getValue().split("\\.")[1]);
                            shortCutArray.add(privMenu);
                        }
                        if (!Strings.isNotBlank((String)add.getPhoneValue()) || CAPBusinessEnum.Platform.MOBILE.getType() != Integer.parseInt(client)) continue block10;
                        privMenu.put("phoneViewId", add.getPhoneValue().split("\\.")[0]);
                        privMenu.put("phoneAuthId", add.getPhoneValue().split("\\.")[1]);
                        shortCutArray.add(privMenu);
                        break;
                    }
                    case UNFLOW_MENU_COLLECTION: {
                        if (ctpBizConfigItem.getSourceType().intValue() != Enums.SourceType.SOURCE_TYPE_INFOMANAGE.getKey() || ctpBizConfigItem.getFlowMenuType() != 0) break;
                        privMenu.put("isUseCustomTemplate", this.capBusinessTemplateManager.isUseCustomTemplate(bizId, ctpBizConfigItem.getSourceId(), CAPBusinessEnum.TemplateType.TP_UNFLOW.getType(), Integer.parseInt(client)) ? CAPBusinessEnum.TrueOrFalseEnum.TRUE.getKey() : CAPBusinessEnum.TrueOrFalseEnum.FALSE.getKey());
                        privMenu.put("formId", String.valueOf(ctpBizConfigItem.getFormAppmainId()));
                        shortCutArray.add(privMenu);
                        break;
                    }
                    case QUERY_MENU_COLLECTION: {
                        if (Enums.SourceType.SOURCE_TYPE_QUERY.getKey() != privMenuBO.getExt12().intValue()) break;
                        privMenu.put("isUseCustomTemplate", this.capBusinessTemplateManager.isUseCustomTemplate(bizId, privMenuBO.getExt17(), CAPBusinessEnum.TemplateType.TP_QUERY.getType(), Integer.parseInt(client)) ? CAPBusinessEnum.TrueOrFalseEnum.TRUE.getKey() : CAPBusinessEnum.TrueOrFalseEnum.FALSE.getKey());
                        shortCutArray.add(privMenu);
                        break;
                    }
                    case CACL_MENU_COLLECTION: {
                        if (Enums.SourceType.SOURCE_TYPE_REPORT.getKey() != privMenuBO.getExt12().intValue()) break;
                        privMenu.put("isUseCustomTemplate", this.capBusinessTemplateManager.isUseCustomTemplate(bizId, privMenuBO.getExt17(), CAPBusinessEnum.TemplateType.TP_CACL.getType(), Integer.parseInt(client)) ? CAPBusinessEnum.TrueOrFalseEnum.TRUE.getKey() : CAPBusinessEnum.TrueOrFalseEnum.FALSE.getKey());
                        shortCutArray.add(privMenu);
                        break;
                    }
                }
            }
            data.put(CAPBusinessEnum.ColumnType.SHORT_CUT.getAlias(), shortCutArray);
            result.put("code", "1000");
            result.put("message", "the operation is success!!!");
            result.put("data", data);
        }
        catch (BusinessException e) {
            LOGGER.error((Object)("CAPBussinessMenuCollectionManagerImpl.BusinessException, params=" + params.toString()), (Throwable)e);
            result.put("code", "1002");
            result.put("message", String.format("%s option exception!", "CAPBussinessMenuCollectionManagerImpl.BusinessException"));
            return result;
        }
        return result;
    }

    @Override
    public String getClassId() {
        return String.valueOf(CAPBusinessEnum.ColumnType.MENU_COLLECTION.getType());
    }

    public void setBusinessManager4(BusinessManager businessManager4) {
        this.businessManager4 = businessManager4;
    }

    public void setCapBusinessTemplateManager(CAPBusinessTemplateManager capBusinessTemplateManager) {
        this.capBusinessTemplateManager = capBusinessTemplateManager;
    }

    public void setCap4FormCacheManager(CAP4FormCacheManager cap4FormCacheManager) {
        this.cap4FormCacheManager = cap4FormCacheManager;
    }
}

