/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.cap4.template.manager.impl;

import com.seeyon.apps.collaboration.api.CollaborationApi;
import com.seeyon.apps.collaboration.enums.ColQueryCondition;
import com.seeyon.cap4.form.bean.FormBean;
import com.seeyon.cap4.form.bean.FormBindAuthBean;
import com.seeyon.cap4.form.bean.SimpleObjectBean;
import com.seeyon.cap4.form.modules.business.BizConfigBean;
import com.seeyon.cap4.form.modules.business.BusinessManager;
import com.seeyon.cap4.form.modules.business.CtpBizConfigItem;
import com.seeyon.cap4.form.modules.business.FormAppBO;
import com.seeyon.cap4.form.service.CAP4FormCacheManager;
import com.seeyon.cap4.form.service.CAP4FormManager;
import com.seeyon.cap4.form.util.Enums;
import com.seeyon.cap4.template.constant.CAPBusinessEnum;
import com.seeyon.cap4.template.manager.AbstractColumnElementDataManager;
import com.seeyon.cap4.template.manager.CAPBusinessTemplateManager;
import com.seeyon.cap4.template.manager.CAPBussinessMenuColumnManager;
import com.seeyon.cap4.template.util.CAPFormUtil;
import com.seeyon.ctp.common.AppContext;
import com.seeyon.ctp.common.constants.Constants;
import com.seeyon.ctp.common.content.affair.constants.StateEnum;
import com.seeyon.ctp.common.exceptions.BusinessException;
import com.seeyon.ctp.common.i18n.ResourceUtil;
import com.seeyon.ctp.common.log.CtpLogFactory;
import com.seeyon.ctp.common.template.manager.TemplateManager;
import com.seeyon.ctp.form.util.StringUtils;
import com.seeyon.ctp.login.bo.MenuBO;
import com.seeyon.ctp.portal.api.PortalApi;
import com.seeyon.ctp.privilege.bo.PrivMenuBO;
import com.seeyon.ctp.report.engine.api.manager.ReportApi;
import com.seeyon.ctp.util.ParamUtil;
import com.seeyon.ctp.util.Strings;
import com.seeyon.ctp.util.UUIDLong;
import com.seeyon.ctp.util.json.JSONUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;

public class CAPBussinessMenuColumnManagerImpl
extends AbstractColumnElementDataManager
implements CAPBussinessMenuColumnManager {
    private static final Log LOGGER = CtpLogFactory.getLog(CAPBussinessMenuColumnManagerImpl.class);
    private CAPBusinessTemplateManager capBusinessTemplateManager;
    private BusinessManager businessManager4;
    private TemplateManager templateManager;
    private CAP4FormCacheManager cap4FormCacheManager;
    private CollaborationApi collaborationApi;
    private CAP4FormManager cap4FormManager;
    private ReportApi reportApi;
    private PortalApi portalApi;
    private static final String MENU_NAME = "menuName";
    private static final String APP_ID = "appId";
    private static final String IS_USE_CUSTOM_TEMPLATE = "isUseCustomTemplate";
    private static final String CATEGORY_MENU = "categoryMenu";
    private static final String BUSS_NAME = "bussName";
    private static final String BUSS_IMG = "bussImg";
    private static final String FORM_ID = "formId";
    private static final String MENU_TYPE = "menuType";
    private static final String MENU_LIST = "menuList";
    private static final String MENU_ID = "menuId";
    private static final String MENU_ICON = "menuIcon";
    private static final String LIST_PENDING_NUM = "listPendingNum";
    private static final String LIST_SENT_NUM = "listSentNum";
    private static final String TYPE = "type";
    private static final String BUSS_ID = "bussId";
    private static final String CLIENT = "client";
    private static final String URL = "url";
    private static final String TARGET = "target";

    @Override
    public Map<String, Object> getColumnElementData(Map<String, Object> params) {
        HashMap<String, Object> result;
        block7: {
            result = new HashMap<String, Object>();
            String type = ParamUtil.getString(params, (String)TYPE);
            if (Strings.isBlank((String)type)) {
                result.put("code", "1001");
                result.put("message", String.format("this param %s is null!", TYPE));
                return result;
            }
            try {
                if (CAPBusinessEnum.DataSource.APP_IN_MENU_NOT_CONFIG.getKey().equals(type) || CAPBusinessEnum.DataSource.APP_IN_MENU_HAS_CONFIG.getKey().equals(type)) {
                    String bizId = ParamUtil.getString(params, (String)BUSS_ID);
                    String client = ParamUtil.getString(params, (String)CLIENT);
                    if (Strings.isBlank((String)bizId) || Strings.isBlank((String)client)) {
                        result.put("code", "1001");
                        result.put("message", String.format("this param %s is null!", "bussId or client"));
                        return result;
                    }
                    Map<String, Object> data = this.getMenusByBussId(bizId, client);
                    result.put("code", "1000");
                    result.put("message", "the operation is success!!!");
                    result.put("data", data);
                    break block7;
                }
                if (!CAPBusinessEnum.DataSource.MUTI_BUSINESS_MENU.getKey().equals(type)) break block7;
                String menuId = ParamUtil.getString(params, (String)MENU_ID);
                if (Strings.isBlank((String)menuId)) {
                    result.put("code", "1001");
                    result.put("message", String.format("this param %s is null!", MENU_ID));
                    return result;
                }
                String portalId = this.portalApi.getUserAcessMainPortalIdFromCache();
                List menuBOS = this.portalApi.getMenuBoListByPortalId(Long.valueOf(portalId));
                int j = menuBOS.size();
                for (int i = 0; i < j; ++i) {
                    MenuBO menuBO = (MenuBO)menuBOS.get(i);
                    if (!menuId.equals(String.valueOf(menuBO.getId()))) continue;
                    result.put("code", "1000");
                    result.put("message", "the operation is success!!!");
                    Map menuBoMap = (Map)JSONUtil.parseJSONString((String)JSONUtil.toJSONString((Object)menuBO), Map.class);
                    result.put("data", menuBoMap);
                    break;
                }
            }
            catch (BusinessException e) {
                result.put("code", "1002");
                result.put("message", String.format("%s option exception!", "get menu list BusinessException"));
            }
        }
        return result;
    }

    @Override
    public Map<String, Object> getMenusByBussId(String bizId, String platform) throws BusinessException {
        long startTime = System.currentTimeMillis();
        Integer userAgent = Strings.isBlank((String)platform) ? AppContext.getCurrentUser().getLoginSign() : Integer.valueOf(platform).intValue();
        ArrayList<Map<String, Object>> flowArray = new ArrayList<Map<String, Object>>();
        ArrayList<Map<String, Object>> shortCutArray = new ArrayList<Map<String, Object>>();
        ArrayList<Map<String, Object>> categoryArray = new ArrayList<Map<String, Object>>();
        BizConfigBean bizConfigBean = this.businessManager4.findBizConfigById(Long.parseLong(bizId));
        List privMenuBOS = bizConfigBean.getMenuList();
        long appBOTime = System.currentTimeMillis();
        List<FormAppBO> formList = this.businessManager4.getFormListByBizId(Long.parseLong(bizId));
        LOGGER.info((Object)("getMenusByBussId " + bizId + " businessManager4.getFormListByBizId " + (System.currentTimeMillis() - appBOTime) + " formList " + (formList == null ? 0 : formList.size())));
        StringBuilder templateIdSb = new StringBuilder();
        boolean hasApprovaerMenu = this.getTemplateIds(formList, bizId, templateIdSb, flowArray, userAgent);
        if (privMenuBOS != null && privMenuBOS.size() == 1 && ((PrivMenuBO)privMenuBOS.get(0)).getId().longValue() == bizConfigBean.getMenuId().longValue()) {
            this.getMenusOfNotSetMenu(bizId, userAgent, shortCutArray, categoryArray, formList);
        } else {
            this.getMenusOfHasSetMenu(bizId, userAgent, shortCutArray, categoryArray, bizConfigBean);
        }
        if (hasApprovaerMenu) {
            ((Map)flowArray.get(0)).put(APP_ID, StringUtils.replaceLast((String)templateIdSb.toString(), (String)",", (String)""));
        }
        HashMap<String, Object> data = new HashMap<String, Object>();
        if (userAgent.equals(Constants.login_sign.phone.value())) {
            this.getFlowIndxs(flowArray, templateIdSb.toString(), data);
        }
        ArrayList shortCut = new ArrayList();
        HashMap<String, Object> createMap = new HashMap<String, Object>();
        createMap.put(MENU_NAME, ResourceUtil.getString((String)"cap.template.business.menuColumn.createName"));
        createMap.put(MENU_LIST, shortCutArray);
        createMap.put(APP_ID, bizId);
        createMap.put(MENU_ID, String.valueOf(UUIDLong.longUUID()));
        createMap.put(MENU_TYPE, CAPBusinessEnum.DataSource.CATEGORY.getKey());
        shortCut.add(createMap);
        data.put(CAPBusinessEnum.ColumnType.FLOW_LIST.getAlias(), flowArray);
        data.put(CAPBusinessEnum.ColumnType.SHORT_CUT.getAlias(), shortCut);
        data.put(CATEGORY_MENU, categoryArray);
        data.put(BUSS_NAME, bizConfigBean.getName());
        data.put(BUSS_IMG, bizConfigBean.getBizIcon());
        LOGGER.info((Object)("getMenusByBussId " + bizId + " use " + (System.currentTimeMillis() - startTime) + " " + AppContext.currentUserName()));
        return data;
    }

    @Override
    public Map<String, Object> getMenuSettingsList(String bizId, String platform) throws BusinessException {
        Integer userAgent = Strings.isBlank((String)platform) ? AppContext.getCurrentUser().getLoginSign() : Integer.valueOf(platform).intValue();
        ArrayList<Map<String, Object>> flowArray = new ArrayList<Map<String, Object>>();
        ArrayList<Map<String, Object>> shortCutArray = new ArrayList<Map<String, Object>>();
        ArrayList<Map<String, Object>> categoryArray = new ArrayList<Map<String, Object>>();
        BizConfigBean bizConfigBean = this.businessManager4.findBizConfigById(Long.parseLong(bizId));
        List privMenuBOS = bizConfigBean.getMenuList();
        List<FormAppBO> formList = this.businessManager4.getFormListByBizId(Long.parseLong(bizId));
        StringBuilder templateIdSb = new StringBuilder();
        boolean hasApprovaerMenu = this.getTemplateIds(formList, bizId, templateIdSb, flowArray, userAgent);
        if (privMenuBOS != null && privMenuBOS.size() == 1 && ((PrivMenuBO)privMenuBOS.get(0)).getId().longValue() == bizConfigBean.getMenuId().longValue()) {
            this.getMenusOfNotSetMenu(bizId, userAgent, shortCutArray, categoryArray, formList);
        } else {
            this.getMenusOfHasSetMenuBySettingsList(bizId, userAgent, shortCutArray, categoryArray, bizConfigBean);
        }
        if (hasApprovaerMenu) {
            ((Map)flowArray.get(0)).put(APP_ID, StringUtils.replaceLast((String)templateIdSb.toString(), (String)",", (String)""));
        }
        HashMap<String, Object> data = new HashMap<String, Object>();
        if (userAgent.equals(Constants.login_sign.phone.value())) {
            this.getFlowIndxs(flowArray, templateIdSb.toString(), data);
        }
        if (userAgent.equals(Constants.login_sign.pc.value())) {
            ArrayList shortCut = new ArrayList();
            HashMap<String, Object> createMap = new HashMap<String, Object>();
            createMap.put(MENU_NAME, ResourceUtil.getString((String)"cap.template.business.menuColumn.createName"));
            createMap.put(MENU_LIST, shortCutArray);
            createMap.put(APP_ID, bizId);
            createMap.put(MENU_ID, String.valueOf(UUIDLong.longUUID()));
            createMap.put(MENU_TYPE, CAPBusinessEnum.DataSource.CATEGORY.getKey());
            shortCut.add(createMap);
            data.put(CAPBusinessEnum.ColumnType.SHORT_CUT.getAlias(), shortCut);
        }
        data.put(CAPBusinessEnum.ColumnType.FLOW_LIST.getAlias(), flowArray);
        data.put(CATEGORY_MENU, categoryArray);
        data.put(BUSS_NAME, bizConfigBean.getName());
        data.put(BUSS_IMG, bizConfigBean.getBizIcon());
        return data;
    }

    private void getMenusOfHasSetMenu(String bizId, Integer userAgent, List<Map<String, Object>> shortCutArray, List<Map<String, Object>> categoryArray, BizConfigBean bizConfigBean) throws BusinessException {
        long startTime = System.currentTimeMillis();
        List<PrivMenuBO> hasAuthMenuList = this.businessManager4.checkMenuAuth(bizConfigBean.getMenuId());
        LOGGER.info((Object)("getMenusOfHasSetMenu " + bizId + ", menuId " + bizConfigBean.getMenuId() + " checkMenuAuth use " + (System.currentTimeMillis() - startTime)));
        ArrayList<CtpBizConfigItem> ctpBizConfigItems = new ArrayList<CtpBizConfigItem>(hasAuthMenuList.size());
        this.getCtpBizConfigItems(userAgent, hasAuthMenuList, ctpBizConfigItems);
        for (int i = 0; i < ctpBizConfigItems.size(); ++i) {
            HashMap category;
            List menuList;
            CtpBizConfigItem ctpBizConfigItem = (CtpBizConfigItem)ctpBizConfigItems.get(i);
            if (ctpBizConfigItem.getSourceType().equals(Enums.SourceType.SOURCE_TYPE_CATG.getKey())) {
                this.isMenuCategory(categoryArray, ctpBizConfigItems, i, ctpBizConfigItem);
                continue;
            }
            HashMap<String, String> privMenu = new HashMap<String, String>();
            privMenu.put(MENU_NAME, ctpBizConfigItem.getName());
            privMenu.put(APP_ID, ctpBizConfigItem.getSourceId().toString());
            privMenu.put(MENU_ID, String.valueOf(ctpBizConfigItem.getMenuId()));
            privMenu.put(MENU_ICON, ctpBizConfigItem.getMenuIcon());
            boolean isUrlType = true;
            if (ctpBizConfigItem.getSourceType().equals(Enums.SourceType.SOURCE_TYPE_FLOWTEMPLATE.getKey()) && ctpBizConfigItem.getFlowMenuType() == 2 && ctpBizConfigItem.getSourceId() != 0L) {
                privMenu.put(IS_USE_CUSTOM_TEMPLATE, this.capBusinessTemplateManager.isUseCustomTemplate(Long.valueOf(bizId), ctpBizConfigItem.getSourceId(), CAPBusinessEnum.TemplateType.TP_FLOW.getType(), userAgent) ? CAPBusinessEnum.TrueOrFalseEnum.TRUE.getKey() : CAPBusinessEnum.TrueOrFalseEnum.FALSE.getKey());
                privMenu.put(MENU_TYPE, CAPBusinessEnum.DataSource.FLOW_LIST.getKey());
                isUrlType = false;
            }
            if (ctpBizConfigItem.getSourceType().equals(Enums.SourceType.SOURCE_TYPE_FLOWTEMPLATE.getKey()) && ctpBizConfigItem.getFlowMenuType() == 1 && ctpBizConfigItem.getSourceId() != 0L) {
                privMenu.put(IS_USE_CUSTOM_TEMPLATE, this.capBusinessTemplateManager.isUseCustomTemplate(Long.valueOf(bizId), ctpBizConfigItem.getSourceId(), CAPBusinessEnum.TemplateType.TP_FLOW.getType(), userAgent) ? CAPBusinessEnum.TrueOrFalseEnum.TRUE.getKey() : CAPBusinessEnum.TrueOrFalseEnum.FALSE.getKey());
                privMenu.put(MENU_TYPE, CAPBusinessEnum.DataSource.LIST_CREATE.getKey());
                shortCutArray.add(privMenu);
                if (i == ctpBizConfigItems.size() - 1 && categoryArray.size() > 0) {
                    Map<String, Object> currentLastPrivMenu = categoryArray.get(categoryArray.size() - 1);
                    if (CAPBusinessEnum.DataSource.CATEGORY.getKey().equals(String.valueOf(currentLastPrivMenu.get(MENU_TYPE))) && ((List)currentLastPrivMenu.get(MENU_LIST)).size() == 0) {
                        categoryArray.remove(categoryArray.size() - 1);
                    }
                }
                isUrlType = false;
                continue;
            }
            if (ctpBizConfigItem.getSourceType().equals(Enums.SourceType.SOURCE_TYPE_INFOMANAGE.getKey())) {
                privMenu.put(IS_USE_CUSTOM_TEMPLATE, this.capBusinessTemplateManager.isUseCustomTemplate(Long.valueOf(bizId), ctpBizConfigItem.getSourceId(), CAPBusinessEnum.TemplateType.TP_UNFLOW.getType(), userAgent) ? CAPBusinessEnum.TrueOrFalseEnum.TRUE.getKey() : CAPBusinessEnum.TrueOrFalseEnum.FALSE.getKey());
                privMenu.put(MENU_TYPE, CAPBusinessEnum.DataSource.UNFLOW_LIST.getKey());
                privMenu.put(FORM_ID, String.valueOf(ctpBizConfigItem.getFormAppmainId()));
                FormBean formBean = this.cap4FormCacheManager.getForm(ctpBizConfigItem.getFormAppmainId());
                FormBindAuthBean formBindAuthBean = formBean.getBind().getFormBindAuthBean(String.valueOf(ctpBizConfigItem.getSourceId()));
                SimpleObjectBean add = formBindAuthBean.getAuthObjByName(FormBindAuthBean.AuthName.ADD.getKey());
                if (userAgent.intValue() == Constants.login_sign.phone.value() && CAPFormUtil.getMobileAuth(add) && Strings.isNotBlank((String)String.valueOf(add.getPhoneValue())) || userAgent.intValue() == Constants.login_sign.pc.value() && CAPFormUtil.getPcNewAuth(add) && Strings.isNotBlank((String)String.valueOf(add.getValue()))) {
                    HashMap<String, String> createPrivMenu = new HashMap<String, String>();
                    createPrivMenu.putAll(privMenu);
                    createPrivMenu.put(MENU_TYPE, CAPBusinessEnum.DataSource.UNFLOW_CREATE.getKey());
                    createPrivMenu.put(MENU_ID, String.valueOf(UUIDLong.longUUID()));
                    shortCutArray.add(createPrivMenu);
                }
                isUrlType = false;
            }
            if (ctpBizConfigItem.getSourceType().intValue() == Enums.SourceType.SOURCE_TYPE_QUERY.getKey()) {
                privMenu.put(IS_USE_CUSTOM_TEMPLATE, this.capBusinessTemplateManager.isUseCustomTemplate(Long.valueOf(bizId), ctpBizConfigItem.getSourceId(), CAPBusinessEnum.TemplateType.TP_QUERY.getType(), userAgent) ? CAPBusinessEnum.TrueOrFalseEnum.TRUE.getKey() : CAPBusinessEnum.TrueOrFalseEnum.FALSE.getKey());
                privMenu.put(MENU_TYPE, CAPBusinessEnum.DataSource.QUERY_LIST.getKey());
                isUrlType = false;
            }
            if (ctpBizConfigItem.getSourceType().intValue() == Enums.SourceType.SOURCE_TYPE_REPORT.getKey()) {
                privMenu.put(IS_USE_CUSTOM_TEMPLATE, this.capBusinessTemplateManager.isUseCustomTemplate(Long.valueOf(bizId), ctpBizConfigItem.getSourceId(), CAPBusinessEnum.TemplateType.TP_CACL.getType(), userAgent) ? CAPBusinessEnum.TrueOrFalseEnum.TRUE.getKey() : CAPBusinessEnum.TrueOrFalseEnum.FALSE.getKey());
                privMenu.put(MENU_TYPE, CAPBusinessEnum.DataSource.CACL_LIST.getKey());
                isUrlType = false;
            }
            if (ctpBizConfigItem.getSourceType().intValue() == Enums.SourceType.SOURCE_TYPE_BIZMAP.getKey()) {
                privMenu.put(IS_USE_CUSTOM_TEMPLATE, this.capBusinessTemplateManager.isUseCustomTemplate(Long.valueOf(bizId), ctpBizConfigItem.getSourceId(), CAPBusinessEnum.TemplateType.TP_BIZ_MAP.getType(), userAgent) ? CAPBusinessEnum.TrueOrFalseEnum.TRUE.getKey() : CAPBusinessEnum.TrueOrFalseEnum.FALSE.getKey());
                privMenu.put(MENU_TYPE, CAPBusinessEnum.DataSource.BIZ_MAP.getKey());
                isUrlType = false;
            }
            if (ctpBizConfigItem.getSourceType().intValue() == Enums.SourceType.SOURCE_TYPE_FLOWBUSINESS.getKey()) {
                privMenu.put(IS_USE_CUSTOM_TEMPLATE, this.capBusinessTemplateManager.isUseCustomTemplate(Long.valueOf(bizId), ctpBizConfigItem.getSourceId(), CAPBusinessEnum.TemplateType.TP_FLOW_BUSINESS.getType(), userAgent) ? CAPBusinessEnum.TrueOrFalseEnum.TRUE.getKey() : CAPBusinessEnum.TrueOrFalseEnum.FALSE.getKey());
                privMenu.put(MENU_TYPE, CAPBusinessEnum.DataSource.FLOW_BUSINESS.getKey());
                privMenu.put(FORM_ID, String.valueOf(ctpBizConfigItem.getFormAppmainId()));
                isUrlType = false;
            }
            if (isUrlType) {
                if (userAgent.intValue() == Constants.login_sign.phone.value()) {
                    privMenu.put(IS_USE_CUSTOM_TEMPLATE, CAPBusinessEnum.TrueOrFalseEnum.FALSE.getKey());
                    privMenu.put(MENU_TYPE, Enums.SourceType.getEnumByKey((int)ctpBizConfigItem.getSourceType()).name());
                    privMenu.put("frType", "21");
                } else {
                    privMenu.put(IS_USE_CUSTOM_TEMPLATE, CAPBusinessEnum.TrueOrFalseEnum.FALSE.getKey());
                    privMenu.put(URL, ctpBizConfigItem.getPrivMenuBO().getResourceNavurl());
                    privMenu.put(TARGET, ctpBizConfigItem.getPrivMenuBO().getTarget() == null ? "mainfrm" : ctpBizConfigItem.getPrivMenuBO().getTarget());
                    privMenu.put(MENU_TYPE, CAPBusinessEnum.DataSource.URL_TYPE.getKey());
                }
            }
            if ((menuList = (List)(category = categoryArray.size() == 0 ? new HashMap() : categoryArray.get(categoryArray.size() - 1)).get(MENU_LIST)) == null) {
                categoryArray.add(privMenu);
                continue;
            }
            menuList.add(privMenu);
        }
        LOGGER.info((Object)("getMenusOfHasSetMenu " + bizId + " use " + (System.currentTimeMillis() - startTime)));
    }

    private void getCtpBizConfigItems(Integer userAgent, List<PrivMenuBO> hasAuthMenuList, List<CtpBizConfigItem> ctpBizConfigItems) {
        for (int i = 0; i < hasAuthMenuList.size(); ++i) {
            PrivMenuBO privMenuBO = hasAuthMenuList.get(i);
            CtpBizConfigItem ctpBizConfigItem = new CtpBizConfigItem();
            ctpBizConfigItem.setPrivMenuBO(privMenuBO);
            if (ctpBizConfigItem.getSourceType() == -1 || Enums.SourceType.SOURCE_TYPE_BIZHOMEPAGE.getKey() == ctpBizConfigItem.getSourceType().intValue() || Constants.login_sign.pc.value() != userAgent.intValue() && ctpBizConfigItem.getSourceType().intValue() == Enums.SourceType.SOURCE_TYPE_BIZMAP.getKey()) continue;
            ctpBizConfigItems.add(ctpBizConfigItem);
        }
    }

    private void getMenusOfHasSetMenuBySettingsList(String bizId, Integer userAgent, List<Map<String, Object>> shortCutArray, List<Map<String, Object>> categoryArray, BizConfigBean bizConfigBean) throws BusinessException {
        if (userAgent.intValue() == Constants.login_sign.pc.value()) {
            this.getMenusOfHasSetMenu(bizId, userAgent, shortCutArray, categoryArray, bizConfigBean);
        } else {
            this.getMenusBySettings(bizId, userAgent, categoryArray, bizConfigBean);
        }
    }

    private void getMenusBySettings(String bizId, Integer userAgent, List<Map<String, Object>> categoryArray, BizConfigBean bizConfigBean) throws BusinessException {
        List<PrivMenuBO> hasAuthMenuList = this.businessManager4.checkMenuAuth(bizConfigBean.getMenuId());
        ArrayList<CtpBizConfigItem> ctpBizConfigItems = new ArrayList<CtpBizConfigItem>(hasAuthMenuList.size());
        this.getCtpBizConfigItems(userAgent, hasAuthMenuList, ctpBizConfigItems);
        for (int i = 0; i < ctpBizConfigItems.size(); ++i) {
            CtpBizConfigItem ctpBizConfigItem = (CtpBizConfigItem)ctpBizConfigItems.get(i);
            if (ctpBizConfigItem.getSourceType().equals(Enums.SourceType.SOURCE_TYPE_CATG.getKey())) {
                this.isMenuCategory(categoryArray, ctpBizConfigItems, i, ctpBizConfigItem);
                continue;
            }
            HashMap<String, String> privMenu = new HashMap<String, String>();
            privMenu.put(MENU_NAME, ctpBizConfigItem.getName());
            privMenu.put(APP_ID, ctpBizConfigItem.getSourceId().toString());
            privMenu.put(MENU_ID, String.valueOf(ctpBizConfigItem.getMenuId()));
            privMenu.put(MENU_ICON, ctpBizConfigItem.getMenuIcon());
            boolean isUrlType = true;
            if (ctpBizConfigItem.getSourceType().equals(Enums.SourceType.SOURCE_TYPE_FLOWTEMPLATE.getKey()) && ctpBizConfigItem.getFlowMenuType() == 2 && ctpBizConfigItem.getSourceId() != 0L) {
                privMenu.put(IS_USE_CUSTOM_TEMPLATE, this.capBusinessTemplateManager.isUseCustomTemplate(Long.valueOf(bizId), ctpBizConfigItem.getSourceId(), CAPBusinessEnum.TemplateType.TP_FLOW.getType(), userAgent) ? CAPBusinessEnum.TrueOrFalseEnum.TRUE.getKey() : CAPBusinessEnum.TrueOrFalseEnum.FALSE.getKey());
                privMenu.put(MENU_TYPE, CAPBusinessEnum.DataSource.FLOW_LIST.getKey());
                isUrlType = false;
            }
            if (ctpBizConfigItem.getSourceType().equals(Enums.SourceType.SOURCE_TYPE_FLOWTEMPLATE.getKey()) && ctpBizConfigItem.getFlowMenuType() == 1 && ctpBizConfigItem.getSourceId() != 0L) {
                privMenu.put(IS_USE_CUSTOM_TEMPLATE, this.capBusinessTemplateManager.isUseCustomTemplate(Long.valueOf(bizId), ctpBizConfigItem.getSourceId(), CAPBusinessEnum.TemplateType.TP_FLOW.getType(), userAgent) ? CAPBusinessEnum.TrueOrFalseEnum.TRUE.getKey() : CAPBusinessEnum.TrueOrFalseEnum.FALSE.getKey());
                privMenu.put(MENU_TYPE, CAPBusinessEnum.DataSource.LIST_CREATE.getKey());
                isUrlType = false;
            }
            if (ctpBizConfigItem.getSourceType().equals(Enums.SourceType.SOURCE_TYPE_INFOMANAGE.getKey())) {
                privMenu.put(IS_USE_CUSTOM_TEMPLATE, this.capBusinessTemplateManager.isUseCustomTemplate(Long.valueOf(bizId), ctpBizConfigItem.getSourceId(), CAPBusinessEnum.TemplateType.TP_UNFLOW.getType(), userAgent) ? CAPBusinessEnum.TrueOrFalseEnum.TRUE.getKey() : CAPBusinessEnum.TrueOrFalseEnum.FALSE.getKey());
                privMenu.put(MENU_TYPE, CAPBusinessEnum.DataSource.UNFLOW_LIST.getKey());
                privMenu.put(FORM_ID, String.valueOf(ctpBizConfigItem.getFormAppmainId()));
                isUrlType = false;
            }
            if (ctpBizConfigItem.getSourceType().intValue() == Enums.SourceType.SOURCE_TYPE_QUERY.getKey()) {
                privMenu.put(IS_USE_CUSTOM_TEMPLATE, this.capBusinessTemplateManager.isUseCustomTemplate(Long.valueOf(bizId), ctpBizConfigItem.getSourceId(), CAPBusinessEnum.TemplateType.TP_QUERY.getType(), userAgent) ? CAPBusinessEnum.TrueOrFalseEnum.TRUE.getKey() : CAPBusinessEnum.TrueOrFalseEnum.FALSE.getKey());
                privMenu.put(MENU_TYPE, CAPBusinessEnum.DataSource.QUERY_LIST.getKey());
                isUrlType = false;
            }
            if (ctpBizConfigItem.getSourceType().intValue() == Enums.SourceType.SOURCE_TYPE_REPORT.getKey()) {
                privMenu.put(IS_USE_CUSTOM_TEMPLATE, this.capBusinessTemplateManager.isUseCustomTemplate(Long.valueOf(bizId), ctpBizConfigItem.getSourceId(), CAPBusinessEnum.TemplateType.TP_CACL.getType(), userAgent) ? CAPBusinessEnum.TrueOrFalseEnum.TRUE.getKey() : CAPBusinessEnum.TrueOrFalseEnum.FALSE.getKey());
                privMenu.put(MENU_TYPE, CAPBusinessEnum.DataSource.CACL_LIST.getKey());
                isUrlType = false;
            }
            if (ctpBizConfigItem.getSourceType().intValue() == Enums.SourceType.SOURCE_TYPE_BIZMAP.getKey()) {
                privMenu.put(IS_USE_CUSTOM_TEMPLATE, this.capBusinessTemplateManager.isUseCustomTemplate(Long.valueOf(bizId), ctpBizConfigItem.getSourceId(), CAPBusinessEnum.TemplateType.TP_BIZ_MAP.getType(), userAgent) ? CAPBusinessEnum.TrueOrFalseEnum.TRUE.getKey() : CAPBusinessEnum.TrueOrFalseEnum.FALSE.getKey());
                privMenu.put(MENU_TYPE, CAPBusinessEnum.DataSource.BIZ_MAP.getKey());
                isUrlType = false;
            }
            if (ctpBizConfigItem.getSourceType().intValue() == Enums.SourceType.SOURCE_TYPE_FLOWBUSINESS.getKey()) {
                privMenu.put(IS_USE_CUSTOM_TEMPLATE, this.capBusinessTemplateManager.isUseCustomTemplate(Long.valueOf(bizId), ctpBizConfigItem.getSourceId(), CAPBusinessEnum.TemplateType.TP_FLOW_BUSINESS.getType(), userAgent) ? CAPBusinessEnum.TrueOrFalseEnum.TRUE.getKey() : CAPBusinessEnum.TrueOrFalseEnum.FALSE.getKey());
                privMenu.put(MENU_TYPE, CAPBusinessEnum.DataSource.FLOW_BUSINESS.getKey());
                privMenu.put(FORM_ID, String.valueOf(ctpBizConfigItem.getFormAppmainId()));
                isUrlType = false;
            }
            if (isUrlType) {
                isUrlType = false;
                continue;
            }
            Map<Object, Object> category = categoryArray.size() == 0 ? new HashMap() : categoryArray.get(categoryArray.size() - 1);
            List menuList = (List)category.get(MENU_LIST);
            if (menuList == null) {
                categoryArray.add(privMenu);
                continue;
            }
            menuList.add(privMenu);
        }
    }

    private void isMenuCategory(List<Map<String, Object>> categoryArray, List<CtpBizConfigItem> ctpBizConfigItems, int i, CtpBizConfigItem ctpBizConfigItem) {
        CtpBizConfigItem tempCtpBizConfigItem;
        if (categoryArray.size() > 0) {
            Map<String, Object> currentLastPrivMenu = categoryArray.get(categoryArray.size() - 1);
            if (CAPBusinessEnum.DataSource.CATEGORY.getKey().equals(String.valueOf(currentLastPrivMenu.get(MENU_TYPE))) && ((List)currentLastPrivMenu.get(MENU_LIST)).size() == 0) {
                categoryArray.remove(categoryArray.size() - 1);
            }
        }
        if (i == ctpBizConfigItems.size() - 1) {
            return;
        }
        if (i < ctpBizConfigItems.size() - 1 && (tempCtpBizConfigItem = ctpBizConfigItems.get(i + 1)).getSourceType().intValue() == Enums.SourceType.SOURCE_TYPE_CATG.getKey()) {
            return;
        }
        HashMap<String, Object> privMenu = new HashMap<String, Object>();
        privMenu.put(MENU_NAME, ctpBizConfigItem.getName());
        privMenu.put(MENU_LIST, new ArrayList());
        privMenu.put(MENU_ID, String.valueOf(ctpBizConfigItem.getMenuId()));
        privMenu.put(MENU_TYPE, CAPBusinessEnum.DataSource.CATEGORY.getKey());
        privMenu.put(MENU_ICON, ctpBizConfigItem.getMenuIcon());
        categoryArray.add(privMenu);
    }

    private void getMenusOfNotSetMenu(String bizId, Integer userAgent, List<Map<String, Object>> shortCutArray, List<Map<String, Object>> categoryArray, List<FormAppBO> formList) throws BusinessException {
        long startTime = System.currentTimeMillis();
        ArrayList<Map<String, Object>> queryArray = new ArrayList<Map<String, Object>>();
        ArrayList<Map<String, Object>> caclArray = new ArrayList<Map<String, Object>>();
        ArrayList<Map<String, Object>> unflowArray = new ArrayList<Map<String, Object>>();
        for (FormAppBO formAppBO : formList) {
            HashMap<String, String> privMenu = new HashMap<String, String>();
            privMenu.put(MENU_NAME, formAppBO.getName());
            privMenu.put(APP_ID, formAppBO.getId());
            privMenu.put(MENU_ID, String.valueOf(UUIDLong.longUUID()));
            if (Enums.FormType.processesForm.getKey() == formAppBO.getSourceType() && this.templateManager.isTemplateEnabled(Long.valueOf(Long.parseLong(formAppBO.getId())), Long.valueOf(AppContext.currentUserId()))) {
                privMenu.put(IS_USE_CUSTOM_TEMPLATE, this.capBusinessTemplateManager.isUseCustomTemplate(Long.parseLong(bizId), Long.parseLong(formAppBO.getId()), CAPBusinessEnum.TemplateType.TP_FLOW.getType(), userAgent) ? CAPBusinessEnum.TrueOrFalseEnum.TRUE.getKey() : CAPBusinessEnum.TrueOrFalseEnum.FALSE.getKey());
                privMenu.put(MENU_TYPE, CAPBusinessEnum.DataSource.LIST_CREATE.getKey());
                shortCutArray.add(privMenu);
            }
            if (Enums.FormType.unFlowForm.getKey() == formAppBO.getSourceType() && this.cap4FormManager.checkRight(Enums.FormModuleAuthModuleType.BindAppForm, Long.parseLong(formAppBO.getId()), AppContext.currentUserId(), formAppBO.getFormAppmainId())) {
                privMenu.put(IS_USE_CUSTOM_TEMPLATE, this.capBusinessTemplateManager.isUseCustomTemplate(Long.parseLong(bizId), Long.parseLong(formAppBO.getId()), CAPBusinessEnum.TemplateType.TP_UNFLOW.getType(), userAgent) ? CAPBusinessEnum.TrueOrFalseEnum.TRUE.getKey() : CAPBusinessEnum.TrueOrFalseEnum.FALSE.getKey());
                privMenu.put(FORM_ID, String.valueOf(formAppBO.getFormAppmainId()));
                privMenu.put(MENU_TYPE, CAPBusinessEnum.DataSource.UNFLOW_LIST.getKey());
                unflowArray.add(privMenu);
                FormBean formBean = this.cap4FormCacheManager.getForm(formAppBO.getFormAppmainId());
                FormBindAuthBean formBindAuthBean = formBean.getBind().getFormBindAuthBean(String.valueOf(formAppBO.getId()));
                SimpleObjectBean add = formBindAuthBean.getAuthObjByName(FormBindAuthBean.AuthName.ADD.getKey());
                if (userAgent.equals(Constants.login_sign.phone.value()) && CAPFormUtil.getMobileAuth(add) && Strings.isNotBlank((String)String.valueOf(add.getPhoneValue())) || userAgent.equals(Constants.login_sign.pc.value()) && CAPFormUtil.getPcNewAuth(add) && Strings.isNotBlank((String)String.valueOf(add.getValue()))) {
                    HashMap<String, String> newUnFlowPrivMenu = new HashMap<String, String>();
                    newUnFlowPrivMenu.putAll(privMenu);
                    newUnFlowPrivMenu.put(MENU_TYPE, CAPBusinessEnum.DataSource.UNFLOW_CREATE.getKey());
                    shortCutArray.add(newUnFlowPrivMenu);
                }
            }
            if (Enums.SourceType.SOURCE_TYPE_QUERY.getKey() == formAppBO.getSourceType() && this.reportApi.checkAuth(Long.valueOf(Long.parseLong(formAppBO.getId())), Long.valueOf(AppContext.currentUserId()))) {
                privMenu.put(IS_USE_CUSTOM_TEMPLATE, this.capBusinessTemplateManager.isUseCustomTemplate(Long.parseLong(bizId), Long.parseLong(formAppBO.getId()), CAPBusinessEnum.TemplateType.TP_QUERY.getType(), userAgent) ? CAPBusinessEnum.TrueOrFalseEnum.TRUE.getKey() : CAPBusinessEnum.TrueOrFalseEnum.FALSE.getKey());
                privMenu.put(MENU_TYPE, CAPBusinessEnum.DataSource.QUERY_LIST.getKey());
                queryArray.add(privMenu);
            }
            if (Enums.SourceType.SOURCE_TYPE_REPORT.getKey() != formAppBO.getSourceType() || !this.reportApi.checkAuth(Long.valueOf(Long.parseLong(formAppBO.getId())), Long.valueOf(AppContext.currentUserId()))) continue;
            privMenu.put(IS_USE_CUSTOM_TEMPLATE, this.capBusinessTemplateManager.isUseCustomTemplate(Long.parseLong(bizId), Long.parseLong(formAppBO.getId()), CAPBusinessEnum.TemplateType.TP_CACL.getType(), userAgent) ? CAPBusinessEnum.TrueOrFalseEnum.TRUE.getKey() : CAPBusinessEnum.TrueOrFalseEnum.FALSE.getKey());
            privMenu.put(MENU_TYPE, CAPBusinessEnum.DataSource.CACL_LIST.getKey());
            caclArray.add(privMenu);
        }
        if (unflowArray.size() > 0) {
            this.addCategory(categoryArray, unflowArray, ResourceUtil.getString((String)"cap.template.business.menuColumn.unflowName"));
        }
        if (queryArray.size() > 0) {
            this.addCategory(categoryArray, queryArray, ResourceUtil.getString((String)"cap.template.business.menuColumn.queryName"));
        }
        if (caclArray.size() > 0) {
            this.addCategory(categoryArray, caclArray, ResourceUtil.getString((String)"cap.template.business.menuColumn.caclName"));
        }
        LOGGER.info((Object)("getMenusOfNotSetMenu " + bizId + " use " + (System.currentTimeMillis() - startTime)));
    }

    private void addCategory(List<Map<String, Object>> categoryArray, List<Map<String, Object>> categoryList, String categoryName) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put(MENU_NAME, categoryName);
        map.put(MENU_LIST, categoryList);
        map.put(MENU_ID, String.valueOf(UUIDLong.longUUID()));
        map.put(MENU_TYPE, CAPBusinessEnum.DataSource.CATEGORY.getKey());
        categoryArray.add(map);
    }

    private boolean getTemplateIds(List<FormAppBO> formList, String bizId, StringBuilder templateIdSb, List<Map<String, Object>> flowArray, Integer userAgent) {
        boolean hasApprovaerMenu = false;
        for (FormAppBO formAppBO : formList) {
            if (Enums.FormType.processesForm.getKey() != formAppBO.getSourceType()) continue;
            if (hasApprovaerMenu) {
                templateIdSb.append(formAppBO.getId()).append(",");
                continue;
            }
            HashMap<String, String> approvaerMenu = new HashMap<String, String>();
            approvaerMenu.put(MENU_NAME, ResourceUtil.getString((String)"cap.template.business.menuColumn.approverName"));
            approvaerMenu.put(APP_ID, bizId);
            approvaerMenu.put(MENU_ID, String.valueOf(UUIDLong.longUUID()));
            approvaerMenu.put(MENU_TYPE, CAPBusinessEnum.DataSource.FLOW_LIST.getKey());
            approvaerMenu.put(IS_USE_CUSTOM_TEMPLATE, this.capBusinessTemplateManager.isUseCustomTemplate(Long.parseLong(bizId), Long.parseLong(bizId), CAPBusinessEnum.TemplateType.TP_FLOW.getType(), userAgent) ? CAPBusinessEnum.TrueOrFalseEnum.TRUE.getKey() : CAPBusinessEnum.TrueOrFalseEnum.FALSE.getKey());
            flowArray.add(approvaerMenu);
            hasApprovaerMenu = true;
            templateIdSb.append(formAppBO.getId()).append(",");
        }
        return hasApprovaerMenu;
    }

    private void getFlowIndxs(List<Map<String, Object>> flowArray, String templateids, Map<String, Object> data) throws BusinessException {
        if (flowArray.isEmpty()) {
            data.put(LIST_PENDING_NUM, "0");
            data.put(LIST_SENT_NUM, "0");
        } else {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put(ColQueryCondition.templeteIds.name(), templateids);
            map.put(ColQueryCondition.currentUser.name(), String.valueOf(AppContext.currentUserId()));
            map.put(ColQueryCondition.state.name(), String.valueOf(StateEnum.col_pending.getKey()));
            int listPendingNum = this.collaborationApi.getColAffairsCountByCondition(map);
            data.put(LIST_PENDING_NUM, String.valueOf(listPendingNum));
            map.put(ColQueryCondition.state.name(), String.valueOf(StateEnum.col_sent.getKey()));
            int listSentNum = this.collaborationApi.getColAffairsCountByCondition(map);
            data.put(LIST_SENT_NUM, String.valueOf(listSentNum));
        }
    }

    @Override
    public String getClassId() {
        return String.valueOf(CAPBusinessEnum.ColumnType.MENU_COLUMN.getType());
    }

    public void setCapBusinessTemplateManager(CAPBusinessTemplateManager capBusinessTemplateManager) {
        this.capBusinessTemplateManager = capBusinessTemplateManager;
    }

    public void setBusinessManager4(BusinessManager businessManager4) {
        this.businessManager4 = businessManager4;
    }

    public void setTemplateManager(TemplateManager templateManager) {
        this.templateManager = templateManager;
    }

    public void setCap4FormCacheManager(CAP4FormCacheManager cap4FormCacheManager) {
        this.cap4FormCacheManager = cap4FormCacheManager;
    }

    public void setCollaborationApi(CollaborationApi collaborationApi) {
        this.collaborationApi = collaborationApi;
    }

    public void setCap4FormManager(CAP4FormManager cap4FormManager) {
        this.cap4FormManager = cap4FormManager;
    }

    public void setReportApi(ReportApi reportApi) {
        this.reportApi = reportApi;
    }

    public void setPortalApi(PortalApi portalApi) {
        this.portalApi = portalApi;
    }
}

