/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.cap4.template.manager.impl;

import com.seeyon.cap4.form.bean.FormBean;
import com.seeyon.cap4.form.bean.FormBindAuthBean;
import com.seeyon.cap4.form.modules.business.BizConfigBean;
import com.seeyon.cap4.form.modules.business.BusinessManager;
import com.seeyon.cap4.form.service.CAP4FormCacheManager;
import com.seeyon.cap4.form.service.CAP4FormManager;
import com.seeyon.cap4.form.util.Enums;
import com.seeyon.cap4.template.constant.CAPBusinessEnum;
import com.seeyon.cap4.template.manager.AbstractColumnElementDataManager;
import com.seeyon.cap4.template.manager.CAPBusinessTemplateManager;
import com.seeyon.cap4.template.manager.CAPBussinessMenuManager;
import com.seeyon.ctp.common.AppContext;
import com.seeyon.ctp.common.exceptions.BusinessException;
import com.seeyon.ctp.common.log.CtpLogFactory;
import com.seeyon.ctp.common.po.template.CtpTemplate;
import com.seeyon.ctp.common.template.manager.TemplateManager;
import com.seeyon.ctp.report.engine.api.manager.ReportApi;
import com.seeyon.ctp.util.Strings;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;

public class CAPBussinessMenuManagerImpl
extends AbstractColumnElementDataManager
implements CAPBussinessMenuManager {
    private static final Log LOGGER = CtpLogFactory.getLog(CAPBussinessMenuManagerImpl.class);
    private BusinessManager businessManager4;
    private TemplateManager templateManager;
    private CAPBusinessTemplateManager capBusinessTemplateManager;
    private CAP4FormManager cap4FormManager;
    private ReportApi reportApi;
    private CAP4FormCacheManager cap4FormCacheManager;
    private static final List<String> dataSourceList = new ArrayList<String>();

    @Override
    public Map<String, Object> getColumnElementData(Map<String, Object> params) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        String bussId = (String)params.get("bussId");
        String type = (String)params.get("type");
        if (Strings.isBlank((String)bussId)) {
            result.put("code", "1001");
            result.put("message", String.format("this param %s is null!", "bussId or type"));
            return result;
        }
        try {
            HashMap data = new HashMap();
            HashMap<String, Object> menu = new HashMap<String, Object>();
            String appId = (String)params.get("appId");
            if (Strings.isBlank((String)appId)) {
                BizConfigBean bizConfigBean = this.businessManager4.findBizConfigById(Long.valueOf(bussId));
                menu.put("menuName", bizConfigBean.getName());
                menu.put("appId", bussId);
                menu.put("type", type);
                menu.put("isUseCustomTemplate", this.capBusinessTemplateManager.isUseCustomTemplate(Long.valueOf(bussId), Long.valueOf(bussId), CAPBusinessEnum.TemplateType.TP_FLOW.getType()) ? CAPBusinessEnum.TrueOrFalseEnum.TRUE.getKey() : CAPBusinessEnum.TrueOrFalseEnum.FALSE.getKey());
            } else if (dataSourceList.contains(type)) {
                CtpTemplate ctpTemplate = this.templateManager.getCtpTemplate(Long.valueOf(appId));
                menu.put("menuName", ctpTemplate.getSubject());
                menu.put("appId", appId);
                menu.put("type", type);
                menu.put("isUseCustomTemplate", this.capBusinessTemplateManager.isUseCustomTemplate(Long.valueOf(bussId), Long.valueOf(appId), CAPBusinessEnum.TemplateType.TP_FLOW.getType()) ? CAPBusinessEnum.TrueOrFalseEnum.TRUE.getKey() : CAPBusinessEnum.TrueOrFalseEnum.FALSE.getKey());
            } else {
                String formId;
                if (CAPBusinessEnum.DataSource.LIST_CREATE.getKey().equals(type)) {
                    formId = (String)params.get("formId");
                    if (Strings.isBlank((String)formId)) {
                        result.put("code", "1001");
                        result.put("message", String.format("this param %s is null!", "formId"));
                        return result;
                    }
                    if (this.templateManager.isTemplateEnabled(Long.valueOf(appId), Long.valueOf(AppContext.currentUserId()))) {
                        CtpTemplate ctpTemplate = this.templateManager.getCtpTemplate(Long.valueOf(appId));
                        menu.put("menuName", ctpTemplate.getSubject());
                        menu.put("appId", appId);
                        menu.put("type", type);
                        menu.put("isUseCustomTemplate", this.capBusinessTemplateManager.isUseCustomTemplate(Long.valueOf(bussId), Long.valueOf(appId), CAPBusinessEnum.TemplateType.TP_FLOW.getType()) ? CAPBusinessEnum.TrueOrFalseEnum.TRUE.getKey() : CAPBusinessEnum.TrueOrFalseEnum.FALSE.getKey());
                    }
                }
                if (CAPBusinessEnum.DataSource.UNFLOW_CREATE.getKey().equals(type) || CAPBusinessEnum.DataSource.UNFLOW_LIST.getKey().equals(type)) {
                    formId = (String)params.get("formId");
                    if (Strings.isBlank((String)formId)) {
                        result.put("code", "1001");
                        result.put("message", String.format("this param %s is null!", "formId"));
                        return result;
                    }
                    if (this.cap4FormManager.checkRight(Enums.FormModuleAuthModuleType.BindAppForm, Long.parseLong(appId), AppContext.currentUserId(), Long.parseLong(formId))) {
                        FormBean formBean = this.cap4FormCacheManager.getForm(Long.parseLong(formId));
                        FormBindAuthBean formBindAuthBean = formBean.getBind().getFormBindAuthBean(appId);
                        menu.put("menuName", formBindAuthBean.getName());
                        menu.put("appId", appId);
                        menu.put("type", type);
                        menu.put("formId", formId);
                        menu.put("isUseCustomTemplate", this.capBusinessTemplateManager.isUseCustomTemplate(Long.parseLong(bussId), Long.parseLong(appId), CAPBusinessEnum.TemplateType.TP_UNFLOW.getType()) ? CAPBusinessEnum.TrueOrFalseEnum.TRUE.getKey() : CAPBusinessEnum.TrueOrFalseEnum.FALSE.getKey());
                    }
                }
                if ((CAPBusinessEnum.DataSource.QUERY_LIST.getKey().equals(type) || CAPBusinessEnum.DataSource.CACL_LIST.getKey().equals(type)) && this.reportApi.checkAuth(Long.valueOf(appId), Long.valueOf(AppContext.currentUserId()))) {
                    menu.put("menuName", params.get("name"));
                    menu.put("appId", appId);
                    menu.put("type", type);
                    menu.put("isUseCustomTemplate", this.capBusinessTemplateManager.isUseCustomTemplate(Long.valueOf(bussId), Long.valueOf(appId), CAPBusinessEnum.TemplateType.TP_QUERY.getType()) ? CAPBusinessEnum.TrueOrFalseEnum.TRUE.getKey() : CAPBusinessEnum.TrueOrFalseEnum.FALSE.getKey());
                }
                if (CAPBusinessEnum.DataSource.CACL_LIST.getKey().equals(type) && this.reportApi.checkAuth(Long.valueOf(appId), Long.valueOf(AppContext.currentUserId()))) {
                    menu.put("menuName", params.get("name"));
                    menu.put("appId", appId);
                    menu.put("type", type);
                    menu.put("isUseCustomTemplate", this.capBusinessTemplateManager.isUseCustomTemplate(Long.valueOf(bussId), Long.valueOf(appId), CAPBusinessEnum.TemplateType.TP_CACL.getType()) ? CAPBusinessEnum.TrueOrFalseEnum.TRUE.getKey() : CAPBusinessEnum.TrueOrFalseEnum.FALSE.getKey());
                }
            }
            ArrayList<HashMap<String, Object>> menuArray = new ArrayList<HashMap<String, Object>>();
            if (!menu.isEmpty()) {
                menuArray.add(menu);
            }
            data.put(CAPBusinessEnum.ColumnType.SHORT_CUT.getAlias(), menuArray);
            result.put("code", "1000");
            result.put("message", "the operation is success!!!");
            result.put("data", data);
        }
        catch (BusinessException e) {
            LOGGER.error((Object)("CAPBussinessMenuManagerImpl.BusinessException, params=" + params.toString()), (Throwable)e);
            result.put("code", "1002");
            result.put("message", String.format("%s option exception!", "CAPBussinessMenuManagerImpl.BusinessException"));
            return result;
        }
        return result;
    }

    @Override
    public String getClassId() {
        return String.valueOf(CAPBusinessEnum.ColumnType.SHORT_CUT.getType());
    }

    public void setBusinessManager4(BusinessManager businessManager4) {
        this.businessManager4 = businessManager4;
    }

    public void setTemplateManager(TemplateManager templateManager) {
        this.templateManager = templateManager;
    }

    public void setCapBusinessTemplateManager(CAPBusinessTemplateManager capBusinessTemplateManager) {
        this.capBusinessTemplateManager = capBusinessTemplateManager;
    }

    public void setCap4FormManager(CAP4FormManager cap4FormManager) {
        this.cap4FormManager = cap4FormManager;
    }

    public void setReportApi(ReportApi reportApi) {
        this.reportApi = reportApi;
    }

    public void setCap4FormCacheManager(CAP4FormCacheManager cap4FormCacheManager) {
        this.cap4FormCacheManager = cap4FormCacheManager;
    }

    static {
        dataSourceList.add(CAPBusinessEnum.DataSource.LIST_SENT.getKey());
        dataSourceList.add(CAPBusinessEnum.DataSource.LIST_WAIT_SEND.getKey());
        dataSourceList.add(CAPBusinessEnum.DataSource.LIST_DONE.getKey());
        dataSourceList.add(CAPBusinessEnum.DataSource.LIST_PENDING.getKey());
    }
}

