/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.cap4.template.manager.impl;

import com.seeyon.cap4.form.bean.FormBindAuthBean;
import com.seeyon.cap4.form.bean.FormFieldComEnum;
import com.seeyon.cap4.form.bean.FormFormulaBean;
import com.seeyon.cap4.form.bean.FormQueryWhereClause;
import com.seeyon.cap4.form.bean.FormTableBean;
import com.seeyon.cap4.form.bean.SimpleObjectBean;
import com.seeyon.cap4.form.modules.engin.formula.FormulaEnums;
import com.seeyon.cap4.form.util.Enums;
import com.seeyon.cap4.form.util.FormUtil;
import com.seeyon.cap4.template.bean.ConditionBean;
import com.seeyon.cap4.template.bean.FieldSqlBean;
import com.seeyon.cap4.template.condition.clause.AbstractConditionClause;
import com.seeyon.cap4.template.condition.clause.CheckBoxConditionClause;
import com.seeyon.cap4.template.condition.clause.LikeConditionClause;
import com.seeyon.cap4.template.condition.clause.SimpleConditionClause;
import com.seeyon.cap4.template.condition.clause.TableConstantConditionClause;
import com.seeyon.cap4.template.condition.clause.ValueNullConditionClause;
import com.seeyon.cap4.template.manager.CAPDataListSqlHelpManager;
import com.seeyon.cap4.template.manager.CAPSqlFieldManager;
import com.seeyon.ctp.common.AppContext;
import com.seeyon.ctp.common.SystemEnvironment;
import com.seeyon.ctp.common.exceptions.BusinessException;
import com.seeyon.ctp.common.log.CtpLogFactory;
import com.seeyon.ctp.form.bean.FormBean;
import com.seeyon.ctp.form.bean.FormFieldBean;
import com.seeyon.ctp.util.FlipInfo;
import com.seeyon.ctp.util.JDBCAgent;
import com.seeyon.ctp.util.Strings;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;

public class CAPDataListSqlHelpManagerImpl
implements CAPDataListSqlHelpManager {
    private static final Log LOGGER = CtpLogFactory.getLog(CAPDataListSqlHelpManagerImpl.class);
    private static final String NULLS_FIRST = " NULLS FIRST";
    private static final String NULLS_LAST = " NULLS LAST";
    private CAPSqlFieldManager sqlFieldDefaultManager = new CAPSqlFieldManager(){

        @Override
        public String getField(String tableName, String fieldName) {
            if (Strings.isBlank((String)tableName)) {
                return fieldName;
            }
            return fieldName.contains(".") ? fieldName : tableName + "." + fieldName;
        }
    };

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void selectDataList(FlipInfo flipInfo, String sql, List params) throws BusinessException, SQLException {
        long startTime;
        block5: {
            startTime = System.currentTimeMillis();
            LOGGER.info((Object)(startTime + " selectDataList sql\uff1a" + sql));
            LOGGER.info((Object)(startTime + " selectDataList \u53c2\u6570\uff1a" + params));
            JDBCAgent jdbc = null;
            try {
                jdbc = new JDBCAgent();
                if (CollectionUtils.isNotEmpty((Collection)params)) {
                    jdbc.findByPaging(sql, params, flipInfo);
                } else {
                    jdbc.findByPaging(sql, flipInfo);
                }
                if (jdbc == null) break block5;
            }
            catch (Throwable throwable) {
                if (jdbc != null) {
                    jdbc.close();
                }
                LOGGER.info((Object)(startTime + " selectDataList data size " + (flipInfo.getData() == null ? 0 : flipInfo.getData().size()) + ", use time " + (System.currentTimeMillis() - startTime) + " ms."));
                throw throwable;
            }
            jdbc.close();
        }
        LOGGER.info((Object)(startTime + " selectDataList data size " + (flipInfo.getData() == null ? 0 : flipInfo.getData().size()) + ", use time " + (System.currentTimeMillis() - startTime) + " ms."));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public List selectDataList(String sql, List params) throws BusinessException, SQLException {
        List resultList;
        long startTime;
        block5: {
            startTime = System.currentTimeMillis();
            LOGGER.info((Object)(startTime + " selectDataList sql\uff1a" + sql));
            LOGGER.info((Object)(startTime + " selectDataList \u53c2\u6570\uff1a" + params));
            JDBCAgent jdbc = null;
            resultList = null;
            try {
                jdbc = new JDBCAgent();
                if (CollectionUtils.isNotEmpty((Collection)params)) {
                    jdbc.execute(sql, params);
                } else {
                    jdbc.execute(sql);
                }
                resultList = jdbc.resultSetToList();
                if (jdbc == null) break block5;
            }
            catch (Throwable throwable) {
                if (jdbc != null) {
                    jdbc.close();
                }
                LOGGER.info((Object)(startTime + " selectDataList data size " + (resultList == null ? 0 : resultList.size()) + ", use time " + (System.currentTimeMillis() - startTime) + " ms."));
                throw throwable;
            }
            jdbc.close();
        }
        LOGGER.info((Object)(startTime + " selectDataList data size " + (resultList == null ? 0 : resultList.size()) + ", use time " + (System.currentTimeMillis() - startTime) + " ms."));
        return resultList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Integer selectDataCount(String sql, List params) throws BusinessException, SQLException {
        long startTime = System.currentTimeMillis();
        LOGGER.info((Object)(startTime + " selectDataCount sql\uff1a" + sql));
        LOGGER.info((Object)(startTime + " selectDataCount \u53c2\u6570\uff1a" + params));
        JDBCAgent jdbc = null;
        Integer count = 0;
        try {
            jdbc = new JDBCAgent();
            if (CollectionUtils.isNotEmpty((Collection)params)) {
                jdbc.execute(sql, params);
            } else {
                jdbc.execute(sql);
            }
            if (!jdbc.getQueryResult().next()) {
                LOGGER.error((Object)(startTime + " selectDataCount \u53c2\u6570\uff1acount\u6267\u884c\u5931\u8d25"));
            } else {
                count = jdbc.getQueryResult().getInt(1);
            }
        }
        finally {
            if (jdbc != null) {
                jdbc.close();
            }
            LOGGER.info((Object)(startTime + " selectDataCount data size " + count + ", use time " + (System.currentTimeMillis() - startTime) + " ms."));
        }
        return count;
    }

    @Override
    public FormQueryWhereClause getOperationRangeWhereClause(FormBindAuthBean bindAuthBean) {
        FormFormulaBean formulaBean = bindAuthBean.getFormFormulaBean();
        FormQueryWhereClause formulaWhereClause = null;
        if (formulaBean != null) {
            formulaWhereClause = formulaBean.getExecuteFormulaForWhereClauseSQL(null, true, true);
        }
        return formulaWhereClause;
    }

    private void appendWhereClause(StringBuilder sb, List<Object> queryParams, FormQueryWhereClause whereClause) {
        if (whereClause != null) {
            if (Strings.isNotBlank((String)whereClause.getAllSqlClause())) {
                sb.append(whereClause.getAllSqlClause());
            }
            if (CollectionUtils.isNotEmpty((Collection)whereClause.getQueryParams())) {
                queryParams.addAll(whereClause.getQueryParams());
            }
        }
    }

    private boolean isValidFormQueryWhereClause(FormQueryWhereClause whereClause) {
        return whereClause != null && Strings.isNotBlank((String)whereClause.getAllSqlClause());
    }

    @Override
    public FormQueryWhereClause getFormQueryWhereClauseByMap(List<Map<String, Object>> conditions, boolean needTableName) throws BusinessException {
        ArrayList<ConditionBean> conditionBeans = null;
        if (CollectionUtils.isNotEmpty(conditions)) {
            try {
                conditionBeans = new ArrayList<ConditionBean>();
                for (Map<String, Object> map : conditions) {
                    ConditionBean bean = new ConditionBean();
                    BeanUtils.populate((Object)bean, map);
                    conditionBeans.add(bean);
                }
            }
            catch (Exception e) {
                throw new BusinessException((Throwable)e);
            }
        }
        return this.getFormQueryWhereClauseByConditionBean(conditionBeans, needTableName);
    }

    private String getConditionNotEqual4ValueNotNull(ConditionBean conditionBean) {
        boolean appendNotEqualNull;
        StringBuilder sb = new StringBuilder();
        String fieldType = conditionBean.getFieldType();
        String fieldName = conditionBean.getTableNameAndFieldName();
        boolean bl = appendNotEqualNull = "<>".equals(conditionBean.getOperation()) || "not_like".equalsIgnoreCase(conditionBean.getOperation());
        if (appendNotEqualNull) {
            sb.append("(");
            if (Enums.FieldType.VARCHAR.getKey().equalsIgnoreCase(fieldType) || Enums.FieldType.LONGTEXT.getKey().equalsIgnoreCase(fieldType)) {
                sb.append("(").append(fieldName).append(" is null or ").append(fieldName).append(" = '' )");
            } else {
                sb.append(fieldName).append(" is null ");
            }
            sb.append(" or ");
        }
        return appendNotEqualNull ? sb.toString() : null;
    }

    @Override
    public FormQueryWhereClause getFormQueryWhereClauseByConditionBean(List<ConditionBean> conditions, boolean needTableName) throws BusinessException {
        if (CollectionUtils.isEmpty(conditions)) {
            return null;
        }
        Map conditionClauseMap = AppContext.getBeansOfType(AbstractConditionClause.class);
        ArrayList<ConditionContextClause> contextClauses = new ArrayList<ConditionContextClause>();
        for (ConditionBean conditionBean : conditions) {
            String inputType = conditionBean.getInputType();
            if ("0".equals(FormUtil.isNull2Str((Object)conditionBean.getFieldValue())) && FormFieldComEnum.SELECT.getKey().equalsIgnoreCase(inputType)) continue;
            ConditionContextClause contextClause = new ConditionContextClause();
            contextClauses.add(contextClause);
            contextClause.setConditionBean(conditionBean);
            if (FormFieldComEnum.CHECKBOX.getKey().equalsIgnoreCase(conditionBean.getInputType())) {
                contextClause.setConditionClause(this.getClauseBean(CheckBoxConditionClause.class, conditionClauseMap));
                continue;
            }
            if (Strings.isBlank((String)FormUtil.isNull2Str((Object)conditionBean.getFieldValue()))) {
                contextClause.setConditionClause(this.getClauseBean(ValueNullConditionClause.class, conditionClauseMap));
                continue;
            }
            contextClause.setConditionNotEqual4ValueNotNull(this.getConditionNotEqual4ValueNotNull(conditionBean));
            contextClause.setConditionClause(this.getFieldConditionClause(conditionBean, conditionClauseMap));
        }
        this.initConditionFormQueryWhereClause(contextClauses);
        int i = 0;
        int j = contextClauses.size();
        ArrayList<Object> queryParams = new ArrayList<Object>();
        StringBuilder sb = new StringBuilder();
        for (ConditionContextClause contextClause : contextClauses) {
            ++i;
            sb.append(FormUtil.isNull2Str((Object)contextClause.getConditionBean().getLeftChar())).append(" ");
            if (contextClause.getConditionNotEqual4ValueNotNull() != null) {
                sb.append(contextClause.getConditionNotEqual4ValueNotNull());
            }
            this.appendWhereClause(sb, queryParams, contextClause.getWhereClause());
            sb.append(FormUtil.isNull2Str((Object)contextClause.getConditionBean().getRightChar())).append(" ");
            if (contextClause.getConditionNotEqual4ValueNotNull() != null) {
                sb.append(")");
            }
            if (i >= j) continue;
            sb.append(contextClause.getConditionBean().getRowOperation()).append(" ");
        }
        FormQueryWhereClause whereClause = new FormQueryWhereClause();
        whereClause.setAllSqlClause(sb.toString());
        whereClause.setQueryParams(queryParams);
        return whereClause;
    }

    private AbstractConditionClause getClauseBean(Class<? extends AbstractConditionClause> clazz, Map<String, AbstractConditionClause> map) throws BusinessException {
        for (Map.Entry<String, AbstractConditionClause> entry : map.entrySet()) {
            if (!entry.getValue().getClass().getName().split("[$]")[0].equals(clazz.getName())) continue;
            return entry.getValue();
        }
        throw new BusinessException(clazz.getName() + " can't find implements!");
    }

    private AbstractConditionClause getFieldConditionClause(ConditionBean conditionBean, Map<String, AbstractConditionClause> conditionClauseMap) throws BusinessException {
        String inputType = conditionBean.getInputType();
        AbstractConditionClause resultClause = null;
        for (Map.Entry<String, AbstractConditionClause> entry : conditionClauseMap.entrySet()) {
            boolean isContain;
            AbstractConditionClause clause = entry.getValue();
            boolean bl = isContain = CollectionUtils.isNotEmpty(clause.supportInputType()) && clause.supportInputType().contains(inputType);
            if (FormulaEnums.ConditionSymbol.include.getKey().equals(conditionBean.getOperation())) {
                if (!isContain || !clause.supportInclude()) continue;
                resultClause = clause;
                break;
            }
            if (!isContain || clause.supportInclude()) continue;
            resultClause = clause;
            break;
        }
        if (resultClause == null) {
            if (Enums.MasterTableField.getEnumByKey((String)conditionBean.getFieldName()) != null) {
                resultClause = this.getClauseBean(TableConstantConditionClause.class, conditionClauseMap);
            } else {
                Class clazz = conditionBean.getOperation().contains(FormulaEnums.ConditionSymbol.like.getKey()) ? LikeConditionClause.class : SimpleConditionClause.class;
                resultClause = this.getClauseBean(clazz, conditionClauseMap);
            }
        }
        return resultClause;
    }

    private void initConditionFormQueryWhereClause(List<ConditionContextClause> contextClauses) throws BusinessException {
        Iterator<ConditionContextClause> iterator = contextClauses.iterator();
        while (iterator.hasNext()) {
            ConditionContextClause contextClause = iterator.next();
            FormQueryWhereClause whereClause = contextClause.getConditionClause().get(contextClause.conditionBean);
            if (this.isValidFormQueryWhereClause(whereClause)) {
                contextClause.setWhereClause(whereClause);
                continue;
            }
            iterator.remove();
        }
    }

    @Override
    public String getSQLWhere(List<FormQueryWhereClause> whereClauses, List<Object> queryParams) {
        String sb;
        StringBuilder whereSb = new StringBuilder();
        if (CollectionUtils.isNotEmpty(whereClauses)) {
            for (FormQueryWhereClause whereClause : whereClauses) {
                if (whereClause == null) continue;
                if (Strings.isNotBlank((String)whereClause.getAllSqlClause())) {
                    whereSb.append(" AND (").append(whereClause.getAllSqlClause()).append(") ");
                }
                if (!CollectionUtils.isNotEmpty((Collection)whereClause.getQueryParams())) continue;
                queryParams.addAll(whereClause.getQueryParams());
            }
        }
        sb = (sb = whereSb.toString()).indexOf(" AND") == 0 ? sb.substring(4, sb.length()) : sb;
        return sb;
    }

    @Override
    public String getSQLSort(FormTableBean masterTableBean, String sortFields, boolean isReverse) {
        String collation = isReverse ? " desc" : " asc";
        LinkedHashSet<String> sortSet = new LinkedHashSet<String>();
        if (Strings.isNotBlank((String)sortFields)) {
            sortSet.add(sortFields);
        }
        if (!sortFields.contains(Enums.MasterTableField.start_date.getKey())) {
            sortSet.add(masterTableBean.getTableName() + "." + Enums.MasterTableField.start_date.getKey() + collation);
        }
        sortSet.add(masterTableBean.getTableName() + "." + Enums.MasterTableField.id.getKey() + collation);
        return StringUtils.join(sortSet, (String)",");
    }

    @Override
    public String getSQLFrom(com.seeyon.cap4.form.bean.FormBean formBean, StringBuilder sql, String whereClause) {
        List allFields = formBean.getAllFieldBeans();
        StringBuilder from = new StringBuilder(" ");
        for (com.seeyon.cap4.form.bean.FormFieldBean fieldBean : allFields) {
            if (fieldBean.isConstantField() || fieldBean.isMasterField()) continue;
            if (from.indexOf(fieldBean.getOwnerTableName()) == -1 && sql.indexOf(fieldBean.getName()) != -1) {
                from.append(",").append(fieldBean.getOwnerTableName());
            }
            if (from.indexOf(fieldBean.getOwnerTableName()) != -1 || whereClause.indexOf(fieldBean.getName()) == -1) continue;
            from.append(",").append(fieldBean.getOwnerTableName());
        }
        return from.toString();
    }

    @Override
    public String getSQLJoin(com.seeyon.cap4.form.bean.FormBean formBean, String sql, String whereClause) {
        return this.getSQLJoin(formBean, sql, whereClause, "LEFT");
    }

    @Override
    public String getSQLJoin(com.seeyon.cap4.form.bean.FormBean formBean, String sql, String whereClause, String joinType) {
        List allFields = formBean.getAllFieldBeans();
        ArrayList<FieldSqlBean> fieldSqlBeans = new ArrayList<FieldSqlBean>();
        for (com.seeyon.cap4.form.bean.FormFieldBean fieldBean : allFields) {
            fieldSqlBeans.add(new FieldSqlBean(fieldBean));
        }
        return this.getSQLJoin(fieldSqlBeans, sql, whereClause, formBean.getMasterTableBean().getTableName(), joinType);
    }

    @Override
    public String getSQLJoin(FormBean formBean, String sql, String whereClause, String joinType) {
        List allFields = formBean.getAllFieldBeans();
        ArrayList<FieldSqlBean> fieldSqlBeans = new ArrayList<FieldSqlBean>();
        for (FormFieldBean fieldBean : allFields) {
            fieldSqlBeans.add(new FieldSqlBean(fieldBean));
        }
        return this.getSQLJoin(fieldSqlBeans, sql, whereClause, formBean.getMasterTableBean().getTableName(), joinType);
    }

    @Override
    public String getSQLJoin(List<FieldSqlBean> fieldSqlBeans, String sql, String whereClause, String masterTableName, String joinType) {
        StringBuilder joinBuilder = new StringBuilder(" ");
        for (FieldSqlBean fieldBean : fieldSqlBeans) {
            if (fieldBean.isConstantField() || fieldBean.isMasterField()) continue;
            if (joinBuilder.indexOf(fieldBean.getOwnerTableName()) == -1 && sql.contains(fieldBean.getFieldName())) {
                joinBuilder.append(" ").append(joinType).append(" JOIN ").append(fieldBean.getOwnerTableName());
                joinBuilder.append(" ON ").append(this.getSQLMasterEqualSub4Id(masterTableName, fieldBean.getOwnerTableName()));
            }
            if (joinBuilder.indexOf(fieldBean.getOwnerTableName()) != -1 || !whereClause.contains(fieldBean.getFieldName())) continue;
            joinBuilder.append(" ").append(joinType).append(" JOIN ").append(fieldBean.getOwnerTableName());
            joinBuilder.append(" ON ").append(this.getSQLMasterEqualSub4Id(masterTableName, fieldBean.getOwnerTableName()));
        }
        return joinBuilder.toString();
    }

    @Override
    public String getSQLMasterEqualSub4Id(String masterTableName, String subTableName) {
        StringBuilder builder = new StringBuilder();
        builder.append(" ").append(masterTableName).append(".").append(Enums.MasterTableField.id.getKey());
        builder.append("=").append(subTableName).append(".").append(Enums.SubTableField.formmain_id.getKey()).append(" ");
        return builder.toString();
    }

    @Override
    public Set<String> getSQLSelectFields(String tableName, List<SimpleObjectBean> showFields, Set<String> customShowFields) {
        Set<String> fieldSet = this.getSQLSelectFields(tableName, showFields, customShowFields, this.sqlFieldDefaultManager);
        fieldSet.add(tableName + "." + Enums.MasterTableField.id.getKey());
        fieldSet.add(tableName + "." + Enums.MasterTableField.state.getKey());
        fieldSet.add(tableName + "." + Enums.MasterTableField.start_date.getKey());
        return fieldSet;
    }

    @Override
    public Set<String> getSQLSelectFields(String tableName, List<SimpleObjectBean> showFields, Set<String> customShowFields, CAPSqlFieldManager capSqlFieldManager) {
        LinkedHashSet<String> fieldSet = new LinkedHashSet<String>();
        if (CollectionUtils.isNotEmpty(showFields)) {
            for (SimpleObjectBean showField : showFields) {
                fieldSet.add(capSqlFieldManager.getField(tableName, showField.getName()));
            }
        }
        if (Strings.isNotEmpty(customShowFields)) {
            for (String fieldName : customShowFields) {
                fieldSet.add(capSqlFieldManager.getField(tableName, fieldName));
            }
        }
        return fieldSet;
    }

    @Override
    public String getSQLOrder4CustomString(List<Map<String, Object>> sortList, String tableName, boolean reverse) {
        String tablePrefix;
        Set<String> sortSet = this.getSQLOrder4CustomSet(sortList, tableName, this.sqlFieldDefaultManager);
        String string = tablePrefix = Strings.isNotBlank((String)tableName) ? tableName + "." : "";
        if (sortSet.isEmpty() || !StringUtils.join(sortSet, (String)",").contains(Enums.MasterTableField.start_date.getKey())) {
            sortSet.add(tablePrefix + Enums.MasterTableField.start_date.getKey() + " asc");
        }
        sortSet.add(tablePrefix + Enums.MasterTableField.id.getKey() + " asc");
        return StringUtils.join(sortSet, (String)",");
    }

    @Override
    public Set<String> getSQLOrder4CustomSet(List<Map<String, Object>> sortList, String tableName, CAPSqlFieldManager capSqlFieldManager) {
        LinkedHashSet<String> sortSet = new LinkedHashSet<String>();
        if (Strings.isNotEmpty(sortList)) {
            Map<String, String> field2Order = this.getSQLOrder4CustomMap(sortList, tableName, this.sqlFieldDefaultManager);
            for (Map.Entry<String, String> entry : field2Order.entrySet()) {
                sortSet.add(entry.getKey() + " " + entry.getValue());
            }
        }
        return sortSet;
    }

    @Override
    public Set<String> getSQLOrder4CustomSetByMap(Map<String, String> field2Order) {
        LinkedHashSet<String> sortSet = new LinkedHashSet<String>();
        if (field2Order != null) {
            for (Map.Entry<String, String> entry : field2Order.entrySet()) {
                sortSet.add(entry.getKey() + " " + entry.getValue());
            }
        }
        return sortSet;
    }

    @Override
    public Map<String, String> getSQLOrder4CustomMap(List<Map<String, Object>> sortList, String tableName, CAPSqlFieldManager capSqlFieldManager) {
        LinkedHashMap<String, String> field2Order = new LinkedHashMap<String, String>();
        if (Strings.isNotEmpty(sortList)) {
            boolean orderByHasNull = this.orderByHasNull();
            for (Map<String, Object> map : sortList) {
                String orderType = map.get("orderType").toString();
                String fieldName = String.valueOf(map.get("fieldName"));
                String key = capSqlFieldManager.getField(tableName, fieldName);
                StringBuilder sb = new StringBuilder();
                sb.append(orderType);
                if (orderByHasNull) {
                    if ("asc".equalsIgnoreCase(orderType)) {
                        sb.append(NULLS_FIRST);
                    } else {
                        sb.append(NULLS_LAST);
                    }
                }
                field2Order.put(key, sb.toString());
            }
        }
        return field2Order;
    }

    private boolean orderByHasNull() {
        boolean result = false;
        String dbType = SystemEnvironment.getDatabaseType();
        if ("dm dbms".equals(dbType) || "Oracle".equalsIgnoreCase(dbType) || "PostgreSQL".equalsIgnoreCase(dbType)) {
            result = true;
        }
        return result;
    }

    private class ConditionContextClause {
        private AbstractConditionClause conditionClause;
        private FormQueryWhereClause whereClause;
        private ConditionBean conditionBean;
        private String conditionNotEqual4ValueNotNull;

        private ConditionContextClause() {
        }

        public AbstractConditionClause getConditionClause() {
            return this.conditionClause;
        }

        public void setConditionClause(AbstractConditionClause conditionClause) {
            this.conditionClause = conditionClause;
        }

        public FormQueryWhereClause getWhereClause() {
            return this.whereClause;
        }

        public void setWhereClause(FormQueryWhereClause whereClause) {
            this.whereClause = whereClause;
        }

        public ConditionBean getConditionBean() {
            return this.conditionBean;
        }

        public void setConditionBean(ConditionBean conditionBean) {
            this.conditionBean = conditionBean;
        }

        public String getConditionNotEqual4ValueNotNull() {
            return this.conditionNotEqual4ValueNotNull;
        }

        public void setConditionNotEqual4ValueNotNull(String conditionNotEqual4ValueNotNull) {
            this.conditionNotEqual4ValueNotNull = conditionNotEqual4ValueNotNull;
        }
    }
}

