/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.cap4.template.manager.impl;

import com.seeyon.apps.cloudapp.api.MallApi;
import com.seeyon.apps.cloudapp.constant.MallEnum;
import com.seeyon.apps.cloudapp.po.CloudAppDatas;
import com.seeyon.cap4.template.bean.DownloadParamBean;
import com.seeyon.cap4.template.bo.CAPBusinessTemplateBO;
import com.seeyon.cap4.template.constant.CAPBusinessConstant;
import com.seeyon.cap4.template.constant.CAPBusinessEnum;
import com.seeyon.cap4.template.manager.CAPBusinessTemplateManager;
import com.seeyon.cap4.template.manager.CAPDownloadBaseManager;
import com.seeyon.cap4.template.manager.CAPDownloadManager;
import com.seeyon.cap4.template.manager.CAPHttpRequestManager;
import com.seeyon.cap4.template.util.CAPBusinessTemplateUtil;
import com.seeyon.cap4.template.util.CAPBusinessUtil;
import com.seeyon.cap4.template.util.CAPParamUtil;
import com.seeyon.cap4.template.util.mall.Authcode;
import com.seeyon.cap4.template.util.mall.MallUtil;
import com.seeyon.cap4.template.vo.CAPDownloadUrlVO;
import com.seeyon.cap4.validity.ValidityUtil;
import com.seeyon.ctp.common.AppContext;
import com.seeyon.ctp.common.exceptions.BusinessException;
import com.seeyon.ctp.common.i18n.ResourceUtil;
import com.seeyon.ctp.common.log.CtpLogFactory;
import com.seeyon.ctp.organization.bo.V3xOrgDepartment;
import com.seeyon.ctp.organization.bo.V3xOrgMember;
import com.seeyon.ctp.organization.bo.V3xOrgPost;
import com.seeyon.ctp.organization.manager.OrgManager;
import com.seeyon.ctp.util.UUIDLong;
import com.seeyon.ctp.util.ZipUtil;
import com.seeyon.ctp.util.json.JSONUtil;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;

public class CAPDownloadBaseManagerImpl
implements CAPDownloadBaseManager {
    private static final Log LOGGER = CtpLogFactory.getLog(CAPDownloadBaseManagerImpl.class);
    private CAPBusinessTemplateManager capBusinessTemplateManager;
    private CAPHttpRequestManager capHttpRequestManager;
    private OrgManager orgManager;
    private MallApi mallApi;
    private static final String PARAM_URL = "url";
    private static final String PARAM_PLATFORM = "platform";
    private static final String CODE_PARAMS_ERROR = "1001";
    private static final String CODE_DOWNLOAD_ERROR = "1002";
    private static final String CODE_UNZIP_ERROR = "1003";
    private static final String CODE_REQUEST_ERROR = "1004";
    private static final String CODE_METHOD_ERROR = "1005";
    private static final String MESSAGE2 = "cap.template.message.paramNull";
    private static final String MESSAGE10 = "cap.template.design.download.implError";
    private static final String KEY_ACCESS_TOKEN = "access_token";
    private static final String KEY_MEMBER_INFO = "memberInfo";

    @Override
    public Map<String, Object> download(DownloadParamBean bean) throws BusinessException {
        if (bean == null || bean.getDownloadZipType() == null) {
            throw this.businessException(CODE_PARAMS_ERROR, String.format(ResourceUtil.getString((String)MESSAGE2), "param"));
        }
        Map<String, Object> result = null;
        Map map = AppContext.getBeansOfType(CAPDownloadManager.class);
        for (Map.Entry entry : map.entrySet()) {
            if (!bean.getDownloadZipType().equals(((CAPDownloadManager)entry.getValue()).getType())) continue;
            result = ((CAPDownloadManager)entry.getValue()).download(bean);
            break;
        }
        if (result == null) {
            throw this.businessException(CODE_METHOD_ERROR, ResourceUtil.getString((String)MESSAGE10));
        }
        return result;
    }

    @Override
    public CAPDownloadUrlVO getDownloadUrlVO(Long goodId) throws BusinessException {
        if (goodId == null || goodId <= 0L) {
            throw this.businessException(CODE_PARAMS_ERROR, String.format(ResourceUtil.getString((String)MESSAGE2), "goodId"));
        }
        CloudAppDatas ctpCloudAppData = this.mallApi.getBindMallUserData(Long.valueOf(AppContext.currentUserId()));
        Long userId = AppContext.currentUserId();
        HashMap<String, Object> dataMap = new HashMap<String, Object>();
        if (ctpCloudAppData != null) {
            dataMap.put(KEY_ACCESS_TOKEN, ctpCloudAppData.getAccessToken());
        }
        try {
            dataMap.put(KEY_MEMBER_INFO, Authcode.encode(URLEncoder.encode(JSONUtil.toJSONString(this.getMemberInfo(userId)), "UTF-8")));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        CAPDownloadUrlVO vo = this.getFreeDownloadInfo(goodId, dataMap);
        if (vo == null) {
            if (ctpCloudAppData == null) {
                throw this.businessException("1101", "need bind mall user");
            }
            Map<String, Object> parameterJson = MallUtil.getMallCommonParams(MallEnum.MallAction.DOWNLOAD, dataMap);
            Map httpResult = this.capHttpRequestManager.postByFormPart(MallUtil.getRestApiUrl(MallEnum.RestApi.MALL_INDEX), parameterJson, Map.class);
            if (MallUtil.isRequestSuccess(httpResult)) {
                vo = new CAPDownloadUrlVO();
                vo.setGoodId(goodId);
                vo.setUrl(CAPParamUtil.getString((Map)httpResult, (String)PARAM_URL));
                vo.setClient(CAPParamUtil.getString((Map)httpResult, (String)PARAM_PLATFORM));
                vo.setGoodName(CAPParamUtil.getString((Map)httpResult, (String)"goodsName"));
            } else {
                String message = MallUtil.getMallErrorMessage(httpResult);
                LOGGER.error((Object)("method getDownloadUrl is error AND param goodId is " + goodId + " , return message is " + message));
                String mallResult = MallUtil.getRequestMallResult(httpResult);
                if ("-5".equals(mallResult)) {
                    throw this.businessException("1102", this.getMallGoodUrl(goodId, ctpCloudAppData));
                }
                throw this.businessException(CODE_REQUEST_ERROR, String.format(ResourceUtil.getString((String)"cap.template.message.methodError"), "getDownloadUrl") + message);
            }
        }
        return vo;
    }

    private BusinessException businessException(String code, String message) {
        BusinessException exception = new BusinessException(message);
        exception.setCode(code);
        return exception;
    }

    @Override
    public CAPDownloadUrlVO getFreeDownloadInfo(Long goodId, Map<String, Object> dataMap) {
        if (dataMap == null) {
            dataMap = new HashMap<String, Object>();
        }
        dataMap.put("goodsId", String.valueOf(goodId));
        dataMap.put("corpId", ValidityUtil.getMplusCorpId());
        Map<String, Object> parameterMap = MallUtil.getMallCommonParams(MallEnum.MallAction.IS_FREE, dataMap);
        Map httpResult = this.capHttpRequestManager.postByFormPart(MallUtil.getRestApiUrl(MallEnum.RestApi.MALL_INDEX), parameterMap, Map.class);
        CAPDownloadUrlVO vo = null;
        if (MallUtil.isRequestSuccess(httpResult) && "1".equals(CAPParamUtil.getString((Map)httpResult, (String)"isFree"))) {
            vo = new CAPDownloadUrlVO();
            vo.setUrl(CAPParamUtil.getString((Map)httpResult, (String)PARAM_URL));
            vo.setClient(CAPParamUtil.getString((Map)httpResult, (String)PARAM_PLATFORM));
            vo.setGoodName(CAPParamUtil.getString((Map)httpResult, (String)"goodsName"));
            vo.setGoodId(goodId);
        }
        LOGGER.info((Object)("getFreeDownloadInfo result is " + httpResult.toString()));
        return vo;
    }

    @Override
    public Map<String, CAPDownloadUrlVO> getFreeDownloadInfo(Map<String, Object> dataMap) {
        HashMap<String, CAPDownloadUrlVO> result = new HashMap<String, CAPDownloadUrlVO>();
        if (dataMap == null) {
            dataMap = new HashMap<String, Object>();
        }
        if (dataMap.containsKey("goodsKeys") && dataMap.get("goodsKeys") instanceof List) {
            List goodsKeys = (List)dataMap.get("goodsKeys");
            for (String goodsKey : goodsKeys) {
                HashMap<String, Object> dataMapIn = new HashMap<String, Object>();
                dataMapIn.put("goodsKey", goodsKey);
                dataMapIn.put("corpId", ValidityUtil.getMplusCorpId());
                Map<String, Object> parameterMap = MallUtil.getMallCommonParams(MallEnum.MallAction.IS_FREE, dataMapIn);
                Map httpResult = this.capHttpRequestManager.postByFormPart(MallUtil.getRestApiUrl(MallEnum.RestApi.MALL_INDEX), parameterMap, Map.class);
                if (!MallUtil.isRequestSuccess(httpResult) && (MallUtil.getRequestMallResult(httpResult) == null || !"-5".equals(MallUtil.getRequestMallResult(httpResult).toString()))) continue;
                CAPDownloadUrlVO vo = new CAPDownloadUrlVO();
                vo.setUrl(CAPParamUtil.getString((Map)httpResult, (String)PARAM_URL));
                vo.setClient(CAPParamUtil.getString((Map)httpResult, (String)PARAM_PLATFORM));
                vo.setGoodName(CAPParamUtil.getString((Map)httpResult, (String)"goodsName"));
                vo.setInfoUrl(CAPParamUtil.getString((Map)httpResult, (String)"infoUrl"));
                vo.setFree(CAPParamUtil.getBoolean((Map)httpResult, (String)"isFree"));
                vo.setGoodId(CAPParamUtil.getLong((Map)httpResult, (String)"goodsId"));
                vo.setGoodKey(goodsKey);
                result.put(goodsKey, vo);
            }
        }
        return result;
    }

    @Override
    public File downloadMallFile(String url) throws BusinessException {
        String zipFileName = CAPBusinessTemplateUtil.getTemplateTempFolder() + File.separator + String.valueOf(UUIDLong.longUUID()) + ".zip";
        File zipFile = new File(zipFileName);
        boolean downResult = this.capHttpRequestManager.download(url, zipFile);
        if (!downResult) {
            throw this.businessException(CODE_DOWNLOAD_ERROR, "\u4e0b\u8f7d\u5931\u8d25\uff01\u8bf7\u68c0\u67e5\u7f51\u7edc\u8bbe\u7f6e");
        }
        return zipFile;
    }

    @Override
    public boolean checkDownloadFolder(String unZipedFolder, int zipType) {
        String checkFile;
        File file;
        boolean checkResult = false;
        CAPBusinessTemplateUtil.clearMacOSFile(unZipedFolder);
        if (zipType == CAPBusinessEnum.DownloadZipType.TEMPLATE.getType()) {
            String singleTemplate = unZipedFolder + File.separator + CAPBusinessConstant.DIST_STATIC_CONFIG_JSON;
            File singleTemplateFile = new File(singleTemplate);
            if (singleTemplateFile.exists()) {
                return true;
            }
            File fileTempFolder = new File(unZipedFolder);
            String[] fileTempList = fileTempFolder.list();
            if (fileTempList.length == 0) {
                return false;
            }
            String checkFile2 = unZipedFolder + File.separator + fileTempList[0] + File.separator + CAPBusinessConstant.DIST_STATIC_CONFIG_JSON;
            File file2 = new File(checkFile2);
            if (file2.exists()) {
                return true;
            }
            if (fileTempList.length > 1 && (file2 = new File(checkFile2 = unZipedFolder + File.separator + fileTempList[1] + File.separator + CAPBusinessConstant.DIST_STATIC_CONFIG_JSON)).exists()) {
                return true;
            }
        } else if (zipType == CAPBusinessEnum.DownloadZipType.COLUMN.getType() && (file = new File(checkFile = unZipedFolder + File.separator + "info" + File.separator + "config.json")).exists()) {
            checkResult = true;
        }
        return checkResult;
    }

    @Override
    public String unzipDownloadFile(File zipFile) throws BusinessException {
        String savePath = CAPBusinessTemplateUtil.getTemplateTempFolder();
        String fileBaseName = String.valueOf(UUIDLong.longUUID());
        String unzipToFolder = savePath + File.separator + fileBaseName;
        try {
            ZipUtil.unzip((File)zipFile, (File)new File(unzipToFolder));
        }
        catch (IOException e) {
            LOGGER.error((Object)("method unzipDownloadFile is unzip exception  zip is " + zipFile.getName()), (Throwable)e);
            throw this.businessException(CODE_UNZIP_ERROR, ResourceUtil.getString((String)"cap.template.message.unzip.error"));
        }
        return unzipToFolder;
    }

    @Override
    public Map<String, Object> getMemberInfo(Long userId) {
        HashMap<String, Object> memberObject = new HashMap<String, Object>();
        try {
            V3xOrgPost post;
            V3xOrgMember v3xOrgMember = this.orgManager.getMemberById(userId);
            memberObject.put("memberId", String.valueOf(userId));
            V3xOrgDepartment department = this.orgManager.getDepartmentById(v3xOrgMember.getOrgDepartmentId());
            if (department != null) {
                memberObject.put("departName", department.getName());
                memberObject.put("departId", String.valueOf(v3xOrgMember.getOrgDepartmentId()));
            }
            if ((post = this.orgManager.getPostById(v3xOrgMember.getOrgPostId())) != null) {
                memberObject.put("postName", post.getName());
            }
            memberObject.put("postID", String.valueOf(v3xOrgMember.getOrgPostId()));
            memberObject.put("telNum", v3xOrgMember.getTelNumber());
            memberObject.put("orgName", this.orgManager.getUnitById(v3xOrgMember.getOrgAccountId()).getName());
            memberObject.put("orgId", String.valueOf(v3xOrgMember.getOrgAccountId()));
            memberObject.put("memberName", v3xOrgMember.getName());
            memberObject.put("accountName", v3xOrgMember.getLoginName());
            memberObject.put("dogNo", CAPBusinessUtil.getDogNo());
        }
        catch (BusinessException e) {
            LOGGER.error((Object)("method getMemberInfo is get member error AND userId is " + userId), (Throwable)e);
        }
        return memberObject;
    }

    @Override
    public String getMallGoodUrl(Long goodId, CloudAppDatas ctpCloudAppData) {
        String url = MallUtil.isNewMall() ? MallUtil.CLOUD_MALL_URL + String.format(MallEnum.MallAction.NEW_DETAIL.action, goodId) : MallUtil.CLOUD_MALL_URL + String.format(MallEnum.MallAction.OLD_DETAIL.action, goodId);
        CloudAppDatas cloudAppDatas = ctpCloudAppData = ctpCloudAppData == null ? this.mallApi.getBindMallUserData(Long.valueOf(AppContext.currentUserId())) : ctpCloudAppData;
        if (ctpCloudAppData != null) {
            StringBuilder homeUrl = new StringBuilder(MallUtil.CLOUD_APP_URL);
            homeUrl.append("/portal.php?m=user&a=loginToken&access_token=");
            homeUrl.append(ctpCloudAppData.getAccessToken());
            homeUrl.append("&back_url=");
            homeUrl.append(URLEncoder.encode(url));
            return homeUrl.toString();
        }
        return url;
    }

    @Override
    public Map<String, Object> reportTemplateSaveAsNew(Long bizId, Long oldDataId, Long newDataId, int templateType) {
        HashMap<String, Object> map = new HashMap<String, Object>(2);
        CAPBusinessTemplateBO pcBO = this.capBusinessTemplateManager.getCustomTemplateBO(bizId, oldDataId, templateType, CAPBusinessEnum.Platform.PC.getType());
        CAPBusinessTemplateBO mobileBo = this.capBusinessTemplateManager.getCustomTemplateBO(bizId, oldDataId, templateType, CAPBusinessEnum.Platform.MOBILE.getType());
        if (pcBO != null) {
            map.put("pc", this.doReportTemplateSaveAsNew(bizId, Long.valueOf(pcBO.getId()), newDataId));
        }
        if (mobileBo != null) {
            map.put("mobile", this.doReportTemplateSaveAsNew(bizId, Long.valueOf(mobileBo.getId()), newDataId));
        }
        return map;
    }

    private Map<String, Object> doReportTemplateSaveAsNew(Long bizId, Long oldTemplateId, Long newDataId) {
        DownloadParamBean vo = new DownloadParamBean();
        vo.setDownloadZipType(CAPBusinessEnum.DownloadZipType.TEMPLATE.getType());
        vo.setDownloadType(3);
        vo.setTemplateId(oldTemplateId);
        vo.setNewDataId(newDataId);
        vo.setEggId(bizId);
        HashMap<String, Object> result = new HashMap<String, String>();
        try {
            result = this.download(vo);
        }
        catch (BusinessException e) {
            result.put("code", e.getCode());
            result.put("message", e.getMessage());
        }
        return result;
    }

    public void setMallApi(MallApi mallApi) {
        this.mallApi = mallApi;
    }

    public void setOrgManager(OrgManager orgManager) {
        this.orgManager = orgManager;
    }

    public void setCapBusinessTemplateManager(CAPBusinessTemplateManager capBusinessTemplateManager) {
        this.capBusinessTemplateManager = capBusinessTemplateManager;
    }

    public void setCapHttpRequestManager(CAPHttpRequestManager capHttpRequestManager) {
        this.capHttpRequestManager = capHttpRequestManager;
    }
}

