/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.cap4.template.manager.impl;

import com.seeyon.cap4.template.bean.DownloadParamBean;
import com.seeyon.cap4.template.bo.CAPBusinessColumnBO;
import com.seeyon.cap4.template.bo.CAPBusinessElementBO;
import com.seeyon.cap4.template.bo.CAPBusinessTemplateBO;
import com.seeyon.cap4.template.constant.CAPBusinessEnum;
import com.seeyon.cap4.template.manager.CAPBusinessColumnManager;
import com.seeyon.cap4.template.manager.CAPBusinessElementManager;
import com.seeyon.cap4.template.manager.CAPBusinessManager;
import com.seeyon.cap4.template.manager.CAPBusinessTemplate4EditManager;
import com.seeyon.cap4.template.manager.impl.CAPDownloadAbstractManager;
import com.seeyon.cap4.template.util.CAPBusinessTemplateUtil;
import com.seeyon.cap4.template.util.CAPBusinessUtil;
import com.seeyon.cap4.template.util.FileUtil;
import com.seeyon.cap4.template.vo.CAPDownloadUrlVO;
import com.seeyon.cap4.template.vo.config.ConfigColumnVO;
import com.seeyon.cap4.template.vo.config.ConfigElementVO;
import com.seeyon.cap4.template.vo.config.ConfigTemplateVO;
import com.seeyon.ctp.common.AppContext;
import com.seeyon.ctp.common.authenticate.domain.User;
import com.seeyon.ctp.common.exceptions.BusinessException;
import com.seeyon.ctp.common.i18n.ResourceUtil;
import com.seeyon.ctp.common.log.CtpLogFactory;
import com.seeyon.ctp.util.DateUtil;
import com.seeyon.ctp.util.Strings;
import com.seeyon.ctp.util.UUIDLong;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;

public class CAPDownloadManager4Column
extends CAPDownloadAbstractManager {
    private static final Log LOGGER = CtpLogFactory.getLog(CAPDownloadManager4Column.class);
    private CAPBusinessManager capBusinessManager;
    private CAPBusinessColumnManager capBusinessColumnManager;
    private CAPBusinessElementManager capBusinessElementManager;
    private CAPBusinessTemplate4EditManager capBusinessTemplate4EditManager;
    private static final String MESSAGE5 = "cap.template.design.edit.columnMissing";

    @Override
    public Map<String, Object> download(DownloadParamBean vo) throws BusinessException {
        CAPBusinessTemplateBO capBusinessTemplateBO;
        long startTime = System.currentTimeMillis();
        if (vo.getTemplateId() == null || vo.getColumnId() == null) {
            throw this.businessException("1001", String.format(ResourceUtil.getString((String)"cap.template.message.paramNull"), "templateId  or columnId"));
        }
        if (vo.getDownloadType() == 2) {
            if (vo.getGoodId() == null || vo.getGoodId() <= 0L) {
                throw this.businessException("1001", String.format(ResourceUtil.getString((String)"cap.template.message.paramNull"), " columnId"));
            }
        } else if (vo.getDownloadType() == 4 && (vo.getFileId() == null || Long.valueOf(0L).equals(vo.getFileId()))) {
            throw this.businessException("1001", String.format(ResourceUtil.getString((String)"cap.template.message.paramNull"), "fileId"));
        }
        if ((capBusinessTemplateBO = this.capBusinessTemplateManager.getCAPBusinessTemplateBOById(vo.getTemplateId())) == null) {
            throw this.businessException("1007", ResourceUtil.getString((String)"cap.template.design.download.template.missing"));
        }
        if (!this.capBusinessManager.checkBizOwnerAuth4Template(Long.valueOf(capBusinessTemplateBO.getEggId()))) {
            throw this.businessException("1201", "this user is no auth");
        }
        CAPBusinessColumnBO oldColumnBO = this.capBusinessTemplate4EditManager.getCacheEditableCAPBusinessColumnBO(vo.getTemplateId(), vo.getColumnId());
        if (oldColumnBO == null) {
            try {
                oldColumnBO = this.capBusinessTemplate4EditManager.cloneCAPBusinessColumnBOWithElementBOs(this.capBusinessColumnManager.getCAPBusinessColumnBOFromCacheById(vo.getTemplateId(), vo.getColumnId()));
            }
            catch (CloneNotSupportedException e) {
                throw this.businessException("1005", e.getMessage());
            }
        }
        if (oldColumnBO == null) {
            throw this.businessException("1007", ResourceUtil.getString((String)MESSAGE5));
        }
        Map<Object, Object> result = new HashMap();
        switch (vo.getDownloadType()) {
            case 2: {
                CAPDownloadUrlVO capDownloadUrlVO = this.capDownloadBaseManager.getDownloadUrlVO(vo.getGoodId());
                File downloadFile = this.capDownloadBaseManager.downloadMallFile(capDownloadUrlVO.getUrl());
                result = this.analysis(downloadFile, vo, capBusinessTemplateBO, oldColumnBO, capDownloadUrlVO);
                break;
            }
            case 4: {
                File importFile = this.fileManager.getFile(vo.getFileId(), DateUtil.currentDate());
                result = this.analysis(importFile, vo, capBusinessTemplateBO, oldColumnBO, null);
                break;
            }
        }
        LOGGER.info((Object)("download column use time " + (System.currentTimeMillis() - startTime) + " ms , params " + vo.toString()));
        return result;
    }

    private Map<String, Object> analysis(File downloadFile, DownloadParamBean vo, CAPBusinessTemplateBO capBusinessTemplateBO, CAPBusinessColumnBO oldColumnBO, CAPDownloadUrlVO capDownloadUrlVO) throws BusinessException {
        String unzipToFolder = this.capDownloadBaseManager.unzipDownloadFile(downloadFile);
        boolean checkFolder = this.capDownloadBaseManager.checkDownloadFolder(unzipToFolder, vo.getDownloadZipType());
        if (!checkFolder) {
            LOGGER.error((Object)("method download column is dir error , unzipToFolder is " + unzipToFolder));
            throw this.businessException("1005", ResourceUtil.getString((String)"cap.template.design.download.error"));
        }
        ConfigColumnVO configColumnVO = this.analysisConfigJSON(unzipToFolder);
        CAPBusinessColumnBO capBusinessColumnBO = this.analysisZipColumn(capDownloadUrlVO, configColumnVO, unzipToFolder, capBusinessTemplateBO, oldColumnBO);
        this.deleteFileAfterDownloaded(downloadFile, unzipToFolder);
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("data", capBusinessColumnBO.exportToMapForDesign());
        result.put("columnConfig", configColumnVO.exportToMap());
        return result;
    }

    private CAPBusinessColumnBO analysisZipColumn(CAPDownloadUrlVO downloadUrlVO, ConfigColumnVO downloadColumnVO, String srcFolder, CAPBusinessTemplateBO capBusinessTemplateBO, CAPBusinessColumnBO oldCapBusinessColumnBO) throws BusinessException {
        List<CAPBusinessElementBO> oldCapBusinessElementBOS;
        User user = AppContext.getCurrentUser();
        Long templateId = Long.valueOf(capBusinessTemplateBO.getId());
        ConfigTemplateVO configTemplateVO = this.capBusinessTemplate4EditManager.getCacheEditableTemplateConfigJSON(templateId);
        if (downloadColumnVO == null || configTemplateVO == null) {
            String message = " downloadColumnVO " + (downloadColumnVO == null) + " , configTemplateVO " + (configTemplateVO == null);
            LOGGER.error((Object)("method analysisZipColumn" + message));
            throw this.businessException("1005", String.format(ResourceUtil.getString((String)"cap.template.message.methodError"), "analysisZipColumn") + message);
        }
        if (oldCapBusinessColumnBO.getCapBusinessElementBOs() == null) {
            oldCapBusinessElementBOS = this.capBusinessElementManager.getCAPBusinessElementBOsByColumnId(Long.valueOf(oldCapBusinessColumnBO.getId()));
            oldCapBusinessColumnBO.setCapBusinessElementBOs(oldCapBusinessElementBOS);
        } else {
            oldCapBusinessElementBOS = oldCapBusinessColumnBO.getCapBusinessElementBOs();
        }
        Map<String, Object> historyElementDataSource = this.capBusinessTemplate4EditManager.getCacheEditableColumnPreDataSource(templateId, Long.valueOf(oldCapBusinessColumnBO.getId()));
        if (Strings.isNotEmpty(oldCapBusinessElementBOS)) {
            if (historyElementDataSource == null) {
                historyElementDataSource = new HashMap<String, Object>();
            }
            for (CAPBusinessElementBO capBusinessElementBO : oldCapBusinessElementBOS) {
                String key;
                if (capBusinessElementBO.getExtendInfo() == null || Strings.isBlank((String)(key = (String)capBusinessElementBO.getExtendInfo().get("dynamicKey"))) || capBusinessElementBO.getDataInfo() == null) continue;
                Map<String, Object> dataMap = capBusinessElementBO.getDataInfo();
                if (dataMap.get("dataInfoTime") == null) {
                    dataMap.put("dataInfoTime", capBusinessElementBO.getCreateDate());
                    dataMap.put("dataInfoType", capBusinessElementBO.getElementType());
                    dataMap.put("sort", capBusinessElementBO.getSort());
                }
                historyElementDataSource.put(key, dataMap);
            }
        }
        CAPBusinessColumnBO capBusinessColumnBO = this.capBusinessColumnManager.analysisDownloadColumn(downloadColumnVO, String.valueOf(downloadUrlVO.getGoodId()), downloadUrlVO.getGoodName(), String.valueOf(templateId), String.valueOf(user.getId()));
        List<CAPBusinessElementBO> capBusinessElementBOS = this.capBusinessElementManager.analysisDownloadElement(downloadColumnVO.getElements(), capBusinessColumnBO, historyElementDataSource);
        if (capBusinessElementBOS != null) {
            capBusinessColumnBO.setCapBusinessElementBOs(capBusinessElementBOS);
        }
        String runtimeTemplateFolder = CAPBusinessTemplateUtil.getTemplatePath("runtime", capBusinessTemplateBO, true);
        String runtimeColumnFolder = runtimeTemplateFolder + "columns" + File.separator;
        String runtimeCopyToFolder = runtimeColumnFolder + downloadColumnVO.getColumnId() + File.separator;
        try {
            File srcFolderFile = new File(srcFolder);
            File srcDataJson = new File(srcFolder, "info" + File.separator + "data.json");
            Map<String, Object> egDataMap = null;
            if (srcDataJson.exists()) {
                egDataMap = CAPBusinessUtil.readConfigJSON(srcDataJson.getAbsolutePath());
                FileUtil.deleteDirectory((String)srcDataJson.getParent());
            }
            FileUtil.copyDirectory((File)srcFolderFile, (File)new File(runtimeCopyToFolder));
            if (downloadColumnVO.getExtraMap() == null) {
                downloadColumnVO.setExtraMap(new HashMap());
            }
            downloadColumnVO.getExtraMap().put("isReplaced", CAPBusinessEnum.TrueOrFalseEnum.TRUE.getKey());
            List<ConfigColumnVO> exitsColumns = configTemplateVO.getColumns();
            ArrayList<ConfigColumnVO> newColumns = new ArrayList<ConfigColumnVO>();
            String oldColumnFolderName = "";
            for (ConfigColumnVO vo : exitsColumns) {
                if (oldCapBusinessColumnBO.getId().equals(vo.getColumnId())) {
                    oldColumnFolderName = oldCapBusinessColumnBO.getId();
                    newColumns.add(downloadColumnVO);
                    continue;
                }
                newColumns.add(vo);
            }
            configTemplateVO.setColumns(newColumns);
            if (!Strings.isBlank((String)oldColumnFolderName)) {
                String oldColumnPath = runtimeColumnFolder + oldColumnFolderName;
                FileUtil.deleteDirectory((String)oldColumnPath);
            }
            if (egDataMap != null) {
                String egPath = runtimeTemplateFolder + "eg" + File.separator + "data.json";
                Map<String, Object> egAllMap = CAPBusinessUtil.readConfigJSON(egPath);
                if (egAllMap == null) {
                    egAllMap = egDataMap;
                } else {
                    egAllMap.putAll(egDataMap);
                }
                CAPBusinessUtil.writeConfigJSON(egPath, egAllMap);
            }
        }
        catch (Exception e) {
            LOGGER.error((Object)("method analysisZipColumn Exception:" + downloadColumnVO.toString()), (Throwable)e);
            throw this.businessException("1005", String.format(ResourceUtil.getString((String)"cap.template.message.methodError"), "analysisZipColumn") + " Exception");
        }
        this.capBusinessTemplate4EditManager.putCacheEditableTemplateConfigJSON(templateId, configTemplateVO);
        this.capBusinessTemplate4EditManager.putCacheEditableCAPBusinessColumnBO(capBusinessColumnBO, Long.valueOf(oldCapBusinessColumnBO.getId()));
        this.capBusinessTemplate4EditManager.putCacheEditableReplacedColumnIds(templateId, Long.valueOf(oldCapBusinessColumnBO.getId()));
        this.capBusinessTemplate4EditManager.putCacheEditableColumnPreDataSource(templateId, Long.valueOf(capBusinessColumnBO.getId()), historyElementDataSource, Long.valueOf(oldCapBusinessColumnBO.getId()));
        return capBusinessColumnBO;
    }

    @Override
    public Integer getType() {
        return CAPBusinessEnum.DownloadZipType.COLUMN.getType();
    }

    private ConfigColumnVO analysisConfigJSON(String configJSONFolder) throws BusinessException {
        String configJSON = configJSONFolder + File.separator + "info" + File.separator + "config.json";
        Map<String, Object> businessConfigJson = CAPBusinessUtil.readConfigJSON(configJSON);
        if (businessConfigJson == null) {
            LOGGER.error((Object)"method analysisConfigJSON config.json parse is null ");
            throw this.businessException("1005", String.format(ResourceUtil.getString((String)"cap.template.message.methodError"), "analysisConfigJSON") + " config.json parse is null");
        }
        ConfigColumnVO configColumnVO = new ConfigColumnVO();
        configColumnVO.importFromMap(businessConfigJson);
        configColumnVO.setColumnId(String.valueOf(UUIDLong.longUUID()));
        List<ConfigElementVO> configElementVOS = configColumnVO.getElements();
        if (configElementVOS != null) {
            for (ConfigElementVO configElementVO : configElementVOS) {
                configElementVO.setElementId(String.valueOf(UUIDLong.longUUID()));
            }
        }
        FileUtil.deleteFile((String)configJSON);
        return configColumnVO;
    }

    public void setCapBusinessColumnManager(CAPBusinessColumnManager capBusinessColumnManager) {
        this.capBusinessColumnManager = capBusinessColumnManager;
    }

    public void setCapBusinessElementManager(CAPBusinessElementManager capBusinessElementManager) {
        this.capBusinessElementManager = capBusinessElementManager;
    }

    public void setCapBusinessTemplate4EditManager(CAPBusinessTemplate4EditManager capBusinessTemplate4EditManager) {
        this.capBusinessTemplate4EditManager = capBusinessTemplate4EditManager;
    }

    public void setCapBusinessManager(CAPBusinessManager capBusinessManager) {
        this.capBusinessManager = capBusinessManager;
    }
}

