/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.cap4.template.manager.impl;

import com.seeyon.cap4.form.control.ControlManager;
import com.seeyon.cap4.template.bean.DownloadParamBean;
import com.seeyon.cap4.template.constant.CAPBusinessEnum;
import com.seeyon.cap4.template.manager.CAPHttpRequestManager;
import com.seeyon.cap4.template.manager.impl.CAPDownloadAbstractManager;
import com.seeyon.cap4.template.util.FileUtil;
import com.seeyon.cap4.template.util.mall.Authcode;
import com.seeyon.cap4.template.vo.CAPDownloadUrlVO;
import com.seeyon.ctp.common.AppContext;
import com.seeyon.ctp.common.SystemEnvironment;
import com.seeyon.ctp.common.exceptions.BusinessException;
import com.seeyon.ctp.common.i18n.ResourceUtil;
import com.seeyon.ctp.common.log.CtpLogFactory;
import com.seeyon.ctp.util.DateUtil;
import com.seeyon.ctp.util.Strings;
import com.seeyon.ctp.util.json.JSONUtil;
import java.io.File;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;

public class CAPDownloadManager4CustomCtrl
extends CAPDownloadAbstractManager {
    private static final Log LOGGER = CtpLogFactory.getLog(CAPDownloadManager4CustomCtrl.class);
    private static final String KEY_MEMBER_INFO = "memberInfo";
    private CAPHttpRequestManager capHttpRequestManager;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Map<String, Object> download(DownloadParamBean vo) throws BusinessException {
        HashMap<String, Object> result;
        long startTime;
        block13: {
            startTime = System.currentTimeMillis();
            result = new HashMap<String, Object>();
            if (vo.getFileId() != null) {
                Long fileId = vo.getFileId() == null ? 0L : vo.getFileId();
                String fileName = vo.getFileName();
                try {
                    File importFile = this.fileManager.getFile(fileId, DateUtil.currentDate());
                    if (importFile == null) return result;
                    if (!importFile.exists()) return result;
                    ControlManager controlManager = (ControlManager)AppContext.getBean((String)"controlManager");
                    HashMap<String, Object> map = new HashMap<String, Object>();
                    map.put("contrlPackage", importFile);
                    controlManager.setupContrl(map);
                    return result;
                }
                catch (BusinessException e) {
                    LOGGER.error((Object)("\u63a7\u4ef6" + fileName + "\u79bb\u7ebf\u5b89\u88c5\u5931\u8d25\uff1a" + e.getMessage()), (Throwable)e);
                    throw this.businessException("1005", ResourceUtil.getString((String)"cap.template.design.download.installError") + e.getMessage());
                }
            }
            Long userId = AppContext.currentUserId();
            HashMap<String, Object> dataMap = new HashMap<String, Object>();
            try {
                dataMap.put(KEY_MEMBER_INFO, Authcode.encode(URLEncoder.encode(JSONUtil.toJSONString(this.capDownloadBaseManager.getMemberInfo(userId)), "UTF-8")));
            }
            catch (UnsupportedEncodingException e) {
                // empty catch block
            }
            CAPDownloadUrlVO capDownloadUrlVO = this.capDownloadBaseManager.getFreeDownloadInfo(vo.getGoodId(), dataMap);
            File toFile = null;
            try {
                String goodName = "";
                String url = "";
                boolean isFree = false;
                if (capDownloadUrlVO != null) {
                    goodName = capDownloadUrlVO.getGoodName();
                    url = capDownloadUrlVO.getUrl();
                    isFree = true;
                } else {
                    result.put("code", "1102");
                    result.put("goodUrl", this.capDownloadBaseManager.getMallGoodUrl(vo.getGoodId(), null));
                    result.put("message", "downloadCustomCtrl get cloudResource is null.need buy it on mall");
                }
                if (url != null && Strings.isNotBlank((String)url)) {
                    String fileName;
                    File customCtrlFolder = SystemEnvironment.getClusterPublicFolder((String)"capCustomCtrls");
                    toFile = new File(customCtrlFolder, fileName = vo.getGoodId() + ".zip");
                    boolean downloadResult = this.capHttpRequestManager.download(url, toFile);
                    if (!downloadResult) {
                        LOGGER.error((Object)("method downLoadCustomCtrl is download error , params is " + vo.toString()));
                        throw this.businessException("1002", String.format(ResourceUtil.getString((String)"cap.template.message.methodError"), "downloadMallFile"));
                    }
                    ControlManager controlManager = (ControlManager)AppContext.getBean((String)"controlManager");
                    HashMap<String, Object> map = new HashMap<String, Object>();
                    map.put("goodsId", String.valueOf(vo.getGoodId()));
                    map.put("goodsName", goodName);
                    map.put("contrlPackage", toFile);
                    map.put("goodsIsFree", isFree ? "1" : "0");
                    controlManager.setupContrl(map);
                }
                if (toFile == null) break block13;
            }
            catch (BusinessException e) {
                try {
                    LOGGER.error((Object)("method downLoadCustomCtrl is error , params goodId " + vo.toString() + " , " + e.getMessage()), (Throwable)e);
                    throw this.businessException("1005", ResourceUtil.getString((String)"cap.template.design.download.installError") + e.getMessage());
                }
                catch (Throwable throwable) {
                    if (toFile == null) throw throwable;
                    FileUtil.deleteFile(toFile);
                    LOGGER.info((Object)("delete control file:" + toFile.getName()));
                    throw throwable;
                }
            }
            FileUtil.deleteFile((File)toFile);
            LOGGER.info((Object)("delete control file:" + toFile.getName()));
        }
        LOGGER.info((Object)("download customCtrl use time " + (System.currentTimeMillis() - startTime) + " ms , params " + vo.toString()));
        return result;
    }

    @Override
    public Integer getType() {
        return CAPBusinessEnum.DownloadZipType.CUSTOM_CTRL.getType();
    }

    public void setCapHttpRequestManager(CAPHttpRequestManager capHttpRequestManager) {
        this.capHttpRequestManager = capHttpRequestManager;
    }
}

