/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.cap4.template.manager.impl;

import com.seeyon.cap4.template.bean.DownloadParamBean;
import com.seeyon.cap4.template.bo.CAPBusinessColumnBO;
import com.seeyon.cap4.template.bo.CAPBusinessElementBO;
import com.seeyon.cap4.template.bo.CAPBusinessTemplateBO;
import com.seeyon.cap4.template.constant.CAPBusinessConstant;
import com.seeyon.cap4.template.constant.CAPBusinessEnum;
import com.seeyon.cap4.template.manager.CAPBusinessColumnManager;
import com.seeyon.cap4.template.manager.CAPBusinessElementManager;
import com.seeyon.cap4.template.manager.CAPBusinessManager;
import com.seeyon.cap4.template.manager.CAPBusinessTemplateClusterManager;
import com.seeyon.cap4.template.manager.impl.CAPDownloadAbstractManager;
import com.seeyon.cap4.template.po.CAPBusinessTemplate;
import com.seeyon.cap4.template.util.CAPBuildM3Util;
import com.seeyon.cap4.template.util.CAPBusinessTemplateUtil;
import com.seeyon.cap4.template.util.CAPBusinessUtil;
import com.seeyon.cap4.template.util.FileUtil;
import com.seeyon.cap4.template.vo.CAPBuildTemplateVO;
import com.seeyon.cap4.template.vo.CAPDownloadUrlVO;
import com.seeyon.cap4.template.vo.config.ConfigColumnVO;
import com.seeyon.cap4.template.vo.config.ConfigElementVO;
import com.seeyon.cap4.template.vo.config.ConfigTemplateVO;
import com.seeyon.ctp.common.AppContext;
import com.seeyon.ctp.common.exceptions.BusinessException;
import com.seeyon.ctp.common.i18n.ResourceUtil;
import com.seeyon.ctp.common.log.CtpLogFactory;
import com.seeyon.ctp.util.DateUtil;
import com.seeyon.ctp.util.Strings;
import com.seeyon.ctp.util.UUIDLong;
import com.seeyon.ctp.util.json.JSONUtil;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.FutureTask;
import org.apache.commons.logging.Log;

public class CAPDownloadManager4Template
extends CAPDownloadAbstractManager {
    private static final Log LOGGER = CtpLogFactory.getLog(CAPDownloadManager4Template.class);
    private CAPBusinessManager capBusinessManager;
    private CAPBusinessColumnManager capBusinessColumnManager;
    private CAPBusinessElementManager capBusinessElementManager;
    private CAPBusinessTemplateClusterManager capBusinessTemplateClusterManager;
    private static final long DEFAULT_GOOD_ID = 0L;
    private static final String DEFAULT_GOOD_NAME = "";
    private static final String KEY_FRAME_FOLDER = "frame";
    private static final String TEMPLATE_INDEX_HTML = "index.html";
    private static final String MESSAGE_RECOVERY_ERROR = "cap.template.design.edit.saveRollbackError";
    private static final String MESSAGE_DELETE_COPY = "\u4e0b\u8f7d\u6a21\u677f\u5931\u8d25!!!\u6267\u884c\u5220\u9664\u5df2\u590d\u5236\u7684\u6587\u4ef6\u5939";
    private static final String MESSAGE2 = "cap.template.message.paramNull";

    @Override
    public Map<String, Object> download(DownloadParamBean vo) throws BusinessException {
        Map<String, Object> result;
        long startTime = System.currentTimeMillis();
        if (vo.getDataId() == null || vo.getTemplateType() == null) {
            throw this.businessException("1001", String.format(ResourceUtil.getString((String)MESSAGE2), "paramId or templateType"));
        }
        if (!this.capBusinessManager.checkBizOwnerAuth4Template(vo.getEggId())) {
            throw this.businessException("1201", "this user is no auth");
        }
        switch (vo.getDownloadType()) {
            case 1: {
                Long templateId = vo.getTemplateId() == null ? Long.valueOf(0L) : vo.getTemplateId();
                result = this.copyPresetTemplate(vo.getDataId(), vo.getEggId(), vo.getClientType(), vo.getTemplateType(), templateId);
                break;
            }
            case 3: {
                CAPBusinessTemplate capBusinessTemplate = this.capBusinessTemplateManager.getCAPBusinessTemplateById(vo.getTemplateId());
                result = this.copyLocalTemplate(capBusinessTemplate, vo.getNewDataId());
                break;
            }
            case 4: {
                if (vo.getFileId() == null || Long.valueOf(0L).equals(vo.getFileId())) {
                    throw this.businessException("1001", String.format(ResourceUtil.getString((String)MESSAGE2), "fileId"));
                }
                File importFile = this.fileManager.getFile(vo.getFileId(), DateUtil.currentDate());
                result = this.analysis(importFile, vo, null);
                break;
            }
            default: {
                if (vo.getGoodId() == null || vo.getGoodId() <= 0L) {
                    throw this.businessException("1001", String.format(ResourceUtil.getString((String)MESSAGE2), "goodId"));
                }
                CAPDownloadUrlVO capDownloadUrlVO = this.capDownloadBaseManager.getDownloadUrlVO(vo.getGoodId());
                File downloadFile = this.capDownloadBaseManager.downloadMallFile(capDownloadUrlVO.getUrl());
                result = this.analysis(downloadFile, vo, capDownloadUrlVO);
            }
        }
        LOGGER.info((Object)("download template use time " + (System.currentTimeMillis() - startTime) + " ms , params " + vo.toString()));
        return result;
    }

    private Map<String, Object> analysis(File downloadFile, DownloadParamBean vo, CAPDownloadUrlVO capDownloadUrlVO) throws BusinessException {
        String unzipToFolder = this.capDownloadBaseManager.unzipDownloadFile(downloadFile);
        boolean checkFolder = this.capDownloadBaseManager.checkDownloadFolder(unzipToFolder, vo.getDownloadZipType());
        if (!checkFolder) {
            LOGGER.error((Object)("method download template is dir error , unzipToFolder is " + unzipToFolder));
            throw this.businessException("1005", ResourceUtil.getString((String)"cap.template.design.download.error"));
        }
        CAPBusinessCustomTemplateVO capBusinessTemplateVO = new CAPBusinessCustomTemplateVO();
        capBusinessTemplateVO.setGoodId(vo.getGoodId() == null ? 0L : vo.getGoodId());
        capBusinessTemplateVO.setGoodName(capDownloadUrlVO == null ? DEFAULT_GOOD_NAME : capDownloadUrlVO.getGoodName());
        int urlClient = capDownloadUrlVO != null ? Integer.valueOf(capDownloadUrlVO.getClient()) : 0;
        capBusinessTemplateVO.setClient(vo.getClientType() == null ? urlClient : vo.getClientType());
        capBusinessTemplateVO.setTemplateType(vo.getTemplateType());
        capBusinessTemplateVO.setPathId(vo.getDataId());
        if (CAPBusinessEnum.TemplateType.TP_BIZ_INDEX.getType() == vo.getTemplateType().intValue()) {
            capBusinessTemplateVO.setEggId(vo.getDataId());
            capBusinessTemplateVO.setSleepTime(0L);
        } else {
            capBusinessTemplateVO.setEggId(vo.getEggId());
            capBusinessTemplateVO.setSleepTime(2500L);
        }
        List<ConfigTemplateVO> configTemplateVOS = this.analysisConfigJSON(unzipToFolder, capBusinessTemplateVO);
        capBusinessTemplateVO.setZipConfig(configTemplateVOS);
        Map<String, Object> result = this.analysisZipTemplate(unzipToFolder, capBusinessTemplateVO);
        this.deleteFileAfterDownloaded(vo.getDownloadType() == 4 ? null : downloadFile, unzipToFolder);
        return result;
    }

    private Map<String, Object> copyPresetTemplate(Long pathId, Long eggId, Integer clientType, Integer templateType, Long presetTemplateId) throws BusinessException {
        Map<String, Object> result = new HashMap<String, Object>();
        if (eggId == null || pathId == null || templateType == null || clientType == null || presetTemplateId == null) {
            throw this.businessException("1001", String.format(ResourceUtil.getString((String)MESSAGE2), "param"));
        }
        if (templateType.equals(CAPBusinessEnum.TemplateType.TP_BIZ_INDEX.getType())) {
            throw this.businessException("1005", ResourceUtil.getString((String)"cap.template.design.download.template.missing"));
        }
        if (presetTemplateId.intValue() == 0) {
            CAPBusinessTemplate oldCapBusinessTemplate = this.capBusinessTemplateManager.getCAPBusinessTemplateByPathIdAndTypeAndClient(pathId, templateType, clientType);
            boolean deleteResult = true;
            if (oldCapBusinessTemplate != null) {
                ArrayList<CAPBusinessTemplate> capBusinessTemplates = new ArrayList<CAPBusinessTemplate>();
                capBusinessTemplates.add(oldCapBusinessTemplate);
                deleteResult = this.capBusinessTemplateManager.deleteCAPBusinessTemplates(eggId, capBusinessTemplates, false);
            }
            result.put("code", deleteResult ? "1000" : "1005");
            result.put("message", deleteResult ? "the operation is success!!!" : String.format(ResourceUtil.getString((String)"cap.template.message.methodError"), "copy"));
        } else {
            String defaultPath = CAPBusinessTemplateUtil.getPresetTemplateFolder(String.valueOf(presetTemplateId), clientType, templateType);
            Map<String, Object> configMap = CAPBusinessUtil.readConfigJSON(defaultPath + CAPBusinessConstant.DIST_STATIC_CONFIG_JSON);
            if (configMap != null) {
                ArrayList<ConfigTemplateVO> configTemplateVOS = new ArrayList<ConfigTemplateVO>();
                try {
                    configTemplateVOS.add(this.analysisTemplateConfig(configMap));
                }
                catch (BusinessException e) {
                    LOGGER.error((Object)("copyDefaultTemplate analysisTemplateConfig error " + e.getMessage()), (Throwable)e);
                    throw this.businessException("1005", String.format(ResourceUtil.getString((String)MESSAGE2), "config"));
                }
                CAPBusinessCustomTemplateVO capBusinessTemplateVO = new CAPBusinessCustomTemplateVO();
                capBusinessTemplateVO.setZipConfig(configTemplateVOS);
                capBusinessTemplateVO.setClient(clientType);
                capBusinessTemplateVO.setTemplateType(templateType);
                capBusinessTemplateVO.setGoodId(presetTemplateId);
                capBusinessTemplateVO.setGoodName(DEFAULT_GOOD_NAME);
                capBusinessTemplateVO.setEggId(eggId);
                capBusinessTemplateVO.setPathId(pathId);
                capBusinessTemplateVO.setNoParentFolder(true);
                capBusinessTemplateVO.setSleepTime(4000L);
                result = this.analysisZipTemplate(defaultPath, capBusinessTemplateVO);
            } else {
                LOGGER.error((Object)("copyDefaultTemplate configMap is null ,  path is " + defaultPath));
                throw this.businessException("1005", String.format(ResourceUtil.getString((String)MESSAGE2), "config"));
            }
        }
        return result;
    }

    private Map<String, Object> copyLocalTemplate(CAPBusinessTemplate oldCapBusinessTemplate, Long newDataId) throws BusinessException {
        String baseTemplatePath = CAPBusinessTemplateUtil.getTemplatePath("base", oldCapBusinessTemplate, false);
        String baseConfigPath = CAPBusinessTemplateUtil.getTemplateConfigPath("base", oldCapBusinessTemplate, false);
        Map<String, Object> configMap = CAPBusinessUtil.readConfigJSON(baseConfigPath);
        if (configMap == null) {
            LOGGER.error((Object)("copyReportTemplate configMap is null,  path is " + baseConfigPath));
            throw this.businessException("1005", String.format(ResourceUtil.getString((String)MESSAGE2), "config"));
        }
        ArrayList<ConfigTemplateVO> configTemplateVOS = new ArrayList<ConfigTemplateVO>();
        try {
            configTemplateVOS.add(this.analysisTemplateConfig(configMap));
        }
        catch (BusinessException e) {
            LOGGER.error((Object)("copyReportTemplate analysisTemplateConfig error " + e.getMessage()), (Throwable)e);
            throw this.businessException("1005", String.format(ResourceUtil.getString((String)MESSAGE2), "config"));
        }
        CAPBusinessCustomTemplateVO vo = new CAPBusinessCustomTemplateVO();
        vo.setZipConfig(configTemplateVOS);
        vo.setClient(oldCapBusinessTemplate.getClient());
        vo.setTemplateType(oldCapBusinessTemplate.getTemplateType());
        vo.setGoodId(oldCapBusinessTemplate.getGoodId());
        vo.setGoodName(oldCapBusinessTemplate.getName());
        vo.setEggId(oldCapBusinessTemplate.getEggId());
        vo.setPathId(newDataId);
        vo.setNoParentFolder(true);
        vo.setSleepTime(0L);
        return this.analysisZipTemplate(baseTemplatePath, vo);
    }

    private Map<String, Object> analysisZipTemplate(String copyFromFolder, CAPBusinessCustomTemplateVO capBusinessTemplateVO) throws BusinessException {
        HashMap<String, Object> result = new HashMap<String, Object>();
        List<ConfigTemplateVO> configTemplateVOS = capBusinessTemplateVO.getZipConfig();
        Integer clientType = capBusinessTemplateVO.getClient();
        CAPBusinessTemplate oldCapBusinessTemplate = null;
        if (!capBusinessTemplateVO.getTemplateType().equals(CAPBusinessEnum.TemplateType.TP_BIZ_INDEX.getType())) {
            oldCapBusinessTemplate = this.capBusinessTemplateManager.getCAPBusinessTemplateByPathIdAndTypeAndClient(capBusinessTemplateVO.getPathId(), capBusinessTemplateVO.getTemplateType(), clientType);
        }
        List<CAPBusinessTemplateBO> waitCapBusinessTemplateBOS = null;
        CAPTemplateFileFuture fileFuture = null;
        try {
            CAPTemplateFileCallable templateFileCallable = new CAPTemplateFileCallable(copyFromFolder, capBusinessTemplateVO, configTemplateVOS);
            FutureTask<CAPTemplateFileFuture> futureTask = new FutureTask<CAPTemplateFileFuture>(templateFileCallable);
            new Thread(futureTask).start();
            waitCapBusinessTemplateBOS = this.getTemplateBOSFromConfigVOS(configTemplateVOS, capBusinessTemplateVO);
            this.setTemplateSort(waitCapBusinessTemplateBOS, capBusinessTemplateVO.getTemplateType(), capBusinessTemplateVO.getEggId());
            fileFuture = futureTask.get();
            boolean queryResult = this.capBusinessTemplateManager.saveCAPBusinessTemplatesByImport(waitCapBusinessTemplateBOS, null, capBusinessTemplateVO.getEggId());
            if (!queryResult) {
                LOGGER.error((Object)"method analysisZipTemplate is error AND queryResult is false");
                throw this.businessException("1005", String.format(ResourceUtil.getString((String)"cap.template.message.methodError"), "analysisZipTemplate") + " query error");
            }
            if (!capBusinessTemplateVO.getTemplateType().equals(CAPBusinessEnum.TemplateType.TP_BIZ_INDEX.getType()) && oldCapBusinessTemplate != null) {
                ArrayList<CAPBusinessTemplate> capBusinessTemplates = new ArrayList<CAPBusinessTemplate>();
                capBusinessTemplates.add(oldCapBusinessTemplate);
                this.capBusinessTemplateManager.deleteCAPBusinessTemplates(capBusinessTemplateVO.getEggId(), capBusinessTemplates, false);
            }
            LOGGER.info((Object)("downloadTemplate remove cache " + capBusinessTemplateVO.getEggId()));
            result.put("data", this.getDownloadTemplatesMap(waitCapBusinessTemplateBOS));
            result.put("code", "1000");
            result.put("message", "the operation is success!!!");
            if (Strings.isNotEmpty(fileFuture.getBakBaseFiles())) {
                for (CAPBusinessCustomFileVO vo : fileFuture.getBakBaseFiles()) {
                    FileUtil.deleteDirectory((File)vo.getCopyFromFile());
                }
            }
        }
        catch (Exception e) {
            LOGGER.error((Object)("method analysisZipTemplate is Exception AND param copyFromFolder is " + copyFromFolder + " AND param businessConfigList is " + JSONUtil.toJSONString(configTemplateVOS) + " AND capBusinessTemplateVO is " + capBusinessTemplateVO), (Throwable)e);
            this.deleteCopyTemplateWhenFailed(fileFuture == null ? null : fileFuture.getFailDeleteFiles());
            try {
                this.downloadFailRecoveryTemplateFolder(clientType, capBusinessTemplateVO.getTemplateType(), fileFuture == null ? null : fileFuture.getBakBaseFiles());
            }
            catch (IOException e1) {
                throw this.businessException("1005", ResourceUtil.getString((String)MESSAGE_RECOVERY_ERROR) + " " + e1.getMessage());
            }
            throw this.businessException("1005", String.format(ResourceUtil.getString((String)"cap.template.message.methodError"), "analysisZipTemplate") + " Exception" + e.getMessage());
        }
        this.doAfterDownload(capBusinessTemplateVO.getEggId(), waitCapBusinessTemplateBOS);
        return result;
    }

    private List<CAPBusinessTemplateBO> getTemplateBOSFromConfigVOS(List<ConfigTemplateVO> configTemplateVOS, CAPBusinessCustomTemplateVO capBusinessTemplateVO) {
        ArrayList<CAPBusinessTemplateBO> waitCapBusinessTemplateBOS = new ArrayList<CAPBusinessTemplateBO>();
        Long userId = AppContext.currentUserId();
        for (ConfigTemplateVO configTemplateVO : configTemplateVOS) {
            CAPBusinessTemplateBO capBusinessTemplateBO = new CAPBusinessTemplateBO();
            capBusinessTemplateBO.setId(configTemplateVO.getTemplateId());
            capBusinessTemplateBO.setName(configTemplateVO.getName());
            capBusinessTemplateBO.setClient(String.valueOf(capBusinessTemplateVO.getClient()));
            capBusinessTemplateBO.setGoodId(String.valueOf(capBusinessTemplateVO.getGoodId()));
            capBusinessTemplateBO.setGoodName(capBusinessTemplateVO.getGoodName());
            capBusinessTemplateBO.setEggId(String.valueOf(capBusinessTemplateVO.getEggId()));
            capBusinessTemplateBO.setPathId(String.valueOf(capBusinessTemplateVO.getPathId()));
            capBusinessTemplateBO.setState(String.valueOf(CAPBusinessEnum.State.ENABLE.getState()));
            capBusinessTemplateBO.setTemplateType(configTemplateVO.getType());
            capBusinessTemplateBO.setCreateMemberId(String.valueOf(userId));
            capBusinessTemplateBO.setModifyMemberId(String.valueOf(userId));
            capBusinessTemplateBO.setFrameType(configTemplateVO.getFrameType());
            List<CAPBusinessColumnBO> columnBOS = this.analysisZipColumnFromTemplate(configTemplateVO.getColumns(), capBusinessTemplateBO);
            if (columnBOS != null) {
                capBusinessTemplateBO.setCapBusinessColumnBOs(columnBOS);
            }
            waitCapBusinessTemplateBOS.add(capBusinessTemplateBO);
        }
        return waitCapBusinessTemplateBOS;
    }

    private void setTemplateSort(List<CAPBusinessTemplateBO> waitCapBusinessTemplateBOS, Integer inputTemplateType, Long bizId) {
        Integer startSort = 0;
        if (CAPBusinessEnum.TemplateType.TP_BIZ_INDEX.getType() == inputTemplateType.intValue()) {
            double maxSort = this.capBusinessTemplateManager.getMaxSortByBizIdAndTemplateType(bizId, inputTemplateType);
            double maxSort10 = maxSort / 10.0;
            startSort = Double.valueOf(0.0).equals(maxSort10 % 1.0) ? Integer.valueOf(new Double(maxSort).intValue() + 10) : Integer.valueOf(new Double(Math.ceil(maxSort10) * 10.0).intValue());
        }
        int loopKey = 0;
        for (CAPBusinessTemplateBO capBusinessTemplateBO : waitCapBusinessTemplateBOS) {
            int sort = startSort + loopKey * 10;
            if (sort > 9999) {
                sort = 9999;
            }
            capBusinessTemplateBO.setSort(String.valueOf(sort));
            ++loopKey;
        }
    }

    private void doAfterDownload(Long bizId, List<CAPBusinessTemplateBO> waitCapBusinessTemplateBOS) throws BusinessException {
        if (Strings.isNotEmpty(waitCapBusinessTemplateBOS)) {
            ArrayList<CAPBuildTemplateVO> waitBuildTemplates = new ArrayList<CAPBuildTemplateVO>();
            ArrayList<String> clusterTemplateIds = new ArrayList<String>();
            ArrayList<Long> waitBackInit = new ArrayList<Long>();
            for (CAPBusinessTemplateBO bo : waitCapBusinessTemplateBOS) {
                clusterTemplateIds.add(bo.getId());
                if (Integer.valueOf(bo.getClient()).equals(CAPBusinessEnum.Platform.MOBILE.getType())) {
                    waitBuildTemplates.add(new CAPBuildTemplateVO(Long.valueOf(bo.getEggId()), Long.valueOf(bo.getId()), Integer.valueOf(bo.getTemplateType()), Integer.valueOf(bo.getClient()), Long.valueOf(bo.getPathId())));
                }
                if (Integer.valueOf(bo.getFrameType()).intValue() != CAPBusinessEnum.TemplateFrameType.NO_NEED_FRAME.getType()) continue;
                waitBackInit.add(Long.valueOf(bo.getId()));
            }
            this.capBusinessTemplateManager.execTemplateInitialBackup(waitBackInit);
            if (Strings.isNotEmpty(waitBuildTemplates)) {
                CAPBuildM3Util.buildMobileCAPTemplatePackage(waitBuildTemplates, true);
            }
            this.capBusinessTemplateClusterManager.sendDownloadTemplate(bizId, clusterTemplateIds);
        }
    }

    private List<Map<String, Object>> getDownloadTemplatesMap(List<CAPBusinessTemplateBO> waitCapBusinessTemplateBOS) {
        ArrayList<Map<String, Object>> templates = new ArrayList<Map<String, Object>>();
        for (CAPBusinessTemplateBO capBusinessTemplateBO : waitCapBusinessTemplateBOS) {
            Map<String, Object> template = capBusinessTemplateBO.exportToMapForDesign();
            ArrayList<Map<String, Object>> columns = new ArrayList<Map<String, Object>>();
            for (CAPBusinessColumnBO capBusinessColumnBO : capBusinessTemplateBO.getCapBusinessColumnBOs()) {
                Map<String, Object> column = capBusinessColumnBO.exportToMapForDesign();
                ArrayList<Map<String, Object>> elements = new ArrayList<Map<String, Object>>();
                for (CAPBusinessElementBO capBusinessElementBO : capBusinessColumnBO.getCapBusinessElementBOs()) {
                    elements.add(capBusinessElementBO.exportToMapForDesign());
                }
                column.put("elements", elements);
                columns.add(column);
            }
            template.put("columns", columns);
            templates.add(template);
        }
        return templates;
    }

    @Override
    public Integer getType() {
        return CAPBusinessEnum.DownloadZipType.TEMPLATE.getType();
    }

    private void downloadFailRecoveryTemplateFolder(int clientType, int templateType, List<CAPBusinessCustomFileVO> bakBaseFiles) throws IOException {
        if (Strings.isNotEmpty(bakBaseFiles)) {
            String baseRoot = CAPBusinessTemplateUtil.getBaseCustomTemplateRootFolder(clientType);
            String runtimeRoot = CAPBusinessTemplateUtil.getRuntimeCustomTemplateRootFolder(clientType, templateType);
            for (CAPBusinessCustomFileVO vo : bakBaseFiles) {
                String runtimePath = vo.getCopyToPath().replace(baseRoot, runtimeRoot);
                LOGGER.info((Object)("\u4e0b\u8f7d\u6a21\u677f\u5907\u4efd\u6062\u590dfrom folder : " + vo.getCopyFromFile().getAbsolutePath() + " , to base folder : " + vo.getCopyToPath() + " , to runtime folder : " + runtimePath));
                File baseFile = new File(vo.getCopyToPath());
                if (vo.getDeleteToFile() && baseFile.exists()) {
                    FileUtil.deleteDirectory((File)baseFile);
                }
                FileUtil.copyDirectory((File)vo.getCopyFromFile(), (File)baseFile);
                FileUtil.copyDirectory((File)vo.getCopyFromFile(), (File)new File(runtimePath));
                FileUtil.deleteDirectory((File)vo.getCopyFromFile());
            }
        }
    }

    private List<CAPBusinessColumnBO> analysisZipColumnFromTemplate(List<ConfigColumnVO> configColumnVOS, CAPBusinessTemplateBO capBusinessTemplateBO) {
        ArrayList<CAPBusinessColumnBO> capBusinessColumnBOS = null;
        if (configColumnVOS != null) {
            capBusinessColumnBOS = new ArrayList<CAPBusinessColumnBO>();
            for (ConfigColumnVO vo : configColumnVOS) {
                CAPBusinessColumnBO capBusinessColumnBO = this.capBusinessColumnManager.analysisDownloadColumn(vo, String.valueOf(0L), DEFAULT_GOOD_NAME, capBusinessTemplateBO.getId(), capBusinessTemplateBO.getCreateMemberId());
                List<CAPBusinessElementBO> elementBOS = this.capBusinessElementManager.analysisDownloadElement(vo.getElements(), capBusinessColumnBO, null);
                capBusinessColumnBO.setCapBusinessElementBOs(elementBOS);
                capBusinessColumnBOS.add(capBusinessColumnBO);
            }
        }
        return capBusinessColumnBOS;
    }

    private List<ConfigTemplateVO> analysisConfigJSON(String configJSONFolder, CAPBusinessCustomTemplateVO capBusinessTemplateVO) throws BusinessException {
        ArrayList<ConfigTemplateVO> list = new ArrayList<ConfigTemplateVO>();
        String oneConfigJSON = configJSONFolder + File.separator + CAPBusinessConstant.DIST_STATIC_CONFIG_JSON;
        File fileOneConfigJSON = new File(oneConfigJSON);
        if (fileOneConfigJSON.exists()) {
            String config = FileUtil.readFile((File)fileOneConfigJSON);
            if (Strings.isBlank((String)config)) {
                LOGGER.error((Object)("method analysisConfigJSON config.json is empty:" + oneConfigJSON));
            } else {
                Map businessConfigJson = (Map)JSONUtil.parseJSONString((String)config);
                if (businessConfigJson == null) {
                    LOGGER.error((Object)"method analysisConfigJSON config.json is parse error");
                } else {
                    ConfigTemplateVO configTemplateVO = this.analysisTemplateConfig(businessConfigJson);
                    fileOneConfigJSON.delete();
                    list.add(configTemplateVO);
                }
            }
            capBusinessTemplateVO.setNoParentFolder(true);
        } else {
            File fileTempFolder = new File(configJSONFolder);
            String[] fileTempList = fileTempFolder.list();
            for (int i = 0; i < fileTempList.length; ++i) {
                String configJSON = configJSONFolder + File.separator + fileTempList[i] + File.separator + CAPBusinessConstant.DIST_STATIC_CONFIG_JSON;
                Map<String, Object> businessConfigJson = CAPBusinessUtil.readConfigJSON(configJSON);
                if (businessConfigJson == null) {
                    LOGGER.error((Object)"method analysisConfigJSON config.json is parse error");
                    continue;
                }
                ConfigTemplateVO configTemplateVO = this.analysisTemplateConfig(businessConfigJson);
                configTemplateVO.setTemplateFolder(fileTempList[i]);
                list.add(configTemplateVO);
                FileUtil.deleteFile((String)configJSON);
            }
            capBusinessTemplateVO.setNoParentFolder(false);
        }
        if (list.size() == 0) {
            LOGGER.error((Object)("method analysisConfigJSON config.json's is all empty:" + configJSONFolder));
            throw this.businessException("1005", String.format(ResourceUtil.getString((String)"cap.template.message.methodError"), "analysisConfigJSON") + "config.json is error");
        }
        return list;
    }

    private ConfigTemplateVO analysisTemplateConfig(Map<String, Object> businessConfigJson) throws BusinessException {
        ConfigTemplateVO configTemplateVO = new ConfigTemplateVO();
        configTemplateVO.importFromMap(businessConfigJson);
        String templateId = String.valueOf(UUIDLong.longUUID());
        configTemplateVO.setTemplateId(templateId);
        if (configTemplateVO.getColumns() != null) {
            for (ConfigColumnVO column : configTemplateVO.getColumns()) {
                column.setColumnId(String.valueOf(UUIDLong.longUUID()));
                if (column.getElements() == null) continue;
                for (ConfigElementVO element : column.getElements()) {
                    element.setElementId(String.valueOf(UUIDLong.longUUID()));
                }
            }
        }
        return configTemplateVO;
    }

    private boolean deleteCopyTemplateWhenFailed(List<File> copyedFile) {
        if (copyedFile == null || copyedFile.size() == 0) {
            return false;
        }
        for (File file : copyedFile) {
            if (file == null || !file.exists()) continue;
            LOGGER.info((Object)(MESSAGE_DELETE_COPY + file.getAbsolutePath()));
            FileUtil.deleteDirectory((File)file);
        }
        return true;
    }

    public void setCapBusinessColumnManager(CAPBusinessColumnManager capBusinessColumnManager) {
        this.capBusinessColumnManager = capBusinessColumnManager;
    }

    public void setCapBusinessElementManager(CAPBusinessElementManager capBusinessElementManager) {
        this.capBusinessElementManager = capBusinessElementManager;
    }

    public void setCapBusinessManager(CAPBusinessManager capBusinessManager) {
        this.capBusinessManager = capBusinessManager;
    }

    public void setCapBusinessTemplateClusterManager(CAPBusinessTemplateClusterManager capBusinessTemplateClusterManager) {
        this.capBusinessTemplateClusterManager = capBusinessTemplateClusterManager;
    }

    private class CAPBusinessCustomTemplateVO {
        private Long goodId;
        private String goodName;
        private Integer client;
        private Integer templateType;
        private Long pathId;
        private Long eggId;
        private List<ConfigTemplateVO> zipConfig;
        private boolean noParentFolder = false;
        private long sleepTime = 0L;

        private CAPBusinessCustomTemplateVO() {
        }

        public Long getGoodId() {
            return this.goodId;
        }

        public void setGoodId(Long goodId) {
            this.goodId = goodId;
        }

        public String getGoodName() {
            return this.goodName;
        }

        public void setGoodName(String goodName) {
            this.goodName = goodName;
        }

        public Integer getClient() {
            return this.client;
        }

        public void setClient(Integer client) {
            this.client = client;
        }

        public Integer getTemplateType() {
            return this.templateType;
        }

        public void setTemplateType(Integer templateType) {
            this.templateType = templateType;
        }

        public Long getPathId() {
            return this.pathId;
        }

        public void setPathId(Long pathId) {
            this.pathId = pathId;
        }

        public Long getEggId() {
            return this.eggId;
        }

        public void setEggId(Long eggId) {
            this.eggId = eggId;
        }

        public List<ConfigTemplateVO> getZipConfig() {
            return this.zipConfig;
        }

        public void setZipConfig(List<ConfigTemplateVO> zipConfig) {
            this.zipConfig = zipConfig;
        }

        public boolean getNoParentFolder() {
            return this.noParentFolder;
        }

        public void setNoParentFolder(boolean noParentFolder) {
            this.noParentFolder = noParentFolder;
        }

        public long getSleepTime() {
            return this.sleepTime;
        }

        public void setSleepTime(long sleepTime) {
            this.sleepTime = sleepTime;
        }

        public String toString() {
            return "CAPBusinessCustomTemplateVO{goodId=" + this.goodId + ", goodName='" + this.goodName + '\'' + ", client=" + this.client + ", templateType=" + this.templateType + ", pathId=" + this.pathId + ", eggId=" + this.eggId + ", zipConfig=" + this.zipConfig + ", noParentFolder=" + this.noParentFolder + ", sleepTime=" + this.sleepTime + '}';
        }
    }

    private class CAPBusinessCustomFileVO {
        private String copyToPath;
        private File copyFromFile;
        private boolean deleteToFile = false;

        public CAPBusinessCustomFileVO(File copyFromFile, String copyToPath, boolean deleteToFile) {
            this.copyToPath = copyToPath;
            this.copyFromFile = copyFromFile;
            this.deleteToFile = deleteToFile;
        }

        public CAPBusinessCustomFileVO(File copyFromFile, boolean deleteToFile) {
            this.copyFromFile = copyFromFile;
            this.deleteToFile = deleteToFile;
        }

        public File getCopyFromFile() {
            return this.copyFromFile;
        }

        public boolean getDeleteToFile() {
            return this.deleteToFile;
        }

        public String getCopyToPath() {
            return this.copyToPath;
        }
    }

    private class CAPTemplateFileFuture {
        private List<CAPBusinessCustomFileVO> bakBaseFiles = new ArrayList<CAPBusinessCustomFileVO>();
        private List<File> failDeleteFiles = new ArrayList<File>();

        public List<CAPBusinessCustomFileVO> getBakBaseFiles() {
            return this.bakBaseFiles;
        }

        public List<File> getFailDeleteFiles() {
            return this.failDeleteFiles;
        }
    }

    private class CAPTemplateFileCallable
    implements Callable<CAPTemplateFileFuture> {
        private String copyFromFolder;
        private CAPBusinessCustomTemplateVO capBusinessTemplateVO;
        private List<ConfigTemplateVO> configTemplateVOS;

        public CAPTemplateFileCallable(String copyFromFolder, CAPBusinessCustomTemplateVO capBusinessTemplateVO, List<ConfigTemplateVO> configTemplateVOS) {
            this.copyFromFolder = copyFromFolder;
            this.capBusinessTemplateVO = capBusinessTemplateVO;
            this.configTemplateVOS = configTemplateVOS;
        }

        @Override
        public CAPTemplateFileFuture call() throws IOException, BusinessException, InterruptedException {
            Object fromFrameFolder;
            ArrayList<CAPBusinessCustomFileVO> filesCopyToRuntime = new ArrayList<CAPBusinessCustomFileVO>();
            CAPTemplateFileFuture capTemplateFileFuture = new CAPTemplateFileFuture();
            Long folderId = this.capBusinessTemplateVO.getEggId();
            if (!this.capBusinessTemplateVO.getTemplateType().equals(CAPBusinessEnum.TemplateType.TP_BIZ_INDEX.getType())) {
                folderId = this.capBusinessTemplateVO.getPathId();
            }
            String copyToRootBaseFolder = CAPBusinessTemplateUtil.getBaseCustomTemplateTypeDataFolder(String.valueOf(folderId), this.capBusinessTemplateVO.getClient(), this.capBusinessTemplateVO.getTemplateType());
            if (this.capBusinessTemplateVO.getTemplateType().equals(CAPBusinessEnum.TemplateType.TP_BIZ_INDEX.getType()) && ((File)(fromFrameFolder = new File(this.copyFromFolder + File.separator + CAPDownloadManager4Template.KEY_FRAME_FOLDER))).exists()) {
                File toFrameFolder = new File(copyToRootBaseFolder + CAPDownloadManager4Template.KEY_FRAME_FOLDER);
                FileUtil.deleteDirectory((File)toFrameFolder);
                FileUtil.copyDirectory((File)fromFrameFolder, (File)toFrameFolder, (boolean)false);
                filesCopyToRuntime.add(new CAPBusinessCustomFileVO(toFrameFolder, false));
            }
            for (ConfigTemplateVO configTemplateVO : this.configTemplateVOS) {
                File copyFromTemplate;
                Long templateId = Long.valueOf(configTemplateVO.getTemplateId());
                String copyToBaseTemplateFolder = copyToRootBaseFolder;
                if (this.capBusinessTemplateVO.getTemplateType().equals(CAPBusinessEnum.TemplateType.TP_BIZ_INDEX.getType())) {
                    copyToBaseTemplateFolder = copyToBaseTemplateFolder + String.valueOf(templateId);
                    copyFromTemplate = new File(this.copyFromFolder + File.separator + configTemplateVO.getTemplateFolder());
                } else {
                    copyFromTemplate = this.capBusinessTemplateVO.getNoParentFolder() ? new File(this.copyFromFolder) : new File(this.copyFromFolder + File.separator + configTemplateVO.getTemplateFolder());
                }
                File copyToBaseTemplate = new File(copyToBaseTemplateFolder);
                File indexHtmlFile = new File(copyToBaseTemplate, "dist" + File.separator + CAPDownloadManager4Template.TEMPLATE_INDEX_HTML);
                File indexWapFile = new File(copyToBaseTemplate, "dist" + File.separator + "wap.html");
                if (copyToBaseTemplate.exists()) {
                    if (!this.capBusinessTemplateVO.getTemplateType().equals(CAPBusinessEnum.TemplateType.TP_BIZ_INDEX.getType())) {
                        File bakFile = new File(CAPBusinessTemplateUtil.getTemplateTempFolder() + File.separator + folderId + "_" + String.valueOf(UUIDLong.longUUID()));
                        FileUtil.copyDirectory((File)copyToBaseTemplate, (File)bakFile);
                        capTemplateFileFuture.getBakBaseFiles().add(new CAPBusinessCustomFileVO(bakFile, copyToBaseTemplate.getAbsolutePath(), true));
                    }
                    FileUtil.deleteFile((File)indexHtmlFile);
                    FileUtil.deleteFile((File)indexWapFile);
                    FileUtil.deleteDirectory((File)copyToBaseTemplate);
                }
                FileUtil.copyDirectory((File)copyFromTemplate, (File)copyToBaseTemplate, (boolean)false);
                filesCopyToRuntime.add(new CAPBusinessCustomFileVO(copyToBaseTemplate, true));
                capTemplateFileFuture.getFailDeleteFiles().add(copyToBaseTemplate);
                configTemplateVO.setTemplateFolder(configTemplateVO.getTemplateId());
                if (this.capBusinessTemplateVO.getTemplateType().equals(CAPBusinessEnum.TemplateType.TP_BIZ_INDEX.getType())) {
                    CAPBusinessUtil.writeBaseTemplateConfigJSON(this.capBusinessTemplateVO.getClient(), this.capBusinessTemplateVO.getTemplateType(), String.valueOf(templateId), configTemplateVO.exportToMap(), folderId);
                    continue;
                }
                CAPBusinessUtil.writeBaseTemplateConfigJSON(this.capBusinessTemplateVO.getClient(), this.capBusinessTemplateVO.getTemplateType(), String.valueOf(folderId), configTemplateVO.exportToMap(), null);
                this.rewriteIndexFileContent(indexHtmlFile);
                this.rewriteIndexFileContent(indexWapFile);
            }
            List<File> runtimeFiles = this.copyBaseToRuntime(this.capBusinessTemplateVO.getClient(), this.capBusinessTemplateVO.getTemplateType(), filesCopyToRuntime);
            capTemplateFileFuture.getFailDeleteFiles().addAll(runtimeFiles);
            filesCopyToRuntime.clear();
            if (this.capBusinessTemplateVO.getSleepTime() > 0L && !this.capBusinessTemplateVO.getTemplateType().equals(CAPBusinessEnum.TemplateType.TP_BIZ_INDEX.getType())) {
                Thread.sleep(this.capBusinessTemplateVO.getSleepTime());
            }
            return capTemplateFileFuture;
        }

        private void rewriteIndexFileContent(File file) {
            if (file.exists()) {
                String rnd = DateUtil.currentDateString((String)"yyyyMMddHHmmss");
                String fileContent = FileUtil.readFile((File)file);
                fileContent = fileContent.replace("</body>", "<!-- seeyon downtime " + rnd + " --></body>");
                FileUtil.writeFile((File)file, (String)fileContent);
            }
        }

        private List<File> copyBaseToRuntime(int clientType, int templateType, List<CAPBusinessCustomFileVO> baseFiles) throws IOException {
            ArrayList<File> runtimeFiles = new ArrayList<File>();
            if (baseFiles == null || baseFiles.isEmpty()) {
                return runtimeFiles;
            }
            String baseRoot = CAPBusinessTemplateUtil.getBaseCustomTemplateRootFolder(clientType);
            String runtimeRoot = CAPBusinessTemplateUtil.getRuntimeCustomTemplateRootFolder(clientType, templateType);
            for (CAPBusinessCustomFileVO vo : baseFiles) {
                String runtimePath = vo.getCopyFromFile().getAbsolutePath().replace(baseRoot, runtimeRoot);
                File runtimeFile = new File(runtimePath);
                if (vo.getDeleteToFile() && runtimeFile.exists()) {
                    FileUtil.deleteFile((File)new File(runtimeFile, "dist" + File.separator + CAPDownloadManager4Template.TEMPLATE_INDEX_HTML));
                    FileUtil.deleteDirectory((File)runtimeFile);
                }
                FileUtil.copyDirectory((File)vo.getCopyFromFile(), (File)runtimeFile, (boolean)false);
                if (!vo.getDeleteToFile()) continue;
                runtimeFiles.add(runtimeFile);
            }
            return runtimeFiles;
        }
    }
}

