/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.cap4.template.manager.impl;

import com.seeyon.cap4.form.bean.FormBean;
import com.seeyon.cap4.form.bean.FormFieldBean;
import com.seeyon.cap4.form.bean.FormFieldComEnum;
import com.seeyon.cap4.form.util.Enums;
import com.seeyon.cap4.template.bean.ExcelCellStyleBean;
import com.seeyon.cap4.template.bean.ExportTableBean;
import com.seeyon.cap4.template.manager.CAPExcelManager;
import com.seeyon.cap4.template.util.FileUtil;
import com.seeyon.cap4.template.vo.ExportFieldCellStyleVO;
import com.seeyon.cap4.template.vo.ExportFileVO;
import com.seeyon.cap4.template.vo.ExportSubTableDataVO;
import com.seeyon.cap4.template.vo.ExportTableLineDataVO;
import com.seeyon.ctp.common.AppContext;
import com.seeyon.ctp.common.SystemEnvironment;
import com.seeyon.ctp.common.constants.ApplicationCategoryEnum;
import com.seeyon.ctp.common.exceptions.BusinessException;
import com.seeyon.ctp.common.filemanager.manager.FileManager;
import com.seeyon.ctp.common.i18n.ResourceUtil;
import com.seeyon.ctp.common.log.CtpLogFactory;
import com.seeyon.ctp.common.po.filemanager.V3XFile;
import com.seeyon.ctp.common.security.SecurityHelper;
import com.seeyon.ctp.common.taglibs.functions.Functions;
import com.seeyon.ctp.util.DateUtil;
import com.seeyon.ctp.util.Strings;
import com.seeyon.ctp.util.UUIDLong;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.net.URLEncoder;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.DataFormat;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.IndexedColors;
import org.apache.poi.ss.usermodel.RichTextString;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.VerticalAlignment;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.xssf.streaming.SXSSFCell;
import org.apache.poi.xssf.streaming.SXSSFRow;
import org.apache.poi.xssf.streaming.SXSSFSheet;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;
import org.apache.poi.xssf.usermodel.XSSFRichTextString;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class CAPExcelManagerImpl
implements CAPExcelManager {
    private static final Log LOGGER = CtpLogFactory.getLog(CAPExcelManagerImpl.class);
    private static final int SHEET_NAME_LENGTH = 31;
    private static final int ROW_ACCESS_WINDOW_SIZE = 100;
    private static final String REPLACE_REGEX = "\\\\s*|\\:|\\\\|\\/|\\?|\\*|\\[|\\]";
    private static final String UNFLOW_EXCEL_TEMPLATE_PATH = "excelTempPath";
    private static final String REMARKS_TEMPLATE = "cap.form.batchOperation.remarksTemplate";
    private static final String ERROR_EXPLAIN = "cap.form.batchOperation.errorExplain";
    private FileManager fileManager;

    @Override
    public Workbook exportExcelFile(String titleName, FormBean formBean, ExportTableBean tableVO, Integer totalFieldSize, List<ExportTableLineDataVO> lineDataVOS, boolean hasErrorMessage) throws BusinessException {
        totalFieldSize = hasErrorMessage ? totalFieldSize + 1 : totalFieldSize;
        CellRangeAddress cellRangeAddress = new CellRangeAddress(0, 0, 0, 0);
        HashMap<Integer, ExportFieldCellStyleVO> fieldDataCellStyle = new HashMap<Integer, ExportFieldCellStyleVO>();
        SXSSFWorkbook sxssfWorkbook = new SXSSFWorkbook(-1);
        ExcelCellStyleBean cellStyleVO = this.getCellStyle((Workbook)sxssfWorkbook);
        SXSSFSheet firstSheet = sxssfWorkbook.createSheet(this.getSheetName(titleName, null));
        this.createCell((Row)firstSheet.createRow(0), 0, titleName, cellStyleVO.getTitleStyle());
        if (totalFieldSize > 1) {
            cellRangeAddress.setLastColumn(totalFieldSize - 1);
            firstSheet.addMergedRegionUnsafe(cellRangeAddress);
        }
        SXSSFRow secondRow = firstSheet.createRow(1);
        secondRow.setHeightInPoints(30.0f);
        String remarks = ResourceUtil.getStringByParams((String)REMARKS_TEMPLATE, (Object[])new Object[]{formBean.getFormName(), DateUtil.format((Date)new Date(), (String)"yyyy-MM-dd")});
        this.createCell((Row)secondRow, 0, (RichTextString)new XSSFRichTextString(remarks), cellStyleVO.getRemarksStyle());
        if (totalFieldSize > 1) {
            this.setCellRangeAddress(cellRangeAddress, 1, 1, 0, totalFieldSize - 1);
            firstSheet.addMergedRegionUnsafe(cellRangeAddress);
        }
        ArrayList<ExportTableBean> tableList = new ArrayList<ExportTableBean>();
        tableList.add(tableVO);
        this.createFieldTitleRow(firstSheet.createRow(2), tableList, cellStyleVO, fieldDataCellStyle, hasErrorMessage);
        Long startTime = System.currentTimeMillis();
        int rowStartIndex = tableList.size() > 1 ? 4 : 3;
        for (ExportTableLineDataVO lineDataVO : lineDataVOS) {
            int subMaxSize = 0;
            SXSSFRow row = firstSheet.createRow(rowStartIndex);
            int rowEndRow = rowStartIndex + subMaxSize - 1;
            int cellIndex = 0;
            List<Object> masterDataList = lineDataVO.getLineValueData();
            for (Object obj : masterDataList) {
                this.setCellStyleAndValue(row, fieldDataCellStyle, cellIndex, obj, hasErrorMessage);
                this.setCellRangeAddress(cellRangeAddress, rowStartIndex, rowEndRow, cellIndex, cellIndex);
                if (rowStartIndex < rowEndRow) {
                    firstSheet.addMergedRegionUnsafe(cellRangeAddress);
                }
                ++cellIndex;
            }
            if (hasErrorMessage && Strings.isNotBlank((String)lineDataVO.getError())) {
                this.createErrorCell((Workbook)sxssfWorkbook, row, cellIndex, lineDataVO.getError());
            }
            if (hasErrorMessage && rowStartIndex < rowEndRow) {
                this.setCellRangeAddress(cellRangeAddress, rowStartIndex, rowEndRow, cellIndex, cellIndex);
                firstSheet.addMergedRegionUnsafe(cellRangeAddress);
            }
            ++rowStartIndex;
        }
        LOGGER.info((Object)("write file use time " + (System.currentTimeMillis() - startTime) + " ms"));
        return sxssfWorkbook;
    }

    @Override
    public Workbook exportExcelFile(String titleName, FormBean formBean, List<ExportTableBean> tableList, Integer totalFieldSize, List<ExportTableLineDataVO> masterDatas, Map<String, ExportSubTableDataVO> subTableDataVOMap, boolean hasErrorMessage) throws BusinessException {
        long startTime = System.currentTimeMillis();
        if (hasErrorMessage && subTableDataVOMap != null) {
            totalFieldSize = totalFieldSize + tableList.size();
        } else if (hasErrorMessage && subTableDataVOMap == null) {
            totalFieldSize = totalFieldSize + 1;
        }
        CellRangeAddress cellRangeAddress = new CellRangeAddress(0, 0, 0, 0);
        HashMap<Integer, ExportFieldCellStyleVO> fieldDataCellStyle = new HashMap<Integer, ExportFieldCellStyleVO>();
        SXSSFWorkbook sxssfWorkbook = new SXSSFWorkbook(-1);
        ExcelCellStyleBean cellStyleVO = this.getCellStyle((Workbook)sxssfWorkbook);
        SXSSFSheet firstSheet = sxssfWorkbook.createSheet(this.getSheetName(titleName, null));
        this.createCell((Row)firstSheet.createRow(0), 0, titleName, cellStyleVO.getTitleStyle());
        if (totalFieldSize > 1) {
            cellRangeAddress.setLastColumn(totalFieldSize - 1);
            firstSheet.addMergedRegionUnsafe(cellRangeAddress);
        }
        SXSSFRow secondRow = firstSheet.createRow(1);
        secondRow.setHeightInPoints(30.0f);
        String remarks = ResourceUtil.getStringByParams((String)REMARKS_TEMPLATE, (Object[])new Object[]{formBean.getFormName(), DateUtil.format((Date)new Date(), (String)"yyyy-MM-dd")});
        this.createCell((Row)secondRow, 0, (RichTextString)new XSSFRichTextString(remarks), cellStyleVO.getRemarksStyle());
        if (totalFieldSize > 1) {
            this.setCellRangeAddress(cellRangeAddress, 1, 1, 0, totalFieldSize - 1);
            firstSheet.addMergedRegionUnsafe(cellRangeAddress);
        }
        Integer subTableTitleStartCell = 0;
        SXSSFRow thirdRow = firstSheet.createRow(2);
        SXSSFRow fourthRow = firstSheet.createRow(3);
        int tableListSize = tableList.size();
        for (ExportTableBean tableVO : tableList) {
            List<FormFieldBean> fieldList = tableVO.getFieldList();
            if (tableVO.isMainTable()) {
                subTableTitleStartCell = hasErrorMessage ? fieldList.size() + 1 : fieldList.size();
                for (int i = 0; i < fieldList.size(); ++i) {
                    FormFieldBean formFieldBean = fieldList.get(i);
                    this.setFieldDataCellStyle(fieldDataCellStyle, i, formFieldBean);
                    this.createCell((Row)thirdRow, i, formFieldBean.getDisplay(), cellStyleVO.getFieldStyle());
                    if (tableListSize <= 1) continue;
                    this.setCellRangeAddress(cellRangeAddress, 2, 3, i, i);
                    firstSheet.addMergedRegionUnsafe(cellRangeAddress);
                }
                if (!hasErrorMessage) continue;
                this.createCell((Row)thirdRow, fieldList.size(), ResourceUtil.getString((String)ERROR_EXPLAIN), cellStyleVO.getRedFieldStyle());
                if (tableListSize <= 1) continue;
                this.setCellRangeAddress(cellRangeAddress, 2, 3, fieldList.size(), fieldList.size());
                firstSheet.addMergedRegionUnsafe(cellRangeAddress);
                continue;
            }
            this.createCell((Row)thirdRow, (int)subTableTitleStartCell, tableVO.getDisplay(), cellStyleVO.getSubTableTitleStyle());
            Integer curretSubTableTitleLastCell = hasErrorMessage ? subTableTitleStartCell + fieldList.size() + 1 : subTableTitleStartCell + fieldList.size();
            if (fieldList.size() > 1) {
                this.setCellRangeAddress(cellRangeAddress, 2, 2, subTableTitleStartCell, curretSubTableTitleLastCell - 1);
                firstSheet.addMergedRegionUnsafe(cellRangeAddress);
            }
            for (int i = 0; i < fieldList.size(); ++i) {
                Integer currentCell = subTableTitleStartCell + i;
                FormFieldBean formFieldBean = fieldList.get(i);
                this.setFieldDataCellStyle(fieldDataCellStyle, currentCell, formFieldBean);
                this.createCell((Row)fourthRow, (int)currentCell, formFieldBean.getDisplay(), cellStyleVO.getFieldStyle());
            }
            if (hasErrorMessage) {
                this.createCell((Row)fourthRow, subTableTitleStartCell + fieldList.size(), ResourceUtil.getString((String)ERROR_EXPLAIN), cellStyleVO.getRedFieldStyle());
            }
            subTableTitleStartCell = curretSubTableTitleLastCell;
        }
        Long masterStartTime = System.currentTimeMillis();
        LOGGER.info((Object)("exportExcelFile write head use time " + (masterStartTime - startTime) + " ms"));
        int columnIndex = 0;
        HashMap<String, Integer> masterDataStartRowNum = new HashMap<String, Integer>();
        int rowStartIndex = tableList.size() > 1 ? 4 : 3;
        for (ExportTableLineDataVO lineDataVO : masterDatas) {
            String masterId = lineDataVO.getMasterId();
            masterDataStartRowNum.put(masterId, rowStartIndex);
            int subMaxSize = 0;
            for (Map.Entry<String, ExportSubTableDataVO> entry : subTableDataVOMap.entrySet()) {
                Map<String, Integer> dataSizeMap = entry.getValue().getDataSize();
                int dataSize = dataSizeMap.get(masterId) == null ? 1 : dataSizeMap.get(masterId);
                subMaxSize = dataSize > subMaxSize ? dataSize : subMaxSize;
            }
            SXSSFRow row = firstSheet.createRow(rowStartIndex);
            int rowEndRow = rowStartIndex + subMaxSize - 1;
            int cellIndex = 0;
            columnIndex = lineDataVO.getLineValueData().size();
            int j = lineDataVO.getLineValueData().size();
            for (int i = 0; i < j; ++i) {
                this.setCellStyleAndValue(row, fieldDataCellStyle, cellIndex, lineDataVO.getLineValueData().get(i), hasErrorMessage);
                this.setCellRangeAddress(cellRangeAddress, rowStartIndex, rowEndRow, cellIndex, cellIndex);
                if (rowStartIndex < rowEndRow) {
                    firstSheet.addMergedRegionUnsafe(cellRangeAddress);
                }
                ++cellIndex;
            }
            if (hasErrorMessage) {
                if (Strings.isNotBlank((String)lineDataVO.getError())) {
                    this.createErrorCell((Workbook)sxssfWorkbook, row, cellIndex, lineDataVO.getError());
                }
                if (rowStartIndex < rowEndRow) {
                    this.setCellRangeAddress(cellRangeAddress, rowStartIndex, rowEndRow, cellIndex, cellIndex);
                    firstSheet.addMergedRegionUnsafe(cellRangeAddress);
                }
                ++columnIndex;
            }
            if (subTableDataVOMap == null || subTableDataVOMap.isEmpty()) {
                ++rowStartIndex;
                continue;
            }
            rowStartIndex += subMaxSize;
        }
        LOGGER.info((Object)("exportExcelFile write master use time " + (System.currentTimeMillis() - masterStartTime) + " ms"));
        Long subStartTime = System.currentTimeMillis();
        int j = tableList.size();
        for (int i = 1; i < j; ++i) {
            String tableName = String.valueOf(tableList.get(i).getTableName());
            ExportSubTableDataVO tableDataVO = subTableDataVOMap.get(tableName);
            if (tableDataVO == null) continue;
            for (Map.Entry<String, List<ExportTableLineDataVO>> entry : tableDataVO.getDataList().entrySet()) {
                List<ExportTableLineDataVO> lineDataVOS = entry.getValue();
                HashMap<String, Integer> currentSubDataLineIndex = new HashMap<String, Integer>();
                for (ExportTableLineDataVO lineDataVO : lineDataVOS) {
                    Integer subRowNum;
                    String masterId = lineDataVO.getMasterId();
                    Integer n = subRowNum = currentSubDataLineIndex.get(masterId) == null ? (Integer)masterDataStartRowNum.get(masterId) : (Integer)currentSubDataLineIndex.get(masterId);
                    if (subRowNum == null) continue;
                    int subStartColumnIndex = columnIndex;
                    List<Object> oneLineData = lineDataVO.getLineValueData();
                    SXSSFRow row = firstSheet.getRow(subRowNum.intValue());
                    if (row == null) {
                        row = firstSheet.createRow(subRowNum.intValue());
                    }
                    for (Object object2 : oneLineData) {
                        this.setCellStyleAndValue(row, fieldDataCellStyle, subStartColumnIndex, object2, hasErrorMessage);
                        ++subStartColumnIndex;
                    }
                    if (hasErrorMessage && Strings.isNotBlank((String)lineDataVO.getError())) {
                        this.createErrorCell((Workbook)sxssfWorkbook, row, subStartColumnIndex, lineDataVO.getError());
                    }
                    Integer n2 = subRowNum;
                    Integer n3 = subRowNum = Integer.valueOf(subRowNum + 1);
                    currentSubDataLineIndex.put(masterId, subRowNum);
                }
            }
            int fieldSize = tableList.get(i).getFieldList().size();
            columnIndex += hasErrorMessage ? fieldSize + 1 : fieldSize;
        }
        LOGGER.info((Object)("exportExcelFile write sub use time " + (System.currentTimeMillis() - subStartTime) + " ms"));
        return sxssfWorkbook;
    }

    @Override
    public Workbook exportPromptFile(FormBean formBean, String titleName, String errorInfo) throws BusinessException {
        SXSSFWorkbook sxssfWorkbook = new SXSSFWorkbook(100);
        ExcelCellStyleBean cellStyleVO = this.getCellStyle((Workbook)sxssfWorkbook);
        SXSSFSheet firstSheet = sxssfWorkbook.createSheet(this.getSheetName(titleName, null));
        int width = 0;
        try {
            width = errorInfo.getBytes("utf-8").length;
        }
        catch (UnsupportedEncodingException e) {
            throw new BusinessException((Throwable)e);
        }
        firstSheet.setColumnWidth(0, (width > 256 ? 256 : width) * 256);
        this.createCell((Row)firstSheet.createRow(0), 0, titleName, cellStyleVO.getTitleStyle());
        SXSSFRow secondRow = firstSheet.createRow(1);
        secondRow.setHeightInPoints(30.0f);
        String remarks = ResourceUtil.getStringByParams((String)REMARKS_TEMPLATE, (Object[])new Object[]{formBean.getFormName(), DateUtil.format((Date)new Date(), (String)"yyyy-MM-dd")});
        this.createCell((Row)secondRow, 0, (RichTextString)new XSSFRichTextString(remarks), cellStyleVO.getRemarksStyle());
        this.createErrorCell((Workbook)sxssfWorkbook, firstSheet.createRow(2), 0, errorInfo);
        return sxssfWorkbook;
    }

    @Override
    public void createErrorCell(Workbook workbook, SXSSFRow row, int columnIndex, String value) {
        CellStyle cellStyle = workbook.createCellStyle();
        Font redFieldFont = workbook.createFont();
        redFieldFont.setColor(IndexedColors.RED.getIndex());
        cellStyle.setFont(redFieldFont);
        cellStyle.setVerticalAlignment(VerticalAlignment.CENTER);
        this.createCell((Row)row, columnIndex, value, cellStyle);
    }

    @Override
    public void createCell(Row row, int columnIndex, RichTextString value, CellStyle cellStyle) {
        Cell thirdCell = row.createCell(columnIndex);
        thirdCell.setCellValue(value);
        thirdCell.setCellStyle(cellStyle);
    }

    @Override
    public void createCell(Row row, int columnIndex, String value, CellStyle cellStyle) {
        Cell thirdCell = row.createCell(columnIndex);
        thirdCell.setCellValue(value);
        thirdCell.setCellStyle(cellStyle);
    }

    @Override
    public void createFieldTitleRow(SXSSFRow row, List<ExportTableBean> tableVOS, ExcelCellStyleBean cellStyleVO, Map<Integer, ExportFieldCellStyleVO> fieldDataCellStyle, boolean hasErrorMessage) {
        for (ExportTableBean tableInfo : tableVOS) {
            List<FormFieldBean> fieldList = tableInfo.getFieldList();
            if (CollectionUtils.isEmpty(fieldList)) continue;
            for (int i = 0; i < fieldList.size(); ++i) {
                FormFieldBean formFieldBean = fieldList.get(i);
                this.setFieldDataCellStyle(fieldDataCellStyle, i, formFieldBean);
                this.createCell((Row)row, i, formFieldBean.getDisplay(), cellStyleVO.getFieldStyle());
            }
            if (!hasErrorMessage) continue;
            this.createCell((Row)row, fieldList.size(), ResourceUtil.getString((String)ERROR_EXPLAIN), cellStyleVO.getRedFieldStyle());
        }
    }

    @Override
    public String getSheetName(String sheetName, String sheetNameExpansionNum) {
        String result = "_" + UUIDLong.longUUID();
        if (Strings.isNotBlank((String)sheetName)) {
            sheetNameExpansionNum = sheetNameExpansionNum == null ? "" : sheetNameExpansionNum;
            Matcher matcher = Pattern.compile(REPLACE_REGEX).matcher(sheetName);
            sheetName = matcher.replaceAll("");
            if (sheetName.length() > 31 - sheetNameExpansionNum.length()) {
                sheetName = sheetName.substring(0, 31 - sheetNameExpansionNum.length());
            }
            result = sheetName = sheetName + sheetNameExpansionNum;
        }
        return result;
    }

    @Override
    public void setFieldDataCellStyle(Map<Integer, ExportFieldCellStyleVO> fieldDataCellStyle, Integer currentCell, FormFieldBean formFieldBean) {
        ExportFieldCellStyleVO vo = this.getFieldCellStyle(formFieldBean);
        if (vo.getFormatStyle() != null) {
            fieldDataCellStyle.put(currentCell, vo);
        }
    }

    @Override
    public ExportFieldCellStyleVO getFieldCellStyle(FormFieldBean formFieldBean) {
        ExportFieldCellStyleVO vo = new ExportFieldCellStyleVO(formFieldBean);
        DecimalFormat decimalFormat = null;
        FormFieldComEnum formFieldComEnum = formFieldBean.getInputTypeEnum();
        switch (formFieldComEnum) {
            case TEXT: {
                if (!Enums.FieldType.DECIMAL.getKey().equals(formFieldBean.getFieldType())) break;
                String digitNum = formFieldBean.getDigitNum();
                String formatType = formFieldBean.getFormatType();
                if ("##,###,###0".equalsIgnoreCase(formatType)) {
                    formatType = formatType.substring(0, formatType.length() - 1);
                    StringBuilder formatTypeSb = new StringBuilder(formatType);
                    if (Strings.isNotBlank((String)digitNum) && !"0".equals(digitNum)) {
                        formatTypeSb.append(".");
                        int digitNumInt = Integer.parseInt(digitNum);
                        for (int i = 0; i < digitNumInt; ++i) {
                            formatTypeSb.append("0");
                        }
                    }
                    decimalFormat = new DecimalFormat(formatTypeSb.toString());
                    break;
                }
                if (!"%".equalsIgnoreCase(formatType) && !Strings.isBlank((String)formatType)) break;
                StringBuilder formatTypeSb = new StringBuilder("0");
                if (Strings.isNotBlank((String)digitNum) && !"0".equals(digitNum)) {
                    int digitNumInt = Integer.parseInt(digitNum);
                    if ("%".equalsIgnoreCase(formatType)) {
                        digitNumInt -= 2;
                    }
                    if (digitNumInt > 0) {
                        formatTypeSb.append(".");
                        for (int i = 0; i < digitNumInt; ++i) {
                            formatTypeSb.append("0");
                        }
                    }
                }
                formatTypeSb.append(formatType);
                decimalFormat = new DecimalFormat(formatTypeSb.toString());
                break;
            }
        }
        vo.setFormatStyle(decimalFormat);
        return vo;
    }

    @Override
    public void setCellStyleAndValue(SXSSFRow row, Map<Integer, ExportFieldCellStyleVO> fieldDataCellStyle, Integer cellIndex, Object value, boolean hasErrorMessage) {
        ExportFieldCellStyleVO fieldCellStyleVO = fieldDataCellStyle.get(cellIndex);
        String stringValue = String.valueOf(value);
        if (fieldCellStyleVO != null && fieldCellStyleVO.getFormatStyle() != null && !hasErrorMessage) {
            SXSSFCell cell = row.createCell(cellIndex.intValue());
            DecimalFormat decimalFormat = (DecimalFormat)fieldCellStyleVO.getFormatStyle();
            if (Strings.isNotBlank((String)stringValue)) {
                String formatType = fieldCellStyleVO.getFormatType();
                if (FormFieldComEnum.TEXT.getKey().equalsIgnoreCase(fieldCellStyleVO.getInputType()) && Enums.FieldType.DECIMAL.getKey().equalsIgnoreCase(fieldCellStyleVO.getFieldType()) && (Strings.isBlank((String)formatType) || "##,###,###0".equalsIgnoreCase(formatType) || "%".equalsIgnoreCase(formatType))) {
                    cell.setCellValue("*".equals(stringValue) || "***".equals(stringValue) ? stringValue : decimalFormat.format(new BigDecimal(stringValue)));
                } else {
                    cell.setCellValue(stringValue);
                }
            }
        } else if (Strings.isNotBlank((String)stringValue)) {
            SXSSFCell cell = row.createCell(cellIndex.intValue());
            cell.setCellValue(stringValue);
        }
    }

    @Override
    public void setCellRangeAddress(CellRangeAddress cellRangeAddress, int firstRow, int lastRow, int firstColumn, int lastColumn) {
        cellRangeAddress.setFirstRow(firstRow);
        cellRangeAddress.setLastRow(lastRow);
        cellRangeAddress.setFirstColumn(firstColumn);
        cellRangeAddress.setLastColumn(lastColumn);
    }

    @Override
    public ExcelCellStyleBean getCellStyle(Workbook workbook) {
        CellStyle titleCellStyle = workbook.createCellStyle();
        Font titleFont = workbook.createFont();
        titleFont.setBold(true);
        titleFont.setFontHeightInPoints((short)14);
        titleCellStyle.setFont(titleFont);
        titleCellStyle.setAlignment(HorizontalAlignment.CENTER);
        titleCellStyle.setVerticalAlignment(VerticalAlignment.CENTER);
        CellStyle fieldCellStyle = workbook.createCellStyle();
        Font fieldFont = workbook.createFont();
        fieldFont.setBold(true);
        fieldFont.setFontHeightInPoints((short)10);
        fieldCellStyle.setFont(fieldFont);
        fieldCellStyle.setAlignment(HorizontalAlignment.CENTER);
        fieldCellStyle.setVerticalAlignment(VerticalAlignment.CENTER);
        CellStyle redFieldCellStyle = workbook.createCellStyle();
        Font redFieldFont = workbook.createFont();
        redFieldFont.setBold(true);
        redFieldFont.setFontHeightInPoints((short)10);
        redFieldFont.setColor(IndexedColors.RED.getIndex());
        redFieldCellStyle.setFont(redFieldFont);
        redFieldCellStyle.setAlignment(HorizontalAlignment.CENTER);
        redFieldCellStyle.setVerticalAlignment(VerticalAlignment.CENTER);
        CellStyle subTableTitleCellStyle = workbook.createCellStyle();
        Font subTableTitleFont = workbook.createFont();
        subTableTitleFont.setBold(true);
        subTableTitleFont.setFontHeightInPoints((short)12);
        subTableTitleCellStyle.setFont(subTableTitleFont);
        subTableTitleCellStyle.setAlignment(HorizontalAlignment.CENTER);
        subTableTitleCellStyle.setVerticalAlignment(VerticalAlignment.CENTER);
        CellStyle remarksCellStyle = workbook.createCellStyle();
        Font remarksFont = workbook.createFont();
        remarksFont.setFontHeightInPoints((short)10);
        remarksCellStyle.setFont(remarksFont);
        remarksCellStyle.setVerticalAlignment(VerticalAlignment.CENTER);
        remarksCellStyle.setWrapText(true);
        CellStyle textCellStyle = workbook.createCellStyle();
        DataFormat format = workbook.createDataFormat();
        textCellStyle.setDataFormat(format.getFormat("@"));
        ExcelCellStyleBean styleVO = new ExcelCellStyleBean();
        styleVO.setTitleStyle(titleCellStyle);
        styleVO.setFieldStyle(fieldCellStyle);
        styleVO.setRedFieldStyle(redFieldCellStyle);
        styleVO.setRemarksStyle(remarksCellStyle);
        styleVO.setTextStyle(textCellStyle);
        styleVO.setSubTableTitleStyle(subTableTitleCellStyle);
        return styleVO;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void saveExcel(ExportFileVO fileVO, Workbook workbook) throws BusinessException {
        FileOutputStream fos = null;
        try {
            String fileName = fileVO.getFileName();
            if (Strings.isNotBlank((String)fileName) && fileName.length() > 20) {
                fileName = fileName.substring(0, 20);
            }
            String fileType = workbook instanceof SXSSFWorkbook ? ".xlsx" : ".xls";
            fileName = fileName + fileType;
            String path = SystemEnvironment.getBaseFolder() + File.separator + UNFLOW_EXCEL_TEMPLATE_PATH;
            File file = new File(path);
            if (!file.exists()) {
                file.mkdirs();
            }
            File tempFile = new File(path + File.separator + UUIDLong.longUUID() + fileType);
            fos = new FileOutputStream(tempFile);
            workbook.write((OutputStream)fos);
            if (tempFile.exists()) {
                V3XFile v3XFile = this.fileManager.save(tempFile, ApplicationCategoryEnum.doc, fileName, DateUtil.currentDate(), Boolean.valueOf(true));
                StringBuilder sb = new StringBuilder();
                sb.append("/fileUpload.do?method=download&fileId=").append(String.valueOf(v3XFile.getId())).append("&createDate=").append(DateUtil.format((Date)v3XFile.getCreateDate())).append("&v=").append(SecurityHelper.digest((Object[])new Object[]{String.valueOf(v3XFile.getId())})).append("&filename=").append(URLEncoder.encode(fileName, "UTF-8")).append(Functions.csrfSuffix());
                fileVO.setUrl(sb.toString());
                fileVO.setFileName(fileName);
                FileUtil.deleteFile((File)tempFile);
            }
        }
        catch (FileNotFoundException e) {
            try {
                throw new BusinessException((Throwable)e);
                catch (IOException e2) {
                    throw new BusinessException((Throwable)e2);
                }
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(fos);
                try {
                    if (workbook == null) throw throwable;
                    workbook.close();
                    throw throwable;
                }
                catch (IOException e3) {
                    LOGGER.error((Object)e3.getMessage());
                }
                throw throwable;
            }
        }
        IOUtils.closeQuietly((OutputStream)fos);
        try {
            if (workbook == null) return;
            workbook.close();
            return;
        }
        catch (IOException e) {
            LOGGER.error((Object)e.getMessage());
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void downloadExcel(Workbook excel, String title, HttpServletResponse response) {
        ServletOutputStream out = null;
        try {
            String targetName;
            out = response.getOutputStream();
            if (excel == null) {
                throw new IllegalArgumentException();
            }
            response.setContentType("application/vnd.ms-excel");
            if (!(excel instanceof XSSFWorkbook) && !(excel instanceof SXSSFWorkbook)) {
                targetName = com.seeyon.ctp.util.FileUtil.getDownloadFileName((HttpServletRequest)AppContext.getRawRequest(), (String)(title + ".xls"));
                response.setHeader("Content-disposition", "attachment;" + targetName);
            } else {
                targetName = com.seeyon.ctp.util.FileUtil.getDownloadFileName((HttpServletRequest)AppContext.getRawRequest(), (String)(title + ".xlsx"));
                response.setHeader("Content-disposition", "attachment;" + targetName);
            }
            excel.write((OutputStream)out);
            excel.close();
            out.flush();
        }
        catch (Throwable var8) {
            if (!"ClientAbortException".equals(var8.getClass().getSimpleName())) {
                LOGGER.error((Object)"\u5bfc\u51faexcel\u51fa\u73b0\u81f4\u547d\u9519\u8bef\uff01", var8);
            }
        }
        finally {
            IOUtils.closeQuietly((OutputStream)out);
            try {
                if (excel != null) {
                    excel.close();
                }
            }
            catch (IOException e) {
                LOGGER.error((Object)e.getMessage());
            }
        }
    }

    public void setFileManager(FileManager fileManager) {
        this.fileManager = fileManager;
    }
}

