/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.cap4.template.manager.impl;

import com.seeyon.cap4.form.bean.FormBean;
import com.seeyon.cap4.form.bean.FormBindAuthBean;
import com.seeyon.cap4.form.bean.FormFieldBean;
import com.seeyon.cap4.form.bean.FormTableBean;
import com.seeyon.cap4.form.bean.SimpleObjectBean;
import com.seeyon.cap4.form.modules.engin.base.formData.CAP4FormDataDAO;
import com.seeyon.cap4.form.util.Enums;
import com.seeyon.cap4.template.annotation.JMCalling4Service;
import com.seeyon.cap4.template.annotation.ParamClass;
import com.seeyon.cap4.template.bean.ExcelCellStyleBean;
import com.seeyon.cap4.template.bean.ExportFormDataParamBean;
import com.seeyon.cap4.template.bean.ExportTableBean;
import com.seeyon.cap4.template.bean.FormDataListFormatBean;
import com.seeyon.cap4.template.bean.FormDataListParamBean;
import com.seeyon.cap4.template.constant.CAPBusinessEnum;
import com.seeyon.cap4.template.event.CAPBatchOperationLogEvent;
import com.seeyon.cap4.template.manager.CAPDataListSqlHelpManager;
import com.seeyon.cap4.template.manager.CAPFilterFieldManager;
import com.seeyon.cap4.template.manager.CAPUnFlowFormatManager;
import com.seeyon.cap4.template.manager.CAPUnFlowManager;
import com.seeyon.cap4.template.manager.impl.AbstractCAPExportManager;
import com.seeyon.cap4.template.vo.ExportFieldCellStyleVO;
import com.seeyon.cap4.template.vo.ExportFileVO;
import com.seeyon.cap4.template.vo.ExportSubTableDataVO;
import com.seeyon.cap4.template.vo.ExportTableLineDataVO;
import com.seeyon.cap4.template.vo.ExportWorkBookVO;
import com.seeyon.cap4.template.vo.ListVO;
import com.seeyon.ctp.common.AppContext;
import com.seeyon.ctp.common.exceptions.BusinessException;
import com.seeyon.ctp.common.i18n.ResourceUtil;
import com.seeyon.ctp.common.log.CtpLogFactory;
import com.seeyon.ctp.event.Event;
import com.seeyon.ctp.event.EventDispatcher;
import com.seeyon.ctp.util.DateUtil;
import com.seeyon.ctp.util.StringUtil;
import com.seeyon.ctp.util.Strings;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.poi.ss.usermodel.RichTextString;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.xssf.streaming.SXSSFRow;
import org.apache.poi.xssf.streaming.SXSSFSheet;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;
import org.apache.poi.xssf.usermodel.XSSFRichTextString;

@ParamClass(clazz=ExportFormDataParamBean.class)
public class CAPExportManager4FormData
extends AbstractCAPExportManager<ExportFormDataParamBean, Workbook> {
    private static final Log LOGGER = CtpLogFactory.getLog(CAPExportManager4FormData.class);
    private static final int EXPORT_PAGE_SIZE = 900;
    private static final int ROW_ACCESS_WINDOW_SIZE = 100;
    private static final int SHEET_MAX_ROW = 90000;
    private static final String REMARKS_TEMPLATE = "cap.form.batchOperation.remarksTemplate";
    protected CAP4FormDataDAO cap4FormDataDAO;
    private CAPFilterFieldManager capFilterFieldManager;
    private CAPUnFlowManager capUnFlowManager;
    private CAPDataListSqlHelpManager capDataListSqlHelpManager;
    private CAPUnFlowFormatManager capUnFlowFormatManager;

    @Override
    public String getType() {
        return CAPBusinessEnum.BatchOperationEnum.EXPORT_DATA.getKey();
    }

    @Override
    @JMCalling4Service(batchRunType=CAPBusinessEnum.BatchOperationEnum.EXPORT_DATA)
    public Workbook export(ExportFormDataParamBean bean, ExportFileVO fileVO) throws BusinessException {
        return this.exportFile(bean, fileVO);
    }

    private Workbook exportFile(ExportFormDataParamBean bean, ExportFileVO fileVO) throws BusinessException {
        SXSSFWorkbook workbook;
        FormBean formBean = this.cap4FormCacheManager.getForm(bean.getFormId());
        FormBindAuthBean formBindAuthBean = formBean.getBind().getFormBindAuthBean(String.valueOf(bean.getBindId()));
        List subFormTableBeans = formBean.getSubTableBean();
        String bindAuthStr = formBindAuthBean.getAuthObjByName(FormBindAuthBean.AuthName.BROWSE.getKey()).getValue();
        if (fileVO != null) {
            fileVO.setFileName(formBindAuthBean.getName());
        }
        long startTime = System.currentTimeMillis();
        String logStart = AppContext.currentUserName() + ",\u6267\u884c\u5bfc\u51fa:" + startTime + ",";
        List<FormFieldBean> validFieldBeans = this.getExportFieldBeans(formBean, formBindAuthBean.getShowFieldList());
        Map<String, List<FormFieldBean>> subValidFieldBeanMap = this.getExportSubTableFieldBeans(subFormTableBeans);
        FormDataListParamBean listParamBean = new FormDataListParamBean();
        listParamBean.setFormId(formBean.getId());
        listParamBean.setFormTemplateId(formBindAuthBean.getId());
        listParamBean.setUserOrderBy(bean.getUserOrderBy());
        listParamBean.setUserConditions(bean.getUserConditions());
        listParamBean.setDataConditions(bean.getDataConditions());
        listParamBean.setQueryType(CAPBusinessEnum.DataListTypeEnum.UN_FLOW.getValue());
        listParamBean.setForExport(true);
        List<ExportTableBean> tableList = this.getExportTableVOs(formBean, validFieldBeans, subValidFieldBeanMap);
        int totalFieldSize = 0;
        for (ExportTableBean tableVO : tableList) {
            totalFieldSize += tableVO.getFieldList().size();
        }
        try {
            long headStartTime = System.currentTimeMillis();
            ExportWorkBookVO workBookVO = this.createExcelHead(formBean, formBindAuthBean.getName(), tableList, totalFieldSize, false);
            LOGGER.info((Object)(logStart + "createExcelHead use " + (System.currentTimeMillis() - headStartTime)));
            FormDataListFormatBean formatBean = new FormDataListFormatBean();
            formatBean.setRightId(bindAuthStr);
            formatBean.setForExport(true);
            int totalCount = bean.getSize();
            int pageCount = totalCount % 900 == 0 ? totalCount / 900 : totalCount / 900 + 1;
            for (int j = 1; j <= pageCount; ++j) {
                long s1 = System.currentTimeMillis();
                listParamBean.setPage(j);
                listParamBean.setPageSize(900);
                ListVO listVO = (ListVO)this.capUnFlowManager.getList(listParamBean);
                if (CollectionUtils.isEmpty(listVO.getDatas())) continue;
                ArrayList<ExportTableLineDataVO> tableLineDataVOS = new ArrayList<ExportTableLineDataVO>();
                List<Map<String, Object>> masterDataLists = listVO.getDatas();
                int dataSize = masterDataLists.size();
                HashSet<Long> masterIds = new HashSet<Long>(dataSize);
                for (Map<String, Object> map : masterDataLists) {
                    ArrayList<Object> dataList = new ArrayList<Object>();
                    for (FormFieldBean formFieldBean : validFieldBeans) {
                        dataList.add(map.get(formFieldBean.getName()) == null ? "" : String.valueOf(map.get(formFieldBean.getName())));
                    }
                    String masterId = String.valueOf(map.get(Enums.MasterTableField.id.getKey()));
                    tableLineDataVOS.add(new ExportTableLineDataVO(dataList, masterId));
                    masterIds.add(Long.valueOf(masterId));
                }
                HashMap<String, ExportSubTableDataVO> subTableDataVOMap = new HashMap<String, ExportSubTableDataVO>();
                for (FormTableBean subTableBean : subFormTableBeans) {
                    LOGGER.info((Object)(logStart + " \u5f00\u59cb\u5904\u7406\u660e\u7ec6\u8868 " + j + " " + subTableBean.getTableName()));
                    List<FormFieldBean> formFieldBeans = subValidFieldBeanMap.get(subTableBean.getTableName());
                    if (Strings.isEmpty(formFieldBeans)) {
                        LOGGER.error((Object)(logStart + "method exportUnFlowData \u660e\u7ec6\u8868" + subTableBean.getTableName() + "\u65e0\u5b57\u6bb5\u663e\u793a\uff0c\u5ffd\u7565\u8fd9\u6b21\u67e5\u8be2."));
                        continue;
                    }
                    List<Map<String, Object>> formSlaveDataList = this.selectSubDataList(subTableBean.getTableName(), formFieldBeans, masterIds);
                    long sonQueryEndTime = System.currentTimeMillis();
                    List<Map<String, Object>> newFormSlaveDataList = this.capUnFlowFormatManager.format(formBean, formSlaveDataList, formatBean);
                    LOGGER.info((Object)(logStart + " \u5904\u7406\u660e\u7ec6\u8868\u6570\u636eformatData " + j + " " + subTableBean.getTableName() + " use " + (System.currentTimeMillis() - sonQueryEndTime)));
                    ExportSubTableDataVO subTableDataVO = this.convertSlaveData(newFormSlaveDataList, subValidFieldBeanMap.get(subTableBean.getTableName()));
                    subTableDataVOMap.put(subTableBean.getTableName(), subTableDataVO);
                    LOGGER.info((Object)(logStart + " \u7ed3\u675f\u5904\u7406\u660e\u7ec6\u8868 " + j + " " + subTableBean.getTableName()));
                }
                long l = System.currentTimeMillis();
                this.writeExcelData(workBookVO, tableList, tableLineDataVOS, subTableDataVOMap, false);
                LOGGER.info((Object)(logStart + "\u5355\u6b21writeExcelData " + j + " use\uff1a" + (System.currentTimeMillis() - l)));
                LOGGER.info((Object)(logStart + "\u5355\u6b21\u5199\u5165\u6570\u636e " + j + " all use\uff1a" + (System.currentTimeMillis() - s1)));
            }
            EventDispatcher.fireEvent((Event)new CAPBatchOperationLogEvent(this, formBean.getId(), totalCount, 0, Enums.CapLogType.EXPORTEXCEL));
            workbook = workBookVO.getSxssfWorkbook();
            LOGGER.info((Object)(logStart + "\u603b\u5199excel\u65f6\u95f4\uff1a" + (System.currentTimeMillis() - startTime)));
        }
        catch (BusinessException e) {
            LOGGER.error((Object)"CAPBatchOperationService.exportUnFlowData.BusinessException", (Throwable)e);
            EventDispatcher.fireEvent((Event)new CAPBatchOperationLogEvent(this, formBean.getId(), 0, 0, Enums.CapLogType.EXPORTEXCEL));
            e.setCode("3002");
            throw e;
        }
        return workbook;
    }

    private List<Map<String, Object>> selectSubDataList(String tableName, List<FormFieldBean> formFieldBeans, Set<Long> masterIds) throws BusinessException {
        List list;
        String[] returnFields = new String[formFieldBeans.size() + 2];
        returnFields[0] = Enums.SubTableField.id.getKey();
        returnFields[1] = Enums.SubTableField.formmain_id.getKey();
        int i = 2;
        for (FormFieldBean formFieldBean : formFieldBeans) {
            returnFields[i] = formFieldBean.getName();
            ++i;
        }
        StringBuilder sql = new StringBuilder("SELECT ").append(StringUtil.arrayToString((String[])returnFields)).append(" FROM ").append(tableName);
        sql.append(" WHERE ").append(Enums.SubTableField.formmain_id.getKey()).append(" IN ( ");
        sql.append(StringUtils.join(masterIds, (String)","));
        sql.append(" ) ORDER BY ").append(Enums.SubTableField.formmain_id.getKey()).append(" ASC, ").append(Enums.SubTableField.sort.getKey()).append(" ASC");
        try {
            list = this.capDataListSqlHelpManager.selectDataList(sql.toString(), null);
        }
        catch (SQLException e) {
            throw new BusinessException((Throwable)e);
        }
        return list;
    }

    private ExportSubTableDataVO convertSlaveData(List<Map<String, Object>> formDataList, List<FormFieldBean> showFieldList) {
        ExportSubTableDataVO dataVO = new ExportSubTableDataVO();
        for (Map<String, Object> lineValues : formDataList) {
            String masterId = String.valueOf(lineValues.get(Enums.SubTableField.formmain_id.getKey()));
            ArrayList<Object> lineValueData = new ArrayList<Object>();
            for (FormFieldBean formFieldBean : showFieldList) {
                lineValueData.add(lineValues.get(formFieldBean.getName()));
            }
            dataVO.getDataSize().put(masterId, dataVO.getDataSize().get(masterId) == null ? 1 : dataVO.getDataSize().get(masterId) + 1);
            List<ExportTableLineDataVO> masterData = dataVO.getDataList().get(masterId);
            if (masterData == null) {
                masterData = new ArrayList<ExportTableLineDataVO>();
            }
            masterData.add(new ExportTableLineDataVO(lineValueData, masterId));
            dataVO.getDataList().put(masterId, masterData);
        }
        return dataVO;
    }

    private void writeExcelData(ExportWorkBookVO bookVO, List<ExportTableBean> tableList, List<ExportTableLineDataVO> masterDatas, Map<String, ExportSubTableDataVO> subDatas, boolean hasErrorMessage) throws BusinessException {
        SXSSFWorkbook sxssfWorkbook = bookVO.getSxssfWorkbook();
        SXSSFSheet sxssfSheet = bookVO.getSxssfSheet();
        Map<Integer, ExportFieldCellStyleVO> fieldDataCellStyle = bookVO.getFieldDataCellStyle();
        Map<String, Integer> subTableStartColumn = bookVO.getSubTableStartColumn();
        CellRangeAddress cellRangeAddress = new CellRangeAddress(0, 0, 0, 0);
        int rowStartIndex = bookVO.getRowStartIndex() == null ? (tableList.size() > 1 ? 4 : 3) : bookVO.getRowStartIndex();
        for (ExportTableLineDataVO tableLineDataVO : masterDatas) {
            String masterId = tableLineDataVO.getMasterId();
            int subMaxSize = 0;
            if (subDatas != null) {
                for (Map.Entry<String, ExportSubTableDataVO> entry : subDatas.entrySet()) {
                    ExportSubTableDataVO subTableDataVO = entry.getValue();
                    int dataSize = subTableDataVO.getDataSize().get(masterId) == null ? 1 : subTableDataVO.getDataSize().get(masterId);
                    subMaxSize = dataSize > subMaxSize ? dataSize : subMaxSize;
                }
            }
            if (rowStartIndex + subMaxSize > 90000) {
                SXSSFSheet sheet = sxssfWorkbook.createSheet(this.capExcelManager.getSheetName(sxssfSheet.getSheetName(), "1"));
                bookVO.setSxssfSheet(sheet);
                bookVO.setRowStartIndex(0);
                sxssfSheet = sheet;
                rowStartIndex = this.writeOneLineData(tableList, subDatas, hasErrorMessage, sxssfWorkbook, sheet, fieldDataCellStyle, subTableStartColumn, cellRangeAddress, 0, tableLineDataVO, subMaxSize);
                continue;
            }
            rowStartIndex = this.writeOneLineData(tableList, subDatas, hasErrorMessage, sxssfWorkbook, sxssfSheet, fieldDataCellStyle, subTableStartColumn, cellRangeAddress, rowStartIndex, tableLineDataVO, subMaxSize);
        }
        bookVO.setSxssfSheet(sxssfSheet);
        bookVO.setRowStartIndex(rowStartIndex);
    }

    private int writeOneLineData(List<ExportTableBean> tableList, Map<String, ExportSubTableDataVO> subDatas, boolean hasErrorMessage, SXSSFWorkbook sxssfWorkbook, SXSSFSheet sxssfSheet, Map<Integer, ExportFieldCellStyleVO> fieldDataCellStyle, Map<String, Integer> subTableStartColumn, CellRangeAddress cellRangeAddress, int rowStartIndex, ExportTableLineDataVO tableLineDataVO, int subMaxSize) {
        int i;
        String masterId = tableLineDataVO.getMasterId();
        sxssfSheet.setRandomAccessWindowSize(subMaxSize == 0 ? 100 : subMaxSize);
        SXSSFRow row = sxssfSheet.createRow(rowStartIndex);
        int rowEndRow = rowStartIndex + subMaxSize - 1;
        int cellIndex = 0;
        List<Object> masterDataList = tableLineDataVO.getLineValueData();
        int j = masterDataList.size();
        for (i = 0; i < j; ++i) {
            this.capExcelManager.setCellStyleAndValue(row, fieldDataCellStyle, cellIndex, masterDataList.get(i), hasErrorMessage);
            this.capExcelManager.setCellRangeAddress(cellRangeAddress, rowStartIndex, rowEndRow, cellIndex, cellIndex);
            if (rowStartIndex < rowEndRow) {
                sxssfSheet.addMergedRegionUnsafe(cellRangeAddress);
            }
            ++cellIndex;
        }
        if (hasErrorMessage && Strings.isNotBlank((String)tableLineDataVO.getError())) {
            this.capExcelManager.createErrorCell((Workbook)sxssfWorkbook, row, cellIndex, tableLineDataVO.getError());
        }
        if (hasErrorMessage && rowStartIndex < rowEndRow) {
            this.capExcelManager.setCellRangeAddress(cellRangeAddress, rowStartIndex, rowEndRow, cellIndex, cellIndex);
            sxssfSheet.addMergedRegionUnsafe(cellRangeAddress);
        }
        if (tableList.size() > 1 && subDatas != null) {
            j = tableList.size();
            for (i = 1; i < j; ++i) {
                Map<String, List<ExportTableLineDataVO>> dataList;
                List<ExportTableLineDataVO> currentSubData;
                ExportSubTableDataVO subTableDataVO = subDatas.get(tableList.get(i).getTableName());
                if (subTableDataVO == null || CollectionUtils.isEmpty(currentSubData = (dataList = subTableDataVO.getDataList()).get(masterId))) continue;
                int subStartRowIndex = rowStartIndex;
                int subStartColumnIndex = subTableStartColumn.get(tableList.get(i).getTableName());
                for (ExportTableLineDataVO lineDataVO : currentSubData) {
                    row = sxssfSheet.getRow(subStartRowIndex);
                    if (row == null) {
                        row = sxssfSheet.createRow(subStartRowIndex);
                    }
                    for (Object vo : lineDataVO.getLineValueData()) {
                        this.capExcelManager.setCellStyleAndValue(row, fieldDataCellStyle, subStartColumnIndex, vo, hasErrorMessage);
                        ++subStartColumnIndex;
                    }
                    if (hasErrorMessage && Strings.isNotBlank((String)lineDataVO.getError())) {
                        this.capExcelManager.createErrorCell((Workbook)sxssfWorkbook, row, subStartColumnIndex, lineDataVO.getError());
                        ++subStartColumnIndex;
                    }
                    ++subStartRowIndex;
                    subStartColumnIndex = subTableStartColumn.get(tableList.get(i).getTableName());
                }
            }
        }
        return subDatas == null || subDatas.isEmpty() ? rowStartIndex + 1 : rowStartIndex + subMaxSize;
    }

    private ExportWorkBookVO createExcelHead(FormBean formBean, String titleName, List<ExportTableBean> tableList, Integer totalFieldSize, boolean hasErrorMessage) {
        if (hasErrorMessage) {
            totalFieldSize = totalFieldSize + tableList.size();
        }
        HashMap<Integer, ExportFieldCellStyleVO> fieldDataCellStyle = new HashMap<Integer, ExportFieldCellStyleVO>();
        SXSSFWorkbook sxssfWorkbook = new SXSSFWorkbook(100);
        ExcelCellStyleBean cellStyleVO = this.capExcelManager.getCellStyle((Workbook)sxssfWorkbook);
        SXSSFSheet firstSheet = sxssfWorkbook.createSheet(this.capExcelManager.getSheetName(titleName, null));
        CellRangeAddress cellRangeAddress = new CellRangeAddress(0, 0, 0, 0);
        this.capExcelManager.createCell((Row)firstSheet.createRow(0), 0, titleName, cellStyleVO.getTitleStyle());
        if (totalFieldSize > 1) {
            cellRangeAddress.setLastColumn(totalFieldSize - 1);
            firstSheet.addMergedRegionUnsafe(cellRangeAddress);
        }
        SXSSFRow secondRow = firstSheet.createRow(1);
        secondRow.setHeightInPoints(30.0f);
        String remarks = ResourceUtil.getStringByParams((String)REMARKS_TEMPLATE, (Object[])new Object[]{formBean.getFormName(), DateUtil.format((Date)new Date(), (String)"yyyy-MM-dd")});
        this.capExcelManager.createCell((Row)secondRow, 0, (RichTextString)new XSSFRichTextString(remarks), cellStyleVO.getRemarksStyle());
        if (totalFieldSize > 1) {
            this.capExcelManager.setCellRangeAddress(cellRangeAddress, 1, 1, 0, totalFieldSize - 1);
            firstSheet.addMergedRegionUnsafe(cellRangeAddress);
        }
        HashMap<String, Integer> subTableStartColumn = new HashMap<String, Integer>();
        if (tableList.size() > 1) {
            Integer subTableTitleStartCell = 0;
            SXSSFRow thirdRow = firstSheet.createRow(2);
            SXSSFRow fourthRow = firstSheet.createRow(3);
            for (ExportTableBean tableVO : tableList) {
                List<FormFieldBean> fieldList = tableVO.getFieldList();
                int fieldSize = fieldList.size();
                if (tableVO.isMainTable()) {
                    subTableTitleStartCell = hasErrorMessage ? fieldSize + 1 : fieldSize;
                    for (int i = 0; i < fieldSize; ++i) {
                        FormFieldBean formFieldBean = fieldList.get(i);
                        this.capExcelManager.setFieldDataCellStyle(fieldDataCellStyle, i, formFieldBean);
                        this.capExcelManager.createCell((Row)thirdRow, i, formFieldBean.getDisplay(), cellStyleVO.getFieldStyle());
                        this.capExcelManager.setCellRangeAddress(cellRangeAddress, 2, 3, i, i);
                        firstSheet.addMergedRegionUnsafe(cellRangeAddress);
                    }
                    if (!hasErrorMessage) continue;
                    this.capExcelManager.createCell((Row)thirdRow, fieldSize, ResourceUtil.getString((String)"cap.form.batchOperation.errorExplain"), cellStyleVO.getRedFieldStyle());
                    this.capExcelManager.setCellRangeAddress(cellRangeAddress, 2, 3, fieldSize, fieldSize);
                    firstSheet.addMergedRegionUnsafe(cellRangeAddress);
                    continue;
                }
                subTableStartColumn.put(tableVO.getTableName(), subTableTitleStartCell);
                this.capExcelManager.createCell((Row)thirdRow, (int)subTableTitleStartCell, tableVO.getDisplay(), cellStyleVO.getSubTableTitleStyle());
                Integer currentSubTableTitleLastCell = hasErrorMessage ? subTableTitleStartCell + fieldSize + 1 : subTableTitleStartCell + fieldSize;
                if (fieldSize > 1) {
                    this.capExcelManager.setCellRangeAddress(cellRangeAddress, 2, 2, subTableTitleStartCell, currentSubTableTitleLastCell - 1);
                    firstSheet.addMergedRegionUnsafe(cellRangeAddress);
                }
                for (int i = 0; i < fieldSize; ++i) {
                    FormFieldBean formFieldBean = fieldList.get(i);
                    this.capExcelManager.setFieldDataCellStyle(fieldDataCellStyle, subTableTitleStartCell + i, formFieldBean);
                    this.capExcelManager.createCell((Row)fourthRow, subTableTitleStartCell + i, formFieldBean.getDisplay(), cellStyleVO.getFieldStyle());
                }
                if (hasErrorMessage) {
                    this.capExcelManager.createCell((Row)fourthRow, subTableTitleStartCell + fieldSize, ResourceUtil.getString((String)"cap.form.batchOperation.errorExplain"), cellStyleVO.getRedFieldStyle());
                }
                subTableTitleStartCell = currentSubTableTitleLastCell;
            }
        } else {
            this.capExcelManager.createFieldTitleRow(firstSheet.createRow(2), tableList, cellStyleVO, fieldDataCellStyle, hasErrorMessage);
        }
        ExportWorkBookVO vo = new ExportWorkBookVO();
        vo.setSxssfWorkbook(sxssfWorkbook);
        vo.setSxssfSheet(firstSheet);
        vo.setFieldDataCellStyle(fieldDataCellStyle);
        vo.setSubTableStartColumn(subTableStartColumn);
        return vo;
    }

    private List<FormFieldBean> getExportFieldBeans(FormBean formBean, List<SimpleObjectBean> showFields) {
        ArrayList<FormFieldBean> validFieldBeans = new ArrayList<FormFieldBean>();
        if (CollectionUtils.isNotEmpty(showFields)) {
            for (SimpleObjectBean simpleObjectBean : showFields) {
                FormFieldBean formFieldBean = this.capFilterFieldManager.getFormFieldBeanBySimpleObject(formBean, simpleObjectBean);
                if (!this.checkImportSupportField(formFieldBean)) continue;
                validFieldBeans.add(formFieldBean);
            }
        }
        return validFieldBeans;
    }

    private Map<String, List<FormFieldBean>> getExportSubTableFieldBeans(List<FormTableBean> subFormTableBeans) {
        HashMap<String, List<FormFieldBean>> subValidFieldBeanMap = new HashMap<String, List<FormFieldBean>>();
        for (FormTableBean subTableBean : subFormTableBeans) {
            ArrayList<FormFieldBean> validSubFieldList = new ArrayList<FormFieldBean>();
            for (FormFieldBean formFieldBean : subTableBean.getFields()) {
                if (!this.checkImportSupportField(formFieldBean)) continue;
                validSubFieldList.add(formFieldBean);
            }
            subValidFieldBeanMap.put(subTableBean.getTableName(), validSubFieldList);
        }
        return subValidFieldBeanMap;
    }

    private List<ExportTableBean> getExportTableVOs(FormBean formBean, List<FormFieldBean> validFieldBeans, Map<String, List<FormFieldBean>> subValidFieldBeanMap) {
        ArrayList<ExportTableBean> tableList = new ArrayList<ExportTableBean>();
        List formTableBeans = formBean.getTableList();
        for (FormTableBean formTableBean : formTableBeans) {
            List<FormFieldBean> fieldList;
            List<FormFieldBean> list = fieldList = formTableBean.isMainTable() ? validFieldBeans : subValidFieldBeanMap.get(formTableBean.getTableName());
            if (CollectionUtils.isEmpty(fieldList)) continue;
            ExportTableBean tableVO = new ExportTableBean(formTableBean);
            tableVO.setFieldList(fieldList);
            tableList.add(tableVO);
        }
        return tableList;
    }

    public void setCap4FormDataDAO(CAP4FormDataDAO cap4FormDataDAO) {
        this.cap4FormDataDAO = cap4FormDataDAO;
    }

    public void setCapFilterFieldManager(CAPFilterFieldManager capFilterFieldManager) {
        this.capFilterFieldManager = capFilterFieldManager;
    }

    public void setCapUnFlowManager(CAPUnFlowManager capUnFlowManager) {
        this.capUnFlowManager = capUnFlowManager;
    }

    public void setCapDataListSqlHelpManager(CAPDataListSqlHelpManager capDataListSqlHelpManager) {
        this.capDataListSqlHelpManager = capDataListSqlHelpManager;
    }

    public void setCapUnFlowFormatManager(CAPUnFlowFormatManager capUnFlowFormatManager) {
        this.capUnFlowFormatManager = capUnFlowFormatManager;
    }
}

