/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.cap4.template.manager.impl;

import com.seeyon.cap4.form.bean.FormBean;
import com.seeyon.cap4.form.bean.FormBindAuthBean;
import com.seeyon.cap4.form.bean.FormFieldBean;
import com.seeyon.cap4.form.bean.FormTableBean;
import com.seeyon.cap4.template.annotation.JMCalling4Service;
import com.seeyon.cap4.template.annotation.ParamClass;
import com.seeyon.cap4.template.bean.ExcelCellStyleBean;
import com.seeyon.cap4.template.bean.ExportTableBean;
import com.seeyon.cap4.template.bean.ExportTemplateParamBean;
import com.seeyon.cap4.template.constant.CAPBusinessEnum;
import com.seeyon.cap4.template.manager.impl.AbstractCAPExportManager;
import com.seeyon.cap4.template.vo.ExportFileVO;
import com.seeyon.ctp.common.exceptions.BusinessException;
import com.seeyon.ctp.common.log.CtpLogFactory;
import com.seeyon.ctp.util.StringUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

@ParamClass(clazz=ExportTemplateParamBean.class)
public class CAPExportManager4FormDataTemplate
extends AbstractCAPExportManager<ExportTemplateParamBean, Workbook> {
    private static final Log LOGGER = CtpLogFactory.getLog(CAPExportManager4FormDataTemplate.class);

    @Override
    public String getType() {
        return CAPBusinessEnum.BatchOperationEnum.EXPORT_MODULE.getKey();
    }

    @Override
    @JMCalling4Service(batchRunType=CAPBusinessEnum.BatchOperationEnum.EXPORT_MODULE)
    public Workbook export(ExportTemplateParamBean templateBean, ExportFileVO fileVO) throws BusinessException {
        List<String> fields = Arrays.asList(StringUtil.split((String)templateBean.getFields(), (String)","));
        return this.exportTemplateFile(templateBean.getFormId(), templateBean.getBindId(), fields, fileVO);
    }

    private Workbook exportTemplateFile(Long formId, Long bindAuthId, List<String> fieldList, ExportFileVO fileVO) throws BusinessException {
        ArrayList<ExportTableBean> tableList = new ArrayList<ExportTableBean>();
        FormBean formBean = this.cap4FormCacheManager.getForm(formId);
        if (fileVO != null) {
            fileVO.setFileName(formBean.getFormName());
        }
        FormBindAuthBean formBindAuthBean = formBean.getBind().getFormBindAuthBean(String.valueOf(bindAuthId));
        List formTableBeans = formBean.getTableList();
        int titleColSize = fieldList.size();
        for (FormTableBean formTableBean : formTableBeans) {
            ArrayList<FormFieldBean> formFieldBeanList = new ArrayList<FormFieldBean>();
            for (String fieldName : fieldList) {
                FormFieldBean formFieldBean = formTableBean.getFieldBeanByName(fieldName);
                if (formFieldBean == null) continue;
                if (this.checkImportSupportField(formFieldBean)) {
                    formFieldBeanList.add(formFieldBean);
                    continue;
                }
                --titleColSize;
            }
            if (CollectionUtils.isEmpty(formFieldBeanList)) continue;
            ExportTableBean vo = new ExportTableBean(formTableBean);
            vo.setFieldList(formFieldBeanList);
            tableList.add(vo);
        }
        String bindAuthBeanName = formBindAuthBean.getName();
        XSSFWorkbook xssfWorkbook = new XSSFWorkbook();
        ExcelCellStyleBean styleVO = this.capExcelManager.getCellStyle((Workbook)xssfWorkbook);
        XSSFSheet firstSheet = xssfWorkbook.createSheet(this.capExcelManager.getSheetName(bindAuthBeanName, null));
        this.capExcelManager.createCell((Row)firstSheet.createRow(0), 0, bindAuthBeanName, styleVO.getTitleStyle());
        if (fieldList.size() > 1) {
            firstSheet.addMergedRegionUnsafe(new CellRangeAddress(0, 0, 0, titleColSize - 1));
        }
        if (tableList.size() > 1) {
            this.exportMasterAndSub(styleVO, tableList, xssfWorkbook, firstSheet);
        } else {
            this.exportMaster(styleVO, tableList, xssfWorkbook, firstSheet);
        }
        return xssfWorkbook;
    }

    private void exportMasterAndSub(ExcelCellStyleBean styleVO, List<ExportTableBean> tableList, XSSFWorkbook xssfWorkbook, XSSFSheet firstSheet) throws BusinessException {
        int subTableTitleStartCell = 0;
        XSSFRow secondRow = firstSheet.createRow(1);
        XSSFRow thirdRow = firstSheet.createRow(2);
        for (ExportTableBean tableInfo : tableList) {
            List<FormFieldBean> formFieldBeans = tableInfo.getFieldList();
            if (tableInfo.isMainTable()) {
                subTableTitleStartCell = formFieldBeans.size();
                for (int i = 0; i < formFieldBeans.size(); ++i) {
                    FormFieldBean formFieldBean = formFieldBeans.get(i);
                    this.capExcelManager.createCell((Row)secondRow, i, formFieldBean.getDisplay(), styleVO.getFieldStyle());
                    firstSheet.addMergedRegionUnsafe(new CellRangeAddress(1, 2, i, i));
                    this.setEnumValidation(xssfWorkbook, firstSheet, formFieldBean, 3, i);
                }
                continue;
            }
            this.capExcelManager.createCell((Row)secondRow, subTableTitleStartCell, tableInfo.getDisplay(), styleVO.getSubTableTitleStyle());
            Integer currentSubTableTitleLastCell = subTableTitleStartCell + formFieldBeans.size();
            if (formFieldBeans.size() > 1) {
                firstSheet.addMergedRegionUnsafe(new CellRangeAddress(1, 1, subTableTitleStartCell, currentSubTableTitleLastCell - 1));
            }
            for (int i = 0; i < formFieldBeans.size(); ++i) {
                FormFieldBean formFieldBean = formFieldBeans.get(i);
                Integer currentCell = subTableTitleStartCell + i;
                this.capExcelManager.createCell((Row)thirdRow, subTableTitleStartCell + i, formFieldBean.getDisplay(), styleVO.getFieldStyle());
                this.setEnumValidation(xssfWorkbook, firstSheet, formFieldBean, 3, currentCell);
            }
            subTableTitleStartCell = currentSubTableTitleLastCell;
        }
    }

    private void exportMaster(ExcelCellStyleBean styleVO, List<ExportTableBean> tableList, XSSFWorkbook xssfWorkbook, XSSFSheet xssfSheet) throws BusinessException {
        XSSFRow secondRow = xssfSheet.createRow(1);
        for (ExportTableBean tableInfo : tableList) {
            List<FormFieldBean> formFieldBeans = tableInfo.getFieldList();
            for (int i = 0; i < formFieldBeans.size(); ++i) {
                FormFieldBean formFieldBean = formFieldBeans.get(i);
                this.capExcelManager.createCell((Row)secondRow, i, formFieldBean.getDisplay(), styleVO.getFieldStyle());
                this.setEnumValidation(xssfWorkbook, xssfSheet, formFieldBean, 2, i);
            }
        }
    }
}

