/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.cap4.template.manager.impl;

import com.seeyon.cap4.form.bean.FormAuthViewBean;
import com.seeyon.cap4.form.bean.FormAuthViewFieldBean;
import com.seeyon.cap4.form.bean.FormAuthorizationTableBean;
import com.seeyon.cap4.form.bean.FormBean;
import com.seeyon.cap4.form.bean.FormDataMasterBean;
import com.seeyon.cap4.form.bean.FormDataSubBean;
import com.seeyon.cap4.form.bean.FormFieldBean;
import com.seeyon.cap4.form.bean.FormTableBean;
import com.seeyon.cap4.form.bean.FormViewBean;
import com.seeyon.cap4.form.util.Enums;
import com.seeyon.cap4.template.annotation.JMCalling4Service;
import com.seeyon.cap4.template.annotation.ParamClass;
import com.seeyon.cap4.template.bean.ExcelCellStyleBean;
import com.seeyon.cap4.template.bean.ExportFormSubDataParamBean;
import com.seeyon.cap4.template.bean.ExportTableBean;
import com.seeyon.cap4.template.constant.CAPBusinessEnum;
import com.seeyon.cap4.template.exception.FormDataBusinessException;
import com.seeyon.cap4.template.manager.impl.AbstractCAPExportManager;
import com.seeyon.cap4.template.util.CAPFormUtil;
import com.seeyon.cap4.template.vo.ExportFieldCellStyleVO;
import com.seeyon.cap4.template.vo.ExportFileVO;
import com.seeyon.cap4.template.vo.ExportTableLineDataVO;
import com.seeyon.ctp.common.exceptions.BusinessException;
import com.seeyon.ctp.common.i18n.ResourceUtil;
import com.seeyon.ctp.common.log.CtpLogFactory;
import com.seeyon.ctp.util.DateUtil;
import com.seeyon.ctp.util.Strings;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.poi.ss.usermodel.RichTextString;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.xssf.streaming.SXSSFRow;
import org.apache.poi.xssf.streaming.SXSSFSheet;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;
import org.apache.poi.xssf.usermodel.XSSFRichTextString;

@ParamClass(clazz=ExportFormSubDataParamBean.class)
public class CAPExportManager4FormSubData
extends AbstractCAPExportManager<ExportFormSubDataParamBean, Workbook> {
    private static final Log LOGGER = CtpLogFactory.getLog(CAPExportManager4FormSubData.class);
    private static final String CODE6 = "3006";
    private static final String MESSAGE6 = "%s table not exist!";

    @Override
    public String getType() {
        return CAPBusinessEnum.BatchOperationEnum.EXPORT_SUB_DATA.getKey();
    }

    @Override
    @JMCalling4Service(batchRunType=CAPBusinessEnum.BatchOperationEnum.EXPORT_SUB_DATA)
    public Workbook export(ExportFormSubDataParamBean bean, ExportFileVO fileVO) throws BusinessException {
        return this.exportFile(bean, fileVO);
    }

    private Workbook exportFile(ExportFormSubDataParamBean bean, ExportFileVO fileVO) throws BusinessException {
        FormAuthViewBean formAuthViewBean;
        Map<String, Object> auth;
        Map formAuthorizationTableBeans;
        FormAuthorizationTableBean formAuthorizationTableBean;
        FormBean formBean = this.cap4FormCacheManager.getForm(bean.getFormId());
        FormTableBean formTableBean = formBean.getTableByTableName(bean.getTableName());
        if (formTableBean == null) {
            LOGGER.error((Object)("exportSubTableDataFile " + String.format(MESSAGE6, bean.getTableName())));
            throw new FormDataBusinessException(CODE6, String.format(MESSAGE6, bean.getTableName()));
        }
        FormDataMasterBean cacheFormDataMasterBean = this.cap4FormManager.getSessioMasterDataBean(bean.getFormMasterId());
        if (cacheFormDataMasterBean == null) {
            throw new FormDataBusinessException("2010", ResourceUtil.getString((String)"cap.template.form.data.message.cacheDisabled"));
        }
        if (fileVO != null) {
            fileVO.setFileName(formTableBean.getDisplay());
        }
        FormAuthorizationTableBean formAuthorizationTableBean2 = formAuthorizationTableBean = (formAuthorizationTableBeans = (Map)(auth = this.cap4FormDataManager.dealFormRightChangeResult(formBean, formAuthViewBean = CAPFormUtil.getFormAuthViewBean(formBean, cacheFormDataMasterBean, bean.getRightId()), cacheFormDataMasterBean, false)).get("subTableAuthMap")).get(bean.getTableName()) == null ? formAuthViewBean.getSubTableAuth(formTableBean.getDisplay()) : (FormAuthorizationTableBean)formAuthorizationTableBeans.get(formTableBean.getTableName());
        if (!formAuthorizationTableBean.isExportData()) {
            throw new FormDataBusinessException("2006", ResourceUtil.getString((String)"cap.template.form.data.message.noAuth"));
        }
        FormViewBean formViewBean = formBean.getFormView(formAuthViewBean.getFormViewId());
        List<FormFieldBean> fieldBeans = CAPFormUtil.getViewTableNameFieldBeans(formBean, formViewBean, formTableBean.getTableName());
        if (CollectionUtils.isNotEmpty(fieldBeans)) {
            Iterator<FormFieldBean> iterator = fieldBeans.iterator();
            while (iterator.hasNext()) {
                FormFieldBean formFieldBean = iterator.next();
                if (this.checkExportSubField(formFieldBean)) continue;
                iterator.remove();
            }
        }
        List formDataSubBeans = cacheFormDataMasterBean.getSubData(formTableBean.getTableName());
        ArrayList<ExportTableLineDataVO> lineDataVOS = new ArrayList<ExportTableLineDataVO>();
        Map apartAuthMap = (Map)auth.get("apartAuthMap");
        for (FormDataSubBean formDataSubBean : formDataSubBeans) {
            String id = String.valueOf(formDataSubBean.getId());
            ArrayList<Object> dataList = new ArrayList<Object>();
            for (FormFieldBean formFieldBean : fieldBeans) {
                Object value = formDataSubBean.getFieldValue(formFieldBean.getName());
                String key = formFieldBean.getName() + "_" + id;
                FormAuthViewFieldBean formAuthViewFieldBean = apartAuthMap.get(key) == null ? formAuthViewBean.getFormAuthorizationField(formFieldBean.getName()) : (FormAuthViewFieldBean)apartAuthMap.get(key);
                value = Enums.FieldAccessType.hide.getKey().equals(formAuthViewFieldBean.getAccess()) ? "***" : formFieldBean.getDisplayValue(value, false, true, false)[1];
                dataList.add(value);
            }
            lineDataVOS.add(new ExportTableLineDataVO(dataList, id));
        }
        ArrayList<ExportTableBean> tableList = new ArrayList<ExportTableBean>(1);
        ExportTableBean tableVO = new ExportTableBean(formTableBean);
        tableVO.setFieldList(fieldBeans);
        tableList.add(tableVO);
        return this.exportExcelFile(formTableBean.getDisplay(), formBean, tableList, fieldBeans.size(), lineDataVOS, false);
    }

    protected Workbook exportExcelFile(String titleName, FormBean formBean, List<ExportTableBean> tableList, Integer totalFieldSize, List<ExportTableLineDataVO> lineDataVOS, boolean hasErrorMessage) throws BusinessException {
        totalFieldSize = hasErrorMessage ? totalFieldSize + 1 : totalFieldSize;
        CellRangeAddress cellRangeAddress = new CellRangeAddress(0, 0, 0, 0);
        HashMap<Integer, ExportFieldCellStyleVO> fieldDataCellStyle = new HashMap<Integer, ExportFieldCellStyleVO>();
        SXSSFWorkbook sxssfWorkbook = new SXSSFWorkbook(-1);
        ExcelCellStyleBean cellStyleVO = this.capExcelManager.getCellStyle((Workbook)sxssfWorkbook);
        SXSSFSheet firstSheet = sxssfWorkbook.createSheet(this.capExcelManager.getSheetName(titleName, null));
        this.capExcelManager.createCell((Row)firstSheet.createRow(0), 0, titleName, cellStyleVO.getTitleStyle());
        if (totalFieldSize > 1) {
            cellRangeAddress.setLastColumn(totalFieldSize - 1);
            firstSheet.addMergedRegionUnsafe(cellRangeAddress);
        }
        SXSSFRow secondRow = firstSheet.createRow(1);
        secondRow.setHeightInPoints(30.0f);
        String remarks = ResourceUtil.getStringByParams((String)"cap.form.batchOperation.remarksTemplate", (Object[])new Object[]{formBean.getFormName(), DateUtil.format((Date)new Date(), (String)"yyyy-MM-dd")});
        this.capExcelManager.createCell((Row)secondRow, 0, (RichTextString)new XSSFRichTextString(remarks), cellStyleVO.getRemarksStyle());
        if (totalFieldSize > 1) {
            this.capExcelManager.setCellRangeAddress(cellRangeAddress, 1, 1, 0, totalFieldSize - 1);
            firstSheet.addMergedRegionUnsafe(cellRangeAddress);
        }
        this.capExcelManager.createFieldTitleRow(firstSheet.createRow(2), tableList, cellStyleVO, fieldDataCellStyle, hasErrorMessage);
        Long startTime = System.currentTimeMillis();
        int rowStartIndex = tableList.size() > 1 ? 4 : 3;
        for (ExportTableLineDataVO lineDataVO : lineDataVOS) {
            int subMaxSize = 0;
            SXSSFRow row = firstSheet.createRow(rowStartIndex);
            int rowEndRow = rowStartIndex + subMaxSize - 1;
            int cellIndex = 0;
            List<Object> masterDataList = lineDataVO.getLineValueData();
            for (Object obj : masterDataList) {
                this.capExcelManager.setCellStyleAndValue(row, fieldDataCellStyle, cellIndex, obj, hasErrorMessage);
                this.capExcelManager.setCellRangeAddress(cellRangeAddress, rowStartIndex, rowEndRow, cellIndex, cellIndex);
                if (rowStartIndex < rowEndRow) {
                    firstSheet.addMergedRegionUnsafe(cellRangeAddress);
                }
                ++cellIndex;
            }
            if (hasErrorMessage && Strings.isNotBlank((String)lineDataVO.getError())) {
                this.capExcelManager.createErrorCell((Workbook)sxssfWorkbook, row, cellIndex, lineDataVO.getError());
            }
            if (hasErrorMessage && rowStartIndex < rowEndRow) {
                this.capExcelManager.setCellRangeAddress(cellRangeAddress, rowStartIndex, rowEndRow, cellIndex, cellIndex);
                firstSheet.addMergedRegionUnsafe(cellRangeAddress);
            }
            ++rowStartIndex;
        }
        LOGGER.info((Object)("write file use time " + (System.currentTimeMillis() - startTime) + " ms"));
        return sxssfWorkbook;
    }
}

