/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.cap4.template.manager.impl;

import com.seeyon.cap4.form.bean.FormBean;
import com.seeyon.cap4.form.bean.FormFieldBean;
import com.seeyon.cap4.form.bean.FormTableBean;
import com.seeyon.cap4.template.annotation.JMCalling4Service;
import com.seeyon.cap4.template.annotation.ParamClass;
import com.seeyon.cap4.template.bean.ExcelCellStyleBean;
import com.seeyon.cap4.template.bean.ExportTemplateParamBean;
import com.seeyon.cap4.template.constant.CAPBusinessEnum;
import com.seeyon.cap4.template.manager.impl.AbstractCAPExportManager;
import com.seeyon.cap4.template.vo.ExportFileVO;
import com.seeyon.ctp.common.exceptions.BusinessException;
import com.seeyon.ctp.common.log.CtpLogFactory;
import com.seeyon.ctp.util.StringUtil;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

@ParamClass(clazz=ExportTemplateParamBean.class)
public class CAPExportManager4FormSubDataTemplate
extends AbstractCAPExportManager<ExportTemplateParamBean, Workbook> {
    private static final Log LOGGER = CtpLogFactory.getLog(CAPExportManager4FormSubDataTemplate.class);

    @Override
    public String getType() {
        return CAPBusinessEnum.BatchOperationEnum.EXPORT_SUB_MODULE.getKey();
    }

    @Override
    @JMCalling4Service(batchRunType=CAPBusinessEnum.BatchOperationEnum.EXPORT_SUB_MODULE)
    public Workbook export(ExportTemplateParamBean templateBean, ExportFileVO fileVO) throws BusinessException {
        List<String> fields = Arrays.asList(StringUtil.split((String)templateBean.getFields(), (String)","));
        return this.exportSubTableTemplateFile(templateBean.getFormId(), fields, fileVO);
    }

    private Workbook exportSubTableTemplateFile(Long formId, List<String> fields, ExportFileVO fileVO) throws BusinessException {
        FormBean formBean = this.cap4FormCacheManager.getForm(formId);
        if (fileVO != null) {
            fileVO.setFileName(formBean.getFormName());
        }
        XSSFWorkbook xssfWorkbook = new XSSFWorkbook();
        ExcelCellStyleBean styleVO = this.capExcelManager.getCellStyle((Workbook)xssfWorkbook);
        String tableName = formBean.getFieldBeanByName(fields.get(0)).getOwnerTableName();
        FormTableBean formTableBean = formBean.getTableByTableName(tableName);
        XSSFSheet firstSheet = xssfWorkbook.createSheet(this.capExcelManager.getSheetName(formTableBean.getDisplay(), null));
        this.capExcelManager.createCell((Row)firstSheet.createRow(0), 0, formTableBean.getDisplay(), styleVO.getTitleStyle());
        if (fields.size() > 1) {
            firstSheet.addMergedRegionUnsafe(new CellRangeAddress(0, 0, 0, fields.size() - 1));
        }
        XSSFRow secondRow = firstSheet.createRow(1);
        for (int i = 0; i < fields.size(); ++i) {
            FormFieldBean formFieldBean = formBean.getFieldBeanByName(fields.get(i));
            this.capExcelManager.createCell((Row)secondRow, i, formFieldBean.getDisplay(), styleVO.getFieldStyle());
            this.setEnumValidation(xssfWorkbook, firstSheet, formFieldBean, 2, i);
        }
        return xssfWorkbook;
    }
}

