/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.cap4.template.manager.impl;

import com.seeyon.cap4.form.bean.FormFieldComEnum;
import com.seeyon.cap4.form.util.Enums;
import com.seeyon.cap4.template.bean.ConditionBean;
import com.seeyon.cap4.template.constant.SqlOperationEnum;
import com.seeyon.cap4.template.manager.CAPFilterFieldConditionManager;
import com.seeyon.cap4.template.util.EnumUtil;
import com.seeyon.cap4.template.vo.FilterFieldVO;
import com.seeyon.ctp.common.exceptions.BusinessException;
import com.seeyon.ctp.common.log.CtpLogFactory;
import com.seeyon.ctp.form.bean.FormBean;
import com.seeyon.ctp.form.bean.FormFieldBean;
import com.seeyon.ctp.util.DateUtil;
import com.seeyon.ctp.util.Strings;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;

public class CAPFilterFieldConditionManagerImpl
implements CAPFilterFieldConditionManager {
    private static final Log LOGGER = CtpLogFactory.getLog(CAPFilterFieldConditionManagerImpl.class);
    private static final String CUSTOM_ENUM = "customenum";

    @Override
    public ConditionBean populate(Map<String, Object> userCondition) throws BusinessException {
        ConditionBean bean = new ConditionBean();
        try {
            BeanUtils.populate((Object)bean, userCondition);
        }
        catch (Exception e) {
            LOGGER.error(userCondition, (Throwable)e);
            throw new BusinessException((Throwable)e);
        }
        return bean;
    }

    @Override
    public List<ConditionBean> getDefaultConditionBeans(List<FilterFieldVO> filterFieldVOS) throws BusinessException {
        ArrayList<ConditionBean> conditionBeans = new ArrayList<ConditionBean>();
        if (CollectionUtils.isEmpty(filterFieldVOS)) {
            return conditionBeans;
        }
        for (FilterFieldVO fieldVO : filterFieldVOS) {
            if (fieldVO.getDefaultValue() == null || fieldVO.getDefaultValue().isEmpty() || FormFieldComEnum.LINE_NUMBER.getKey().equals(fieldVO.getInputType())) continue;
            FormFieldComEnum formFieldComEnum = FormFieldComEnum.getEnumByKey((String)fieldVO.getInputType());
            switch (formFieldComEnum) {
                case EXTEND_DATE: 
                case EXTEND_DATETIME: {
                    if (fieldVO.getDefaultValue().get("startTime") != null && StringUtils.isNotEmpty((String)String.valueOf(fieldVO.getDefaultValue().get("startTime")))) {
                        conditionBeans.add(this.getDefaultConditionBean(fieldVO, SqlOperationEnum.GreatEqual.getValue(), fieldVO.getDefaultValue().get("startTime")));
                    }
                    if (fieldVO.getDefaultValue().get("endTime") == null || !StringUtils.isNotEmpty((String)String.valueOf(fieldVO.getDefaultValue().get("endTime")))) break;
                    conditionBeans.add(this.getDefaultConditionBean(fieldVO, SqlOperationEnum.LessEqual.getValue(), fieldVO.getDefaultValue().get("endTime")));
                    break;
                }
                case TEXT: 
                case TEXTAREA: {
                    Object showValue = fieldVO.getDefaultValue().get("showValue");
                    if (Enums.FieldType.DECIMAL.getKey().equals(fieldVO.getFieldType())) {
                        conditionBeans.add(this.getDefaultConditionBean(fieldVO, SqlOperationEnum.GreatEqual.getValue(), showValue));
                        conditionBeans.add(this.getDefaultConditionBean(fieldVO, SqlOperationEnum.LessEqual.getValue(), showValue));
                        break;
                    }
                    conditionBeans.add(this.getDefaultConditionBean(fieldVO, SqlOperationEnum.Like.getValue(), showValue));
                    break;
                }
                case CHECKBOX: {
                    if ("0".equals(fieldVO.getDefaultValue().get("value"))) break;
                    conditionBeans.add(this.getDefaultConditionBean(fieldVO, SqlOperationEnum.Equal.getValue(), fieldVO.getDefaultValue().get("value")));
                    break;
                }
                case EXTEND_DEPARTMENT: 
                case EXTEND_MULTI_DEPARTMENT: {
                    Object departValue = fieldVO.getDefaultValue().get("value");
                    conditionBeans.add(this.getDefaultConditionBean(fieldVO, SqlOperationEnum.Include.getValue(), CAPFilterFieldConditionManagerImpl.getExtendConditionFieldValue(departValue)));
                    break;
                }
                case EXTEND_MEMBER: 
                case EXTEND_ACCOUNT: 
                case EXTEND_MULTI_MEMBER: 
                case EXTEND_MULTI_ACCOUNT: {
                    Object value = fieldVO.getDefaultValue().get("value");
                    value = CAPFilterFieldConditionManagerImpl.getExtendConditionFieldValue(value);
                    if (FormFieldComEnum.EXTEND_MEMBER.getKey().equals(formFieldComEnum.getKey()) || FormFieldComEnum.EXTEND_ACCOUNT.getKey().equals(formFieldComEnum.getKey())) {
                        conditionBeans.add(this.getDefaultConditionBean(fieldVO, SqlOperationEnum.Equal.getValue(), value));
                        break;
                    }
                    conditionBeans.add(this.getDefaultConditionBean(fieldVO, SqlOperationEnum.Include.getValue(), value));
                    break;
                }
            }
        }
        return conditionBeans;
    }

    private ConditionBean getDefaultConditionBean(FilterFieldVO fieldVO, String operation, Object fieldValue) {
        ConditionBean conditionBean = new ConditionBean();
        conditionBean.setAliasTableName(fieldVO.getAliasTableName());
        conditionBean.setRowOperation("and");
        conditionBean.setFieldName(fieldVO.getName());
        conditionBean.setLeftChar("(");
        conditionBean.setRightChar(")");
        conditionBean.setOperation(operation);
        conditionBean.setFieldValue(fieldValue);
        conditionBean.setInputType(fieldVO.getInputType());
        conditionBean.setFieldType(fieldVO.getFieldType());
        return conditionBean;
    }

    @Override
    public List<ConditionBean> getConditionBeans(List<Map<String, Object>> userConditions) throws BusinessException {
        ArrayList<ConditionBean> conditionBeans = new ArrayList<ConditionBean>();
        if (CollectionUtils.isEmpty(userConditions)) {
            return conditionBeans;
        }
        for (Map<String, Object> userCondition : userConditions) {
            ConditionBean conditionBean = this.populate(userCondition);
            this.conversionOperation(conditionBean);
            String key = conditionBean.getInputType();
            String fieldName = conditionBean.getFieldName();
            if (key == null) {
                Enums.FlowBusinessFixField fixField = Enums.FlowBusinessFixField.getEnumByKey((String)fieldName);
                String string = key = fixField == null ? null : fixField.getInputType();
            }
            if (Enums.MasterTableField.state.getKey().equals(fieldName) || Enums.MasterTableField.ratifyflag.getKey().equals(fieldName) || Enums.MasterTableField.finishedflag.getKey().equals(fieldName) || Enums.FlowBusinessFixField.importantLevel.getKey().equals(fieldName) || Enums.FlowBusinessFixField.archiveId.getKey().equals(fieldName)) {
                key = CUSTOM_ENUM;
            }
            if (FormFieldComEnum.EXTEND_DATE.getKey().equals(key) || FormFieldComEnum.EXTEND_DATETIME.getKey().equals(key)) {
                if (conditionBean.getFieldValue() != null && conditionBean.getFieldValue() instanceof Date) {
                    Date date = (Date)conditionBean.getFieldValue();
                    if (FormFieldComEnum.EXTEND_DATE.getKey().equals(key)) {
                        conditionBean.setFieldValue(DateUtil.format((Date)date, (String)"yyyy-MM-dd"));
                    } else {
                        conditionBean.setFieldValue(DateUtil.format((Date)date, (String)"yyyy-MM-dd HH:mm"));
                    }
                }
                conditionBeans.add(conditionBean);
                continue;
            }
            if (FormFieldComEnum.SELECT.getKey().equals(key) || FormFieldComEnum.RADIO.getKey().equals(key) || FormFieldComEnum.IMAGE_RADIO.getKey().equals(key) || FormFieldComEnum.IMAGE_SELECT.getKey().equals(key) || CUSTOM_ENUM.equals(key)) {
                this.invokeEnumCondition(conditionBean, conditionBeans, key.equals(CUSTOM_ENUM) ? "value" : "id");
                continue;
            }
            if (FormFieldComEnum.EXTEND_MEMBER.getKey().equals(key) || FormFieldComEnum.EXTEND_MULTI_MEMBER.getKey().equals(key) || FormFieldComEnum.EXTEND_DEPARTMENT.getKey().equals(key) || FormFieldComEnum.EXTEND_MULTI_DEPARTMENT.getKey().equals(key) || FormFieldComEnum.EXTEND_POST.getKey().equals(key) || FormFieldComEnum.EXTEND_MULTI_POST.getKey().equals(key) || FormFieldComEnum.EXTEND_LEVEL.getKey().equals(key) || FormFieldComEnum.EXTEND_MULTI_LEVEL.getKey().equals(key) || FormFieldComEnum.EXTEND_ACCOUNT.getKey().equals(key) || FormFieldComEnum.EXTEND_MULTI_ACCOUNT.getKey().equals(key)) {
                conditionBean.setFieldValue(CAPFilterFieldConditionManagerImpl.getExtendConditionFieldValue(conditionBean.getFieldValue()));
                conditionBeans.add(conditionBean);
                continue;
            }
            conditionBeans.add(conditionBean);
        }
        return conditionBeans;
    }

    private void invokeEnumCondition(ConditionBean conditionBean, List<ConditionBean> conditionBeans, String enumValueKey) throws BusinessException {
        Object fieldValue = conditionBean.getFieldValue();
        if (fieldValue instanceof List) {
            List enums = (List)fieldValue;
            if (enums.size() == 1 && Strings.isBlank((String)((String)((Map)enums.get(0)).get(enumValueKey)))) {
                this.setNullCondition(conditionBean);
                conditionBeans.add(conditionBean);
            } else {
                Map lastEnum = (Map)enums.get(enums.size() - 1);
                if (Strings.isBlank((String)((String)lastEnum.get(enumValueKey)))) {
                    ConditionBean nullCondition;
                    ArrayList values = new ArrayList();
                    for (int i = 0; i < enums.size() - 1; ++i) {
                        values.add(((Map)enums.get(i)).get(enumValueKey));
                    }
                    String rightChar = conditionBean.getRightChar();
                    conditionBean.setFieldValue(StringUtils.join(values, (String)","));
                    conditionBean.setRightChar("");
                    conditionBean.setRowOperation("or");
                    conditionBeans.add(conditionBean);
                    try {
                        nullCondition = (ConditionBean)conditionBean.clone();
                    }
                    catch (CloneNotSupportedException e) {
                        throw new BusinessException((Throwable)e);
                    }
                    nullCondition.setRowOperation("and");
                    nullCondition.setLeftChar("");
                    nullCondition.setRightChar(rightChar);
                    this.setNullCondition(nullCondition);
                    conditionBeans.add(nullCondition);
                } else {
                    ArrayList values = new ArrayList();
                    for (Map enumMap : enums) {
                        values.add(enumMap.get(enumValueKey));
                    }
                    conditionBean.setFieldValue(StringUtils.join(values, (String)","));
                    conditionBeans.add(conditionBean);
                }
            }
        } else {
            conditionBeans.add(conditionBean);
        }
    }

    private void setNullCondition(ConditionBean bean) throws BusinessException {
        bean.setFieldValue("");
    }

    private void conversionOperation(ConditionBean conditionBean) {
        SqlOperationEnum operationEnum = EnumUtil.getEnumByKey(SqlOperationEnum.class, conditionBean.getOperation());
        if (operationEnum != null) {
            conditionBean.setOperation(operationEnum.getValue());
        }
    }

    private static String getExtendConditionFieldValue(Object fieldValue) {
        if (fieldValue == null) {
            return "";
        }
        HashSet<String> lastValue = new HashSet<String>();
        if (fieldValue instanceof List) {
            List values = (List)fieldValue;
            for (String value : values) {
                lastValue.add(CAPFilterFieldConditionManagerImpl.getExtendConditionFieldLastValue(value));
            }
        } else if (Strings.isNotBlank((String)fieldValue.toString())) {
            lastValue.add(CAPFilterFieldConditionManagerImpl.getExtendConditionFieldLastValue(fieldValue.toString()));
        }
        return StringUtils.join(lastValue, (String)",");
    }

    private static String getExtendConditionFieldLastValue(String fieldValue) {
        if (fieldValue == null) {
            return null;
        }
        if (fieldValue.contains("|")) {
            String[] values = fieldValue.split(",");
            HashSet<String> set = new HashSet<String>();
            for (String value : values) {
                if (value.contains(Strings.capitalize((String)FormFieldComEnum.EXTEND_MEMBER.getKey()) + "|") || value.contains(Strings.capitalize((String)FormFieldComEnum.EXTEND_DEPARTMENT.getKey()) + "|") || value.contains(Strings.capitalize((String)FormFieldComEnum.EXTEND_ACCOUNT.getKey()) + "|") || value.contains(Strings.capitalize((String)FormFieldComEnum.EXTEND_POST.getKey()) + "|") || value.contains(Strings.capitalize((String)FormFieldComEnum.EXTEND_LEVEL.getKey()) + "|")) {
                    value = value.substring(value.indexOf("|") + 1, value.length());
                }
                set.add(value);
            }
            fieldValue = StringUtils.join(set, (String)",");
        }
        return fieldValue;
    }

    @Override
    public List<Map<String, Object>> completeUserConditions(com.seeyon.cap4.form.bean.FormBean formBean, List<Map<String, Object>> userConditions) {
        if (CollectionUtils.isNotEmpty(userConditions)) {
            for (Map<String, Object> userCondition : userConditions) {
                String fieldName = (String)userCondition.get("fieldName");
                com.seeyon.cap4.form.bean.FormFieldBean formFieldBean = formBean.getFieldBeanByName(fieldName, true);
                if (formFieldBean == null) continue;
                if (userCondition.get("aliasTableName") == null) {
                    userCondition.put("aliasTableName", formFieldBean.getOwnerTableName());
                }
                if (userCondition.get("fieldType") == null) {
                    userCondition.put("fieldType", formFieldBean.getFieldType());
                }
                if (userCondition.get("inputType") != null) continue;
                userCondition.put("inputType", formFieldBean.getInputType());
            }
        }
        return userConditions;
    }

    @Override
    public List<Map<String, Object>> completeUserConditions(FormBean formBean, List<Map<String, Object>> userConditions) {
        if (CollectionUtils.isNotEmpty(userConditions)) {
            for (Map<String, Object> userCondition : userConditions) {
                String fieldName = (String)userCondition.get("fieldName");
                FormFieldBean formFieldBean = formBean.getFieldBeanByName(fieldName, true);
                if (formFieldBean == null) continue;
                if (userCondition.get("aliasTableName") == null) {
                    userCondition.put("aliasTableName", formFieldBean.getOwnerTableName());
                }
                if (userCondition.get("fieldType") == null) {
                    userCondition.put("fieldType", formFieldBean.getFieldType());
                }
                if (userCondition.get("inputType") != null) continue;
                userCondition.put("inputType", formFieldBean.getFinalInputType(true));
            }
        }
        return userConditions;
    }
}

