/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.cap4.template.manager.impl;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.seeyon.cap4.form.api.FormApi4Cap4;
import com.seeyon.cap4.form.bean.FormFieldComEnum;
import com.seeyon.cap4.form.bean.FormQueryTypeEnum;
import com.seeyon.cap4.form.bean.FormTableBean;
import com.seeyon.cap4.form.bean.SimpleObjectBean;
import com.seeyon.cap4.form.modules.engin.formula.CustomSelectEnums;
import com.seeyon.cap4.form.modules.engin.formula.FormulaEnums;
import com.seeyon.cap4.form.util.Enums;
import com.seeyon.cap4.template.bean.FilterFieldBean;
import com.seeyon.cap4.template.constant.CAPBusinessEnum;
import com.seeyon.cap4.template.manager.CAPFilterFieldManager;
import com.seeyon.cap4.template.util.CAPFormUtil;
import com.seeyon.cap4.template.vo.FilterFieldVO;
import com.seeyon.ctp.common.exceptions.BusinessException;
import com.seeyon.ctp.common.i18n.ResourceUtil;
import com.seeyon.ctp.form.api.FormApi4Cap3;
import com.seeyon.ctp.form.bean.FormBean;
import com.seeyon.ctp.form.bean.FormFieldBean;
import com.seeyon.ctp.organization.bo.V3xOrgAccount;
import com.seeyon.ctp.organization.bo.V3xOrgDepartment;
import com.seeyon.ctp.organization.bo.V3xOrgMember;
import com.seeyon.ctp.organization.manager.OrgManager;
import com.seeyon.ctp.util.DateUtil;
import com.seeyon.ctp.util.Strings;
import com.seeyon.ctp.util.json.JSONUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.collections.CollectionUtils;

public class CAPFilterFieldManagerImpl
implements CAPFilterFieldManager {
    private OrgManager orgManager;
    private FormApi4Cap4 formApi4Cap4;
    private FormApi4Cap3 formApi4Cap3;
    private static final String NOT_INCLUDE_CHILD = "cap.form.unFlow.list.notIncludeChild";
    private static final String DATE_CUSTOM = "date_custom";
    private static final String CUSTOM_ENUM = "customenum";
    private static final List<CustomSelectEnums.DateTime4CustomSelect> DEFAULT_DATE_ENUMS = new ArrayList<CustomSelectEnums.DateTime4CustomSelect>();
    private static final Enums.FormDataStateEnum[] flowStateFilterEnum;

    @Override
    public List<FilterFieldBean> getFilterFieldBeans(com.seeyon.cap4.form.bean.FormBean formBean, List<SimpleObjectBean> searchFields, FormQueryTypeEnum queryTypeEnum) throws BusinessException {
        ArrayList<FilterFieldBean> fieldBeans = new ArrayList<FilterFieldBean>();
        if (Strings.isNotEmpty(searchFields)) {
            for (SimpleObjectBean simpleObjectBean : searchFields) {
                String fieldName;
                Enums.FlowBusinessFixField fixField;
                if (queryTypeEnum == FormQueryTypeEnum.flowToDoQuery && (fixField = Enums.FlowBusinessFixField.getEnumByKey((String)(fieldName = simpleObjectBean.getName().contains(".") ? simpleObjectBean.getName().split("[.]")[1] : simpleObjectBean.getName()))) != null) {
                    if (!fixField.getSupportUseCase()[2]) continue;
                    FilterFieldBean filterFieldBean = new FilterFieldBean(fixField);
                    filterFieldBean.setTableName("ctp_affair");
                    filterFieldBean.setSimpleObjectInfo(simpleObjectBean);
                    fieldBeans.add(filterFieldBean);
                    continue;
                }
                com.seeyon.cap4.form.bean.FormFieldBean formFieldBean = this.getFormFieldBeanBySimpleObject(formBean, simpleObjectBean);
                if (formFieldBean == null) continue;
                FilterFieldBean filterFieldBean = new FilterFieldBean(formFieldBean);
                filterFieldBean.setSimpleObjectInfo(simpleObjectBean);
                fieldBeans.add(filterFieldBean);
            }
        }
        return fieldBeans;
    }

    @Override
    public List<FilterFieldVO> getFilterFields(List<FilterFieldBean> searchFields) throws BusinessException {
        if (CollectionUtils.isEmpty(searchFields)) {
            return Collections.emptyList();
        }
        HashMap filterFieldVOMap = Maps.newHashMapWithExpectedSize((int)searchFields.size());
        ArrayList filterFields = Lists.newArrayListWithCapacity((int)searchFields.size());
        for (FilterFieldBean fieldBean : searchFields) {
            FilterFieldVO filterFieldVO = this.getFilterField(fieldBean);
            filterFieldVOMap.put(fieldBean.getName(), filterFieldVO);
            filterFields.add(filterFieldVO);
        }
        for (FilterFieldBean fieldBean : searchFields) {
            String toRelationAttr;
            if (fieldBean.getToRelationAttr() == null || !filterFieldVOMap.containsKey(toRelationAttr = fieldBean.getToRelationAttr())) continue;
            String fieldBeanName = fieldBean.getName();
            FilterFieldVO filterFieldVO = (FilterFieldVO)filterFieldVOMap.get(fieldBeanName);
            FilterFieldVO parentField = (FilterFieldVO)filterFieldVOMap.get(toRelationAttr);
            filterFieldVO.setMultiEnum(CAPBusinessEnum.TrueOrFalseEnum.TRUE.getKey());
            filterFieldVO.setParentField(this.getFieldKey(parentField.getAliasTableName(), parentField.getName()));
            ((FilterFieldVO)filterFieldVOMap.get(toRelationAttr)).setHasChildren(CAPBusinessEnum.TrueOrFalseEnum.TRUE.getKey());
        }
        return filterFields;
    }

    @Override
    public FilterFieldVO getFilterField(FilterFieldBean filterFieldBean) throws BusinessException {
        String simpleObjectValue = filterFieldBean.getSimpleObjectValue();
        String displayName = filterFieldBean.getDisplay();
        if (simpleObjectValue != null && !displayName.equals(simpleObjectValue) && simpleObjectValue.indexOf("(") > -1) {
            displayName = simpleObjectValue.substring(simpleObjectValue.indexOf("(") + 1, simpleObjectValue.indexOf(")"));
        }
        FilterFieldVO filterField = new FilterFieldVO();
        filterField.setTableName(filterFieldBean.getTableName());
        filterField.setAliasTableName(filterFieldBean.getTableName());
        filterField.setFieldType(filterFieldBean.getFieldType());
        filterField.setInputType(filterFieldBean.getInputType());
        filterField.setName(filterFieldBean.getName());
        filterField.setDisplay(displayName);
        filterField.setToRelationAttr(filterFieldBean.getToRelationAttr());
        filterField.setLength(filterFieldBean.getFieldLength());
        HashMap<String, Object> defaultValueJson = (HashMap<String, Object>)JSONUtil.parseJSONString((String)filterFieldBean.getSimpleObjectDefaultVal(), Map.class);
        if (defaultValueJson == null) {
            defaultValueJson = new HashMap<String, Object>();
        }
        HashMap<String, Object> defaultValue = new HashMap<String, Object>();
        if (Enums.MasterTableField.state.getKey().equals(filterFieldBean.getName()) || Enums.MasterTableField.ratifyflag.getKey().equals(filterFieldBean.getName()) || Enums.MasterTableField.finishedflag.getKey().equals(filterFieldBean.getName())) {
            this.getFlowStateFilterField(filterField);
        } else if (Enums.FlowBusinessFixField.importantLevel.getKey().equals(filterFieldBean.getName())) {
            this.getFlowImportantLevelFilterField(filterField);
        } else if (Enums.FlowBusinessFixField.archiveId.getKey().equals(filterFieldBean.getName())) {
            CAPBusinessEnum.TrueOrFalseEnum[] vs;
            ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
            for (CAPBusinessEnum.TrueOrFalseEnum tfEnum : vs = CAPBusinessEnum.TrueOrFalseEnum.values()) {
                list.add(this.getCustomEnumMap(Integer.valueOf(tfEnum.getKey()), tfEnum.getI18n(), tfEnum.getKey()));
            }
            filterField.setInputType(CUSTOM_ENUM);
            filterField.setEnums(list);
        } else {
            FormFieldComEnum formFieldComEnum = FormFieldComEnum.getEnumByKey((String)filterFieldBean.getInputType());
            if (formFieldComEnum != null) {
                switch (formFieldComEnum) {
                    case EXTEND_DATE: {
                        this.invokeExtendDate(filterField, defaultValueJson, formFieldComEnum);
                        break;
                    }
                    case EXTEND_DATETIME: {
                        this.invokeExtendDateTime(filterField, defaultValueJson, formFieldComEnum);
                        break;
                    }
                    case RADIO: 
                    case SELECT: 
                    case IMAGE_RADIO: 
                    case IMAGE_SELECT: {
                        com.seeyon.cap4.form.bean.FormFieldBean formFieldBean = null;
                        filterField.setDefaultValue(defaultValue);
                        if (filterFieldBean.isCAP4()) {
                            FormTableBean tableBean = this.formApi4Cap4.getTable(filterFieldBean.getTableName());
                            if (tableBean != null) {
                                com.seeyon.cap4.form.bean.FormBean formBean = this.formApi4Cap4.getForm(tableBean.getFormId().longValue());
                                formFieldBean = formBean.getFieldBeanByName(filterFieldBean.getName());
                            } else {
                                Map filedInfo = (Map)JSONUtil.parseJSONString((String)filterFieldBean.getFieldInfo(), Map.class);
                                formFieldBean = new com.seeyon.cap4.form.bean.FormFieldBean();
                                try {
                                    BeanUtils.populate((Object)formFieldBean, (Map)filedInfo);
                                }
                                catch (Exception e) {
                                    throw new BusinessException((Throwable)e);
                                }
                            }
                        }
                        if (formFieldBean != null) {
                            filterField.setEnums(CAPFormUtil.getFieldEnumJSON(formFieldBean, null, null, true));
                            break;
                        }
                        throw new BusinessException(filterField.getName() + " can't find formFieldBean!");
                    }
                    case TEXT: 
                    case TEXTAREA: {
                        this.invokeTextarea(filterField, defaultValueJson, formFieldComEnum);
                        break;
                    }
                    case EXTEND_MEMBER: 
                    case EXTEND_MULTI_MEMBER: {
                        this.invokeExtendMember(filterField, defaultValueJson, formFieldComEnum);
                        break;
                    }
                    case EXTEND_DEPARTMENT: 
                    case EXTEND_MULTI_DEPARTMENT: {
                        this.invokeExtendDepartment(filterField, defaultValueJson, formFieldComEnum);
                        break;
                    }
                    case EXTEND_ACCOUNT: 
                    case EXTEND_MULTI_ACCOUNT: {
                        this.invokeExtendAccount(filterField, defaultValueJson, formFieldComEnum);
                        break;
                    }
                    case CHECKBOX: {
                        this.invokeCheckbox(filterField, defaultValueJson, formFieldComEnum);
                        break;
                    }
                }
            }
        }
        return filterField;
    }

    private void getFlowImportantLevelFilterField(FilterFieldVO filterField) {
        Enums.FlowImportantLevel[] vs;
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
        for (Enums.FlowImportantLevel flagEnum : vs = Enums.FlowImportantLevel.values()) {
            list.add(this.getCustomEnumMap(flagEnum.getKey(), flagEnum.getI18n(), String.valueOf(flagEnum.getKey())));
        }
        filterField.setInputType(CUSTOM_ENUM);
        filterField.setEnums(list);
    }

    private void getFlowStateFilterField(FilterFieldVO filterField) {
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
        if (Enums.MasterTableField.state.getKey().equals(filterField.getName())) {
            for (Enums.FormDataStateEnum stateEnum : flowStateFilterEnum) {
                list.add(this.getCustomEnumMap(stateEnum.ordinal(), stateEnum.getText(), String.valueOf(stateEnum.getKey())));
            }
        } else if (Enums.MasterTableField.ratifyflag.getKey().equals(filterField.getName())) {
            Enums.FormDataRatifyFlagEnum[] vs;
            for (Enums.FormDataRatifyFlagEnum flagEnum : vs = Enums.FormDataRatifyFlagEnum.values()) {
                list.add(this.getCustomEnumMap(flagEnum.ordinal(), flagEnum.getText(), String.valueOf(flagEnum.getKey())));
            }
        } else if (Enums.MasterTableField.finishedflag.getKey().equals(filterField.getName())) {
            Enums.FromDataFinishedFlagEnum[] vs;
            for (Enums.FromDataFinishedFlagEnum flagEnum : vs = Enums.FromDataFinishedFlagEnum.values()) {
                list.add(this.getCustomEnumMap(flagEnum.ordinal(), flagEnum.getText(), String.valueOf(flagEnum.getKey())));
            }
        }
        filterField.setInputType(CUSTOM_ENUM);
        filterField.setEnums(list);
    }

    private Map<String, Object> getCustomEnumMap(Integer id, String showValue, String enumValue) {
        HashMap<String, Object> map = new HashMap<String, Object>(3);
        map.put("id", String.valueOf(id));
        map.put("showValue", showValue);
        map.put("enumValue", enumValue);
        return map;
    }

    private void invokeExtendDate(FilterFieldVO filterField, Map<String, Object> defaultValueJson, FormFieldComEnum formFieldComEnum) {
        HashMap<String, Object> defaultValue = new HashMap<String, Object>();
        List<Object> enums = new ArrayList();
        Map dateYzxxValueJson = (Map)defaultValueJson.get("dateTimeYzxxValue");
        if (dateYzxxValueJson != null) {
            List rightArray = (List)dateYzxxValueJson.get("rightArray");
            for (Map rightObject : rightArray) {
                HashMap tempEnum = new HashMap();
                tempEnum.put("showValue", rightObject.get("name"));
                tempEnum.put("id", rightObject.get("value"));
                tempEnum.put("enumValue", rightObject.get("value"));
                if ("false".equals(String.valueOf(rightObject.get("isSystemVar")))) {
                    String[] datas = String.valueOf(rightObject.get("value")).split("\\|");
                    tempEnum.put("startTime", datas[0]);
                    tempEnum.put("endTime", datas[1]);
                    tempEnum.put("id", DATE_CUSTOM);
                    tempEnum.put("enumValue", DATE_CUSTOM);
                } else {
                    String enumKey = String.valueOf(rightObject.get("value"));
                    Date[] datas = CustomSelectEnums.DateTime4CustomSelect.getEnumByKey(enumKey).getTimeValue();
                    tempEnum.put("startTime", DateUtil.format((Date)datas[0], (String)"yyyy-MM-dd"));
                    tempEnum.put("endTime", DateUtil.format((Date)datas[1], (String)"yyyy-MM-dd"));
                }
                enums.add(tempEnum);
            }
        } else {
            enums = this.getDefaultTimeEnum(formFieldComEnum);
        }
        if (enums.size() >= 1 && defaultValueJson.get("defaultCheckFirst") != null && "1".equals(defaultValueJson.get("defaultCheckFirst"))) {
            Map firstJson = (Map)enums.get(0);
            defaultValue.put("value", firstJson.get("enumValue"));
            defaultValue.put("showValue", firstJson.get("showValue"));
            defaultValue.put("showValue2", firstJson.get("enumValue"));
            defaultValue.put("startTime", firstJson.get("startTime"));
            defaultValue.put("endTime", firstJson.get("endTime"));
        }
        filterField.setDefaultValue(defaultValue);
        filterField.setEnums(enums);
    }

    private void invokeExtendDateTime(FilterFieldVO filterField, Map<String, Object> defaultValueJson, FormFieldComEnum formFieldComEnum) {
        HashMap<String, Object> defaultValue = new HashMap<String, Object>();
        List<Object> enums = new ArrayList();
        Map dateTimeYzxxValueJson = (Map)defaultValueJson.get("dateTimeYzxxValue");
        if (dateTimeYzxxValueJson != null) {
            List rightArray = (List)dateTimeYzxxValueJson.get("rightArray");
            for (Map rightObject : rightArray) {
                HashMap tempEnum = new HashMap();
                tempEnum.put("id", rightObject.get("value"));
                tempEnum.put("showValue", rightObject.get("name"));
                tempEnum.put("enumValue", rightObject.get("value"));
                if ("false".equals(String.valueOf(rightObject.get("isSystemVar")))) {
                    String[] datas = String.valueOf(rightObject.get("value")).split("\\|");
                    tempEnum.put("startTime", datas[0]);
                    tempEnum.put("endTime", datas[1]);
                    tempEnum.put("id", DATE_CUSTOM);
                    tempEnum.put("enumValue", DATE_CUSTOM);
                } else {
                    String enumKey = String.valueOf(rightObject.get("value"));
                    Date[] datas = CustomSelectEnums.DateTime4CustomSelect.getEnumByKey(enumKey).getTimeValue();
                    tempEnum.put("startTime", DateUtil.format((Date)datas[0], (String)"yyyy-MM-dd HH:mm"));
                    tempEnum.put("endTime", DateUtil.format((Date)datas[1], (String)"yyyy-MM-dd HH:mm"));
                }
                enums.add(tempEnum);
            }
        } else {
            enums = this.getDefaultTimeEnum(formFieldComEnum);
        }
        if (enums.size() >= 1 && defaultValueJson.get("defaultCheckFirst") != null && "1".equals(defaultValueJson.get("defaultCheckFirst"))) {
            Map firstJson = (Map)enums.get(0);
            defaultValue.put("value", firstJson.get("enumValue"));
            defaultValue.put("showValue", firstJson.get("showValue"));
            defaultValue.put("showValue2", firstJson.get("enumValue"));
            defaultValue.put("startTime", firstJson.get("startTime"));
            defaultValue.put("endTime", firstJson.get("endTime"));
        }
        filterField.setDefaultValue(defaultValue);
        filterField.setEnums(enums);
    }

    private void invokeTextarea(FilterFieldVO filterField, Map<String, Object> defaultValueJson, FormFieldComEnum formFieldComEnum) throws BusinessException {
        HashMap<String, Object> defaultValue = new HashMap<String, Object>();
        ArrayList<Map<String, Object>> enums = new ArrayList<Map<String, Object>>();
        if ("true".equals(defaultValueJson.get("isSettingDefaultVal")) && defaultValueJson.containsKey("defaultVal")) {
            String defaultVal = (String)defaultValueJson.get("defaultVal");
            if ("extend".equals(defaultValueJson.get("defaultType"))) {
                String showValue = "";
                FormulaEnums.FormulaVar formulaVar = FormulaEnums.FormulaVar.getEnumByKey((String)defaultVal);
                CustomSelectEnums.SystemVar4CustomSelect systemVar4CustomSelect = CustomSelectEnums.SystemVar4CustomSelect.getEnumByKey(defaultVal);
                if (formulaVar != null) {
                    showValue = formulaVar.getValue();
                }
                if (systemVar4CustomSelect != null) {
                    showValue = systemVar4CustomSelect.getIdValue();
                }
                defaultValue.put("value", showValue);
                defaultValue.put("showValue", showValue);
                defaultValue.put("showValue2", defaultVal);
            } else {
                defaultValue.put("value", defaultVal);
                defaultValue.put("showValue", defaultVal);
                defaultValue.put("showValue2", defaultVal);
            }
        }
        filterField.setDefaultValue(defaultValue);
        filterField.setEnums(enums);
    }

    private void invokeExtendMember(FilterFieldVO filterField, Map<String, Object> defaultValueJson, FormFieldComEnum formFieldComEnum) throws BusinessException {
        HashMap<String, Object> defaultValue = new HashMap<String, Object>();
        ArrayList<Map<String, Object>> enums = new ArrayList<Map<String, Object>>();
        if (defaultValueJson.get("handOrgIds") != null && defaultValueJson.get("isSettingDefaultVal") != null && "true".equals(defaultValueJson.get("isSettingDefaultVal"))) {
            if ("extend".equals(defaultValueJson.get("defaultType"))) {
                String defaultVal = (String)defaultValueJson.get("defaultVal");
                String showValue = "";
                FormulaEnums.FormulaVar formulaVar = FormulaEnums.FormulaVar.getEnumByKey((String)defaultVal);
                CustomSelectEnums.SystemVar4CustomSelect systemVar4CustomSelect = CustomSelectEnums.SystemVar4CustomSelect.getEnumByKey(defaultVal);
                if (formulaVar != null) {
                    showValue = formulaVar.getValue();
                }
                if (systemVar4CustomSelect != null) {
                    showValue = systemVar4CustomSelect.getIdValue();
                }
                if (Strings.isNotBlank((String)showValue)) {
                    String[] menberStringIds = showValue.split(",");
                    StringBuilder sb = new StringBuilder();
                    StringBuilder relaValueSb = new StringBuilder();
                    for (int i = 0; i < menberStringIds.length; ++i) {
                        Long memberId = Long.valueOf(menberStringIds[i]);
                        V3xOrgMember v3xOrgMember = this.orgManager.getMemberById(memberId);
                        if (i == menberStringIds.length - 1) {
                            sb.append(v3xOrgMember.getName());
                            relaValueSb.append("Member|").append(memberId);
                            continue;
                        }
                        sb.append(v3xOrgMember.getName()).append(",");
                        relaValueSb.append("Member|").append(memberId).append(",");
                    }
                    defaultValue.put("value", relaValueSb.toString());
                    defaultValue.put("showValue", sb.toString());
                    defaultValue.put("showValue2", defaultVal);
                }
            } else {
                StringBuilder showValueSb = new StringBuilder();
                StringBuilder sb = new StringBuilder();
                String value = (String)defaultValueJson.get("handOrgIds");
                if (value.contains(",")) {
                    String[] values = value.split(",");
                    for (int i = 0; i < values.length; ++i) {
                        Long memberId = Long.valueOf(values[i]);
                        V3xOrgMember v3xOrgMember = this.orgManager.getMemberById(memberId);
                        if (i == values.length - 1) {
                            sb.append("Member|").append(memberId);
                            showValueSb.append(v3xOrgMember.getName());
                            continue;
                        }
                        sb.append("Member|").append(memberId).append(",");
                        showValueSb.append(v3xOrgMember.getName()).append(",");
                    }
                } else {
                    V3xOrgMember v3xOrgMember = this.orgManager.getMemberById(Long.valueOf(value));
                    showValueSb.append(v3xOrgMember.getName());
                    sb.append("Member|").append(value);
                }
                defaultValue.put("value", sb.toString());
                defaultValue.put("showValue", showValueSb.toString());
                defaultValue.put("showValue2", sb.toString());
            }
        }
        filterField.setDefaultValue(defaultValue);
        filterField.setEnums(enums);
    }

    private void invokeExtendDepartment(FilterFieldVO filterField, Map<String, Object> defaultValueJson, FormFieldComEnum formFieldComEnum) throws BusinessException {
        HashMap<String, Object> defaultValue = new HashMap<String, Object>();
        ArrayList<Map<String, Object>> enums = new ArrayList<Map<String, Object>>();
        if (defaultValueJson.get("isSettingDefaultVal") != null && "true".equals(defaultValueJson.get("isSettingDefaultVal"))) {
            if ("extend".equals(defaultValueJson.get("defaultType"))) {
                String defaultVal = (String)defaultValueJson.get("defaultVal");
                String showValue = "";
                FormulaEnums.FormulaVar formulaVar = FormulaEnums.FormulaVar.getEnumByKey((String)defaultVal);
                CustomSelectEnums.SystemVar4CustomSelect systemVar4CustomSelect = CustomSelectEnums.SystemVar4CustomSelect.getEnumByKey(defaultVal);
                if (formulaVar != null) {
                    showValue = formulaVar.getValue();
                }
                if (systemVar4CustomSelect != null) {
                    showValue = systemVar4CustomSelect.getIdValue();
                }
                if (Strings.isNotBlank((String)showValue)) {
                    String[] departmentStringIds = showValue.split(",");
                    StringBuilder sb = new StringBuilder();
                    StringBuilder relaValueSb = new StringBuilder();
                    for (int i = 0; i < departmentStringIds.length; ++i) {
                        String departmentId = departmentStringIds[i];
                        V3xOrgDepartment v3xOrgDepartment = this.orgManager.getDepartmentById(Long.valueOf(departmentId));
                        String departmentName = v3xOrgDepartment.getName();
                        if (systemVar4CustomSelect != null) {
                            switch (systemVar4CustomSelect) {
                                case org_currentUserDepartmentId: 
                                case org_currentUserJZDeptId: 
                                case org_currentUserSuperiorDeptId: {
                                    departmentId = showValue + "|1";
                                    departmentName = departmentName + ResourceUtil.getString((String)NOT_INCLUDE_CHILD);
                                }
                            }
                        }
                        if (i == departmentStringIds.length - 1) {
                            sb.append(departmentName);
                            relaValueSb.append("Department|").append(departmentId);
                            continue;
                        }
                        sb.append(departmentName).append(",");
                        relaValueSb.append("Department|").append(departmentId).append(",");
                    }
                    defaultValue.put("value", relaValueSb.toString());
                    defaultValue.put("showValue", sb.toString());
                    defaultValue.put("showValue2", defaultVal);
                }
            } else {
                StringBuilder showValueSb = new StringBuilder();
                StringBuilder sb = new StringBuilder();
                String value = (String)defaultValueJson.get("handOrgIds");
                if ((value = value.replace("BusinessDepartment|", "")).contains(",")) {
                    String[] values = value.split(",");
                    for (int i = 0; i < values.length; ++i) {
                        Long departmementId = Long.valueOf(values[i]);
                        V3xOrgDepartment v3xOrgDepartment = this.orgManager.getDepartmentById(departmementId);
                        String type = "Department";
                        if (4 == v3xOrgDepartment.getExternalType()) {
                            type = "BusinessDepartment";
                        }
                        String showName = v3xOrgDepartment.getName();
                        if (type.equals("BusinessDepartment")) {
                            V3xOrgAccount father = this.orgManager.getAccountById(v3xOrgDepartment.getOrgAccountId());
                            V3xOrgAccount grandfather = (V3xOrgAccount)this.orgManager.getAllParentAccount(v3xOrgDepartment.getOrgAccountId()).get(0);
                            showName = father.getShortName() + "(" + grandfather.getShortName() + ")-" + v3xOrgDepartment.getName();
                        }
                        if (i == values.length - 1) {
                            sb.append(type).append("|").append(departmementId);
                            showValueSb.append(showName);
                            continue;
                        }
                        sb.append(type).append("|").append(departmementId).append(",");
                        showValueSb.append(showName).append(",");
                    }
                } else {
                    V3xOrgDepartment v3xOrgDepartment = this.orgManager.getDepartmentById(Long.valueOf(value));
                    String type = "Department";
                    if (4 == v3xOrgDepartment.getExternalType()) {
                        type = "BusinessDepartment";
                    }
                    String showName = v3xOrgDepartment.getName();
                    if (type.equals("BusinessDepartment")) {
                        V3xOrgAccount father = this.orgManager.getAccountById(v3xOrgDepartment.getOrgAccountId());
                        V3xOrgAccount grandfather = (V3xOrgAccount)this.orgManager.getAllParentAccount(v3xOrgDepartment.getOrgAccountId()).get(0);
                        showName = father.getShortName() + "(" + grandfather.getShortName() + ")-" + v3xOrgDepartment.getName();
                    }
                    showValueSb.append(showName);
                    sb.append(type).append("|").append(value);
                }
                defaultValue.put("value", sb.toString());
                defaultValue.put("showValue", showValueSb.toString());
                defaultValue.put("showValue2", sb.toString());
            }
        }
        filterField.setDefaultValue(defaultValue);
        filterField.setEnums(enums);
    }

    private void invokeExtendAccount(FilterFieldVO filterField, Map<String, Object> defaultValueJson, FormFieldComEnum formFieldComEnum) throws BusinessException {
        HashMap<String, Object> defaultValue = new HashMap<String, Object>();
        ArrayList<Map<String, Object>> enums = new ArrayList<Map<String, Object>>();
        if (defaultValueJson.get("isSettingDefaultVal") != null && "true".equals(defaultValueJson.get("isSettingDefaultVal"))) {
            if ("extend".equals(defaultValueJson.get("defaultType"))) {
                String defaultVal = (String)defaultValueJson.get("defaultVal");
                String showValue = "";
                FormulaEnums.FormulaVar formulaVar = FormulaEnums.FormulaVar.getEnumByKey((String)defaultVal);
                CustomSelectEnums.SystemVar4CustomSelect systemVar4CustomSelect = CustomSelectEnums.SystemVar4CustomSelect.getEnumByKey(defaultVal);
                if (formulaVar != null) {
                    showValue = formulaVar.getValue();
                }
                if (systemVar4CustomSelect != null) {
                    showValue = systemVar4CustomSelect.getIdValue();
                }
                if (Strings.isNotBlank((String)showValue)) {
                    String[] accountStringIds = showValue.split(",");
                    StringBuilder sb = new StringBuilder();
                    StringBuilder relaValueSb = new StringBuilder();
                    for (int i = 0; i < accountStringIds.length; ++i) {
                        Long accountId = Long.valueOf(accountStringIds[i]);
                        V3xOrgAccount v3xOrgAccount = this.orgManager.getAccountById(accountId);
                        if (i == accountStringIds.length - 1) {
                            sb.append(v3xOrgAccount.getName());
                            relaValueSb.append("Account|").append(accountId);
                            continue;
                        }
                        sb.append(v3xOrgAccount.getName()).append(",");
                        relaValueSb.append("Account|").append(accountId).append(",");
                    }
                    defaultValue.put("value", relaValueSb.toString());
                    defaultValue.put("showValue", sb.toString());
                    defaultValue.put("showValue2", defaultVal);
                }
            } else {
                StringBuilder showValueSb = new StringBuilder();
                StringBuilder sb = new StringBuilder();
                String value = (String)defaultValueJson.get("handOrgIds");
                if (value.contains(",")) {
                    String[] values = value.split(",");
                    for (int i = 0; i < values.length; ++i) {
                        Long accountId = Long.valueOf(values[i]);
                        V3xOrgAccount v3xOrgAccount = this.orgManager.getAccountById(accountId);
                        if (i == values.length - 1) {
                            sb.append("Account|").append(accountId);
                            showValueSb.append(v3xOrgAccount.getName());
                            continue;
                        }
                        sb.append("Account|").append(accountId).append(",");
                        showValueSb.append(v3xOrgAccount.getName()).append(",");
                    }
                } else {
                    V3xOrgAccount v3xOrgAccount = this.orgManager.getAccountById(Long.valueOf(value));
                    showValueSb.append(v3xOrgAccount.getName());
                    sb.append("Account|").append(value);
                }
                defaultValue.put("value", sb.toString());
                defaultValue.put("showValue", showValueSb.toString());
                defaultValue.put("showValue2", sb.toString());
            }
        }
        filterField.setDefaultValue(defaultValue);
        filterField.setEnums(enums);
    }

    private void invokeCheckbox(FilterFieldVO filterField, Map<String, Object> defaultValueJson, FormFieldComEnum formFieldComEnum) throws BusinessException {
        String defaultVal;
        HashMap<String, Object> defaultValue = new HashMap<String, Object>();
        ArrayList<Map<String, Object>> enums = new ArrayList<Map<String, Object>>();
        if (defaultValueJson.get("isSettingDefaultVal") != null && "true".equals(defaultValueJson.get("isSettingDefaultVal")) && "1".equals(defaultVal = (String)defaultValueJson.get("defaultVal"))) {
            defaultValue.put("value", defaultVal);
            defaultValue.put("showValue", defaultVal);
            defaultValue.put("showValue2", defaultVal);
        }
        filterField.setDefaultValue(defaultValue);
        filterField.setEnums(enums);
    }

    private String getFieldKey(String tableName, String fieldName) {
        return tableName + "_" + fieldName;
    }

    private List<Map<String, Object>> getDefaultTimeEnum(FormFieldComEnum formFieldComEnum) {
        ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>();
        for (CustomSelectEnums.DateTime4CustomSelect dateTime4CustomSelect : DEFAULT_DATE_ENUMS) {
            HashMap<String, String> tempEnum = new HashMap<String, String>();
            tempEnum.put("id", dateTime4CustomSelect.getKey());
            tempEnum.put("showValue", dateTime4CustomSelect.getText());
            tempEnum.put("enumValue", dateTime4CustomSelect.getKey());
            Date[] datas = CustomSelectEnums.DateTime4CustomSelect.getEnumByKey(dateTime4CustomSelect.getKey()).getTimeValue();
            tempEnum.put("startTime", this.getFormatDate(formFieldComEnum, datas[0]));
            tempEnum.put("endTime", this.getFormatDate(formFieldComEnum, datas[1]));
            result.add(tempEnum);
        }
        return result;
    }

    private String getFormatDate(FormFieldComEnum formFieldComEnum, Date date) {
        String formatDate = "";
        switch (formFieldComEnum) {
            case EXTEND_DATETIME: {
                formatDate = DateUtil.format((Date)date, (String)"yyyy-MM-dd HH:mm");
                break;
            }
            case EXTEND_DATE: {
                formatDate = DateUtil.format((Date)date, (String)"yyyy-MM-dd");
                break;
            }
        }
        return formatDate;
    }

    @Override
    public com.seeyon.cap4.form.bean.FormFieldBean getFormFieldBeanBySimpleObject(com.seeyon.cap4.form.bean.FormBean formBean, SimpleObjectBean sob) {
        String fieldName = sob.getName().contains(".") ? sob.getName().split("[.]")[1] : sob.getName();
        return formBean.getFieldBeanByName(fieldName, true);
    }

    @Override
    public FormFieldBean getFormFieldBeanBySimpleObject(FormBean formBean, SimpleObjectBean sob) {
        String fieldName = sob.getName().contains(".") ? sob.getName().split("[.]")[1] : sob.getName();
        return formBean.getFieldBeanByName(fieldName, true);
    }

    public void setOrgManager(OrgManager orgManager) {
        this.orgManager = orgManager;
    }

    public void setFormApi4Cap4(FormApi4Cap4 formApi4Cap4) {
        this.formApi4Cap4 = formApi4Cap4;
    }

    public void setFormApi4Cap3(FormApi4Cap3 formApi4Cap3) {
        this.formApi4Cap3 = formApi4Cap3;
    }

    static {
        DEFAULT_DATE_ENUMS.add(CustomSelectEnums.DateTime4CustomSelect.date_thisyear);
        DEFAULT_DATE_ENUMS.add(CustomSelectEnums.DateTime4CustomSelect.date_thisSeason);
        DEFAULT_DATE_ENUMS.add(CustomSelectEnums.DateTime4CustomSelect.date_thisMonth);
        DEFAULT_DATE_ENUMS.add(CustomSelectEnums.DateTime4CustomSelect.date_thisWeek);
        DEFAULT_DATE_ENUMS.add(CustomSelectEnums.DateTime4CustomSelect.date_today);
        DEFAULT_DATE_ENUMS.add(CustomSelectEnums.DateTime4CustomSelect.date_preMonth);
        flowStateFilterEnum = new Enums.FormDataStateEnum[]{Enums.FormDataStateEnum.FLOW_DRAFT, Enums.FormDataStateEnum.FLOW_UNAUDITED, Enums.FormDataStateEnum.FLOW_AUDITEDPASS, Enums.FormDataStateEnum.FLOW_AUDITEDUNPASS};
    }
}

