/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.cap4.template.manager.impl;

import com.seeyon.cap4.form.bean.FormBean;
import com.seeyon.cap4.form.bean.FormBindAuthBean;
import com.seeyon.cap4.form.bean.FormFlowBusinessBean;
import com.seeyon.cap4.form.util.Enums;
import com.seeyon.cap4.template.manager.CAPFlowButtonManager;
import com.seeyon.cap4.template.manager.impl.AbstractCAPButtonManager;
import com.seeyon.cap4.template.vo.FlowListButtonVO;
import com.seeyon.ctp.util.Strings;
import com.seeyon.ctp.util.json.JSONUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class CAPFlowButtonManagerImpl
extends AbstractCAPButtonManager
implements CAPFlowButtonManager {
    @Override
    public List<FlowListButtonVO> getButtons(FormBean formBean, FormFlowBusinessBean businessBean, Enums.ViewType viewType, FormBindAuthBean.ShowPosition showPosition) {
        List<FlowListButtonVO> vos = null;
        if ("pending".equals(businessBean.getType())) {
            List buttons = businessBean.getAllBtnListByBtnOrder(viewType, showPosition);
            vos = this.getToDoButtons(formBean, businessBean, buttons, viewType, showPosition);
        } else if ("integrated".equals(businessBean.getType())) {
            // empty if block
        }
        return vos;
    }

    private List<FlowListButtonVO> getToDoButtons(FormBean formBean, FormFlowBusinessBean businessBean, List<Map<String, String>> buttons, Enums.ViewType viewType, FormBindAuthBean.ShowPosition showPosition) {
        ArrayList<FlowListButtonVO> buttonList = new ArrayList<FlowListButtonVO>();
        for (Map<String, String> button : buttons) {
            Map position;
            if (button == null || button.isEmpty() || "false".equals((position = (Map)JSONUtil.parseJSONString((String)button.get("position"), Map.class)).get(showPosition.getKey()))) continue;
            String value = button.get("value");
            FlowListButtonVO btn = new FlowListButtonVO();
            btn.setName(button.get("display"));
            btn.setType(button.get("name"));
            btn.setValue(value);
            btn.setPosition(showPosition.getKey());
            this.setButtonCustomInfo(businessBean.getCustomBtnInfoById(button.get("name")), button, btn, viewType);
            if (("false".equals(value) || Strings.isBlank((String)value)) && Strings.isBlank((String)button.get("isCustomBtn"))) continue;
            buttonList.add(btn);
        }
        return buttonList;
    }
}

