/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.cap4.template.manager.impl;

import com.seeyon.cap4.form.bean.FormAuthViewBean;
import com.seeyon.cap4.form.bean.FormAuthViewFieldBean;
import com.seeyon.cap4.form.bean.FormBean;
import com.seeyon.cap4.form.bean.FormFieldBean;
import com.seeyon.cap4.form.bean.FormViewBean;
import com.seeyon.cap4.form.util.Enums;
import com.seeyon.cap4.template.bean.FormDataListFormatBean;
import com.seeyon.cap4.template.constant.CAPBusinessEnum;
import com.seeyon.cap4.template.constant.CAPFlowEnum;
import com.seeyon.cap4.template.manager.CAPFlowToDoFormatManager;
import com.seeyon.cap4.template.manager.impl.AbstractCAPDataListFormatManager;
import com.seeyon.cap4.template.vo.ListFieldVO;
import com.seeyon.ctp.common.content.affair.constants.StateEnum;
import com.seeyon.ctp.common.content.affair.constants.SubStateEnum;
import com.seeyon.ctp.common.ctpenumnew.EnumNameEnum;
import com.seeyon.ctp.common.exceptions.BusinessException;
import com.seeyon.ctp.common.i18n.ResourceUtil;
import com.seeyon.ctp.common.log.CtpLogFactory;
import com.seeyon.ctp.common.permission.manager.PermissionManager;
import com.seeyon.ctp.common.track.enums.TrackEnum;
import com.seeyon.ctp.organization.bo.V3xOrgMember;
import com.seeyon.ctp.util.DateUtil;
import com.seeyon.ctp.util.Strings;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.logging.Log;

public class CAPFlowToDoFormatManagerImpl
extends AbstractCAPDataListFormatManager
implements CAPFlowToDoFormatManager {
    private static final Log LOGGER = CtpLogFactory.getLog(CAPFlowToDoFormatManagerImpl.class);
    private PermissionManager permissionManager;

    @Override
    public List<Map<String, Object>> format(FormBean formBean, List<Map<String, Object>> formDataList, FormDataListFormatBean paramFormatBean) throws BusinessException {
        if (Strings.isEmpty(formDataList)) {
            return new ArrayList<Map<String, Object>>();
        }
        ArrayList<Map<String, Object>> resultList = new ArrayList<Map<String, Object>>(formDataList.size());
        Set<String> displayImageFields = this.getDisplayImageFields(formBean, paramFormatBean.getShowFields());
        Map<String, List<Map<String, String>>> capFormAttachmentsMap = this.getDataAttachmentMap(formDataList, this.hasImageField(paramFormatBean.getShowFields()), CAPFlowEnum.ToDoAffairField.SUMMARY_ID.getKey());
        for (Map<String, Object> dataMap : formDataList) {
            resultList.add(this.getOneLineAppointDisplayValue(formBean, dataMap, displayImageFields, paramFormatBean, capFormAttachmentsMap));
        }
        return resultList;
    }

    private Map<String, Object> getOneLineAppointDisplayValue(FormBean formBean, Map<String, Object> dataMap, Set<String> displayImageFields, FormDataListFormatBean paramFormatBean, Map<String, List<Map<String, String>>> capFormAttachmentsMap) throws BusinessException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        try {
            HashMap<String, String> fixedField = new HashMap<String, String>(5);
            fixedField.put("formMasterId", MapUtils.getString(dataMap, (Object)CAPFlowEnum.ToDoAffairField.FORM_RECORD_ID.getKey()));
            fixedField.put("affairId", MapUtils.getString(dataMap, (Object)CAPFlowEnum.ToDoAffairField.AFFAIR_ID.getKey()));
            fixedField.put("summaryId", MapUtils.getString(dataMap, (Object)CAPFlowEnum.ToDoAffairField.SUMMARY_ID.getKey()));
            fixedField.put("category", MapUtils.getString(dataMap, (Object)Enums.FlowBusinessFixField.category.getKey()));
            fixedField.put("subject", MapUtils.getString(dataMap, (Object)Enums.FlowBusinessFixField.flowTitle.getKey()));
            map.put("fixedField", fixedField);
            map.put("id", MapUtils.getString(dataMap, (Object)CAPFlowEnum.ToDoAffairField.FORM_RECORD_ID.getKey()));
            String rightId = MapUtils.getString(dataMap, (Object)CAPFlowEnum.ToDoAffairField.FORM_MULTI_OPERATION_ID.getKey());
            FormAuthViewBean authViewBean = this.getFormAuthViewBean(formBean, rightId, paramFormatBean);
            for (ListFieldVO fieldVO : paramFormatBean.getShowFields()) {
                Object value;
                String key = fieldVO.getFieldName();
                String auth = fieldVO.getAuth();
                HashMap<String, Object> fieldData = new HashMap<String, Object>(1);
                if (key.contains("field")) {
                    FormFieldBean fieldBean = formBean.getFieldBeanByName(key);
                    if (authViewBean != null) {
                        FormAuthViewFieldBean authViewFieldBean = authViewBean.getFormAuthorizationField(fieldBean.getName());
                        auth = authViewFieldBean == null ? auth : authViewFieldBean.getAccess();
                    }
                    Object v = this.getFormFieldDisplayValue(formBean, fieldBean, dataMap, auth, displayImageFields, paramFormatBean, capFormAttachmentsMap);
                    value = fieldBean.isImageEnumField() ? this.resetEnumImageValue(v, fieldData) : v;
                } else {
                    value = this.getConstantFieldValue(formBean.getFormType(), key, dataMap);
                }
                fieldData.put("value", value);
                map.put(key, fieldData);
            }
        }
        catch (Exception e) {
            LOGGER.error((Object)"\u6d41\u7a0b\u5f85\u529e\u5217\u8868\u6570\u636e\u7ec4\u88c5\u5f02\u5e38", (Throwable)e);
            throw new BusinessException((Throwable)e);
        }
        return map;
    }

    private FormAuthViewBean getFormAuthViewBean(FormBean formBean, String rightId, FormDataListFormatBean paramFormatBean) {
        FormAuthViewBean formAuthViewBean;
        if (Strings.isEmpty((String)rightId)) {
            return null;
        }
        FormAuthViewBean authViewBean = null;
        if (rightId.contains("_") || rightId.contains(".")) {
            String[] viewStrs = rightId.split("_");
            for (int i = 0; i < viewStrs.length && authViewBean == null; ++i) {
                String rightIdStr = viewStrs[i].contains(".") ? viewStrs[i].split("\\.")[1].split("[|]")[0] : viewStrs[i].split("[|]")[0];
                FormAuthViewBean formAuthViewBean2 = formBean.getAuthViewBeanById(Long.valueOf(Long.parseLong(rightIdStr)));
                if (formAuthViewBean2 == null) continue;
                FormViewBean formViewBean = formBean.getFormView(formAuthViewBean2.getFormViewId());
                if (Enums.ViewType.SeeyonForm.equals((Object)paramFormatBean.getViewType()) && formViewBean.isPc()) {
                    authViewBean = formAuthViewBean2;
                    continue;
                }
                if (!Enums.ViewType.Phone.equals((Object)paramFormatBean.getViewType()) || !formViewBean.isPhone()) continue;
                authViewBean = formAuthViewBean2;
            }
        }
        if (authViewBean == null && (formAuthViewBean = formBean.getAuthViewBeanById(Long.valueOf(Long.parseLong(rightId)))) != null) {
            FormViewBean formViewBean = formBean.getFormView(formAuthViewBean.getFormViewId());
            if (Enums.ViewType.SeeyonForm.equals((Object)paramFormatBean.getViewType()) && formViewBean.isPc() || Enums.ViewType.Phone.equals((Object)paramFormatBean.getViewType()) && formViewBean.isPhone()) {
                authViewBean = formAuthViewBean;
            }
        }
        return authViewBean;
    }

    @Override
    public Object getConstantFieldValue(int formType, String fieldName, Map<String, Object> dataMap) throws Exception {
        Object value = dataMap.get(fieldName);
        Enums.FlowBusinessFixField fixField = Enums.FlowBusinessFixField.getEnumByKey((String)fieldName);
        if (fixField != null) {
            switch (fixField) {
                case processDeadlineTime: 
                case createDate: 
                case updateDate: 
                case receiveTime: 
                case expectedProcessTime: {
                    value = value == null ? null : DateUtil.formatDateTime((Date)((Date)value));
                    break;
                }
                case senderId: 
                case preApprover: {
                    if (value == null) break;
                    V3xOrgMember member = this.orgManager.getMemberById(Long.valueOf(Long.parseLong(value.toString())));
                    value = member == null ? value : member.getName();
                    break;
                }
                case importantLevel: {
                    value = this.getImportantLevel(value);
                    break;
                }
                case archiveId: {
                    value = ResourceUtil.getString((String)(value != null ? "cap.template.common.yes" : "cap.template.common.no"));
                    break;
                }
                case affairState: {
                    value = value != null ? ResourceUtil.getString((String)("collaboration.toolTip.label" + value.toString())) : value;
                    break;
                }
                case subState: {
                    boolean isSpecialBack;
                    if (value == null) break;
                    Integer subState = Integer.valueOf(value.toString());
                    String subStateName = ResourceUtil.getString((String)("collaboration.substate." + subState + ".label"));
                    boolean isWaitSend = Integer.valueOf(StateEnum.col_waitSend.getKey()).equals(subState);
                    boolean bl = isSpecialBack = Integer.valueOf(SubStateEnum.col_pending_specialBackToSenderCancel.getKey()).equals(subState) || Integer.valueOf(SubStateEnum.col_pending_specialBacked.getKey()).equals(subState);
                    if (isWaitSend && isSpecialBack) {
                        subStateName = ResourceUtil.getString((String)("collaboration.substate." + SubStateEnum.col_waitSend_stepBack.getKey() + ".label"));
                    }
                    value = subStateName;
                    break;
                }
                case nodePolicy: {
                    if (value == null) break;
                    value = this.permissionManager.getPermissionName(EnumNameEnum.col_flow_perm_policy.name(), value.toString(), MapUtils.getLong(dataMap, (Object)CAPFlowEnum.ToDoAffairField.ORG_ACCOUNT_ID.getKey()));
                    break;
                }
                case isCoverTime: {
                    if (value == null) break;
                    value = this.getIsCoverTime(Integer.valueOf(value.toString()), dataMap);
                    break;
                }
                case trackState: {
                    CAPBusinessEnum.TrueOrFalseEnum anEnum = CAPBusinessEnum.TrueOrFalseEnum.getEnum(this.getTrackState(Integer.valueOf(value.toString())));
                    value = anEnum.getI18n();
                    break;
                }
            }
        }
        return value == null ? "" : value.toString();
    }

    private String getImportantLevel(Object levelObj) {
        if (levelObj == null) {
            return "";
        }
        Enums.FlowImportantLevel level = Enums.FlowImportantLevel.getEnumByKey((int)Integer.valueOf(levelObj.toString()));
        return level == null ? "" : level.getI18n();
    }

    private boolean getTrackState(Integer track) {
        if (track == null) {
            return false;
        }
        return track.equals(TrackEnum.all.ordinal()) || track.equals(TrackEnum.part.ordinal());
    }

    private String getIsCoverTime(Integer isCoverTime, Map<String, Object> dataMap) {
        Date completeTime;
        Date expectedProcessTime = dataMap.get(Enums.FlowBusinessFixField.expectedProcessTime.getKey()) == null ? null : (Date)dataMap.get(Enums.FlowBusinessFixField.expectedProcessTime.getKey());
        Integer isCover = this.getIsCoverTime(expectedProcessTime, isCoverTime, completeTime = dataMap.get(CAPFlowEnum.ToDoAffairField.COMPLETE_TIME.getKey()) == null ? null : (Date)dataMap.get(CAPFlowEnum.ToDoAffairField.COMPLETE_TIME.getKey()));
        if (isCover == null || isCover == 0) {
            return ResourceUtil.getString((String)"workflow.nodeProperty.time.isovertoptime.false");
        }
        return ResourceUtil.getString((String)"workflow.nodeProperty.time.isovertoptime.true");
    }

    private Integer getIsCoverTime(Date expectedProcessTime, Integer isCoverTime, Date completeTime) {
        if (expectedProcessTime == null) {
            return isCoverTime;
        }
        Integer isOverTime = completeTime == null ? (expectedProcessTime.after(new Date()) ? Integer.valueOf(0) : Integer.valueOf(1)) : (expectedProcessTime.after(completeTime) ? Integer.valueOf(0) : Integer.valueOf(1));
        return isOverTime;
    }

    public void setPermissionManager(PermissionManager permissionManager) {
        this.permissionManager = permissionManager;
    }
}

