/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.cap4.template.manager.impl;

import com.google.common.collect.Lists;
import com.seeyon.cap4.form.bean.FormBean;
import com.seeyon.cap4.form.bean.FormBindAuthBean;
import com.seeyon.cap4.form.bean.FormFieldBean;
import com.seeyon.cap4.form.bean.FormFieldComEnum;
import com.seeyon.cap4.form.bean.FormFlowBusinessBean;
import com.seeyon.cap4.form.bean.FormQueryResult;
import com.seeyon.cap4.form.bean.FormQueryTypeEnum;
import com.seeyon.cap4.form.bean.FormQueryWhereClause;
import com.seeyon.cap4.form.bean.FormTableBean;
import com.seeyon.cap4.form.bean.SimpleObjectBean;
import com.seeyon.cap4.form.modules.engin.base.formData.CAP4FormDataManager;
import com.seeyon.cap4.form.service.CAP4FormCacheManager;
import com.seeyon.cap4.form.service.CAP4FormManager;
import com.seeyon.cap4.form.util.Enums;
import com.seeyon.cap4.form.util.FormSearchUtil;
import com.seeyon.cap4.form.util.FormUtil;
import com.seeyon.cap4.form.vo.FormOperateConditionVo;
import com.seeyon.cap4.template.bean.ConditionBean;
import com.seeyon.cap4.template.bean.FilterFieldBean;
import com.seeyon.cap4.template.bean.FlowToDoListQueryBean;
import com.seeyon.cap4.template.bean.FormDataListFormatBean;
import com.seeyon.cap4.template.bean.FormDataListParamBean;
import com.seeyon.cap4.template.bean.ValidListButtonParamBean;
import com.seeyon.cap4.template.constant.CAPBusinessEnum;
import com.seeyon.cap4.template.constant.CAPFlowEnum;
import com.seeyon.cap4.template.manager.CAPFilterFieldConditionManager;
import com.seeyon.cap4.template.manager.CAPFlowButtonManager;
import com.seeyon.cap4.template.manager.CAPFlowToDoFormatManager;
import com.seeyon.cap4.template.manager.CAPFlowToDoManager;
import com.seeyon.cap4.template.manager.CAPSqlFieldManager;
import com.seeyon.cap4.template.manager.impl.AbstractCAPDataListManager;
import com.seeyon.cap4.template.manager.impl.CAPFilterFieldManagerImpl;
import com.seeyon.cap4.template.vo.FilterFieldVO;
import com.seeyon.cap4.template.vo.FlowListButtonVO;
import com.seeyon.cap4.template.vo.FlowListInitVO;
import com.seeyon.cap4.template.vo.FlowListVO;
import com.seeyon.cap4.template.vo.ListFieldVO;
import com.seeyon.ctp.common.AppContext;
import com.seeyon.ctp.common.content.affair.constants.StateEnum;
import com.seeyon.ctp.common.exceptions.BusinessException;
import com.seeyon.ctp.common.log.CtpLogFactory;
import com.seeyon.ctp.util.FlipInfo;
import com.seeyon.ctp.util.Strings;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;

public class CAPFlowToDoManagerImpl
extends AbstractCAPDataListManager
implements CAPFlowToDoManager {
    private static final Log LOGGER = CtpLogFactory.getLog(CAPFlowToDoManagerImpl.class);
    private static final String TABLE_CTP_AFFAIR = "ctp_affair";
    private CAP4FormManager cap4FormManager;
    private CAP4FormCacheManager cap4FormCacheManager;
    private CAP4FormDataManager cap4FormDataManager;
    private CAPFilterFieldManagerImpl capFilterFieldManager;
    private CAPFilterFieldConditionManager capFilterFieldConditionManager;
    private CAPFlowButtonManager capFlowButtonManager;
    private CAPFlowToDoFormatManager capFlowToDoFormatManager;
    private CAPSqlFieldManager sqlFieldFlowToDoManager = new CAPSqlFieldManager(){

        @Override
        public String getField(String tableName, String fieldName) {
            if (!fieldName.contains(".")) {
                if (fieldName.toLowerCase().contains("field")) {
                    fieldName = tableName + "." + fieldName;
                } else {
                    Enums.FlowBusinessFixField fixField = Enums.FlowBusinessFixField.getEnumByKey((String)fieldName);
                    if (fixField != null) {
                        fieldName = "ctp_affair." + fieldName;
                    }
                }
            }
            return fieldName;
        }
    };

    @Override
    public CAPBusinessEnum.DataListTypeEnum getListType() {
        return CAPBusinessEnum.DataListTypeEnum.FLOW_TO_DO;
    }

    @Override
    public boolean checkButton(ValidListButtonParamBean paramBean) throws BusinessException {
        FormBean formBean = this.cap4FormManager.getForm(paramBean.getFormId(), false);
        if (!formBean.isEnabled()) {
            return false;
        }
        FormFlowBusinessBean businessBean = formBean.getBind().getFlowBusinessById(paramBean.getFormTemplateId());
        if (businessBean == null || !businessBean.checkRight(AppContext.currentUserId())) {
            return false;
        }
        List<FlowListButtonVO> hasRightButtons = this.capFlowButtonManager.getButtons(formBean, businessBean, paramBean.getViewType(), paramBean.getShowPosition());
        for (FlowListButtonVO vo : hasRightButtons) {
            if (!StringUtils.equals((CharSequence)paramBean.getType(), (CharSequence)vo.getType())) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean checkRight(Long userId, FormDataListParamBean paramBean) throws BusinessException {
        FormBean formBean = this.cap4FormCacheManager.getForm(paramBean.getFormId());
        FormFlowBusinessBean businessBean = formBean.getBind().getFlowBusinessById(paramBean.getFormTemplateId());
        return businessBean != null && businessBean.checkRight(userId.longValue());
    }

    @Override
    public FlowListVO getList(FormDataListParamBean paramBean) throws BusinessException {
        FlowListVO flowListVO;
        FormBean formBean = this.cap4FormCacheManager.getForm(paramBean.getFormId());
        FormFlowBusinessBean businessBean = formBean.getBind().getFlowBusinessById(paramBean.getFormTemplateId());
        List<FilterFieldVO> filterFieldVOS = null;
        if (CAPBusinessEnum.TrueOrFalseEnum.TRUE.getKey().equals(paramBean.getInit())) {
            flowListVO = new FlowListInitVO();
            ((FlowListInitVO)flowListVO).setName(businessBean.getName());
            List<FilterFieldBean> filterFieldBeans = this.capFilterFieldManager.getFilterFieldBeans(formBean, businessBean.getSearchFieldList(), FormQueryTypeEnum.flowToDoQuery);
            filterFieldVOS = this.capFilterFieldManager.getFilterFields(filterFieldBeans);
            ((FlowListInitVO)flowListVO).setFilterFields(filterFieldVOS);
            Enums.ViewType viewType = paramBean.getViewType();
            HashMap<String, List<FlowListButtonVO>> buttons = new HashMap<String, List<FlowListButtonVO>>(2);
            buttons.put(FormBindAuthBean.ShowPosition.ToolBar.getKey(), this.capFlowButtonManager.getButtons(formBean, businessBean, viewType, FormBindAuthBean.ShowPosition.ToolBar));
            buttons.put(FormBindAuthBean.ShowPosition.DataRow.getKey(), this.capFlowButtonManager.getButtons(formBean, businessBean, viewType, FormBindAuthBean.ShowPosition.DataRow));
            ((FlowListInitVO)flowListVO).setButtons(buttons);
        } else {
            flowListVO = new FlowListVO();
        }
        List<ListFieldVO> fields = this.getListShowFields(formBean, CollectionUtils.isNotEmpty(paramBean.getCustomShowFields()) ? paramBean.getCustomShowFields() : businessBean.getShowFieldList(), paramBean);
        flowListVO.setFields(fields);
        FlowToDoListQueryBean queryBean = new FlowToDoListQueryBean();
        queryBean.setQueryType(FormQueryTypeEnum.flowToDoQuery);
        queryBean.setFormBean(formBean);
        queryBean.setFormFlowBusinessBean(businessBean);
        queryBean.setUserOrderBy(paramBean.getUserOrderBy());
        queryBean.setUserId(AppContext.currentUserId());
        if (paramBean.getUserConditions() == null) {
            if (filterFieldVOS == null) {
                List<FilterFieldBean> filterFieldBeans = this.capFilterFieldManager.getFilterFieldBeans(formBean, businessBean.getSearchFieldList(), FormQueryTypeEnum.flowToDoQuery);
                filterFieldVOS = this.capFilterFieldManager.getFilterFields(filterFieldBeans);
            }
            queryBean.setUserConditions(this.capFilterFieldConditionManager.getDefaultConditionBeans(filterFieldVOS));
        } else {
            queryBean.setUserConditions(this.capFilterFieldConditionManager.getConditionBeans(paramBean.getUserConditions()));
        }
        queryBean.setDataConditions(paramBean.getDataConditions());
        FlipInfo fi = this.getDataList(queryBean, paramBean.getFlipInfo());
        FormDataListFormatBean formatBean = new FormDataListFormatBean();
        formatBean.setViewType(paramBean.getViewType());
        formatBean.setShowFields(fields);
        fi.setData(this.capFlowToDoFormatManager.format(formBean, fi.getData(), formatBean));
        flowListVO.setDatas(fi.getData());
        flowListVO.setPage(String.valueOf(fi.getPage()));
        flowListVO.setPageSize(String.valueOf(fi.getSize()));
        flowListVO.setTotal(String.valueOf(fi.getTotal()));
        flowListVO.setPages(String.valueOf(fi.getPages()));
        flowListVO.setFormId(paramBean.getFormId().toString());
        flowListVO.setFormTemplateId(paramBean.getFormTemplateId().toString());
        return flowListVO;
    }

    private FlipInfo getDataList(FlowToDoListQueryBean queryBean, FlipInfo fi) throws BusinessException {
        FormQueryWhereClause operationWhereClause = this.getOperationRangeWhereClause(queryBean.getFormFlowBusinessBean(), queryBean);
        FormQueryWhereClause customConditionWhereClause = this.capDataListSqlHelpManager.getFormQueryWhereClauseByConditionBean(queryBean.getUserConditions(), true);
        FormQueryWhereClause dataConditionWhereCause = this.cap4FormDataManager.getFieldDataConditionFormQueryWhereClause(queryBean.getFormBean(), queryBean.getDataConditions(), true);
        ArrayList<FormQueryWhereClause> whereClauses = new ArrayList<FormQueryWhereClause>();
        whereClauses.add(operationWhereClause);
        whereClauses.add(customConditionWhereClause);
        whereClauses.add(dataConditionWhereCause);
        return this.getFormQueryResult(queryBean, fi, whereClauses).getFlipInfo();
    }

    private FormQueryResult getFormQueryResult(FlowToDoListQueryBean queryBean, FlipInfo fi, List<FormQueryWhereClause> whereClauses) throws BusinessException {
        FormQueryWhereClause queryClause = this.getFormQuerySql(queryBean, whereClauses);
        LOGGER.info((Object)("\u3010\u6709\u6d41\u7a0b\u5f85\u529e\u5217\u8868\u67e5\u8be2\u3011" + queryBean.getFormFlowBusinessBean().getId() + "-" + queryBean.getFormFlowBusinessBean().getName()));
        return this.getFormQueryResult(this.buildLastWhereClause(queryClause), fi);
    }

    private FormQueryWhereClause getOperationRangeWhereClause(FormFlowBusinessBean businessBean, FlowToDoListQueryBean queryBean) throws BusinessException {
        FormQueryWhereClause queryClause = null;
        if (Strings.isNotEmpty((Collection)businessBean.getPreCondition())) {
            ArrayList<ConditionBean> conditionBeans = new ArrayList<ConditionBean>();
            for (FormOperateConditionVo vo : businessBean.getPreCondition()) {
                if (vo.isEmpty()) continue;
                ConditionBean conditionBean = new ConditionBean();
                Enums.FlowBusinessFixField fixField = Enums.FlowBusinessFixField.getEnumByKey((String)vo.getLeftOperand());
                if (fixField != null) {
                    conditionBean.setFieldType(fixField.getFieldType());
                    conditionBean.setInputType(fixField.getInputType());
                    conditionBean.setAliasTableName(TABLE_CTP_AFFAIR);
                } else {
                    FormFieldBean fieldBean = businessBean.getFormBindBean().getFormBean().getFieldBeanByName(vo.getLeftOperand(), true);
                    if (fieldBean == null) {
                        throw new BusinessException("OperationRange error ." + vo.toString());
                    }
                    conditionBean.setFieldType(fieldBean.getFieldType());
                    conditionBean.setInputType(fieldBean.getInputType());
                    conditionBean.setAliasTableName(fieldBean.getOwnerTableName());
                }
                conditionBean.setFieldName(vo.getLeftOperand());
                conditionBean.setLeftChar(vo.getPrefix());
                conditionBean.setOperation(vo.getOperator());
                conditionBean.setRightChar(vo.getSuffix());
                conditionBean.setRowOperation(vo.getLogicalFlag());
                conditionBean.setFieldValue(vo.getFinalRightOperand());
                conditionBeans.add(conditionBean);
            }
            queryClause = this.capDataListSqlHelpManager.getFormQueryWhereClauseByConditionBean(conditionBeans, true);
        }
        return queryClause;
    }

    private FormQueryWhereClause getCtpAffairWhereClause(Long formId, Long userId) {
        FormQueryWhereClause formWhereClause = new FormQueryWhereClause();
        StringBuilder builder = new StringBuilder();
        builder.append(TABLE_CTP_AFFAIR).append(".app=1 ");
        builder.append(" AND ").append(TABLE_CTP_AFFAIR).append(".").append(CAPFlowEnum.ToDoAffairField.FORM_ID.getKey()).append(" = ").append(formId);
        builder.append(" AND ").append(TABLE_CTP_AFFAIR).append(".").append(Enums.FlowBusinessFixField.affairState.getKey()).append(" = ").append(StateEnum.col_pending.getKey());
        builder.append(" AND ").append(TABLE_CTP_AFFAIR).append(".").append(CAPFlowEnum.ToDoAffairField.MEMBER_ID.getKey()).append(" = ").append(userId);
        formWhereClause.setAllSqlClause(builder.toString());
        return formWhereClause;
    }

    private FormQueryWhereClause getFormQuerySql(FlowToDoListQueryBean queryBean, List<FormQueryWhereClause> whereClauses) throws BusinessException {
        Set<String> sortSet;
        FormFlowBusinessBean businessBean = queryBean.getFormFlowBusinessBean();
        FormBean formBean = queryBean.getFormBean();
        FormTableBean masterTableBean = formBean.getMasterTableBean();
        FormQueryWhereClause allWhereClause = new FormQueryWhereClause();
        ArrayList<Object> queryParams = new ArrayList<Object>();
        whereClauses.add(0, this.getCtpAffairWhereClause(formBean.getId(), queryBean.getUserId()));
        String whereClause = this.capDataListSqlHelpManager.getSQLWhere(whereClauses, queryParams);
        StringBuilder sql = new StringBuilder();
        Set<String> selectFieldSet = this.capDataListSqlHelpManager.getSQLSelectFields(masterTableBean.getTableName(), businessBean.getShowFieldList(), queryBean.getCustomShowFields(), this.sqlFieldFlowToDoManager);
        sql.append(" FROM ");
        sql.append(TABLE_CTP_AFFAIR).append(" ").append(TABLE_CTP_AFFAIR);
        sql.append(" LEFT JOIN ").append(masterTableBean.getTableName()).append(" ").append(masterTableBean.getTableName()).append(" ");
        sql.append(" ON ").append(TABLE_CTP_AFFAIR).append(".").append(CAPFlowEnum.ToDoAffairField.FORM_RECORD_ID.getKey());
        sql.append(" = ").append(masterTableBean.getTableName()).append(".").append(Enums.MasterTableField.id.getKey());
        sql.append(this.capDataListSqlHelpManager.getSQLJoin(formBean, sql.toString(), whereClause, "LEFT"));
        if (Strings.isNotEmpty((String)whereClause.trim())) {
            sql.append(" WHERE ");
            whereClause = FormUtil.changeAndAddNullWhereSql((String)whereClause);
            sql.append(whereClause);
        }
        if (Strings.isNotEmpty(queryBean.getUserOrderBy())) {
            Map<String, String> map = this.capDataListSqlHelpManager.getSQLOrder4CustomMap(queryBean.getUserOrderBy(), masterTableBean.getTableName(), this.sqlFieldFlowToDoManager);
            sortSet = this.capDataListSqlHelpManager.getSQLOrder4CustomSetByMap(map);
            selectFieldSet.addAll(map.keySet());
        } else {
            sortSet = this.getSQLDefaultSort(businessBean, masterTableBean.getTableName(), queryBean.isReverse(), selectFieldSet);
        }
        String lastSql = this.getLastSelectFields(selectFieldSet) + sql.toString();
        lastSql = lastSql.indexOf("formson") > 0 ? " SELECT DISTINCT " + lastSql : " SELECT " + lastSql;
        allWhereClause.setOrderByClause(this.getLastOrderBy(sortSet));
        allWhereClause.setWhereClause(whereClause);
        allWhereClause.setAllSqlClause(lastSql);
        allWhereClause.setQueryParams(queryParams);
        return allWhereClause;
    }

    private String getLastSelectFields(Set<String> fieldSet) {
        if (fieldSet.contains("ctp_affair." + Enums.FlowBusinessFixField.isCoverTime.getKey())) {
            fieldSet.add("ctp_affair." + Enums.FlowBusinessFixField.expectedProcessTime.getKey());
            fieldSet.add("ctp_affair." + CAPFlowEnum.ToDoAffairField.COMPLETE_TIME.getKey());
        }
        if (fieldSet.contains("ctp_affair." + Enums.FlowBusinessFixField.nodePolicy.getKey())) {
            fieldSet.add("ctp_affair." + CAPFlowEnum.ToDoAffairField.ORG_ACCOUNT_ID.getKey());
        }
        fieldSet.add("ctp_affair." + CAPFlowEnum.ToDoAffairField.AFFAIR_ID.getKey());
        fieldSet.add("ctp_affair." + CAPFlowEnum.ToDoAffairField.SUMMARY_ID.getKey());
        fieldSet.add("ctp_affair." + CAPFlowEnum.ToDoAffairField.FORM_RECORD_ID.getKey());
        fieldSet.add("ctp_affair." + CAPFlowEnum.ToDoAffairField.FORM_MULTI_OPERATION_ID.getKey());
        fieldSet.add("ctp_affair." + Enums.FlowBusinessFixField.category.getKey());
        fieldSet.add("ctp_affair." + Enums.FlowBusinessFixField.flowTitle.getKey());
        fieldSet.add("ctp_affair." + Enums.FlowBusinessFixField.receiveTime.getKey());
        return StringUtils.join(fieldSet, (String)",");
    }

    private String getLastOrderBy(Set<String> sortSet) {
        if (sortSet.isEmpty() || !StringUtils.join(sortSet, (String)",").contains(Enums.FlowBusinessFixField.receiveTime.getKey())) {
            sortSet.add("ctp_affair." + Enums.FlowBusinessFixField.receiveTime.getKey() + " desc");
        }
        return StringUtils.join(sortSet, (String)",");
    }

    private Set<String> getSQLDefaultSort(FormFlowBusinessBean businessBean, String masterTableName, boolean isReverse, Set<String> selectFieldSet) {
        Map map = businessBean.getSortFieldMap(masterTableName, isReverse);
        if (map != null) {
            selectFieldSet.addAll(map.keySet());
        }
        String sortFields = businessBean.getSortStr(map);
        LinkedHashSet<String> sortSet = new LinkedHashSet<String>();
        if (Strings.isNotBlank((String)sortFields)) {
            sortSet.add(sortFields);
        }
        return sortSet;
    }

    private List<ListFieldVO> getListShowFields(FormBean formBean, List<SimpleObjectBean> simpleObjectBeans, FormDataListParamBean paramBean) throws BusinessException {
        ArrayList fields = Lists.newArrayList();
        for (SimpleObjectBean simpleObjectBean : simpleObjectBeans) {
            ListFieldVO field = new ListFieldVO();
            if (simpleObjectBean.getName().contains("field")) {
                FormFieldBean formFieldBean = FormSearchUtil.getFormFieldBean(formBean, simpleObjectBean);
                if (formFieldBean.isAttachment() && !FormFieldComEnum.EXTEND_IMAGE.getKey().equals(formFieldBean.getInputType())) continue;
                field.setDisplay(this.getFieldDisplay(formFieldBean.getDisplay(), simpleObjectBean.getValue()));
                field.setFieldName(formFieldBean.getName());
                field.setInputType(formFieldBean.getInputType());
                field.setFieldType(formFieldBean.getFieldType());
                field.setAliasTableName(formFieldBean.getOwnerTableName());
            } else {
                Enums.FlowBusinessFixField fixField = Enums.FlowBusinessFixField.getEnumByKey((String)simpleObjectBean.getName());
                if (fixField == null) continue;
                field.setDisplay(this.getFieldDisplay(fixField.getText(), simpleObjectBean.getValue()));
                field.setFieldName(fixField.getKey());
                field.setInputType(fixField.getInputType());
                field.setFieldType(fixField.getFieldType());
                field.setAliasTableName(TABLE_CTP_AFFAIR);
            }
            field.setAuth(Enums.FieldAccessType.browse.getKey());
            fields.add(field);
        }
        return fields;
    }

    private String getFieldDisplay(String display, String value) {
        if (value != null && !StringUtils.equals((CharSequence)display, (CharSequence)value) && value.indexOf("(") > -1) {
            display = value.substring(value.indexOf("(") + 1, value.indexOf(")"));
        }
        return display;
    }

    public void setCap4FormCacheManager(CAP4FormCacheManager cap4FormCacheManager) {
        this.cap4FormCacheManager = cap4FormCacheManager;
    }

    public void setCap4FormDataManager(CAP4FormDataManager cap4FormDataManager) {
        this.cap4FormDataManager = cap4FormDataManager;
    }

    public void setCapFilterFieldManager(CAPFilterFieldManagerImpl capFilterFieldManager) {
        this.capFilterFieldManager = capFilterFieldManager;
    }

    public void setCapFlowButtonManager(CAPFlowButtonManager capFlowButtonManager) {
        this.capFlowButtonManager = capFlowButtonManager;
    }

    public void setCapFlowToDoFormatManager(CAPFlowToDoFormatManager capFlowToDoFormatManager) {
        this.capFlowToDoFormatManager = capFlowToDoFormatManager;
    }

    public void setCap4FormManager(CAP4FormManager cap4FormManager) {
        this.cap4FormManager = cap4FormManager;
    }

    public void setCapFilterFieldConditionManager(CAPFilterFieldConditionManager capFilterFieldConditionManager) {
        this.capFilterFieldConditionManager = capFilterFieldConditionManager;
    }
}

