/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.cap4.template.manager.impl;

import com.seeyon.cap4.form.modules.engin.plugin.CAPFormPluginManager;
import com.seeyon.cap4.form.modules.engin.plugin.FormPluginParamBean;
import com.seeyon.cap4.template.dao.CAPFormPluginWhitelistDAO;
import com.seeyon.cap4.template.po.CAPFormPluginWhitelist;
import com.seeyon.cap4.template.util.FileUtil;
import com.seeyon.ctp.common.ModuleType;
import com.seeyon.ctp.common.SystemEnvironment;
import com.seeyon.ctp.common.content.mainbody.MainbodyManager;
import com.seeyon.ctp.common.exceptions.BusinessException;
import com.seeyon.ctp.common.log.CtpLogFactory;
import com.seeyon.ctp.common.po.content.CtpContentAll;
import com.seeyon.ctp.util.Strings;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.commons.logging.Log;
import org.springframework.util.DigestUtils;

public class CAPFormPluginManagerImpl
implements CAPFormPluginManager {
    private static final Log LOGGER = CtpLogFactory.getLog(CAPFormPluginManagerImpl.class);
    private CAPFormPluginWhitelistDAO capFormPluginWhitelistDAO;
    private MainbodyManager ctpMainbodyManager;
    private Map<String, List<Plugin>> pluginMap = new ConcurrentHashMap<String, List<Plugin>>();
    private Map<String, List<Plugin>> pluginWhiteMap = new ConcurrentHashMap<String, List<Plugin>>();
    private static String csdk = "";
    private static final String CSS = "index.css";
    private static final String JS = "index.js";
    private static final String SEPARATOR_URL = "/";
    private static final String PC_FOLDER = "common/capextend/{%version}/{%type}/{%pluginType}";
    private static final String MOBILE_FOLDER = "m3/apps/v5/capextend/{%version}/{%type}/{%pluginType}";
    private static final String[] CLIENTS = new String[]{"pc", "wx", "m3"};
    private static final String[] VERSIONS = new String[]{"cap4", "cap3"};
    private static String[] TYPES = new String[]{"form", "unflow", "query", "report", "todo"};

    public List getAllWhitePlugins() {
        ArrayList list = new ArrayList();
        for (Map.Entry<String, List<Plugin>> entry : this.pluginWhiteMap.entrySet()) {
            list.addAll(entry.getValue());
        }
        return list;
    }

    public void initPlugins() {
        this.initPlugins(this.pluginMap, "utils");
        this.initPlugins(this.pluginWhiteMap, "whiteList");
        this.readCsdk();
    }

    private void readCsdk() {
        String path = SystemEnvironment.getApplicationFolder() + File.separator + "common/form/api/csdk.js";
        path = path.replace(SEPARATOR_URL, File.separator);
        File csdkFile = new File(path);
        csdk = FileUtil.readFile((File)csdkFile);
    }

    private void initPlugins(Map<String, List<Plugin>> dataMap, String pluginType) {
        for (String type : TYPES) {
            for (String version : VERSIONS) {
                for (String client : CLIENTS) {
                    String baseUrl;
                    String key = this.getPluginKey(client, version, type);
                    String path = "pc".equals(client) ? PC_FOLDER : MOBILE_FOLDER;
                    path = path.replace("{%version}", version);
                    path = path.replace("{%type}", type);
                    path = path.replace("{%pluginType}", pluginType);
                    String basePath = "";
                    if ("m3".equals(client)) {
                        baseUrl = "http://capextend.v5.cmp/v/" + version + SEPARATOR_URL + type + SEPARATOR_URL + pluginType;
                    } else {
                        baseUrl = SystemEnvironment.getContextPath() + SEPARATOR_URL + path.replace("\\", SEPARATOR_URL);
                        basePath = SEPARATOR_URL + path.replace("\\", SEPARATOR_URL);
                    }
                    List<Plugin> plugins = this.scanPlugins(path, pluginType, baseUrl, basePath);
                    if (!CollectionUtils.isNotEmpty(plugins)) continue;
                    for (Plugin p : plugins) {
                        p.setClient(client);
                        p.setPage(type);
                        p.setV(version);
                    }
                    dataMap.put(key, plugins);
                }
            }
        }
    }

    public String getFormPlugins4Document(FormPluginParamBean paramBean) {
        List<Plugin> plugins = this.getRequirePlugins(paramBean);
        return this.buildDocumentPlugin(plugins, paramBean.isInitCsdk());
    }

    public List<Map<String, Object>> getFormPlugins(FormPluginParamBean paramBean) {
        List<Plugin> allPlugins = this.getRequirePlugins(paramBean);
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
        if (Strings.isNotEmpty(allPlugins)) {
            for (Plugin plugin : allPlugins) {
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("name", plugin.getName());
                map.put("css", plugin.getCss());
                map.put("script", plugin.getScript());
                map.put("type", plugin.getType());
                list.add(map);
            }
        }
        return list;
    }

    private List<Plugin> getRequirePlugins(FormPluginParamBean paramBean) {
        String key = this.getPluginKey(paramBean.getClient(), paramBean.getVersion(), paramBean.getPage());
        List<Plugin> plugins = this.pluginMap.get(key);
        ArrayList<Plugin> allPlugins = new ArrayList<Plugin>();
        if (Strings.isNotEmpty(plugins)) {
            allPlugins.addAll(plugins);
        }
        if ("form".equals(paramBean.getPage())) {
            this.getFormWhitePlugins(allPlugins, key, paramBean);
        } else {
            this.getOtherWhitePlugins(allPlugins, key, paramBean);
        }
        return allPlugins;
    }

    private void getOtherWhitePlugins(List<Plugin> allPlugins, String key, FormPluginParamBean paramBean) {
        if (Strings.isBlank((String)paramBean.getAppId()) || Strings.isBlank((String)paramBean.getFormId())) {
            return;
        }
        List<Plugin> whitePlugins = this.pluginWhiteMap.get(key);
        if (Strings.isEmpty(whitePlugins)) {
            return;
        }
        try {
            this.getWhiteList(key, whitePlugins, allPlugins, Long.parseLong(paramBean.getFormId()), Long.parseLong(paramBean.getAppId()));
        }
        catch (BusinessException e) {
            LOGGER.error((Object)(e.getMessage() + paramBean.toString()), (Throwable)e);
        }
    }

    private void getWhiteList(String key, List<Plugin> whitePlugins, List<Plugin> allPlugins, Long formId, Long bindId) throws BusinessException {
        List<CAPFormPluginWhitelist> whitelists = this.capFormPluginWhitelistDAO.getByFormIdOrBindId(formId, bindId, key);
        if (CollectionUtils.isNotEmpty(whitelists)) {
            for (CAPFormPluginWhitelist whitelist : whitelists) {
                if (whitelist.getBindId() != null && !whitelist.getBindId().equals(bindId)) continue;
                for (Plugin plugin : whitePlugins) {
                    if (!plugin.getName().equals(whitelist.getPluginName()) || allPlugins.contains(plugin)) continue;
                    allPlugins.add(plugin);
                }
            }
        }
    }

    private void getFormWhitePlugins(List<Plugin> allPlugins, String key, FormPluginParamBean paramBean) {
        if (Strings.isBlank((String)paramBean.getModuleId()) || Strings.isBlank((String)paramBean.getModuleType())) {
            return;
        }
        List<Plugin> whitePlugins = this.pluginWhiteMap.get(key);
        if (Strings.isNotEmpty(whitePlugins)) {
            HashMap<String, Number> contentParams = new HashMap<String, Number>(2);
            int moduleType = Integer.parseInt(paramBean.getModuleType());
            contentParams.put("moduleType", moduleType);
            contentParams.put("moduleId", Long.parseLong(paramBean.getModuleId()));
            List contentPoList = this.ctpMainbodyManager.getContentList(contentParams);
            if (CollectionUtils.isEmpty((Collection)contentPoList)) {
                return;
            }
            CtpContentAll ctpContentAll = (CtpContentAll)contentPoList.get(0);
            try {
                CtpContentAll c;
                Long moduleTemplateId = ctpContentAll.getModuleTemplateId() == -1L && ctpContentAll.getContentDataId() == null ? ctpContentAll.getModuleId() : (ModuleType.cap4UnflowForm.getKey() == moduleType ? ((c = this.ctpMainbodyManager.getContentById(ctpContentAll.getModuleTemplateId())) == null ? null : c.getModuleId()) : ctpContentAll.getModuleTemplateId());
                Long formId = ctpContentAll.getContentTemplateId();
                this.getWhiteList(key, whitePlugins, allPlugins, formId, moduleTemplateId);
            }
            catch (BusinessException e) {
                LOGGER.error((Object)(e.getMessage() + paramBean.toString()), (Throwable)e);
            }
        }
    }

    @Deprecated
    private String buildDocumentPlugin4Text(List<Plugin> plugins) {
        File file;
        StringBuilder builder = new StringBuilder();
        builder.append("(function() {");
        for (Plugin plugin : plugins) {
            if (!Strings.isNotEmpty((String)plugin.getCss()) || !(file = new File(SystemEnvironment.getApplicationFolder() + plugin.getCssPath())).exists()) continue;
            builder.append("document.write(\"").append("<style type=\"text/css\">");
            builder.append(FileUtil.readFile((File)file));
            builder.append("</style>").append("\");");
        }
        for (Plugin plugin : plugins) {
            if (!Strings.isNotEmpty((String)plugin.getScript()) || !(file = new File(SystemEnvironment.getApplicationFolder() + plugin.getScriptPath())).exists()) continue;
            builder.append("document.write(\"").append("<script type=\"text/javascript\">");
            builder.append(StringEscapeUtils.escapeHtml4((String)FileUtil.readFile((File)file)));
            builder.append("</script>").append("\");");
        }
        builder.append("})();");
        return builder.toString();
    }

    private String buildDocumentPlugin(List<Plugin> plugins, boolean readCsdk) {
        StringBuilder builder = new StringBuilder();
        if (readCsdk) {
            builder.append(csdk);
        }
        builder.append("(function() {");
        for (Plugin plugin : plugins) {
            if (!Strings.isNotEmpty((String)plugin.getCss())) continue;
            String pluginName = "formPluginCss_" + DigestUtils.md5DigestAsHex((byte[])plugin.getName().getBytes());
            builder.append("var ").append(pluginName).append("=document.createElement('link');");
            builder.append(pluginName).append(".setAttribute('rel','stylesheet');");
            builder.append(pluginName).append(".setAttribute('type','text/css');");
            builder.append(pluginName).append(".setAttribute('href','").append(plugin.getCss()).append("');");
            builder.append("document.head.appendChild(").append(pluginName).append(");");
        }
        boolean hasScript = false;
        for (Plugin plugin : plugins) {
            if (!Strings.isNotEmpty((String)plugin.getScript())) continue;
            hasScript = true;
            String pluginName = "formPluginScript_" + DigestUtils.md5DigestAsHex((byte[])plugin.getName().getBytes());
            builder.append("var ").append(pluginName).append("=document.createElement('script');");
            builder.append(pluginName).append(".setAttribute('type','text/javascript');");
            builder.append(pluginName).append(".setAttribute('src','").append(plugin.getScript()).append("');");
            builder.append("document.head.appendChild(").append(pluginName).append(");");
        }
        if (hasScript) {
            builder.append("window.csdk._.emitEvent('pluginChecked', '1');");
        } else {
            builder.append("window.csdk._.emitEvent('pluginChecked', '0');");
        }
        builder.append("})();");
        return builder.toString();
    }

    public String getPluginKey(String client, String version, String type) {
        return client + "-" + version + "-" + type;
    }

    private List<Plugin> scanPlugins(String path, String pluginType, String baseUrl, String basePath) {
        File pluginFolderFile = new File(SystemEnvironment.getApplicationFolder() + File.separator + path);
        if (!pluginFolderFile.exists()) {
            return null;
        }
        String[] folderNames = pluginFolderFile.list();
        if (folderNames == null || folderNames.length == 0) {
            return null;
        }
        ArrayList<Plugin> plugins = new ArrayList<Plugin>();
        if (!baseUrl.endsWith(SEPARATOR_URL)) {
            baseUrl = baseUrl + SEPARATOR_URL;
        }
        if (!basePath.endsWith(SEPARATOR_URL)) {
            basePath = basePath + SEPARATOR_URL;
        }
        for (String folder : folderNames) {
            if (Strings.isEmpty((String)folder)) continue;
            File cssFile = new File(pluginFolderFile, folder + File.separator + CSS);
            File jsFile = new File(pluginFolderFile, folder + File.separator + JS);
            Plugin plugin = new Plugin();
            plugin.setType(pluginType);
            plugin.setName(folder);
            if (cssFile.exists()) {
                plugin.setCss(baseUrl + folder + SEPARATOR_URL + CSS);
                if (Strings.isNotBlank((String)basePath)) {
                    plugin.setCssPath(basePath + folder + SEPARATOR_URL + CSS);
                }
            }
            if (jsFile.exists()) {
                plugin.setScript(baseUrl + folder + SEPARATOR_URL + JS);
                if (Strings.isNotBlank((String)basePath)) {
                    plugin.setScriptPath(basePath + folder + SEPARATOR_URL + JS);
                }
            }
            if (plugin.getCss() == null && plugin.getScript() == null) {
                LOGGER.info((Object)(path + " plugin " + folder + " has no css and js."));
                continue;
            }
            plugins.add(plugin);
        }
        return plugins;
    }

    public void setCapFormPluginWhitelistDAO(CAPFormPluginWhitelistDAO capFormPluginWhitelistDAO) {
        this.capFormPluginWhitelistDAO = capFormPluginWhitelistDAO;
    }

    public void setCtpMainbodyManager(MainbodyManager ctpMainbodyManager) {
        this.ctpMainbodyManager = ctpMainbodyManager;
    }

    private class Plugin {
        private String name;
        private String css;
        private String cssPath;
        private String script;
        private String scriptPath;
        private String type;
        private String client;
        private String v;
        private String page;

        private Plugin() {
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getCss() {
            return this.css;
        }

        public void setCss(String css) {
            this.css = css;
        }

        public String getScript() {
            return this.script;
        }

        public void setScript(String script) {
            this.script = script;
        }

        public String getType() {
            return this.type;
        }

        public void setType(String type) {
            this.type = type;
        }

        public String getCssPath() {
            return this.cssPath;
        }

        public void setCssPath(String cssPath) {
            this.cssPath = cssPath;
        }

        public String getScriptPath() {
            return this.scriptPath;
        }

        public void setScriptPath(String scriptPath) {
            this.scriptPath = scriptPath;
        }

        public String getClient() {
            return this.client;
        }

        public void setClient(String client) {
            this.client = client;
        }

        public String getV() {
            return this.v;
        }

        public void setV(String v) {
            this.v = v;
        }

        public String getPage() {
            return this.page;
        }

        public void setPage(String page) {
            this.page = page;
        }
    }
}

