/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.cap4.template.manager.impl;

import com.seeyon.cap4.template.manager.CAPHttpRequestManager;
import com.seeyon.cap4.template.manager.impl.HttpsClientRequestFactory;
import com.seeyon.ctp.common.log.CtpLogFactory;
import com.seeyon.ctp.util.json.JSONUtil;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLDecoder;
import java.nio.charset.Charset;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.util.Map;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.converter.StringHttpMessageConverter;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.HttpClientErrorException;
import org.springframework.web.client.RestClientException;
import org.springframework.web.client.RestTemplate;

public class CAPHttpRequestManagerImpl
implements CAPHttpRequestManager {
    private static final Log LOGGER = CtpLogFactory.getLog(CAPHttpRequestManagerImpl.class);
    private static final HostnameVerifier DO_NOT_VERIFY = new HostnameVerifier(){

        @Override
        public boolean verify(String paramString, SSLSession paramSSLSession) {
            return true;
        }
    };
    private static final int CONNECT_TIMEOUT = 5000;
    private RestTemplate restTemplate;

    @Override
    public <T> T get(String url, Object params, Class<T> tClass) {
        return (T)this.restTemplate.getForObject(url, tClass, new Object[]{params});
    }

    @Override
    public <T> T post(String url, Object params, Class<T> tClass) {
        return (T)this.restTemplate.postForObject(url, params, tClass, new Object[0]);
    }

    @Override
    public <T> T postByFormPart(String url, Map<String, Object> params, Class<T> tClass) {
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_FORM_URLENCODED);
        LinkedMultiValueMap paramsMap = new LinkedMultiValueMap();
        if (params != null && !params.isEmpty()) {
            for (String key : params.keySet()) {
                paramsMap.add((Object)key, (Object)(params.get(key) instanceof String ? String.valueOf(params.get(key)) : JSONUtil.toJSONString((Object)params.get(key))));
            }
        }
        HttpEntity requestEntity = new HttpEntity((Object)paramsMap, (MultiValueMap)headers);
        ResponseEntity response = null;
        try {
            response = this.restTemplate.exchange(url, HttpMethod.POST, requestEntity, String.class, new Object[0]);
        }
        catch (RestClientException e) {
            LOGGER.error((Object)("\u8bf7\u6c42\u5f02\u5e38\uff0cURL:" + url + " , params : " + params));
            LOGGER.error((Object)e.getMessage(), (Throwable)e);
        }
        return (T)(response == null ? null : JSONUtil.parseJSONString((String)((String)response.getBody()), tClass));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean download(String url, File file) {
        byte[] response;
        File pFileDir = new File(file.getParent());
        if (!pFileDir.exists()) {
            pFileDir.mkdirs();
        }
        try {
            response = (byte[])this.restTemplate.getForObject(URLDecoder.decode(url), byte[].class, new Object[0]);
        }
        catch (HttpClientErrorException e) {
            LOGGER.error((Object)("download " + e.getMessage() + " , url " + URLDecoder.decode(url)));
            try {
                response = (byte[])this.restTemplate.getForObject(url, byte[].class, new Object[0]);
            }
            catch (HttpClientErrorException e1) {
                LOGGER.error((Object)("download " + e1.getMessage() + " , url " + url));
                return this.doHttpFileDownload(url, file);
            }
        }
        boolean result = false;
        FileOutputStream outputStream = null;
        ByteArrayInputStream inputStream = null;
        try {
            int bytesRead;
            inputStream = new ByteArrayInputStream(response);
            outputStream = new FileOutputStream(file);
            byte[] buff = new byte[2048];
            while (-1 != (bytesRead = ((InputStream)inputStream).read(buff, 0, buff.length))) {
                outputStream.write(buff, 0, bytesRead);
            }
            outputStream.flush();
            result = true;
        }
        catch (IOException e) {
            try {
                LOGGER.error((Object)("download " + url), (Throwable)e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(outputStream);
                IOUtils.closeQuietly((InputStream)inputStream);
                throw throwable;
            }
            IOUtils.closeQuietly((OutputStream)outputStream);
            IOUtils.closeQuietly((InputStream)inputStream);
        }
        IOUtils.closeQuietly((OutputStream)outputStream);
        IOUtils.closeQuietly((InputStream)inputStream);
        return result;
    }

    @Override
    public void init() {
        HttpsClientRequestFactory factory = new HttpsClientRequestFactory();
        factory.setConnectTimeout(5000);
        factory.setReadTimeout(60000);
        this.restTemplate = new RestTemplate((ClientHttpRequestFactory)factory);
        this.restTemplate.getMessageConverters().add(new StringHttpMessageConverter(Charset.forName("utf-8")));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean doHttpFileDownload(String httpUrl, File saveFile) {
        block11: {
            boolean bl;
            HttpURLConnection conn = null;
            InputStream inStream = null;
            BufferedInputStream bis = null;
            FileOutputStream fos = null;
            BufferedOutputStream bos = null;
            try {
                int bytesRead;
                URL url = new URL(httpUrl);
                if ("https".equalsIgnoreCase(url.getProtocol().toLowerCase())) {
                    this.trustAllHosts();
                    HttpsURLConnection https = (HttpsURLConnection)url.openConnection();
                    https.setHostnameVerifier(DO_NOT_VERIFY);
                    conn = https;
                } else {
                    conn = (HttpURLConnection)url.openConnection();
                }
                conn.setConnectTimeout(5000);
                conn.connect();
                inStream = conn.getInputStream();
                bis = new BufferedInputStream(inStream);
                File pFileDir = new File(saveFile.getParent());
                if (!pFileDir.exists()) {
                    pFileDir.mkdirs();
                }
                fos = new FileOutputStream(saveFile);
                bos = new BufferedOutputStream(fos);
                byte[] buff = new byte[2048];
                while (-1 != (bytesRead = bis.read(buff, 0, buff.length))) {
                    bos.write(buff, 0, bytesRead);
                }
                bl = true;
                IOUtils.closeQuietly((InputStream)inStream);
            }
            catch (Exception e) {
                LOGGER.error((Object)"method doHttpFileDownload IOException", (Throwable)e);
                break block11;
            }
            finally {
                IOUtils.closeQuietly(inStream);
                IOUtils.closeQuietly(bis);
                IOUtils.closeQuietly(bos);
                IOUtils.closeQuietly(fos);
                if (conn != null) {
                    conn.disconnect();
                }
            }
            IOUtils.closeQuietly((InputStream)bis);
            IOUtils.closeQuietly((OutputStream)bos);
            IOUtils.closeQuietly((OutputStream)fos);
            if (conn != null) {
                conn.disconnect();
            }
            return bl;
        }
        return false;
    }

    private void trustAllHosts() throws Exception {
        TrustManager[] trustAllCerts = new TrustManager[]{new X509TrustManager(){

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return null;
            }

            @Override
            public void checkClientTrusted(X509Certificate[] certs, String authType) {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] certs, String authType) {
            }
        }};
        SSLContext sc = SSLContext.getInstance("TLS");
        sc.init(null, trustAllCerts, new SecureRandom());
        HttpsURLConnection.setDefaultSSLSocketFactory(sc.getSocketFactory());
    }
}

