/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.cap4.template.manager.impl;

import com.seeyon.cap4.form.bean.FormAuthViewBean;
import com.seeyon.cap4.form.bean.FormBean;
import com.seeyon.cap4.form.bean.FormDataBean;
import com.seeyon.cap4.form.bean.FormDataMasterBean;
import com.seeyon.cap4.form.bean.FormDataSubBean;
import com.seeyon.cap4.form.bean.FormFieldBean;
import com.seeyon.cap4.form.bean.FormFieldComEnum;
import com.seeyon.cap4.form.bean.FormTableBean;
import com.seeyon.cap4.form.modules.engin.base.formData.CAP4FormDataManager;
import com.seeyon.cap4.form.service.CAP4FormManager;
import com.seeyon.cap4.form.util.Enums;
import com.seeyon.cap4.monitor.uniqueIndex.unit.FormUniqueIndexForCap4;
import com.seeyon.cap4.template.bean.AutoRelationTipBean;
import com.seeyon.cap4.template.bean.ImportCalcResultBean;
import com.seeyon.cap4.template.bean.ImportDBDataListBean;
import com.seeyon.cap4.template.bean.ImportExecuteResolveFieldBean;
import com.seeyon.cap4.template.bean.ImportUniqueBean;
import com.seeyon.cap4.template.bean.ImportUniqueDbResultBean;
import com.seeyon.cap4.template.constant.CAPBusinessEnum;
import com.seeyon.cap4.template.manager.CAPImportCalcManager4FormData;
import com.seeyon.cap4.template.manager.CAPImportUniqueManager;
import com.seeyon.cap4.template.util.CAPFormUtil;
import com.seeyon.ctp.common.AppContext;
import com.seeyon.ctp.common.exceptions.BusinessException;
import com.seeyon.ctp.common.log.CtpLogFactory;
import com.seeyon.ctp.form.modules.engin.base.serialNumber.SerialCalculateRecordDAO;
import com.seeyon.ctp.form.po.FormSerialCalculateRecord;
import com.seeyon.ctp.monitor.util.UniqueIndexUtil;
import com.seeyon.ctp.util.DateUtil;
import com.seeyon.ctp.util.Strings;
import com.seeyon.ctp.util.json.JSONUtil;
import java.sql.Connection;
import java.sql.SQLException;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;

public class CAPImportCalcManager4FormDataImpl
implements CAPImportCalcManager4FormData {
    private static final Log LOGGER = CtpLogFactory.getLog(CAPImportCalcManager4FormDataImpl.class);
    private CAP4FormDataManager cap4FormDataManager;
    private SerialCalculateRecordDAO serialCalculateRecordDAO;
    private CAP4FormManager cap4FormManager;
    private CAPImportUniqueManager capImportUniqueManager;

    private void importCalcClearSerialField(FormDataMasterBean formDataMasterBean, List<FormFieldBean> serialFields) {
        if (CollectionUtils.isEmpty(serialFields)) {
            return;
        }
        for (FormFieldBean formFieldBean : serialFields) {
            List formDataSubBeans;
            if (formFieldBean.isMasterField()) {
                formDataMasterBean.addFieldValue(formFieldBean.getName(), null);
                continue;
            }
            if (!formFieldBean.isSubField() || (formDataSubBeans = formDataMasterBean.getSubData(formFieldBean.getOwnerTableName())) == null) continue;
            for (FormDataSubBean formDataSubBean : formDataSubBeans) {
                formDataSubBean.addFieldValue(formFieldBean.getName(), null);
            }
        }
    }

    private Map<String, Boolean> importCalcSetMasterFieldChangeTags(FormBean formBean, Set<String> allChangedFields) {
        HashMap<String, Boolean> masterChangeTags = new HashMap<String, Boolean>();
        List masterFieldBeans = formBean.getMasterTableBean().getFields();
        boolean isEmpty = CollectionUtils.isEmpty(allChangedFields);
        for (FormFieldBean formFieldBean : masterFieldBeans) {
            String fieldName = formFieldBean.getName();
            if (isEmpty) {
                masterChangeTags.put(fieldName, true);
                continue;
            }
            if (!allChangedFields.contains(fieldName)) continue;
            masterChangeTags.put(fieldName, true);
        }
        return masterChangeTags;
    }

    private void importCalcSetSubFieldChangeTags(Set<String> allChangedFields, List<FormTableBean> subTableBeans, Map<String, Map<String, Boolean>> changeTags, FormDataMasterBean formDataMasterBean) {
        boolean isEmpty = CollectionUtils.isEmpty(allChangedFields);
        for (FormTableBean subTableBean : subTableBeans) {
            String subTableName = subTableBean.getTableName();
            HashMap<String, Boolean> subChangeTags = new HashMap<String, Boolean>();
            changeTags.put(subTableName, subChangeTags);
            List subFormFieldBeans = subTableBean.getFields();
            ArrayList<FormDataSubBean> formDataSubBeans = formDataMasterBean.getSubData(subTableName);
            if (formDataSubBeans == null) {
                FormDataSubBean formDataSubBean = new FormDataSubBean(subTableBean, formDataMasterBean, new boolean[]{true});
                formDataSubBean.setFormmainId(formDataMasterBean.getId().longValue());
                formDataMasterBean.addSubData(subTableName, formDataSubBean);
                formDataSubBeans = new ArrayList<FormDataSubBean>(1);
                formDataSubBeans.add(formDataSubBean);
            }
            for (FormDataSubBean formDataSubBean : formDataSubBeans) {
                for (FormFieldBean formFieldBean : subFormFieldBeans) {
                    if (isEmpty) {
                        subChangeTags.put(formFieldBean.getName() + "_" + formDataSubBean.getId(), true);
                        continue;
                    }
                    if (!allChangedFields.contains(formFieldBean.getName())) continue;
                    subChangeTags.put(formFieldBean.getName() + "_" + formDataSubBean.getId(), true);
                }
            }
        }
    }

    private void importCalc4Serial(FormBean formBean, FormDataMasterBean formDataMasterBean, FormAuthViewBean formAuthViewBean, ImportCalcResultBean calcResultBean) throws BusinessException {
        CAPFormUtil.processSerial4Formula(formDataMasterBean, formBean, formAuthViewBean);
        List serialRecordList = (List)formDataMasterBean.getExtraAttr("serialCalRecords");
        if (serialRecordList != null) {
            calcResultBean.getSerialRecordLists().addAll(serialRecordList);
        }
    }

    private void importCalc4EnumItem(FormDataMasterBean formDataMasterBean, List<FormFieldBean> enumFields, ImportCalcResultBean calcResultBean) {
        if (CollectionUtils.isEmpty(enumFields)) {
            return;
        }
        for (FormFieldBean enumField : enumFields) {
            List attValues = formDataMasterBean.getDataList(enumField.getName());
            if (!CollectionUtils.isNotEmpty((Collection)attValues)) continue;
            calcResultBean.getEnumItemIds().addAll(attValues);
        }
    }

    private boolean importCalc4Validate(FormBean formBean, FormDataMasterBean formDataMasterBean, Integer id, ImportCalcResultBean calcResultBean) throws BusinessException {
        Map validateMap;
        String forceCheck;
        String validateResult = this.cap4FormManager.validate(formBean.getId(), formDataMasterBean);
        if (Strings.isNotBlank((String)validateResult) && !"2".equals(forceCheck = String.valueOf((validateMap = (Map)JSONUtil.parseJSONString((String)validateResult, Map.class)).get("forceCheck")))) {
            calcResultBean.getSqliteId2Error().put(id, CAPBusinessEnum.BatchValidateRulesEnum.VALIDATE_RULES_ERROR.getType());
            calcResultBean.getErrorIds().add(id);
            return false;
        }
        return true;
    }

    private boolean importCalc4AutoRelation(Integer id, ImportCalcResultBean calcResultBean) {
        AutoRelationTipBean autoRelationTipBean = (AutoRelationTipBean)AppContext.getThreadContext((String)"autoRelationTips");
        if (autoRelationTipBean != null && CollectionUtils.isNotEmpty(autoRelationTipBean.getTips())) {
            calcResultBean.getSqliteId2Error().put(id, CAPBusinessEnum.BatchValidateRulesEnum.SYSTEM_RELATION_ERROR.getType() + "_" + StringUtils.join(autoRelationTipBean.getTips(), (String)""));
            calcResultBean.getErrorIds().add(id);
            return false;
        }
        return true;
    }

    private void importCalc4CustomControl(FormBean formBean, FormDataMasterBean formDataMasterBean) {
        HashMap<String, Object> params = new HashMap<String, Object>(3);
        params.put("formBean", formBean);
        params.put("formDataMasterBean", formDataMasterBean);
        params.put("moduleId", formDataMasterBean.getId());
        this.cap4FormDataManager.refreshCustomControls(params);
    }

    private void importCalc4Unique4OneData(FormDataMasterBean formDataMasterBean, ImportDBDataListBean dataBean) {
        Map formDataSubBeans = formDataMasterBean.getSubTables();
        for (Map.Entry listEntry : formDataSubBeans.entrySet()) {
            String subTableName = (String)listEntry.getKey();
            List formDataSubBeanList = (List)listEntry.getValue();
            if (CollectionUtils.isEmpty((Collection)formDataSubBeanList)) continue;
            ArrayList<Map> currentList = new ArrayList<Map>();
            for (FormDataSubBean formDataSubBean : formDataSubBeanList) {
                currentList.add(formDataSubBean.getRowData());
            }
            Map<String, List<Map<String, Object>>> tableData = dataBean.getSubTable2Data().get(subTableName);
            if (tableData == null) {
                tableData = new HashMap<String, List<Map<String, Object>>>();
                dataBean.getSubTable2Data().put(subTableName, tableData);
            }
            tableData.put(String.valueOf(formDataMasterBean.getId()), currentList);
        }
        dataBean.getMasterData().add(formDataMasterBean.getRowData());
    }

    private Map<String, String> importCalc4Unique(FormDataMasterBean formDataMasterBean, List<ImportUniqueBean> uniqueBeans) {
        HashMap<String, Map<String, List<Map<String, Object>>>> subTable2Data = new HashMap<String, Map<String, List<Map<String, Object>>>>();
        ArrayList<Map<String, Object>> currentMasterData = new ArrayList<Map<String, Object>>();
        ImportDBDataListBean dataBean = new ImportDBDataListBean();
        dataBean.setMasterData(currentMasterData);
        dataBean.setSubTable2Data(subTable2Data);
        this.importCalc4Unique4OneData(formDataMasterBean, dataBean);
        return this.buildDbUniqueMarkMap(uniqueBeans, dataBean);
    }

    private Map<String, String> importCalc4Unique(Map<Integer, FormDataMasterBean> formDataMasterBeanMap, List<ImportUniqueBean> uniqueBeans) {
        HashMap<String, Map<String, List<Map<String, Object>>>> subTable2Data = new HashMap<String, Map<String, List<Map<String, Object>>>>();
        ArrayList<Map<String, Object>> currentMasterData = new ArrayList<Map<String, Object>>();
        ImportDBDataListBean dataBean = new ImportDBDataListBean();
        dataBean.setMasterData(currentMasterData);
        dataBean.setSubTable2Data(subTable2Data);
        for (Map.Entry<Integer, FormDataMasterBean> entry : formDataMasterBeanMap.entrySet()) {
            this.importCalc4Unique4OneData(entry.getValue(), dataBean);
        }
        return this.buildDbUniqueMarkMap(uniqueBeans, dataBean);
    }

    @Override
    public ImportCalcResultBean importCalc(FormBean formBean, FormAuthViewBean formAuthViewBean, ImportExecuteResolveFieldBean resolveFieldBean, Map<Integer, FormDataMasterBean> formDataMasterBeanMap, List<ImportUniqueBean> uniqueBeans, Connection connection) throws BusinessException, SQLException {
        FormDataMasterBean formDataMasterBean;
        Integer id;
        ImportCalcResultBean calcResultBean = new ImportCalcResultBean();
        if (formDataMasterBeanMap.isEmpty()) {
            LOGGER.info((Object)"importCalc formDataMasterBeanMap is empty!");
            return calcResultBean;
        }
        for (Map.Entry<Integer, FormDataMasterBean> entry : formDataMasterBeanMap.entrySet()) {
            this.importCalcClearSerialField(entry.getValue(), resolveFieldBean.getSerialFields());
        }
        Map<String, Boolean> masterChangeFields = this.importCalcSetMasterFieldChangeTags(formBean, resolveFieldBean.getAllChangedFields());
        HashMap<Integer, FormDataMasterBean> currentFormDataMasterBean = new HashMap<Integer, FormDataMasterBean>();
        for (Map.Entry<Integer, FormDataMasterBean> entry : formDataMasterBeanMap.entrySet()) {
            id = entry.getKey();
            formDataMasterBean = entry.getValue();
            HashMap<String, Map<String, Boolean>> changeTags = new HashMap<String, Map<String, Boolean>>();
            changeTags.put(formBean.getMasterTableBean().getTableName(), masterChangeFields);
            this.importCalcSetSubFieldChangeTags(resolveFieldBean.getAllChangedFields(), formBean.getSubTableBean(), changeTags, formDataMasterBean);
            AppContext.putThreadContext((String)"fieldChangeTag", changeTags);
            AppContext.removeThreadContext((String)"autoRelationTips");
            this.cap4FormDataManager.calcAll(formBean, formDataMasterBean, formAuthViewBean, false, true, true, true);
            if (!this.importCalc4AutoRelation(id, calcResultBean) || !this.importCalc4Validate(formBean, formDataMasterBean, id, calcResultBean)) continue;
            currentFormDataMasterBean.put(id, formDataMasterBean);
        }
        ImportUniqueDbResultBean checkResult = this.getCheckDbUniqueData(calcResultBean.getErrorIds(), formBean, uniqueBeans, currentFormDataMasterBean, false, false, connection);
        Iterator iterator = currentFormDataMasterBean.keySet().iterator();
        while (iterator.hasNext()) {
            id = (Integer)iterator.next();
            if (checkResult.getCurrentErrorIds().contains(id)) {
                calcResultBean.getSqliteId2Error().put(id, CAPBusinessEnum.BatchValidateRulesEnum.UNIQUE_IDENTIFIER_ERROR.getType());
                calcResultBean.getErrorIds().add(id);
                iterator.remove();
                continue;
            }
            formDataMasterBean = formDataMasterBeanMap.get(id);
            if (checkResult.getUpdateIds().containsKey(id)) {
                LOGGER.info((Object)("importCalc checkResult for update " + formDataMasterBean.getId()));
                iterator.remove();
                continue;
            }
            formDataMasterBean.setModifyDate(new Date());
            formDataMasterBean.setStartDate(new Date());
            this.importCalc4Serial(formBean, formDataMasterBean, formAuthViewBean, calcResultBean);
            this.importCalc4EnumItem(formDataMasterBean, resolveFieldBean.getEnumFields(), calcResultBean);
            calcResultBean.getFormDataMasterBeans().add(formDataMasterBean);
            calcResultBean.getDataIds().add(String.valueOf(formDataMasterBean.getId()));
            calcResultBean.getSqliteIds().add(String.valueOf(id));
        }
        if (!currentFormDataMasterBean.isEmpty()) {
            this.capImportUniqueManager.insert(connection, this.capImportUniqueManager.getInsertSql(), this.importCalc4Unique(currentFormDataMasterBean, uniqueBeans));
        }
        return calcResultBean;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ImportCalcResultBean importCalc4Update(FormBean formBean, FormAuthViewBean formAuthViewBean, ImportExecuteResolveFieldBean resolveFieldBean, Map<Integer, FormDataMasterBean> formDataMasterBeanMap, List<ImportUniqueBean> uniqueBeans, Connection connection, String type) throws BusinessException, SQLException {
        FormDataMasterBean formDataMasterBean;
        Integer id;
        ImportCalcResultBean calcResultBean = new ImportCalcResultBean();
        if (formDataMasterBeanMap.isEmpty()) {
            LOGGER.info((Object)"importCalc4Update formDataMasterBeanMap is empty!");
            return calcResultBean;
        }
        long startTime = System.currentTimeMillis();
        Map<Long, List<FormSerialCalculateRecord>> formSerialCalculateRecordMaps = this.getAllSerialNumberByFormId(formBean.getId(), null);
        HashMap<Integer, FormDataMasterBean> currentFormDataMasterBean = new HashMap<Integer, FormDataMasterBean>();
        Map<String, Boolean> masterChangeFields = this.importCalcSetMasterFieldChangeTags(formBean, resolveFieldBean.getAllChangedFields());
        for (Map.Entry<Integer, FormDataMasterBean> entry : formDataMasterBeanMap.entrySet()) {
            id = entry.getKey();
            formDataMasterBean = entry.getValue();
            if (formDataMasterBean.getState() == Enums.FormDataStateEnum.UNFLOW_LOCKED.getKey()) {
                calcResultBean.getSqliteId2Error().put(id, CAPBusinessEnum.BatchValidateRulesEnum.DATA_LOCK_ERROR.getType());
                continue;
            }
            String checkDataLockForEdit = this.cap4FormManager.checkDataLockFormEdit(String.valueOf(formDataMasterBean.getId()), true, true);
            if (Strings.isNotBlank((String)checkDataLockForEdit)) {
                calcResultBean.getSqliteId2Error().put(id, CAPBusinessEnum.BatchValidateRulesEnum.DATA_LOCK_ERROR.getType());
                continue;
            }
            HashMap<String, Map<String, Boolean>> changeTags = new HashMap<String, Map<String, Boolean>>();
            changeTags.put(formBean.getMasterTableBean().getTableName(), masterChangeFields);
            List<FormSerialCalculateRecord> serialRecordList = formSerialCalculateRecordMaps.get(formDataMasterBean.getId());
            if (serialRecordList != null) {
                formDataMasterBean.putExtraAttr("serialCalRecords", serialRecordList);
            }
            formDataMasterBean.setModifyDate(new Date());
            AppContext.putThreadContext((String)"fieldChangeTag", changeTags);
            if (!"batchRefresh".equals(type)) {
                AppContext.removeThreadContext((String)"autoRelationTips");
            }
            try {
                formDataMasterBean.putExtraAttr("calcAttachSaveDb", "dataFromBatchOperation");
                this.cap4FormDataManager.calcAll(formBean, formDataMasterBean, formAuthViewBean, false, true, true, true);
            }
            finally {
                formDataMasterBean.removeExtraMap("calcAttachSaveDb");
            }
            if (!"batchRefresh".equals(type) && !this.importCalc4AutoRelation(id, calcResultBean) || !this.importCalc4Validate(formBean, formDataMasterBean, id, calcResultBean)) continue;
            this.importCalc4Serial(formBean, formDataMasterBean, formAuthViewBean, calcResultBean);
            currentFormDataMasterBean.put(id, formDataMasterBean);
        }
        ImportUniqueDbResultBean checkResult = this.getCheckDbUniqueData(calcResultBean.getErrorIds(), formBean, uniqueBeans, currentFormDataMasterBean, true, false, connection);
        Iterator iterator = currentFormDataMasterBean.keySet().iterator();
        while (iterator.hasNext()) {
            id = (Integer)iterator.next();
            if (checkResult.getCurrentErrorIds().contains(id)) {
                calcResultBean.getSqliteId2Error().put(id, CAPBusinessEnum.BatchValidateRulesEnum.UNIQUE_IDENTIFIER_ERROR.getType());
                calcResultBean.getErrorIds().add(id);
                iterator.remove();
                continue;
            }
            formDataMasterBean = formDataMasterBeanMap.get(id);
            if (checkResult.errorDbIdContainsId(formDataMasterBean.getId())) {
                calcResultBean.getSqliteId2Error().put(id, CAPBusinessEnum.BatchValidateRulesEnum.UNIQUE_IDENTIFIER_ERROR.getType());
                calcResultBean.getErrorIds().add(id);
                iterator.remove();
                continue;
            }
            formDataMasterBean.setModifyDate(new Date());
            this.importCalc4EnumItem(formDataMasterBean, resolveFieldBean.getEnumFields(), calcResultBean);
            this.importCalc4CustomControl(formBean, formDataMasterBean);
            calcResultBean.getFormDataMasterBeans().add(formDataMasterBean);
            calcResultBean.getDataIds().add(String.valueOf(formDataMasterBean.getId()));
            calcResultBean.getSqliteIds().add(String.valueOf(id));
        }
        if (!currentFormDataMasterBean.isEmpty()) {
            this.capImportUniqueManager.insert(connection, this.capImportUniqueManager.getInsertSql(), this.importCalc4Unique(currentFormDataMasterBean, uniqueBeans));
        }
        LOGGER.info((Object)("importCalc4Update\u6279\u91cf\u4fee\u6539\uff0c\u6279\u91cf\u5237\u65b0\uff0c\u6279\u91cf\u5bfc\u5165\u7684\u4fee\u6539\u65f6\u95f4\uff1a" + (System.currentTimeMillis() - startTime) + "ms,\u6570\u636e\u6761\u6570=" + calcResultBean.getDataIds().size()));
        return calcResultBean;
    }

    private Map<Long, List<FormSerialCalculateRecord>> getAllSerialNumberByFormId(Long formId, List<Long> formDataIds) throws BusinessException {
        HashMap<Long, List<FormSerialCalculateRecord>> recordMap = new HashMap<Long, List<FormSerialCalculateRecord>>();
        List records = this.serialCalculateRecordDAO.selectAllSerialNumberByFormData(formId, formDataIds);
        for (FormSerialCalculateRecord formSerialCalculateRecord : records) {
            Long dataId = formSerialCalculateRecord.getFormDataId();
            ArrayList<FormSerialCalculateRecord> oneRecords = (ArrayList<FormSerialCalculateRecord>)recordMap.get(dataId);
            if (oneRecords == null) {
                oneRecords = new ArrayList<FormSerialCalculateRecord>();
                recordMap.put(dataId, oneRecords);
            }
            oneRecords.add(formSerialCalculateRecord);
        }
        return recordMap;
    }

    private Map<String, String> getExitsUniqueMap(Connection connection, Set<Integer> errorIds, List<ImportUniqueBean> uniqueBeans, Map<Integer, FormDataMasterBean> formDataMasterBeansLeft) throws SQLException {
        HashSet<String> uniqueStrs = new HashSet<String>();
        for (Map.Entry<Integer, FormDataMasterBean> entry : formDataMasterBeansLeft.entrySet()) {
            Integer sqliteId = entry.getKey();
            if (errorIds.contains(sqliteId)) continue;
            FormDataMasterBean formDataMasterBean = entry.getValue();
            for (ImportUniqueBean uniqueBean : uniqueBeans) {
                List subDatas;
                if (uniqueBean.isOnlyMaster()) {
                    StringBuilder masterDataString = this.getFieldUniqueStr((FormDataBean)formDataMasterBean, uniqueBean, true);
                    if (masterDataString.length() == 0) continue;
                    uniqueStrs.add(masterDataString.toString().toLowerCase());
                    continue;
                }
                if (uniqueBean.isMasterAndSub()) {
                    List subDatas2;
                    StringBuilder masterSb = this.getFieldUniqueStr((FormDataBean)formDataMasterBean, uniqueBean, true);
                    if (masterSb.length() == 0 || (subDatas2 = formDataMasterBean.getSubData(uniqueBean.getSubTableName())) == null) continue;
                    for (FormDataSubBean formDataSubBean : subDatas2) {
                        StringBuilder subSb = this.getFieldUniqueStr((FormDataBean)formDataSubBean, uniqueBean, false);
                        if (subSb.length() == 0) continue;
                        uniqueStrs.add(subSb.append(masterSb.toString()).toString().toLowerCase());
                    }
                    continue;
                }
                if (!uniqueBean.isOnlySub() || (subDatas = formDataMasterBean.getSubData(uniqueBean.getSubTableName())) == null) continue;
                for (FormDataSubBean formDataSubBean : subDatas) {
                    StringBuilder subDataString = this.getFieldUniqueStr((FormDataBean)formDataSubBean, uniqueBean, false);
                    if (subDataString.length() == 0) continue;
                    uniqueStrs.add(subDataString.toString().toLowerCase());
                }
            }
        }
        return this.capImportUniqueManager.selectByUniques4Map(connection, uniqueStrs);
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public ImportUniqueDbResultBean getCheckDbUniqueData(Set<Integer> errorIds, FormBean formBean, List<ImportUniqueBean> uniqueBeans, Map<Integer, FormDataMasterBean> formDataMasterBeansLeft, boolean isAfterCalc, boolean isCheckSubData, Connection connection) throws SQLException {
        result = new ImportUniqueDbResultBean();
        if (uniqueBeans.size() == 0 || formDataMasterBeansLeft.size() == 0) {
            return result;
        }
        uniqueMarkMap = this.getExitsUniqueMap(connection, errorIds, uniqueBeans, formDataMasterBeansLeft);
        updateIds = result.getUpdateIds();
        subDataId = result.getSubDataId();
        block0: for (Map.Entry<Integer, FormDataMasterBean> entry : formDataMasterBeansLeft.entrySet()) {
            sqliteId = entry.getKey();
            if (errorIds.contains(sqliteId)) continue;
            formDataMasterBean = entry.getValue();
            subDataIdsMap = new HashMap<String, HashSet<Long>>();
            for (ImportUniqueBean uniqueBean : uniqueBeans) {
                beginTime = System.currentTimeMillis();
                if (!uniqueBean.isOnlyMaster()) ** GOTO lbl33
                masterDataString = this.getFieldUniqueStr((FormDataBean)formDataMasterBean, uniqueBean, true);
                if (masterDataString.length() == 0 || (masterId = uniqueMarkMap.get(masterDataString.toString().toLowerCase())) == null) continue;
                if (!uniqueBean.isUpdateMark()) {
                    errorIds.add(sqliteId);
                    result.getCurrentErrorIds().add(sqliteId);
                    if (isAfterCalc) {
                        result.getErrorDbIds().add(masterId);
                    }
                } else {
                    masterIds = new ArrayList<String>(1);
                    masterIds.add(masterId);
                    updateIds.put(sqliteId, masterIds);
                    continue block0;
lbl33:
                    // 1 sources

                    if (uniqueBean.isMasterAndSub()) {
                        masterSb = this.getFieldUniqueStr((FormDataBean)formDataMasterBean, uniqueBean, true);
                        if (masterSb.length() == 0 || (subDatas = formDataMasterBean.getSubData(uniqueBean.getSubTableName())) == null) continue;
                        masterSubIds = new ArrayList<String>();
                        for (FormDataSubBean formDataSubBean : subDatas) {
                            subSb = this.getFieldUniqueStr((FormDataBean)formDataSubBean, uniqueBean, false);
                            if (subSb.length() == 0 || (masterAndSubId = uniqueMarkMap.get(subSb.append(masterSb.toString()).toString().toLowerCase())) == null) continue;
                            if (!uniqueBean.isUpdateMark()) {
                                errorIds.add(sqliteId);
                                result.getCurrentErrorIds().add(sqliteId);
                                if (isCheckSubData) {
                                    sets = (HashSet<Long>)subDataIdsMap.get(uniqueBean.getSubTableName());
                                    if (sets == null) {
                                        sets = new HashSet<Long>();
                                        subDataIdsMap.put(uniqueBean.getSubTableName(), sets);
                                    }
                                    sets.add(formDataSubBean.getId());
                                    result.getSqliteId2SubTableIds().put(sqliteId, subDataIdsMap);
                                }
                                if (!isAfterCalc) continue;
                                result.getErrorDbIds().add(masterAndSubId);
                                continue;
                            }
                            masterSubIds.add(masterAndSubId);
                            subDataId.put(masterAndSubId, String.valueOf(formDataSubBean.getId()));
                            updateIds.put(sqliteId, masterSubIds);
                        }
                    } else if (uniqueBean.isOnlySub()) {
                        subDatas = formDataMasterBean.getSubData(uniqueBean.getSubTableName());
                        if (subDatas == null) continue;
                        for (FormDataSubBean formDataSubBean : subDatas) {
                            subDataString = this.getFieldUniqueStr((FormDataBean)formDataSubBean, uniqueBean, false);
                            if (subDataString.length() == 0 || (id = uniqueMarkMap.get(subDataString.toString().toLowerCase())) == null) continue;
                            if (isCheckSubData) {
                                sets = (HashSet<Long>)subDataIdsMap.get(uniqueBean.getSubTableName());
                                if (sets == null) {
                                    sets = new HashSet<Long>();
                                    subDataIdsMap.put(uniqueBean.getSubTableName(), sets);
                                }
                                sets.add(formDataSubBean.getId());
                                result.getSqliteId2SubTableIds().put(sqliteId, subDataIdsMap);
                                continue;
                            }
                            errorIds.add(sqliteId);
                            result.getCurrentErrorIds().add(sqliteId);
                            break;
                        }
                    }
                }
                this.putMonitorParam(formBean, uniqueBean.getUniqueFieldNames(), "no DB query,just memory query ", 0, beginTime);
            }
        }
        UniqueIndexUtil.mergeUniqueCache((long)formBean.getId(), (List)formBean.getUniqueFieldList());
        return result;
    }

    private void putMonitorParam(FormBean fb, List<String> fieldList, String sql, int count, long beginTime) {
        if (CollectionUtils.isEmpty(fieldList)) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>(2);
        map.put("MONITOR_INDEX_SQL", sql);
        map.put("MONITOR_INDEX_DATA_COUNT", count);
        FormUniqueIndexForCap4.putUniqueRunInfo(fb, fieldList, System.currentTimeMillis() - beginTime, map);
    }

    @Override
    public StringBuilder getFieldUniqueStr(FormDataBean formDataBean, ImportUniqueBean uniqueBean, boolean isMaster) {
        return this.getFinalFieldUniqueStr(formDataBean, uniqueBean, isMaster);
    }

    private String getFieldFormatData(FormFieldBean formFieldBean, Object value, Map<String, DecimalFormat> fieldDecimalFormat) {
        String result;
        FormFieldComEnum formFieldComEnum = formFieldBean.getInputTypeEnum();
        switch (formFieldComEnum) {
            case TEXT: {
                if (Enums.FieldType.DECIMAL.getKey().equals(formFieldBean.getFieldType())) {
                    DecimalFormat decimalFormat = fieldDecimalFormat.get(formFieldBean.getName());
                    result = decimalFormat.format(value);
                    break;
                }
                result = String.valueOf(value);
                break;
            }
            case EXTEND_DATE: 
            case EXTEND_DATETIME: {
                result = DateUtil.format((Date)((Date)value), (String)"yyyy-MM-dd HH:mm:ss");
                break;
            }
            default: {
                result = String.valueOf(value);
            }
        }
        return result;
    }

    @Override
    public Map<String, String> buildDbUniqueMarkMap(List<ImportUniqueBean> allUniqueBeans, ImportDBDataListBean dataBean) {
        HashMap<String, String> uniqueMarkMap = new HashMap<String, String>();
        if (dataBean == null) {
            LOGGER.info((Object)"\u5bfc\u5165\u6570\u636ebuildDbUniqueMarkMap\u6784\u9020\u6240\u6709\u6570\u636e\u552f\u4e00\uff0c\u6570\u636e\u4e3a\u7a7a");
            return uniqueMarkMap;
        }
        long beginTime = System.currentTimeMillis();
        for (ImportUniqueBean uniqueBean : allUniqueBeans) {
            if (uniqueBean.isOnlyMaster()) {
                for (Map<String, Object> masterDataMap : dataBean.getMasterData()) {
                    StringBuilder masterSb = this.getFieldUniqueStr(masterDataMap, uniqueBean, true);
                    if (masterSb.length() <= 0) continue;
                    uniqueMarkMap.put(masterSb.toString().toLowerCase(), String.valueOf(masterDataMap.get(Enums.MasterTableField.id.getKey())));
                }
                continue;
            }
            if (uniqueBean.isMasterAndSub()) {
                Map<String, Object> masterDataMap;
                Map<String, List<Map<String, Object>>> subDataLists = dataBean.getSubTable2Data().get(uniqueBean.getSubTableName());
                masterDataMap = dataBean.getMasterData().iterator();
                while (masterDataMap.hasNext()) {
                    List<Map<String, Object>> subDataList;
                    Map masterDataMap2 = (Map)masterDataMap.next();
                    String masterId = String.valueOf(masterDataMap2.get(Enums.MasterTableField.id.getKey()));
                    StringBuilder masterSb = this.getFieldUniqueStr(masterDataMap2, uniqueBean, true);
                    if (masterSb.length() == 0 || (subDataList = subDataLists.get(masterId)) == null) continue;
                    for (Map<String, Object> subData : subDataList) {
                        StringBuilder subSb = this.getFieldUniqueStr(subData, uniqueBean, false);
                        if (subSb.length() <= 0) continue;
                        subSb.append((CharSequence)masterSb);
                        uniqueMarkMap.put(subSb.toString().toLowerCase(), masterId + "," + subData.get(Enums.SubTableField.id.getKey()));
                    }
                }
                continue;
            }
            if (!uniqueBean.isOnlySub()) continue;
            Map<String, List<Map<String, Object>>> subDatas = dataBean.getSubTable2Data().get(uniqueBean.getSubTableName());
            ArrayList currentSubDataMaps = new ArrayList();
            for (Map.Entry<String, List<Map<String, Object>>> entry : subDatas.entrySet()) {
                currentSubDataMaps.addAll(entry.getValue());
            }
            for (Map subDataMap : currentSubDataMaps) {
                StringBuilder subSb = this.getFieldUniqueStr(subDataMap, uniqueBean, false);
                if (subSb.length() <= 0) continue;
                uniqueMarkMap.put(subSb.toString().toLowerCase(), subDataMap.get(Enums.SubTableField.formmain_id.getKey()) + "," + subDataMap.get(Enums.SubTableField.id.getKey()));
            }
        }
        long useTime = System.currentTimeMillis() - beginTime;
        if (useTime > 0L) {
            LOGGER.info((Object)("\u5bfc\u5165\u6570\u636ebuildDbUniqueMarkMap\u6784\u9020\u6240\u6709\u6570\u636e\u552f\u4e00 use : " + useTime));
        }
        return uniqueMarkMap;
    }

    @Override
    public StringBuilder getFieldUniqueStr(Map<String, Object> dataMap, ImportUniqueBean uniqueBean, boolean isMasterTable) {
        return this.getFinalFieldUniqueStr(dataMap, uniqueBean, isMasterTable);
    }

    private StringBuilder getFinalFieldUniqueStr(Object object, ImportUniqueBean uniqueBean, boolean isMasterTable) {
        StringBuilder stringBuilder = new StringBuilder();
        boolean isDataBean = object instanceof FormDataBean;
        for (FormFieldBean formFieldBean : uniqueBean.getUniqueFieldList()) {
            if ((!isMasterTable || !formFieldBean.isMasterField()) && (isMasterTable || !formFieldBean.isSubField())) continue;
            Object value = isDataBean ? ((FormDataBean)object).getFieldValue(formFieldBean.getName()) : ((Map)object).get(formFieldBean.getName());
            if (value != null) {
                stringBuilder.append(formFieldBean.getName());
                stringBuilder.append("_");
                stringBuilder.append(this.getFieldFormatData(formFieldBean, value, uniqueBean.getFieldDecimalFormat()));
                stringBuilder.append("_");
                continue;
            }
            stringBuilder.setLength(0);
            break;
        }
        return stringBuilder;
    }

    public void setCap4FormDataManager(CAP4FormDataManager cap4FormDataManager) {
        this.cap4FormDataManager = cap4FormDataManager;
    }

    public void setSerialCalculateRecordDAO(SerialCalculateRecordDAO serialCalculateRecordDAO) {
        this.serialCalculateRecordDAO = serialCalculateRecordDAO;
    }

    public void setCapImportUniqueManager(CAPImportUniqueManager capImportUniqueManager) {
        this.capImportUniqueManager = capImportUniqueManager;
    }

    public void setCap4FormManager(CAP4FormManager cap4FormManager) {
        this.cap4FormManager = cap4FormManager;
    }
}

