/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.cap4.template.manager.impl;

import com.seeyon.cap4.form.bean.FormAuthViewBean;
import com.seeyon.cap4.form.bean.FormBean;
import com.seeyon.cap4.form.bean.FormBindAuthBean;
import com.seeyon.cap4.form.bean.FormDataBean;
import com.seeyon.cap4.form.bean.FormDataMasterBean;
import com.seeyon.cap4.form.bean.FormDataSubBean;
import com.seeyon.cap4.form.bean.FormFieldBean;
import com.seeyon.cap4.form.bean.FormTableBean;
import com.seeyon.cap4.form.bean.FormTriggerBean;
import com.seeyon.cap4.form.modules.engin.base.formData.CAP4FormDataDAO;
import com.seeyon.cap4.form.modules.engin.base.formData.CAP4FormDataManager;
import com.seeyon.cap4.form.modules.engin.base.formData.CAPFormDataCacheManager;
import com.seeyon.cap4.form.modules.engin.trigger.CAP4FormTriggerManager;
import com.seeyon.cap4.form.modules.event.FormDataAfterSubmitEvent;
import com.seeyon.cap4.form.util.Enums;
import com.seeyon.cap4.form.util.sqlite.CAPSQLiteUtil;
import com.seeyon.cap4.task.TaskExecuteManager;
import com.seeyon.cap4.template.annotation.JMCalling4Service;
import com.seeyon.cap4.template.annotation.ParamClass;
import com.seeyon.cap4.template.bean.ExcelReadParamBean;
import com.seeyon.cap4.template.bean.ExcelReadResultBean;
import com.seeyon.cap4.template.bean.ExportTableBean;
import com.seeyon.cap4.template.bean.ImportCalcResultBean;
import com.seeyon.cap4.template.bean.ImportDBDataListBean;
import com.seeyon.cap4.template.bean.ImportExecuteResolveFieldBean;
import com.seeyon.cap4.template.bean.ImportFormDataParamBean;
import com.seeyon.cap4.template.bean.ImportReadDataBean;
import com.seeyon.cap4.template.bean.ImportSQLiteIdBean;
import com.seeyon.cap4.template.bean.ImportUniqueBean;
import com.seeyon.cap4.template.bean.ImportUniqueDbResultBean;
import com.seeyon.cap4.template.bean.ImportUniqueDefinitionBean;
import com.seeyon.cap4.template.constant.CAPBusinessEnum;
import com.seeyon.cap4.template.exception.FormDataBusinessException;
import com.seeyon.cap4.template.manager.CAPImportCacheDataManager;
import com.seeyon.cap4.template.manager.CAPImportCalcManager4FormData;
import com.seeyon.cap4.template.manager.CAPImportManager;
import com.seeyon.cap4.template.manager.impl.AbstractCAPImportManager;
import com.seeyon.cap4.template.vo.AImportDataVO;
import com.seeyon.cap4.template.vo.ExcelReadResultTableVO;
import com.seeyon.cap4.template.vo.ExportFileVO;
import com.seeyon.cap4.template.vo.ExportSubTableDataVO;
import com.seeyon.cap4.template.vo.ExportTableLineDataVO;
import com.seeyon.cap4.template.vo.ImportDataExecuteVO;
import com.seeyon.cap4.template.vo.ImportFieldVO;
import com.seeyon.cap4.template.vo.ImportReadDataVO;
import com.seeyon.cap4.template.vo.ImportUniqueFieldVO;
import com.seeyon.ctp.common.ModuleType;
import com.seeyon.ctp.common.content.mainbody.MainbodyManager;
import com.seeyon.ctp.common.exceptions.BusinessException;
import com.seeyon.ctp.common.i18n.ResourceUtil;
import com.seeyon.ctp.common.log.CtpLogFactory;
import com.seeyon.ctp.common.po.content.CtpContentAll;
import com.seeyon.ctp.event.Event;
import com.seeyon.ctp.event.EventDispatcher;
import com.seeyon.ctp.form.modules.serialNumber.SerialCalRecordManager;
import com.seeyon.ctp.form.po.FormSerialCalculateRecord;
import com.seeyon.ctp.util.FlipInfo;
import com.seeyon.ctp.util.Strings;
import java.io.File;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.poi.ss.usermodel.Workbook;

@ParamClass(clazz=ImportFormDataParamBean.class)
public class CAPImportManager4FormData
extends AbstractCAPImportManager
implements CAPImportManager<ImportFormDataParamBean, AImportDataVO> {
    private static final Log LOGGER = CtpLogFactory.getLog(CAPImportManager4FormData.class);
    private static final String MASTER_TABLE = "cap.form.batchOperation.excelDatas.masterTable";
    private static final String NOT_TRIGGER_FILE_NAME = "cap.form.batchOperation.notTriggerFileName";
    private static final String VARCHAR = " VARCHAR(4000)";
    private static final int SQLITE_LIMIT = 300;
    private static final String ID = "id";
    private static final int SQLITE_ERROR_SIZE = 1000;
    private MainbodyManager ctpMainbodyManager;
    private SerialCalRecordManager serialCalRecordManager;
    private CAP4FormDataManager cap4FormDataManager;
    private CAPImportCalcManager4FormData capImportCalcManager4FormData;
    private CAPFormDataCacheManager capFormDataCacheManager;
    private CAP4FormTriggerManager cap4FormTriggerManager;
    private TaskExecuteManager taskExecuteManager;
    private CAPImportCacheDataManager capImportCacheDataManager;
    private CAP4FormDataDAO cap4FormDataDAO;

    @Override
    public String getType() {
        return CAPBusinessEnum.BatchOperationEnum.BATCH_IMPORT.getKey();
    }

    @Override
    @JMCalling4Service(batchRunType=CAPBusinessEnum.BatchOperationEnum.BATCH_IMPORT)
    public AImportDataVO readData(ImportFormDataParamBean bean) throws BusinessException {
        FormBean formBean = this.cap4FormCacheManager.getForm(bean.getFormId());
        ImportReadDataBean readDataBean = this.readExcel2SQLite(formBean, bean);
        return this.readDataFromSQLite(formBean, bean, readDataBean);
    }

    @Override
    @JMCalling4Service(batchRunType=CAPBusinessEnum.BatchOperationEnum.BATCH_IMPORT)
    public AImportDataVO execute(ImportFormDataParamBean bean) throws BusinessException {
        return this.transImportFormExcelDatas(bean);
    }

    private List<Integer> getExecutePageMasterIds(int i, int totalPage, ImportSQLiteIdBean sqLiteIdBean) {
        int pageStartIndex = i * 300;
        int size = i == totalPage - 1 ? (sqLiteIdBean.getSuccessSize() % 300 == 0 ? 300 : sqLiteIdBean.getSuccessSize() % 300) : 300;
        return sqLiteIdBean.getSuccessIds().subList(pageStartIndex, pageStartIndex + size);
    }

    private Map<Integer, FormDataMasterBean> initExecuteDataBeans(FormBean formBean, ImportExecuteResolveFieldBean resolveFieldBean, List<Integer> masterIds, Connection connection) throws SQLException {
        HashMap<Integer, FormDataMasterBean> formDataMasterBeanMap = new HashMap<Integer, FormDataMasterBean>(300);
        String masterTableName = formBean.getMasterTableBean().getTableName();
        List<Map<String, Object>> masterDataList = this.getSQLiteDataListByIn(connection, masterIds, masterTableName, Enums.MasterTableField.id.getKey());
        for (Map<String, Object> masterData : masterDataList) {
            HashMap<String, Object> data4Bean = new HashMap<String, Object>();
            this.getTableLineDataVO(formBean, masterData, data4Bean, resolveFieldBean.getAllFieldsMap().get(masterTableName));
            FormDataMasterBean formDataMasterBean = new FormDataMasterBean(data4Bean, formBean.getMasterTableBean(), new boolean[]{true});
            formDataMasterBeanMap.put((Integer)masterData.get(ID), formDataMasterBean);
        }
        for (FormTableBean subTableBean : formBean.getSubTableBean()) {
            String subTableName = subTableBean.getTableName();
            if (resolveFieldBean.getAllFieldsMap().get(subTableName) == null) continue;
            List<Map<String, Object>> subDataList = this.getSQLiteDataListByIn(connection, masterIds, subTableName, Enums.SubTableField.formmain_id.getKey());
            for (Map<String, Object> subData : subDataList) {
                Integer sqLiteFormMainId = (Integer)subData.get(Enums.SubTableField.formmain_id.getKey());
                FormDataMasterBean dataMasterBean = (FormDataMasterBean)formDataMasterBeanMap.get(sqLiteFormMainId);
                if (dataMasterBean == null) continue;
                HashMap<String, Object> data4Bean = new HashMap<String, Object>();
                this.getTableLineDataVO(formBean, subData, data4Bean, resolveFieldBean.getAllFieldsMap().get(subTableName));
                data4Bean.put(Enums.SubTableField.formmain_id.getKey(), dataMasterBean.getId());
                FormDataSubBean formDataSubBean = new FormDataSubBean(data4Bean, subTableBean, dataMasterBean, new boolean[]{true});
                dataMasterBean.addSubData(subTableName, formDataSubBean);
            }
        }
        return formDataMasterBeanMap;
    }

    private Set<Integer> executeUnique4ExcelSelfCheck(List<ImportUniqueBean> uniqueBeans, Map<Integer, FormDataMasterBean> formDataMasterBeansMap) {
        long beginTime = System.currentTimeMillis();
        HashSet<Integer> errorIds = new HashSet<Integer>();
        HashMap<String, Integer> excelDataUniqueMark = new HashMap<String, Integer>();
        block0: for (Map.Entry<Integer, FormDataMasterBean> entry : formDataMasterBeansMap.entrySet()) {
            Integer sqliteId = entry.getKey();
            FormDataMasterBean formDataMasterBean = entry.getValue();
            for (ImportUniqueBean uniqueBean : uniqueBeans) {
                FormDataSubBean formDataSubBean;
                StringBuilder stringBuilder;
                List subDatas;
                if (uniqueBean.isOnlyMaster()) {
                    StringBuilder masterDataString = this.capImportCalcManager4FormData.getFieldUniqueStr((FormDataBean)formDataMasterBean, uniqueBean, true);
                    if (masterDataString.length() == 0 || !this.checkFieldUniqueStrExits(masterDataString, sqliteId, errorIds, excelDataUniqueMark)) continue;
                    continue block0;
                }
                if (uniqueBean.isMasterAndSub()) {
                    FormDataSubBean formDataSubBean2;
                    StringBuilder subSb;
                    List subDatas2;
                    StringBuilder masterSb = this.capImportCalcManager4FormData.getFieldUniqueStr((FormDataBean)formDataMasterBean, uniqueBean, true);
                    if (masterSb.length() == 0 || CollectionUtils.isEmpty((Collection)(subDatas2 = formDataMasterBean.getSubData(uniqueBean.getSubTableName())))) continue;
                    Iterator iterator = subDatas2.iterator();
                    while (iterator.hasNext() && ((subSb = this.capImportCalcManager4FormData.getFieldUniqueStr((FormDataBean)(formDataSubBean2 = (FormDataSubBean)iterator.next()), uniqueBean, false)).length() == 0 || !this.checkFieldUniqueStrExits(subSb.append((CharSequence)masterSb), sqliteId, errorIds, excelDataUniqueMark))) {
                    }
                    continue;
                }
                if (!uniqueBean.isOnlySub() || CollectionUtils.isEmpty((Collection)(subDatas = formDataMasterBean.getSubData(uniqueBean.getSubTableName())))) continue;
                Iterator iterator = subDatas.iterator();
                while (iterator.hasNext() && ((stringBuilder = this.capImportCalcManager4FormData.getFieldUniqueStr((FormDataBean)(formDataSubBean = (FormDataSubBean)iterator.next()), uniqueBean, false)).length() == 0 || !this.checkFieldUniqueStrExits(stringBuilder, sqliteId, errorIds, excelDataUniqueMark))) {
                }
            }
        }
        LOGGER.info((Object)("\u5bfc\u5165\u6570\u636echeckExcelSelfUniqueMark\u6821\u9a8cexcel\u81ea\u8eab\u552f\u4e00 use " + (System.currentTimeMillis() - beginTime)));
        return errorIds;
    }

    private boolean checkFieldUniqueStrExits(StringBuilder stringBuilder, Integer sqliteId, Set<Integer> errorIds, Map<String, Integer> excelDataUniqueMark) {
        String uniqueStr = stringBuilder.toString().toLowerCase();
        if (excelDataUniqueMark.get(uniqueStr) == null) {
            excelDataUniqueMark.put(uniqueStr, sqliteId);
            return false;
        }
        errorIds.add(sqliteId);
        return true;
    }

    private ImportDBDataListBean getDbDataById(FormBean formBean, List<Object> masterIds) throws BusinessException {
        if (CollectionUtils.isEmpty(masterIds)) {
            LOGGER.info((Object)"getDbDataById masterIds is empty!");
            return null;
        }
        long beginTime = System.currentTimeMillis();
        ImportDBDataListBean dataBean = new ImportDBDataListBean();
        HashMap<String, Map<String, List<Map<String, Object>>>> subTable2Data = new HashMap<String, Map<String, List<Map<String, Object>>>>();
        dataBean.setMasterData(this.getTableDataList(formBean.getMasterTableBean().getTableName(), null, masterIds));
        dataBean.setSubTable2Data(subTable2Data);
        List formSubTableBeanList = formBean.getSubTableBean();
        for (FormTableBean formSubTableBean : formSubTableBeanList) {
            String subTableName = formSubTableBean.getTableName();
            subTable2Data.put(subTableName, this.getDbSubTableData(subTableName, null, masterIds));
        }
        LOGGER.info((Object)("getDbDataById use " + (System.currentTimeMillis() - beginTime)));
        return dataBean;
    }

    private Map<String, List<Map<String, Object>>> getDbSubTableData(String tableName, List<String> fieldNames, List<Object> masterIds) throws BusinessException {
        HashMap<String, List<Map<String, Object>>> masterId2Data = new HashMap<String, List<Map<String, Object>>>();
        List subDataMapList = this.getTableDataList(tableName, fieldNames, masterIds);
        for (Map subDataMap : subDataMapList) {
            String masterId = String.valueOf(subDataMap.get(Enums.SubTableField.formmain_id.getKey()));
            ArrayList<Map> subData = (ArrayList<Map>)masterId2Data.get(masterId);
            if (subData == null) {
                subData = new ArrayList<Map>();
                masterId2Data.put(masterId, subData);
            }
            subData.add(subDataMap);
        }
        return masterId2Data;
    }

    private ImportDBDataListBean getDbUniqueDataList(FormBean formBean, Map<String, List<String>> tableUniqueFieldNames, FlipInfo flipInfo) throws BusinessException {
        long beginTime = System.currentTimeMillis();
        String masterTableName = formBean.getMasterTableBean().getTableName();
        ArrayList<String> masterFieldNames = tableUniqueFieldNames.get(masterTableName) != null ? new ArrayList(tableUniqueFieldNames.get(masterTableName)) : new ArrayList<String>(1);
        masterFieldNames.add(Enums.MasterTableField.id.getKey());
        List masterDataList = this.getTableDataList(masterTableName, masterFieldNames, null, flipInfo);
        if (CollectionUtils.isEmpty((Collection)masterDataList)) {
            LOGGER.info((Object)("\u5bfc\u5165\u6570\u636egetDbUniqueDataList\u52a0\u8f7dDB\u6570\u636e\uff0c\u6570\u636e\u4e3a\u7a7a\u3002" + masterTableName));
            return null;
        }
        ImportDBDataListBean dataBean = new ImportDBDataListBean();
        dataBean.setMasterData(new ArrayList<Map<String, Object>>());
        dataBean.setSubTable2Data(new HashMap<String, Map<String, List<Map<String, Object>>>>());
        dataBean.getMasterData().addAll(masterDataList);
        ArrayList<Object> masterIds = new ArrayList<Object>(dataBean.getMasterId2Data().keySet());
        for (Map.Entry<String, List<String>> entry : tableUniqueFieldNames.entrySet()) {
            String tableName = entry.getKey();
            if (tableName.equals(masterTableName)) continue;
            ArrayList<String> fieldNames = new ArrayList<String>((Collection)entry.getValue());
            fieldNames.add(Enums.SubTableField.id.getKey());
            fieldNames.add(Enums.SubTableField.formmain_id.getKey());
            dataBean.getSubTable2Data().put(tableName, this.getDbSubTableData(tableName, fieldNames, masterIds));
        }
        LOGGER.info((Object)("\u5bfc\u5165\u6570\u636egetDbUniqueDataList\u52a0\u8f7dDB\u5355\u6b21\u6570\u636e\u552f\u4e00 use : " + (System.currentTimeMillis() - beginTime) + " flipInfo " + flipInfo.getPage() + "," + flipInfo.getSize()));
        return dataBean;
    }

    private ImportUniqueDefinitionBean initDefinitionBean(FormBean formBean, List<Map<String, Object>> uniqueMarks) {
        ImportUniqueDefinitionBean definitionBean = new ImportUniqueDefinitionBean();
        definitionBean.setAllUniqueBeans(this.getUniqueBeans(formBean, ""));
        if (CollectionUtils.isEmpty(definitionBean.getAllUniqueBeans())) {
            return definitionBean;
        }
        HashMap<String, String> uniqueMarksMap = new HashMap<String, String>();
        if (uniqueMarks != null) {
            for (Map map : uniqueMarks) {
                uniqueMarksMap.put(String.valueOf(map.get("display")), String.valueOf(map.get("updateMark")));
            }
        }
        for (ImportUniqueBean importUniqueBean : definitionBean.getAllUniqueBeans()) {
            String isUpdateFlag = (String)uniqueMarksMap.get(importUniqueBean.getDisplay());
            if (CAPBusinessEnum.TrueOrFalseEnum.TRUE.getKey().equals(isUpdateFlag)) {
                importUniqueBean.setUpdateMark(true);
                definitionBean.getUpdateUniqueBeans().add(importUniqueBean);
                continue;
            }
            if (importUniqueBean.isHasSubField()) {
                definitionBean.getHasSubFiledUniqueBeans().add(importUniqueBean);
            }
            definitionBean.getDeleteUniqueBeans().add(importUniqueBean);
        }
        return definitionBean;
    }

    private void getUniqueMarkDataMap(FormBean formBean, ImportUniqueDefinitionBean definitionBean, Connection connection) throws BusinessException, SQLException {
        if (CollectionUtils.isEmpty(definitionBean.getAllUniqueBeans())) {
            return;
        }
        Map<String, List<String>> tableUniqueFieldNames = this.getTableUniqueFieldNames(formBean);
        if (tableUniqueFieldNames == null || tableUniqueFieldNames.isEmpty()) {
            LOGGER.info((Object)"\u5bfc\u5165\u6570\u636egetUniqueMarkDataMap\u52a0\u8f7dDB\u6240\u6709\u6570\u636e\u552f\u4e00\uff0c\u65e0\u6570\u636e\u552f\u4e00\u8bbe\u7f6e\uff0ctableUniqueFieldNames is empty!");
            return;
        }
        String masterTableName = formBean.getMasterTableBean().getTableName();
        int tableCount = this.getTableDataCount(masterTableName, null, null);
        this.capImportUniqueManager.createTable(connection);
        if (tableCount == 0) {
            LOGGER.info((Object)("\u5bfc\u5165\u6570\u636egetUniqueMarkDataMap\u52a0\u8f7dDB\u6240\u6709\u6570\u636e\u552f\u4e00\uff0c\u5e95\u8868\u6570\u636e\u4e3a\u7a7a!" + masterTableName));
            return;
        }
        int pageSize = 900;
        int totalPage = tableCount % pageSize == 0 ? tableCount / pageSize : tableCount / pageSize + 1;
        FlipInfo flipInfo = new FlipInfo();
        flipInfo.setNeedTotal(false);
        flipInfo.setTotal(tableCount);
        flipInfo.setSize(pageSize);
        String uniqueSql = this.capImportUniqueManager.getInsertSql();
        long startTime = System.currentTimeMillis();
        for (int i = 1; i <= totalPage; ++i) {
            flipInfo.setPage(i);
            ImportDBDataListBean dataBean = this.getDbUniqueDataList(formBean, tableUniqueFieldNames, flipInfo);
            Map<String, String> uniqueMarkDataMap = this.capImportCalcManager4FormData.buildDbUniqueMarkMap(definitionBean.getAllUniqueBeans(), dataBean);
            this.capImportUniqueManager.insert(connection, uniqueSql, uniqueMarkDataMap);
            uniqueMarkDataMap.clear();
        }
        LOGGER.info((Object)("\u5bfc\u5165\u6570\u636egetUniqueMarkDataMap\u52a0\u8f7dDB\u6240\u6709\u6570\u636e\u552f\u4e00\uff0cuse " + (System.currentTimeMillis() - startTime) + ", totalPage " + totalPage));
    }

    private void executeUnique4ExcelSelf(ImportUniqueDefinitionBean definitionBean, Map<Integer, FormDataMasterBean> formDataMasterBeanMap, Map<Integer, String> sqliteId2Error) {
        Set<Integer> selfErrorIds = this.executeUnique4ExcelSelfCheck(definitionBean.getAllUniqueBeans(), formDataMasterBeanMap);
        for (Integer id : selfErrorIds) {
            sqliteId2Error.put(id, CAPBusinessEnum.BatchValidateRulesEnum.UNIQUE_IDENTIFIER_ERROR.getType());
            formDataMasterBeanMap.remove(id);
        }
        selfErrorIds.clear();
    }

    private void executeUnique(FormBean formBean, ImportUniqueDefinitionBean definitionBean, ImportExecuteResolveFieldBean resolveFieldBean, Map<Integer, FormDataMasterBean> formDataMasterBeanMap, Map<Integer, FormDataMasterBean> updateMasterDataBeanMap, Map<String, Set<Long>> subTable2AddIds, Map<Integer, String> sqliteId2Error, Connection connection) throws BusinessException, SQLException {
        HashSet<Integer> errorIds = new HashSet<Integer>();
        ImportUniqueDbResultBean updateResult = this.capImportCalcManager4FormData.getCheckDbUniqueData(errorIds, formBean, definitionBean.getUpdateUniqueBeans(), formDataMasterBeanMap, false, false, connection);
        HashSet<Long> updateDbMasterIds = new HashSet<Long>();
        for (Map.Entry<Integer, List<String>> entry : updateResult.getUpdateIds().entrySet()) {
            Integer id = entry.getKey();
            updateMasterDataBeanMap.put(id, formDataMasterBeanMap.get(id));
            formDataMasterBeanMap.remove(id);
            for (String value : entry.getValue()) {
                String finalValue = value.contains(",") ? value.split(",")[0] : value;
                updateDbMasterIds.add(Long.valueOf(finalValue));
            }
        }
        this.capImportCalcManager4FormData.getCheckDbUniqueData(errorIds, formBean, definitionBean.getDeleteUniqueBeans(), formDataMasterBeanMap, false, false, connection);
        for (Integer id : errorIds) {
            sqliteId2Error.put(id, CAPBusinessEnum.BatchValidateRulesEnum.UNIQUE_IDENTIFIER_ERROR.getType());
            formDataMasterBeanMap.remove(id);
        }
        if (CollectionUtils.isEmpty(definitionBean.getUpdateUniqueBeans())) {
            return;
        }
        ImportUniqueDbResultBean hasSubFiledResult = this.capImportCalcManager4FormData.getCheckDbUniqueData(errorIds, formBean, definitionBean.getHasSubFiledUniqueBeans(), updateMasterDataBeanMap, false, true, connection);
        ImportDBDataListBean dbDataBean = null;
        if (updateDbMasterIds.size() > 0) {
            dbDataBean = this.getDbDataById(formBean, new ArrayList<Object>(updateDbMasterIds));
        }
        if (dbDataBean == null) {
            return;
        }
        for (Map.Entry<Integer, List<String>> entry : updateResult.getUpdateIds().entrySet()) {
            HashSet<Long> leftAddSubIds;
            List<String> fieldNames;
            Map<String, Object> masterData;
            String dbMasterId;
            Integer sqliteId = entry.getKey();
            List<String> needUpdateDataIds = entry.getValue();
            ImportUniqueBean updateUniqueBean = definitionBean.getUpdateUniqueBeans().get(0);
            Map<String, Set<Long>> subTableIds = hasSubFiledResult.getSqliteId2SubTableIds().get(sqliteId);
            if (updateUniqueBean.isOnlyMaster()) {
                dbMasterId = needUpdateDataIds.get(0);
                Map<String, Object> map = masterData = dbDataBean.getMasterId2Data() != null ? dbDataBean.getMasterId2Data().get(dbMasterId) : null;
                if (masterData == null) continue;
                FormDataMasterBean formDataMasterBeanLeft = updateMasterDataBeanMap.get(sqliteId);
                FormDataMasterBean formDataMasterBeanRight = new FormDataMasterBean(formBean.getMasterTableBean(), new boolean[]{true});
                fieldNames = resolveFieldBean.getAllFieldsMap().get(formBean.getMasterTableBean().getTableName());
                for (String string : fieldNames) {
                    masterData.put(string, formDataMasterBeanLeft.getFieldValue(string));
                }
                formDataMasterBeanRight.addFieldValue(masterData);
                formDataMasterBeanRight.setId(Long.valueOf(dbMasterId));
                List formTableBeanList = formBean.getSubTableBean();
                Iterator iterator = formTableBeanList.iterator();
                while (iterator.hasNext()) {
                    List formDataSubBeans;
                    FormTableBean formTableBean = (FormTableBean)iterator.next();
                    String tableName = formTableBean.getTableName();
                    Set<Long> subTableDataIds = null;
                    if (subTableIds != null) {
                        subTableDataIds = subTableIds.get(tableName);
                    }
                    boolean firstNull = false;
                    List<Map<String, Object>> subTables = dbDataBean.getSubTable2Data().get(tableName).get(dbMasterId);
                    if (subTables != null) {
                        FormDataSubBean firstFormDataSubBean = null;
                        for (Map<String, Object> map2 : subTables) {
                            Long subId = Long.valueOf(String.valueOf(map2.get(Enums.SubTableField.id.getKey())));
                            FormDataSubBean formDataSubBean = new FormDataSubBean(formTableBean, formDataMasterBeanRight, new boolean[]{true});
                            formDataSubBean.addFieldValue(map2);
                            formDataSubBean.setId(subId);
                            formDataMasterBeanRight.addSubData(tableName, formDataSubBean);
                            firstFormDataSubBean = formDataSubBean;
                        }
                        if (subTables.size() == 1 && firstFormDataSubBean.isEmpty()) {
                            firstNull = true;
                        }
                    }
                    if ((formDataSubBeans = formDataMasterBeanLeft.getSubData(tableName)) == null) continue;
                    leftAddSubIds = new HashSet<Long>();
                    for (FormDataSubBean formDataSubBean : formDataSubBeans) {
                        if (subTableDataIds != null && subTableDataIds.contains(formDataSubBean.getId())) continue;
                        if (firstNull) {
                            FormDataSubBean firstSubDataBean = (FormDataSubBean)formDataMasterBeanRight.getSubData(tableName).get(0);
                            Long id = firstSubDataBean.getId();
                            int sort = firstSubDataBean.getSort();
                            firstSubDataBean.addFieldValue(formDataSubBean.getRowData());
                            firstSubDataBean.setId(id);
                            firstSubDataBean.setSort(sort);
                            firstSubDataBean.setFormmainId(Long.parseLong(dbMasterId));
                            firstNull = false;
                            continue;
                        }
                        formDataSubBean.setFormmainId(Long.parseLong(dbMasterId));
                        formDataMasterBeanRight.addSubData(tableName, formDataSubBean);
                        leftAddSubIds.add(formDataSubBean.getId());
                    }
                    this.executeUnique4SubTable2AddIds(subTable2AddIds, tableName, leftAddSubIds);
                }
                updateMasterDataBeanMap.put(sqliteId, formDataMasterBeanRight);
                continue;
            }
            if (!updateUniqueBean.isMasterAndSub()) continue;
            dbMasterId = needUpdateDataIds.get(0).split(",")[0];
            Map<String, Object> map = masterData = dbDataBean.getMasterId2Data() != null ? dbDataBean.getMasterId2Data().get(dbMasterId) : null;
            if (masterData == null) continue;
            Map<String, String> subDataId = updateResult.getSubDataId();
            FormDataMasterBean formDataMasterBeanLeft = updateMasterDataBeanMap.get(sqliteId);
            fieldNames = resolveFieldBean.getAllFieldsMap().get(formBean.getMasterTableBean().getTableName());
            for (String string : fieldNames) {
                masterData.put(string, formDataMasterBeanLeft.getFieldValue(string));
            }
            formDataMasterBeanLeft.addFieldValue(masterData);
            formDataMasterBeanLeft.setId(Long.valueOf(dbMasterId));
            HashMap<String, String> leftAndRightSubId = new HashMap<String, String>();
            for (String masterSubId : needUpdateDataIds) {
                String leftSubId = subDataId.get(masterSubId);
                String dbSubId = masterSubId.contains(",") ? masterSubId.split(",")[1] : "";
                leftAndRightSubId.put(dbSubId, leftSubId);
            }
            List list = formBean.getSubTableBean();
            for (FormTableBean formTableBean : list) {
                String tableName = formTableBean.getTableName();
                HashMap<String, FormDataSubBean> leftFormDataSubBean = new HashMap<String, FormDataSubBean>();
                if (formDataMasterBeanLeft.getSubData(tableName) != null) {
                    for (FormDataSubBean formDataSubBean : formDataMasterBeanLeft.getSubData(tableName)) {
                        leftFormDataSubBean.put(String.valueOf(formDataSubBean.getId()), formDataSubBean);
                    }
                }
                formDataMasterBeanLeft.setSubData(tableName, new ArrayList());
                Set<Long> subTableDataIds = subTableIds == null ? null : subTableIds.get(tableName);
                List<Map<String, Object>> subDatas = dbDataBean.getSubTable2Data().get(tableName).get(dbMasterId);
                if (subDatas != null) {
                    for (Map map3 : subDatas) {
                        String dbSubId = String.valueOf(map3.get(Enums.SubTableField.id.getKey()));
                        String leftSubId = (String)leftAndRightSubId.get(dbSubId);
                        FormDataSubBean formDataSubBean = null;
                        if (leftSubId != null) {
                            formDataSubBean = (FormDataSubBean)leftFormDataSubBean.get(leftSubId);
                            List<String> subFieldNames = resolveFieldBean.getAllFieldsMap().get(tableName);
                            for (String subFieldName : subFieldNames) {
                                map3.put(subFieldName, formDataSubBean.getFieldValue(subFieldName));
                            }
                            leftFormDataSubBean.remove(leftSubId);
                        }
                        if (formDataSubBean != null) {
                            formDataSubBean.addFieldValue(map3);
                            formDataSubBean.setId(Long.valueOf(dbSubId));
                            formDataSubBean.setFormmainId(Long.parseLong(dbMasterId));
                        } else {
                            formDataSubBean = new FormDataSubBean(formTableBean, formDataMasterBeanLeft, new boolean[]{true});
                            formDataSubBean.addFieldValue(map3);
                        }
                        formDataMasterBeanLeft.addSubData(tableName, formDataSubBean);
                    }
                }
                if (leftFormDataSubBean.size() <= 0) continue;
                leftAddSubIds = new HashSet<Long>();
                for (FormDataSubBean formDataSubBean : leftFormDataSubBean.values()) {
                    if (subTableDataIds != null && subTableDataIds.contains(formDataSubBean.getId())) continue;
                    formDataSubBean.setFormmainId(Long.parseLong(dbMasterId));
                    formDataMasterBeanLeft.addSubData(tableName, formDataSubBean);
                    leftAddSubIds.add(formDataSubBean.getId());
                }
                this.executeUnique4SubTable2AddIds(subTable2AddIds, tableName, leftAddSubIds);
            }
            updateMasterDataBeanMap.put(sqliteId, formDataMasterBeanLeft);
        }
    }

    private void executeUnique4SubTable2AddIds(Map<String, Set<Long>> subTable2AddIds, String tableName, Set<Long> addIds) {
        Set<Long> addSubIds = subTable2AddIds.get(tableName);
        if (addSubIds == null) {
            addSubIds = new HashSet<Long>();
            subTable2AddIds.put(tableName, addSubIds);
        }
        addSubIds.addAll(addIds);
    }

    /*
     * Exception decompiling
     */
    private ImportDataExecuteVO transImportFormExcelDatas(ImportFormDataParamBean paramBean) throws BusinessException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [4[CATCHBLOCK]], but top level block is 2[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private List<ExportTableLineDataVO> getSQLiteErrorData4ExportFile(FormBean formBean, List<Integer> errorSqliteMasterIds, Map<Integer, String> allErrorSqliteDataIds, ImportExecuteResolveFieldBean resolveFieldBean, Map<String, ExportSubTableDataVO> subDataMaps, Connection connection) throws SQLException {
        ArrayList<ExportTableLineDataVO> masterDataList = new ArrayList<ExportTableLineDataVO>();
        ArrayList<Integer> param = new ArrayList<Integer>();
        param.addAll(errorSqliteMasterIds);
        param.addAll(allErrorSqliteDataIds.keySet());
        int size = param.size();
        if (size > 1000) {
            ArrayList mIDs;
            int end = 0;
            for (int i = 0; i < size / 1000; ++i) {
                mIDs = new ArrayList(1000);
                end = (i + 1) * 1000;
                for (int j = i * 1000; j < end; ++j) {
                    mIDs.add(param.get(j));
                }
                this.getSQLiteMasterAndSubData(formBean, connection, resolveFieldBean.getAllFieldsMap(), allErrorSqliteDataIds, masterDataList, subDataMaps, mIDs);
            }
            if (end < size) {
                mIDs = new ArrayList(size - end);
                for (int j = end; j < size; ++j) {
                    mIDs.add(param.get(j));
                }
                this.getSQLiteMasterAndSubData(formBean, connection, resolveFieldBean.getAllFieldsMap(), allErrorSqliteDataIds, masterDataList, subDataMaps, mIDs);
            }
        } else {
            this.getSQLiteMasterAndSubData(formBean, connection, resolveFieldBean.getAllFieldsMap(), allErrorSqliteDataIds, masterDataList, subDataMaps, param);
        }
        return masterDataList;
    }

    private void resetCustomFunctionError(FormBean formBean, FormBindAuthBean formBindAuthBean, int totalSize, ImportDataExecuteVO data) {
        try {
            String errorInfo = ResourceUtil.getString((String)"form.data.exception.customfunc.error.tips");
            Workbook workbook = this.capExcelManager.exportPromptFile(formBean, formBindAuthBean.getName(), errorInfo);
            ExportFileVO fileVO = new ExportFileVO();
            fileVO.setFileName(formBean.getFormName());
            this.capExcelManager.saveExcel(fileVO, workbook);
            data.setFailRecord(fileVO);
            data.setSuccessImportCount("0");
            data.setFailImportCount(String.valueOf(totalSize));
            data.setFormName(formBean.getFormName());
            data.setFailTriggerCount("0");
        }
        catch (BusinessException e) {
            LOGGER.error((Object)"transImportFormExcelDatas.resetCustomFunctionError.BusinessException", (Throwable)e);
        }
    }

    private void transBatchDoTrigger(FormBean formBean, ImportFormDataParamBean paramBean, List<String> sqliteIds, List<String> masterDataIds, ImportDataExecuteVO executeVO, Connection connection) throws SQLException, BusinessException {
        if (!this.taskExecuteManager.isCapacityFull(masterDataIds.size(), formBean.getId())) {
            LOGGER.info((Object)("\u6279\u91cf\u64cd\u4f5c\u6267\u884c\u89e6\u53d1\u7684\u6570\u636e\uff1a\u6761\u6570=" + masterDataIds.size()));
            String triggerType = CAPBusinessEnum.BatchOperationEnum.BATCH_UPDATE.getKey().equals(paramBean.getType()) ? FormTriggerBean.TriggerEventSourceEnum.batchUpdate.getKey() : FormTriggerBean.TriggerEventSourceEnum.batchRefresh.getKey();
            FormAuthViewBean formAuthViewBean = formBean.getNewFormAuthViewBean();
            for (String dataId : masterDataIds) {
                this.cap4FormTriggerManager.doTrigger(ModuleType.cap4UnflowForm.getKey(), Long.parseLong(dataId), (long)formBean.getId(), String.valueOf(formAuthViewBean.getId()), null, triggerType);
            }
            executeVO.setFailTriggerCount("0");
        } else {
            Object fieldInfos = paramBean.getTableFields().get(formBean.getMasterTableBean().getTableName());
            if (fieldInfos == null || Strings.isBlank((String)String.valueOf(fieldInfos))) {
                return;
            }
            LOGGER.info((Object)("\u6279\u91cf\u64cd\u4f5c\u7684\u89e6\u53d1\u5bb9\u91cf\u6ee1\u4e86\uff1a\u6761\u6570=" + masterDataIds.size()));
            List<String> fieldNameList = Arrays.asList(String.valueOf(fieldInfos).split(","));
            ArrayList<FormFieldBean> fieldList = new ArrayList<FormFieldBean>();
            for (String fieldName : fieldNameList) {
                FormFieldBean formFieldBean = formBean.getFieldBeanByName(fieldName, true);
                if (!this.checkImportSupportField(formFieldBean)) continue;
                fieldList.add(formFieldBean);
            }
            int totalFieldSize = fieldList.size();
            String masterTableName = formBean.getMasterTableBean().getTableName();
            ExportTableBean tableVO = new ExportTableBean(formBean.getMasterTableBean());
            ArrayList<ExportTableLineDataVO> masterDataList = new ArrayList<ExportTableLineDataVO>();
            List<Map<String, Object>> masterDatas = this.getSQLiteDataListByIn(connection, sqliteIds, masterTableName, ID);
            for (Map<String, Object> masterData : masterDatas) {
                Integer id = (Integer)masterData.get(ID);
                ExportTableLineDataVO oneLineDataResult = this.getTableLineDataVO(formBean, masterData, masterData, fieldNameList);
                oneLineDataResult.setError(CAPBusinessEnum.BatchValidateRulesEnum.TRIGGER_CAPACITY_FULL_ERROR.getExplain());
                oneLineDataResult.setMasterId(String.valueOf(id));
                masterDataList.add(oneLineDataResult);
            }
            FormBindAuthBean formBindAuthBean = formBean.getBind().getFormBindAuthBean(String.valueOf(paramBean.getModuleId()));
            Workbook workbook = this.capExcelManager.exportExcelFile(formBindAuthBean.getName(), formBean, tableVO, totalFieldSize, masterDataList, true);
            ExportFileVO fileVO = new ExportFileVO();
            fileVO.setFileName(ResourceUtil.getString((String)NOT_TRIGGER_FILE_NAME));
            this.capExcelManager.saveExcel(fileVO, workbook);
            executeVO.setFailTriggerRecord(fileVO);
            executeVO.setFailTriggerCount(String.valueOf(masterDataList.size()));
        }
    }

    private void getSQLiteMasterAndSubData(FormBean formBean, Connection connection, Map<String, List<String>> allFieldsMap, Map<Integer, String> id2ErrorMap, List<ExportTableLineDataVO> masterDataList, Map<String, ExportSubTableDataVO> subDataMaps, List<?> masterIds) throws SQLException {
        List<Map<String, Object>> masterDatas = this.getSQLiteDataListByIn(connection, masterIds, formBean.getMasterTableBean().getTableName(), Enums.MasterTableField.id.getKey());
        HashMap<String, Object> tempData = new HashMap<String, Object>();
        for (Map<String, Object> map : masterDatas) {
            Integer id = (Integer)map.get(ID);
            ExportTableLineDataVO oneLineDataResult = this.getTableLineDataVO(formBean, map, tempData, allFieldsMap.get(formBean.getMasterTableBean().getTableName()));
            if (id2ErrorMap.get(id) != null) {
                String errorType = id2ErrorMap.get(id);
                if (errorType.startsWith(CAPBusinessEnum.BatchValidateRulesEnum.SYSTEM_RELATION_ERROR.getType() + "_")) {
                    oneLineDataResult.setError(errorType.substring(3));
                } else {
                    oneLineDataResult.setError(CAPBusinessEnum.BatchValidateRulesEnum.getExplainByType(errorType));
                }
            }
            oneLineDataResult.setMasterId(String.valueOf(id));
            masterDataList.add(oneLineDataResult);
        }
        for (Map.Entry entry : allFieldsMap.entrySet()) {
            String tableName = (String)entry.getKey();
            if (tableName.startsWith("formmain")) continue;
            ExportSubTableDataVO tableDataVO = subDataMaps.get(tableName);
            if (tableDataVO == null) {
                tableDataVO = new ExportSubTableDataVO();
                subDataMaps.put(tableName, tableDataVO);
            }
            List<Map<String, Object>> subDatas = this.getSQLiteDataListByIn(connection, masterIds, tableName, Enums.SubTableField.formmain_id.getKey());
            for (Map<String, Object> subDataMap : subDatas) {
                String formMainId = String.valueOf(subDataMap.get(Enums.SubTableField.formmain_id.getKey()));
                ExportTableLineDataVO lineDataVO = this.getTableLineDataVO(formBean, subDataMap, tempData, (List)entry.getValue());
                tableDataVO.getDataSize().put(formMainId, tableDataVO.getDataSize().get(formMainId) == null ? 1 : tableDataVO.getDataSize().get(formMainId) + 1);
                lineDataVO.setMasterId(formMainId);
                List<ExportTableLineDataVO> dataList = tableDataVO.getDataList().get(formMainId);
                if (dataList == null) {
                    dataList = new ArrayList<ExportTableLineDataVO>();
                    tableDataVO.getDataList().put(formMainId, dataList);
                }
                dataList.add(lineDataVO);
            }
        }
    }

    private void updateData(FormBean formBean, List<FormDataMasterBean> formDataMasterBeans, Map<String, Set<Long>> subTable2AddIds) throws SQLException, BusinessException {
        if (formDataMasterBeans.size() == 0) {
            return;
        }
        HashMap updateFormSubDataBeans = new HashMap();
        HashMap<String, ArrayList<FormDataSubBean>> addFormDataSubBean = new HashMap<String, ArrayList<FormDataSubBean>>();
        for (FormDataMasterBean formDataMasterBean : formDataMasterBeans) {
            for (Map.Entry entry : formDataMasterBean.getSubTables().entrySet()) {
                String tableName = (String)entry.getKey();
                Set<Long> addSubIds = subTable2AddIds.get(tableName);
                ArrayList<FormDataSubBean> updateList = new ArrayList<FormDataSubBean>();
                for (FormDataSubBean formDataSubBean : (List)entry.getValue()) {
                    if (addSubIds != null && addSubIds.contains(formDataSubBean.getId())) {
                        ArrayList<FormDataSubBean> formDataSubBeanList = (ArrayList<FormDataSubBean>)addFormDataSubBean.get(tableName);
                        if (formDataSubBeanList == null) {
                            formDataSubBeanList = new ArrayList<FormDataSubBean>();
                            addFormDataSubBean.put(tableName, formDataSubBeanList);
                        }
                        formDataSubBeanList.add(formDataSubBean);
                        continue;
                    }
                    updateList.add(formDataSubBean);
                }
                if (!CollectionUtils.isNotEmpty(updateList)) continue;
                ArrayList formDataSubBeanLists = (ArrayList)updateFormSubDataBeans.get(tableName);
                if (formDataSubBeanLists == null) {
                    formDataSubBeanLists = new ArrayList();
                    updateFormSubDataBeans.put(tableName, formDataSubBeanLists);
                }
                formDataSubBeanLists.addAll(updateList);
            }
        }
        long dbStartTime = System.currentTimeMillis();
        this.cap4FormDataDAO.updateDataBatch(formDataMasterBeans, formBean.getMasterTableBean(), false);
        if (!updateFormSubDataBeans.isEmpty()) {
            for (Map.Entry entry : updateFormSubDataBeans.entrySet()) {
                this.cap4FormDataDAO.updateDataBatch((List)entry.getValue(), formBean.getTableByTableName((String)entry.getKey()), false);
            }
        }
        if (!addFormDataSubBean.isEmpty()) {
            for (Map.Entry entry : addFormDataSubBean.entrySet()) {
                this.cap4FormDataManager.insertData((List)entry.getValue(), true);
            }
        }
        LOGGER.info((Object)("\u5bfc\u5165updateData\u6570\u636e\u5165\u5e93\u65f6\u95f4:" + (System.currentTimeMillis() - dbStartTime) + "ms"));
        int masterIdSize = formDataMasterBeans.size();
        String[] masterIds = new String[masterIdSize];
        for (int i = 0; i < masterIdSize; ++i) {
            masterIds[i] = String.valueOf(formDataMasterBeans.get(i).getId());
        }
        this.capFormDataCacheManager.remove(masterIds);
    }

    private List<CtpContentAll> getFinalInsertContentAll(FormBean formBean, CtpContentAll contentAll, List<FormDataMasterBean> formDataMasterBeans, List<CtpContentAll> ctpContentAlls) {
        if (formDataMasterBeans.size() != ctpContentAlls.size()) {
            HashSet<Long> contentDataSet = new HashSet<Long>();
            for (CtpContentAll c : ctpContentAlls) {
                contentDataSet.add(c.getContentDataId());
            }
            for (FormDataMasterBean formDataMasterBean : formDataMasterBeans) {
                if (!contentDataSet.contains(formDataMasterBean.getId())) continue;
                ctpContentAlls.add(this.buildCtpContentAll(formDataMasterBean.getId(), formBean.getId(), contentAll.getId()));
            }
        }
        return ctpContentAlls;
    }

    private void import4AfterEvent(ImportCalcResultBean calcResultBean, ImportCalcResultBean calcUpdateResultBean) throws BusinessException {
        List<FormSerialCalculateRecord> serialRecordLists = calcResultBean.getSerialRecordLists();
        Set<Object> enumItemIds = calcResultBean.getEnumItemIds();
        enumItemIds.addAll(calcUpdateResultBean.getEnumItemIds());
        serialRecordLists.addAll(calcUpdateResultBean.getSerialRecordLists());
        ArrayList<Long> enumItemLongIds = new ArrayList<Long>();
        for (Object object : enumItemIds) {
            String value = object == null ? "" : String.valueOf(object);
            if (!Strings.isNotBlank((String)value) || "0".equals(value)) continue;
            enumItemLongIds.add(Long.parseLong(value));
        }
        this.enumManagerNew.updateEnumItemRef(enumItemLongIds);
        this.serialCalRecordManager.save(serialRecordLists);
        EventDispatcher.fireEventAfterCommit((Event)new FormDataAfterSubmitEvent(calcResultBean.getFormDataMasterBeans()));
        EventDispatcher.fireEventAfterCommit((Event)new FormDataAfterSubmitEvent(calcUpdateResultBean.getFormDataMasterBeans()));
    }

    private List<ExportTableBean> getExportTableBeans(FormBean formBean, Map<String, List<FormFieldBean>> allFieldBeansMap) {
        ArrayList<ExportTableBean> result = new ArrayList<ExportTableBean>();
        String masterTableName = formBean.getMasterTableBean().getTableName();
        if (allFieldBeansMap.get(masterTableName) != null) {
            ExportTableBean vo = new ExportTableBean(formBean.getMasterTableBean());
            vo.setFieldList(allFieldBeansMap.get(masterTableName));
            result.add(vo);
        }
        for (Map.Entry<String, List<FormFieldBean>> entry : allFieldBeansMap.entrySet()) {
            String tableName = entry.getKey();
            if (!tableName.startsWith("formson")) continue;
            FormTableBean subTableBean = formBean.getTableByTableName(tableName);
            ExportTableBean vo = new ExportTableBean(subTableBean);
            vo.setFieldList(allFieldBeansMap.get(subTableBean.getTableName()));
            result.add(vo);
        }
        return result;
    }

    private void insertData(FormBean formBean, List<FormDataMasterBean> formDataMasterBeans) throws SQLException, BusinessException {
        if (CollectionUtils.isEmpty(formDataMasterBeans)) {
            return;
        }
        long startTime = System.currentTimeMillis();
        HashMap formSubDataMaps = new HashMap();
        for (FormDataMasterBean formDataMasterBean : formDataMasterBeans) {
            Map subDatas = formDataMasterBean.getSubTables();
            for (Map.Entry entry : subDatas.entrySet()) {
                String tableName = (String)entry.getKey();
                ArrayList formDataSubBeans = (ArrayList)formSubDataMaps.get(tableName);
                if (formDataSubBeans == null) {
                    formDataSubBeans = new ArrayList();
                    formSubDataMaps.put(tableName, formDataSubBeans);
                }
                formDataSubBeans.addAll((Collection)entry.getValue());
            }
        }
        long dbStartTime = System.currentTimeMillis();
        LOGGER.info((Object)("\u5bfc\u5165insertData\u5904\u7406\u6570\u636e\u65f6\u95f4:" + (dbStartTime - startTime) + "ms"));
        for (Map.Entry entry : formSubDataMaps.entrySet()) {
            this.cap4FormDataManager.insertData((List)entry.getValue(), false);
        }
        this.cap4FormDataManager.insertData(formDataMasterBeans, false);
        LOGGER.info((Object)("\u5bfc\u5165insertData\u6570\u636e\u5165\u5e93\u65f6\u95f4:" + (System.currentTimeMillis() - dbStartTime) + "ms"));
    }

    private ImportSQLiteIdBean getSQLiteDataIds(String masterTableName, Set<String> inprotTableNames, Connection connection) throws SQLException {
        StringBuilder successSql = new StringBuilder("SELECT id FROM ").append(masterTableName).append(" WHERE ").append(masterTableName).append(".error_flag = '0'");
        StringBuilder errorSql = new StringBuilder("SELECT id FROM ").append(masterTableName).append(" WHERE ").append(masterTableName).append(".error_flag = '1'");
        for (String subTableName : inprotTableNames) {
            if (!CAPSQLiteUtil.isExistTable((Connection)connection, (String)subTableName) || !Strings.isNotBlank((String)masterTableName) || subTableName.startsWith("formmain")) continue;
            successSql.append(" AND ").append(masterTableName);
            successSql.append(".id").append(" NOT IN (SELECT DISTINCT formmain_id FROM ");
            successSql.append(subTableName).append(" WHERE ").append(subTableName).append(".error_flag = '1')");
            errorSql.append(" OR ").append(masterTableName);
            errorSql.append(".id").append(" IN (SELECT DISTINCT formmain_id FROM ");
            errorSql.append(subTableName).append(" WHERE ").append(subTableName).append(".error_flag = '1')");
        }
        List successMasterIds = CAPSQLiteUtil.select((Connection)connection, (String)successSql.toString(), null);
        List errorMasterIds = CAPSQLiteUtil.select((Connection)connection, (String)errorSql.toString(), null);
        ArrayList<Integer> successIds = new ArrayList<Integer>();
        ArrayList<Integer> errorIds = new ArrayList<Integer>();
        for (Map map : successMasterIds) {
            successIds.add((Integer)map.get(ID));
        }
        for (Map map : errorMasterIds) {
            errorIds.add((Integer)map.get(ID));
        }
        ImportSQLiteIdBean sqLiteIdBean = new ImportSQLiteIdBean();
        sqLiteIdBean.setErrorIds(errorIds);
        sqLiteIdBean.setSuccessIds(successIds);
        sqLiteIdBean.setErrorSize(errorIds.size());
        sqLiteIdBean.setSuccessSize(successIds.size());
        return sqLiteIdBean;
    }

    private ImportExecuteResolveFieldBean resolveExecuteFields(FormBean formBean, Map<String, Object> tableFields) {
        ImportExecuteResolveFieldBean resolveFieldBean = new ImportExecuteResolveFieldBean();
        for (Map.Entry<String, Object> tableField : tableFields.entrySet()) {
            String[] fieldArray = String.valueOf(tableField.getValue()).split(",");
            ArrayList<String> fieldNames = new ArrayList<String>(fieldArray.length);
            ArrayList<FormFieldBean> fieldBeanss = new ArrayList<FormFieldBean>(fieldArray.length);
            for (String fieldName : fieldArray) {
                FormFieldBean formFieldBean = formBean.getFieldBeanByName(fieldName);
                if (!this.checkImportSupportField(formFieldBean)) continue;
                fieldNames.add(fieldName);
                fieldBeanss.add(formFieldBean);
                resolveFieldBean.getAllChangedFields().add(fieldName);
                if (formFieldBean.isEnumField()) {
                    resolveFieldBean.getEnumFields().add(formFieldBean);
                }
                if (!formFieldBean.isSn() && !formFieldBean.isFormulaSn()) continue;
                resolveFieldBean.getSerialFields().add(formFieldBean);
            }
            resolveFieldBean.getAllFieldsMap().put(tableField.getKey(), fieldNames);
            resolveFieldBean.getAllFieldBeansMap().put(tableField.getKey(), fieldBeanss);
        }
        return resolveFieldBean;
    }

    private CtpContentAll getCtpContentAll(Long moduleId) throws BusinessException {
        HashMap<String, Number> contentParams = new HashMap<String, Number>();
        contentParams.put("moduleType", ModuleType.cap4UnflowForm.getKey());
        contentParams.put("moduleId", moduleId);
        List contentPoList = this.ctpMainbodyManager.getContentList(contentParams);
        if (CollectionUtils.isEmpty((Collection)contentPoList)) {
            throw new FormDataBusinessException("3002", "the content all is empty!");
        }
        return (CtpContentAll)contentPoList.get(0);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private ImportReadDataBean readExcel2SQLite(FormBean formBean, ImportFormDataParamBean paramBean) throws BusinessException {
        String masterTableName = formBean.getMasterTableBean().getTableName();
        File file = this.fileManager.getFile(paramBean.getFileId());
        ImportReadDataBean readDataBean = this.readFormExcelData(file, formBean, paramBean.getSheetName());
        List<Map<String, Object>> excelDatas = readDataBean.getExcelDatas();
        if (CollectionUtils.isEmpty(excelDatas)) throw new FormDataBusinessException("3003", "excel data is empty");
        if (excelDatas.size() == 1 && excelDatas.get(0).get(masterTableName) == null) {
            throw new FormDataBusinessException("3003", "excel data is empty");
        }
        if (excelDatas.size() == 1 && excelDatas.get(0).size() == 0) {
            throw new FormDataBusinessException("3005", "non excel standard template!");
        }
        Map<String, List<FormFieldBean>> tableFields = readDataBean.getTableFields();
        List<FormFieldBean> masterFields = tableFields.get(masterTableName);
        if (masterFields == null) {
            throw new FormDataBusinessException("3003", "excel data is empty");
        }
        Connection connection = null;
        try {
            readDataBean.setResolvedTableBeanMap(new HashMap<String, ExcelReadResultTableVO>());
            connection = CAPSQLiteUtil.getConnection((String)this.getDbName(masterTableName, paramBean.getType()));
            ArrayList<String> insertMasterDataFields = new ArrayList<String>();
            ExcelReadResultTableVO masterFormInfo = this.createMasterSQLite(formBean, connection, masterFields, insertMasterDataFields);
            readDataBean.getResolvedTableBeanMap().put(masterTableName, masterFormInfo);
            String insertMasterDataSql = CAPSQLiteUtil.getInsertDataSql((String)masterTableName, insertMasterDataFields);
            ArrayList<List<Object>> masterInsertParams = new ArrayList<List<Object>>();
            HashMap<String, String> insertSubDataSqlMap = new HashMap<String, String>();
            HashMap<String, List<List<Object>>> insertSubDataParamsMap = new HashMap<String, List<List<Object>>>();
            for (FormTableBean formTableBean : formBean.getSubTableBean()) {
                List<FormFieldBean> subFields = tableFields.get(formTableBean.getTableName());
                if (subFields == null) continue;
                ExcelReadResultTableVO resultTableBean = this.createSubSQLite(connection, formTableBean, subFields, insertSubDataSqlMap, insertSubDataParamsMap);
                readDataBean.getResolvedTableBeanMap().put(formTableBean.getTableName(), resultTableBean);
            }
            this.setInsertParams(formBean, excelDatas, masterInsertParams, insertSubDataParamsMap);
            CAPSQLiteUtil.updateBatch((Connection)connection, (String)insertMasterDataSql, masterInsertParams);
            for (Map.Entry entry : insertSubDataSqlMap.entrySet()) {
                String key = (String)entry.getKey();
                if (!CollectionUtils.isNotEmpty((Collection)((Collection)insertSubDataParamsMap.get(key)))) continue;
                CAPSQLiteUtil.updateBatch((Connection)connection, (String)((String)entry.getValue()), (List)((List)insertSubDataParamsMap.get(key)));
            }
            masterInsertParams.clear();
            insertSubDataSqlMap.clear();
            insertSubDataParamsMap.clear();
            excelDatas.clear();
        }
        catch (BusinessException e) {
            try {
                this.deleteTable(formBean, connection);
                throw e;
                catch (SQLException e2) {
                    LOGGER.error((Object)("importFormExcelDatas.CAPSQLiteUtil.SQLException " + paramBean), (Throwable)e2);
                    this.deleteTable(formBean, connection);
                    throw new FormDataBusinessException("3002", String.format("%s option exception!", "CAPSQLiteUtil.SQLException"));
                }
            }
            catch (Throwable throwable) {
                CAPSQLiteUtil.closeConnection(connection);
                throw throwable;
            }
        }
        CAPSQLiteUtil.closeConnection((Connection)connection);
        return readDataBean;
    }

    private void setInsertParams(FormBean formBean, List<Map<String, Object>> excelDatas, List<List<Object>> masterInsertParams, Map<String, List<List<Object>>> insertSubDataParamsMap) throws BusinessException {
        String masterTableName = formBean.getMasterTableBean().getTableName();
        int masterSort = 1;
        int j = excelDatas.size();
        for (int i = excelDatas.get(0).get(masterTableName) == null ? 1 : 0; i < j; ++i) {
            Map<String, Object> excelData = excelDatas.get(i);
            Iterator<Map.Entry<String, Object>> excelDataIterator = excelData.entrySet().iterator();
            LinkedHashMap<String, String> currentMasterDataMap = new LinkedHashMap();
            while (excelDataIterator.hasNext()) {
                String tableName = excelDataIterator.next().getKey();
                HashMap<String, ImportFieldVO> cacheCurrentLineData = new HashMap<String, ImportFieldVO>();
                if (masterTableName.equals(tableName)) {
                    String errorFlag = CAPBusinessEnum.TrueOrFalseEnum.FALSE.getKey();
                    Map masterData = (Map)excelDatas.get(i).get(tableName);
                    currentMasterDataMap = masterData;
                    ArrayList<Object> param = new ArrayList<Object>();
                    param.add(masterSort);
                    errorFlag = this.setData2Insert(formBean, masterData, cacheCurrentLineData, param, errorFlag, null);
                    param.add(1, errorFlag);
                    masterInsertParams.add(param);
                    continue;
                }
                List subDatas = (List)excelDatas.get(i).get(tableName);
                for (Map subData : subDatas) {
                    if (this.isEmptyData(subData)) continue;
                    String errorFlag = CAPBusinessEnum.TrueOrFalseEnum.FALSE.getKey();
                    ArrayList<Object> subInsertParam = new ArrayList<Object>();
                    subInsertParam.add(masterSort);
                    String subTableName = formBean.getFieldBeanByName(String.valueOf(subData.keySet().toArray()[0])).getOwnerTableName();
                    errorFlag = this.setData2Insert(formBean, subData, cacheCurrentLineData, subInsertParam, errorFlag, currentMasterDataMap);
                    subInsertParam.add(1, errorFlag);
                    insertSubDataParamsMap.get(subTableName).add(subInsertParam);
                }
            }
            ++masterSort;
        }
    }

    private ExcelReadResultTableVO createSubSQLite(Connection connection, FormTableBean formTableBean, List<FormFieldBean> subFields, Map<String, String> insertSubDataSqlMap, Map<String, List<List<Object>>> insertSubDataParamsMap) throws SQLException {
        ArrayList<String> createSubTableFields = new ArrayList<String>();
        createSubTableFields.add("id integer PRIMARY KEY ON CONFLICT REPLACE autoincrement");
        createSubTableFields.add("formmain_id INTEGER");
        createSubTableFields.add("error_flag VARCHAR(2)");
        ArrayList<String> insertSubDataFields = new ArrayList<String>();
        insertSubDataFields.add("formmain_id");
        insertSubDataFields.add("error_flag");
        for (FormFieldBean subField : subFields) {
            createSubTableFields.add(subField.getName() + VARCHAR);
            insertSubDataFields.add(subField.getName());
        }
        insertSubDataSqlMap.put(formTableBean.getTableName(), CAPSQLiteUtil.getInsertDataSql((String)formTableBean.getTableName(), insertSubDataFields));
        insertSubDataParamsMap.put(formTableBean.getTableName(), new ArrayList());
        CAPSQLiteUtil.createTable((Connection)connection, (String)CAPSQLiteUtil.getCreateTableSql((String)formTableBean.getTableName(), createSubTableFields));
        ExcelReadResultTableVO resultTableBean = new ExcelReadResultTableVO();
        resultTableBean.setTableDisplay(formTableBean.getDisplay());
        resultTableBean.setTableName(formTableBean.getTableName());
        resultTableBean.setFieldInfos(StringUtils.join(this.getFieldNames(subFields), (String)","));
        return resultTableBean;
    }

    private ExcelReadResultTableVO createMasterSQLite(FormBean formBean, Connection connection, List<FormFieldBean> masterFields, List<String> insertMasterDataFields) throws SQLException {
        String masterTableName = formBean.getMasterTableBean().getTableName();
        ExcelReadResultTableVO masterFormInfo = new ExcelReadResultTableVO();
        masterFormInfo.setTableDisplay(ResourceUtil.getString((String)MASTER_TABLE));
        masterFormInfo.setTableName(masterTableName);
        boolean doTrigger = CollectionUtils.isNotEmpty((Collection)formBean.getFormTriggerIdList());
        masterFormInfo.setIsDoTrigger(CAPBusinessEnum.TrueOrFalseEnum.getKey(doTrigger));
        ArrayList<String> createMasterTableFields = new ArrayList<String>();
        createMasterTableFields.add("id INTEGER PRIMARY KEY ON CONFLICT REPLACE");
        createMasterTableFields.add("error_flag VARCHAR(2)");
        insertMasterDataFields.add(ID);
        insertMasterDataFields.add("error_flag");
        for (FormFieldBean masterField : masterFields) {
            createMasterTableFields.add(masterField.getName() + VARCHAR);
            insertMasterDataFields.add(masterField.getName());
        }
        masterFormInfo.setFieldInfos(StringUtils.join(this.getFieldNames(masterFields), (String)","));
        if (CAPSQLiteUtil.isExistTable((Connection)connection, (String)masterTableName)) {
            this.deleteTable(formBean, connection);
        }
        CAPSQLiteUtil.createTable((Connection)connection, (String)CAPSQLiteUtil.getCreateTableSql((String)masterTableName, createMasterTableFields));
        return masterFormInfo;
    }

    private ImportReadDataVO readDataFromSQLite(FormBean formBean, ImportFormDataParamBean paramBean, ImportReadDataBean readDataBean) throws BusinessException {
        String masterTableName = formBean.getMasterTableBean().getTableName();
        List<String> masterFieldNames = null;
        ArrayList<String> allFieldNames = new ArrayList<String>();
        HashSet<String> subTableNames = new HashSet<String>();
        for (Map.Entry<String, List<FormFieldBean>> entry : readDataBean.getTableFields().entrySet()) {
            String key = entry.getKey();
            List<String> fieldNames = this.getFieldNames((Collection<FormFieldBean>)entry.getValue());
            if (key.equals(masterTableName)) {
                masterFieldNames = fieldNames;
            } else {
                subTableNames.add(key);
            }
            allFieldNames.addAll(fieldNames);
        }
        ExcelReadParamBean readBean = new ExcelReadParamBean();
        readBean.setTableName(masterTableName);
        readBean.setFormId(formBean.getId());
        readBean.setType(paramBean.getType());
        readBean.setInit(1);
        readBean.setFieldInfos(StringUtils.join(masterFieldNames, (String)","));
        ExcelReadResultBean readResultBean = this.capImportCacheDataManager.read(readBean);
        for (ExcelReadResultTableVO resultTableBean : readResultBean.getResultTableBeans()) {
            ExcelReadResultTableVO resolvedBean = readDataBean.getResolvedTableBeanMap().get(resultTableBean.getTableName());
            if (resolvedBean == null) continue;
            resultTableBean.merge(resolvedBean);
        }
        ImportReadDataVO readDataVO = new ImportReadDataVO(readResultBean);
        List<ImportUniqueBean> uniqueMarks = this.getUniqueBeans(formBean, StringUtils.join(allFieldNames, (String)","));
        if (CollectionUtils.isNotEmpty(uniqueMarks)) {
            ArrayList<ImportUniqueFieldVO> uniqueVOS = new ArrayList<ImportUniqueFieldVO>();
            for (ImportUniqueBean uniqueBean : uniqueMarks) {
                if (uniqueBean.isHasMasterField() && !uniqueBean.isHasSubField()) {
                    uniqueBean.setSubTableName(StringUtils.join(subTableNames, (String)","));
                }
                uniqueVOS.add(new ImportUniqueFieldVO(uniqueBean));
            }
            readDataVO.setUniqueMarks(uniqueVOS);
        }
        return readDataVO;
    }

    private boolean isEmptyData(Map<String, String> map) {
        boolean isAllNull = true;
        for (String value : map.values()) {
            if (!Strings.isNotBlank((String)value)) continue;
            isAllNull = false;
            break;
        }
        return isAllNull;
    }

    private boolean isExportTemplate(FormBean formBean, List<String> secondData) {
        boolean isExportTemplate = true;
        for (String fieldDisplay : secondData) {
            FormFieldBean formFieldBean = formBean.getFieldBeanByDisplay(fieldDisplay);
            if (formFieldBean == null) continue;
            isExportTemplate = false;
            break;
        }
        return isExportTemplate;
    }

    private void addTableFieldListMap(ImportReadDataBean importReadDataBean, FormFieldBean formFieldBean) {
        List<FormFieldBean> fieldBeanList = importReadDataBean.getTableFields().get(formFieldBean.getOwnerTableName());
        if (fieldBeanList == null) {
            fieldBeanList = new ArrayList<FormFieldBean>();
            importReadDataBean.getTableFields().put(formFieldBean.getOwnerTableName(), fieldBeanList);
        }
        fieldBeanList.add(formFieldBean);
    }

    private ImportReadDataBean readFormExcelData(File file, FormBean formBean, String sheetName) throws BusinessException {
        List lists = null;
        try {
            long s = System.currentTimeMillis();
            lists = this.fileToExcelManager.readExcelBySheets(file, sheetName);
            LOGGER.info((Object)("\u65e0\u6d41\u7a0b\u5217\u8868\u5bfc\u5165\u89e3\u6790excel\u65f6\u95f4:" + (System.currentTimeMillis() - s) + "ms"));
        }
        catch (Exception e) {
            LOGGER.error((Object)e);
        }
        if (lists == null) {
            throw new FormDataBusinessException("3003", "excel data is empty");
        }
        ImportReadDataBean importReadDataBean = new ImportReadDataBean();
        if (lists.size() < 2) {
            return importReadDataBean;
        }
        HashMap<Integer, FormFieldBean> indexFieldMap = new HashMap<Integer, FormFieldBean>();
        HashMap<String, Integer> fieldNameIndexMap = new HashMap<String, Integer>();
        importReadDataBean.setTableFields(new HashMap<String, List<FormFieldBean>>());
        int start = this.resolveReadExcelFields(formBean, lists, importReadDataBean, indexFieldMap, fieldNameIndexMap);
        this.removeInvalidField(formBean, importReadDataBean, indexFieldMap, fieldNameIndexMap);
        importReadDataBean.setExcelDatas(this.getExcelDatas(start, lists, indexFieldMap));
        return importReadDataBean;
    }

    private Integer resolveReadExcelFields(FormBean formBean, List<List<String>> lists, ImportReadDataBean importReadDataBean, Map<Integer, FormFieldBean> indexFieldMap, Map<String, Integer> fieldNameIndexMap) throws BusinessException {
        List<String> secondData = lists.get(1);
        boolean isHasSubTable = false;
        boolean isExportTemplate = this.isExportTemplate(formBean, secondData);
        HashMap<Object, Object> tempFieldDisplay = new HashMap<Object, Object>();
        HashSet<String> subTableBeanDisplays = new HashSet<String>();
        for (FormTableBean formTableBean : formBean.getSubTableBean()) {
            subTableBeanDisplays.add(formTableBean.getDisplay());
        }
        List<String> fieldData = isExportTemplate && lists.size() >= 3 ? lists.get(2) : lists.get(1);
        Integer i = 0;
        while (i < fieldData.size()) {
            Object formFieldBean;
            Object fieldDisplay = fieldData.get(i);
            if (!Strings.isBlank((String)fieldDisplay)) {
                if (subTableBeanDisplays.contains(fieldDisplay) && !isHasSubTable) {
                    isHasSubTable = true;
                }
                if (this.checkImportSupportField((FormFieldBean)(formFieldBean = formBean.getFieldBeanByDisplay((String)fieldDisplay))) && !formFieldBean.isSubField() && tempFieldDisplay.get(fieldDisplay) == null) {
                    this.addTableFieldListMap(importReadDataBean, (FormFieldBean)formFieldBean);
                    indexFieldMap.put(i, (FormFieldBean)formFieldBean);
                    fieldNameIndexMap.put(formFieldBean.getName(), i);
                    tempFieldDisplay.put(fieldDisplay, fieldDisplay);
                }
            }
            fieldDisplay = i;
            i = i + 1;
            formFieldBean = i;
        }
        if (isHasSubTable) {
            List<String> subFieldData = isExportTemplate && lists.size() >= 4 ? lists.get(3) : lists.get(2);
            for (int i2 = 0; i2 < subFieldData.size(); ++i2) {
                FormFieldBean formFieldBean;
                String fieldDisplay = subFieldData.get(i2);
                if (Strings.isBlank((String)fieldDisplay) || !this.checkImportSupportField(formFieldBean = formBean.getFieldBeanByDisplay(fieldDisplay)) || tempFieldDisplay.get(fieldDisplay) != null) continue;
                this.addTableFieldListMap(importReadDataBean, formFieldBean);
                indexFieldMap.put(i2, formFieldBean);
                fieldNameIndexMap.put(formFieldBean.getName(), i2);
                tempFieldDisplay.put(fieldDisplay, fieldDisplay);
            }
        }
        Integer start = 2;
        if (isHasSubTable && isExportTemplate) {
            start = 4;
        } else if (isHasSubTable && !isExportTemplate || !isHasSubTable && isExportTemplate) {
            start = 3;
        }
        if (lists.size() - start > 10000) {
            throw new FormDataBusinessException("3004", String.format("more than %s lines!", 10000));
        }
        return start;
    }

    private List<Map<String, Object>> getExcelDatas(int start, List<List<String>> lists, Map<Integer, FormFieldBean> indexFieldMap) {
        ArrayList<Map<String, Object>> excelDatas = new ArrayList<Map<String, Object>>();
        HashMap<Integer, Map<String, LinkedHashMap<String, String>>> indexMasterDataMap = new HashMap<Integer, Map<String, LinkedHashMap<String, String>>>();
        Integer i = start;
        while (i < lists.size()) {
            Map<String, LinkedHashMap<String, String>> excelData;
            List<String> list = lists.get(i);
            boolean isAllMasterDataBlank = true;
            boolean isAllSubDataBlank = true;
            Set<Integer> fieldIndexSet = indexFieldMap.keySet();
            ArrayList<Integer> fieldIndexList = new ArrayList<Integer>(fieldIndexSet);
            Integer j = 0;
            while (j < fieldIndexList.size()) {
                FormFieldBean formFieldBean;
                Object value = "";
                Integer fieldIndex = (Integer)fieldIndexList.get(j);
                if (fieldIndex < list.size()) {
                    value = this.trim(list.get(fieldIndex));
                }
                if ((formFieldBean = indexFieldMap.get(fieldIndex)) != null) {
                    if (formFieldBean.isMasterField() && Strings.isNotBlank((String)value)) {
                        isAllMasterDataBlank = false;
                    } else if (formFieldBean.isSubField() && Strings.isNotBlank((String)value)) {
                        isAllSubDataBlank = false;
                    }
                }
                value = j;
                j = j + 1;
                Integer n = j;
            }
            if (!isAllMasterDataBlank || i.equals(start)) {
                excelData = new LinkedHashMap();
                excelDatas.add(excelData);
            } else {
                excelData = (Map)indexMasterDataMap.get(i - 1);
            }
            LinkedHashMap<String, String> subData = null;
            indexMasterDataMap.put(i, excelData);
            String frontFormSonTableName = "";
            for (Integer fieldIndex : fieldIndexList) {
                FormFieldBean formFieldBean;
                String value = "";
                if (fieldIndex < list.size()) {
                    value = this.trim(list.get(fieldIndex));
                }
                if ((formFieldBean = indexFieldMap.get(fieldIndex)) == null) continue;
                if (formFieldBean.isMasterField() && !isAllMasterDataBlank) {
                    LinkedHashMap<String, String> oneLineMasterData = (LinkedHashMap<String, String>)excelData.get(formFieldBean.getOwnerTableName());
                    if (oneLineMasterData == null) {
                        oneLineMasterData = new LinkedHashMap<String, String>();
                        excelData.put(formFieldBean.getOwnerTableName(), oneLineMasterData);
                    }
                    oneLineMasterData.put(formFieldBean.getName(), value);
                    continue;
                }
                if (!formFieldBean.isSubField() || isAllSubDataBlank) continue;
                ArrayList subDatas = (ArrayList)excelData.get(formFieldBean.getOwnerTableName());
                if (subDatas == null) {
                    subDatas = new ArrayList();
                    excelData.put(formFieldBean.getOwnerTableName(), (LinkedHashMap<String, String>)((Object)subDatas));
                }
                if (!frontFormSonTableName.equals(formFieldBean.getOwnerTableName())) {
                    subData = new LinkedHashMap<String, String>();
                    subDatas.add(subData);
                    frontFormSonTableName = formFieldBean.getOwnerTableName();
                }
                if (null == subData) continue;
                subData.put(formFieldBean.getName(), value);
            }
            Integer n = i;
            Integer n2 = i = Integer.valueOf(i + 1);
        }
        return excelDatas;
    }

    private void removeInvalidField(FormBean formBean, ImportReadDataBean importReadDataBean, Map<Integer, FormFieldBean> indexFieldMap, Map<String, Integer> fieldNameIndexMap) {
        List<Set<String>> enumFieldTeams = this.getEnumFieldTeams(formBean);
        this.deleteErrorEnumField(null, enumFieldTeams, indexFieldMap, fieldNameIndexMap, null);
        for (Map.Entry<String, List<FormFieldBean>> entry : importReadDataBean.getTableFields().entrySet()) {
            Iterator<FormFieldBean> iterator = entry.getValue().iterator();
            while (iterator.hasNext()) {
                FormFieldBean formFieldBean = iterator.next();
                if (fieldNameIndexMap.get(formFieldBean.getName()) != null) continue;
                iterator.remove();
            }
        }
    }

    public void setCtpMainbodyManager(MainbodyManager ctpMainbodyManager) {
        this.ctpMainbodyManager = ctpMainbodyManager;
    }

    public void setSerialCalRecordManager(SerialCalRecordManager serialCalRecordManager) {
        this.serialCalRecordManager = serialCalRecordManager;
    }

    public void setCap4FormDataManager(CAP4FormDataManager cap4FormDataManager) {
        this.cap4FormDataManager = cap4FormDataManager;
    }

    public void setCapImportCalcManager4FormData(CAPImportCalcManager4FormData capImportCalcManager4FormData) {
        this.capImportCalcManager4FormData = capImportCalcManager4FormData;
    }

    public void setCapFormDataCacheManager(CAPFormDataCacheManager capFormDataCacheManager) {
        this.capFormDataCacheManager = capFormDataCacheManager;
    }

    public void setCap4FormTriggerManager(CAP4FormTriggerManager cap4FormTriggerManager) {
        this.cap4FormTriggerManager = cap4FormTriggerManager;
    }

    public void setTaskExecuteManager(TaskExecuteManager taskExecuteManager) {
        this.taskExecuteManager = taskExecuteManager;
    }

    public void setCapImportCacheDataManager(CAPImportCacheDataManager capImportCacheDataManager) {
        this.capImportCacheDataManager = capImportCacheDataManager;
    }

    public void setCap4FormDataDAO(CAP4FormDataDAO cap4FormDataDAO) {
        this.cap4FormDataDAO = cap4FormDataDAO;
    }
}

