/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.cap4.template.manager.impl;

import com.seeyon.cap4.form.bean.FormAuthViewBean;
import com.seeyon.cap4.form.bean.FormAuthViewFieldBean;
import com.seeyon.cap4.form.bean.FormBean;
import com.seeyon.cap4.form.bean.FormDataBean;
import com.seeyon.cap4.form.bean.FormDataMasterBean;
import com.seeyon.cap4.form.bean.FormDataSubBean;
import com.seeyon.cap4.form.bean.FormFieldBean;
import com.seeyon.cap4.form.bean.FormFieldComEnum;
import com.seeyon.cap4.form.bean.FormRelationshipBean;
import com.seeyon.cap4.form.bean.FormRelationshipMapBean;
import com.seeyon.cap4.form.bean.FormTableBean;
import com.seeyon.cap4.form.bean.FormViewBean;
import com.seeyon.cap4.form.modules.engin.base.formData.CAP4FormDataManager;
import com.seeyon.cap4.form.modules.engin.relation.FormRelationEnums;
import com.seeyon.cap4.form.util.Enums;
import com.seeyon.cap4.form.util.sqlite.CAPSQLiteUtil;
import com.seeyon.cap4.template.annotation.JMCalling4Service;
import com.seeyon.cap4.template.annotation.ParamClass;
import com.seeyon.cap4.template.bean.AutoRelationTipBean;
import com.seeyon.cap4.template.bean.ExcelReadParamBean;
import com.seeyon.cap4.template.bean.ExportTableBean;
import com.seeyon.cap4.template.bean.ImportFormSubDataParamBean;
import com.seeyon.cap4.template.bean.ImportPromptBean;
import com.seeyon.cap4.template.bean.ImportSubDataBean;
import com.seeyon.cap4.template.constant.CAPBusinessEnum;
import com.seeyon.cap4.template.exception.FormDataBusinessException;
import com.seeyon.cap4.template.manager.CAPImportCacheDataManager;
import com.seeyon.cap4.template.manager.CAPImportManager;
import com.seeyon.cap4.template.manager.CAPRuntimeCalcManager;
import com.seeyon.cap4.template.manager.CAPTransFormDataBeanManager;
import com.seeyon.cap4.template.manager.impl.AbstractCAPImportManager;
import com.seeyon.cap4.template.util.CAPFormUtil;
import com.seeyon.cap4.template.vo.AImportDataVO;
import com.seeyon.cap4.template.vo.ExportFileVO;
import com.seeyon.cap4.template.vo.ExportTableLineDataVO;
import com.seeyon.cap4.template.vo.ImportFieldVO;
import com.seeyon.cap4.template.vo.ImportReadSubDataVO;
import com.seeyon.cap4.template.vo.ImportSubDataExecuteVO;
import com.seeyon.ctp.common.AppContext;
import com.seeyon.ctp.common.exceptions.BusinessException;
import com.seeyon.ctp.common.i18n.ResourceUtil;
import com.seeyon.ctp.common.log.CtpLogFactory;
import com.seeyon.ctp.common.po.ctpenumnew.CtpEnumItem;
import com.seeyon.ctp.util.Strings;
import com.seeyon.ctp.util.UUIDLong;
import com.seeyon.ctp.util.json.JSONUtil;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.poi.ss.usermodel.Workbook;

@ParamClass(clazz=ImportFormSubDataParamBean.class)
public class CAPImportManager4FormSubData
extends AbstractCAPImportManager
implements CAPImportManager<ImportFormSubDataParamBean, AImportDataVO> {
    private static final Log LOGGER = CtpLogFactory.getLog(CAPImportManager4FormSubData.class);
    private static final String VARCHAR = " VARCHAR(4000)";
    private static final String CHINESE_DELIMITER = "\u3001";
    private static final String UUID = "uuid";
    private static final int SUB_TOTAL_LINE = 1000;
    private static final String NOT_AUTH_FIELD_INFO = "cap.form.batchOperation.notNuthFieldInfo";
    private static final String RELATION_ENUM_FIELD_INFO = "cap.form.batchOperation.relationEnumFieldInfo";
    private static final String NOT_SUPPORT_FIELD_INFO = "cap.form.batchOperation.notSupportFieldInfo";
    private static final String AUTE_BACKFILL_FIELD_INFO = "cap.form.batchOperation.auteBackfillFieldInfo";
    private static final String ERROR_FILE_NAME = "cap.form.batchOperation.errorFileName";
    private CAP4FormDataManager cap4FormDataManager;
    private CAPRuntimeCalcManager capRuntimeCalcManager;
    private CAPTransFormDataBeanManager capTransFormDataBeanManager;
    private CAPImportCacheDataManager capImportCacheDataManager;

    @Override
    public String getType() {
        return CAPBusinessEnum.BatchOperationEnum.BATCH_SUB_IMPORT.getKey();
    }

    @Override
    @JMCalling4Service(batchRunType=CAPBusinessEnum.BatchOperationEnum.BATCH_SUB_IMPORT)
    public AImportDataVO readData(ImportFormSubDataParamBean bean) throws BusinessException {
        return this.readExcelData(bean);
    }

    @Override
    @JMCalling4Service(batchRunType=CAPBusinessEnum.BatchOperationEnum.BATCH_SUB_IMPORT)
    public AImportDataVO execute(ImportFormSubDataParamBean paramBean) throws BusinessException {
        return this.executeImportExcelDatas(paramBean);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private AImportDataVO executeImportExcelDatas(ImportFormSubDataParamBean paramBean) throws BusinessException {
        ImportSubDataExecuteVO dataExecuteVO = new ImportSubDataExecuteVO();
        Connection connection = null;
        FormBean formBean = this.cap4FormCacheManager.getForm(paramBean.getFormId());
        FormDataMasterBean cacheFormDataMasterBean = this.cap4FormManager.getSessioMasterDataBean(paramBean.getFormMasterId());
        String tableName = paramBean.getTableName();
        FormTableBean formTableBean = formBean.getTableByTableName(tableName);
        String jsonData = cacheFormDataMasterBean.getAllDataJSONString();
        Map dataMap = (Map)JSONUtil.parseJSONString((String)jsonData, Map.class);
        FormDataMasterBean cloneFormDataMasterBean = this.capTransFormDataBeanManager.transFormDataBeanFromMap(dataMap);
        FormAuthViewBean formAuthViewBean = CAPFormUtil.getFormAuthViewBean(formBean, cacheFormDataMasterBean, paramBean.getRightId());
        FormViewBean formViewBean = formBean.getFormView(formAuthViewBean.getFormViewId());
        Map<String, FormFieldBean> viewFieldBeans = this.getTableFieldBeans(formBean, formViewBean, paramBean.getTableName());
        String masterTableName = formBean.getMasterTableBean().getTableName();
        try {
            connection = CAPSQLiteUtil.getConnection((String)this.getDbName(masterTableName, paramBean.getType()));
            String selectDataSql = "SELECT * FROM " + tableName;
            List sqliteDatas = CAPSQLiteUtil.select((Connection)connection, (String)selectDataSql, null);
            String[] fieldArray = String.valueOf(paramBean.getTableFields().get(tableName)).split(",");
            ArrayList<String> fieldNameList = new ArrayList<String>();
            ArrayList<FormFieldBean> fieldList = new ArrayList<FormFieldBean>();
            for (String fieldName : fieldArray) {
                if (!this.checkImportSupportSubField(formTableBean.getFieldBeanByName(fieldName)) || viewFieldBeans.get(fieldName) == null) continue;
                fieldList.add(formTableBean.getFieldBeanByName(fieldName));
                fieldNameList.add(fieldName);
            }
            if (paramBean.getFirstRecordId() != null) {
                FormDataSubBean formDataSubBean = cacheFormDataMasterBean.getFormDataSubBeanById(tableName, paramBean.getFirstRecordId());
                dataExecuteVO.setFirstIsNull(CAPBusinessEnum.TrueOrFalseEnum.getKey(formDataSubBean == null || formDataSubBean.isEmpty()));
            }
            ImportSubDataBean importSubDataBean = this.initData(formBean, formAuthViewBean, fieldNameList, cloneFormDataMasterBean, paramBean, sqliteDatas, null);
            int successImportCount = importSubDataBean.getSuccessImportCount();
            int failImportCount = importSubDataBean.getFailImportCount();
            HashMap<String, Map<String, Object>> tableName2DataMaps = new HashMap<String, Map<String, Object>>();
            if (successImportCount > 0) {
                HashMap<String, List<Long>> tableName2AddSubIds = new HashMap<String, List<Long>>();
                tableName2AddSubIds.put(tableName, importSubDataBean.getImportSubIds());
                if (paramBean.getPreRecordId() == null) {
                    this.capRuntimeCalcManager.mergeFirstDelete2Result(cloneFormDataMasterBean, tableName2DataMaps, tableName2AddSubIds, null, null);
                }
                AppContext.removeThreadContext((String)"autoRelationTips");
                this.capRuntimeCalcManager.execCalcAll(formBean, cloneFormDataMasterBean, formAuthViewBean, tableName2AddSubIds);
                AutoRelationTipBean autoRelationTips = (AutoRelationTipBean)AppContext.getThreadContext((String)"autoRelationTips");
                Map<Long, Set<String>> subId2Tips = autoRelationTips != null ? autoRelationTips.getRecord2Tips() : null;
                boolean reInitData = true;
                if (subId2Tips != null) {
                    dataExecuteVO.setFirstIsNull(CAPBusinessEnum.TrueOrFalseEnum.FALSE.getKey());
                    tableName2DataMaps.clear();
                    int importTips = 0;
                    for (Long id : importSubDataBean.getImportSubIds()) {
                        if (!subId2Tips.containsKey(id)) continue;
                        ++importTips;
                    }
                    boolean bl = reInitData = importTips != importSubDataBean.getSuccessImportCount();
                    if (!reInitData && importTips > 0) {
                        for (int i = 0; i < sqliteDatas.size(); ++i) {
                            Long thisSubId;
                            Map sqliteOneLineData = (Map)sqliteDatas.get(i);
                            Long l = thisSubId = sqliteOneLineData.get(UUID) != null ? Long.valueOf(Long.parseLong(String.valueOf(sqliteOneLineData.get(UUID)))) : null;
                            if (thisSubId == null || subId2Tips.get(thisSubId) == null || importSubDataBean.getErrorLineMap().get(String.valueOf(i)) != null) continue;
                            ExportTableLineDataVO lineDataVO = this.getSystemRelationErrorMap(sqliteOneLineData, fieldNameList, StringUtils.join((Iterable)subId2Tips.get(thisSubId), (String)""));
                            lineDataVO.setFlag(false);
                            lineDataVO.setMasterId(String.valueOf(i));
                            importSubDataBean.getErrorLineMap().put(String.valueOf(i), lineDataVO);
                            importSubDataBean.setFailImportCount(importSubDataBean.getFailImportCount() + 1);
                            importSubDataBean.setSuccessImportCount(importSubDataBean.getSuccessImportCount() - 1);
                        }
                    }
                }
                if (reInitData && sqliteDatas.size() != importSubDataBean.getFailImportCount()) {
                    importSubDataBean = this.initData(formBean, formAuthViewBean, fieldNameList, cacheFormDataMasterBean, paramBean, sqliteDatas, subId2Tips);
                    successImportCount = importSubDataBean.getSuccessImportCount();
                    failImportCount = importSubDataBean.getFailImportCount();
                    tableName2DataMaps.clear();
                    tableName2AddSubIds.clear();
                    tableName2AddSubIds.put(tableName, importSubDataBean.getImportSubIds());
                    if (paramBean.getPreRecordId() == null) {
                        this.capRuntimeCalcManager.mergeFirstDelete2Result(cacheFormDataMasterBean, tableName2DataMaps, tableName2AddSubIds, null, null);
                    }
                    Set<String> fillBackFields = this.capRuntimeCalcManager.execCalcAll(formBean, cacheFormDataMasterBean, formAuthViewBean, tableName2AddSubIds);
                    this.capRuntimeCalcManager.buildCalcAllResult(formBean, cacheFormDataMasterBean, formAuthViewBean, tableName2AddSubIds, fillBackFields, CAPBusinessEnum.SubBeanNewFrom.IMPORT, tableName2DataMaps);
                }
            }
            dataExecuteVO.setTableData(tableName2DataMaps);
            ArrayList<ExportTableLineDataVO> subDataMaps = new ArrayList<ExportTableLineDataVO>();
            if (failImportCount > 0) {
                for (int i = 0; i < sqliteDatas.size(); ++i) {
                    ExportTableLineDataVO lineDataVO = importSubDataBean.getErrorLineMap().get(String.valueOf(i));
                    if (lineDataVO == null || lineDataVO.isFlag()) continue;
                    lineDataVO.setMasterId(String.valueOf(i));
                    subDataMaps.add(lineDataVO);
                }
                this.exportErrorRecordFile(formBean, dataExecuteVO, fieldList, formTableBean, subDataMaps);
            }
            dataExecuteVO.setSuccessImportCount("" + successImportCount);
            dataExecuteVO.setFormName(formTableBean.getDisplay());
            dataExecuteVO.setFailImportCount("" + failImportCount);
            this.cap4FormManager.saveSessioMasterDataBean(cacheFormDataMasterBean.getId(), cacheFormDataMasterBean);
        }
        catch (SQLException e) {
            try {
                LOGGER.error((Object)"transImportSubTableExcelDatas.SQLException", (Throwable)e);
                throw new FormDataBusinessException("3002", String.format("%s option exception!", "transImportSubTableExcelDatas.SQLException"));
                catch (BusinessException e2) {
                    LOGGER.error((Object)"transImportSubTableExcelDatas.BusinessException", (Throwable)e2);
                    throw e2;
                }
            }
            catch (Throwable throwable) {
                CAPSQLiteUtil.closeConnection(connection);
                this.deleteSqliteDbFile(paramBean.getFormId(), paramBean.getType());
                throw throwable;
            }
        }
        CAPSQLiteUtil.closeConnection((Connection)connection);
        this.deleteSqliteDbFile(paramBean.getFormId(), paramBean.getType());
        return dataExecuteVO;
    }

    private ExportTableLineDataVO getSystemRelationErrorMap(Map<String, Object> sqliteOneLineData, List<String> fieldNameList, String systemRelationInfo) {
        ArrayList<Object> dataList = new ArrayList<Object>();
        for (String fieldName : fieldNameList) {
            Object valueObject = sqliteOneLineData.get(fieldName);
            if (valueObject == null) continue;
            ImportFieldVO field = (ImportFieldVO)JSONUtil.parseJSONString((String)String.valueOf(valueObject), ImportFieldVO.class);
            dataList.add(field.getShowValue());
        }
        ExportTableLineDataVO lineDataVO = new ExportTableLineDataVO(dataList, "", systemRelationInfo);
        lineDataVO.setFlag(false);
        return lineDataVO;
    }

    private void exportErrorRecordFile(FormBean formBean, ImportSubDataExecuteVO dataExecuteVO, List<FormFieldBean> fieldList, FormTableBean formTableBean, List<ExportTableLineDataVO> lineDataVOS) throws BusinessException {
        ExportTableBean tableVO = new ExportTableBean(formTableBean);
        tableVO.setFieldList(fieldList);
        Workbook workbook = this.capExcelManager.exportExcelFile(formTableBean.getDisplay(), formBean, tableVO, fieldList.size(), lineDataVOS, true);
        ExportFileVO fileVO = new ExportFileVO();
        fileVO.setFileName(ResourceUtil.getString((String)ERROR_FILE_NAME));
        this.capExcelManager.saveExcel(fileVO, workbook);
        dataExecuteVO.setFailRecord(fileVO);
    }

    private ImportSubDataBean initData(FormBean formBean, FormAuthViewBean formAuthViewBean, List<String> fieldNameList, FormDataMasterBean formDataMasterBean, ImportFormSubDataParamBean paramBean, List<Map<String, Object>> sqliteDatas, Map<Long, Set<String>> subId2Tips) throws BusinessException {
        HashMap<Integer, Long> subIdSort = new HashMap<Integer, Long>(sqliteDatas.size());
        ArrayList<Long> importSubIds = new ArrayList<Long>();
        HashMap<String, ExportTableLineDataVO> errorLineMap = new HashMap<String, ExportTableLineDataVO>();
        int successImportCount = 0;
        int failImportCount = 0;
        String tableName = paramBean.getTableName();
        Long preRecordId = paramBean.getPreRecordId();
        FormTableBean formTableBean = formBean.getTableByTableName(tableName);
        for (int i = 0; i < sqliteDatas.size(); ++i) {
            HashMap<String, Object> dbData;
            Map<String, Object> sqliteOneLineData = sqliteDatas.get(i);
            ExportTableLineDataVO lineDataVO = this.getTableLineDataVO(formBean, sqliteOneLineData, dbData = new HashMap<String, Object>(fieldNameList.size()), fieldNameList);
            if (lineDataVO.isFlag()) {
                Long thisSubId;
                Long l = thisSubId = sqliteOneLineData.get(UUID) != null ? Long.valueOf(Long.parseLong(String.valueOf(sqliteOneLineData.get(UUID)))) : null;
                if (thisSubId != null && subId2Tips != null && subId2Tips.get(thisSubId) != null) {
                    lineDataVO.setFlag(false);
                    lineDataVO.setError(StringUtils.join((Iterable)subId2Tips.get(thisSubId), (String)""));
                    errorLineMap.put(String.valueOf(i), lineDataVO);
                    ++failImportCount;
                    continue;
                }
                FormDataSubBean formDataSubBean = new FormDataSubBean(formTableBean, formDataMasterBean, new boolean[]{true});
                if (thisSubId != null) {
                    formDataSubBean.setId(thisSubId);
                }
                if (preRecordId != null) {
                    formDataMasterBean.addSubData(tableName, formDataSubBean, preRecordId);
                } else {
                    formDataMasterBean.addSubData(tableName, formDataSubBean);
                }
                preRecordId = formDataSubBean.getId();
                for (FormFieldBean formFieldBean : formTableBean.getFields()) {
                    this.cap4FormDataManager.procFieldDefaultVal((FormDataBean)formDataSubBean, formAuthViewBean, false, formFieldBean);
                    Object value = dbData.get(formFieldBean.getName());
                    if (value == null) continue;
                    formDataSubBean.addFieldValue(formFieldBean.getName(), value);
                    formDataMasterBean.addFieldChanges4Calc(formFieldBean, value, formDataSubBean);
                }
                importSubIds.add(formDataSubBean.getId());
                ++successImportCount;
                subIdSort.put(i, formDataSubBean.getId());
                continue;
            }
            errorLineMap.put(String.valueOf(i), lineDataVO);
            ++failImportCount;
        }
        ImportSubDataBean dataBean = new ImportSubDataBean();
        dataBean.setSubIdSort(subIdSort);
        dataBean.setImportSubIds(importSubIds);
        dataBean.setErrorLineMap(errorLineMap);
        dataBean.setFailImportCount(failImportCount);
        dataBean.setSuccessImportCount(successImportCount);
        return dataBean;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private ImportReadSubDataVO readExcelData(ImportFormSubDataParamBean paramBean) throws BusinessException {
        connection = null;
        formBean = null;
        importReadSubDataVO = new ImportReadSubDataVO();
        try {
            formBean = this.cap4FormCacheManager.getForm(paramBean.getFormId());
            file = this.fileManager.getFile(paramBean.getFileId());
            lists = this.fileToExcelManager.readExcelBySheets(file, paramBean.getSheetName());
            if (lists == null) throw new FormDataBusinessException("3003", "excel data is empty");
            if (lists.size() <= 2) {
                throw new FormDataBusinessException("3003", "excel data is empty");
            }
            formSubTableBean = formBean.getTableByTableName(paramBean.getTableName());
            isExportTemplate = true;
            secondData = (List)lists.get(1);
            for (String fieldDisplay : secondData) {
                formFieldBean = formSubTableBean.getFieldBeanByDisplay(fieldDisplay);
                if (formFieldBean == null) continue;
                isExportTemplate = false;
                break;
            }
            relationFieldMap = this.getSysRelationMappingField(formBean);
            formDataMasterBean = this.cap4FormManager.getSessioMasterDataBean(paramBean.getFormMasterId());
            formAuthViewBean = CAPFormUtil.getFormAuthViewBean(formBean, formDataMasterBean, paramBean.getRightId());
            formViewBean = formBean.getFormView(formAuthViewBean.getFormViewId());
            fieldBeanMap = this.getTableFieldBeans(formBean, formViewBean, paramBean.getTableName());
            enumFieldTeams = this.getEnumFieldTeams(formBean);
            apartAuthMap = formDataMasterBean.getExtraAttr("apartAuthMap") == null ? new HashMap<K, V>() : (Map)formDataMasterBean.getExtraAttr("apartAuthMap");
            fieldData = isExportTemplate != false && lists.size() >= 3 ? (List)lists.get(2) : (List)lists.get(1);
            tempFieldDisplay = new HashMap<Object, Object>();
            subDatas = formDataMasterBean.getSubData(paramBean.getTableName());
            exitsSubIds = new HashSet<String>(subDatas.size());
            for (FormDataSubBean formDataSubBean : subDatas) {
                exitsSubIds.add(String.valueOf(formDataSubBean.getId()));
            }
            promptBean = new ImportPromptBean();
            indexFieldMap = new HashMap<Integer, FormFieldBean>();
            fieldNameIndexMap = new HashMap<String, Integer>();
            i = 0;
            j = fieldData.size();
            while (i < j) {
                block19: {
                    block23: {
                        block22: {
                            block21: {
                                block20: {
                                    fieldDisplay = (String)fieldData.get(i);
                                    if (Strings.isBlank((String)fieldDisplay)) break block19;
                                    formFieldBean /* !! */  = formBean.getFieldBeanByDisplay((String)fieldDisplay);
                                    if (this.checkImportSupportSubField(formFieldBean /* !! */ ) && tempFieldDisplay.get(fieldDisplay) == null && fieldBeanMap.get(formFieldBean /* !! */ .getName()) != null) break block20;
                                    promptBean.getNotSupportField().add((String)fieldDisplay);
                                    break block19;
                                }
                                if (!this.isAuthBrowseOrHide(apartAuthMap, formFieldBean /* !! */ , formAuthViewBean, exitsSubIds)) break block21;
                                promptBean.getNotAuthField().add((String)fieldDisplay);
                                break block19;
                            }
                            indexFieldMap.put(i, formFieldBean /* !! */ );
                            fieldNameIndexMap.put(formFieldBean /* !! */ .getName(), i);
                            tempFieldDisplay.put(fieldDisplay, fieldDisplay);
                            if (relationFieldMap.get(formFieldBean /* !! */ .getName()) == null) break block22;
                            promptBean.getAutoBackFillField().add((String)fieldDisplay);
                            break block19;
                        }
                        if (!formFieldBean /* !! */ .isSn() && !formFieldBean /* !! */ .isFormulaSn()) break block23;
                        promptBean.getAutoBackFillField().add((String)fieldDisplay);
                        break block19;
                    }
                    if (formFieldBean /* !! */ .getFormRelation() == null) ** GOTO lbl-1000
                    relationFieldBean = formBean.getFieldBeanByName(formFieldBean /* !! */ .getFormRelation().getToRelationAttr());
                    if (!FormFieldComEnum.SELECT.getKey().equals(relationFieldBean.getInputType()) && !FormFieldComEnum.SELECT.getKey().equals(formFieldBean /* !! */ .getInputType())) {
                        promptBean.getAutoBackFillField().add((String)fieldDisplay);
                    } else if (!Strings.isEmpty((Collection)formFieldBean /* !! */ .getFormConditionList())) {
                        promptBean.getAutoBackFillField().add((String)fieldDisplay);
                    }
                }
                fieldDisplay = i;
                i = i + 1;
                formFieldBean /* !! */  = i;
            }
            if (indexFieldMap.isEmpty()) {
                throw new FormDataBusinessException("3005", "non excel standard template!");
            }
            this.deleteErrorEnumField(promptBean, enumFieldTeams, indexFieldMap, fieldNameIndexMap, formBean);
            v0 = startDataRow = isExportTemplate != false ? 3 : 2;
            if (lists.size() - startDataRow > 1000) {
                throw new FormDataBusinessException("3004", String.format("more than %s lines!", new Object[]{1000}));
            }
            allDataList = new ArrayList<LinkedHashMap<K, V>>();
            k = lists.size();
            for (i = startDataRow; i < k; ++i) {
                oneLineDatas = (List)lists.get(i);
                fieldIndexSet = indexFieldMap.keySet();
                if (this.isAllNullLine(fieldIndexSet, oneLineDatas)) continue;
                oneLineDataMap = new LinkedHashMap<String, String>(indexFieldMap.size());
                oneSize = oneLineDatas.size();
                for (Integer var33_40 : fieldIndexSet) {
                    value = var33_40 < oneSize ? this.trim((String)oneLineDatas.get(var33_40)) : "";
                    oneLineDataMap.put(((FormFieldBean)indexFieldMap.get(var33_40)).getName(), value);
                }
                allDataList.add(oneLineDataMap);
            }
            if (allDataList.isEmpty()) {
                throw new FormDataBusinessException("3003", "excel data is empty");
            }
            connection = CAPSQLiteUtil.getConnection((String)this.getDbName(formBean.getMasterTableBean().getTableName(), paramBean.getType()));
            masterEnumDataMap = this.getMasterEnumFieldShowValue(formBean, formDataMasterBean, enumFieldTeams);
            if (!masterEnumDataMap.isEmpty()) {
                this.insertMasterData(formBean, formDataMasterBean, connection, masterEnumDataMap);
            }
            fieldNameList = new ArrayList<String>();
            insertDataFields = this.getInsertFields(connection, formBean, paramBean.getTableName(), indexFieldMap, fieldNameList);
            insertDataSql = CAPSQLiteUtil.getInsertDataSql((String)paramBean.getTableName(), insertDataFields);
            insertParams = new ArrayList<ArrayList<Object>>();
            tableSort = 1;
            for (Map var33_42 : allDataList) {
                errorFlag = CAPBusinessEnum.TrueOrFalseEnum.FALSE.getKey();
                insertParam = new ArrayList<Object>();
                insertParam.add(tableSort);
                insertParam.add(1);
                cacheCurrentLineData = new HashMap<String, ImportFieldVO>();
                errorFlag = this.setData2Insert(formBean, var33_42, cacheCurrentLineData, insertParam, errorFlag, masterEnumDataMap);
                insertParam.add(2, errorFlag);
                insertParam.add(3, String.valueOf(UUIDLong.longUUID()));
                insertParams.add(insertParam);
                ++tableSort;
            }
            CAPSQLiteUtil.updateBatch((Connection)connection, (String)insertDataSql, insertParams);
            readBean = new ExcelReadParamBean();
            readBean.setTableName(paramBean.getTableName());
            readBean.setFormId(paramBean.getFormId());
            readBean.setType(paramBean.getType());
            readBean.setInit(1);
            readBean.setFieldInfos(StringUtils.join(fieldNameList, (String)","));
            var33_43 = this.capImportCacheDataManager.read(readBean);
            this.buildPrompt(importReadSubDataVO, promptBean);
            importReadSubDataVO.setData(var33_43.getData());
            importReadSubDataVO.setFieldInfos(var33_43.getFieldBeans());
            importReadSubDataVO.setFormInfos(var33_43.getResultTableBeans());
        }
        catch (BusinessException e) {
            try {
                this.deleteTable(formBean, connection);
                throw e;
                catch (Exception e) {
                    CAPImportManager4FormSubData.LOGGER.error((Object)("importSubTableExcelDatas.Exception fileId=" + paramBean), (Throwable)e);
                    this.deleteTable(formBean, connection);
                    throw new FormDataBusinessException("3002", String.format("%s option exception!", new Object[]{"importSubTableExcelDatas.Exception"}));
                }
            }
            catch (Throwable var37_47) {
                CAPSQLiteUtil.closeConnection(connection);
                throw var37_47;
            }
        }
        CAPSQLiteUtil.closeConnection((Connection)connection);
        return importReadSubDataVO;
    }

    private boolean isAllNullLine(Set<Integer> fieldIndexs, List<String> oneLineData) {
        boolean isAllNull = true;
        int oneSize = oneLineData.size();
        for (Integer fieldIndex : fieldIndexs) {
            String value = fieldIndex < oneSize ? this.trim(oneLineData.get(fieldIndex)) : "";
            if (!Strings.isNotBlank((String)value)) continue;
            isAllNull = false;
            break;
        }
        return isAllNull;
    }

    private void insertMasterData(FormBean formBean, FormDataMasterBean formDataMasterBean, Connection connection, Map<String, String> masterDataMap) throws SQLException {
        String masterTableName = formBean.getMasterTableBean().getTableName();
        if (CAPSQLiteUtil.isExistTable((Connection)connection, (String)masterTableName)) {
            this.deleteTable(formBean, connection);
        }
        ArrayList<String> createFields = new ArrayList<String>();
        createFields.add("id INTEGER PRIMARY KEY ON CONFLICT REPLACE");
        createFields.add("error_flag VARCHAR(2)");
        ArrayList<String> insertFields = new ArrayList<String>();
        insertFields.add("id");
        insertFields.add("error_flag");
        ArrayList insertParams = new ArrayList();
        ArrayList<Object> insertParam = new ArrayList<Object>();
        insertParam.add(1);
        insertParam.add(CAPBusinessEnum.TrueOrFalseEnum.FALSE.getKey());
        for (String masterFieldName : masterDataMap.keySet()) {
            createFields.add(masterFieldName + VARCHAR);
            insertFields.add(masterFieldName);
            String dbValue = formDataMasterBean.getFieldValue(masterFieldName) == null ? "" : String.valueOf(formDataMasterBean.getFieldValue(masterFieldName));
            ImportFieldVO fieldVO = new ImportFieldVO(dbValue, masterDataMap.get(masterFieldName), "0");
            insertParam.add(fieldVO.toJSONString());
        }
        insertParams.add(insertParam);
        CAPSQLiteUtil.createTable((Connection)connection, (String)CAPSQLiteUtil.getCreateTableSql((String)formBean.getMasterTableBean().getTableName(), createFields));
        String insertSql = CAPSQLiteUtil.getInsertDataSql((String)formBean.getMasterTableBean().getTableName(), insertFields);
        CAPSQLiteUtil.updateBatch((Connection)connection, (String)insertSql, insertParams);
    }

    private Map<String, String> getMasterEnumFieldShowValue(FormBean formBean, FormDataMasterBean formDataMasterBean, List<Set<String>> enumFieldTeams) {
        HashMap<String, String> masterEnumDataMap = new HashMap<String, String>();
        for (Set<String> fieldNames : enumFieldTeams) {
            for (String fieldName : fieldNames) {
                FormFieldBean formFieldBean = formBean.getFieldBeanByName(fieldName, true);
                if (!formFieldBean.isMasterField()) continue;
                masterEnumDataMap.put(fieldName, "");
                if (formDataMasterBean.getFieldValue(fieldName) == null) continue;
                String itemId = String.valueOf(formDataMasterBean.getFieldValue(fieldName));
                CtpEnumItem ctpEnumItem = this.enumManagerNew.getEnumItem(Long.valueOf(Long.parseLong(itemId)));
                masterEnumDataMap.put(fieldName, ctpEnumItem == null ? "" : ctpEnumItem.getShowvalue());
            }
        }
        return masterEnumDataMap;
    }

    private List<String> getInsertFields(Connection connection, FormBean formBean, String tableName, Map<Integer, FormFieldBean> indexFieldMap, List<String> fieldNameList) throws SQLException {
        ArrayList<String> createTableFields = new ArrayList<String>();
        createTableFields.add("id INTEGER PRIMARY KEY ON CONFLICT REPLACE");
        createTableFields.add("formmain_id INTEGER");
        createTableFields.add("error_flag VARCHAR(2)");
        createTableFields.add("uuid VARCHAR(20)");
        ArrayList<String> insertDataFields = new ArrayList<String>();
        insertDataFields.add("id");
        insertDataFields.add("formmain_id");
        insertDataFields.add("error_flag");
        insertDataFields.add(UUID);
        for (Map.Entry<Integer, FormFieldBean> entry : indexFieldMap.entrySet()) {
            FormFieldBean formFieldBean = entry.getValue();
            createTableFields.add(formFieldBean.getName() + VARCHAR);
            insertDataFields.add(formFieldBean.getName());
            fieldNameList.add(formFieldBean.getName());
        }
        if (CAPSQLiteUtil.isExistTable((Connection)connection, (String)tableName)) {
            this.deleteTable(formBean, connection);
        }
        CAPSQLiteUtil.createTable((Connection)connection, (String)CAPSQLiteUtil.getCreateTableSql((String)tableName, createTableFields));
        return insertDataFields;
    }

    private boolean isAuthBrowseOrHide(Map<String, FormAuthViewFieldBean> apartAuthMap, FormFieldBean formFieldBean, FormAuthViewBean formAuthViewBean, Set<String> exitsSubIds) {
        boolean result = false;
        boolean hasFieldApartAuth = false;
        for (Map.Entry<String, FormAuthViewFieldBean> entry : apartAuthMap.entrySet()) {
            String tempFieldName = entry.getKey();
            if (!tempFieldName.startsWith(formFieldBean.getName()) || !tempFieldName.contains("_") || !exitsSubIds.contains(tempFieldName.split("_")[1])) continue;
            String access = entry.getValue().getAccess();
            hasFieldApartAuth = true;
            if (!Enums.FieldAccessType.browse.getKey().equals(access) && !Enums.FieldAccessType.hide.getKey().equals(access)) continue;
            result = true;
            break;
        }
        if (!hasFieldApartAuth) {
            FormAuthViewFieldBean authViewFieldBean = formAuthViewBean.getFormAuthorizationField(formFieldBean.getName());
            if (Enums.FieldAccessType.browse.getKey().equals(authViewFieldBean.getAccess()) || Enums.FieldAccessType.hide.getKey().equals(authViewFieldBean.getAccess())) {
                result = true;
            }
        }
        return result;
    }

    private void buildPrompt(ImportReadSubDataVO vo, ImportPromptBean promptBean) {
        vo.setImportPrompt(new ArrayList<String>());
        vo.setNextPrompt(new ArrayList<String>());
        if (CollectionUtils.isNotEmpty(promptBean.getNotAuthField())) {
            vo.getImportPrompt().add(ResourceUtil.getString((String)NOT_AUTH_FIELD_INFO) + StringUtils.join(promptBean.getNotAuthField(), (String)CHINESE_DELIMITER));
        }
        if (CollectionUtils.isNotEmpty(promptBean.getRelationEnumField())) {
            vo.getImportPrompt().add(ResourceUtil.getString((String)RELATION_ENUM_FIELD_INFO) + StringUtils.join(promptBean.getRelationEnumField(), (String)CHINESE_DELIMITER));
        }
        if (CollectionUtils.isNotEmpty(promptBean.getNotSupportField())) {
            vo.getImportPrompt().add(ResourceUtil.getString((String)NOT_SUPPORT_FIELD_INFO) + StringUtils.join(promptBean.getNotSupportField(), (String)CHINESE_DELIMITER));
        }
        if (CollectionUtils.isNotEmpty(promptBean.getAutoBackFillField())) {
            vo.getNextPrompt().add(ResourceUtil.getString((String)AUTE_BACKFILL_FIELD_INFO) + StringUtils.join(promptBean.getAutoBackFillField(), (String)CHINESE_DELIMITER));
        }
    }

    private Map<String, String> getSysRelationMappingField(FormBean formBean) {
        HashMap<String, String> relationFieldMap = new HashMap<String, String>();
        List formRelationshipIdList = formBean.getFormRelationshipIdList();
        for (Long formRelationshipId : formRelationshipIdList) {
            FormRelationshipBean formRelationshipBean = this.cap4FormCacheManager.getFormRelationshipBean(formRelationshipId);
            if (formRelationshipBean.getState() != 1 || formRelationshipBean.getRelationType() != FormRelationEnums.ViewSelectType.system.getKey()) continue;
            FormRelationshipMapBean formRelationshipMapBean = (FormRelationshipMapBean)formRelationshipBean.getRelationMapList().get(0);
            relationFieldMap.putAll(formRelationshipMapBean.getFormRelationFieldMap());
        }
        return relationFieldMap;
    }

    public void setCap4FormDataManager(CAP4FormDataManager cap4FormDataManager) {
        this.cap4FormDataManager = cap4FormDataManager;
    }

    public void setCapRuntimeCalcManager(CAPRuntimeCalcManager capRuntimeCalcManager) {
        this.capRuntimeCalcManager = capRuntimeCalcManager;
    }

    public void setCapTransFormDataBeanManager(CAPTransFormDataBeanManager capTransFormDataBeanManager) {
        this.capTransFormDataBeanManager = capTransFormDataBeanManager;
    }

    public void setCapImportCacheDataManager(CAPImportCacheDataManager capImportCacheDataManager) {
        this.capImportCacheDataManager = capImportCacheDataManager;
    }
}

