/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.cap4.template.manager.impl;

import com.seeyon.cap4.form.util.sqlite.CAPSQLiteUtil;
import com.seeyon.cap4.template.manager.CAPImportUniqueManager;
import com.seeyon.cap4.template.manager.impl.AbstractCAPImportManager;
import com.seeyon.ctp.common.log.CtpLogFactory;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;

public class CAPImportUniqueManagerImpl
extends AbstractCAPImportManager
implements CAPImportUniqueManager {
    private static final Log LOGGER = CtpLogFactory.getLog(CAPImportUniqueManagerImpl.class);
    private static final String UNIQUE_TABLE = "unique_table";
    private static final String UNIQUE_KEY = "unique_key";
    private static final String UNIQUE_VALUE = "value";
    private static final int SELECT_IN_SIZE = 900;

    @Override
    public void createTable(Connection connection) throws SQLException {
        this.deleteTable(connection);
        ArrayList<String> fields = new ArrayList<String>(2);
        fields.add("unique_key VARCHAR(4000) PRIMARY KEY ON CONFLICT REPLACE");
        fields.add("value VARCHAR(41)");
        CAPSQLiteUtil.createTable((Connection)connection, (String)CAPSQLiteUtil.getCreateTableSql((String)UNIQUE_TABLE, fields));
    }

    @Override
    public void deleteTable(Connection connection) throws SQLException {
        if (CAPSQLiteUtil.isExistTable((Connection)connection, (String)UNIQUE_TABLE)) {
            CAPSQLiteUtil.deleteTable((Connection)connection, (String)UNIQUE_TABLE);
        }
    }

    @Override
    public String getInsertSql() {
        ArrayList<String> fields = new ArrayList<String>(2);
        fields.add(UNIQUE_KEY);
        fields.add(UNIQUE_VALUE);
        return CAPSQLiteUtil.getInsertDataSql((String)UNIQUE_TABLE, fields);
    }

    @Override
    public void insert(Connection connection, String insertSql, Map<String, String> uniqueMap) throws SQLException {
        if (uniqueMap == null || uniqueMap.isEmpty()) {
            return;
        }
        ArrayList insertParams = new ArrayList();
        for (Map.Entry<String, String> entry : uniqueMap.entrySet()) {
            ArrayList<String> params = new ArrayList<String>(2);
            params.add(entry.getKey());
            params.add(entry.getValue());
            insertParams.add(params);
        }
        CAPSQLiteUtil.updateBatch((Connection)connection, (String)insertSql, insertParams);
    }

    @Override
    public List<Map<String, Object>> selectByUniques(Connection connection, Collection<String> uniques) throws SQLException {
        if (CollectionUtils.isEmpty(uniques)) {
            return null;
        }
        long startTime = System.currentTimeMillis();
        ArrayList<String> keys = uniques instanceof List ? (ArrayList<String>)uniques : new ArrayList<String>(uniques);
        ArrayList<Map<String, Object>> dataList = new ArrayList<Map<String, Object>>();
        int count = uniques.size();
        int totalPage = count % 900 == 0 ? count / 900 : count / 900 + 1;
        for (int i = 1; i <= totalPage; ++i) {
            List tempKeys = keys.subList((i - 1) * 900, i == totalPage ? count : i * 900);
            List<Map<String, Object>> pageList = this.getSQLiteDataListByIn(connection, tempKeys, UNIQUE_TABLE, UNIQUE_KEY);
            if (pageList == null) continue;
            dataList.addAll(pageList);
        }
        LOGGER.info((Object)("selectByUniques uniques count " + count + ", result size " + dataList.size() + ", use " + (System.currentTimeMillis() - startTime)));
        return dataList;
    }

    @Override
    public Map<String, String> selectByUniques4Map(Connection connection, Collection<String> uniques) throws SQLException {
        List<Map<String, Object>> exitsUnique = this.selectByUniques(connection, uniques);
        HashMap<String, String> uniqueMap = new HashMap<String, String>();
        if (CollectionUtils.isNotEmpty(exitsUnique)) {
            for (Map<String, Object> map : exitsUnique) {
                uniqueMap.put(String.valueOf(map.get(UNIQUE_KEY)), String.valueOf(map.get(UNIQUE_VALUE)));
            }
        }
        return uniqueMap;
    }
}

