/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.cap4.template.manager.impl;

import com.seeyon.cap4.form.bean.FormAuthViewBean;
import com.seeyon.cap4.form.bean.FormAuthViewFieldBean;
import com.seeyon.cap4.form.bean.FormAuthorizationTableBean;
import com.seeyon.cap4.form.bean.FormBean;
import com.seeyon.cap4.form.bean.FormDataBean;
import com.seeyon.cap4.form.bean.FormDataMasterBean;
import com.seeyon.cap4.form.bean.FormDataSubBean;
import com.seeyon.cap4.form.bean.FormFieldBean;
import com.seeyon.cap4.form.bean.FormRelationshipMapBean;
import com.seeyon.cap4.form.bean.FormTableBean;
import com.seeyon.cap4.form.modules.engin.base.formData.CAP4FormDataManager;
import com.seeyon.cap4.form.modules.engin.relation.CAP4FormRelationActionManager;
import com.seeyon.cap4.form.modules.engin.relation.FormRelationEnums;
import com.seeyon.cap4.form.po.CAPFormRelationRecord;
import com.seeyon.cap4.form.service.CAP4FormManager;
import com.seeyon.cap4.form.util.Enums;
import com.seeyon.cap4.template.constant.CAPBusinessEnum;
import com.seeyon.cap4.template.manager.CAPRuntimeCalcManager;
import com.seeyon.cap4.template.util.CAPAttachmentUtil;
import com.seeyon.cap4.template.util.CAPFormDataLogUtil;
import com.seeyon.cap4.template.util.CAPFormUtil;
import com.seeyon.cap4.template.util.CAPParamUtil;
import com.seeyon.ctp.common.AppContext;
import com.seeyon.ctp.common.exceptions.BusinessException;
import com.seeyon.ctp.common.i18n.ResourceUtil;
import com.seeyon.ctp.common.log.CtpLogFactory;
import com.seeyon.ctp.util.Strings;
import com.seeyon.ctp.util.UUIDLong;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;

public class CAPRuntimeCalcManagerImpl
implements CAPRuntimeCalcManager {
    private static final Log LOGGER = CtpLogFactory.getLog(CAPRuntimeCalcManagerImpl.class);
    private CAP4FormDataManager cap4FormDataManager;
    private CAP4FormRelationActionManager cap4FormRelationActionManager;
    private CAP4FormManager cap4FormManager;
    private static final String ATTACHMENT_INFO = "attachmentInfo";
    private static final String RELATION_INFO = "relationInfo";
    private static final String RELATION_DATA = "relationData";
    private static final String ENUMS = "enums";
    private static final String TRIGGER_DATA = "triggerData";
    private static final String RELATION_RECORDS = "relationRecords";
    private static final String AUTH = "auth";
    private static final String FORMSON = "formson";
    private static final String FIELD = "field";
    private static final String UPDATE = "update";
    private static final String DELETE = "delete";
    private static final String ADD = "add";
    private static final String ID = "id";
    private static final String TABLE_BUTTON = "tableButton";
    private static final String TABLE_AUTH = "tableAuth";

    @Override
    public Set<String> execCalcAll(FormBean formBean, FormDataMasterBean cacheFormDataMasterBean, FormAuthViewBean formAuthViewBean, Map<String, List<Long>> tableName2AddSubIds) throws BusinessException {
        Set changeFields = cacheFormDataMasterBean.getFieldChanges4Calc();
        if (cacheFormDataMasterBean.getInnerRelationChanges4Calc() != null) {
            AppContext.putThreadContext((String)"fieldInnerChangeMap", (Object)cacheFormDataMasterBean.getInnerRelationChanges4Calc());
        }
        HashSet<String> fillBackFields = new HashSet();
        try {
            long fieldStart = System.currentTimeMillis();
            Map<String, Map<String, Boolean>> fieldChangeTags = this.getCalcAllFieldChanges(formBean, changeFields, tableName2AddSubIds);
            long fieldEnd = System.currentTimeMillis();
            if (fieldEnd - fieldStart > 500L) {
                LOGGER.info((Object)(cacheFormDataMasterBean.getId() + " getCalcAllFieldChanges use " + (fieldEnd - fieldStart) + " " + fieldChangeTags.size()));
            }
            AppContext.putThreadContext((String)"fieldChangeTag", fieldChangeTags);
            HashSet runtimeCalcEnumSets = new HashSet();
            AppContext.putThreadContext((String)"runtimeCalcEnumSets", runtimeCalcEnumSets);
            fillBackFields = this.cap4FormDataManager.calcAll(formBean, cacheFormDataMasterBean, formAuthViewBean, true, false, true, true);
            this.execCalcAllSpecial(formBean, cacheFormDataMasterBean, formAuthViewBean, tableName2AddSubIds, fillBackFields);
            fillBackFields.addAll(runtimeCalcEnumSets);
        }
        catch (Exception e) {
            LOGGER.info((Object)(cacheFormDataMasterBean.getId() + " doCalculateAll " + e.getMessage()), (Throwable)e);
            throw new BusinessException((Throwable)e);
        }
        finally {
            cacheFormDataMasterBean.clearFieldChangesByCalc();
            AppContext.removeThreadContext((String)"fieldInnerChangeMap");
            AppContext.removeThreadContext((String)"fieldChangeTag");
            AppContext.removeThreadContext((String)"runtimeCalcEnumSets");
        }
        return fillBackFields;
    }

    @Override
    public void buildCalcAllResult(FormBean formBean, FormDataMasterBean cacheFormDataMasterBean, FormAuthViewBean formAuthViewBean, Object tableName2AddObjects, Set<String> fillBackFields, CAPBusinessEnum.SubBeanNewFrom newFrom, Map<String, Map<String, Object>> tableName2DataMaps) throws BusinessException {
        Map<String, Object> calcResult = this.buildCalcResult(formBean, cacheFormDataMasterBean, formAuthViewBean, fillBackFields);
        this.mergeAddSubBeans2Result(formBean, cacheFormDataMasterBean, formAuthViewBean, tableName2DataMaps, tableName2AddObjects, calcResult, newFrom);
        this.mergeCalcData2Result(calcResult, tableName2DataMaps);
    }

    @Override
    public Map<String, Object> buildCalcResult(FormBean formBean, FormDataMasterBean cacheFormDataMasterBean, FormAuthViewBean formAuthViewBean, Set<String> fillBackFields) throws BusinessException {
        Map<String, Object> auth1 = this.cap4FormDataManager.dealFormRightChangeResult(formBean, formAuthViewBean, cacheFormDataMasterBean, true);
        Map apartAuthMap = (Map)auth1.get("apartAuthMap");
        Map subTableAuthMap = (Map)auth1.get("subTableAuthMap");
        Map<String, List<FormRelationshipMapBean>> manualFormRelationshipMapBeans = this.cap4FormRelationActionManager.getFormField4ManualRelationMapBeans(formBean);
        if (fillBackFields != null) {
            fillBackFields.addAll(apartAuthMap.keySet());
        }
        Map<String, Object> dataMap = this.getCalcDataMap(formBean, cacheFormDataMasterBean, formAuthViewBean, fillBackFields, apartAuthMap, manualFormRelationshipMapBeans);
        for (Map.Entry entry : apartAuthMap.entrySet()) {
            List<FormRelationshipMapBean> mapBeans;
            String key = (String)entry.getKey();
            FormAuthViewFieldBean formAuthViewFieldBean = (FormAuthViewFieldBean)entry.getValue();
            FormFieldBean formFieldBean = formAuthViewFieldBean.getFormFieldBean();
            Map<String, String> authMap = CAPFormUtil.getAuthMap(formFieldBean, formAuthViewFieldBean, null, false);
            HashMap<String, Object> data = (HashMap<String, Object>)dataMap.get(key);
            if (data == null) {
                data = new HashMap<String, Object>();
                dataMap.put(key, data);
                String recordId = null;
                if (key.contains("_")) {
                    recordId = key.split("_")[1];
                }
                data.putAll(this.getCalcRelationAndTriggerDataMap(cacheFormDataMasterBean, formFieldBean, authMap, manualFormRelationshipMapBeans, recordId));
            }
            if ((Enums.FieldAccessType.edit.getKey().equals(formAuthViewFieldBean.getAccess()) || Enums.FieldAccessType.add.getKey().equals(formAuthViewFieldBean.getAccess())) && CollectionUtils.isNotEmpty(mapBeans = manualFormRelationshipMapBeans.get(formFieldBean.getName())) && !CAPFormUtil.relationFieldHasEditAuth(mapBeans)) {
                authMap.put(AUTH, Enums.FieldAccessType.browse.getKey());
            }
            data.putAll(authMap);
        }
        Map<String, Object> resultMap = this.rebuildCalcDataMap(formBean, dataMap);
        for (String tableName : subTableAuthMap.keySet()) {
            FormTableBean tableBean = formBean.getTableByTableName(tableName);
            HashMap<String, Object> tableMap = (HashMap<String, Object>)resultMap.get(tableName);
            if (tableMap == null) {
                tableMap = new HashMap<String, Object>();
                resultMap.put(tableName, tableMap);
            }
            FormAuthorizationTableBean formAuthorizationTableBean = subTableAuthMap.get(tableName) == null ? formAuthViewBean.getSubTableAuth(tableBean.getDisplay()) : (FormAuthorizationTableBean)subTableAuthMap.get(tableName);
            tableMap.put(TABLE_BUTTON, this.getFormSonAuthButtons(formBean, formAuthViewBean, tableBean, formAuthorizationTableBean, false));
            tableMap.put(TABLE_AUTH, this.getFormSonAuth(formAuthorizationTableBean, false));
        }
        return resultMap;
    }

    @Override
    public boolean needCalcSysRelation(FormDataBean oldFormDataBean, FormDataBean formDataBean, FormFieldBean formFieldBean, List<Long> addSubIds, Set<String> relationChangeFields) {
        if (formFieldBean.isInRelationCondition()) {
            if (addSubIds != null && formFieldBean.isSubField() && addSubIds.contains(formDataBean.getId())) {
                return true;
            }
            if (relationChangeFields != null && relationChangeFields.contains(formDataBean.generageFillbackKey(formFieldBean.getName()))) {
                return true;
            }
            if (!this.checkFieldValueChanged(oldFormDataBean, formDataBean, formFieldBean)) {
                return false;
            }
        }
        return true;
    }

    @Override
    public boolean needCalc(FormDataBean oldFormDataBean, FormDataBean formDataBean, FormFieldBean formFieldBean, Set<String> fieldInnerChangesKey) {
        boolean needCalc = formFieldBean.needCalculation();
        if (needCalc && fieldInnerChangesKey != null && fieldInnerChangesKey.contains(formDataBean.generageFillbackKey(formFieldBean.getName()))) {
            return needCalc;
        }
        if (formFieldBean.isInInnerRelation()) {
            needCalc = this.needCalcInnerRelation(oldFormDataBean, formDataBean, formFieldBean);
        }
        return needCalc;
    }

    @Override
    public FormDataMasterBean mergeFormData(FormBean formBean, FormDataMasterBean cacheFormDataMasterBean, FormAuthViewBean formAuthViewBean, Map<String, Object> mergeData) {
        FormTableBean masterTableBean = formBean.getMasterTableBean();
        Map masterData = (Map)mergeData.get(masterTableBean.getTableName());
        List masterFields = masterTableBean.getFields();
        CAPFormDataLogUtil.recordTraceFront(masterData, formBean.getId(), false);
        for (FormFieldBean formFieldBean : masterFields) {
            FormAuthViewFieldBean formAuthViewFieldBean = CAPFormUtil.getFormAuthViewFieldBean(formAuthViewBean, formFieldBean, cacheFormDataMasterBean, null);
            if (!formAuthViewFieldBean.getAccess().equals(Enums.FieldAccessType.browse.getKey()) && !formAuthViewFieldBean.getAccess().equals(Enums.FieldAccessType.hide.getKey())) continue;
            masterData.put(formFieldBean.getName(), cacheFormDataMasterBean.getFieldValue(formFieldBean.getName()));
        }
        CAPFormDataLogUtil.recordTrace(cacheFormDataMasterBean, "\u5408\u5e76\u7f13\u5b58\u524d");
        AppContext.putThreadContext((String)"newFormDataMasterBeanFrom", (Object)"mergeForm");
        FormDataMasterBean formDataMasterBean = new FormDataMasterBean(masterData, masterTableBean, new boolean[0]);
        formDataMasterBean.setId(cacheFormDataMasterBean.getId());
        List subTableBeans = formBean.getSubTableBean();
        for (FormTableBean formTableBean : subTableBeans) {
            List subDatas = CAPParamUtil.getParamsListByKey(mergeData, (String)formTableBean.getTableName());
            if (subDatas == null) {
                LOGGER.info((Object)(cacheFormDataMasterBean.getId() + " \u5408\u5e76\u7f13\u5b58\u63d0\u4ea4\u6570\u636e " + formTableBean.getTableName() + " \u65e0\u660e\u7ec6\u8868"));
                continue;
            }
            LOGGER.info((Object)(cacheFormDataMasterBean.getId() + " \u5408\u5e76\u7f13\u5b58\u63d0\u4ea4\u6570\u636e " + formTableBean.getTableName() + " " + subDatas.size() + "\u884c"));
            for (Map subData : subDatas) {
                CAPFormDataLogUtil.recordTraceFront(subData, formBean.getId(), true);
                List subFields = formTableBean.getFields();
                FormDataSubBean cacheSubDataBean = null;
                boolean initCacheBean = false;
                for (FormFieldBean formFieldBean : subFields) {
                    FormAuthViewFieldBean formAuthViewFieldBean = CAPFormUtil.getFormAuthViewFieldBean(formAuthViewBean, formFieldBean, cacheFormDataMasterBean, String.valueOf(subData.get(ID)));
                    if (!formAuthViewFieldBean.getAccess().equals(Enums.FieldAccessType.browse.getKey()) && !formAuthViewFieldBean.getAccess().equals(Enums.FieldAccessType.hide.getKey())) continue;
                    if (!initCacheBean) {
                        cacheSubDataBean = cacheFormDataMasterBean.getFormDataSubBeanById(formTableBean.getTableName(), Long.valueOf(String.valueOf(subData.get(ID))));
                        initCacheBean = true;
                    }
                    if (cacheSubDataBean == null) {
                        subData.remove(formFieldBean.getName());
                        continue;
                    }
                    subData.put(formFieldBean.getName(), cacheSubDataBean.getFieldValue(formFieldBean.getName()));
                }
                subData.put(Enums.SubTableField.formmain_id.getKey(), cacheFormDataMasterBean.getId());
                FormDataSubBean formDataSubBean = new FormDataSubBean(subData, formTableBean, formDataMasterBean, new boolean[]{false});
                formDataMasterBean.addSubData(formTableBean.getTableName(), formDataSubBean);
            }
        }
        AppContext.removeThreadContext((String)"newFormDataMasterBeanFrom");
        this.cap4FormManager.mergeFormData(formDataMasterBean, cacheFormDataMasterBean, formBean);
        for (FormTableBean formTableBean : subTableBeans) {
            List subBeans = cacheFormDataMasterBean.getSubData(formTableBean.getTableName());
            LOGGER.info((Object)(cacheFormDataMasterBean.getId() + " \u5408\u5e76\u7f13\u5b58\u540e " + formTableBean.getTableName() + " " + (subBeans == null ? "null" : Integer.valueOf(subBeans.size())) + "\u884c"));
        }
        CAPFormDataLogUtil.recordTrace(cacheFormDataMasterBean, "\u5408\u5e76\u7f13\u5b58\u540e");
        this.cap4FormManager.saveSessioMasterDataBean(cacheFormDataMasterBean.getId(), cacheFormDataMasterBean);
        return formDataMasterBean;
    }

    @Override
    public Map<String, String> getFormSonAuth(FormAuthorizationTableBean authTableBean, boolean isPre) {
        HashMap<String, String> map = new HashMap<String, String>();
        ArrayList<CAPBusinessEnum.FormsonButtonType> authTypes = new ArrayList<CAPBusinessEnum.FormsonButtonType>();
        authTypes.add(CAPBusinessEnum.FormsonButtonType.ADD);
        authTypes.add(CAPBusinessEnum.FormsonButtonType.COPY);
        authTypes.add(CAPBusinessEnum.FormsonButtonType.DELETE);
        authTypes.add(CAPBusinessEnum.FormsonButtonType.DELETE_ALL);
        authTypes.add(CAPBusinessEnum.FormsonButtonType.IMPORT_EXCEL);
        authTypes.add(CAPBusinessEnum.FormsonButtonType.EXPORT_EXCEL);
        for (CAPBusinessEnum.FormsonButtonType fbt : authTypes) {
            if (!isPre && !this.getFormSonOperationAuth(authTableBean, fbt)) continue;
            map.put(fbt.getAlias(), CAPBusinessEnum.TrueOrFalseEnum.TRUE.getKey());
        }
        return map;
    }

    @Override
    public List<Map<String, Object>> getFormSonAuthButtons(FormBean formBean, FormAuthViewBean formAuthViewBean, FormTableBean subTable, FormAuthorizationTableBean authTableBean, boolean isPre) {
        LinkedList<Map<String, Object>> list = new LinkedList<Map<String, Object>>();
        if (isPre || this.getFormSonOperationAuth(authTableBean, CAPBusinessEnum.FormsonButtonType.ADD)) {
            Map<String, Object> addMap = CAPBusinessEnum.FormsonButtonType.ADD.exportMap();
            list.add(addMap);
            List<FormRelationshipMapBean> formRelationshipMapBeans = this.cap4FormRelationActionManager.getValidFormRelationshipMapBeansByType(formBean, FormRelationEnums.ViewSelectType.user.getKey());
            Iterator<FormRelationshipMapBean> iterator = formRelationshipMapBeans.iterator();
            while (iterator.hasNext()) {
                FormFieldBean formFieldBean;
                FormRelationshipMapBean formRelationshipMapBean = iterator.next();
                if (formRelationshipMapBean.getFillInRow() != 1 || !(formFieldBean = formBean.getFieldBeanByName(formRelationshipMapBean.getSelectedField())).getOwnerTableName().equals(subTable.getTableName())) continue;
                Map<String, Object> map = CAPBusinessEnum.FormsonButtonType.MANUAL_RELATION.exportMap();
                Map<String, String> relationMap = CAPFormUtil.getRelationCommonJSON(formRelationshipMapBean);
                map.put("params", relationMap);
                if (Strings.isBlank((String)formRelationshipMapBean.getButtonName())) {
                    map.put("name", ResourceUtil.getString((String)"cap.formDesign.toolbar.insert") + formFieldBean.getDisplay());
                } else {
                    map.put("name", formRelationshipMapBean.getButtonName());
                }
                list.add(map);
            }
        }
        ArrayList<CAPBusinessEnum.FormsonButtonType> authCommonTypes = new ArrayList<CAPBusinessEnum.FormsonButtonType>();
        authCommonTypes.add(CAPBusinessEnum.FormsonButtonType.COPY);
        authCommonTypes.add(CAPBusinessEnum.FormsonButtonType.DELETE);
        authCommonTypes.add(CAPBusinessEnum.FormsonButtonType.DELETE_ALL);
        authCommonTypes.add(CAPBusinessEnum.FormsonButtonType.IMPORT_EXCEL);
        authCommonTypes.add(CAPBusinessEnum.FormsonButtonType.EXPORT_EXCEL);
        for (CAPBusinessEnum.FormsonButtonType fbt : authCommonTypes) {
            if (!isPre && !this.getFormSonOperationAuth(authTableBean, fbt)) continue;
            Map<String, Object> map = fbt.exportMap();
            list.add(map);
        }
        List<FormRelationshipMapBean> autoSummaryMapBeans = this.cap4FormRelationActionManager.getValidFormRelationshipMapBeansByType(formBean, FormRelationEnums.ViewSelectType.auto_collect.getKey());
        List<FormRelationshipMapBean> autoIncreaseMapBeans = this.cap4FormRelationActionManager.getValidFormRelationshipMapBeansByType(formBean, FormRelationEnums.ViewSelectType.auto_increase_row.getKey());
        if (!isPre) {
            Iterator<FormRelationshipMapBean> iterator = autoIncreaseMapBeans.iterator();
            while (iterator.hasNext()) {
                FormRelationshipMapBean mapBean = iterator.next();
                if (mapBean.getTriggerOperationAdd() != null && mapBean.getTriggerOperationAdd().contains(formAuthViewBean.getId().toString()) || mapBean.getTriggerOperationUpdate() != null && mapBean.getTriggerOperationUpdate().contains(formAuthViewBean.getId().toString())) continue;
                iterator.remove();
            }
        }
        list.addAll(this.getFormSonAutoRelationButtons(subTable, autoSummaryMapBeans));
        list.addAll(this.getFormSonAutoRelationButtons(subTable, autoIncreaseMapBeans));
        return list;
    }

    private boolean getFormSonOperationAuth(FormAuthorizationTableBean authTableBean, CAPBusinessEnum.FormsonButtonType formsonButtonType) {
        boolean auth = false;
        switch (formsonButtonType) {
            case ADD: {
                auth = authTableBean.isAdd();
                break;
            }
            case COPY: {
                auth = authTableBean.isCopy();
                break;
            }
            case DELETE: {
                auth = authTableBean.isDelete();
                break;
            }
            case DELETE_ALL: {
                auth = authTableBean.isDeleteAll();
                break;
            }
            case IMPORT_EXCEL: {
                auth = authTableBean.isImportData();
                break;
            }
            case EXPORT_EXCEL: {
                auth = authTableBean.isExportData();
                break;
            }
        }
        return auth;
    }

    private List<Map<String, Object>> getFormSonAutoRelationButtons(FormTableBean formTableBean, List<FormRelationshipMapBean> formRelationshipMapBeans) {
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
        if (formRelationshipMapBeans != null) {
            for (FormRelationshipMapBean formRelationshipMapBean : formRelationshipMapBeans) {
                if (formRelationshipMapBean.getRefreshButton() == 0 || !formTableBean.getTableName().equals(formRelationshipMapBean.getButtonLocation())) continue;
                list.add(this.getAutoRelationButtonMap(formRelationshipMapBean));
            }
        }
        return list;
    }

    private Map<String, Object> getAutoRelationButtonMap(FormRelationshipMapBean formRelationshipMapBean) {
        HashMap<String, Object> data = new HashMap<String, Object>();
        if (formRelationshipMapBean.getRelationshipBean().getRelationType() == CAPBusinessEnum.FormsonButtonType.AUTO_INCREASE_ROW.getType()) {
            data.putAll(CAPBusinessEnum.FormsonButtonType.AUTO_INCREASE_ROW.exportMap());
        } else if (formRelationshipMapBean.getRelationshipBean().getRelationType() == CAPBusinessEnum.FormsonButtonType.AUTO_COLLECT.getType()) {
            data.putAll(CAPBusinessEnum.FormsonButtonType.AUTO_COLLECT.exportMap());
        }
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("relationShipId", String.valueOf(formRelationshipMapBean.getRelationshipBean().getId()));
        params.put("type", String.valueOf(formRelationshipMapBean.getRelationshipBean().getRelationType()));
        data.put("name", formRelationshipMapBean.getButtonName());
        data.put("params", params);
        return data;
    }

    private boolean needCalcInnerRelation(FormDataBean oldFormDataBean, FormDataBean formDataBean, FormFieldBean formFieldBean) {
        return this.checkFieldValueChanged(oldFormDataBean, formDataBean, formFieldBean);
    }

    private boolean checkFieldValueChanged(FormDataBean oldFormDataBean, FormDataBean formDataBean, FormFieldBean formFieldBean) {
        boolean changed;
        if (oldFormDataBean == null) {
            changed = true;
        } else {
            Object oldValue = oldFormDataBean.getFieldValue(formFieldBean.getName());
            Object value = formDataBean.getFieldValue(formFieldBean.getName());
            changed = oldValue == null ? value != null : (value == null ? true : !String.valueOf(oldValue).equals(String.valueOf(value)));
        }
        return changed;
    }

    private Map<String, Object> getCalcDataMap(FormBean formBean, FormDataMasterBean formDataMasterBean, FormAuthViewBean formAuthViewBean, Set<String> fillBackFields, Map<String, FormAuthViewFieldBean> apartAuthMap, Map<String, List<FormRelationshipMapBean>> manualFormRelationshipMapBeans) throws BusinessException {
        HashMap<String, Object> dataMap = new HashMap<String, Object>();
        if (fillBackFields.isEmpty()) {
            return dataMap;
        }
        Map<Long, FormDataSubBean> formDataSubBeanMaps = this.getFormDataSubBeanMap(formDataMasterBean);
        Iterator<String> it = fillBackFields.iterator();
        while (it.hasNext()) {
            FormDataMasterBean formDataBean;
            String key;
            String fieldName = key = it.next();
            if (key.indexOf("_") > 0) {
                String[] keys = key.split("_");
                fieldName = keys[0];
                formDataBean = (FormDataBean)formDataSubBeanMaps.get(Long.valueOf(keys[1]));
            } else {
                formDataBean = formDataMasterBean;
            }
            if (formDataBean == null) continue;
            FormFieldBean formFieldBean = formBean.getFieldBeanByName(fieldName);
            FormAuthViewFieldBean formAuthViewFieldBean = apartAuthMap.get(key) == null ? formAuthViewBean.getFormAuthorizationField(fieldName) : apartAuthMap.get(key);
            Map<String, String> authMap = CAPFormUtil.getAuthMap(formFieldBean, formAuthViewFieldBean, null, false);
            Map<String, Object> data = this.getCalcFieldDataMap((FormDataBean)formDataBean, formFieldBean, authMap, manualFormRelationshipMapBeans);
            dataMap.put(key, data);
        }
        return dataMap;
    }

    private Map<String, Object> getCalcFieldDataMap(FormDataBean formDataBean, FormFieldBean formFieldBean, Map<String, String> authMap, Map<String, List<FormRelationshipMapBean>> manualFormRelationshipMapBeans) throws BusinessException {
        Object value = formDataBean.getFieldValue(formFieldBean.getName());
        boolean isSub = formDataBean instanceof FormDataSubBean;
        FormDataSubBean formDataSubBean = isSub ? (FormDataSubBean)formDataBean : null;
        FormDataMasterBean formDataMasterBean = isSub ? formDataSubBean.getMasterData() : (FormDataMasterBean)formDataBean;
        Map<String, Object> dataInfo = CAPFormUtil.getDisplayValueMap(value, formFieldBean, authMap.get(AUTH));
        if (formFieldBean.isAttachment() && !Enums.FieldAccessType.hide.getKey().equals(authMap.get(AUTH))) {
            List<Map<String, String>> attachmentMaps = null;
            if (value != null) {
                List attachments = formDataMasterBean.getSessionAttachments(String.valueOf(value));
                attachmentMaps = CAPAttachmentUtil.buildAttachmentMaps(attachments, true);
            }
            dataInfo.put(ATTACHMENT_INFO, CAPAttachmentUtil.getAttachmentMap(formDataMasterBean.getId(), formFieldBean, String.valueOf(value == null ? Long.valueOf(UUIDLong.longUUID()) : value), attachmentMaps));
        }
        if (formFieldBean.isEnumField()) {
            dataInfo.put(ENUMS, CAPFormUtil.getFieldEnumJSON(formFieldBean, formDataMasterBean, (FormDataSubBean)(isSub ? formDataSubBean : null), false));
        }
        dataInfo.putAll(this.getCalcRelationAndTriggerDataMap(formDataMasterBean, formFieldBean, authMap, manualFormRelationshipMapBeans, formDataSubBean == null ? null : String.valueOf(formDataBean.getId())));
        return dataInfo;
    }

    private Map<String, Object> getCalcRelationAndTriggerDataMap(FormDataMasterBean formDataMasterBean, FormFieldBean formFieldBean, Map<String, String> authMap, Map<String, List<FormRelationshipMapBean>> manualFormRelationshipMapBeans, String recordId) throws BusinessException {
        String mapKey;
        Map capFormTriggerSourceRecordMap;
        HashMap<String, Object> dataInfo = new HashMap<String, Object>();
        List<FormRelationshipMapBean> formRelationshipMapBeans = manualFormRelationshipMapBeans.get(formFieldBean.getName());
        if (CollectionUtils.isNotEmpty(formRelationshipMapBeans)) {
            Map<String, String> relationData = CAPFormUtil.getRelationData(formRelationshipMapBeans, (Map<String, CAPFormRelationRecord>)formDataMasterBean.getRelationRecordMap(), recordId, formFieldBean.getName(), authMap);
            dataInfo.put(RELATION_DATA, relationData);
            dataInfo.put(RELATION_INFO, CAPFormUtil.getRelationInfoMaps(formRelationshipMapBeans));
        }
        if ((capFormTriggerSourceRecordMap = (Map)formDataMasterBean.getExtraMap().get("capFormTriggerSourceRecordMap")).containsKey(mapKey = formFieldBean.getName() + (recordId == null ? "" : "_" + recordId))) {
            Map<String, String> triggerData = CAPFormUtil.getTriggerDataJSON(capFormTriggerSourceRecordMap, formFieldBean, authMap, recordId);
            dataInfo.put(TRIGGER_DATA, triggerData);
        }
        return dataInfo;
    }

    private Map<String, Object> rebuildCalcDataMap(FormBean formBean, Map<String, Object> calcDataMap) {
        HashMap<String, Object> data = new HashMap<String, Object>();
        if (calcDataMap == null || calcDataMap.isEmpty()) {
            return data;
        }
        for (String key : calcDataMap.keySet()) {
            HashMap<String, Object> updateMap;
            FormFieldBean formFieldBean;
            if (key.indexOf(FORMSON) == 0) {
                HashMap authMap;
                HashMap tableMap = (HashMap)data.get(key);
                if (tableMap == null) {
                    tableMap = new HashMap();
                    data.put(key, tableMap);
                }
                if ((authMap = (HashMap)tableMap.get(AUTH)) == null) {
                    authMap = new HashMap();
                    tableMap.put(AUTH, authMap);
                }
                authMap.putAll((Map)calcDataMap.get(key));
                continue;
            }
            String fieldName = key;
            String recordId = null;
            if (key.contains("_")) {
                fieldName = key.split("_")[0];
                recordId = key.split("_")[1];
            }
            if ((formFieldBean = formBean.getFieldBeanByName(fieldName)) == null) continue;
            HashMap tableMap = (HashMap)data.get(formFieldBean.getOwnerTableName());
            if (tableMap == null) {
                tableMap = new HashMap();
            }
            if ((updateMap = (HashMap<String, Object>)tableMap.get(UPDATE)) == null) {
                updateMap = new HashMap<String, Object>();
            }
            if (formFieldBean.isMasterField()) {
                updateMap.put(fieldName, calcDataMap.get(fieldName));
            } else {
                HashMap<String, Object> recordFieldMap = (HashMap<String, Object>)updateMap.get(recordId);
                if (recordFieldMap == null) {
                    recordFieldMap = new HashMap<String, Object>();
                }
                recordFieldMap.put(fieldName, calcDataMap.get(key));
                updateMap.put(recordId, recordFieldMap);
            }
            tableMap.put(UPDATE, updateMap);
            data.put(formFieldBean.getOwnerTableName(), tableMap);
        }
        return data;
    }

    private Map<Long, FormDataSubBean> getFormDataSubBeanMap(FormDataMasterBean formDataMasterBean) {
        HashMap<Long, FormDataSubBean> formDataSubBeanMaps = new HashMap<Long, FormDataSubBean>();
        Map dataSubBeanMap = formDataMasterBean.getSubTables();
        Iterator it = dataSubBeanMap.keySet().iterator();
        while (it.hasNext()) {
            List formDataSubBeans = (List)dataSubBeanMap.get(it.next());
            for (FormDataSubBean formDataSubBean : formDataSubBeans) {
                formDataSubBeanMaps.put(formDataSubBean.getId(), formDataSubBean);
            }
        }
        return formDataSubBeanMaps;
    }

    private void mergeAddSubBeans2Result(FormBean formBean, FormDataMasterBean formDataMasterBean, FormAuthViewBean formAuthViewBean, Map<String, Map<String, Object>> tableName2DataMaps, Object tableName2AddObjects, Map<String, Object> tableCalcUpdateData, CAPBusinessEnum.SubBeanNewFrom newFrom) throws BusinessException {
        Map tableName2AddSubIds = (Map)tableName2AddObjects;
        if (tableName2AddSubIds == null || tableName2AddSubIds.isEmpty()) {
            return;
        }
        Map capFormRelationRecordMap = formDataMasterBean.getRelationRecordMap();
        Map<String, List<FormRelationshipMapBean>> manualFormRelationshipMapBeans = this.cap4FormRelationActionManager.getFormField4ManualRelationMapBeans(formBean);
        Map<String, List<FormFieldBean>> fieldBeanMap = CAPFormUtil.getTableName2FieldBeans(formBean, formAuthViewBean.getViewBean(formBean));
        for (String tableName : tableName2AddSubIds.keySet()) {
            Map<String, Object> tableData;
            Map tempCalcUpdateData;
            ArrayList<Map<String, Object>> datas = new ArrayList<Map<String, Object>>();
            Map map = tempCalcUpdateData = tableCalcUpdateData.get(tableName) == null ? null : (Map)((Map)tableCalcUpdateData.get(tableName)).get(UPDATE);
            List<FormFieldBean> subFields = fieldBeanMap.get(tableName);
            if (subFields == null) continue;
            boolean setMapFieldNull = CAPBusinessEnum.SubBeanNewFrom.FRONT_SUBMIT.equals((Object)newFrom) || CAPBusinessEnum.SubBeanNewFrom.IMPORT.equals((Object)newFrom);
            ArrayList<String> tableMapFields = new ArrayList<String>();
            for (FormFieldBean fieldBean : subFields) {
                if (!fieldBean.isMap()) continue;
                tableMapFields.add(fieldBean.getName());
            }
            for (Object object : (List)tableName2AddSubIds.get(tableName)) {
                Long subId;
                FormDataSubBean formDataSubBean;
                if (object instanceof FormDataSubBean) {
                    formDataSubBean = (FormDataSubBean)object;
                    subId = formDataSubBean.getId();
                } else {
                    subId = (Long)object;
                    formDataSubBean = formDataMasterBean.getFormDataSubBeanById(tableName, subId);
                }
                Map<String, Object> data = this.getSubDataMap(formDataMasterBean, formDataSubBean, formAuthViewBean, subFields, manualFormRelationshipMapBeans, newFrom);
                if (tempCalcUpdateData != null && tempCalcUpdateData.get(String.valueOf(subId)) != null) {
                    Map tempSubMap = (Map)tempCalcUpdateData.get(String.valueOf(subId));
                    for (String fieldName : tempSubMap.keySet()) {
                        if (data.get(fieldName) == null) {
                            data.put(fieldName, tempSubMap.get(fieldName));
                        } else {
                            ((Map)data.get(fieldName)).putAll((Map)tempSubMap.get(fieldName));
                        }
                        if (!tableMapFields.contains(fieldName) || !setMapFieldNull) continue;
                        Map fieldDataMap = (Map)data.get(fieldName);
                        fieldDataMap.putAll(CAPFormUtil.getDisplayValueMap(null, formBean.getFieldBeanByName(fieldName), fieldDataMap.get(AUTH)));
                    }
                    tempCalcUpdateData.remove(String.valueOf(subId));
                }
                ArrayList<Map> relationRecordMaps = new ArrayList<Map>();
                for (String fName : data.keySet()) {
                    String key;
                    if (fName.indexOf(FIELD) != 0 || capFormRelationRecordMap.get(key = fName + "_" + subId) == null) continue;
                    relationRecordMaps.add(((CAPFormRelationRecord)capFormRelationRecordMap.get(key)).exportToMap());
                }
                if (!relationRecordMaps.isEmpty()) {
                    data.put(RELATION_RECORDS, relationRecordMaps);
                }
                datas.add(data);
            }
            if (tempCalcUpdateData != null && tempCalcUpdateData.isEmpty()) {
                ((Map)tableCalcUpdateData.get(tableName)).remove(UPDATE);
            }
            if ((tableData = tableName2DataMaps.get(tableName)) == null) {
                tableData = new HashMap<String, Object>();
            }
            tableData.put(ADD, datas);
            tableName2DataMaps.put(tableName, tableData);
        }
    }

    private Map<String, Object> getSubDataMap(FormDataMasterBean formDataMasterBean, FormDataSubBean formDataSubBean, FormAuthViewBean formAuthViewBean, List<FormFieldBean> subFields, Map<String, List<FormRelationshipMapBean>> manualFormRelationshipMapBeans, CAPBusinessEnum.SubBeanNewFrom newFrom) throws BusinessException {
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("recordId", String.valueOf(formDataSubBean.getId()));
        for (FormFieldBean formFieldBean : subFields) {
            Map capFormTriggerSourceRecordMap;
            FormAuthViewFieldBean formAuthViewFieldBean = formAuthViewBean.getFormAuthorizationField(formFieldBean.getName());
            Object fieldValue = formDataSubBean.getFieldValue(formFieldBean.getName());
            if (formFieldBean.isMap() && (CAPBusinessEnum.SubBeanNewFrom.FRONT_SUBMIT.equals((Object)newFrom) || CAPBusinessEnum.SubBeanNewFrom.IMPORT.equals((Object)newFrom))) {
                fieldValue = null;
            }
            Map<String, Object> dataSubInfo = CAPFormUtil.getDisplayValueMap(fieldValue, formFieldBean, formAuthViewFieldBean);
            Map<String, String> auth = CAPFormUtil.getAuthMap(formFieldBean, formAuthViewFieldBean, null, false);
            List<FormRelationshipMapBean> formRelationshipMapBeans = manualFormRelationshipMapBeans.get(formFieldBean.getName());
            if (CollectionUtils.isNotEmpty(formRelationshipMapBeans)) {
                Map<String, String> relationData = CAPFormUtil.getRelationData(formRelationshipMapBeans, (Map<String, CAPFormRelationRecord>)formDataMasterBean.getRelationRecordMap(), (FormDataBean)formDataSubBean, formFieldBean.getName(), auth);
                dataSubInfo.put(RELATION_DATA, relationData);
                dataSubInfo.put(RELATION_INFO, CAPFormUtil.getRelationInfoMaps(formRelationshipMapBeans));
            }
            if ((capFormTriggerSourceRecordMap = (Map)formDataMasterBean.getExtraMap().get("capFormTriggerSourceRecordMap")).containsKey(formFieldBean.getName() + "_" + formDataSubBean.getId())) {
                Map<String, String> triggerData = CAPFormUtil.getTriggerDataJSON(capFormTriggerSourceRecordMap, formFieldBean, auth, formDataSubBean.getId().toString());
                dataSubInfo.put(TRIGGER_DATA, triggerData);
            } else {
                dataSubInfo.put(TRIGGER_DATA, new HashMap());
            }
            dataSubInfo.putAll(auth);
            if (formFieldBean.isAttachment()) {
                String subReference;
                List attachments = null;
                String string = subReference = fieldValue == null ? null : String.valueOf(fieldValue);
                if (subReference == null) {
                    subReference = String.valueOf(UUIDLong.longUUID());
                } else {
                    attachments = formDataMasterBean.getSessionAttachments(subReference);
                }
                Map<String, Object> attachmentInfo = CAPAttachmentUtil.getAttachmentMap(formDataMasterBean.getId(), formFieldBean, subReference, CAPAttachmentUtil.buildAttachmentMaps(attachments, true));
                dataSubInfo.put(ATTACHMENT_INFO, attachmentInfo);
            }
            if (formFieldBean.isEnumField()) {
                dataSubInfo.put(ENUMS, CAPFormUtil.getFieldEnumJSON(formFieldBean, formDataMasterBean, formDataSubBean, false));
            }
            data.put(formFieldBean.getName(), dataSubInfo);
        }
        return data;
    }

    private void mergeCalcData2Result(Map<String, Object> tableCalcUpdateData, Map<String, Map<String, Object>> tableName2DataMaps) {
        if (tableCalcUpdateData == null || tableCalcUpdateData.isEmpty()) {
            return;
        }
        for (String tableName : tableCalcUpdateData.keySet()) {
            Map calcTableMap = (Map)tableCalcUpdateData.get(tableName);
            if (calcTableMap.get(UPDATE) != null) {
                HashMap<String, Object> updateMap;
                Map calcUpdateMap = (Map)calcTableMap.get(UPDATE);
                Map<String, Object> tableMap = tableName2DataMaps.get(tableName);
                if (tableMap == null) {
                    tableMap = new HashMap<String, Object>();
                    tableName2DataMaps.put(tableName, tableMap);
                }
                if ((updateMap = (HashMap<String, Object>)tableMap.get(UPDATE)) == null) {
                    updateMap = new HashMap<String, Object>();
                    tableMap.put(UPDATE, updateMap);
                }
                this.mergeCalcFieldData2Result(calcUpdateMap, updateMap);
            }
            this.mergeCalcData2ResultBySingleKey(calcTableMap, tableName2DataMaps, tableName, TABLE_BUTTON);
            this.mergeCalcData2ResultBySingleKey(calcTableMap, tableName2DataMaps, tableName, TABLE_AUTH);
        }
        Iterator<String> it = tableName2DataMaps.keySet().iterator();
        while (it.hasNext()) {
            String tableName = it.next();
            if (!tableName2DataMaps.get(tableName).isEmpty()) continue;
            it.remove();
        }
    }

    private void mergeCalcData2ResultBySingleKey(Map<String, Object> calcTableMap, Map<String, Map<String, Object>> tableName2DataMaps, String tableName, String key) {
        if (calcTableMap.get(key) != null) {
            Map<String, Object> tableMap = tableName2DataMaps.get(tableName);
            if (tableMap == null) {
                tableMap = new HashMap<String, Object>();
                tableName2DataMaps.put(tableName, tableMap);
            }
            tableMap.put(key, calcTableMap.get(key));
        }
    }

    private void mergeCalcFieldData2Result(Map<String, Object> calcUpdateMap, Map<String, Object> updateMap) {
        for (String key : calcUpdateMap.keySet()) {
            if (key.indexOf(FIELD) == 0) {
                if (updateMap.get(key) == null) {
                    updateMap.put(key, calcUpdateMap.get(key));
                    continue;
                }
                ((Map)updateMap.get(key)).putAll((Map)calcUpdateMap.get(key));
                continue;
            }
            Map tempCalcMap = (Map)calcUpdateMap.get(key);
            HashMap<String, Object> tempUpdateMap = (HashMap<String, Object>)updateMap.get(key);
            if (tempCalcMap == null) continue;
            if (tempUpdateMap == null) {
                tempUpdateMap = new HashMap<String, Object>();
            }
            this.mergeCalcFieldData2Result(tempCalcMap, tempUpdateMap);
            updateMap.put(key, tempUpdateMap);
        }
    }

    private Map<String, Map<String, Boolean>> getCalcAllFieldChanges(FormBean formBean, Set<String> changeFields, Map<String, List<Long>> tableName2AddSubIds) {
        FormTableBean masterTableBean = formBean.getMasterTableBean();
        HashMap<String, Map<String, Boolean>> fieldChangeTags = new HashMap<String, Map<String, Boolean>>();
        HashMap<String, Boolean> masterChangeMap = new HashMap<String, Boolean>();
        if (changeFields != null) {
            for (String str : changeFields) {
                if (str.indexOf("_") > 0) {
                    String fieldName = str.split("_")[0];
                    FormFieldBean formFieldBean = formBean.getFieldBeanByName(fieldName);
                    HashMap<String, Boolean> tableChangeMap = (HashMap<String, Boolean>)fieldChangeTags.get(formFieldBean.getOwnerTableName());
                    if (tableChangeMap == null) {
                        tableChangeMap = new HashMap<String, Boolean>();
                        fieldChangeTags.put(formFieldBean.getOwnerTableName(), tableChangeMap);
                    }
                    tableChangeMap.put(str, true);
                    continue;
                }
                masterChangeMap.put(str, true);
            }
        }
        if (!masterChangeMap.isEmpty()) {
            fieldChangeTags.put(masterTableBean.getTableName(), masterChangeMap);
        }
        if (tableName2AddSubIds != null && !tableName2AddSubIds.isEmpty()) {
            for (String tableName : tableName2AddSubIds.keySet()) {
                HashMap<String, Boolean> tableChangeMap = (HashMap<String, Boolean>)fieldChangeTags.get(tableName);
                if (tableChangeMap == null) {
                    tableChangeMap = new HashMap<String, Boolean>();
                }
                FormTableBean subTableBean = formBean.getTableByTableName(tableName);
                List<Long> addIds = tableName2AddSubIds.get(tableName);
                for (FormFieldBean subField : subTableBean.getFields()) {
                    if (!subField.needCalculation()) continue;
                    for (Long addId : addIds) {
                        tableChangeMap.put(subField.getName() + "_" + addId, true);
                    }
                }
                if (tableChangeMap == null || tableChangeMap.isEmpty()) continue;
                fieldChangeTags.put(tableName, tableChangeMap);
            }
        }
        return fieldChangeTags;
    }

    private void execCalcAllSpecial(FormBean formBean, FormDataMasterBean cacheFormDataMasterBean, FormAuthViewBean formAuthViewBean, Map<String, List<Long>> tableName2AddSubIds, Set<String> fillBackFields) throws BusinessException {
        if (tableName2AddSubIds == null || tableName2AddSubIds.isEmpty()) {
            return;
        }
        for (String tName : tableName2AddSubIds.keySet()) {
            FormTableBean subTableBean = formBean.getTableByTableName(tName);
            List subFields = subTableBean.getFields();
            List<Long> addSubIds = tableName2AddSubIds.get(tName);
            for (Long id : addSubIds) {
                FormDataSubBean subRow = cacheFormDataMasterBean.getFormDataSubBeanById(tName, id);
                for (FormFieldBean subField : subFields) {
                    FormFieldBean toField;
                    if (fillBackFields.contains(subRow.generageFillbackKey(subField.getName()))) continue;
                    boolean calc = Strings.isNotEmpty((Collection)subField.getFormConditionList());
                    if (calc) {
                        this.cap4FormDataManager.calc4EditingForm(formBean, subField, cacheFormDataMasterBean, subRow, fillBackFields, formAuthViewBean, true);
                    }
                    if (calc || subField.getFormRelation() == null || subRow.getFieldValue(subField.getName()) != null || (toField = formBean.getFieldBeanByName(subField.getFormRelation().getToRelationAttr())) == null || !toField.isMasterField()) continue;
                    AppContext.putThreadContext((String)"ignoreFillMasterField", (Object)true);
                    this.cap4FormDataManager.calcAllWithFieldIn(formBean, toField, cacheFormDataMasterBean, subRow, fillBackFields, formAuthViewBean, true);
                    AppContext.removeThreadContext((String)"ignoreFillMasterField");
                }
            }
        }
    }

    @Override
    public void mergeFirstDelete2Result(FormDataMasterBean formDataMasterBean, Map<String, Map<String, Object>> tableName2DataMaps, Map<String, List<Long>> tableName2AddSubIds, Map<String, String> selectRecordIds, Map<String, Set<String>> tableName2DeleteIds) {
        for (String tableName : tableName2AddSubIds.keySet()) {
            List subBeans;
            if (selectRecordIds != null && Strings.isNotBlank((String)selectRecordIds.get(tableName)) || (subBeans = formDataMasterBean.getSubData(tableName)) == null || subBeans.get(0) == null || !((FormDataSubBean)subBeans.get(0)).isEmpty()) continue;
            Long firstId = ((FormDataSubBean)subBeans.get(0)).getId();
            HashSet<String> deleteIds = new HashSet<String>(1);
            deleteIds.add(firstId.toString());
            formDataMasterBean.removeSubData(tableName, firstId);
            if (tableName2DeleteIds != null) {
                if (tableName2DeleteIds.get(tableName) == null) {
                    tableName2DeleteIds.put(tableName, deleteIds);
                    continue;
                }
                tableName2DeleteIds.get(tableName).add(firstId.toString());
                continue;
            }
            Map<String, Object> tableData = tableName2DataMaps.get(tableName);
            if (tableData == null) {
                tableData = new HashMap<String, Object>();
            }
            tableData.put(DELETE, tableData.get(DELETE) == null ? deleteIds : Boolean.valueOf(((Set)tableData.get(DELETE)).add(firstId.toString())));
            tableName2DataMaps.put(tableName, tableData);
        }
    }

    public void setCap4FormDataManager(CAP4FormDataManager cap4FormDataManager) {
        this.cap4FormDataManager = cap4FormDataManager;
    }

    public void setCap4FormRelationActionManager(CAP4FormRelationActionManager cap4FormRelationActionManager) {
        this.cap4FormRelationActionManager = cap4FormRelationActionManager;
    }

    public void setCap4FormManager(CAP4FormManager cap4FormManager) {
        this.cap4FormManager = cap4FormManager;
    }
}

